/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.source.SourceSection;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;

@CoreClass(name="Dir")
public abstract class DirNodes {

    @CoreMethod(names={"pwd", "getwd"}, onSingleton=true)
    public static abstract class PwdNode
    extends CoreMethodNode {
        public PwdNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PwdNode(PwdNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString pwd() {
            PwdNode.notDesignedForCompilation();
            return this.getContext().makeString(this.getContext().getRuntime().getCurrentDirectory());
        }
    }

    @CoreMethod(names={"mkdir"}, needsSelf=false, onSingleton=true, required=1)
    public static abstract class MkdirNode
    extends CoreMethodNode {
        public MkdirNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MkdirNode(MkdirNode prev) {
            super(prev);
        }

        @Specialization
        public int mkdir(RubyString path2) {
            MkdirNode.notDesignedForCompilation();
            if (!new File(path2.toString()).mkdir()) {
                throw new UnsupportedOperationException();
            }
            return 0;
        }
    }

    @CoreMethod(names={"glob", "[]"}, onSingleton=true, required=1)
    public static abstract class GlobNode
    extends CoreMethodNode {
        public GlobNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public GlobNode(GlobNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray glob(RubyString glob2) {
            return GlobNode.glob(this.getContext(), glob2.toString());
        }

        @CompilerDirectives.TruffleBoundary
        private static RubyArray glob(final RubyContext context, String glob2) {
            int prefixLength;
            String absoluteGlob = !glob2.startsWith("/") ? new File(".", glob2).getAbsolutePath() : glob2;
            int firstStar = absoluteGlob.indexOf(42);
            assert (firstStar >= 0);
            for (prefixLength = firstStar; prefixLength > 0 && absoluteGlob.charAt(prefixLength) == File.separatorChar; --prefixLength) {
            }
            String prefix = absoluteGlob.substring(0, prefixLength - 1);
            final PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + absoluteGlob.substring(prefixLength).replace('\\', '/'));
            final RubyArray array = new RubyArray(context.getCoreLibrary().getArrayClass());
            try {
                Files.walkFileTree(FileSystems.getDefault().getPath(prefix, new String[0]), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file2, BasicFileAttributes attrs) throws IOException {
                        if (matcher.matches(file2)) {
                            array.slowPush(context.makeString(file2.toString()));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return array;
        }
    }

    @CoreMethod(names={"exist?", "exists?"}, onSingleton=true, optional=1)
    public static abstract class ExistsNode
    extends CoreMethodNode {
        public ExistsNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ExistsNode(ExistsNode prev) {
            super(prev);
        }

        @Specialization
        public boolean exists(RubyString path2) {
            ExistsNode.notDesignedForCompilation();
            return new File(path2.toString()).isDirectory();
        }
    }

    @CoreMethod(names={"delete", "rmdir", "unlink"}, onSingleton=true, optional=1)
    public static abstract class DeleteNode
    extends CoreMethodNode {
        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DeleteNode(DeleteNode prev) {
            super(prev);
        }

        @Specialization
        public int delete(RubyString path2) {
            DeleteNode.notDesignedForCompilation();
            File dir = new File(path2.toString());
            if (!dir.isDirectory()) {
                throw new UnsupportedOperationException(path2.toString());
            }
            if (!dir.delete()) {
                throw new UnsupportedOperationException();
            }
            return 0;
        }
    }

    @CoreMethod(names={"chdir"}, onSingleton=true, needsBlock=true, required=1)
    public static abstract class ChdirNode
    extends YieldingCoreMethodNode {
        public ChdirNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ChdirNode(ChdirNode prev) {
            super(prev);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public Object chdir(VirtualFrame frame, RubyString path2, RubyProc block) {
            ChdirNode.notDesignedForCompilation();
            RubyContext context = this.getContext();
            String previous = context.getRuntime().getCurrentDirectory();
            context.getRuntime().setCurrentDirectory(path2.toString());
            if (block != null) {
                try {
                    Object object = this.yield(frame, block, path2);
                    return object;
                }
                finally {
                    context.getRuntime().setCurrentDirectory(previous);
                }
            }
            return 0;
        }
    }
}

