/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.CoreSourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.control.SequenceNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.FixnumLowerNode;
import org.jruby.truffle.nodes.methods.ExceptionTranslatingNode;
import org.jruby.truffle.nodes.methods.arguments.CheckArityNode;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.methods.arguments.ReadAllArgumentsNode;
import org.jruby.truffle.nodes.methods.arguments.ReadBlockNode;
import org.jruby.truffle.nodes.methods.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.objects.SelfNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyConstant;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.TruffleFatalException;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.methods.Arity;
import org.jruby.truffle.runtime.methods.InternalMethod;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.util.ArrayUtils;

public abstract class CoreMethodNodeManager {
    public static void addCoreMethodNodes(RubyClass rubyObjectClass, List<? extends NodeFactory<? extends RubyNode>> nodeFactories) {
        for (NodeFactory<? extends RubyNode> nodeFactory : nodeFactories) {
            GeneratedBy generatedBy = nodeFactory.getClass().getAnnotation(GeneratedBy.class);
            Class nodeClass = generatedBy.value();
            CoreClass classAnnotation = nodeClass.getEnclosingClass().getAnnotation(CoreClass.class);
            CoreMethod methodAnnotation = nodeClass.getAnnotation(CoreMethod.class);
            if (methodAnnotation == null) continue;
            MethodDetails details = new MethodDetails(classAnnotation, methodAnnotation, nodeFactory);
            CoreMethodNodeManager.addMethod(rubyObjectClass, details);
        }
    }

    private static void addMethod(RubyClass rubyObjectClass, MethodDetails methodDetails) {
        RubyModule module;
        assert (rubyObjectClass != null);
        assert (methodDetails != null);
        RubyContext context = rubyObjectClass.getContext();
        if (methodDetails.getClassAnnotation().name().equals("main")) {
            module = context.getCoreLibrary().getMainObject().getSingletonClass(null);
        } else {
            module = rubyObjectClass;
            for (String moduleName : methodDetails.getClassAnnotation().name().split("::")) {
                RubyConstant constant = ModuleOperations.lookupConstant(context, LexicalScope.NONE, module, moduleName);
                if (constant == null) {
                    throw new RuntimeException(String.format("Module %s not found when adding core library", moduleName));
                }
                module = (RubyModule)constant.getValue();
            }
        }
        assert (module != null) : methodDetails.getClassAnnotation().name();
        CoreMethod anno = methodDetails.getMethodAnnotation();
        List<String> names2 = Arrays.asList(anno.names());
        assert (names2.size() >= 1);
        Visibility visibility = anno.visibility();
        if (anno.isModuleFunction()) {
            if (visibility != Visibility.PUBLIC) {
                System.err.println("WARNING: visibility ignored when isModuleFunction in " + methodDetails.getIndicativeName());
            }
            if (anno.onSingleton()) {
                System.err.println("WARNING: Either onSingleton or isModuleFunction for " + methodDetails.getIndicativeName());
            }
        }
        boolean needsSelf = !anno.isModuleFunction() && !anno.onSingleton() && anno.needsSelf();
        RubyRootNode rootNode = CoreMethodNodeManager.makeGenericMethod(context, methodDetails, needsSelf);
        if (anno.isModuleFunction()) {
            CoreMethodNodeManager.addMethod(module, rootNode, names2, Visibility.PRIVATE);
            CoreMethodNodeManager.addMethod(module.getSingletonClass(null), rootNode, names2, Visibility.PUBLIC);
        } else if (anno.onSingleton()) {
            CoreMethodNodeManager.addMethod(module.getSingletonClass(null), rootNode, names2, visibility);
        } else {
            CoreMethodNodeManager.addMethod(module, rootNode, names2, visibility);
        }
    }

    private static void addMethod(RubyModule module, RubyRootNode rootNode, List<String> names2, Visibility visibility) {
        for (String name2 : names2) {
            RubyRootNode rootNodeCopy = (RubyRootNode)NodeUtil.cloneNode((Node)rootNode);
            CoreMethodNode coreMethodNode = (CoreMethodNode)((Object)NodeUtil.findFirstNodeInstance((Node)rootNodeCopy, CoreMethodNode.class));
            if (coreMethodNode != null) {
                coreMethodNode.setName(name2);
            }
            InternalMethod method = new InternalMethod(rootNodeCopy.getSharedMethodInfo(), name2, module, visibility, false, (CallTarget)Truffle.getRuntime().createCallTarget((RootNode)rootNodeCopy), null);
            module.addMethod(null, method.withVisibility(visibility).withNewName(name2));
        }
    }

    private static RubyRootNode makeGenericMethod(RubyContext context, MethodDetails methodDetails, boolean needsSelf) {
        CoreSourceSection sourceSection = new CoreSourceSection(methodDetails.getClassAnnotation().name(), methodDetails.getMethodAnnotation().names()[0]);
        SharedMethodInfo sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, null, methodDetails.getIndicativeName(), false, null, true);
        int required = methodDetails.getMethodAnnotation().required();
        int optional = methodDetails.getMethodAnnotation().argumentsAsArray() ? 0 : methodDetails.getMethodAnnotation().optional();
        Arity arity2 = new Arity(required, optional, methodDetails.getMethodAnnotation().argumentsAsArray(), false);
        ArrayList<RubyNode> argumentsNodes = new ArrayList<RubyNode>();
        if (needsSelf) {
            RubyNode readSelfNode = new SelfNode(context, (SourceSection)sourceSection);
            if (methodDetails.getMethodAnnotation().lowerFixnumSelf()) {
                readSelfNode = new FixnumLowerNode(readSelfNode);
            }
            argumentsNodes.add(readSelfNode);
        }
        if (methodDetails.getMethodAnnotation().argumentsAsArray()) {
            argumentsNodes.add(new ReadAllArgumentsNode(context, (SourceSection)sourceSection));
        } else {
            for (int n = 0; n < arity2.getRequired() + arity2.getOptional(); ++n) {
                RubyNode readArgumentNode = new ReadPreArgumentNode(context, (SourceSection)sourceSection, n, MissingArgumentBehaviour.UNDEFINED);
                if (ArrayUtils.contains(methodDetails.getMethodAnnotation().lowerFixnumParameters(), n)) {
                    readArgumentNode = new FixnumLowerNode(readArgumentNode);
                }
                argumentsNodes.add(readArgumentNode);
            }
        }
        if (methodDetails.getMethodAnnotation().needsBlock()) {
            argumentsNodes.add(new ReadBlockNode(context, (SourceSection)sourceSection, UndefinedPlaceholder.INSTANCE));
        }
        RubyNode methodNode = null;
        NodeFactory<? extends RubyNode> nodeFactory = methodDetails.getNodeFactory();
        List signatures = nodeFactory.getNodeSignatures();
        assert (!signatures.isEmpty());
        for (List signature : signatures) {
            if (signature.size() >= 1 && signature.get(0) != RubyContext.class && signature.get(0) != nodeFactory.getNodeClass()) {
                throw new TruffleFatalException("Copy constructor with wrong type for previous in " + nodeFactory.getNodeClass() + " : " + signature.get(0), null);
            }
            if (signature.size() >= 3 && signature.get(2) == RubyNode[].class) {
                methodNode = (RubyNode)((Object)methodDetails.getNodeFactory().createNode(new Object[]{context, sourceSection, argumentsNodes.toArray(new RubyNode[argumentsNodes.size()])}));
                continue;
            }
            Object[] args2 = new Object[2 + argumentsNodes.size()];
            args2[0] = context;
            args2[1] = sourceSection;
            System.arraycopy(argumentsNodes.toArray(new RubyNode[argumentsNodes.size()]), 0, args2, 2, argumentsNodes.size());
            methodNode = (RubyNode)((Object)methodDetails.getNodeFactory().createNode(args2));
        }
        CheckArityNode checkArity = new CheckArityNode(context, (SourceSection)sourceSection, arity2);
        RubyNode block = SequenceNode.sequence(context, (SourceSection)sourceSection, checkArity, methodNode);
        ExceptionTranslatingNode exceptionTranslatingNode = new ExceptionTranslatingNode(context, (SourceSection)sourceSection, block, methodDetails.getMethodAnnotation().unsupportedOperationBehavior());
        return new RubyRootNode(context, (SourceSection)sourceSection, null, sharedMethodInfo, exceptionTranslatingNode);
    }

    public static class MethodDetails {
        private final CoreClass classAnnotation;
        private final CoreMethod methodAnnotation;
        private final NodeFactory<? extends RubyNode> nodeFactory;

        public MethodDetails(CoreClass classAnnotation, CoreMethod methodAnnotation, NodeFactory<? extends RubyNode> nodeFactory) {
            assert (classAnnotation != null);
            assert (methodAnnotation != null);
            assert (nodeFactory != null);
            this.classAnnotation = classAnnotation;
            this.methodAnnotation = methodAnnotation;
            this.nodeFactory = nodeFactory;
        }

        public CoreClass getClassAnnotation() {
            return this.classAnnotation;
        }

        public CoreMethod getMethodAnnotation() {
            return this.methodAnnotation;
        }

        public NodeFactory<? extends RubyNode> getNodeFactory() {
            return this.nodeFactory;
        }

        public String getIndicativeName() {
            return this.classAnnotation.name() + "#" + this.methodAnnotation.names()[0] + "(core)";
        }
    }
}

