/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.CreateCast;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.RubyCallNode;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.core.BinaryCoreMethodNode;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.UnaryCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.ObjectIDOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.util.ArrayUtils;
import org.jruby.util.cli.Options;

@CoreClass(name="BasicObject")
public abstract class BasicObjectNodes {

    @CoreMethod(names={"__send__"}, needsBlock=true, required=1, argumentsAsArray=true)
    public static abstract class SendNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode dispatchNode;

        public SendNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatchNode = DispatchHeadNodeFactory.createMethodCall(context, true, (Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_INDIRECT.load(), MissingBehavior.CALL_METHOD_MISSING);
            if (((Boolean)Options.TRUFFLE_DISPATCH_METAPROGRAMMING_ALWAYS_UNCACHED.load()).booleanValue()) {
                this.dispatchNode.forceUncached();
            }
        }

        public SendNode(SendNode prev) {
            super(prev);
            this.dispatchNode = prev.dispatchNode;
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self2, Object[] args2, UndefinedPlaceholder block) {
            return this.send(frame, self2, args2, (RubyProc)null);
        }

        @Specialization
        public Object send(VirtualFrame frame, Object self2, Object[] args2, RubyProc block) {
            Object name2 = args2[0];
            Object[] sendArgs = ArrayUtils.extractRange(args2, 1, args2.length);
            return this.dispatchNode.call(frame, self2, name2, block, sendArgs);
        }
    }

    @CoreMethod(names={"method_missing"}, needsBlock=true, argumentsAsArray=true, visibility=Visibility.PRIVATE)
    public static abstract class MethodMissingNode
    extends CoreMethodNode {
        public MethodMissingNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MethodMissingNode(MethodMissingNode prev) {
            super(prev);
        }

        @Specialization
        public Object methodMissing(Object self2, Object[] args2, UndefinedPlaceholder block) {
            MethodMissingNode.notDesignedForCompilation();
            return this.methodMissing(self2, args2, (RubyProc)null);
        }

        @Specialization
        public Object methodMissing(Object self2, Object[] args2, RubyProc block) {
            MethodMissingNode.notDesignedForCompilation();
            RubySymbol name2 = (RubySymbol)args2[0];
            Object[] sentArgs = ArrayUtils.extractRange(args2, 1, args2.length);
            return this.methodMissing(self2, name2, sentArgs, block);
        }

        private Object methodMissing(Object self2, RubySymbol name2, Object[] args2, RubyProc block) {
            if (this.lastCallWasVCall()) {
                throw new RaiseException(this.getContext().getCoreLibrary().nameErrorUndefinedLocalVariableOrMethod(name2.toString(), this.getContext().getCoreLibrary().getLogicalClass(self2).getName(), this));
            }
            throw new RaiseException(this.getContext().getCoreLibrary().noMethodError(name2.toString(), this.getContext().getCoreLibrary().getLogicalClass(self2).getName(), this));
        }

        private boolean lastCallWasVCall() {
            RubyCallNode callNode = (RubyCallNode)((Object)NodeUtil.findParent((Node)Truffle.getRuntime().getCallerFrame().getCallNode(), RubyCallNode.class));
            if (callNode == null) {
                return false;
            }
            return callNode.isVCall();
        }
    }

    @CoreMethod(names={"instance_eval"}, needsBlock=true, optional=1)
    public static abstract class InstanceEvalNode
    extends CoreMethodNode {
        @Node.Child
        private YieldDispatchHeadNode yield;

        public InstanceEvalNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.yield = new YieldDispatchHeadNode(context);
        }

        public InstanceEvalNode(InstanceEvalNode prev) {
            super(prev);
            this.yield = prev.yield;
        }

        @Specialization
        public Object instanceEval(VirtualFrame frame, Object receiver2, RubyString string2, UndefinedPlaceholder block) {
            InstanceEvalNode.notDesignedForCompilation();
            return this.getContext().eval(string2.getBytes(), receiver2, (RubyNode)this);
        }

        @Specialization
        public Object instanceEval(VirtualFrame frame, Object receiver2, UndefinedPlaceholder string2, RubyProc block) {
            InstanceEvalNode.notDesignedForCompilation();
            return this.yield.dispatchWithModifiedSelf(frame, block, receiver2, new Object[0]);
        }
    }

    @CoreMethod(names={"initialize"}, needsSelf=false, visibility=Visibility.PRIVATE)
    public static abstract class InitializeNode
    extends CoreMethodNode {
        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
        }

        @Specialization
        public RubyNilClass initialize() {
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"equal?", "=="}, required=1)
    public static abstract class ReferenceEqualNode
    extends BinaryCoreMethodNode {
        public ReferenceEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReferenceEqualNode(ReferenceEqualNode prev) {
            super(prev);
        }

        protected abstract boolean executeReferenceEqual(VirtualFrame var1, Object var2, Object var3);

        @Specialization
        public boolean equal(boolean a, boolean b2) {
            return a == b2;
        }

        @Specialization
        public boolean equal(int a, int b2) {
            return a == b2;
        }

        @Specialization
        public boolean equal(long a, long b2) {
            return a == b2;
        }

        @Specialization
        public boolean equal(double a, double b2) {
            return a == b2;
        }

        @Specialization
        public boolean equal(RubyBasicObject a, RubyBasicObject b2) {
            return a == b2;
        }

        @Specialization(guards={"isNotRubyBasicObject(left)", "isNotRubyBasicObject(right)", "notSameClass"})
        public boolean equal(Object a, Object b2) {
            return false;
        }

        @Specialization(guards={"isNotRubyBasicObject(left)"})
        public boolean equal(Object a, RubyBasicObject b2) {
            return false;
        }

        @Specialization(guards={"isNotRubyBasicObject(right)"})
        public boolean equal(RubyBasicObject a, Object b2) {
            return false;
        }

        protected boolean isNotRubyBasicObject(Object value2) {
            return !(value2 instanceof RubyBasicObject);
        }

        protected boolean notSameClass(Object a, Object b2) {
            return a.getClass() != b2.getClass();
        }
    }

    @CoreMethod(names={"__id__"})
    public static abstract class IDNode
    extends CoreMethodNode {
        public IDNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IDNode(IDNode prev) {
            super(prev);
        }

        public abstract Object executeObjectID(VirtualFrame var1, Object var2);

        @Specialization
        public int objectID(RubyNilClass nil) {
            return 4;
        }

        @Specialization(guards={"isTrue"})
        public int objectIDTrue(boolean value2) {
            return 2;
        }

        @Specialization(guards={"!isTrue"})
        public int objectIDFalse(boolean value2) {
            return 0;
        }

        @Specialization
        public long objectID(int value2) {
            return ObjectIDOperations.smallFixnumToID(value2);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        public long objectIDSmallFixnumOverflow(long value2) {
            return ObjectIDOperations.smallFixnumToIDOverflow(value2);
        }

        @Specialization
        public Object objectID(long value2) {
            if (this.isSmallFixnum(value2)) {
                return ObjectIDOperations.smallFixnumToID(value2);
            }
            return ObjectIDOperations.largeFixnumToID(this.getContext(), value2);
        }

        @Specialization
        public RubyBignum objectID(double value2) {
            return ObjectIDOperations.floatToID(this.getContext(), value2);
        }

        @Specialization
        public long objectID(RubyBasicObject object) {
            return object.getObjectID();
        }

        protected boolean isSmallFixnum(long fixnum) {
            return ObjectIDOperations.isSmallFixnum(fixnum);
        }
    }

    @CoreMethod(names={"!="}, required=1)
    public static abstract class NotEqualNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode equalNode;

        public NotEqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public NotEqualNode(NotEqualNode prev) {
            super(prev);
            this.equalNode = prev.equalNode;
        }

        @Specialization
        public boolean equal(VirtualFrame frame, Object a, Object b2) {
            return !this.equalNode.callBoolean(frame, a, "==", null, b2);
        }
    }

    @CoreMethod(names={"!"})
    public static abstract class NotNode
    extends UnaryCoreMethodNode {
        public NotNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public NotNode(NotNode prev) {
            super(prev);
        }

        @CreateCast(value={"operand"})
        public RubyNode createCast(RubyNode operand) {
            return BooleanCastNodeFactory.create(this.getContext(), this.getSourceSection(), operand);
        }

        @Specialization
        public boolean not(boolean value2) {
            return !value2;
        }
    }
}

