/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.util.Arrays;
import java.util.List;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.nodes.core.ArrayNodes;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;

@GeneratedBy(value=ArrayNodes.class)
public final class ArrayNodesFactory {
    public static List<NodeFactory<? extends CoreMethodNode>> getFactories() {
        return Arrays.asList(AddNodeFactory.getInstance(), SubNodeFactory.getInstance(), MulNodeFactory.getInstance(), UnionNodeFactory.getInstance(), EqualNodeFactory.getInstance(), AtNodeFactory.getInstance(), IndexNodeFactory.getInstance(), IndexSetNodeFactory.getInstance(), AnyNodeFactory.getInstance(), ClearNodeFactory.getInstance(), CompactNodeFactory.getInstance(), ConcatNodeFactory.getInstance(), DeleteNodeFactory.getInstance(), DeleteAtNodeFactory.getInstance(), EachNodeFactory.getInstance(), EachWithIndexNodeFactory.getInstance(), EmptyNodeFactory.getInstance(), FindNodeFactory.getInstance(), FirstNodeFactory.getInstance(), FlattenNodeFactory.getInstance(), HashNodeFactory.getInstance(), IncludeNodeFactory.getInstance(), InitializeNodeFactory.getInstance(), InitializeCopyNodeFactory.getInstance(), InjectNodeFactory.getInstance(), InsertNodeFactory.getInstance(), InspectNodeFactory.getInstance(), JoinNodeFactory.getInstance(), LastNodeFactory.getInstance(), MapNodeFactory.getInstance(), MapInPlaceNodeFactory.getInstance(), MaxNodeFactory.getInstance(), MaxBlockNodeFactory.getInstance(), MinNodeFactory.getInstance(), MinBlockNodeFactory.getInstance(), PackNodeFactory.getInstance(), PermutationNodeFactory.getInstance(), PopNodeFactory.getInstance(), ProductNodeFactory.getInstance(), PushNodeFactory.getInstance(), PushOneNodeFactory.getInstance(), RejectNodeFactory.getInstance(), RejectInPlaceNodeFactory.getInstance(), ReplaceNodeFactory.getInstance(), SelectNodeFactory.getInstance(), ShiftNodeFactory.getInstance(), SizeNodeFactory.getInstance(), SortNodeFactory.getInstance(), SortBangNodeFactory.getInstance(), ToANodeFactory.getInstance(), UniqNodeFactory.getInstance(), UnshiftNodeFactory.getInstance(), ZipNodeFactory.getInstance());
    }

    @GeneratedBy(value=ArrayNodes.ZipNode.class)
    public static final class ZipNodeFactory
    extends NodeFactoryBase<ArrayNodes.ZipNode> {
        private static ZipNodeFactory zipNodeFactoryInstance;

        private ZipNodeFactory() {
            super(ArrayNodes.ZipNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ZipNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ZipNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ZipNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ZipUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.ZipNode> getInstance() {
            if (zipNodeFactoryInstance == null) {
                zipNodeFactoryInstance = new ZipNodeFactory();
            }
            return zipNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ZipPolymorphicNode
        extends ZipBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ZipPolymorphicNode(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ZipRubyArray1Node
        extends ZipBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZipRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ZipRubyArray1Node(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isObject(arguments0Value) && ArrayGuards.isOtherObject(arguments0Value, arguments1Value)) {
                    return super.zipObjectObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, isOtherObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyArray arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast) && ArrayGuards.isOtherObject(arguments0ValueCast, arguments1ValueCast)) {
                        return super.zipObjectObject(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ZipNode create0(ArrayNodes.ZipNode current2) {
                return new ZipRubyArray1Node((ZipBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ZipRubyArray0Node
        extends ZipBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZipRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ZipRubyArray0Node(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isObject(arguments0Value) && ArrayGuards.isOtherIntegerFixnum(arguments0Value, arguments1Value)) {
                    return super.zipObjectIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, isOtherIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyArray arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast) && ArrayGuards.isOtherIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.zipObjectIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ZipNode create0(ArrayNodes.ZipNode current2) {
                return new ZipRubyArray0Node((ZipBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ZipUninitializedNode
        extends ZipBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ZipUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ZipUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ZipUninitializedNode(ZipBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ZipBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ZipBaseNode rootNode = (ZipBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ZipBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ZipNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ZipUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.ZipNode.class)
        private static abstract class ZipBaseNode
        extends ArrayNodes.ZipNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ZipBaseNode next0;

            ZipBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ZipBaseNode(ZipBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ZipBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ZipBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ZipUninitializedNode(this);
                    ((ZipUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ZipBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ZipBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ZipBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ZipUninitializedNode(this), (Node)new ZipPolymorphicNode(this), (DSLNode)((ZipBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ZipBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyArray arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        if (ArrayGuards.isOtherIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (ZipBaseNode)ZipRubyArray0Node.create0(this);
                        }
                        if (ArrayGuards.isOtherObject(arguments0ValueCast, arguments1ValueCast)) {
                            return (ZipBaseNode)ZipRubyArray1Node.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ZipBaseNode otherCast = (ZipBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ZipBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
    public static final class UnshiftNodeFactory
    extends NodeFactoryBase<ArrayNodes.UnshiftNode> {
        private static UnshiftNodeFactory unshiftNodeFactoryInstance;

        private UnshiftNodeFactory() {
            super(ArrayNodes.UnshiftNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.UnshiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UnshiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.UnshiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UnshiftUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.UnshiftNode> getInstance() {
            if (unshiftNodeFactoryInstance == null) {
                unshiftNodeFactoryInstance = new UnshiftNodeFactory();
            }
            return unshiftNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UnshiftPolymorphicNode
        extends UnshiftBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            UnshiftPolymorphicNode(UnshiftBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UnshiftRubyArrayNode
        extends UnshiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnshiftRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            UnshiftRubyArrayNode(UnshiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                return super.unshift(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    return super.unshift(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.UnshiftNode create0(ArrayNodes.UnshiftNode current2) {
                return new UnshiftRubyArrayNode((UnshiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UnshiftUninitializedNode
        extends UnshiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UnshiftUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UnshiftUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UnshiftUninitializedNode(UnshiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                UnshiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UnshiftBaseNode rootNode = (UnshiftBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UnshiftBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.UnshiftNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UnshiftUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.UnshiftNode.class)
        private static abstract class UnshiftBaseNode
        extends ArrayNodes.UnshiftNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UnshiftBaseNode next0;

            UnshiftBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UnshiftBaseNode(UnshiftBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                UnshiftBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UnshiftBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new UnshiftUninitializedNode(this);
                    ((UnshiftUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UnshiftBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = UnshiftBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (UnshiftBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UnshiftUninitializedNode(this), (Node)new UnshiftPolymorphicNode(this), (DSLNode)((UnshiftBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UnshiftBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    return (UnshiftBaseNode)UnshiftRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    UnshiftBaseNode otherCast = (UnshiftBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (UnshiftBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.UniqNode.class)
    public static final class UniqNodeFactory
    extends NodeFactoryBase<ArrayNodes.UniqNode> {
        private static UniqNodeFactory uniqNodeFactoryInstance;

        private UniqNodeFactory() {
            super(ArrayNodes.UniqNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.UniqNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return UniqNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.UniqNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return UniqUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.UniqNode> getInstance() {
            if (uniqNodeFactoryInstance == null) {
                uniqNodeFactoryInstance = new UniqNodeFactory();
            }
            return uniqNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.UniqNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class UniqPolymorphicNode
        extends UniqBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            UniqPolymorphicNode(UniqBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.UniqNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class UniqRubyArrayNode
        extends UniqBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UniqRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            UniqRubyArrayNode(UniqBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.uniq(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.uniq(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.UniqNode create0(ArrayNodes.UniqNode current2) {
                return new UniqRubyArrayNode((UniqBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.UniqNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class UniqUninitializedNode
        extends UniqBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(UniqUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            UniqUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            UniqUninitializedNode(UniqBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                UniqBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    UniqBaseNode rootNode = (UniqBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((UniqBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.UniqNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new UniqUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.UniqNode.class)
        private static abstract class UniqBaseNode
        extends ArrayNodes.UniqNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected UniqBaseNode next0;

            UniqBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            UniqBaseNode(UniqBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                UniqBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                UniqBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new UniqUninitializedNode(this);
                    ((UniqUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (UniqBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = UniqBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (UniqBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new UniqUninitializedNode(this), (Node)new UniqPolymorphicNode(this), (DSLNode)((UniqBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final UniqBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (UniqBaseNode)UniqRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((UniqBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (UniqBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ToANode.class)
    public static final class ToANodeFactory
    extends NodeFactoryBase<ArrayNodes.ToANode> {
        private static ToANodeFactory toANodeFactoryInstance;

        private ToANodeFactory() {
            super(ArrayNodes.ToANode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ToANode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ToANodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ToANode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ToAUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.ToANode> getInstance() {
            if (toANodeFactoryInstance == null) {
                toANodeFactoryInstance = new ToANodeFactory();
            }
            return toANodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ToAPolymorphicNode
        extends ToABaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ToAPolymorphicNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ToARubyArrayNode
        extends ToABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToARubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            ToARubyArrayNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.toA(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.toA(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.ToANode create0(ArrayNodes.ToANode current2) {
                return new ToARubyArrayNode((ToABaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ToANode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ToAUninitializedNode
        extends ToABaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ToAUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ToAUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ToAUninitializedNode(ToABaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ToABaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ToABaseNode rootNode = (ToABaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ToABaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.ToANode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ToAUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.ToANode.class)
        private static abstract class ToABaseNode
        extends ArrayNodes.ToANode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ToABaseNode next0;

            ToABaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ToABaseNode(ToABaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ToABaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ToABaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ToAUninitializedNode(this);
                    ((ToAUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ToABaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ToABaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ToABaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ToAUninitializedNode(this), (Node)new ToAPolymorphicNode(this), (DSLNode)((ToABaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ToABaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (ToABaseNode)ToARubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ToABaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ToABaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SortBangNode.class)
    public static final class SortBangNodeFactory
    extends NodeFactoryBase<ArrayNodes.SortBangNode> {
        private static SortBangNodeFactory sortBangNodeFactoryInstance;

        private SortBangNodeFactory() {
            super(ArrayNodes.SortBangNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SortBangNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SortBangNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.SortBangNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SortBangUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.SortBangNode> getInstance() {
            if (sortBangNodeFactoryInstance == null) {
                sortBangNodeFactoryInstance = new SortBangNodeFactory();
            }
            return sortBangNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.SortBangNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SortBangPolymorphicNode
        extends SortBangBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SortBangPolymorphicNode(SortBangBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortBangNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortBangRubyArrayNode
        extends SortBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortBangRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            SortBangRubyArrayNode(SortBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.sort(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.sort(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.SortBangNode create0(ArrayNodes.SortBangNode current2) {
                return new SortBangRubyArrayNode((SortBangBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortBangNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SortBangUninitializedNode
        extends SortBangBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortBangUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SortBangUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SortBangUninitializedNode(SortBangBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SortBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SortBangBaseNode rootNode = (SortBangBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SortBangBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.SortBangNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SortBangUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortBangNode.class)
        private static abstract class SortBangBaseNode
        extends ArrayNodes.SortBangNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SortBangBaseNode next0;

            SortBangBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SortBangBaseNode(SortBangBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SortBangBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SortBangBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SortBangUninitializedNode(this);
                    ((SortBangUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SortBangBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SortBangBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SortBangBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SortBangUninitializedNode(this), (Node)new SortBangPolymorphicNode(this), (DSLNode)((SortBangBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SortBangBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (SortBangBaseNode)SortBangRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SortBangBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SortBangBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SortNode.class)
    public static final class SortNodeFactory
    extends NodeFactoryBase<ArrayNodes.SortNode> {
        private static SortNodeFactory sortNodeFactoryInstance;

        private SortNodeFactory() {
            super(ArrayNodes.SortNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SortNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SortNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.SortNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SortUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.SortNode> getInstance() {
            if (sortNodeFactoryInstance == null) {
                sortNodeFactoryInstance = new SortNodeFactory();
            }
            return sortNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SortPolymorphicNode
        extends SortBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SortPolymorphicNode(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyProc.class ? this.arguments[1].executeRubyProc(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayRubyProcNode
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            SortRubyArrayRubyProcNode(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.sortWithCompareBlock(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.sortWithCompareBlock(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current2) {
                return new SortRubyArrayRubyProcNode((SortBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder7Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder7Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder7Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.sortObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.sortObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current2) {
                return new SortRubyArrayUndefinedPlaceholder7Node((SortBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder6Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder6Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder6Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isObject(arguments0Value) && SortBaseNode.isSmall(arguments0Value)) {
                    return super.sortVeryShortObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, isSmall] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast) && SortBaseNode.isSmall(arguments0ValueCast)) {
                        return super.sortVeryShortObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current2) {
                return new SortRubyArrayUndefinedPlaceholder6Node((SortBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder5Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder5Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder5Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.sortDouble(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.sortDouble(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current2) {
                return new SortRubyArrayUndefinedPlaceholder5Node((SortBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder4Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder4Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.sortLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.sortLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current2) {
                return new SortRubyArrayUndefinedPlaceholder4Node((SortBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder3Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder3Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value) && SortBaseNode.isSmall(arguments0Value)) {
                    return super.sortVeryShortLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, isSmall] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast) && SortBaseNode.isSmall(arguments0ValueCast)) {
                        return super.sortVeryShortLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current2) {
                return new SortRubyArrayUndefinedPlaceholder3Node((SortBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder2Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder2Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.sortIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.sortIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current2) {
                return new SortRubyArrayUndefinedPlaceholder2Node((SortBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder1Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder1Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && SortBaseNode.isSmall(arguments0Value)) {
                    return super.sortVeryShortIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, isSmall] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && SortBaseNode.isSmall(arguments0ValueCast)) {
                        return super.sortVeryShortIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current2) {
                return new SortRubyArrayUndefinedPlaceholder1Node((SortBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SortRubyArrayUndefinedPlaceholder0Node
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortRubyArrayUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            SortRubyArrayUndefinedPlaceholder0Node(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.sortNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.sortNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(ArrayNodes.SortNode current2) {
                return new SortRubyArrayUndefinedPlaceholder0Node((SortBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SortUninitializedNode
        extends SortBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SortUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SortUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SortUninitializedNode(SortBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SortBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SortBaseNode rootNode = (SortBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SortBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SortNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SortUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.SortNode.class)
        private static abstract class SortBaseNode
        extends ArrayNodes.SortNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SortBaseNode next0;

            SortBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SortBaseNode(SortBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                SortBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SortBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SortUninitializedNode(this);
                    ((SortUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SortBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SortBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SortBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SortUninitializedNode(this), (Node)new SortPolymorphicNode(this), (DSLNode)((SortBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SortBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        if (ArrayGuards.isNull(arguments0ValueCast)) {
                            return (SortBaseNode)SortRubyArrayUndefinedPlaceholder0Node.create0(this);
                        }
                        if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                            if (ArrayNodes.SortNode.isSmall(arguments0ValueCast)) {
                                return (SortBaseNode)SortRubyArrayUndefinedPlaceholder1Node.create0(this);
                            }
                            return (SortBaseNode)SortRubyArrayUndefinedPlaceholder2Node.create0(this);
                        }
                        if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                            if (ArrayNodes.SortNode.isSmall(arguments0ValueCast)) {
                                return (SortBaseNode)SortRubyArrayUndefinedPlaceholder3Node.create0(this);
                            }
                            return (SortBaseNode)SortRubyArrayUndefinedPlaceholder4Node.create0(this);
                        }
                        if (ArrayGuards.isFloat(arguments0ValueCast)) {
                            return (SortBaseNode)SortRubyArrayUndefinedPlaceholder5Node.create0(this);
                        }
                        if (ArrayGuards.isObject(arguments0ValueCast)) {
                            if (ArrayNodes.SortNode.isSmall(arguments0ValueCast)) {
                                return (SortBaseNode)SortRubyArrayUndefinedPlaceholder6Node.create0(this);
                            }
                            return (SortBaseNode)SortRubyArrayUndefinedPlaceholder7Node.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value) && ArrayGuards.isObject(arguments0ValueCast)) {
                        return (SortBaseNode)SortRubyArrayRubyProcNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SortBaseNode otherCast = (SortBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SortBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SizeNode.class)
    public static final class SizeNodeFactory
    extends NodeFactoryBase<ArrayNodes.SizeNode> {
        private static SizeNodeFactory sizeNodeFactoryInstance;

        private SizeNodeFactory() {
            super(ArrayNodes.SizeNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SizeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SizeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.SizeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SizeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.SizeNode> getInstance() {
            if (sizeNodeFactoryInstance == null) {
                sizeNodeFactoryInstance = new SizeNodeFactory();
            }
            return sizeNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SizePolymorphicNode
        extends SizeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            SizePolymorphicNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SizeRubyArrayNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            SizeRubyArrayNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.size(arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.size(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.SizeNode create0(ArrayNodes.SizeNode current2) {
                return new SizeRubyArrayNode((SizeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SizeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SizeUninitializedNode
        extends SizeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SizeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SizeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SizeUninitializedNode(SizeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected int executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected int executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SizeBaseNode rootNode = (SizeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SizeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.SizeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SizeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.SizeNode.class)
        private static abstract class SizeBaseNode
        extends ArrayNodes.SizeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SizeBaseNode next0;

            SizeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SizeBaseNode(SizeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract int executeChained0(VirtualFrame var1, Object var2);

            protected final int rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                SizeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SizeBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new SizeUninitializedNode(this);
                    ((SizeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SizeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SizeBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (SizeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SizeUninitializedNode(this), (Node)new SizePolymorphicNode(this), (DSLNode)((SizeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SizeBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (SizeBaseNode)SizeRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((SizeBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (SizeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ShiftNode.class)
    public static final class ShiftNodeFactory
    extends NodeFactoryBase<ArrayNodes.ShiftNode> {
        private static ShiftNodeFactory shiftNodeFactoryInstance;

        private ShiftNodeFactory() {
            super(ArrayNodes.ShiftNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ShiftNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ShiftNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ShiftNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ShiftUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.ShiftNode> getInstance() {
            if (shiftNodeFactoryInstance == null) {
                shiftNodeFactoryInstance = new ShiftNodeFactory();
            }
            return shiftNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ShiftPolymorphicNode
        extends ShiftBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ShiftPolymorphicNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ShiftRubyArrayNode
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            ShiftRubyArrayNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.shift(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.shift(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.ShiftNode create0(ArrayNodes.ShiftNode current2) {
                return new ShiftRubyArrayNode((ShiftBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ShiftUninitializedNode
        extends ShiftBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ShiftUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ShiftUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ShiftUninitializedNode(ShiftBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ShiftBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ShiftBaseNode rootNode = (ShiftBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ShiftBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.ShiftNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ShiftUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.ShiftNode.class)
        private static abstract class ShiftBaseNode
        extends ArrayNodes.ShiftNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ShiftBaseNode next0;

            ShiftBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ShiftBaseNode(ShiftBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ShiftBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ShiftBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ShiftUninitializedNode(this);
                    ((ShiftUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ShiftBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ShiftBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ShiftBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ShiftUninitializedNode(this), (Node)new ShiftPolymorphicNode(this), (DSLNode)((ShiftBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ShiftBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (ShiftBaseNode)ShiftRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ShiftBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ShiftBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.SelectNode.class)
    public static final class SelectNodeFactory
    extends NodeFactoryBase<ArrayNodes.SelectNode> {
        private static SelectNodeFactory selectNodeFactoryInstance;

        private SelectNodeFactory() {
            super(ArrayNodes.SelectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.SelectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return SelectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.SelectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return SelectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.SelectNode> getInstance() {
            if (selectNodeFactoryInstance == null) {
                selectNodeFactoryInstance = new SelectNodeFactory();
            }
            return selectNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class SelectPolymorphicNode
        extends SelectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            SelectPolymorphicNode(SelectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SelectRubyArray2Node
        extends SelectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SelectRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            SelectRubyArray2Node(SelectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.selectFixnumInteger(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.selectFixnumInteger(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SelectNode create0(ArrayNodes.SelectNode current2) {
                return new SelectRubyArray2Node((SelectBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SelectRubyArray1Node
        extends SelectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SelectRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            SelectRubyArray1Node(SelectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.selectObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.selectObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SelectNode create0(ArrayNodes.SelectNode current2) {
                return new SelectRubyArray1Node((SelectBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class SelectRubyArray0Node
        extends SelectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SelectRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            SelectRubyArray0Node(SelectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.selectNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.selectNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SelectNode create0(ArrayNodes.SelectNode current2) {
                return new SelectRubyArray0Node((SelectBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class SelectUninitializedNode
        extends SelectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(SelectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            SelectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            SelectUninitializedNode(SelectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                SelectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    SelectBaseNode rootNode = (SelectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((SelectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.SelectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new SelectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.SelectNode.class)
        private static abstract class SelectBaseNode
        extends ArrayNodes.SelectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected SelectBaseNode next0;

            SelectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            SelectBaseNode(SelectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                SelectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                SelectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new SelectUninitializedNode(this);
                    ((SelectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (SelectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = SelectBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (SelectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new SelectUninitializedNode(this), (Node)new SelectPolymorphicNode(this), (DSLNode)((SelectBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final SelectBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (SelectBaseNode)SelectRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (SelectBaseNode)SelectRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (SelectBaseNode)SelectRubyArray2Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    SelectBaseNode otherCast = (SelectBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (SelectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
    public static final class ReplaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.ReplaceNode> {
        private static ReplaceNodeFactory replaceNodeFactoryInstance;

        private ReplaceNodeFactory() {
            super(ArrayNodes.ReplaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ReplaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ReplaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ReplaceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ReplaceUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.ReplaceNode> getInstance() {
            if (replaceNodeFactoryInstance == null) {
                replaceNodeFactoryInstance = new ReplaceNodeFactory();
            }
            return replaceNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ReplacePolymorphicNode
        extends ReplaceBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ReplacePolymorphicNode(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyArray4Node
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ReplaceRubyArray4Node(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isOtherObject(arguments0Value, arguments1Value)) {
                    return super.replaceObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isOtherObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.isOtherObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.replaceObject(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ReplaceNode create0(ArrayNodes.ReplaceNode current2) {
                return new ReplaceRubyArray4Node((ReplaceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyArray3Node
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ReplaceRubyArray3Node(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isOtherFloat(arguments0Value, arguments1Value)) {
                    return super.replaceFloat(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isOtherFloat] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.isOtherFloat(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.replaceFloat(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ReplaceNode create0(ArrayNodes.ReplaceNode current2) {
                return new ReplaceRubyArray3Node((ReplaceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyArray2Node
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ReplaceRubyArray2Node(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isOtherLongFixnum(arguments0Value, arguments1Value)) {
                    return super.replaceLongFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isOtherLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.isOtherLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.replaceLongFixnum(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ReplaceNode create0(ArrayNodes.ReplaceNode current2) {
                return new ReplaceRubyArray2Node((ReplaceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyArray1Node
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ReplaceRubyArray1Node(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isOtherIntegerFixnum(arguments0Value, arguments1Value)) {
                    return super.replaceIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isOtherIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.isOtherIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.replaceIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ReplaceNode create0(ArrayNodes.ReplaceNode current2) {
                return new ReplaceRubyArray1Node((ReplaceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ReplaceRubyArray0Node
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ReplaceRubyArray0Node(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isOtherNull(arguments0Value, arguments1Value)) {
                    return super.replace(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isOtherNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.isOtherNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.replace(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ReplaceNode create0(ArrayNodes.ReplaceNode current2) {
                return new ReplaceRubyArray0Node((ReplaceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ReplaceUninitializedNode
        extends ReplaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ReplaceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ReplaceUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ReplaceUninitializedNode(ReplaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ReplaceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ReplaceBaseNode rootNode = (ReplaceBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ReplaceBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ReplaceNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ReplaceUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.ReplaceNode.class)
        private static abstract class ReplaceBaseNode
        extends ArrayNodes.ReplaceNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ReplaceBaseNode next0;

            ReplaceBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ReplaceBaseNode(ReplaceBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ReplaceBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ReplaceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ReplaceUninitializedNode(this);
                    ((ReplaceUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ReplaceBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ReplaceBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ReplaceBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ReplaceUninitializedNode(this), (Node)new ReplacePolymorphicNode(this), (DSLNode)((ReplaceBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ReplaceBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value)) {
                    RubyArray arguments1ValueCast;
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isOtherNull(arguments0ValueCast, arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                        return (ReplaceBaseNode)ReplaceRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isOtherIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return (ReplaceBaseNode)ReplaceRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isOtherLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return (ReplaceBaseNode)ReplaceRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isOtherFloat(arguments0ValueCast, arguments1ValueCast)) {
                        return (ReplaceBaseNode)ReplaceRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isOtherObject(arguments0ValueCast, arguments1ValueCast)) {
                        return (ReplaceBaseNode)ReplaceRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ReplaceBaseNode otherCast = (ReplaceBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ReplaceBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
    public static final class RejectInPlaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.RejectInPlaceNode> {
        private static RejectInPlaceNodeFactory rejectInPlaceNodeFactoryInstance;

        private RejectInPlaceNodeFactory() {
            super(ArrayNodes.RejectInPlaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.RejectInPlaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RejectInPlaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.RejectInPlaceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RejectInPlaceUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.RejectInPlaceNode> getInstance() {
            if (rejectInPlaceNodeFactoryInstance == null) {
                rejectInPlaceNodeFactoryInstance = new RejectInPlaceNodeFactory();
            }
            return rejectInPlaceNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RejectInPlacePolymorphicNode
        extends RejectInPlaceBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RejectInPlacePolymorphicNode(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectInPlaceRubyArray1Node
        extends RejectInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectInPlaceRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectInPlaceRubyArray1Node(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.rejectInPlaceObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.rejectInPlaceObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectInPlaceNode create0(ArrayNodes.RejectInPlaceNode current2) {
                return new RejectInPlaceRubyArray1Node((RejectInPlaceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectInPlaceRubyArray0Node
        extends RejectInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectInPlaceRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectInPlaceRubyArray0Node(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.rejectInPlaceNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.rejectInPlaceNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectInPlaceNode create0(ArrayNodes.RejectInPlaceNode current2) {
                return new RejectInPlaceRubyArray0Node((RejectInPlaceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RejectInPlaceUninitializedNode
        extends RejectInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectInPlaceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RejectInPlaceUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RejectInPlaceUninitializedNode(RejectInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RejectInPlaceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RejectInPlaceBaseNode rootNode = (RejectInPlaceBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RejectInPlaceBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectInPlaceNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RejectInPlaceUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectInPlaceNode.class)
        private static abstract class RejectInPlaceBaseNode
        extends ArrayNodes.RejectInPlaceNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RejectInPlaceBaseNode next0;

            RejectInPlaceBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RejectInPlaceBaseNode(RejectInPlaceBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                RejectInPlaceBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RejectInPlaceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RejectInPlaceUninitializedNode(this);
                    ((RejectInPlaceUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RejectInPlaceBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = RejectInPlaceBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (RejectInPlaceBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RejectInPlaceUninitializedNode(this), (Node)new RejectInPlacePolymorphicNode(this), (DSLNode)((RejectInPlaceBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RejectInPlaceBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (RejectInPlaceBaseNode)RejectInPlaceRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (RejectInPlaceBaseNode)RejectInPlaceRubyArray1Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RejectInPlaceBaseNode otherCast = (RejectInPlaceBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RejectInPlaceBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.RejectNode.class)
    public static final class RejectNodeFactory
    extends NodeFactoryBase<ArrayNodes.RejectNode> {
        private static RejectNodeFactory rejectNodeFactoryInstance;

        private RejectNodeFactory() {
            super(ArrayNodes.RejectNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.RejectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return RejectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.RejectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return RejectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.RejectNode> getInstance() {
            if (rejectNodeFactoryInstance == null) {
                rejectNodeFactoryInstance = new RejectNodeFactory();
            }
            return rejectNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class RejectPolymorphicNode
        extends RejectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            RejectPolymorphicNode(RejectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectRubyArray2Node
        extends RejectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectRubyArray2Node(RejectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.selectFixnumInteger(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.selectFixnumInteger(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectNode create0(ArrayNodes.RejectNode current2) {
                return new RejectRubyArray2Node((RejectBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectRubyArray1Node
        extends RejectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectRubyArray1Node(RejectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.selectObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.selectObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectNode create0(ArrayNodes.RejectNode current2) {
                return new RejectRubyArray1Node((RejectBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class RejectRubyArray0Node
        extends RejectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            RejectRubyArray0Node(RejectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.selectNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.selectNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectNode create0(ArrayNodes.RejectNode current2) {
                return new RejectRubyArray0Node((RejectBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class RejectUninitializedNode
        extends RejectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(RejectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            RejectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            RejectUninitializedNode(RejectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RejectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    RejectBaseNode rootNode = (RejectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((RejectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.RejectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new RejectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.RejectNode.class)
        private static abstract class RejectBaseNode
        extends ArrayNodes.RejectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected RejectBaseNode next0;

            RejectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            RejectBaseNode(RejectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                RejectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                RejectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new RejectUninitializedNode(this);
                    ((RejectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (RejectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = RejectBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (RejectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new RejectUninitializedNode(this), (Node)new RejectPolymorphicNode(this), (DSLNode)((RejectBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final RejectBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (RejectBaseNode)RejectRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (RejectBaseNode)RejectRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (RejectBaseNode)RejectRubyArray2Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    RejectBaseNode otherCast = (RejectBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (RejectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PushOneNode.class)
    public static final class PushOneNodeFactory
    extends NodeFactoryBase<ArrayNodes.PushOneNode> {
        private static PushOneNodeFactory pushOneNodeFactoryInstance;

        private PushOneNodeFactory() {
            super(ArrayNodes.PushOneNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PushOneNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PushOneNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.PushOneNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PushOneUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.PushOneNode> getInstance() {
            if (pushOneNodeFactoryInstance == null) {
                pushOneNodeFactoryInstance = new PushOneNodeFactory();
            }
            return pushOneNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PushOnePolymorphicNode
        extends PushOneBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PushOnePolymorphicNode(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushOneRubyArrayObject2Node
        extends PushOneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushOneRubyArrayObject2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PushOneRubyArrayObject2Node(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.pushObjectObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.pushObjectObject(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushOneNode create0(ArrayNodes.PushOneNode current2) {
                return new PushOneRubyArrayObject2Node((PushOneBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushOneRubyArrayObject1Node
        extends PushOneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushOneRubyArrayObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PushOneRubyArrayObject1Node(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.pushIntegerFixnumObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.pushIntegerFixnumObject(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushOneNode create0(ArrayNodes.PushOneNode current2) {
                return new PushOneRubyArrayObject1Node((PushOneBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushOneRubyArrayIntNode
        extends PushOneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushOneRubyArrayIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            PushOneRubyArrayIntNode(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.pushIntegerFixnumIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.pushIntegerFixnumIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushOneNode create0(ArrayNodes.PushOneNode current2) {
                return new PushOneRubyArrayIntNode((PushOneBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushOneRubyArrayObject0Node
        extends PushOneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushOneRubyArrayObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            PushOneRubyArrayObject0Node(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.pushEmpty(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.pushEmpty(arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushOneNode create0(ArrayNodes.PushOneNode current2) {
                return new PushOneRubyArrayObject0Node((PushOneBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PushOneUninitializedNode
        extends PushOneBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushOneUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PushOneUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PushOneUninitializedNode(PushOneBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PushOneBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PushOneBaseNode rootNode = (PushOneBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PushOneBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushOneNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PushOneUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushOneNode.class)
        private static abstract class PushOneBaseNode
        extends ArrayNodes.PushOneNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PushOneBaseNode next0;

            PushOneBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PushOneBaseNode(PushOneBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PushOneBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PushOneBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PushOneUninitializedNode(this);
                    ((PushOneUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PushOneBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PushOneBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PushOneBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PushOneUninitializedNode(this), (Node)new PushOnePolymorphicNode(this), (DSLNode)((PushOneBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PushOneBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (PushOneBaseNode)PushOneRubyArrayObject0Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (PushOneBaseNode)PushOneRubyArrayIntNode.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (PushOneBaseNode)PushOneRubyArrayObject1Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (PushOneBaseNode)PushOneRubyArrayObject2Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PushOneBaseNode otherCast = (PushOneBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PushOneBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PushNode.class)
    public static final class PushNodeFactory
    extends NodeFactoryBase<ArrayNodes.PushNode> {
        private static PushNodeFactory pushNodeFactoryInstance;

        private PushNodeFactory() {
            super(ArrayNodes.PushNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PushNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PushNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.PushNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PushUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.PushNode> getInstance() {
            if (pushNodeFactoryInstance == null) {
                pushNodeFactoryInstance = new PushNodeFactory();
            }
            return pushNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PushPolymorphicNode
        extends PushBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PushPolymorphicNode(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray6Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray6Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray6Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.pushObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.pushObject(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current2) {
                return new PushRubyArray6Node((PushBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray5Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray5Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray5Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value) && super.isSingleLongFixnum(arguments0Value, arguments1Value)) {
                    return super.pushLongFixnumSingleLongFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, isSingleLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast) && super.isSingleLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushLongFixnumSingleLongFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current2) {
                return new PushRubyArray5Node((PushBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray4Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray4Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value) && super.isSingleIntegerFixnum(arguments0Value, arguments1Value)) {
                    return super.pushLongFixnumSingleIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum, isSingleIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast) && super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushLongFixnumSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current2) {
                return new PushRubyArray4Node((PushBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray3Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray3Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value) && super.isSingleIntegerFixnum(arguments0Value, arguments1Value)) {
                    return super.pushIntegerFixnumSingleIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum, isSingleIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushIntegerFixnumSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current2) {
                return new PushRubyArray3Node((PushBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray2Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray2Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.pushEmptyObjects(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.pushEmptyObjects(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current2) {
                return new PushRubyArray2Node((PushBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray1Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray1Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isNull(arguments0Value) && super.isSingleLongFixnum(arguments0Value, arguments1Value)) {
                    return super.pushEmptySingleIntegerLong(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull, isSingleLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast) && super.isSingleLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushEmptySingleIntegerLong(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current2) {
                return new PushRubyArray1Node((PushBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PushRubyArray0Node
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object[].class}, 0, 0);

            PushRubyArray0Node(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object[] arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeObjectArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof Object[]");
                }
                if (ArrayGuards.isNull(arguments0Value) && super.isSingleIntegerFixnum(arguments0Value, arguments1Value)) {
                    return super.pushEmptySingleIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull, isSingleIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast) && super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return super.pushEmptySingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(ArrayNodes.PushNode current2) {
                return new PushRubyArray0Node((PushBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PushUninitializedNode
        extends PushBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PushUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PushUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PushUninitializedNode(PushBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PushBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PushBaseNode rootNode = (PushBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PushBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PushNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PushUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.PushNode.class)
        private static abstract class PushBaseNode
        extends ArrayNodes.PushNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PushBaseNode next0;

            PushBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PushBaseNode(PushBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PushBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PushBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PushUninitializedNode(this);
                    ((PushUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PushBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PushBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PushBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PushUninitializedNode(this), (Node)new PushPolymorphicNode(this), (DSLNode)((PushBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PushBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isObjectArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    Object[] arguments1ValueCast = RubyTypesGen.RUBYTYPES.asObjectArray(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        if (super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (PushBaseNode)PushRubyArray0Node.create0(this);
                        }
                        if (super.isSingleLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (PushBaseNode)PushRubyArray1Node.create0(this);
                        }
                        return (PushBaseNode)PushRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return (PushBaseNode)PushRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        if (super.isSingleIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (PushBaseNode)PushRubyArray4Node.create0(this);
                        }
                        if (super.isSingleLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                            return (PushBaseNode)PushRubyArray5Node.create0(this);
                        }
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (PushBaseNode)PushRubyArray6Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PushBaseNode otherCast = (PushBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PushBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ProductNode.class)
    public static final class ProductNodeFactory
    extends NodeFactoryBase<ArrayNodes.ProductNode> {
        private static ProductNodeFactory productNodeFactoryInstance;

        private ProductNodeFactory() {
            super(ArrayNodes.ProductNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ProductNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ProductNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ProductNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ProductUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.ProductNode> getInstance() {
            if (productNodeFactoryInstance == null) {
                productNodeFactoryInstance = new ProductNodeFactory();
            }
            return productNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ProductNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ProductPolymorphicNode
        extends ProductBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ProductPolymorphicNode(ProductBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.ProductNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ProductRubyArrayNode
        extends ProductBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProductRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ProductRubyArrayNode(ProductBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isObject(arguments0Value) && ArrayGuards.isOtherObject(arguments0Value, arguments1Value)) {
                    return super.product(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject, isOtherObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyArray arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast) && ArrayGuards.isOtherObject(arguments0ValueCast, arguments1ValueCast)) {
                        return super.product(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ProductNode create0(ArrayNodes.ProductNode current2) {
                return new ProductRubyArrayNode((ProductBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ProductNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ProductUninitializedNode
        extends ProductBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ProductUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ProductUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ProductUninitializedNode(ProductBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ProductBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ProductBaseNode rootNode = (ProductBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ProductBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ProductNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ProductUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.ProductNode.class)
        private static abstract class ProductBaseNode
        extends ArrayNodes.ProductNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ProductBaseNode next0;

            ProductBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ProductBaseNode(ProductBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ProductBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ProductBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ProductUninitializedNode(this);
                    ((ProductUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ProductBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ProductBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ProductBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ProductUninitializedNode(this), (Node)new ProductPolymorphicNode(this), (DSLNode)((ProductBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ProductBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyArray arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast) && ArrayGuards.isOtherObject(arguments0ValueCast, arguments1ValueCast)) {
                        return (ProductBaseNode)ProductRubyArrayNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ProductBaseNode otherCast = (ProductBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ProductBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PopNode.class)
    public static final class PopNodeFactory
    extends NodeFactoryBase<ArrayNodes.PopNode> {
        private static PopNodeFactory popNodeFactoryInstance;

        private PopNodeFactory() {
            super(ArrayNodes.PopNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PopNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PopNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.PopNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PopUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.PopNode> getInstance() {
            if (popNodeFactoryInstance == null) {
                popNodeFactoryInstance = new PopNodeFactory();
            }
            return popNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PopPolymorphicNode
        extends PopBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            PopPolymorphicNode(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObject4Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObject4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            PopObject4Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.popObject(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.popObject(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current2) {
                return new PopObject4Node((PopBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObject3Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObject3Node.class, new Class[]{PopDoubleNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            PopObject3Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.popFloat(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isFloat(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.popFloat(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current2) {
                return new PopObject3Node((PopBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopDoubleNode
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopDoubleNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObject3Node.class}, new Class[]{RubyArray.class}, 0, 0);

            PopDoubleNode(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray"));
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.popFloatInBounds(arguments0Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, "One of guards [isFloat] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isFloat(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    try {
                        return super.popFloatInBounds(arguments0ValueCast);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current2) {
                return new PopDoubleNode((PopBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObject2Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObject2Node.class, new Class[]{PopLongNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            PopObject2Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.popLongFixnum(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.popLongFixnum(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current2) {
                return new PopObject2Node((PopBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopLongNode
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopLongNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObject2Node.class}, new Class[]{RubyArray.class}, 0, 0);

            PopLongNode(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray"));
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    try {
                        return super.popLongFixnumInBounds(arguments0Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, "One of guards [isLongFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    try {
                        return super.popLongFixnumInBounds(arguments0ValueCast);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current2) {
                return new PopLongNode((PopBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObject1Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObject1Node.class, new Class[]{PopIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            PopObject1Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.popIntegerFixnum(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.popIntegerFixnum(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current2) {
                return new PopObject1Node((PopBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopIntNode
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{PopObject1Node.class}, new Class[]{RubyArray.class}, 0, 0);

            PopIntNode(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    try {
                        return super.popIntegerFixnumInBounds(arguments0Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    try {
                        return super.popIntegerFixnumInBounds(arguments0ValueCast);
                    }
                    catch (UnexpectedResultException rewriteEx) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(frameValue, arguments0Value, "Thrown UnexpectedResultException");
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current2) {
                return new PopIntNode((PopBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PopObject0Node
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            PopObject0Node(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.popNil(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.popNil(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.PopNode create0(ArrayNodes.PopNode current2) {
                return new PopObject0Node((PopBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PopUninitializedNode
        extends PopBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PopUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PopUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PopUninitializedNode(PopBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                PopBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PopBaseNode rootNode = (PopBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PopBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.PopNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PopUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.PopNode.class)
        private static abstract class PopBaseNode
        extends ArrayNodes.PopNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PopBaseNode next0;

            PopBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PopBaseNode(PopBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                PopBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PopBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new PopUninitializedNode(this);
                    ((PopUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PopBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PopBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (PopBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PopUninitializedNode(this), (Node)new PopPolymorphicNode(this), (DSLNode)((PopBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PopBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (PopBaseNode)PopObject0Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast) && !DSLShare.isExcluded((Node)this, (DSLMetadata)PopIntNode.METADATA)) {
                        return (PopBaseNode)PopIntNode.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (PopBaseNode)PopObject1Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast) && !DSLShare.isExcluded((Node)this, (DSLMetadata)PopLongNode.METADATA)) {
                        return (PopBaseNode)PopLongNode.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return (PopBaseNode)PopObject2Node.create0(this);
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast) && !DSLShare.isExcluded((Node)this, (DSLMetadata)PopDoubleNode.METADATA)) {
                        return (PopBaseNode)PopDoubleNode.create0(this);
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return (PopBaseNode)PopObject3Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (PopBaseNode)PopObject4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((PopBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (PopBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PermutationNode.class)
    public static final class PermutationNodeFactory
    extends NodeFactoryBase<ArrayNodes.PermutationNode> {
        private static PermutationNodeFactory permutationNodeFactoryInstance;

        private PermutationNodeFactory() {
            super(ArrayNodes.PermutationNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PermutationNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PermutationNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.PermutationNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PermutationUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.PermutationNode> getInstance() {
            if (permutationNodeFactoryInstance == null) {
                permutationNodeFactoryInstance = new PermutationNodeFactory();
            }
            return permutationNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.PermutationNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PermutationPolymorphicNode
        extends PermutationBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PermutationPolymorphicNode(PermutationBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.PermutationNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PermutationRubyArrayNode
        extends PermutationBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PermutationRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            PermutationRubyArrayNode(PermutationBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                return super.permutation(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    return super.permutation(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PermutationNode create0(ArrayNodes.PermutationNode current2) {
                return new PermutationRubyArrayNode((PermutationBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PermutationNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PermutationUninitializedNode
        extends PermutationBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PermutationUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PermutationUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PermutationUninitializedNode(PermutationBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PermutationBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PermutationBaseNode rootNode = (PermutationBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PermutationBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PermutationNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PermutationUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.PermutationNode.class)
        private static abstract class PermutationBaseNode
        extends ArrayNodes.PermutationNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PermutationBaseNode next0;

            PermutationBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PermutationBaseNode(PermutationBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PermutationBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PermutationBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PermutationUninitializedNode(this);
                    ((PermutationUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PermutationBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PermutationBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PermutationBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PermutationUninitializedNode(this), (Node)new PermutationPolymorphicNode(this), (DSLNode)((PermutationBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PermutationBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    return (PermutationBaseNode)PermutationRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PermutationBaseNode otherCast = (PermutationBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PermutationBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.PackNode.class)
    public static final class PackNodeFactory
    extends NodeFactoryBase<ArrayNodes.PackNode> {
        private static PackNodeFactory packNodeFactoryInstance;

        private PackNodeFactory() {
            super(ArrayNodes.PackNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.PackNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return PackNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.PackNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return PackUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.PackNode> getInstance() {
            if (packNodeFactoryInstance == null) {
                packNodeFactoryInstance = new PackNodeFactory();
            }
            return packNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class PackPolymorphicNode
        extends PackBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            PackPolymorphicNode(PackBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class PackRubyArrayNode
        extends PackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PackRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyString.class}, 0, 0);

            PackRubyArrayNode(PackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.pack(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.pack(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PackNode create0(ArrayNodes.PackNode current2) {
                return new PackRubyArrayNode((PackBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class PackUninitializedNode
        extends PackBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(PackUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            PackUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            PackUninitializedNode(PackBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                PackBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    PackBaseNode rootNode = (PackBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((PackBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.PackNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new PackUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.PackNode.class)
        private static abstract class PackBaseNode
        extends ArrayNodes.PackNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected PackBaseNode next0;

            PackBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            PackBaseNode(PackBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                PackBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                PackBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new PackUninitializedNode(this);
                    ((PackUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (PackBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = PackBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (PackBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new PackUninitializedNode(this), (Node)new PackPolymorphicNode(this), (DSLNode)((PackBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final PackBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    return (PackBaseNode)PackRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    PackBaseNode otherCast = (PackBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (PackBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MinBlockNode.class)
    public static final class MinBlockNodeFactory
    extends NodeFactoryBase<ArrayNodes.MinBlockNode> {
        private static MinBlockNodeFactory minBlockNodeFactoryInstance;

        private MinBlockNodeFactory() {
            super(ArrayNodes.MinBlockNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MinBlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MinBlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MinBlockNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MinBlockObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MinBlockNode> getInstance() {
            if (minBlockNodeFactoryInstance == null) {
                minBlockNodeFactoryInstance = new MinBlockNodeFactory();
            }
            return minBlockNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MinBlockNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MinBlockObjectNode
        extends MinBlockBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MinBlockObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            MinBlockObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.min(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MinBlockNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MinBlockObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MinBlockNode.class)
        private static abstract class MinBlockBaseNode
        extends ArrayNodes.MinBlockNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            MinBlockBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MinBlockBaseNode otherCast = (MinBlockBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MinNode.class)
    public static final class MinNodeFactory
    extends NodeFactoryBase<ArrayNodes.MinNode> {
        private static MinNodeFactory minNodeFactoryInstance;

        private MinNodeFactory() {
            super(ArrayNodes.MinNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MinNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MinUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MinNode> getInstance() {
            if (minNodeFactoryInstance == null) {
                minNodeFactoryInstance = new MinNodeFactory();
            }
            return minNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MinNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MinPolymorphicNode
        extends MinBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            MinPolymorphicNode(MinBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.MinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MinRubyArrayNode
        extends MinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MinRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            MinRubyArrayNode(MinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.min(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.min(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.MinNode create0(ArrayNodes.MinNode current2) {
                return new MinRubyArrayNode((MinBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.MinNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MinUninitializedNode
        extends MinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MinUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MinUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MinUninitializedNode(MinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                MinBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MinBaseNode rootNode = (MinBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MinBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.MinNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MinUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MinNode.class)
        private static abstract class MinBaseNode
        extends ArrayNodes.MinNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MinBaseNode next0;

            MinBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MinBaseNode(MinBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                MinBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MinBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new MinUninitializedNode(this);
                    ((MinUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MinBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MinBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (MinBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MinUninitializedNode(this), (Node)new MinPolymorphicNode(this), (DSLNode)((MinBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MinBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (MinBaseNode)MinRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((MinBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (MinBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MaxBlockNode.class)
    public static final class MaxBlockNodeFactory
    extends NodeFactoryBase<ArrayNodes.MaxBlockNode> {
        private static MaxBlockNodeFactory maxBlockNodeFactoryInstance;

        private MaxBlockNodeFactory() {
            super(ArrayNodes.MaxBlockNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MaxBlockNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MaxBlockNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MaxBlockNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MaxBlockObjectNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MaxBlockNode> getInstance() {
            if (maxBlockNodeFactoryInstance == null) {
                maxBlockNodeFactoryInstance = new MaxBlockNodeFactory();
            }
            return maxBlockNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MaxBlockNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MaxBlockObjectNode
        extends MaxBlockBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MaxBlockObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);

            MaxBlockObjectNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return super.max(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MaxBlockNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MaxBlockObjectNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MaxBlockNode.class)
        private static abstract class MaxBlockBaseNode
        extends ArrayNodes.MaxBlockNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;

            MaxBlockBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MaxBlockBaseNode otherCast = (MaxBlockBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return null;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MaxNode.class)
    public static final class MaxNodeFactory
    extends NodeFactoryBase<ArrayNodes.MaxNode> {
        private static MaxNodeFactory maxNodeFactoryInstance;

        private MaxNodeFactory() {
            super(ArrayNodes.MaxNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MaxNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MaxNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MaxNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MaxUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MaxNode> getInstance() {
            if (maxNodeFactoryInstance == null) {
                maxNodeFactoryInstance = new MaxNodeFactory();
            }
            return maxNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MaxNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MaxPolymorphicNode
        extends MaxBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            MaxPolymorphicNode(MaxBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.MaxNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MaxRubyArrayNode
        extends MaxBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MaxRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            MaxRubyArrayNode(MaxBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.max(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.max(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.MaxNode create0(ArrayNodes.MaxNode current2) {
                return new MaxRubyArrayNode((MaxBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.MaxNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MaxUninitializedNode
        extends MaxBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MaxUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MaxUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MaxUninitializedNode(MaxBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                MaxBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MaxBaseNode rootNode = (MaxBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MaxBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.MaxNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MaxUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MaxNode.class)
        private static abstract class MaxBaseNode
        extends ArrayNodes.MaxNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MaxBaseNode next0;

            MaxBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MaxBaseNode(MaxBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                MaxBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MaxBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new MaxUninitializedNode(this);
                    ((MaxUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MaxBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MaxBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (MaxBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MaxUninitializedNode(this), (Node)new MaxPolymorphicNode(this), (DSLNode)((MaxBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MaxBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (MaxBaseNode)MaxRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((MaxBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (MaxBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
    public static final class MapInPlaceNodeFactory
    extends NodeFactoryBase<ArrayNodes.MapInPlaceNode> {
        private static MapInPlaceNodeFactory mapInPlaceNodeFactoryInstance;

        private MapInPlaceNodeFactory() {
            super(ArrayNodes.MapInPlaceNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MapInPlaceNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MapInPlaceNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MapInPlaceNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MapInPlaceUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MapInPlaceNode> getInstance() {
            if (mapInPlaceNodeFactoryInstance == null) {
                mapInPlaceNodeFactoryInstance = new MapInPlaceNodeFactory();
            }
            return mapInPlaceNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MapInPlacePolymorphicNode
        extends MapInPlaceBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MapInPlacePolymorphicNode(MapInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapInPlaceRubyArray1Node
        extends MapInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapInPlaceRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapInPlaceRubyArray1Node(MapInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.mapInPlaceObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.mapInPlaceObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapInPlaceNode create0(ArrayNodes.MapInPlaceNode current2) {
                return new MapInPlaceRubyArray1Node((MapInPlaceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapInPlaceRubyArray0Node
        extends MapInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapInPlaceRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapInPlaceRubyArray0Node(MapInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.mapInPlaceFixnumInteger(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.mapInPlaceFixnumInteger(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapInPlaceNode create0(ArrayNodes.MapInPlaceNode current2) {
                return new MapInPlaceRubyArray0Node((MapInPlaceBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MapInPlaceUninitializedNode
        extends MapInPlaceBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapInPlaceUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MapInPlaceUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MapInPlaceUninitializedNode(MapInPlaceBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MapInPlaceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MapInPlaceBaseNode rootNode = (MapInPlaceBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MapInPlaceBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapInPlaceNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MapInPlaceUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapInPlaceNode.class)
        private static abstract class MapInPlaceBaseNode
        extends ArrayNodes.MapInPlaceNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MapInPlaceBaseNode next0;

            MapInPlaceBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MapInPlaceBaseNode(MapInPlaceBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                MapInPlaceBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MapInPlaceBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MapInPlaceUninitializedNode(this);
                    ((MapInPlaceUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MapInPlaceBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MapInPlaceBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MapInPlaceBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MapInPlaceUninitializedNode(this), (Node)new MapInPlacePolymorphicNode(this), (DSLNode)((MapInPlaceBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MapInPlaceBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (MapInPlaceBaseNode)MapInPlaceRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (MapInPlaceBaseNode)MapInPlaceRubyArray1Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MapInPlaceBaseNode otherCast = (MapInPlaceBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MapInPlaceBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.MapNode.class)
    public static final class MapNodeFactory
    extends NodeFactoryBase<ArrayNodes.MapNode> {
        private static MapNodeFactory mapNodeFactoryInstance;

        private MapNodeFactory() {
            super(ArrayNodes.MapNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.MapNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return MapNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.MapNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return MapUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.MapNode> getInstance() {
            if (mapNodeFactoryInstance == null) {
                mapNodeFactoryInstance = new MapNodeFactory();
            }
            return mapNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class MapPolymorphicNode
        extends MapBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            MapPolymorphicNode(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyArray4Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapRubyArray4Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.mapObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.mapObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(ArrayNodes.MapNode current2) {
                return new MapRubyArray4Node((MapBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyArray3Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapRubyArray3Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.mapFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.mapFloat(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(ArrayNodes.MapNode current2) {
                return new MapRubyArray3Node((MapBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyArray2Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapRubyArray2Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.mapLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.mapLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(ArrayNodes.MapNode current2) {
                return new MapRubyArray2Node((MapBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyArray1Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapRubyArray1Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.mapIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.mapIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(ArrayNodes.MapNode current2) {
                return new MapRubyArray1Node((MapBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class MapRubyArray0Node
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            MapRubyArray0Node(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.mapNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.mapNull(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(ArrayNodes.MapNode current2) {
                return new MapRubyArray0Node((MapBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class MapUninitializedNode
        extends MapBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(MapUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            MapUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            MapUninitializedNode(MapBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                MapBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    MapBaseNode rootNode = (MapBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((MapBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.MapNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new MapUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.MapNode.class)
        private static abstract class MapBaseNode
        extends ArrayNodes.MapNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected MapBaseNode next0;

            MapBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            MapBaseNode(MapBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                MapBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                MapBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new MapUninitializedNode(this);
                    ((MapUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (MapBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = MapBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (MapBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new MapUninitializedNode(this), (Node)new MapPolymorphicNode(this), (DSLNode)((MapBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final MapBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (MapBaseNode)MapRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (MapBaseNode)MapRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return (MapBaseNode)MapRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return (MapBaseNode)MapRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (MapBaseNode)MapRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    MapBaseNode otherCast = (MapBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (MapBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.LastNode.class)
    public static final class LastNodeFactory
    extends NodeFactoryBase<ArrayNodes.LastNode> {
        private static LastNodeFactory lastNodeFactoryInstance;

        private LastNodeFactory() {
            super(ArrayNodes.LastNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.LastNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return LastNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.LastNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return LastUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.LastNode> getInstance() {
            if (lastNodeFactoryInstance == null) {
                lastNodeFactoryInstance = new LastNodeFactory();
            }
            return lastNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.LastNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class LastPolymorphicNode
        extends LastBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            LastPolymorphicNode(LastBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.LastNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class LastRubyArrayNode
        extends LastBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LastRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            LastRubyArrayNode(LastBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.last(arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.last(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.LastNode create0(ArrayNodes.LastNode current2) {
                return new LastRubyArrayNode((LastBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.LastNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class LastUninitializedNode
        extends LastBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(LastUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            LastUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            LastUninitializedNode(LastBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                LastBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    LastBaseNode rootNode = (LastBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((LastBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.LastNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new LastUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.LastNode.class)
        private static abstract class LastBaseNode
        extends ArrayNodes.LastNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected LastBaseNode next0;

            LastBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            LastBaseNode(LastBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                LastBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                LastBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new LastUninitializedNode(this);
                    ((LastUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (LastBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = LastBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (LastBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new LastUninitializedNode(this), (Node)new LastPolymorphicNode(this), (DSLNode)((LastBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final LastBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (LastBaseNode)LastRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((LastBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (LastBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.JoinNode.class)
    public static final class JoinNodeFactory
    extends NodeFactoryBase<ArrayNodes.JoinNode> {
        private static JoinNodeFactory joinNodeFactoryInstance;

        private JoinNodeFactory() {
            super(ArrayNodes.JoinNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.JoinNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return JoinNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.JoinNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return JoinUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.JoinNode> getInstance() {
            if (joinNodeFactoryInstance == null) {
                joinNodeFactoryInstance = new JoinNodeFactory();
            }
            return joinNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class JoinPolymorphicNode
        extends JoinBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            JoinPolymorphicNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == UndefinedPlaceholder.class ? this.arguments[1].executeUndefinedPlaceholder(frameValue) : (this.arguments1PolymorphicType == RubyString.class ? this.arguments[1].executeRubyString(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class JoinRubyArrayRubyStringNode
        extends JoinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JoinRubyArrayRubyStringNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyString.class}, 0, 0);

            JoinRubyArrayRubyStringNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyString arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyString");
                }
                return super.join(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyString arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyString(arguments1Value);
                    return super.join(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.JoinNode create0(ArrayNodes.JoinNode current2) {
                return new JoinRubyArrayRubyStringNode((JoinBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class JoinRubyArrayUndefinedPlaceholderNode
        extends JoinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JoinRubyArrayUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            JoinRubyArrayUndefinedPlaceholderNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof UndefinedPlaceholder");
                }
                return super.join(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    UndefinedPlaceholder arguments1ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments1Value);
                    return super.join(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.JoinNode create0(ArrayNodes.JoinNode current2) {
                return new JoinRubyArrayUndefinedPlaceholderNode((JoinBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.JoinNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class JoinUninitializedNode
        extends JoinBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(JoinUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            JoinUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            JoinUninitializedNode(JoinBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                JoinBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    JoinBaseNode rootNode = (JoinBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((JoinBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.JoinNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new JoinUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.JoinNode.class)
        private static abstract class JoinBaseNode
        extends ArrayNodes.JoinNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected JoinBaseNode next0;

            JoinBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            JoinBaseNode(JoinBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                JoinBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                JoinBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new JoinUninitializedNode(this);
                    ((JoinUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (JoinBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = JoinBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (JoinBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new JoinUninitializedNode(this), (Node)new JoinPolymorphicNode(this), (DSLNode)((JoinBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final JoinBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments1Value)) {
                        return (JoinBaseNode)JoinRubyArrayUndefinedPlaceholderNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubyString(arguments1Value)) {
                        return (JoinBaseNode)JoinRubyArrayRubyStringNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    JoinBaseNode otherCast = (JoinBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (JoinBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InspectNode.class)
    public static final class InspectNodeFactory
    extends NodeFactoryBase<ArrayNodes.InspectNode> {
        private static InspectNodeFactory inspectNodeFactoryInstance;

        private InspectNodeFactory() {
            super(ArrayNodes.InspectNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InspectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InspectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.InspectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InspectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.InspectNode> getInstance() {
            if (inspectNodeFactoryInstance == null) {
                inspectNodeFactoryInstance = new InspectNodeFactory();
            }
            return inspectNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InspectPolymorphicNode
        extends InspectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            InspectPolymorphicNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InspectRubyArrayNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            InspectRubyArrayNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.inspect(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.inspect(frameValue, arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.InspectNode create0(ArrayNodes.InspectNode current2) {
                return new InspectRubyArrayNode((InspectBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InspectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InspectUninitializedNode
        extends InspectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InspectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InspectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InspectUninitializedNode(InspectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyString value2;
                try {
                    value2 = this.executeRubyString(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyString executeRubyString(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyString executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyString executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InspectBaseNode rootNode = (InspectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InspectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.InspectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InspectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.InspectNode.class)
        private static abstract class InspectBaseNode
        extends ArrayNodes.InspectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InspectBaseNode next0;

            InspectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InspectBaseNode(InspectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyString executeChained0(VirtualFrame var1, Object var2);

            protected final RubyString rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                InspectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InspectBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new InspectUninitializedNode(this);
                    ((InspectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InspectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InspectBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (InspectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InspectUninitializedNode(this), (Node)new InspectPolymorphicNode(this), (DSLNode)((InspectBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InspectBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (InspectBaseNode)InspectRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((InspectBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (InspectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InsertNode.class)
    public static final class InsertNodeFactory
    extends NodeFactoryBase<ArrayNodes.InsertNode> {
        private static InsertNodeFactory insertNodeFactoryInstance;

        private InsertNodeFactory() {
            super(ArrayNodes.InsertNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InsertNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InsertNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.InsertNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InsertUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.InsertNode> getInstance() {
            if (insertNodeFactoryInstance == null) {
                insertNodeFactoryInstance = new InsertNodeFactory();
            }
            return insertNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InsertPolymorphicNode
        extends InsertBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            InsertPolymorphicNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : this.arguments[2].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InsertRubyArrayIntNode
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertRubyArrayIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            InsertRubyArrayIntNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.insert(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.insert(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InsertNode create0(ArrayNodes.InsertNode current2) {
                return new InsertRubyArrayIntNode((InsertBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InsertRubyArrayObjectNode
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertRubyArrayObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class}, 0, 0);

            InsertRubyArrayObjectNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, "Expected arguments1Value instanceof int");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.insert(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.insert(arguments0ValueCast, arguments1ValueCast, arguments2Value);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InsertNode create0(ArrayNodes.InsertNode current2) {
                return new InsertRubyArrayObjectNode((InsertBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InsertUninitializedNode
        extends InsertBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InsertUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InsertUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InsertUninitializedNode(InsertBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                InsertBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InsertBaseNode rootNode = (InsertBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InsertBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InsertNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InsertUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.InsertNode.class)
        private static abstract class InsertBaseNode
        extends ArrayNodes.InsertNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InsertBaseNode next0;

            InsertBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InsertBaseNode(InsertBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                InsertBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InsertBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new InsertUninitializedNode(this);
                    ((InsertUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InsertBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InsertBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (InsertBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InsertUninitializedNode(this), (Node)new InsertPolymorphicNode(this), (DSLNode)((InsertBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InsertBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (InsertBaseNode)InsertRubyArrayObjectNode.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (InsertBaseNode)InsertRubyArrayIntNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    InsertBaseNode otherCast = (InsertBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (InsertBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InjectNode.class)
    public static final class InjectNodeFactory
    extends NodeFactoryBase<ArrayNodes.InjectNode> {
        private static InjectNodeFactory injectNodeFactoryInstance;

        private InjectNodeFactory() {
            super(ArrayNodes.InjectNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InjectNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InjectNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.InjectNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InjectUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.InjectNode> getInstance() {
            if (injectNodeFactoryInstance == null) {
                injectNodeFactoryInstance = new InjectNodeFactory();
            }
            return injectNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InjectPolymorphicNode
        extends InjectBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            InjectPolymorphicNode(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == RubySymbol.class ? this.arguments[1].executeRubySymbol(frameValue) : this.arguments[1].execute(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == RubyProc.class ? this.arguments[2].executeRubyProc(frameValue) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InjectRubyArrayRubySymbolUndefinedPlaceholderNode
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectRubyArrayRubySymbolUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubySymbol.class, UndefinedPlaceholder.class}, 0, 0);

            InjectRubyArrayRubySymbolUndefinedPlaceholderNode(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubySymbol arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubySymbol(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof RubySymbol");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.inject(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubySymbol arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubySymbol(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.inject(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(ArrayNodes.InjectNode current2) {
                return new InjectRubyArrayRubySymbolUndefinedPlaceholderNode((InjectBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InjectRubyArrayObjectRubyProc1Node
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectRubyArrayObjectRubyProc1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class, RubyProc.class}, 0, 0);

            InjectRubyArrayObjectRubyProc1Node(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                return super.inject(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    return super.inject(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(ArrayNodes.InjectNode current2) {
                return new InjectRubyArrayObjectRubyProc1Node((InjectBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InjectRubyArrayObjectRubyProc0Node
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectRubyArrayObjectRubyProc0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class, RubyProc.class}, 0, 0);

            InjectRubyArrayObjectRubyProc0Node(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments2Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                try {
                    arguments2Value = this.arguments[2].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.injectObject(frameValue, arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments2Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.injectObject(frameValue, arguments0ValueCast, arguments1Value, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(ArrayNodes.InjectNode current2) {
                return new InjectRubyArrayObjectRubyProc0Node((InjectBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InjectUninitializedNode
        extends InjectBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InjectUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InjectUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InjectUninitializedNode(InjectBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                InjectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InjectBaseNode rootNode = (InjectBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InjectBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.InjectNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InjectUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.InjectNode.class)
        private static abstract class InjectBaseNode
        extends ArrayNodes.InjectNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InjectBaseNode next0;

            InjectBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InjectBaseNode(InjectBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                InjectBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InjectBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new InjectUninitializedNode(this);
                    ((InjectUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InjectBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InjectBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (InjectBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InjectUninitializedNode(this), (Node)new InjectPolymorphicNode(this), (DSLNode)((InjectBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InjectBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isRubyProc(arguments2Value)) {
                        if (ArrayGuards.isObject(arguments0ValueCast)) {
                            return (InjectBaseNode)InjectRubyArrayObjectRubyProc0Node.create0(this);
                        }
                        return (InjectBaseNode)InjectRubyArrayObjectRubyProc1Node.create0(this);
                    }
                    if (RubyTypesGen.RUBYTYPES.isRubySymbol(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        return (InjectBaseNode)InjectRubyArrayRubySymbolUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    InjectBaseNode otherCast = (InjectBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (InjectBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
    public static final class InitializeCopyNodeFactory
    extends NodeFactoryBase<ArrayNodes.InitializeCopyNode> {
        private static InitializeCopyNodeFactory initializeCopyNodeFactoryInstance;

        private InitializeCopyNodeFactory() {
            super(ArrayNodes.InitializeCopyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InitializeCopyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeCopyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.InitializeCopyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeCopyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.InitializeCopyNode> getInstance() {
            if (initializeCopyNodeFactoryInstance == null) {
                initializeCopyNodeFactoryInstance = new InitializeCopyNodeFactory();
            }
            return initializeCopyNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializeCopyPolymorphicNode
        extends InitializeCopyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            InitializeCopyPolymorphicNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyArray4Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            InitializeCopyRubyArray4Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isOtherObject(arguments0Value, arguments1Value)) {
                    return super.initializeCopyObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isOtherObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.isOtherObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.initializeCopyObject(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.InitializeCopyNode create0(ArrayNodes.InitializeCopyNode current2) {
                return new InitializeCopyRubyArray4Node((InitializeCopyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyArray3Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            InitializeCopyRubyArray3Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isOtherFloat(arguments0Value, arguments1Value)) {
                    return super.initializeCopyFloat(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isOtherFloat] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.isOtherFloat(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.initializeCopyFloat(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.InitializeCopyNode create0(ArrayNodes.InitializeCopyNode current2) {
                return new InitializeCopyRubyArray3Node((InitializeCopyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyArray2Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            InitializeCopyRubyArray2Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isOtherLongFixnum(arguments0Value, arguments1Value)) {
                    return super.initializeCopyLongFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isOtherLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.isOtherLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.initializeCopyLongFixnum(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.InitializeCopyNode create0(ArrayNodes.InitializeCopyNode current2) {
                return new InitializeCopyRubyArray2Node((InitializeCopyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyArray1Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            InitializeCopyRubyArray1Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isOtherIntegerFixnum(arguments0Value, arguments1Value)) {
                    return super.initializeCopyIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isOtherIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.isOtherIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.initializeCopyIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.InitializeCopyNode create0(ArrayNodes.InitializeCopyNode current2) {
                return new InitializeCopyRubyArray1Node((InitializeCopyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeCopyRubyArray0Node
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            InitializeCopyRubyArray0Node(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.isOtherNull(arguments0Value, arguments1Value)) {
                    return super.initializeCopyNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isOtherNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.isOtherNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.initializeCopyNull(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.InitializeCopyNode create0(ArrayNodes.InitializeCopyNode current2) {
                return new InitializeCopyRubyArray0Node((InitializeCopyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeCopyUninitializedNode
        extends InitializeCopyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeCopyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeCopyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeCopyUninitializedNode(InitializeCopyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeCopyBaseNode rootNode = (InitializeCopyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeCopyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.InitializeCopyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeCopyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeCopyNode.class)
        private static abstract class InitializeCopyBaseNode
        extends ArrayNodes.InitializeCopyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeCopyBaseNode next0;

            InitializeCopyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeCopyBaseNode(InitializeCopyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                InitializeCopyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeCopyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new InitializeCopyUninitializedNode(this);
                    ((InitializeCopyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeCopyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InitializeCopyBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (InitializeCopyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeCopyUninitializedNode(this), (Node)new InitializeCopyPolymorphicNode(this), (DSLNode)((InitializeCopyBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeCopyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value)) {
                    RubyArray arguments1ValueCast;
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isOtherNull(arguments0ValueCast, arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isOtherIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isOtherLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isOtherFloat(arguments0ValueCast, arguments1ValueCast)) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isOtherObject(arguments0ValueCast, arguments1ValueCast)) {
                        return (InitializeCopyBaseNode)InitializeCopyRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    InitializeCopyBaseNode otherCast = (InitializeCopyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (InitializeCopyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.InitializeNode.class)
    public static final class InitializeNodeFactory
    extends NodeFactoryBase<ArrayNodes.InitializeNode> {
        private static InitializeNodeFactory initializeNodeFactoryInstance;

        private InitializeNodeFactory() {
            super(ArrayNodes.InitializeNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.InitializeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return InitializeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.InitializeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return InitializeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.InitializeNode> getInstance() {
            if (initializeNodeFactoryInstance == null) {
                initializeNodeFactoryInstance = new InitializeNodeFactory();
            }
            return initializeNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class InitializePolymorphicNode
        extends InitializeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;

            InitializePolymorphicNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments3Value;
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[1].executeLongFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyArray.class ? this.arguments[1].executeArray(frameValue) : this.arguments[1].execute(frameValue)));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, arguments3Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : (this.arguments2PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[2].executeLongFixnum(frameValue)) : (this.arguments2PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[2].executeFloat(frameValue)) : this.arguments[2].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value3);
                }
                try {
                    arguments3Value = this.arguments3PolymorphicType == UndefinedPlaceholder.class ? this.arguments[3].executeUndefinedPlaceholder(frameValue) : (this.arguments3PolymorphicType == RubyProc.class ? this.arguments[3].executeRubyProc(frameValue) : this.arguments[3].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments3PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayRubyArrayUndefinedPlaceholderUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayRubyArrayUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayRubyArrayUndefinedPlaceholderUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof RubyArray");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyArray arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current2) {
                return new InitializeRubyArrayRubyArrayUndefinedPlaceholderUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntUndefinedPlaceholderRubyProcNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntUndefinedPlaceholderRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, UndefinedPlaceholder.class, RubyProc.class}, 0, 0);

            InitializeRubyArrayIntUndefinedPlaceholderRubyProcNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments3Value;
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyProc");
                }
                return super.initialize(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    RubyProc arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments3Value);
                    return super.initialize(frameValue, arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current2) {
                return new InitializeRubyArrayIntUndefinedPlaceholderRubyProcNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntObjectUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntObjectUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntObjectUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2Value, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current2) {
                return new InitializeRubyArrayIntObjectUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntDoubleUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntDoubleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Double.TYPE, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntDoubleUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                double arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof double");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    double arguments2ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current2) {
                return new InitializeRubyArrayIntDoubleUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntLongUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntLongUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Long.TYPE, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntLongUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                long arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof long");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isLong(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    long arguments2ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current2) {
                return new InitializeRubyArrayIntLongUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntIntUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntIntUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof int");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current2) {
                return new InitializeRubyArrayIntIntUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Long.TYPE, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                long arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof long");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isLong(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    long arguments1ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current2) {
                return new InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholderNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, UndefinedPlaceholder.class, UndefinedPlaceholder.class}, 0, 0);

            InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholderNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                return super.initialize(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    return super.initialize(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(ArrayNodes.InitializeNode current2) {
                return new InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholderNode((InitializeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class InitializeUninitializedNode
        extends InitializeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(InitializeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            InitializeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            InitializeUninitializedNode(InitializeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    InitializeBaseNode rootNode = (InitializeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3]}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((InitializeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.InitializeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new InitializeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.InitializeNode.class)
        private static abstract class InitializeBaseNode
        extends ArrayNodes.InitializeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected InitializeBaseNode next0;

            InitializeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            InitializeBaseNode(InitializeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, String reason2) {
                String message2;
                InitializeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                InitializeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    newNode = new InitializeUninitializedNode(this);
                    ((InitializeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (InitializeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = InitializeBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value, arguments3Value)))) == null) {
                    returnNode = (InitializeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new InitializeUninitializedNode(this), (Node)new InitializePolymorphicNode(this), (DSLNode)((InitializeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final InitializeBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                                return (InitializeBaseNode)InitializeRubyArrayIntUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isLong(arguments1Value)) {
                                return (InitializeBaseNode)InitializeRubyArrayLongUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                            }
                        }
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                            if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                                return (InitializeBaseNode)InitializeRubyArrayIntIntUndefinedPlaceholderNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isLong(arguments2Value)) {
                                return (InitializeBaseNode)InitializeRubyArrayIntLongUndefinedPlaceholderNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isDouble(arguments2Value)) {
                                return (InitializeBaseNode)InitializeRubyArrayIntDoubleUndefinedPlaceholderNode.create0(this);
                            }
                            return (InitializeBaseNode)InitializeRubyArrayIntObjectUndefinedPlaceholderNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments3Value)) {
                            return (InitializeBaseNode)InitializeRubyArrayIntUndefinedPlaceholderRubyProcNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            return (InitializeBaseNode)InitializeRubyArrayRubyArrayUndefinedPlaceholderUndefinedPlaceholderNode.create0(this);
                        }
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                } else {
                    InitializeBaseNode otherCast = (InitializeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                }
                this.next0 = newNext == null ? null : (InitializeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.IncludeNode.class)
    public static final class IncludeNodeFactory
    extends NodeFactoryBase<ArrayNodes.IncludeNode> {
        private static IncludeNodeFactory includeNodeFactoryInstance;

        private IncludeNodeFactory() {
            super(ArrayNodes.IncludeNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.IncludeNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IncludeNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.IncludeNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IncludeUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.IncludeNode> getInstance() {
            if (includeNodeFactoryInstance == null) {
                includeNodeFactoryInstance = new IncludeNodeFactory();
            }
            return includeNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IncludePolymorphicNode
        extends IncludeBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            IncludePolymorphicNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeRubyArray3Node
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            IncludeRubyArray3Node(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.includeObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.includeObject(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(ArrayNodes.IncludeNode current2) {
                return new IncludeRubyArray3Node((IncludeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeRubyArray2Node
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            IncludeRubyArray2Node(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.includeLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.includeLongFixnum(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(ArrayNodes.IncludeNode current2) {
                return new IncludeRubyArray2Node((IncludeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeRubyArray1Node
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            IncludeRubyArray1Node(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.includeIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.includeIntegerFixnum(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(ArrayNodes.IncludeNode current2) {
                return new IncludeRubyArray1Node((IncludeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IncludeRubyArray0Node
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            IncludeRubyArray0Node(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.includeNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.includeNull(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(ArrayNodes.IncludeNode current2) {
                return new IncludeRubyArray0Node((IncludeBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IncludeUninitializedNode
        extends IncludeBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IncludeUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IncludeUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IncludeUninitializedNode(IncludeBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                IncludeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IncludeBaseNode rootNode = (IncludeBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IncludeBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.IncludeNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IncludeUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.IncludeNode.class)
        private static abstract class IncludeBaseNode
        extends ArrayNodes.IncludeNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IncludeBaseNode next0;

            IncludeBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IncludeBaseNode(IncludeBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                IncludeBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IncludeBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new IncludeUninitializedNode(this);
                    ((IncludeUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IncludeBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = IncludeBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (IncludeBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IncludeUninitializedNode(this), (Node)new IncludePolymorphicNode(this), (DSLNode)((IncludeBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IncludeBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (IncludeBaseNode)IncludeRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (IncludeBaseNode)IncludeRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return (IncludeBaseNode)IncludeRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (IncludeBaseNode)IncludeRubyArray3Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    IncludeBaseNode otherCast = (IncludeBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (IncludeBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.HashNode.class)
    public static final class HashNodeFactory
    extends NodeFactoryBase<ArrayNodes.HashNode> {
        private static HashNodeFactory hashNodeFactoryInstance;

        private HashNodeFactory() {
            super(ArrayNodes.HashNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.HashNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return HashNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.HashNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return HashUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.HashNode> getInstance() {
            if (hashNodeFactoryInstance == null) {
                hashNodeFactoryInstance = new HashNodeFactory();
            }
            return hashNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class HashPolymorphicNode
        extends HashBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            HashPolymorphicNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class HashRubyArrayNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            HashRubyArrayNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.hashNumber(arguments0Value);
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.hashNumber(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.HashNode create0(ArrayNodes.HashNode current2) {
                return new HashRubyArrayNode((HashBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.HashNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class HashUninitializedNode
        extends HashBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(HashUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            HashUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            HashUninitializedNode(HashBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected long executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected long executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                HashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    HashBaseNode rootNode = (HashBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((HashBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.HashNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new HashUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.HashNode.class)
        private static abstract class HashBaseNode
        extends ArrayNodes.HashNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected HashBaseNode next0;

            HashBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            HashBaseNode(HashBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract long executeChained0(VirtualFrame var1, Object var2);

            protected final long rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                HashBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                HashBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new HashUninitializedNode(this);
                    ((HashUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (HashBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = HashBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (HashBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new HashUninitializedNode(this), (Node)new HashPolymorphicNode(this), (DSLNode)((HashBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final HashBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (HashBaseNode)HashRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((HashBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (HashBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.FlattenNode.class)
    public static final class FlattenNodeFactory
    extends NodeFactoryBase<ArrayNodes.FlattenNode> {
        private static FlattenNodeFactory flattenNodeFactoryInstance;

        private FlattenNodeFactory() {
            super(ArrayNodes.FlattenNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.FlattenNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FlattenNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.FlattenNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FlattenUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.FlattenNode> getInstance() {
            if (flattenNodeFactoryInstance == null) {
                flattenNodeFactoryInstance = new FlattenNodeFactory();
            }
            return flattenNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.FlattenNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FlattenPolymorphicNode
        extends FlattenBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            FlattenPolymorphicNode(FlattenBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.FlattenNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FlattenRubyArrayNode
        extends FlattenBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FlattenRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            FlattenRubyArrayNode(FlattenBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.flatten(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.flatten(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.FlattenNode create0(ArrayNodes.FlattenNode current2) {
                return new FlattenRubyArrayNode((FlattenBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.FlattenNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FlattenUninitializedNode
        extends FlattenBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FlattenUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FlattenUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FlattenUninitializedNode(FlattenBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                FlattenBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FlattenBaseNode rootNode = (FlattenBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((FlattenBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.FlattenNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FlattenUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.FlattenNode.class)
        private static abstract class FlattenBaseNode
        extends ArrayNodes.FlattenNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FlattenBaseNode next0;

            FlattenBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FlattenBaseNode(FlattenBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                FlattenBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FlattenBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new FlattenUninitializedNode(this);
                    ((FlattenUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (FlattenBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = FlattenBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (FlattenBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FlattenUninitializedNode(this), (Node)new FlattenPolymorphicNode(this), (DSLNode)((FlattenBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FlattenBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (FlattenBaseNode)FlattenRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((FlattenBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (FlattenBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.FirstNode.class)
    public static final class FirstNodeFactory
    extends NodeFactoryBase<ArrayNodes.FirstNode> {
        private static FirstNodeFactory firstNodeFactoryInstance;

        private FirstNodeFactory() {
            super(ArrayNodes.FirstNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.FirstNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FirstNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.FirstNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FirstUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.FirstNode> getInstance() {
            if (firstNodeFactoryInstance == null) {
                firstNodeFactoryInstance = new FirstNodeFactory();
            }
            return firstNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.FirstNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FirstPolymorphicNode
        extends FirstBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            FirstPolymorphicNode(FirstBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.FirstNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FirstObject1Node
        extends FirstBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FirstObject1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            FirstObject1Node(FirstBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.firstObject(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.firstObject(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.FirstNode create0(ArrayNodes.FirstNode current2) {
                return new FirstObject1Node((FirstBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.FirstNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FirstObject0Node
        extends FirstBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FirstObject0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            FirstObject0Node(FirstBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.firstIntegerFixnum(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.firstIntegerFixnum(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.FirstNode create0(ArrayNodes.FirstNode current2) {
                return new FirstObject0Node((FirstBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.FirstNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FirstRubyNilClassNode
        extends FirstBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FirstRubyNilClassNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            FirstRubyNilClassNode(FirstBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyNilClass value2;
                try {
                    value2 = this.executeRubyNilClass(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyNilClass executeRubyNilClass(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray"));
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.firstNull(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.rewrite0(frameValue, arguments0Value, "One of guards [isNull] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.firstNull(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.FirstNode create0(ArrayNodes.FirstNode current2) {
                return new FirstRubyNilClassNode((FirstBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.FirstNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FirstUninitializedNode
        extends FirstBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FirstUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FirstUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FirstUninitializedNode(FirstBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                FirstBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FirstBaseNode rootNode = (FirstBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((FirstBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.FirstNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FirstUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.FirstNode.class)
        private static abstract class FirstBaseNode
        extends ArrayNodes.FirstNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FirstBaseNode next0;

            FirstBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FirstBaseNode(FirstBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                FirstBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FirstBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new FirstUninitializedNode(this);
                    ((FirstUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (FirstBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = FirstBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (FirstBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FirstUninitializedNode(this), (Node)new FirstPolymorphicNode(this), (DSLNode)((FirstBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FirstBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (FirstBaseNode)FirstRubyNilClassNode.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (FirstBaseNode)FirstObject0Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (FirstBaseNode)FirstObject1Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((FirstBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (FirstBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.FindNode.class)
    public static final class FindNodeFactory
    extends NodeFactoryBase<ArrayNodes.FindNode> {
        private static FindNodeFactory findNodeFactoryInstance;

        private FindNodeFactory() {
            super(ArrayNodes.FindNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.FindNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return FindNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.FindNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return FindUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.FindNode> getInstance() {
            if (findNodeFactoryInstance == null) {
                findNodeFactoryInstance = new FindNodeFactory();
            }
            return findNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.FindNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class FindPolymorphicNode
        extends FindBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            FindPolymorphicNode(FindBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.FindNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FindRubyArray4Node
        extends FindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FindRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            FindRubyArray4Node(FindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.findObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.findObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.FindNode create0(ArrayNodes.FindNode current2) {
                return new FindRubyArray4Node((FindBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.FindNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FindRubyArray3Node
        extends FindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FindRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            FindRubyArray3Node(FindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.findFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.findFloat(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.FindNode create0(ArrayNodes.FindNode current2) {
                return new FindRubyArray3Node((FindBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.FindNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FindRubyArray2Node
        extends FindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FindRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            FindRubyArray2Node(FindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.findLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.findLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.FindNode create0(ArrayNodes.FindNode current2) {
                return new FindRubyArray2Node((FindBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.FindNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FindRubyArray1Node
        extends FindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FindRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            FindRubyArray1Node(FindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.findIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.findIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.FindNode create0(ArrayNodes.FindNode current2) {
                return new FindRubyArray1Node((FindBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.FindNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class FindRubyArray0Node
        extends FindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FindRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            FindRubyArray0Node(FindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.findNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.findNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.FindNode create0(ArrayNodes.FindNode current2) {
                return new FindRubyArray0Node((FindBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.FindNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class FindUninitializedNode
        extends FindBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(FindUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            FindUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            FindUninitializedNode(FindBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                FindBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    FindBaseNode rootNode = (FindBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((FindBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.FindNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new FindUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.FindNode.class)
        private static abstract class FindBaseNode
        extends ArrayNodes.FindNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected FindBaseNode next0;

            FindBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            FindBaseNode(FindBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                FindBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                FindBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new FindUninitializedNode(this);
                    ((FindUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (FindBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = FindBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (FindBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new FindUninitializedNode(this), (Node)new FindPolymorphicNode(this), (DSLNode)((FindBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final FindBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (FindBaseNode)FindRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (FindBaseNode)FindRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return (FindBaseNode)FindRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return (FindBaseNode)FindRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (FindBaseNode)FindRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    FindBaseNode otherCast = (FindBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (FindBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.EmptyNode.class)
    public static final class EmptyNodeFactory
    extends NodeFactoryBase<ArrayNodes.EmptyNode> {
        private static EmptyNodeFactory emptyNodeFactoryInstance;

        private EmptyNodeFactory() {
            super(ArrayNodes.EmptyNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.EmptyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EmptyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.EmptyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EmptyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.EmptyNode> getInstance() {
            if (emptyNodeFactoryInstance == null) {
                emptyNodeFactoryInstance = new EmptyNodeFactory();
            }
            return emptyNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EmptyPolymorphicNode
        extends EmptyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            EmptyPolymorphicNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EmptyRubyArrayNode
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            EmptyRubyArrayNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.isEmpty(arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.isEmpty(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.EmptyNode create0(ArrayNodes.EmptyNode current2) {
                return new EmptyRubyArrayNode((EmptyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.EmptyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EmptyUninitializedNode
        extends EmptyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EmptyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EmptyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EmptyUninitializedNode(EmptyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EmptyBaseNode rootNode = (EmptyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EmptyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.EmptyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EmptyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.EmptyNode.class)
        private static abstract class EmptyBaseNode
        extends ArrayNodes.EmptyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EmptyBaseNode next0;

            EmptyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EmptyBaseNode(EmptyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                EmptyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EmptyBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new EmptyUninitializedNode(this);
                    ((EmptyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EmptyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EmptyBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (EmptyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EmptyUninitializedNode(this), (Node)new EmptyPolymorphicNode(this), (DSLNode)((EmptyBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EmptyBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (EmptyBaseNode)EmptyRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((EmptyBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (EmptyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
    public static final class EachWithIndexNodeFactory
    extends NodeFactoryBase<ArrayNodes.EachWithIndexNode> {
        private static EachWithIndexNodeFactory eachWithIndexNodeFactoryInstance;

        private EachWithIndexNodeFactory() {
            super(ArrayNodes.EachWithIndexNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.EachWithIndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachWithIndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.EachWithIndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachWithIndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.EachWithIndexNode> getInstance() {
            if (eachWithIndexNodeFactoryInstance == null) {
                eachWithIndexNodeFactoryInstance = new EachWithIndexNodeFactory();
            }
            return eachWithIndexNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachWithIndexPolymorphicNode
        extends EachWithIndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachWithIndexPolymorphicNode(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachWithIndexObjectRubyProcNode
        extends EachWithIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachWithIndexObjectRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachWithIndexObjectRubyProcNode(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.eachWithIndexObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.eachWithIndexObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachWithIndexNode create0(ArrayNodes.EachWithIndexNode current2) {
                return new EachWithIndexObjectRubyProcNode((EachWithIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachWithIndexRubyArrayRubyProcNode
        extends EachWithIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachWithIndexRubyArrayRubyProcNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachWithIndexRubyArrayRubyProcNode(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc"));
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.eachWithEmpty(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.eachWithEmpty(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachWithIndexNode create0(ArrayNodes.EachWithIndexNode current2) {
                return new EachWithIndexRubyArrayRubyProcNode((EachWithIndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachWithIndexUninitializedNode
        extends EachWithIndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachWithIndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachWithIndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachWithIndexUninitializedNode(EachWithIndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachWithIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachWithIndexBaseNode rootNode = (EachWithIndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachWithIndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachWithIndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachWithIndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachWithIndexNode.class)
        private static abstract class EachWithIndexBaseNode
        extends ArrayNodes.EachWithIndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachWithIndexBaseNode next0;

            EachWithIndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachWithIndexBaseNode(EachWithIndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EachWithIndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachWithIndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachWithIndexUninitializedNode(this);
                    ((EachWithIndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachWithIndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EachWithIndexBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachWithIndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachWithIndexUninitializedNode(this), (Node)new EachWithIndexPolymorphicNode(this), (DSLNode)((EachWithIndexBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachWithIndexBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (EachWithIndexBaseNode)EachWithIndexRubyArrayRubyProcNode.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (EachWithIndexBaseNode)EachWithIndexObjectRubyProcNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachWithIndexBaseNode otherCast = (EachWithIndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachWithIndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.EachNode.class)
    public static final class EachNodeFactory
    extends NodeFactoryBase<ArrayNodes.EachNode> {
        private static EachNodeFactory eachNodeFactoryInstance;

        private EachNodeFactory() {
            super(ArrayNodes.EachNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.EachNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return EachNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.EachNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return EachUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.EachNode> getInstance() {
            if (eachNodeFactoryInstance == null) {
                eachNodeFactoryInstance = new EachNodeFactory();
            }
            return eachNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class EachPolymorphicNode
        extends EachBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            EachPolymorphicNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArray4Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachRubyArray4Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.eachObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.eachObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current2) {
                return new EachRubyArray4Node((EachBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArray3Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachRubyArray3Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.eachFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.eachFloat(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current2) {
                return new EachRubyArray3Node((EachBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArray2Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachRubyArray2Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.eachLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.eachLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current2) {
                return new EachRubyArray2Node((EachBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArray1Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachRubyArray1Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.eachIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.eachIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current2) {
                return new EachRubyArray1Node((EachBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class EachRubyArray0Node
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            EachRubyArray0Node(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.eachNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.eachNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(ArrayNodes.EachNode current2) {
                return new EachRubyArray0Node((EachBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class EachUninitializedNode
        extends EachBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(EachUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            EachUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            EachUninitializedNode(EachBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    EachBaseNode rootNode = (EachBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((EachBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.EachNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new EachUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.EachNode.class)
        private static abstract class EachBaseNode
        extends ArrayNodes.EachNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected EachBaseNode next0;

            EachBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            EachBaseNode(EachBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                EachBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                EachBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new EachUninitializedNode(this);
                    ((EachUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (EachBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = EachBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (EachBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new EachUninitializedNode(this), (Node)new EachPolymorphicNode(this), (DSLNode)((EachBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final EachBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (EachBaseNode)EachRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (EachBaseNode)EachRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return (EachBaseNode)EachRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return (EachBaseNode)EachRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (EachBaseNode)EachRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    EachBaseNode otherCast = (EachBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (EachBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
    public static final class DeleteAtNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteAtNode> {
        private static DeleteAtNodeFactory deleteAtNodeFactoryInstance;

        private DeleteAtNodeFactory() {
            super(ArrayNodes.DeleteAtNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.DeleteAtNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteAtNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.DeleteAtNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DeleteAtUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.DeleteAtNode> getInstance() {
            if (deleteAtNodeFactoryInstance == null) {
                deleteAtNodeFactoryInstance = new DeleteAtNodeFactory();
            }
            return deleteAtNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DeleteAtPolymorphicNode
        extends DeleteAtBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DeleteAtPolymorphicNode(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtObjectIntNode
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtObjectIntNode.class, new Class[]{DeleteAtIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtObjectIntNode(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.deleteAtIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.deleteAtIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current2) {
                return new DeleteAtObjectIntNode((DeleteAtBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteAtIntNode
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{DeleteAtObjectIntNode.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            DeleteAtIntNode(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    try {
                        return super.deleteAtIntegerFixnumInBounds(arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        try {
                            return super.deleteAtIntegerFixnumInBounds(arguments0ValueCast, arguments1ValueCast);
                        }
                        catch (UnexpectedResultException rewriteEx) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            return this.rewrite0(frameValue, arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                        }
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteAtNode create0(ArrayNodes.DeleteAtNode current2) {
                return new DeleteAtIntNode((DeleteAtBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DeleteAtUninitializedNode
        extends DeleteAtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteAtUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DeleteAtUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DeleteAtUninitializedNode(DeleteAtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DeleteAtBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DeleteAtBaseNode rootNode = (DeleteAtBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DeleteAtBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteAtNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DeleteAtUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteAtNode.class)
        private static abstract class DeleteAtBaseNode
        extends ArrayNodes.DeleteAtNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DeleteAtBaseNode next0;

            DeleteAtBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DeleteAtBaseNode(DeleteAtBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                DeleteAtBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DeleteAtBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DeleteAtUninitializedNode(this);
                    ((DeleteAtUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DeleteAtBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DeleteAtBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DeleteAtBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DeleteAtUninitializedNode(this), (Node)new DeleteAtPolymorphicNode(this), (DSLNode)((DeleteAtBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DeleteAtBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    if (!DSLShare.isExcluded((Node)this, (DSLMetadata)DeleteAtIntNode.METADATA)) {
                        return (DeleteAtBaseNode)DeleteAtIntNode.create0(this);
                    }
                    return (DeleteAtBaseNode)DeleteAtObjectIntNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DeleteAtBaseNode otherCast = (DeleteAtBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DeleteAtBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.DeleteNode.class)
    public static final class DeleteNodeFactory
    extends NodeFactoryBase<ArrayNodes.DeleteNode> {
        private static DeleteNodeFactory deleteNodeFactoryInstance;

        private DeleteNodeFactory() {
            super(ArrayNodes.DeleteNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.DeleteNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return DeleteNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.DeleteNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return DeleteUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.DeleteNode> getInstance() {
            if (deleteNodeFactoryInstance == null) {
                deleteNodeFactoryInstance = new DeleteNodeFactory();
            }
            return deleteNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class DeletePolymorphicNode
        extends DeleteBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            DeletePolymorphicNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteRubyArray1Node
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            DeleteRubyArray1Node(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.deleteObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.deleteObject(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteNode create0(ArrayNodes.DeleteNode current2) {
                return new DeleteRubyArray1Node((DeleteBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class DeleteRubyArray0Node
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Object.class}, 0, 0);

            DeleteRubyArray0Node(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value, "Expected arguments0Value instanceof RubyArray");
                }
                Object arguments1Value = this.arguments[1].execute(frameValue);
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.deleteIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.deleteIntegerFixnum(frameValue, arguments0ValueCast, arguments1Value);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteNode create0(ArrayNodes.DeleteNode current2) {
                return new DeleteRubyArray0Node((DeleteBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class DeleteUninitializedNode
        extends DeleteBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(DeleteUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            DeleteUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            DeleteUninitializedNode(DeleteBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                DeleteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    DeleteBaseNode rootNode = (DeleteBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((DeleteBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.DeleteNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new DeleteUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.DeleteNode.class)
        private static abstract class DeleteBaseNode
        extends ArrayNodes.DeleteNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected DeleteBaseNode next0;

            DeleteBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            DeleteBaseNode(DeleteBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                DeleteBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                DeleteBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new DeleteUninitializedNode(this);
                    ((DeleteUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (DeleteBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = DeleteBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (DeleteBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new DeleteUninitializedNode(this), (Node)new DeletePolymorphicNode(this), (DSLNode)((DeleteBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final DeleteBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (DeleteBaseNode)DeleteRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (DeleteBaseNode)DeleteRubyArray1Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    DeleteBaseNode otherCast = (DeleteBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (DeleteBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ConcatNode.class)
    public static final class ConcatNodeFactory
    extends NodeFactoryBase<ArrayNodes.ConcatNode> {
        private static ConcatNodeFactory concatNodeFactoryInstance;

        private ConcatNodeFactory() {
            super(ArrayNodes.ConcatNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ConcatNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ConcatNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ConcatNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ConcatUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.ConcatNode> getInstance() {
            if (concatNodeFactoryInstance == null) {
                concatNodeFactoryInstance = new ConcatNodeFactory();
            }
            return concatNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ConcatPolymorphicNode
        extends ConcatBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            ConcatPolymorphicNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyArray5Node
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyArray5Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ConcatRubyArray5Node(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                return super.concat(arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyArray arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value);
                    return super.concat(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ConcatNode create0(ArrayNodes.ConcatNode current2) {
                return new ConcatRubyArray5Node((ConcatBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyArray4Node
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ConcatRubyArray4Node(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.areBothObject(arguments0Value, arguments1Value)) {
                    return super.concatObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [areBothObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.areBothObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.concatObject(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ConcatNode create0(ArrayNodes.ConcatNode current2) {
                return new ConcatRubyArray4Node((ConcatBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyArray3Node
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ConcatRubyArray3Node(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.areBothFloat(arguments0Value, arguments1Value)) {
                    return super.concatDouble(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [areBothFloat] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.areBothFloat(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.concatDouble(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ConcatNode create0(ArrayNodes.ConcatNode current2) {
                return new ConcatRubyArray3Node((ConcatBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyArray2Node
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ConcatRubyArray2Node(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.areBothLongFixnum(arguments0Value, arguments1Value)) {
                    return super.concatLongFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [areBothLongFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.areBothLongFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.concatLongFixnum(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ConcatNode create0(ArrayNodes.ConcatNode current2) {
                return new ConcatRubyArray2Node((ConcatBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyArray1Node
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ConcatRubyArray1Node(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.areBothIntegerFixnum(arguments0Value, arguments1Value)) {
                    return super.concatIntegerFixnum(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [areBothIntegerFixnum] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.areBothIntegerFixnum(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.concatIntegerFixnum(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ConcatNode create0(ArrayNodes.ConcatNode current2) {
                return new ConcatRubyArray1Node((ConcatBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ConcatRubyArray0Node
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyArray.class}, 0, 0);

            ConcatRubyArray0Node(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyArray");
                }
                if (ArrayGuards.areBothNull(arguments0Value, arguments1Value)) {
                    return super.concatNull(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [areBothNull] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                RubyArray arguments1ValueCast;
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value) && ArrayGuards.areBothNull(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value), arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                    return super.concatNull(arguments0ValueCast, arguments1ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ConcatNode create0(ArrayNodes.ConcatNode current2) {
                return new ConcatRubyArray0Node((ConcatBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ConcatUninitializedNode
        extends ConcatBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ConcatUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ConcatUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ConcatUninitializedNode(ConcatBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                ConcatBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ConcatBaseNode rootNode = (ConcatBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ConcatBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.ConcatNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ConcatUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.ConcatNode.class)
        private static abstract class ConcatBaseNode
        extends ArrayNodes.ConcatNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ConcatBaseNode next0;

            ConcatBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ConcatBaseNode(ConcatBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                ConcatBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ConcatBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new ConcatUninitializedNode(this);
                    ((ConcatUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ConcatBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ConcatBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (ConcatBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ConcatUninitializedNode(this), (Node)new ConcatPolymorphicNode(this), (DSLNode)((ConcatBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ConcatBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments1Value)) {
                    RubyArray arguments1ValueCast;
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.areBothNull(arguments0ValueCast, arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments1Value))) {
                        return (ConcatBaseNode)ConcatRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.areBothIntegerFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return (ConcatBaseNode)ConcatRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.areBothLongFixnum(arguments0ValueCast, arguments1ValueCast)) {
                        return (ConcatBaseNode)ConcatRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.areBothFloat(arguments0ValueCast, arguments1ValueCast)) {
                        return (ConcatBaseNode)ConcatRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.areBothObject(arguments0ValueCast, arguments1ValueCast)) {
                        return (ConcatBaseNode)ConcatRubyArray4Node.create0(this);
                    }
                    return (ConcatBaseNode)ConcatRubyArray5Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    ConcatBaseNode otherCast = (ConcatBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (ConcatBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.CompactNode.class)
    public static final class CompactNodeFactory
    extends NodeFactoryBase<ArrayNodes.CompactNode> {
        private static CompactNodeFactory compactNodeFactoryInstance;

        private CompactNodeFactory() {
            super(ArrayNodes.CompactNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.CompactNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return CompactNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.CompactNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return CompactUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.CompactNode> getInstance() {
            if (compactNodeFactoryInstance == null) {
                compactNodeFactoryInstance = new CompactNodeFactory();
            }
            return compactNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.CompactNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class CompactPolymorphicNode
        extends CompactBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            CompactPolymorphicNode(CompactBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.CompactNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompactRubyArray1Node
        extends CompactBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompactRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            CompactRubyArray1Node(CompactBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.compatObjects(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [isObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.compatObjects(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.CompactNode create0(ArrayNodes.CompactNode current2) {
                return new CompactRubyArray1Node((CompactBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.CompactNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class CompactRubyArray0Node
        extends CompactBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompactRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            CompactRubyArray0Node(CompactBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                if (!ArrayGuards.isObject(arguments0Value)) {
                    return super.compatNotObjects(arguments0Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, "One of guards [!isObject] failed");
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                RubyArray arguments0ValueCast;
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && !ArrayGuards.isObject(arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value))) {
                    return super.compatNotObjects(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.CompactNode create0(ArrayNodes.CompactNode current2) {
                return new CompactRubyArray0Node((CompactBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.CompactNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class CompactUninitializedNode
        extends CompactBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(CompactUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            CompactUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            CompactUninitializedNode(CompactBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                CompactBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    CompactBaseNode rootNode = (CompactBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((CompactBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.CompactNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new CompactUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.CompactNode.class)
        private static abstract class CompactBaseNode
        extends ArrayNodes.CompactNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected CompactBaseNode next0;

            CompactBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            CompactBaseNode(CompactBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                CompactBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                CompactBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new CompactUninitializedNode(this);
                    ((CompactUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (CompactBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = CompactBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (CompactBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new CompactUninitializedNode(this), (Node)new CompactPolymorphicNode(this), (DSLNode)((CompactBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final CompactBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (!ArrayGuards.isObject(arguments0ValueCast)) {
                        return (CompactBaseNode)CompactRubyArray0Node.create0(this);
                    }
                    return (CompactBaseNode)CompactRubyArray1Node.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((CompactBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (CompactBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.ClearNode.class)
    public static final class ClearNodeFactory
    extends NodeFactoryBase<ArrayNodes.ClearNode> {
        private static ClearNodeFactory clearNodeFactoryInstance;

        private ClearNodeFactory() {
            super(ArrayNodes.ClearNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.ClearNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return ClearNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.ClearNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return ClearUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.ClearNode> getInstance() {
            if (clearNodeFactoryInstance == null) {
                clearNodeFactoryInstance = new ClearNodeFactory();
            }
            return clearNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class ClearPolymorphicNode
        extends ClearBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;

            ClearPolymorphicNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                return this.next0.executeChained0(frameValue, arguments0Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class ClearRubyArrayNode
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

            ClearRubyArrayNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, ex.getResult(), "Expected arguments0Value instanceof RubyArray");
                }
                return super.clear(arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    return super.clear(arguments0ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.ClearNode create0(ArrayNodes.ClearNode current2) {
                return new ClearRubyArrayNode((ClearBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.ClearNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class ClearUninitializedNode
        extends ClearBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(ClearUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            ClearUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            ClearUninitializedNode(ClearBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            @Override
            protected RubyArray executeChained0(VirtualFrame frameValue, Object arguments0Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value);
            }

            protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arguments0Value) {
                ClearBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    ClearBaseNode rootNode = (ClearBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0]}, new Object[]{arguments0Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((ClearBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value);
            }

            static ArrayNodes.ClearNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new ClearUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.ClearNode.class)
        private static abstract class ClearBaseNode
        extends ArrayNodes.ClearNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected ClearBaseNode next0;

            ClearBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            ClearBaseNode(ClearBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

            protected final RubyArray rewrite0(VirtualFrame frameValue, Object arguments0Value, String reason2) {
                String message2;
                ClearBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                ClearBaseNode newNode = this.specialize0(arguments0Value);
                if (newNode == null) {
                    newNode = new ClearUninitializedNode(this);
                    ((ClearUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (ClearBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ClearBaseNode.createInfo0(reason2, arguments0Value)))) == null) {
                    returnNode = (ClearBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ClearUninitializedNode(this), (Node)new ClearPolymorphicNode(this), (DSLNode)((ClearBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final ClearBaseNode specialize0(Object arguments0Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    return (ClearBaseNode)ClearRubyArrayNode.create0(this);
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                this.arguments[0] = other == null ? null : ((ClearBaseNode)other).arguments[0];
                this.next0 = newNext == null ? null : (ClearBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.AnyNode.class)
    public static final class AnyNodeFactory
    extends NodeFactoryBase<ArrayNodes.AnyNode> {
        private static AnyNodeFactory anyNodeFactoryInstance;

        private AnyNodeFactory() {
            super(ArrayNodes.AnyNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.AnyNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AnyNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.AnyNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AnyUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.AnyNode> getInstance() {
            if (anyNodeFactoryInstance == null) {
                anyNodeFactoryInstance = new AnyNodeFactory();
            }
            return anyNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.AnyNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AnyPolymorphicNode
        extends AnyBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AnyPolymorphicNode(AnyBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.AnyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AnyRubyArray4Node
        extends AnyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AnyRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            AnyRubyArray4Node(AnyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.anyObject(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.anyObject(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.AnyNode create0(ArrayNodes.AnyNode current2) {
                return new AnyRubyArray4Node((AnyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.AnyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AnyRubyArray3Node
        extends AnyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AnyRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            AnyRubyArray3Node(AnyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.anyFloat(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.anyFloat(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.AnyNode create0(ArrayNodes.AnyNode current2) {
                return new AnyRubyArray3Node((AnyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.AnyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AnyRubyArray2Node
        extends AnyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AnyRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            AnyRubyArray2Node(AnyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.anyLongFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.anyLongFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.AnyNode create0(ArrayNodes.AnyNode current2) {
                return new AnyRubyArray2Node((AnyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.AnyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AnyRubyArray1Node
        extends AnyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AnyRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            AnyRubyArray1Node(AnyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.allIntegerFixnum(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.allIntegerFixnum(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.AnyNode create0(ArrayNodes.AnyNode current2) {
                return new AnyRubyArray1Node((AnyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.AnyNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AnyRubyArray0Node
        extends AnyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AnyRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyProc.class}, 0, 0);

            AnyRubyArray0Node(AnyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyProc arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeRubyProc(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), "Expected arguments1Value instanceof RubyProc");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.anyNull(frameValue, arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, "One of guards [isNull] failed");
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyProc arguments1ValueCast = RubyTypesGen.RUBYTYPES.asRubyProc(arguments1Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.anyNull(frameValue, arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.AnyNode create0(ArrayNodes.AnyNode current2) {
                return new AnyRubyArray0Node((AnyBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.AnyNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class AnyUninitializedNode
        extends AnyBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AnyUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            AnyUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            AnyUninitializedNode(AnyBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                boolean value2;
                try {
                    value2 = this.executeBoolean(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public boolean executeBoolean(VirtualFrame frameValue) throws UnexpectedResultException {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            @Override
            protected boolean executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value);
            }

            protected boolean executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value) {
                AnyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    AnyBaseNode rootNode = (AnyBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1]}, new Object[]{arguments0Value, arguments1Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((AnyBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            static ArrayNodes.AnyNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new AnyUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.AnyNode.class)
        private static abstract class AnyBaseNode
        extends ArrayNodes.AnyNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected AnyBaseNode next0;

            AnyBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            AnyBaseNode(AnyBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract boolean executeChained0(VirtualFrame var1, Object var2, Object var3);

            protected final boolean rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, String reason2) {
                String message2;
                AnyBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                AnyBaseNode newNode = this.specialize0(arguments0Value, arguments1Value);
                if (newNode == null) {
                    newNode = new AnyUninitializedNode(this);
                    ((AnyUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (AnyBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = AnyBaseNode.createInfo0(reason2, arguments0Value, arguments1Value)))) == null) {
                    returnNode = (AnyBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new AnyUninitializedNode(this), (Node)new AnyPolymorphicNode(this), (DSLNode)((AnyBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final AnyBaseNode specialize0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isRubyProc(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return (AnyBaseNode)AnyRubyArray0Node.create0(this);
                    }
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (AnyBaseNode)AnyRubyArray1Node.create0(this);
                    }
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return (AnyBaseNode)AnyRubyArray2Node.create0(this);
                    }
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return (AnyBaseNode)AnyRubyArray3Node.create0(this);
                    }
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return (AnyBaseNode)AnyRubyArray4Node.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                } else {
                    AnyBaseNode otherCast = (AnyBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                }
                this.next0 = newNext == null ? null : (AnyBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
    public static final class IndexSetNodeFactory
    extends NodeFactoryBase<ArrayNodes.IndexSetNode> {
        private static IndexSetNodeFactory indexSetNodeFactoryInstance;

        private IndexSetNodeFactory() {
            super(ArrayNodes.IndexSetNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.IndexSetNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IndexSetNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.IndexSetNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IndexSetUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.IndexSetNode> getInstance() {
            if (indexSetNodeFactoryInstance == null) {
                indexSetNodeFactoryInstance = new IndexSetNodeFactory();
            }
            return indexSetNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IndexSetPolymorphicNode
        extends IndexSetBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments3PolymorphicType;

            IndexSetPolymorphicNode(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments3Value;
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[1].executeIntegerFixnumRange(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2, arguments3Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : (this.arguments2PolymorphicType == Long.TYPE ? Long.valueOf(this.arguments[2].executeLongFixnum(frameValue)) : (this.arguments2PolymorphicType == Double.TYPE ? Double.valueOf(this.arguments[2].executeFloat(frameValue)) : (this.arguments2PolymorphicType == RubyArray.class ? this.arguments[2].executeArray(frameValue) : this.arguments[2].execute(frameValue))));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value3);
                }
                try {
                    arguments3Value = this.arguments3PolymorphicType == UndefinedPlaceholder.class ? this.arguments[3].executeUndefinedPlaceholder(frameValue) : (this.arguments3PolymorphicType == RubyArray.class ? this.arguments[3].executeArray(frameValue) : this.arguments[3].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments3PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
                this.arguments3PolymorphicType = types[3];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetRubyArrayIntegerFixnumRangeRubyArrayUndefinedPlaceholderNode
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetRubyArrayIntegerFixnumRangeRubyArrayUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyRange.IntegerFixnumRange.class, RubyArray.class, UndefinedPlaceholder.class}, 0, 0);

            IndexSetRubyArrayIntegerFixnumRangeRubyArrayUndefinedPlaceholderNode(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                RubyArray arguments2Value;
                RubyRange.IntegerFixnumRange arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof IntegerFixnumRange"));
                }
                try {
                    arguments2Value = this.arguments[2].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof RubyArray"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.setIntegerFixnumRange(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyRange.IntegerFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments1Value);
                    RubyArray arguments2ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.setIntegerFixnumRange(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetRubyArrayIntegerFixnumRangeRubyArrayUndefinedPlaceholderNode((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetObjectIntIntObjectNode
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetObjectIntIntObjectNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE, Object.class}, 0, 0);

            IndexSetObjectIntIntObjectNode(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value, "Expected arguments2Value instanceof int");
                }
                Object arguments3Value = this.arguments[3].execute(frameValue);
                if (ArrayGuards.isObject(arguments0Value) && !super.isRubyArray(arguments3Value)) {
                    return super.setObject(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isObject, !isRubyArray] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && !super.isRubyArray(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.setObject(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3Value);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetObjectIntIntObjectNode((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetObjectIntObjectUndefinedPlaceholder1Node
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetObjectIntObjectUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class, UndefinedPlaceholder.class}, 0, 0);

            IndexSetObjectIntObjectUndefinedPlaceholder1Node(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments3Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.setObject(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.setObject(arguments0ValueCast, arguments1ValueCast, arguments2Value, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetObjectIntObjectUndefinedPlaceholder1Node((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetDoubleIntDoubleUndefinedPlaceholderNode
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetDoubleIntDoubleUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Double.TYPE, UndefinedPlaceholder.class}, 0, 0);

            IndexSetDoubleIntDoubleUndefinedPlaceholderNode(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                double arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof double"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.setFloat(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isFloat] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isDouble(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    double arguments2ValueCast = RubyTypesGen.RUBYTYPES.asDouble(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.setFloat(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetDoubleIntDoubleUndefinedPlaceholderNode((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetLongIntLongUndefinedPlaceholder1Node
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetLongIntLongUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Long.TYPE, UndefinedPlaceholder.class}, 0, 0);

            IndexSetLongIntLongUndefinedPlaceholder1Node(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                long arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof long"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.setLongFixnum(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isLongFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isLong(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    long arguments2ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.setLongFixnum(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetLongIntLongUndefinedPlaceholder1Node((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetIntIntIntUndefinedPlaceholder1Node
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetIntIntIntUndefinedPlaceholder1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            IndexSetIntIntIntUndefinedPlaceholder1Node(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof int"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.setLongFixnum(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isLongFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.setLongFixnum(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetIntIntIntUndefinedPlaceholder1Node((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetRubyArrayIntIntRubyArrayNode
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetRubyArrayIntIntRubyArrayNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE, RubyArray.class}, 0, 0);

            IndexSetRubyArrayIntIntRubyArrayNode(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                RubyArray value2;
                try {
                    value2 = this.executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
                RubyArray arguments3Value;
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof int"));
                }
                try {
                    arguments3Value = this.arguments[3].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof RubyArray"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.setIntegerFixnum(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectRubyArray(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    RubyArray arguments3ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments3Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.setIntegerFixnum(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetRubyArrayIntIntRubyArrayNode((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetLongIntLongUndefinedPlaceholder0Node
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetLongIntLongUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Long.TYPE, UndefinedPlaceholder.class}, 0, 0);

            IndexSetLongIntLongUndefinedPlaceholder0Node(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                long value2;
                try {
                    value2 = this.executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public long executeLongFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                long arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof long"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.setLongInIntegerFixnum(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectLong(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isLong(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    long arguments2ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.setLongInIntegerFixnum(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetLongIntLongUndefinedPlaceholder0Node((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetIntIntIntUndefinedPlaceholder0Node
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetIntIntIntUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            IndexSetIntIntIntUndefinedPlaceholder0Node(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int value2;
                try {
                    value2 = this.executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public int executeIntegerFixnum(VirtualFrame frameValue) throws UnexpectedResultException {
                UndefinedPlaceholder arguments3Value;
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int"));
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof int"));
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder"));
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.setIntegerFixnum(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectInteger(this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isIntegerFixnum] failed"));
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.setIntegerFixnum(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetIntIntIntUndefinedPlaceholder0Node((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetObjectIntObjectUndefinedPlaceholder0Node
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetObjectIntObjectUndefinedPlaceholder0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Object.class, UndefinedPlaceholder.class}, 0, 0);

            IndexSetObjectIntObjectUndefinedPlaceholder0Node(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments3Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                Object arguments2Value = this.arguments[2].execute(frameValue);
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.setNullObject(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.setNullObject(arguments0ValueCast, arguments1ValueCast, arguments2Value, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetObjectIntObjectUndefinedPlaceholder0Node((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetObjectIntLongUndefinedPlaceholderNode
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetObjectIntLongUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Long.TYPE, UndefinedPlaceholder.class}, 0, 0);

            IndexSetObjectIntLongUndefinedPlaceholderNode(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments3Value;
                long arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeLongFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof long");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.setNullLongFixnum(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isLong(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    long arguments2ValueCast = RubyTypesGen.RUBYTYPES.asLong(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.setNullLongFixnum(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetObjectIntLongUndefinedPlaceholderNode((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexSetObjectIntIntUndefinedPlaceholderNode
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetObjectIntIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            IndexSetObjectIntIntUndefinedPlaceholderNode(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments3Value;
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    Object arguments3Value2 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, arguments3Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    Object arguments3Value3 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, arguments3Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments3Value4 = this.arguments[3].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), arguments3Value4, "Expected arguments2Value instanceof int");
                }
                try {
                    arguments3Value = this.arguments[3].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, ex.getResult(), "Expected arguments3Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isNull(arguments0Value)) {
                    return super.setNullIntegerFixnum(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value, "One of guards [isNull] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    UndefinedPlaceholder arguments3ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments3Value);
                    if (ArrayGuards.isNull(arguments0ValueCast)) {
                        return super.setNullIntegerFixnum(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast, arguments3ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(ArrayNodes.IndexSetNode current2) {
                return new IndexSetObjectIntIntUndefinedPlaceholderNode((IndexSetBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IndexSetUninitializedNode
        extends IndexSetBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexSetUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IndexSetUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IndexSetUninitializedNode(IndexSetBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                Object arguments3Value = this.arguments[3].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                IndexSetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IndexSetBaseNode rootNode = (IndexSetBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2], rootNode.arguments[3]}, new Object[]{arguments0Value, arguments1Value, arguments2Value, arguments3Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IndexSetBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            static ArrayNodes.IndexSetNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IndexSetUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexSetNode.class)
        private static abstract class IndexSetBaseNode
        extends ArrayNodes.IndexSetNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IndexSetBaseNode next0;

            IndexSetBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IndexSetBaseNode(IndexSetBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4, Object var5);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value, String reason2) {
                String message2;
                IndexSetBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IndexSetBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value, arguments3Value);
                if (newNode == null) {
                    newNode = new IndexSetUninitializedNode(this);
                    ((IndexSetUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IndexSetBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = IndexSetBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value, arguments3Value)))) == null) {
                    returnNode = (IndexSetBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IndexSetUninitializedNode(this), (Node)new IndexSetPolymorphicNode(this), (DSLNode)((IndexSetBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value, arguments3Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IndexSetBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && ArrayGuards.isNull(arguments0ValueCast)) {
                                return (IndexSetBaseNode)IndexSetObjectIntIntUndefinedPlaceholderNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isLong(arguments2Value) && ArrayGuards.isNull(arguments0ValueCast)) {
                                return (IndexSetBaseNode)IndexSetObjectIntLongUndefinedPlaceholderNode.create0(this);
                            }
                            if (ArrayGuards.isNull(arguments0ValueCast)) {
                                return (IndexSetBaseNode)IndexSetObjectIntObjectUndefinedPlaceholder0Node.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                                return (IndexSetBaseNode)IndexSetIntIntIntUndefinedPlaceholder0Node.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isLong(arguments2Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                                return (IndexSetBaseNode)IndexSetLongIntLongUndefinedPlaceholder0Node.create0(this);
                            }
                        }
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                            if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments3Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                                return (IndexSetBaseNode)IndexSetRubyArrayIntIntRubyArrayNode.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                                return (IndexSetBaseNode)IndexSetIntIntIntUndefinedPlaceholder1Node.create0(this);
                            }
                        }
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value)) {
                            if (RubyTypesGen.RUBYTYPES.isLong(arguments2Value) && ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                                return (IndexSetBaseNode)IndexSetLongIntLongUndefinedPlaceholder1Node.create0(this);
                            }
                            if (RubyTypesGen.RUBYTYPES.isDouble(arguments2Value) && ArrayGuards.isFloat(arguments0ValueCast)) {
                                return (IndexSetBaseNode)IndexSetDoubleIntDoubleUndefinedPlaceholderNode.create0(this);
                            }
                            if (ArrayGuards.isObject(arguments0ValueCast)) {
                                return (IndexSetBaseNode)IndexSetObjectIntObjectUndefinedPlaceholder1Node.create0(this);
                            }
                        }
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value) && ArrayGuards.isObject(arguments0ValueCast) && !super.isRubyArray(arguments3Value)) {
                            return (IndexSetBaseNode)IndexSetObjectIntIntObjectNode.create0(this);
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isRubyArray(arguments2Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments3Value) && ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return (IndexSetBaseNode)IndexSetRubyArrayIntegerFixnumRangeRubyArrayUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                    this.arguments[3] = null;
                } else {
                    IndexSetBaseNode otherCast = (IndexSetBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                    this.arguments[3] = otherCast.arguments[3];
                }
                this.next0 = newNext == null ? null : (IndexSetBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value, Object arguments3Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments3Value").append(" = ").append(arguments3Value);
                    if (arguments3Value != null) {
                        builder.append(" (").append(arguments3Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.IndexNode.class)
    public static final class IndexNodeFactory
    extends NodeFactoryBase<ArrayNodes.IndexNode> {
        private static IndexNodeFactory indexNodeFactoryInstance;

        private IndexNodeFactory() {
            super(ArrayNodes.IndexNode.class, new Class[]{RubyNode.class, RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.IndexNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return IndexNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.IndexNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return IndexUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.IndexNode> getInstance() {
            if (indexNodeFactoryInstance == null) {
                indexNodeFactoryInstance = new IndexNodeFactory();
            }
            return indexNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class IndexPolymorphicNode
        extends IndexBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments2PolymorphicType;

            IndexPolymorphicNode(IndexBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments2Value;
                Object arguments1Value;
                Object arguments0Value = this.arguments[0].execute(frameValue);
                try {
                    arguments1Value = this.arguments1PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[1].executeIntegerFixnum(frameValue)) : (this.arguments1PolymorphicType == RubyRange.IntegerFixnumRange.class ? this.arguments[1].executeIntegerFixnumRange(frameValue) : this.arguments[1].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    this.arguments1PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, ex.getResult(), arguments2Value2);
                }
                try {
                    arguments2Value = this.arguments2PolymorphicType == UndefinedPlaceholder.class ? this.arguments[2].executeUndefinedPlaceholder(frameValue) : (this.arguments2PolymorphicType == Integer.TYPE ? Integer.valueOf(this.arguments[2].executeIntegerFixnum(frameValue)) : this.arguments[2].execute(frameValue));
                }
                catch (UnexpectedResultException ex) {
                    this.arguments2PolymorphicType = Object.class;
                    return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, ex.getResult());
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
                this.arguments2PolymorphicType = types[2];
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexRubyArrayIntegerFixnumRangeUndefinedPlaceholderNode
        extends IndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexRubyArrayIntegerFixnumRangeUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, RubyRange.IntegerFixnumRange.class, UndefinedPlaceholder.class}, 0, 0);

            IndexRubyArrayIntegerFixnumRangeUndefinedPlaceholderNode(IndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                RubyRange.IntegerFixnumRange arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnumRange(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof IntegerFixnumRange");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.sliceObject(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    RubyRange.IntegerFixnumRange arguments1ValueCast = RubyTypesGen.RUBYTYPES.asIntegerFixnumRange(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.sliceObject(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.IndexNode create0(ArrayNodes.IndexNode current2) {
                return new IndexRubyArrayIntegerFixnumRangeUndefinedPlaceholderNode((IndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexRubyArrayIntInt3Node
        extends IndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexRubyArrayIntInt3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            IndexRubyArrayIntInt3Node(IndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.sliceObject(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.sliceObject(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.IndexNode create0(ArrayNodes.IndexNode current2) {
                return new IndexRubyArrayIntInt3Node((IndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexRubyArrayIntInt2Node
        extends IndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexRubyArrayIntInt2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            IndexRubyArrayIntInt2Node(IndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.sliceFloat(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.sliceFloat(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.IndexNode create0(ArrayNodes.IndexNode current2) {
                return new IndexRubyArrayIntInt2Node((IndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexRubyArrayIntInt1Node
        extends IndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexRubyArrayIntInt1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            IndexRubyArrayIntInt1Node(IndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (ArrayGuards.isLongFixnum(arguments0Value)) {
                    return super.sliceLongFixnum(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isLongFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                        return super.sliceLongFixnum(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.IndexNode create0(ArrayNodes.IndexNode current2) {
                return new IndexRubyArrayIntInt1Node((IndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexRubyArrayIntInt0Node
        extends IndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexRubyArrayIntInt0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, Integer.TYPE}, 0, 0);

            IndexRubyArrayIntInt0Node(IndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof int");
                }
                if (ArrayGuards.isIntegerFixnum(arguments0Value)) {
                    return super.sliceIntegerFixnum(arguments0Value, arguments1Value, arguments2Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(frameValue, arguments0Value, arguments1Value, arguments2Value, "One of guards [isIntegerFixnum] failed");
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    int arguments2ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments2Value);
                    if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                        return super.sliceIntegerFixnum(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                    }
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.IndexNode create0(ArrayNodes.IndexNode current2) {
                return new IndexRubyArrayIntInt0Node((IndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class IndexRubyArrayIntUndefinedPlaceholderNode
        extends IndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexRubyArrayIntUndefinedPlaceholderNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE, UndefinedPlaceholder.class}, 0, 0);

            IndexRubyArrayIntUndefinedPlaceholderNode(IndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                UndefinedPlaceholder arguments2Value;
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    Object arguments2Value2 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, ex.getResult(), arguments1Value2, arguments2Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments2Value3 = this.arguments[2].execute(frameValue);
                    return this.rewrite0(frameValue, arguments0Value, ex.getResult(), arguments2Value3, "Expected arguments1Value instanceof int");
                }
                try {
                    arguments2Value = this.arguments[2].executeUndefinedPlaceholder(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(frameValue, arguments0Value, arguments1Value, ex.getResult(), "Expected arguments2Value instanceof UndefinedPlaceholder");
                }
                return super.index(arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    UndefinedPlaceholder arguments2ValueCast = RubyTypesGen.RUBYTYPES.asUndefinedPlaceholder(arguments2Value);
                    return super.index(arguments0ValueCast, arguments1ValueCast, arguments2ValueCast);
                }
                return this.next0.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.IndexNode create0(ArrayNodes.IndexNode current2) {
                return new IndexRubyArrayIntUndefinedPlaceholderNode((IndexBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        @NodeInfo(cost=NodeCost.UNINITIALIZED)
        private static final class IndexUninitializedNode
        extends IndexBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(IndexUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class, Object.class, Object.class}, 0, 0);
            @CompilerDirectives.CompilationFinal
            private boolean containsFallback;

            IndexUninitializedNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection, arguments);
            }

            IndexUninitializedNode(IndexBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            public NodeCost getCost() {
                if (this.containsFallback) {
                    return NodeCost.MONOMORPHIC;
                }
                return super.getCost();
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                Object arguments2Value = this.arguments[2].execute(frameValue);
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @Override
            protected Object executeChained0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (!this.containsFallback) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                }
                return this.executeUninitialized0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            protected Object executeUninitialized0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                IndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    if (CompilerDirectives.inInterpreter()) {
                        this.containsFallback = true;
                    }
                    CompilerDirectives.transferToInterpreter();
                    IndexBaseNode rootNode = (IndexBaseNode)DSLShare.findRoot((Node)this);
                    throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.arguments[0], rootNode.arguments[1], rootNode.arguments[2]}, new Object[]{arguments0Value, arguments1Value, arguments2Value});
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return ((IndexBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            static ArrayNodes.IndexNode create0(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                return new IndexUninitializedNode(context, sourceSection, arguments);
            }
        }

        @GeneratedBy(value=ArrayNodes.IndexNode.class)
        private static abstract class IndexBaseNode
        extends ArrayNodes.IndexNode
        implements DSLNode {
            @Node.Children
            protected final RubyNode[] arguments;
            @Node.Child
            protected IndexBaseNode next0;

            IndexBaseNode(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
                super(context, sourceSection);
                this.arguments = arguments;
            }

            IndexBaseNode(IndexBaseNode copy) {
                super(copy);
                this.arguments = new RubyNode[copy.arguments.length];
            }

            protected abstract Object executeChained0(VirtualFrame var1, Object var2, Object var3, Object var4);

            protected final Object rewrite0(VirtualFrame frameValue, Object arguments0Value, Object arguments1Value, Object arguments2Value, String reason2) {
                String message2;
                IndexBaseNode returnNode;
                CompilerAsserts.neverPartOfCompilation();
                IndexBaseNode newNode = this.specialize0(arguments0Value, arguments1Value, arguments2Value);
                if (newNode == null) {
                    newNode = new IndexUninitializedNode(this);
                    ((IndexUninitializedNode)newNode).containsFallback = true;
                }
                if ((returnNode = (IndexBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = IndexBaseNode.createInfo0(reason2, arguments0Value, arguments1Value, arguments2Value)))) == null) {
                    returnNode = (IndexBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new IndexUninitializedNode(this), (Node)new IndexPolymorphicNode(this), (DSLNode)((IndexBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
                }
                return returnNode.executeChained0(frameValue, arguments0Value, arguments1Value, arguments2Value);
            }

            @CompilerDirectives.TruffleBoundary
            protected final IndexBaseNode specialize0(Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    if (RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                        if (RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value)) {
                            return (IndexBaseNode)IndexRubyArrayIntUndefinedPlaceholderNode.create0(this);
                        }
                        if (RubyTypesGen.RUBYTYPES.isInteger(arguments2Value)) {
                            if (ArrayGuards.isIntegerFixnum(arguments0ValueCast)) {
                                return (IndexBaseNode)IndexRubyArrayIntInt0Node.create0(this);
                            }
                            if (ArrayGuards.isLongFixnum(arguments0ValueCast)) {
                                return (IndexBaseNode)IndexRubyArrayIntInt1Node.create0(this);
                            }
                            if (ArrayGuards.isFloat(arguments0ValueCast)) {
                                return (IndexBaseNode)IndexRubyArrayIntInt2Node.create0(this);
                            }
                            if (ArrayGuards.isObject(arguments0ValueCast)) {
                                return (IndexBaseNode)IndexRubyArrayIntInt3Node.create0(this);
                            }
                        }
                    }
                    if (RubyTypesGen.RUBYTYPES.isIntegerFixnumRange(arguments1Value) && RubyTypesGen.RUBYTYPES.isUndefinedPlaceholder(arguments2Value) && ArrayGuards.isObject(arguments0ValueCast)) {
                        return (IndexBaseNode)IndexRubyArrayIntegerFixnumRangeUndefinedPlaceholderNode.create0(this);
                    }
                }
                return null;
            }

            public final void adoptChildren0(Node other, Node newNext) {
                if (other == null) {
                    this.arguments[0] = null;
                    this.arguments[1] = null;
                    this.arguments[2] = null;
                } else {
                    IndexBaseNode otherCast = (IndexBaseNode)other;
                    this.arguments[0] = otherCast.arguments[0];
                    this.arguments[1] = otherCast.arguments[1];
                    this.arguments[2] = otherCast.arguments[2];
                }
                this.next0 = newNext == null ? null : (IndexBaseNode)newNext;
            }

            public DSLMetadata getMetadata0() {
                return DSLMetadata.NONE;
            }

            public void updateTypes0(Class<?>[] types) {
            }

            public final Node getNext0() {
                return this.next0;
            }

            protected static String createInfo0(String message2, Object arguments0Value, Object arguments1Value, Object arguments2Value) {
                if (TruffleOptions.DetailedRewriteReasons) {
                    StringBuilder builder = new StringBuilder(message2);
                    builder.append(" (");
                    builder.append("arguments0Value").append(" = ").append(arguments0Value);
                    if (arguments0Value != null) {
                        builder.append(" (").append(arguments0Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments1Value").append(" = ").append(arguments1Value);
                    if (arguments1Value != null) {
                        builder.append(" (").append(arguments1Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(", ").append("arguments2Value").append(" = ").append(arguments2Value);
                    if (arguments2Value != null) {
                        builder.append(" (").append(arguments2Value.getClass().getSimpleName()).append(")");
                    }
                    builder.append(")");
                    return builder.toString();
                }
                return message2;
            }
        }
    }

    @GeneratedBy(value=ArrayNodes.AtNode.class)
    public static final class AtNodeFactory
    extends NodeFactoryBase<ArrayNodes.AtNode> {
        private static AtNodeFactory atNodeFactoryInstance;

        private AtNodeFactory() {
            super(ArrayNodes.AtNode.class, new Class[]{RubyNode.class, RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, RubyNode[].class}});
        }

        public ArrayNodes.AtNode createNode(Object ... arguments) {
            if (!(arguments.length != 3 || arguments[0] != null && !(arguments[0] instanceof RubyContext) || arguments[1] != null && !(arguments[1] instanceof SourceSection) || arguments[2] != null && !(arguments[2] instanceof RubyNode[]))) {
                return AtNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (RubyNode[])arguments[2]);
            }
            throw new IllegalArgumentException("Invalid create signature.");
        }

        public static ArrayNodes.AtNode create(RubyContext context, SourceSection sourceSection, RubyNode[] arguments) {
            return AtUninitializedNode.create0(context, sourceSection, arguments);
        }

        public static NodeFactory<ArrayNodes.AtNode> getInstance() {
            if (atNodeFactoryInstance == null) {
                atNodeFactoryInstance = new AtNodeFactory();
            }
            return atNodeFactoryInstance;
        }

        @GeneratedBy(value=ArrayNodes.AtNode.class)
        @NodeInfo(cost=NodeCost.POLYMORPHIC)
        private static final class AtPolymorphicNode
        extends AtBaseNode {
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments0PolymorphicType;
            @CompilerDirectives.CompilationFinal
            private Class<?> arguments1PolymorphicType;

            AtPolymorphicNode(AtBaseNode copy) {
                super(copy);
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value = this.arguments[0].execute(frameValue);
                Object arguments1Value = this.arguments[1].execute(frameValue);
                return this.next0.executeChained0(arguments0Value, arguments1Value);
            }

            @Override
            public Object executeAt(RubyArray arguments0ValueEvaluated, int arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                Integer arguments1Value = arguments1ValueEvaluated;
                return this.next0.executeChained0(arguments0Value, arguments1Value);
            }

            @Override
            public void updateTypes0(Class<?>[] types) {
                this.arguments0PolymorphicType = types[0];
                this.arguments1PolymorphicType = types[1];
            }

            @Override
            protected Object executeChained0(Object arguments0Value, Object arguments1Value) {
                return this.next0.executeChained0(arguments0Value, arguments1Value);
            }
        }

        @GeneratedBy(value=ArrayNodes.AtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AtObjectInt3Node
        extends AtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AtObjectInt3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            AtObjectInt3Node(AtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.getObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            public Object executeAt(RubyArray arguments0ValueEvaluated, int arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                int arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isObject(arguments0Value)) {
                    return super.getObject(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(arguments0Value, arguments1Value, "One of guards [isObject] failed");
            }

            @Override
            protected Object executeChained0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isObject(arguments0ValueCast)) {
                        return super.getObject(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(arguments0Value, arguments1Value);
            }

            static ArrayNodes.AtNode create0(ArrayNodes.AtNode current2) {
                return new AtObjectInt3Node((AtBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.AtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AtObjectInt2Node
        extends AtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AtObjectInt2Node.class, new Class[]{AtDoubleIntNode.class}, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            AtObjectInt2Node(AtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return this.rewrite0(ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray");
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return this.rewrite0(arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int");
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.getFloat(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            public Object executeAt(RubyArray arguments0ValueEvaluated, int arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                int arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isFloat(arguments0Value)) {
                    return super.getFloat(arguments0Value, arguments1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.rewrite0(arguments0Value, arguments1Value, "One of guards [isFloat] failed");
            }

            @Override
            protected Object executeChained0(Object arguments0Value, Object arguments1Value) {
                if (RubyTypesGen.RUBYTYPES.isRubyArray(arguments0Value) && RubyTypesGen.RUBYTYPES.isInteger(arguments1Value)) {
                    RubyArray arguments0ValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arguments0Value);
                    int arguments1ValueCast = RubyTypesGen.RUBYTYPES.asInteger(arguments1Value);
                    if (ArrayGuards.isFloat(arguments0ValueCast)) {
                        return super.getFloat(arguments0ValueCast, arguments1ValueCast);
                    }
                }
                return this.next0.executeChained0(arguments0Value, arguments1Value);
            }

            static ArrayNodes.AtNode create0(ArrayNodes.AtNode current2) {
                return new AtObjectInt2Node((AtBaseNode)current2);
            }
        }

        @GeneratedBy(value=ArrayNodes.AtNode.class)
        @NodeInfo(cost=NodeCost.MONOMORPHIC)
        private static final class AtDoubleIntNode
        extends AtBaseNode {
            private static final DSLMetadata METADATA = new DSLMetadata(AtDoubleIntNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{AtObjectInt2Node.class}, new Class[]{RubyArray.class, Integer.TYPE}, 0, 0);

            AtDoubleIntNode(AtBaseNode copy) {
                super(copy);
            }

            @Override
            public DSLMetadata getMetadata0() {
                return METADATA;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                double value2;
                try {
                    value2 = this.executeFloat(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return ex.getResult();
                }
                return value2;
            }

            @Override
            public double executeFloat(VirtualFrame frameValue) throws UnexpectedResultException {
                int arguments1Value;
                RubyArray arguments0Value;
                try {
                    arguments0Value = this.arguments[0].executeArray(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    Object arguments1Value2 = this.arguments[1].execute(frameValue);
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(ex.getResult(), arguments1Value2, "Expected arguments0Value instanceof RubyArray"));
                }
                try {
                    arguments1Value = this.arguments[1].executeIntegerFixnum(frameValue);
                }
                catch (UnexpectedResultException ex) {
                    return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(arguments0Value, ex.getResult(), "Expected arguments1Value instanceof int"));
                }
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.getFloatInBounds(arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(arguments0Value, arguments1Value, "Thrown UnexpectedResultException"));
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return RubyTypesGen.RUBYTYPES.expectDouble(this.rewrite0(arguments0Value, arguments1Value, "One of guards [isFloat] failed"));
            }

            @Override
            public Object executeAt(RubyArray arguments0ValueEvaluated, int arguments1ValueEvaluated) {
                RubyArray arguments0Value = arguments0ValueEvaluated;
                int arguments1Value = arguments1ValueEvaluated;
                if (ArrayGuards.isFloat(arguments0Value)) {
                    try {
                        return super.getFloatInBounds(arguments0Value, arguments1Value);
                    }
                    catch (UnexpectedResultException ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        return this.rewrite0(arguments0Value, arguments1Value, "Thrown UnexpectedResultException");
                    }
          