/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.dsl.ImportGuards;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.FrameSlot;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import com.oracle.truffle.api.utilities.BranchProfile;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jruby.runtime.Visibility;
import org.jruby.truffle.nodes.CoreSourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyRootNode;
import org.jruby.truffle.nodes.core.ArrayBuilderNode;
import org.jruby.truffle.nodes.core.ArrayCoreMethodNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.nodes.core.ArrayNodesFactory;
import org.jruby.truffle.nodes.core.CoreClass;
import org.jruby.truffle.nodes.core.CoreMethod;
import org.jruby.truffle.nodes.core.CoreMethodNode;
import org.jruby.truffle.nodes.core.KernelNodes;
import org.jruby.truffle.nodes.core.KernelNodesFactory;
import org.jruby.truffle.nodes.core.YieldingCoreMethodNode;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.nodes.methods.arguments.MissingArgumentBehaviour;
import org.jruby.truffle.nodes.methods.arguments.ReadPreArgumentNode;
import org.jruby.truffle.nodes.methods.locals.ReadLevelVariableNodeFactory;
import org.jruby.truffle.nodes.yield.YieldDispatchHeadNode;
import org.jruby.truffle.runtime.DebugOperations;
import org.jruby.truffle.runtime.RubyArguments;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.control.BreakException;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.methods.MethodLike;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;
import org.jruby.truffle.runtime.util.ArrayUtils;
import org.jruby.util.Memo;
import org.jruby.util.Pack;

@CoreClass(name="Array")
public abstract class ArrayNodes {

    @CoreMethod(names={"zip"}, required=1)
    public static abstract class ZipNode
    extends ArrayCoreMethodNode {
        public ZipNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ZipNode(ZipNode prev) {
            super(prev);
        }

        @Specialization(guards={"isObject", "isOtherIntegerFixnum"})
        public RubyArray zipObjectIntegerFixnum(RubyArray array, RubyArray other) {
            Object[] a = (Object[])array.getStore();
            int aLength = array.getSize();
            int[] b2 = (int[])other.getStore();
            int bLength = other.getSize();
            int zippedLength = Math.min(aLength, bLength);
            Object[] zipped = new Object[zippedLength];
            for (int n = 0; n < zippedLength; ++n) {
                zipped[n] = new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{a[n], b2[n]}, 2);
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), zipped, zippedLength);
        }

        @Specialization(guards={"isObject", "isOtherObject"})
        public RubyArray zipObjectObject(RubyArray array, RubyArray other) {
            Object[] a = (Object[])array.getStore();
            int aLength = array.getSize();
            Object[] b2 = (Object[])other.getStore();
            int bLength = other.getSize();
            int zippedLength = Math.min(aLength, bLength);
            Object[] zipped = new Object[zippedLength];
            for (int n = 0; n < zippedLength; ++n) {
                zipped[n] = new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{a[n], b2[n]}, 2);
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), zipped, zippedLength);
        }
    }

    @CoreMethod(names={"unshift"}, argumentsAsArray=true)
    public static abstract class UnshiftNode
    extends CoreMethodNode {
        public UnshiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UnshiftNode(UnshiftNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray unshift(RubyArray array, Object ... args2) {
            UnshiftNode.notDesignedForCompilation();
            array.slowUnshift(args2);
            return array;
        }
    }

    @CoreMethod(names={"uniq"})
    public static abstract class UniqNode
    extends CoreMethodNode {
        public UniqNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UniqNode(UniqNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray uniq(RubyArray array) {
            UniqNode.notDesignedForCompilation();
            RubyArray uniq = new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0);
            for (Object value2 : array.slowToArray()) {
                boolean duplicate = false;
                for (Object compare : uniq.slowToArray()) {
                    if (!((Boolean)DebugOperations.send(this.getContext(), value2, "==", null, compare)).booleanValue()) continue;
                    duplicate = true;
                    break;
                }
                if (duplicate) continue;
                uniq.slowPush(value2);
            }
            return uniq;
        }
    }

    @CoreMethod(names={"to_a"})
    public static abstract class ToANode
    extends CoreMethodNode {
        public ToANode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ToANode(ToANode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray toA(RubyArray array) {
            return array;
        }
    }

    @CoreMethod(names={"sort!"})
    public static abstract class SortBangNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareDispatchNode;

        public SortBangNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareDispatchNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public SortBangNode(SortBangNode prev) {
            super(prev);
            this.compareDispatchNode = prev.compareDispatchNode;
        }

        @Specialization
        public RubyArray sort(VirtualFrame frame, RubyArray array) {
            SortBangNode.notDesignedForCompilation();
            Object[] store = array.slowToArray();
            this.sort(frame, store);
            array.setStore(store, array.getSize());
            return array;
        }

        private <T> void sort(VirtualFrame frame, T[] objects) {
            final VirtualFrame finalFrame = frame;
            Arrays.sort(objects, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b2) {
                    return (Integer)SortBangNode.this.compareDispatchNode.call(finalFrame, a, "<=>", null, b2);
                }
            });
        }
    }

    @CoreMethod(names={"sort"}, needsBlock=true)
    public static abstract class SortNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareDispatchNode;
        @Node.Child
        private YieldDispatchHeadNode yieldNode;

        public SortNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareDispatchNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.yieldNode = new YieldDispatchHeadNode(context);
        }

        public SortNode(SortNode prev) {
            super(prev);
            this.compareDispatchNode = prev.compareDispatchNode;
            this.yieldNode = prev.yieldNode;
        }

        @Specialization(guards={"isNull"})
        public RubyArray sortNull(RubyArray array, UndefinedPlaceholder block) {
            SortNode.notDesignedForCompilation();
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }

        @ExplodeLoop
        @Specialization(guards={"isIntegerFixnum", "isSmall"})
        public RubyArray sortVeryShortIntegerFixnum(VirtualFrame frame, RubyArray array, UndefinedPlaceholder block) {
            int[] store = (int[])array.getStore();
            int size2 = array.getSize();
            for (int i2 = 0; i2 < RubyArray.ARRAYS_SMALL; ++i2) {
                if (i2 >= size2) continue;
                for (int j = i2 + 1; j < RubyArray.ARRAYS_SMALL; ++j) {
                    if (j >= size2 || (Integer)this.compareDispatchNode.call(frame, store[j], "<=>", null, store[i2]) >= 0) continue;
                    int temp = store[j];
                    store[j] = store[i2];
                    store[i2] = temp;
                }
            }
            return array;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public RubyArray sortIntegerFixnum(VirtualFrame frame, RubyArray array, UndefinedPlaceholder block) {
            SortNode.notDesignedForCompilation();
            Object[] boxed = ArrayUtils.box((int[])array.getStore());
            this.sort(frame, boxed);
            int[] unboxed = ArrayUtils.unboxInteger(boxed, array.getSize());
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), unboxed, array.getSize());
        }

        @ExplodeLoop
        @Specialization(guards={"isLongFixnum", "isSmall"})
        public RubyArray sortVeryShortLongFixnum(VirtualFrame frame, RubyArray array, UndefinedPlaceholder block) {
            long[] store = (long[])array.getStore();
            int size2 = array.getSize();
            for (int i2 = 0; i2 < RubyArray.ARRAYS_SMALL; ++i2) {
                if (i2 >= size2) continue;
                for (int j = i2 + 1; j < RubyArray.ARRAYS_SMALL; ++j) {
                    if (j >= size2 || (Integer)this.compareDispatchNode.call(frame, store[j], "<=>", null, store[i2]) >= 0) continue;
                    long temp = store[j];
                    store[j] = store[i2];
                    store[i2] = temp;
                }
            }
            return array;
        }

        @Specialization(guards={"isLongFixnum"})
        public RubyArray sortLongFixnum(VirtualFrame frame, RubyArray array, UndefinedPlaceholder block) {
            SortNode.notDesignedForCompilation();
            Object[] boxed = ArrayUtils.box((long[])array.getStore());
            this.sort(frame, boxed);
            long[] unboxed = ArrayUtils.unboxLong(boxed, array.getSize());
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), unboxed, array.getSize());
        }

        @Specialization(guards={"isFloat"})
        public RubyArray sortDouble(VirtualFrame frame, RubyArray array, UndefinedPlaceholder block) {
            SortNode.notDesignedForCompilation();
            Object[] boxed = ArrayUtils.box((double[])array.getStore());
            this.sort(frame, boxed);
            double[] unboxed = ArrayUtils.unboxDouble(boxed, array.getSize());
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), unboxed, array.getSize());
        }

        @Specialization(guards={"isObject", "isSmall"})
        public RubyArray sortVeryShortObject(VirtualFrame frame, RubyArray array, UndefinedPlaceholder block) {
            Object[] store = (Object[])array.getStore();
            int size2 = array.getSize();
            for (int i2 = 1; i2 < size2; ++i2) {
                Object x = store[i2];
                for (int j = i2; j > 0 && (Integer)this.compareDispatchNode.call(frame, store[j - 1], "<=>", null, x) > 0; --j) {
                    store[j] = store[j - 1];
                }
                store[j] = x;
            }
            return array;
        }

        @Specialization(guards={"isObject"})
        public RubyArray sortObject(VirtualFrame frame, RubyArray array, UndefinedPlaceholder block) {
            SortNode.notDesignedForCompilation();
            Object[] store = Arrays.copyOf((Object[])array.getStore(), array.getSize());
            this.sort(frame, store);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), store, array.getSize());
        }

        @Specialization(guards={"isObject"})
        public RubyArray sortWithCompareBlock(VirtualFrame frame, RubyArray array, RubyProc block) {
            SortNode.notDesignedForCompilation();
            Object[] store = Arrays.copyOf((Object[])array.getStore(), array.getSize());
            this.sort(frame, store, block);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), store, array.getSize());
        }

        private <T> void sort(VirtualFrame frame, T[] objects) {
            final VirtualFrame finalFrame = frame;
            Arrays.sort(objects, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b2) {
                    return (Integer)SortNode.this.compareDispatchNode.call(finalFrame, a, "<=>", null, b2);
                }
            });
        }

        private <T> void sort(VirtualFrame frame, T[] objects, RubyProc compare) {
            final VirtualFrame finalFrame = frame;
            final RubyProc finalCompare = compare;
            Arrays.sort(objects, new Comparator<Object>(){

                @Override
                public int compare(Object a, Object b2) {
                    return (Integer)SortNode.this.yieldNode.dispatch(finalFrame, finalCompare, a, b2);
                }
            });
        }

        protected static boolean isSmall(RubyArray array) {
            return array.getSize() <= RubyArray.ARRAYS_SMALL;
        }
    }

    @CoreMethod(names={"size", "length"})
    public static abstract class SizeNode
    extends ArrayCoreMethodNode {
        public SizeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SizeNode(SizeNode prev) {
            super(prev);
        }

        @Specialization
        public int size(RubyArray array) {
            return array.getSize();
        }
    }

    @CoreMethod(names={"shift"})
    public static abstract class ShiftNode
    extends CoreMethodNode {
        public ShiftNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ShiftNode(ShiftNode prev) {
            super(prev);
        }

        @Specialization
        public Object shift(RubyArray array) {
            ShiftNode.notDesignedForCompilation();
            return array.slowShift();
        }
    }

    @CoreMethod(names={"select"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class SelectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public SelectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public SelectNode(SelectNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
        }

        @Specialization(guards={"isNull"})
        public Object selectNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public Object selectObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            Object[] store = (Object[])array.getStore();
            Object selectedStore = this.arrayBuilder.start(array.getSize());
            int selectedSize = 0;
            int count2 = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    Object value2 = store[n];
                    SelectNode.notDesignedForCompilation();
                    if (!this.yieldIsTruthy(frame, block, value2)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value2);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public Object selectFixnumInteger(VirtualFrame frame, RubyArray array, RubyProc block) {
            int[] store = (int[])array.getStore();
            Object selectedStore = this.arrayBuilder.start(array.getSize());
            int selectedSize = 0;
            int count2 = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    Integer value2 = store[n];
                    SelectNode.notDesignedForCompilation();
                    if (!this.yieldIsTruthy(frame, block, value2)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value2);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }
    }

    @CoreMethod(names={"replace"}, required=1)
    public static abstract class ReplaceNode
    extends ArrayCoreMethodNode {
        public ReplaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ReplaceNode(ReplaceNode prev) {
            super(prev);
        }

        @Specialization(guards={"isOtherNull"})
        public RubyArray replace(RubyArray array, RubyArray other) {
            ReplaceNode.notDesignedForCompilation();
            array.setSize(0);
            return array;
        }

        @Specialization(guards={"isOtherIntegerFixnum"})
        public RubyArray replaceIntegerFixnum(RubyArray array, RubyArray other) {
            ReplaceNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((int[])other.getStore(), other.getSize()), other.getSize());
            return array;
        }

        @Specialization(guards={"isOtherLongFixnum"})
        public RubyArray replaceLongFixnum(RubyArray array, RubyArray other) {
            ReplaceNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((long[])other.getStore(), other.getSize()), other.getSize());
            return array;
        }

        @Specialization(guards={"isOtherFloat"})
        public RubyArray replaceFloat(RubyArray array, RubyArray other) {
            ReplaceNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((double[])other.getStore(), other.getSize()), other.getSize());
            return array;
        }

        @Specialization(guards={"isOtherObject"})
        public RubyArray replaceObject(RubyArray array, RubyArray other) {
            ReplaceNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((Object[])other.getStore(), other.getSize()), other.getSize());
            return array;
        }
    }

    @CoreMethod(names={"reject!", "delete_if"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class RejectInPlaceNode
    extends YieldingCoreMethodNode {
        public RejectInPlaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public RejectInPlaceNode(RejectInPlaceNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public Object rejectInPlaceNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return array;
        }

        @Specialization(guards={"isObject"})
        public Object rejectInPlaceObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            Object[] store = (Object[])array.getStore();
            int i2 = 0;
            for (int n = 0; n < array.getSize(); ++n) {
                if (this.yieldIsTruthy(frame, block, store[n])) continue;
                if (i2 != n) {
                    store[i2] = store[n];
                }
                ++i2;
            }
            array.setSize(i2);
            return array;
        }
    }

    @CoreMethod(names={"reject"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class RejectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public RejectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public RejectNode(RejectNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
        }

        @Specialization(guards={"isNull"})
        public Object selectNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public Object selectObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            Object[] store = (Object[])array.getStore();
            Object selectedStore = this.arrayBuilder.start(array.getSize());
            int selectedSize = 0;
            int count2 = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    Object value2 = store[n];
                    RejectNode.notDesignedForCompilation();
                    if (this.yieldIsTruthy(frame, block, value2)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value2);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public Object selectFixnumInteger(VirtualFrame frame, RubyArray array, RubyProc block) {
            int[] store = (int[])array.getStore();
            Object selectedStore = this.arrayBuilder.start(array.getSize());
            int selectedSize = 0;
            int count2 = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    Integer value2 = store[n];
                    RejectNode.notDesignedForCompilation();
                    if (this.yieldIsTruthy(frame, block, value2)) continue;
                    selectedStore = this.arrayBuilder.append(selectedStore, selectedSize, value2);
                    ++selectedSize;
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(selectedStore, selectedSize), selectedSize);
        }
    }

    public static abstract class PushOneNode
    extends ArrayCoreMethodNode {
        private final BranchProfile extendBranch = BranchProfile.create();

        public PushOneNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PushOneNode(PushOneNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyArray pushEmpty(RubyArray array, Object value2) {
            array.setStore(new Object[]{value2}, 1);
            return array;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public RubyArray pushIntegerFixnumIntegerFixnum(RubyArray array, int value2) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            int[] store = (int[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                array.setStore(store, array.getSize());
            }
            store[oldSize] = value2;
            array.setSize(newSize);
            return array;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public RubyArray pushIntegerFixnumObject(RubyArray array, Object value2) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            int[] oldStore = (int[])array.getStore();
            Object[] newStore = ArrayUtils.box(oldStore, newSize);
            newStore[oldSize] = value2;
            array.setStore(newStore, newSize);
            return array;
        }

        @Specialization(guards={"isObject"})
        public RubyArray pushObjectObject(RubyArray array, Object value2) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            Object[] store = (Object[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                array.setStore(store, array.getSize());
            }
            store[oldSize] = value2;
            array.setSize(newSize);
            return array;
        }
    }

    @CoreMethod(names={"push", "<<"}, argumentsAsArray=true)
    public static abstract class PushNode
    extends ArrayCoreMethodNode {
        private final BranchProfile extendBranch = BranchProfile.create();

        public PushNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PushNode(PushNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull", "isSingleIntegerFixnum"})
        public RubyArray pushEmptySingleIntegerFixnum(RubyArray array, Object ... values2) {
            array.setStore(new int[]{(Integer)values2[0]}, 1);
            return array;
        }

        @Specialization(guards={"isNull", "isSingleLongFixnum"})
        public RubyArray pushEmptySingleIntegerLong(RubyArray array, Object ... values2) {
            array.setStore(new long[]{(Long)values2[0]}, 1);
            return array;
        }

        @Specialization(guards={"isNull"})
        public RubyArray pushEmptyObjects(RubyArray array, Object ... values2) {
            array.setStore(values2, values2.length);
            return array;
        }

        @Specialization(guards={"isIntegerFixnum", "isSingleIntegerFixnum"})
        public RubyArray pushIntegerFixnumSingleIntegerFixnum(RubyArray array, Object ... values2) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            int[] store = (int[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                array.setStore(store, array.getSize());
            }
            store[oldSize] = (Integer)values2[0];
            array.setSize(newSize);
            return array;
        }

        @Specialization(guards={"isLongFixnum", "isSingleIntegerFixnum"})
        public RubyArray pushLongFixnumSingleIntegerFixnum(RubyArray array, Object ... values2) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            long[] store = (long[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                array.setStore(store, array.getSize());
            }
            store[oldSize] = ((Integer)values2[0]).intValue();
            array.setSize(newSize);
            return array;
        }

        @Specialization(guards={"isLongFixnum", "isSingleLongFixnum"})
        public RubyArray pushLongFixnumSingleLongFixnum(RubyArray array, Object ... values2) {
            int oldSize = array.getSize();
            int newSize = oldSize + 1;
            long[] store = (long[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                array.setStore(store, array.getSize());
            }
            store[oldSize] = (Long)values2[0];
            array.setSize(newSize);
            return array;
        }

        @Specialization(guards={"isObject"})
        public RubyArray pushObject(RubyArray array, Object ... values2) {
            int oldSize = array.getSize();
            int newSize = oldSize + values2.length;
            Object[] store = (Object[])array.getStore();
            if (store.length < newSize) {
                this.extendBranch.enter();
                store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, newSize));
                array.setStore(store, oldSize);
            }
            for (int n = 0; n < values2.length; ++n) {
                store[oldSize + n] = values2[n];
            }
            array.setSize(newSize);
            return array;
        }

        protected boolean isSingleIntegerFixnum(RubyArray array, Object ... values2) {
            return values2.length == 1 && values2[0] instanceof Integer;
        }

        protected boolean isSingleLongFixnum(RubyArray array, Object ... values2) {
            return values2.length == 1 && values2[0] instanceof Long;
        }
    }

    @CoreMethod(names={"product"}, required=1)
    public static abstract class ProductNode
    extends ArrayCoreMethodNode {
        public ProductNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ProductNode(ProductNode prev) {
            super(prev);
        }

        @Specialization(guards={"isObject", "isOtherObject"})
        public Object product(RubyArray array, RubyArray other) {
            Object[] a = (Object[])array.getStore();
            int aLength = array.getSize();
            Object[] b2 = (Object[])other.getStore();
            int bLength = other.getSize();
            Object[] pairs = new Object[aLength * bLength];
            for (int an = 0; an < aLength; ++an) {
                for (int bn = 0; bn < bLength; ++bn) {
                    pairs[an * bLength + bn] = new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), new Object[]{a[an], b2[bn]}, 2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), pairs, pairs.length);
        }
    }

    @CoreMethod(names={"pop"})
    public static abstract class PopNode
    extends ArrayCoreMethodNode {
        public PopNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PopNode(PopNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public Object popNil(RubyArray array) {
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization(guards={"isIntegerFixnum"}, rewriteOn={UnexpectedResultException.class})
        public int popIntegerFixnumInBounds(RubyArray array) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
            }
            int value2 = ((int[])array.getStore())[array.getSize() - 1];
            array.setSize(array.getSize() - 1);
            return value2;
        }

        @Specialization(contains={"popIntegerFixnumInBounds"}, guards={"isIntegerFixnum"})
        public Object popIntegerFixnum(RubyArray array) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            int value2 = ((int[])array.getStore())[array.getSize() - 1];
            array.setSize(array.getSize() - 1);
            return value2;
        }

        @Specialization(guards={"isLongFixnum"}, rewriteOn={UnexpectedResultException.class})
        public long popLongFixnumInBounds(RubyArray array) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
            }
            long value2 = ((long[])array.getStore())[array.getSize() - 1];
            array.setSize(array.getSize() - 1);
            return value2;
        }

        @Specialization(contains={"popLongFixnumInBounds"}, guards={"isLongFixnum"})
        public Object popLongFixnum(RubyArray array) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            long value2 = ((long[])array.getStore())[array.getSize() - 1];
            array.setSize(array.getSize() - 1);
            return value2;
        }

        @Specialization(guards={"isFloat"}, rewriteOn={UnexpectedResultException.class})
        public double popFloatInBounds(RubyArray array) throws UnexpectedResultException {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
            }
            double value2 = ((double[])array.getStore())[array.getSize() - 1];
            array.setSize(array.getSize() - 1);
            return value2;
        }

        @Specialization(contains={"popFloatInBounds"}, guards={"isFloat"})
        public Object popFloat(RubyArray array) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            double value2 = ((double[])array.getStore())[array.getSize() - 1];
            array.setSize(array.getSize() - 1);
            return value2;
        }

        @Specialization(guards={"isObject"})
        public Object popObject(RubyArray array) {
            if (CompilerDirectives.injectBranchProbability((double)0.25, (array.getSize() == 0 ? 1 : 0) != 0)) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            Object value2 = ((Object[])array.getStore())[array.getSize() - 1];
            array.setSize(array.getSize() - 1);
            return value2;
        }
    }

    @CoreMethod(names={"permutation"}, required=1)
    public static abstract class PermutationNode
    extends ArrayCoreMethodNode {
        public PermutationNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PermutationNode(PermutationNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray permutation(RubyArray array, int n) {
            PermutationNode.notDesignedForCompilation();
            ArrayList<RubyArray> permutations = new ArrayList<RubyArray>();
            this.permutationCommon(n, false, array.slowToArray(), permutations);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), permutations.toArray(), permutations.size());
        }

        private void permutationCommon(int r, boolean repeat, Object[] values2, List<RubyArray> permutations) {
            if (r == 0) {
                permutations.add(new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), null, 0));
            } else if (r == 1) {
                for (int i2 = 0; i2 < values2.length; ++i2) {
                    permutations.add(new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), values2[i2], 1));
                }
            } else if (r >= 0) {
                int n = values2.length;
                this.permute(n, r, new int[r], 0, new boolean[n], repeat, values2, permutations);
            }
        }

        private void permute(int n, int r, int[] p2, int index2, boolean[] used, boolean repeat, Object[] values2, List<RubyArray> permutations) {
            for (int i2 = 0; i2 < n; ++i2) {
                if (!repeat && used[i2]) continue;
                p2[index2] = i2;
                if (index2 < r - 1) {
                    used[i2] = true;
                    this.permute(n, r, p2, index2 + 1, used, repeat, values2, permutations);
                    used[i2] = false;
                    continue;
                }
                Object[] result2 = new Object[r];
                for (int j = 0; j < r; ++j) {
                    result2[j] = values2[p2[j]];
                }
                permutations.add(new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), result2, r));
            }
        }
    }

    @CoreMethod(names={"pack"}, required=1)
    public static abstract class PackNode
    extends ArrayCoreMethodNode {
        public PackNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public PackNode(PackNode prev) {
            super(prev);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        public RubyString pack(RubyArray array, RubyString format) {
            PackNode.notDesignedForCompilation();
            return new RubyString(this.getContext().getCoreLibrary().getStringClass(), Pack.pack(this.getContext().getRuntime(), this.getContext().toJRuby(array), this.getContext().toJRuby(format).getByteList()).getByteList());
        }
    }

    public static class MinBlock
    implements MethodLike {
        private final FrameDescriptor frameDescriptor;
        private final FrameSlot frameSlot;
        private final SharedMethodInfo sharedMethodInfo;
        private final CallTarget callTarget;

        public MinBlock(RubyContext context) {
            CoreSourceSection sourceSection = new CoreSourceSection("Array", "min");
            this.frameDescriptor = new FrameDescriptor();
            this.frameSlot = this.frameDescriptor.addFrameSlot((Object)"minimum_memo");
            this.sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, null, "min", false, null, false);
            this.callTarget = Truffle.getRuntime().createCallTarget((RootNode)new RubyRootNode(context, (SourceSection)sourceSection, null, this.sharedMethodInfo, ArrayNodesFactory.MinBlockNodeFactory.create(context, (SourceSection)sourceSection, new RubyNode[]{ReadLevelVariableNodeFactory.create(context, (SourceSection)sourceSection, this.frameSlot, 1), new ReadPreArgumentNode(context, (SourceSection)sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR)})));
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        @Override
        public SharedMethodInfo getSharedMethodInfo() {
            return this.sharedMethodInfo;
        }

        @Override
        public RubyModule getDeclaringModule() {
            throw new UnsupportedOperationException();
        }

        public CallTarget getCallTarget() {
            return this.callTarget;
        }
    }

    public static abstract class MinBlockNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public MinBlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public MinBlockNode(MinBlockNode prev) {
            super(prev);
            this.compareNode = prev.compareNode;
        }

        @Specialization
        public RubyNilClass min(VirtualFrame frame, Object minimumObject, Object value2) {
            Memo minimum = (Memo)minimumObject;
            Object current2 = minimum.get();
            if (current2 == null || (Integer)this.compareNode.call(frame, value2, "<=>", null, current2) < 0) {
                minimum.set(value2);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"min"})
    public static abstract class MinNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachNode;
        private final MinBlock minBlock;

        public MinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.minBlock = context.getCoreLibrary().getArrayMinBlock();
        }

        public MinNode(MinNode prev) {
            super(prev);
            this.eachNode = prev.eachNode;
            this.minBlock = prev.minBlock;
        }

        @Specialization
        public Object min(VirtualFrame frame, RubyArray array) {
            Memo minimum = new Memo();
            VirtualFrame minimumClosureFrame = Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(this.minBlock, null, array, null, new Object[0]), this.minBlock.getFrameDescriptor());
            minimumClosureFrame.setObject(this.minBlock.getFrameSlot(), minimum);
            RubyProc block = new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, this.minBlock.getSharedMethodInfo(), this.minBlock.getCallTarget(), this.minBlock.getCallTarget(), this.minBlock.getCallTarget(), minimumClosureFrame.materialize(), null, null, array, null);
            this.eachNode.call(frame, array, "each", block, new Object[0]);
            if (minimum.get() == null) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return minimum.get();
        }
    }

    public static class MaxBlock
    implements MethodLike {
        private final FrameDescriptor frameDescriptor;
        private final FrameSlot frameSlot;
        private final SharedMethodInfo sharedMethodInfo;
        private final CallTarget callTarget;

        public MaxBlock(RubyContext context) {
            CoreSourceSection sourceSection = new CoreSourceSection("Array", "max");
            this.frameDescriptor = new FrameDescriptor();
            this.frameSlot = this.frameDescriptor.addFrameSlot((Object)"maximum_memo");
            this.sharedMethodInfo = new SharedMethodInfo((SourceSection)sourceSection, null, "max", false, null, false);
            this.callTarget = Truffle.getRuntime().createCallTarget((RootNode)new RubyRootNode(context, (SourceSection)sourceSection, null, this.sharedMethodInfo, ArrayNodesFactory.MaxBlockNodeFactory.create(context, (SourceSection)sourceSection, new RubyNode[]{ReadLevelVariableNodeFactory.create(context, (SourceSection)sourceSection, this.frameSlot, 1), new ReadPreArgumentNode(context, (SourceSection)sourceSection, 0, MissingArgumentBehaviour.RUNTIME_ERROR)})));
        }

        public FrameDescriptor getFrameDescriptor() {
            return this.frameDescriptor;
        }

        public FrameSlot getFrameSlot() {
            return this.frameSlot;
        }

        @Override
        public SharedMethodInfo getSharedMethodInfo() {
            return this.sharedMethodInfo;
        }

        @Override
        public RubyModule getDeclaringModule() {
            throw new UnsupportedOperationException();
        }

        public CallTarget getCallTarget() {
            return this.callTarget;
        }
    }

    public static abstract class MaxBlockNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode compareNode;

        public MaxBlockNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.compareNode = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public MaxBlockNode(MaxBlockNode prev) {
            super(prev);
            this.compareNode = prev.compareNode;
        }

        @Specialization
        public RubyNilClass max(VirtualFrame frame, Object maximumObject, Object value2) {
            Memo maximum = (Memo)maximumObject;
            Object current2 = maximum.get();
            if (current2 == null || (Integer)this.compareNode.call(frame, value2, "<=>", null, current2) < 0) {
                maximum.set(value2);
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"max"})
    public static abstract class MaxNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode eachNode;
        private final MaxBlock maxBlock;

        public MaxNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.eachNode = DispatchHeadNodeFactory.createMethodCall(context);
            this.maxBlock = context.getCoreLibrary().getArrayMaxBlock();
        }

        public MaxNode(MaxNode prev) {
            super(prev);
            this.eachNode = prev.eachNode;
            this.maxBlock = prev.maxBlock;
        }

        @Specialization
        public Object max(VirtualFrame frame, RubyArray array) {
            Memo maximum = new Memo();
            VirtualFrame maximumClosureFrame = Truffle.getRuntime().createVirtualFrame(RubyArguments.pack(this.maxBlock, null, array, null, new Object[0]), this.maxBlock.getFrameDescriptor());
            maximumClosureFrame.setObject(this.maxBlock.getFrameSlot(), maximum);
            RubyProc block = new RubyProc(this.getContext().getCoreLibrary().getProcClass(), RubyProc.Type.PROC, this.maxBlock.getSharedMethodInfo(), this.maxBlock.getCallTarget(), this.maxBlock.getCallTarget(), this.maxBlock.getCallTarget(), maximumClosureFrame.materialize(), null, null, array, null);
            this.eachNode.call(frame, array, "each", block, new Object[0]);
            if (maximum.get() == null) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return maximum.get();
        }
    }

    @CoreMethod(names={"map!", "collect!"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class MapInPlaceNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public MapInPlaceNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public MapInPlaceNode(MapInPlaceNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public RubyArray mapInPlaceFixnumInteger(VirtualFrame frame, RubyArray array, RubyProc block) {
            int[] store = (int[])array.getStore();
            int arraySize = array.getSize();
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count2 = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            array.setStore(this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public RubyArray mapInPlaceObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            Object[] store = (Object[])array.getStore();
            int arraySize = array.getSize();
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count2 = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            array.setStore(this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
            return array;
        }
    }

    @CoreMethod(names={"map", "collect"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class MapNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public MapNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public MapNode(MapNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
        }

        @Specialization(guards={"isNull"})
        public RubyArray mapNull(RubyArray array, RubyProc block) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isIntegerFixnum"})
        public RubyArray mapIntegerFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            int[] store = (int[])array.getStore();
            int arraySize = array.getSize();
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count2 = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isLongFixnum"})
        public RubyArray mapLongFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            long[] store = (long[])array.getStore();
            int arraySize = array.getSize();
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count2 = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isFloat"})
        public RubyArray mapFloat(VirtualFrame frame, RubyArray array, RubyProc block) {
            double[] store = (double[])array.getStore();
            int arraySize = array.getSize();
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count2 = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public RubyArray mapObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            Object[] store = (Object[])array.getStore();
            int arraySize = array.getSize();
            Object mappedStore = this.arrayBuilder.start(arraySize);
            int count2 = 0;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    mappedStore = this.arrayBuilder.append(mappedStore, n, this.yield(frame, block, store[n]));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), this.arrayBuilder.finish(mappedStore, arraySize), arraySize);
        }
    }

    @CoreMethod(names={"last"})
    public static abstract class LastNode
    extends ArrayCoreMethodNode {
        public LastNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public LastNode(LastNode prev) {
            super(prev);
        }

        @Specialization
        public Object last(RubyArray array) {
            LastNode.notDesignedForCompilation();
            if (array.getSize() == 0) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return array.slowToArray()[array.getSize() - 1];
        }
    }

    @CoreMethod(names={"join"}, optional=1)
    public static abstract class JoinNode
    extends ArrayCoreMethodNode {
        public JoinNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public JoinNode(JoinNode prev) {
            super(prev);
        }

        @Specialization
        public RubyString join(RubyArray array, UndefinedPlaceholder unused2) {
            Object separator = this.getContext().getCoreLibrary().getGlobalVariablesObject().getInstanceVariable("$,");
            if (separator == this.getContext().getCoreLibrary().getNilObject()) {
                separator = this.getContext().makeString("");
            }
            if (separator instanceof RubyString) {
                return this.join(array, (RubyString)separator);
            }
            throw new UnsupportedOperationException();
        }

        @Specialization
        public RubyString join(RubyArray array, RubyString separator) {
            JoinNode.notDesignedForCompilation();
            StringBuilder builder = new StringBuilder();
            Object[] objects = array.slowToArray();
            for (int n = 0; n < objects.length; ++n) {
                if (n > 0) {
                    builder.append(separator);
                }
                builder.append(objects[n]);
            }
            return this.getContext().makeString(builder.toString());
        }
    }

    @CoreMethod(names={"inspect", "to_s"})
    public static abstract class InspectNode
    extends CoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode inspect;

        public InspectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.inspect = DispatchHeadNodeFactory.createMethodCall(context);
        }

        public InspectNode(InspectNode prev) {
            super(prev);
            this.inspect = prev.inspect;
        }

        @Specialization
        public RubyString inspect(VirtualFrame frame, RubyArray array) {
            InspectNode.notDesignedForCompilation();
            StringBuilder builder = new StringBuilder();
            Object[] objects = array.slowToArray();
            builder.append("[");
            for (int n = 0; n < objects.length; ++n) {
                if (n > 0) {
                    builder.append(", ");
                }
                RubyString string2 = (RubyString)this.inspect.call(frame, objects[n], "inspect", null, new Object[0]);
                builder.append(string2.getBytes().toString());
            }
            builder.append("]");
            return this.getContext().makeString(builder.toString());
        }
    }

    @CoreMethod(names={"insert"}, required=2)
    public static abstract class InsertNode
    extends ArrayCoreMethodNode {
        private final BranchProfile tooSmallBranch = BranchProfile.create();

        public InsertNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InsertNode(InsertNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public Object insert(RubyArray array, int index2, Object value2) {
            InsertNode.notDesignedForCompilation();
            Object[] store = new Object[index2 + 1];
            Arrays.fill(store, this.getContext().getCoreLibrary().getNilObject());
            store[index2] = value2;
            array.setSize(array.getSize() + 1);
            return array;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public Object insert(RubyArray array, int index2, int value2) {
            int normalisedIndex = array.normaliseIndex(index2);
            int[] store = (int[])array.getStore();
            if (normalisedIndex < 0) {
                this.tooSmallBranch.enter();
                throw new UnsupportedOperationException();
            }
            if (array.getSize() > store.length + 1) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            System.arraycopy(store, normalisedIndex, store, normalisedIndex + 1, array.getSize() - normalisedIndex);
            store[normalisedIndex] = value2;
            array.setSize(array.getSize() + 1);
            return array;
        }
    }

    @CoreMethod(names={"inject", "reduce"}, needsBlock=true, optional=1)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class InjectNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode dispatch;

        public InjectNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.dispatch = DispatchHeadNodeFactory.createMethodCall(context, MissingBehavior.CALL_METHOD_MISSING);
        }

        public InjectNode(InjectNode prev) {
            super(prev);
            this.dispatch = prev.dispatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isObject"})
        public Object injectObject(VirtualFrame frame, RubyArray array, Object initial, RubyProc block) {
            int count2 = 0;
            Object[] store = (Object[])array.getStore();
            Object accumulator = initial;
            try {
                for (int n = 0; n < array.getSize(); ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    accumulator = this.yield(frame, block, accumulator, store[n]);
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    ((RubyRootNode)this.getRootNode()).reportLoopCount(count2);
                }
            }
            return accumulator;
        }

        @Specialization
        public Object inject(VirtualFrame frame, RubyArray array, Object initial, RubyProc block) {
            InjectNode.notDesignedForCompilation();
            Object[] store = array.slowToArray();
            if (store.length < 2) {
                throw new UnsupportedOperationException();
            }
            Object accumulator = initial;
            for (int n = 0; n < array.getSize(); ++n) {
                accumulator = this.yield(frame, block, accumulator, store[n]);
            }
            return accumulator;
        }

        @Specialization
        public Object inject(VirtualFrame frame, RubyArray array, RubySymbol symbol, UndefinedPlaceholder unused2) {
            InjectNode.notDesignedForCompilation();
            Object[] store = array.slowToArray();
            if (store.length < 2) {
                throw new UnsupportedOperationException();
            }
            Object accumulator = this.dispatch.call(frame, store[0], symbol, null, store[1]);
            for (int n = 2; n < array.getSize(); ++n) {
                accumulator = this.dispatch.call(frame, accumulator, symbol, null, store[n]);
            }
            return accumulator;
        }
    }

    @CoreMethod(names={"initialize_copy"}, visibility=Visibility.PRIVATE, required=1)
    public static abstract class InitializeCopyNode
    extends ArrayCoreMethodNode {
        public InitializeCopyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public InitializeCopyNode(InitializeCopyNode prev) {
            super(prev);
        }

        @Specialization(guards={"isOtherNull"})
        public RubyArray initializeCopyNull(RubyArray self2, RubyArray from) {
            if (self2 == from) {
                return self2;
            }
            self2.setStore(null, 0);
            return self2;
        }

        @Specialization(guards={"isOtherIntegerFixnum"})
        public RubyArray initializeCopyIntegerFixnum(RubyArray self2, RubyArray from) {
            if (self2 == from) {
                return self2;
            }
            self2.setStore(Arrays.copyOf((int[])from.getStore(), from.getSize()), from.getSize());
            return self2;
        }

        @Specialization(guards={"isOtherLongFixnum"})
        public RubyArray initializeCopyLongFixnum(RubyArray self2, RubyArray from) {
            if (self2 == from) {
                return self2;
            }
            self2.setStore(Arrays.copyOf((long[])from.getStore(), from.getSize()), from.getSize());
            return self2;
        }

        @Specialization(guards={"isOtherFloat"})
        public RubyArray initializeCopyFloat(RubyArray self2, RubyArray from) {
            if (self2 == from) {
                return self2;
            }
            self2.setStore(Arrays.copyOf((double[])from.getStore(), from.getSize()), from.getSize());
            return self2;
        }

        @Specialization(guards={"isOtherObject"})
        public RubyArray initializeCopyObject(RubyArray self2, RubyArray from) {
            if (self2 == from) {
                return self2;
            }
            self2.setStore(Arrays.copyOf((Object[])from.getStore(), from.getSize()), from.getSize());
            return self2;
        }
    }

    @CoreMethod(names={"initialize"}, needsBlock=true, required=1, optional=1)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class InitializeNode
    extends YieldingCoreMethodNode {
        @Node.Child
        private ArrayBuilderNode arrayBuilder;

        public InitializeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.arrayBuilder = new ArrayBuilderNode.UninitializedArrayBuilderNode(context);
        }

        public InitializeNode(InitializeNode prev) {
            super(prev);
            this.arrayBuilder = prev.arrayBuilder;
        }

        @Specialization
        public RubyArray initialize(RubyArray array, int size2, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            return this.initialize(array, size2, this.getContext().getCoreLibrary().getNilObject(), block);
        }

        @Specialization
        public RubyArray initialize(RubyArray array, long size2, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            if (size2 > Integer.MAX_VALUE) {
                throw new IllegalStateException();
            }
            return this.initialize(array, (int)size2, this.getContext().getCoreLibrary().getNilObject(), block);
        }

        @Specialization
        public RubyArray initialize(RubyArray array, int size2, int defaultValue, UndefinedPlaceholder block) {
            int[] store = new int[size2];
            Arrays.fill(store, defaultValue);
            array.setStore(store, size2);
            return array;
        }

        @Specialization
        public RubyArray initialize(RubyArray array, int size2, long defaultValue, UndefinedPlaceholder block) {
            long[] store = new long[size2];
            Arrays.fill(store, defaultValue);
            array.setStore(store, size2);
            return array;
        }

        @Specialization
        public RubyArray initialize(RubyArray array, int size2, double defaultValue, UndefinedPlaceholder block) {
            double[] store = new double[size2];
            Arrays.fill(store, defaultValue);
            array.setStore(store, size2);
            return array;
        }

        @Specialization
        public RubyArray initialize(RubyArray array, int size2, Object defaultValue, UndefinedPlaceholder block) {
            Object[] store = new Object[size2];
            Arrays.fill(store, defaultValue);
            array.setStore(store, size2);
            return array;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        public RubyArray initialize(VirtualFrame frame, RubyArray array, int size2, UndefinedPlaceholder defaultValue, RubyProc block) {
            Object store = this.arrayBuilder.start(size2);
            int count2 = 0;
            try {
                for (int n = 0; n < size2; ++n) {
                    if (CompilerDirectives.inInterpreter()) {
                        ++count2;
                    }
                    store = this.arrayBuilder.append(store, n, this.yield(frame, block, n));
                }
            }
            finally {
                if (CompilerDirectives.inInterpreter()) {
                    this.getRootNode().reportLoopCount(count2);
                }
            }
            array.setStore(this.arrayBuilder.finish(store, size2), size2);
            return array;
        }

        @Specialization
        public RubyArray initialize(RubyArray array, RubyArray copy, UndefinedPlaceholder defaultValue, UndefinedPlaceholder block) {
            InitializeNode.notDesignedForCompilation();
            array.setStore(copy.slowToArray(), copy.getSize());
            return array;
        }
    }

    @CoreMethod(names={"include?"}, required=1)
    public static abstract class IncludeNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode;

        public IncludeNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        public IncludeNode(IncludeNode prev) {
            super(prev);
            this.equalNode = prev.equalNode;
        }

        @Specialization(guards={"isNull"})
        public boolean includeNull(VirtualFrame frame, RubyArray array, Object value2) {
            return false;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public boolean includeIntegerFixnum(VirtualFrame frame, RubyArray array, Object value2) {
            int[] store = (int[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                Integer stored = store[n];
                IncludeNode.notDesignedForCompilation();
                if (!this.equalNode.executeSameOrEqual(frame, stored, value2)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isLongFixnum"})
        public boolean includeLongFixnum(VirtualFrame frame, RubyArray array, Object value2) {
            long[] store = (long[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                Long stored = store[n];
                IncludeNode.notDesignedForCompilation();
                if (!this.equalNode.executeSameOrEqual(frame, stored, value2)) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isObject"})
        public boolean includeObject(VirtualFrame frame, RubyArray array, Object value2) {
            Object[] store = (Object[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                Object stored = store[n];
                if (!this.equalNode.executeSameOrEqual(frame, stored, value2)) continue;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"hash"})
    public static abstract class HashNode
    extends CoreMethodNode {
        public HashNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public HashNode(HashNode prev) {
            super(prev);
        }

        @Specialization
        public long hashNumber(RubyArray array) {
            return array.hashCode();
        }
    }

    @CoreMethod(names={"flatten"})
    public static abstract class FlattenNode
    extends ArrayCoreMethodNode {
        public FlattenNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FlattenNode(FlattenNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray flatten(RubyArray array) {
            FlattenNode.notDesignedForCompilation();
            ArrayList<Object> flattened = new ArrayList<Object>();
            this.flatten(flattened, array.slowToArray());
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), flattened.toArray(), array.getSize());
        }

        private void flatten(List<Object> flattened, Object[] store) {
            for (Object value2 : store) {
                if (value2 instanceof RubyArray) {
                    this.flatten(flattened, ((RubyArray)value2).slowToArray());
                    continue;
                }
                flattened.add(value2);
            }
        }
    }

    @CoreMethod(names={"first"})
    public static abstract class FirstNode
    extends ArrayCoreMethodNode {
        public FirstNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FirstNode(FirstNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyNilClass firstNull(RubyArray array) {
            FirstNode.notDesignedForCompilation();
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization(guards={"isIntegerFixnum"})
        public Object firstIntegerFixnum(RubyArray array) {
            FirstNode.notDesignedForCompilation();
            if (array.getSize() == 0) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return ((int[])array.getStore())[0];
        }

        @Specialization(guards={"isObject"})
        public Object firstObject(RubyArray array) {
            FirstNode.notDesignedForCompilation();
            if (array.getSize() == 0) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return ((Object[])array.getStore())[0];
        }
    }

    @CoreMethod(names={"find"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class FindNode
    extends YieldingCoreMethodNode {
        public FindNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public FindNode(FindNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public Object findNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization(guards={"isIntegerFixnum"})
        public Object findIntegerFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            FindNode.notDesignedForCompilation();
            int[] store = (int[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                try {
                    Integer value2 = store[n];
                    if (!this.yieldIsTruthy(frame, block, value2)) continue;
                    return value2;
                }
                catch (BreakException e) {
                    break;
                }
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization(guards={"isLongFixnum"})
        public Object findLongFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            FindNode.notDesignedForCompilation();
            long[] store = (long[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                try {
                    Long value2 = store[n];
                    if (!this.yieldIsTruthy(frame, block, value2)) continue;
                    return value2;
                }
                catch (BreakException e) {
                    break;
                }
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization(guards={"isFloat"})
        public Object findFloat(VirtualFrame frame, RubyArray array, RubyProc block) {
            FindNode.notDesignedForCompilation();
            double[] store = (double[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                try {
                    Double value2 = store[n];
                    if (!this.yieldIsTruthy(frame, block, value2)) continue;
                    return value2;
                }
                catch (BreakException e) {
                    break;
                }
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization(guards={"isObject"})
        public Object findObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            FindNode.notDesignedForCompilation();
            Object[] store = (Object[])array.getStore();
            for (int n = 0; n < array.getSize(); ++n) {
                try {
                    Object value2 = store[n];
                    if (!this.yieldIsTruthy(frame, block, value2)) continue;
                    return value2;
                }
                catch (BreakException e) {
                    break;
                }
            }
            return this.getContext().getCoreLibrary().getNilObject();
        }
    }

    @CoreMethod(names={"empty?"})
    public static abstract class EmptyNode
    extends ArrayCoreMethodNode {
        public EmptyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EmptyNode(EmptyNode prev) {
            super(prev);
        }

        @Specialization
        public boolean isEmpty(RubyArray array) {
            return array.getSize() == 0;
        }
    }

    @CoreMethod(names={"each_with_index"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class EachWithIndexNode
    extends YieldingCoreMethodNode {
        private final BranchProfile breakProfile = BranchProfile.create();
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public EachWithIndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachWithIndexNode(EachWithIndexNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyArray eachWithEmpty(VirtualFrame frame, RubyArray array, RubyProc block) {
            return array;
        }

        /*
         * Exception decompiling
         */
        @Specialization(guards={"isObject"})
        public Object eachWithIndexObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @CoreMethod(names={"each"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class EachNode
    extends YieldingCoreMethodNode {
        private final BranchProfile breakProfile = BranchProfile.create();
        private final BranchProfile nextProfile = BranchProfile.create();
        private final BranchProfile redoProfile = BranchProfile.create();

        public EachNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public EachNode(EachNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public Object eachNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return this.getContext().getCoreLibrary().getNilObject();
        }

        /*
         * Exception decompiling
         */
        @Specialization(guards={"isIntegerFixnum"})
        public Object eachIntegerFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Specialization(guards={"isLongFixnum"})
        public Object eachLongFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Specialization(guards={"isFloat"})
        public Object eachFloat(VirtualFrame frame, RubyArray array, RubyProc block) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * Exception decompiling
         */
        @Specialization(guards={"isObject"})
        public Object eachObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [4[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @CoreMethod(names={"delete_at"}, required=1)
    public static abstract class DeleteAtNode
    extends ArrayCoreMethodNode {
        private final BranchProfile tooSmallBranch = BranchProfile.create();
        private final BranchProfile beyondEndBranch = BranchProfile.create();

        public DeleteAtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public DeleteAtNode(DeleteAtNode prev) {
            super(prev);
        }

        @Specialization(guards={"isIntegerFixnum"}, rewriteOn={UnexpectedResultException.class})
        public int deleteAtIntegerFixnumInBounds(RubyArray array, int index2) throws UnexpectedResultException {
            int normalisedIndex = array.normaliseIndex(index2);
            if (normalisedIndex < 0) {
                throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
            }
            if (normalisedIndex >= array.getSize()) {
                throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
            }
            int[] store = (int[])array.getStore();
            int value2 = store[normalisedIndex];
            System.arraycopy(store, normalisedIndex + 1, store, normalisedIndex, array.getSize() - normalisedIndex - 1);
            array.setSize(array.getSize() - 1);
            return value2;
        }

        @Specialization(contains={"deleteAtIntegerFixnumInBounds"}, guards={"isIntegerFixnum"})
        public Object deleteAtIntegerFixnum(RubyArray array, int index2) {
            DeleteAtNode.notDesignedForCompilation();
            int normalisedIndex = index2;
            if (normalisedIndex < 0) {
                normalisedIndex = array.getSize() + index2;
            }
            if (normalisedIndex < 0) {
                this.tooSmallBranch.enter();
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            if (normalisedIndex >= array.getSize()) {
                this.beyondEndBranch.enter();
                throw new UnsupportedOperationException();
            }
            int[] store = (int[])array.getStore();
            int value2 = store[normalisedIndex];
            System.arraycopy(store, normalisedIndex + 1, store, normalisedIndex, array.getSize() - normalisedIndex - 1);
            array.setSize(array.getSize() - 1);
            return value2;
        }
    }

    @CoreMethod(names={"delete"}, required=1)
    public static abstract class DeleteNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private KernelNodes.SameOrEqualNode equalNode;

        public DeleteNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equalNode = KernelNodesFactory.SameOrEqualNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        public DeleteNode(DeleteNode prev) {
            super(prev);
            this.equalNode = prev.equalNode;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public Object deleteIntegerFixnum(VirtualFrame frame, RubyArray array, Object value2) {
            int[] store = (int[])array.getStore();
            Object found = this.getContext().getCoreLibrary().getNilObject();
            int i2 = 0;
            for (int n = 0; n < array.getSize(); ++n) {
                Integer stored = store[n];
                if (this.equalNode.executeSameOrEqual(frame, stored, value2)) {
                    found = store[n];
                    continue;
                }
                if (i2 != n) {
                    store[i2] = store[n];
                }
                ++i2;
            }
            array.setSize(i2);
            return found;
        }

        @Specialization(guards={"isObject"})
        public Object deleteObject(VirtualFrame frame, RubyArray array, Object value2) {
            Object[] store = (Object[])array.getStore();
            Object found = this.getContext().getCoreLibrary().getNilObject();
            int i2 = 0;
            for (int n = 0; n < array.getSize(); ++n) {
                Object stored = store[n];
                if (this.equalNode.executeSameOrEqual(frame, stored, value2)) {
                    found = store[n];
                    continue;
                }
                if (i2 != n) {
                    store[i2] = store[n];
                }
                ++i2;
            }
            array.setSize(i2);
            return found;
        }
    }

    @CoreMethod(names={"concat"}, required=1)
    public static abstract class ConcatNode
    extends ArrayCoreMethodNode {
        public ConcatNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ConcatNode(ConcatNode prev) {
            super(prev);
        }

        @Specialization(guards={"areBothNull"})
        public RubyArray concatNull(RubyArray array, RubyArray other) {
            return array;
        }

        @Specialization(guards={"areBothIntegerFixnum"})
        public RubyArray concatIntegerFixnum(RubyArray array, RubyArray other) {
            ConcatNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((int[])array.getStore(), array.getSize() + other.getSize()), array.getSize());
            System.arraycopy(other.getStore(), 0, array.getStore(), array.getSize(), other.getSize());
            array.setSize(array.getSize() + other.getSize());
            return array;
        }

        @Specialization(guards={"areBothLongFixnum"})
        public RubyArray concatLongFixnum(RubyArray array, RubyArray other) {
            ConcatNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((long[])array.getStore(), array.getSize() + other.getSize()), array.getSize());
            System.arraycopy(other.getStore(), 0, array.getStore(), array.getSize(), other.getSize());
            array.setSize(array.getSize() + other.getSize());
            return array;
        }

        @Specialization(guards={"areBothFloat"})
        public RubyArray concatDouble(RubyArray array, RubyArray other) {
            ConcatNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((double[])array.getStore(), array.getSize() + other.getSize()), array.getSize());
            System.arraycopy(other.getStore(), 0, array.getStore(), array.getSize(), other.getSize());
            array.setSize(array.getSize() + other.getSize());
            return array;
        }

        @Specialization(guards={"areBothObject"})
        public RubyArray concatObject(RubyArray array, RubyArray other) {
            ConcatNode.notDesignedForCompilation();
            array.setStore(Arrays.copyOf((Object[])array.getStore(), array.getSize() + other.getSize()), array.getSize());
            System.arraycopy(other.getStore(), 0, array.getStore(), array.getSize(), other.getSize());
            array.setSize(array.getSize() + other.getSize());
            return array;
        }

        @Specialization
        public RubyArray concat(RubyArray array, RubyArray other) {
            ConcatNode.notDesignedForCompilation();
            Object[] newStore = new Object[array.getSize() + other.getSize()];
            ArrayUtils.copy(array.getStore(), newStore, 0, array.getSize());
            ArrayUtils.copy(other.getStore(), newStore, array.getSize(), other.getSize());
            array.setStore(newStore, array.getSize() + other.getSize());
            return array;
        }
    }

    @CoreMethod(names={"compact"})
    public static abstract class CompactNode
    extends ArrayCoreMethodNode {
        public CompactNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public CompactNode(CompactNode prev) {
            super(prev);
        }

        @Specialization(guards={"!isObject"})
        public RubyArray compatNotObjects(RubyArray array) {
            return array;
        }

        @Specialization(guards={"isObject"})
        public RubyArray compatObjects(RubyArray array) {
            CompactNode.notDesignedForCompilation();
            Object[] compacted = new Object[array.getSize()];
            int compactedSize = 0;
            for (Object object : array.slowToArray()) {
                if (object == this.getContext().getCoreLibrary().getNilObject()) continue;
                compacted[compactedSize] = object;
                ++compactedSize;
            }
            array.setStore(compacted, compactedSize);
            return array;
        }
    }

    @CoreMethod(names={"clear"})
    public static abstract class ClearNode
    extends ArrayCoreMethodNode {
        public ClearNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public ClearNode(ClearNode prev) {
            super(prev);
        }

        @Specialization
        public RubyArray clear(RubyArray array) {
            ClearNode.notDesignedForCompilation();
            array.setSize(0);
            return array;
        }
    }

    @CoreMethod(names={"any?"}, needsBlock=true)
    @ImportGuards(value={ArrayGuards.class})
    public static abstract class AnyNode
    extends YieldingCoreMethodNode {
        public AnyNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AnyNode(AnyNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public boolean anyNull(VirtualFrame frame, RubyArray array, RubyProc block) {
            return false;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public boolean allIntegerFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            AnyNode.notDesignedForCompilation();
            for (int n = 0; n < array.getSize(); ++n) {
                if (!this.yieldIsTruthy(frame, block, ((int[])array.getStore())[n])) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isLongFixnum"})
        public boolean anyLongFixnum(VirtualFrame frame, RubyArray array, RubyProc block) {
            AnyNode.notDesignedForCompilation();
            for (int n = 0; n < array.getSize(); ++n) {
                if (!this.yieldIsTruthy(frame, block, ((long[])array.getStore())[n])) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isFloat"})
        public boolean anyFloat(VirtualFrame frame, RubyArray array, RubyProc block) {
            AnyNode.notDesignedForCompilation();
            for (int n = 0; n < array.getSize(); ++n) {
                if (!this.yieldIsTruthy(frame, block, ((double[])array.getStore())[n])) continue;
                return true;
            }
            return false;
        }

        @Specialization(guards={"isObject"})
        public boolean anyObject(VirtualFrame frame, RubyArray array, RubyProc block) {
            AnyNode.notDesignedForCompilation();
            for (int n = 0; n < array.getSize(); ++n) {
                if (!this.yieldIsTruthy(frame, block, ((Object[])array.getStore())[n])) continue;
                return true;
            }
            return false;
        }
    }

    @CoreMethod(names={"[]="}, required=2, optional=1, lowerFixnumParameters={0})
    public static abstract class IndexSetNode
    extends ArrayCoreMethodNode {
        private final BranchProfile tooSmallBranch = BranchProfile.create();
        private final BranchProfile pastEndBranch = BranchProfile.create();
        private final BranchProfile appendBranch = BranchProfile.create();
        private final BranchProfile beyondBranch = BranchProfile.create();
        private final BranchProfile reallocateBranch = BranchProfile.create();

        public IndexSetNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public IndexSetNode(IndexSetNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public Object setNullIntegerFixnum(RubyArray array, int index2, int value2, UndefinedPlaceholder unused2) {
            if (index2 != 0) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            array.setStore(new int[]{value2}, 1);
            return value2;
        }

        @Specialization(guards={"isNull"})
        public Object setNullLongFixnum(RubyArray array, int index2, long value2, UndefinedPlaceholder unused2) {
            if (index2 != 0) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            array.setStore(new long[]{value2}, 1);
            return value2;
        }

        @Specialization(guards={"isNull"})
        public Object setNullObject(RubyArray array, int index2, Object value2, UndefinedPlaceholder unused2) {
            IndexSetNode.notDesignedForCompilation();
            if (index2 != 0) {
                throw new UnsupportedOperationException();
            }
            array.slowPush(value2);
            return value2;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public int setIntegerFixnum(RubyArray array, int index2, int value2, UndefinedPlaceholder unused2) {
            int normalisedIndex = array.normaliseIndex(index2);
            int[] store = (int[])array.getStore();
            if (normalisedIndex < 0) {
                this.tooSmallBranch.enter();
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexTooSmallError("array", index2, array.getSize(), this));
            }
            if (normalisedIndex >= array.getSize()) {
                this.pastEndBranch.enter();
                if (normalisedIndex == array.getSize()) {
                    this.appendBranch.enter();
                    if (normalisedIndex >= store.length) {
                        this.reallocateBranch.enter();
                        store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, normalisedIndex + 1));
                        array.setStore(store, array.getSize());
                    }
                    store[normalisedIndex] = value2;
                    array.setSize(array.getSize() + 1);
                } else if (normalisedIndex > array.getSize()) {
                    this.beyondBranch.enter();
                    throw new UnsupportedOperationException();
                }
            } else {
                store[normalisedIndex] = value2;
            }
            return value2;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public long setLongInIntegerFixnum(RubyArray array, int index2, long value2, UndefinedPlaceholder unused2) {
            if (array.getAllocationSite() != null) {
                array.getAllocationSite().convertedIntToLong();
            }
            int normalisedIndex = array.normaliseIndex(index2);
            long[] store = ArrayUtils.longCopyOf((int[])array.getStore());
            array.setStore(store, array.getSize());
            if (normalisedIndex < 0) {
                this.tooSmallBranch.enter();
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexTooSmallError("array", index2, array.getSize(), this));
            }
            if (normalisedIndex >= array.getSize()) {
                this.pastEndBranch.enter();
                if (normalisedIndex == array.getSize()) {
                    this.appendBranch.enter();
                    if (normalisedIndex >= store.length) {
                        this.reallocateBranch.enter();
                        store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, normalisedIndex + 1));
                        array.setStore(store, array.getSize());
                    }
                    store[normalisedIndex] = value2;
                    array.setSize(array.getSize() + 1);
                } else if (normalisedIndex > array.getSize()) {
                    this.beyondBranch.enter();
                    throw new UnsupportedOperationException();
                }
            } else {
                store[normalisedIndex] = value2;
            }
            return value2;
        }

        @Specialization(guards={"isIntegerFixnum"})
        public RubyArray setIntegerFixnum(RubyArray array, int start2, int length2, RubyArray value2) {
            IndexSetNode.notDesignedForCompilation();
            if (length2 < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexNegativeLength(length2, this));
            }
            if (value2.getSize() == 0) {
                int begin2 = array.normaliseIndex(start2);
                int exclusiveEnd = begin2 + length2;
                int[] store = (int[])array.getStore();
                if (begin2 < 0) {
                    this.tooSmallBranch.enter();
                    CompilerDirectives.transferToInterpreter();
                    throw new RaiseException(this.getContext().getCoreLibrary().indexTooSmallError("array", start2, array.getSize(), this));
                }
                if (exclusiveEnd > array.getSize()) {
                    throw new UnsupportedOperationException();
                }
                System.arraycopy(store, exclusiveEnd, store, begin2, array.getSize() - exclusiveEnd);
                array.setSize(array.getSize() - length2);
                return value2;
            }
            throw new UnsupportedOperationException();
        }

        @Specialization(guards={"isLongFixnum"})
        public int setLongFixnum(RubyArray array, int index2, int value2, UndefinedPlaceholder unused2) {
            this.setLongFixnum(array, index2, (long)value2, unused2);
            return value2;
        }

        @Specialization(guards={"isLongFixnum"})
        public long setLongFixnum(RubyArray array, int index2, long value2, UndefinedPlaceholder unused2) {
            int normalisedIndex = array.normaliseIndex(index2);
            long[] store = (long[])array.getStore();
            if (normalisedIndex < 0) {
                this.tooSmallBranch.enter();
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexTooSmallError("array", index2, array.getSize(), this));
            }
            if (normalisedIndex >= array.getSize()) {
                this.pastEndBranch.enter();
                if (normalisedIndex == array.getSize()) {
                    this.appendBranch.enter();
                    if (normalisedIndex >= store.length) {
                        this.reallocateBranch.enter();
                        store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, normalisedIndex + 1));
                        array.setStore(store, array.getSize());
                    }
                    store[normalisedIndex] = value2;
                    array.setSize(array.getSize() + 1);
                } else if (normalisedIndex > array.getSize()) {
                    this.beyondBranch.enter();
                    throw new UnsupportedOperationException();
                }
            } else {
                store[normalisedIndex] = value2;
            }
            return value2;
        }

        @Specialization(guards={"isFloat"})
        public double setFloat(RubyArray array, int index2, double value2, UndefinedPlaceholder unused2) {
            int normalisedIndex = array.normaliseIndex(index2);
            double[] store = (double[])array.getStore();
            if (normalisedIndex < 0) {
                this.tooSmallBranch.enter();
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexTooSmallError("array", index2, array.getSize(), this));
            }
            if (normalisedIndex >= array.getSize()) {
                this.pastEndBranch.enter();
                if (normalisedIndex == array.getSize()) {
                    this.appendBranch.enter();
                    if (normalisedIndex >= store.length) {
                        this.reallocateBranch.enter();
                        store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, normalisedIndex + 1));
                        array.setStore(store, array.getSize());
                    }
                    store[normalisedIndex] = value2;
                    array.setSize(array.getSize() + 1);
                } else if (normalisedIndex > array.getSize()) {
                    this.beyondBranch.enter();
                    throw new UnsupportedOperationException();
                }
            } else {
                store[normalisedIndex] = value2;
            }
            return value2;
        }

        @Specialization(guards={"isObject"})
        public Object setObject(RubyArray array, int index2, Object value2, UndefinedPlaceholder unused2) {
            int normalisedIndex = array.normaliseIndex(index2);
            Object[] store = (Object[])array.getStore();
            if (normalisedIndex < 0) {
                this.tooSmallBranch.enter();
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexTooSmallError("array", index2, array.getSize(), this));
            }
            if (normalisedIndex >= array.getSize()) {
                this.pastEndBranch.enter();
                if (normalisedIndex == array.getSize()) {
                    this.appendBranch.enter();
                    if (normalisedIndex >= store.length) {
                        this.reallocateBranch.enter();
                        store = Arrays.copyOf(store, ArrayUtils.capacity(store.length, normalisedIndex + 1));
                        array.setStore(store, array.getSize());
                    }
                    store[normalisedIndex] = value2;
                    array.setSize(array.getSize() + 1);
                } else if (normalisedIndex > array.getSize()) {
                    this.beyondBranch.enter();
                    throw new UnsupportedOperationException();
                }
            } else {
                store[normalisedIndex] = value2;
            }
            return value2;
        }

        @Specialization(guards={"isObject", "!isRubyArray(arguments[3])"})
        public Object setObject(RubyArray array, int start2, int length2, Object value2) {
            IndexSetNode.notDesignedForCompilation();
            if (length2 < 0) {
                CompilerDirectives.transferToInterpreter();
                throw new RaiseException(this.getContext().getCoreLibrary().indexNegativeLength(length2, this));
            }
            int begin2 = array.normaliseIndex(start2);
            if (begin2 >= array.getSize()) {
                return this.setObject(array, start2, value2, UndefinedPlaceholder.INSTANCE);
            }
            throw new UnsupportedOperationException();
        }

        @Specialization(guards={"isIntegerFixnum"})
        public RubyArray setIntegerFixnumRange(RubyArray array, RubyRange.IntegerFixnumRange range, RubyArray other, UndefinedPlaceholder unused2) {
            if (range.doesExcludeEnd()) {
                CompilerDirectives.transferToInterpreter();
                throw new UnsupportedOperationException();
            }
            int normalisedBegin = array.normaliseIndex(range.getBegin());
            int normalisedEnd = array.normaliseIndex(range.getEnd());
            if (normalisedBegin != 0 || normalisedEnd != array.getSize() - 1) {
                throw new RuntimeException();
            }
            array.setStore(Arrays.copyOf((int[])other.getStore(), other.getSize()), other.getSize());
            return other;
        }
    }

    @CoreMethod(names={"[]", "slice"}, required=1, optional=1, lowerFixnumParameters={0, 1})
    public static abstract class IndexNode
    extends ArrayCoreMethodNode {
        @Node.Child
        protected AtNode atNode;
        private final BranchProfile outOfBounds = BranchProfile.create();

        public IndexNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.atNode = ArrayNodesFactory.AtNodeFactory.create(context, sourceSection, new RubyNode[]{null, null});
        }

        public IndexNode(IndexNode prev) {
            super(prev);
            this.atNode = prev.atNode;
        }

        @Specialization
        public Object index(RubyArray array, int index2, UndefinedPlaceholder undefined) {
            return this.atNode.executeAt(array, index2);
        }

        @Specialization(guards={"isIntegerFixnum"})
        public Object sliceIntegerFixnum(RubyArray array, int start2, int length2) {
            int normalisedIndex = array.normaliseIndex(start2);
            if (normalisedIndex < 0 || normalisedIndex > array.getSize() || length2 < 0) {
                this.outOfBounds.enter();
                return this.getContext().getCoreLibrary().getNilObject();
            }
            int end2 = Math.min(array.getSize(), normalisedIndex + length2);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((int[])array.getStore(), normalisedIndex, end2), end2 - normalisedIndex);
        }

        @Specialization(guards={"isLongFixnum"})
        public Object sliceLongFixnum(RubyArray array, int start2, int length2) {
            int normalisedIndex = array.normaliseIndex(start2);
            if (normalisedIndex < 0 || normalisedIndex > array.getSize() || length2 < 0) {
                this.outOfBounds.enter();
                return this.getContext().getCoreLibrary().getNilObject();
            }
            int end2 = Math.min(array.getSize(), normalisedIndex + length2);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((long[])array.getStore(), normalisedIndex, end2), end2 - normalisedIndex);
        }

        @Specialization(guards={"isFloat"})
        public Object sliceFloat(RubyArray array, int start2, int length2) {
            int normalisedIndex = array.normaliseIndex(start2);
            if (normalisedIndex < 0 || normalisedIndex > array.getSize() || length2 < 0) {
                this.outOfBounds.enter();
                return this.getContext().getCoreLibrary().getNilObject();
            }
            int end2 = Math.min(array.getSize(), normalisedIndex + length2);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((double[])array.getStore(), normalisedIndex, end2), end2 - normalisedIndex);
        }

        @Specialization(guards={"isObject"})
        public Object sliceObject(RubyArray array, int start2, int length2) {
            int normalisedIndex = array.normaliseIndex(start2);
            if (normalisedIndex < 0 || normalisedIndex > array.getSize() || length2 < 0) {
                this.outOfBounds.enter();
                return this.getContext().getCoreLibrary().getNilObject();
            }
            int end2 = Math.min(array.getSize(), normalisedIndex + length2);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((Object[])array.getStore(), normalisedIndex, end2), end2 - normalisedIndex);
        }

        @Specialization(guards={"isObject"})
        public Object sliceObject(RubyArray array, RubyRange.IntegerFixnumRange range, UndefinedPlaceholder undefined) {
            IndexNode.notDesignedForCompilation();
            int normalisedIndex = array.normaliseIndex(range.getBegin());
            if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            int end2 = array.normaliseIndex(range.getEnd());
            int excludingEnd = array.clampExclusiveIndex(range.doesExcludeEnd() ? end2 : end2 + 1);
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), ArrayUtils.extractRange((Object[])array.getStore(), normalisedIndex, excludingEnd), excludingEnd - normalisedIndex);
        }
    }

    @CoreMethod(names={"at"}, required=1, lowerFixnumParameters={0})
    public static abstract class AtNode
    extends ArrayCoreMethodNode {
        public AtNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AtNode(AtNode prev) {
            super(prev);
        }

        public abstract Object executeAt(RubyArray var1, int var2);

        @Specialization(guards={"isNull"})
        public RubyNilClass getNull(RubyArray array, int index2) {
            return this.getContext().getCoreLibrary().getNilObject();
        }

        @Specialization(guards={"isIntegerFixnum"}, rewriteOn={UnexpectedResultException.class})
        public int getIntegerFixnumInBounds(RubyArray array, int index2) throws UnexpectedResultException {
            int normalisedIndex = array.normaliseIndex(index2);
            if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
                throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
            }
            return ((int[])array.getStore())[normalisedIndex];
        }

        @Specialization(contains={"getIntegerFixnumInBounds"}, guards={"isIntegerFixnum"})
        public Object getIntegerFixnum(RubyArray array, int index2) {
            int normalisedIndex = array.normaliseIndex(index2);
            if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return ((int[])array.getStore())[normalisedIndex];
        }

        @Specialization(guards={"isLongFixnum"}, rewriteOn={UnexpectedResultException.class})
        public long getLongFixnumInBounds(RubyArray array, int index2) throws UnexpectedResultException {
            int normalisedIndex = array.normaliseIndex(index2);
            if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
                throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
            }
            return ((long[])array.getStore())[normalisedIndex];
        }

        @Specialization(contains={"getLongFixnumInBounds"}, guards={"isLongFixnum"})
        public Object getLongFixnum(RubyArray array, int index2) {
            int normalisedIndex = array.normaliseIndex(index2);
            if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return ((long[])array.getStore())[normalisedIndex];
        }

        @Specialization(guards={"isFloat"}, rewriteOn={UnexpectedResultException.class})
        public double getFloatInBounds(RubyArray array, int index2) throws UnexpectedResultException {
            int normalisedIndex = array.normaliseIndex(index2);
            if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
                throw new UnexpectedResultException((Object)this.getContext().getCoreLibrary().getNilObject());
            }
            return ((double[])array.getStore())[normalisedIndex];
        }

        @Specialization(contains={"getFloatInBounds"}, guards={"isFloat"})
        public Object getFloat(RubyArray array, int index2) {
            int normalisedIndex = array.normaliseIndex(index2);
            if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return ((double[])array.getStore())[normalisedIndex];
        }

        @Specialization(guards={"isObject"})
        public Object getObject(RubyArray array, int index2) {
            int normalisedIndex = array.normaliseIndex(index2);
            if (normalisedIndex < 0 || normalisedIndex >= array.getSize()) {
                return this.getContext().getCoreLibrary().getNilObject();
            }
            return ((Object[])array.getStore())[normalisedIndex];
        }
    }

    @CoreMethod(names={"==", "eql?"}, required=1)
    public static abstract class EqualNode
    extends ArrayCoreMethodNode {
        @Node.Child
        private CallDispatchHeadNode equals;

        public EqualNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
            this.equals = DispatchHeadNodeFactory.createMethodCall(context, false, false, null);
        }

        public EqualNode(EqualNode prev) {
            super(prev);
            this.equals = prev.equals;
        }

        @Specialization(guards={"areBothIntegerFixnum"})
        public boolean equalIntegerFixnum(RubyArray a, RubyArray b2) {
            EqualNode.notDesignedForCompilation();
            if (a == b2) {
                return true;
            }
            if (a.getSize() != b2.getSize()) {
                return false;
            }
            return Arrays.equals((int[])a.getStore(), (int[])b2.getStore());
        }

        @Specialization(guards={"areBothLongFixnum"})
        public boolean equalLongFixnum(RubyArray a, RubyArray b2) {
            EqualNode.notDesignedForCompilation();
            if (a == b2) {
                return true;
            }
            if (a.getSize() != b2.getSize()) {
                return false;
            }
            return Arrays.equals((long[])a.getStore(), (long[])b2.getStore());
        }

        @Specialization(guards={"areBothFloat"})
        public boolean equalFloat(RubyArray a, RubyArray b2) {
            EqualNode.notDesignedForCompilation();
            if (a == b2) {
                return true;
            }
            if (a.getSize() != b2.getSize()) {
                return false;
            }
            return Arrays.equals((double[])a.getStore(), (double[])b2.getStore());
        }

        @Specialization
        public boolean equal(VirtualFrame frame, RubyArray a, RubyArray b2) {
            EqualNode.notDesignedForCompilation();
            if (a == b2) {
                return true;
            }
            if (a.getSize() != b2.getSize()) {
                return false;
            }
            Object[] as = a.slowToArray();
            Object[] bs = b2.slowToArray();
            for (int n = 0; n < a.getSize(); ++n) {
                if (this.equals.callBoolean(frame, as[n], "==", null, bs[n])) continue;
                return false;
            }
            return true;
        }

        @Specialization
        public boolean equal(VirtualFrame frame, RubyArray a, Object b2) {
            EqualNode.notDesignedForCompilation();
            if (!(b2 instanceof RubyArray)) {
                return false;
            }
            return this.equal(frame, a, (RubyArray)b2);
        }
    }

    @CoreMethod(names={"|"}, required=1)
    public static abstract class UnionNode
    extends ArrayCoreMethodNode {
        public UnionNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public UnionNode(UnionNode prev) {
            super(prev);
        }

        @Specialization(guards={"areBothIntegerFixnum"})
        public RubyArray orIntegerFixnum(RubyArray a, RubyArray b2) {
            UnionNode.notDesignedForCompilation();
            int[] as = (int[])a.getStore();
            int[] bs = (int[])b2.getStore();
            int[] or = Arrays.copyOf(as, a.getSize() + b2.getSize());
            int i2 = a.getSize();
            for (int n = 0; n < b2.getSize(); ++n) {
                if (ArrayUtils.contains(as, bs[n])) continue;
                or[i2] = bs[n];
                ++i2;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), or, i2);
        }

        @Specialization(guards={"areBothLongFixnum"})
        public RubyArray orLongFixnum(RubyArray a, RubyArray b2) {
            UnionNode.notDesignedForCompilation();
            long[] as = (long[])a.getStore();
            long[] bs = (long[])b2.getStore();
            long[] or = Arrays.copyOf(as, a.getSize() + b2.getSize());
            int i2 = a.getSize();
            for (int n = 0; n < b2.getSize(); ++n) {
                if (ArrayUtils.contains(as, bs[n])) continue;
                or[i2] = bs[n];
                ++i2;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), or, i2);
        }

        @Specialization(guards={"areBothFloat"})
        public RubyArray orDouble(RubyArray a, RubyArray b2) {
            UnionNode.notDesignedForCompilation();
            double[] as = (double[])a.getStore();
            double[] bs = (double[])b2.getStore();
            double[] or = Arrays.copyOf(as, a.getSize() + b2.getSize());
            int i2 = a.getSize();
            for (int n = 0; n < b2.getSize(); ++n) {
                if (ArrayUtils.contains(as, bs[n])) continue;
                or[i2] = bs[n];
                ++i2;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), or, i2);
        }

        @Specialization(guards={"areBothObject"})
        public RubyArray orObject(RubyArray a, RubyArray b2) {
            UnionNode.notDesignedForCompilation();
            Object[] as = (Object[])a.getStore();
            Object[] bs = (Object[])b2.getStore();
            Object[] or = Arrays.copyOf(as, a.getSize() + b2.getSize());
            int i2 = a.getSize();
            for (int n = 0; n < b2.getSize(); ++n) {
                if (ArrayUtils.contains(as, a.getSize(), bs[n])) continue;
                or[i2] = bs[n];
                ++i2;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), or, i2);
        }
    }

    @CoreMethod(names={"*"}, required=1, lowerFixnumParameters={0})
    public static abstract class MulNode
    extends ArrayCoreMethodNode {
        public MulNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public MulNode(MulNode prev) {
            super(prev);
        }

        @Specialization(guards={"isNull"})
        public RubyArray mulEmpty(RubyArray array, int count2) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
        }

        @Specialization(guards={"isIntegerFixnum"})
        public RubyArray mulIntegerFixnum(RubyArray array, int count2) {
            int[] store = (int[])array.getStore();
            int storeLength = store.length;
            int newStoreLength = storeLength * count2;
            int[] newStore = new int[newStoreLength];
            for (int n = 0; n < count2; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), array.getAllocationSite(), newStore, newStoreLength);
        }

        @Specialization(guards={"isLongFixnum"})
        public RubyArray mulLongFixnum(RubyArray array, int count2) {
            long[] store = (long[])array.getStore();
            int storeLength = store.length;
            int newStoreLength = storeLength * count2;
            long[] newStore = new long[newStoreLength];
            for (int n = 0; n < count2; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), array.getAllocationSite(), newStore, newStoreLength);
        }

        @Specialization(guards={"isFloat"})
        public RubyArray mulFloat(RubyArray array, int count2) {
            double[] store = (double[])array.getStore();
            int storeLength = store.length;
            int newStoreLength = storeLength * count2;
            double[] newStore = new double[newStoreLength];
            for (int n = 0; n < count2; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), array.getAllocationSite(), newStore, newStoreLength);
        }

        @Specialization(guards={"isObject"})
        public RubyArray mulObject(RubyArray array, int count2) {
            Object[] store = (Object[])array.getStore();
            int storeLength = store.length;
            int newStoreLength = storeLength * count2;
            Object[] newStore = new Object[newStoreLength];
            for (int n = 0; n < count2; ++n) {
                System.arraycopy(store, 0, newStore, storeLength * n, storeLength);
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), array.getAllocationSite(), newStore, newStoreLength);
        }
    }

    @CoreMethod(names={"-"}, required=1)
    public static abstract class SubNode
    extends ArrayCoreMethodNode {
        public SubNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public SubNode(SubNode prev) {
            super(prev);
        }

        @Specialization(guards={"areBothIntegerFixnum"})
        public RubyArray subIntegerFixnum(RubyArray a, RubyArray b2) {
            SubNode.notDesignedForCompilation();
            int[] as = (int[])a.getStore();
            int[] bs = (int[])b2.getStore();
            int[] sub2 = new int[a.getSize()];
            int i2 = 0;
            for (int n = 0; n < a.getSize(); ++n) {
                if (ArrayUtils.contains(bs, as[n])) continue;
                sub2[i2] = as[n];
                ++i2;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), sub2, i2);
        }

        @Specialization(guards={"areBothLongFixnum"})
        public RubyArray subLongFixnum(RubyArray a, RubyArray b2) {
            SubNode.notDesignedForCompilation();
            long[] as = (long[])a.getStore();
            long[] bs = (long[])b2.getStore();
            long[] sub2 = new long[a.getSize()];
            int i2 = 0;
            for (int n = 0; n < a.getSize(); ++n) {
                if (ArrayUtils.contains(bs, as[n])) continue;
                sub2[i2] = as[n];
                ++i2;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), sub2, i2);
        }

        @Specialization(guards={"areBothFloat"})
        public RubyArray subDouble(RubyArray a, RubyArray b2) {
            SubNode.notDesignedForCompilation();
            double[] as = (double[])a.getStore();
            double[] bs = (double[])b2.getStore();
            double[] sub2 = new double[a.getSize()];
            int i2 = 0;
            for (int n = 0; n < a.getSize(); ++n) {
                if (ArrayUtils.contains(bs, as[n])) continue;
                sub2[i2] = as[n];
                ++i2;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), sub2, i2);
        }

        @Specialization(guards={"areBothObject"})
        public RubyArray subObject(RubyArray a, RubyArray b2) {
            SubNode.notDesignedForCompilation();
            Object[] as = (Object[])a.getStore();
            Object[] bs = (Object[])b2.getStore();
            Object[] sub2 = new Object[a.getSize()];
            int i2 = 0;
            for (int n = 0; n < a.getSize(); ++n) {
                if (ArrayUtils.contains(bs, b2.getSize(), as[n])) continue;
                sub2[i2] = as[n];
                ++i2;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), sub2, i2);
        }

        @Specialization(guards={"isObject", "isOtherIntegerFixnum"})
        public RubyArray subObjectIntegerFixnum(RubyArray a, RubyArray b2) {
            SubNode.notDesignedForCompilation();
            Object[] as = (Object[])a.getStore();
            Object[] bs = ArrayUtils.box((int[])b2.getStore());
            Object[] sub2 = new Object[a.getSize()];
            int i2 = 0;
            for (int n = 0; n < a.getSize(); ++n) {
                if (ArrayUtils.contains(bs, b2.getSize(), as[n])) continue;
                sub2[i2] = as[n];
                ++i2;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), sub2, i2);
        }

        @Specialization
        public RubyArray sub(RubyArray a, RubyArray b2) {
            SubNode.notDesignedForCompilation();
            Object[] as = a.slowToArray();
            Object[] bs = b2.slowToArray();
            Object[] sub2 = new Object[a.getSize()];
            int i2 = 0;
            for (int n = 0; n < a.getSize(); ++n) {
                if (ArrayUtils.contains(bs, b2.getSize(), as[n])) continue;
                sub2[i2] = as[n];
                ++i2;
            }
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), sub2, i2);
        }
    }

    @CoreMethod(names={"+"}, required=1)
    public static abstract class AddNode
    extends ArrayCoreMethodNode {
        public AddNode(RubyContext context, SourceSection sourceSection) {
            super(context, sourceSection);
        }

        public AddNode(AddNode prev) {
            super(prev);
        }

        @Specialization(guards={"isObject", "isOtherNull"})
        public RubyArray addObjectNull(RubyArray a, RubyArray b2) {
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((Object[])a.getStore(), a.getSize()), a.getSize());
        }

        @Specialization(guards={"areBothIntegerFixnum"})
        public RubyArray addBothIntegerFixnum(RubyArray a, RubyArray b2) {
            int combinedSize = a.getSize() + b2.getSize();
            int[] combined = new int[combinedSize];
            System.arraycopy(a.getStore(), 0, combined, 0, a.getSize());
            System.arraycopy(b2.getStore(), 0, combined, a.getSize(), b2.getSize());
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), combined, combinedSize);
        }

        @Specialization(guards={"areBothLongFixnum"})
        public RubyArray addBothLongFixnum(RubyArray a, RubyArray b2) {
            int combinedSize = a.getSize() + b2.getSize();
            long[] combined = new long[combinedSize];
            System.arraycopy(a.getStore(), 0, combined, 0, a.getSize());
            System.arraycopy(b2.getStore(), 0, combined, a.getSize(), b2.getSize());
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), combined, combinedSize);
        }

        @Specialization(guards={"areBothFloat"})
        public RubyArray addBothFloat(RubyArray a, RubyArray b2) {
            int combinedSize = a.getSize() + b2.getSize();
            double[] combined = new double[combinedSize];
            System.arraycopy(a.getStore(), 0, combined, 0, a.getSize());
            System.arraycopy(b2.getStore(), 0, combined, a.getSize(), b2.getSize());
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), combined, combinedSize);
        }

        @Specialization(guards={"areBothObject"})
        public RubyArray addBothObject(RubyArray a, RubyArray b2) {
            int combinedSize = a.getSize() + b2.getSize();
            Object[] combined = new Object[combinedSize];
            System.arraycopy(a.getStore(), 0, combined, 0, a.getSize());
            System.arraycopy(b2.getStore(), 0, combined, a.getSize(), b2.getSize());
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), combined, combinedSize);
        }

        @Specialization(guards={"isNull", "isOtherIntegerFixnum"})
        public RubyArray addNullIntegerFixnum(RubyArray a, RubyArray b2) {
            int size2 = b2.getSize();
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((int[])b2.getStore(), size2), size2);
        }

        @Specialization(guards={"isNull", "isOtherLongFixnum"})
        public RubyArray addNullLongFixnum(RubyArray a, RubyArray b2) {
            int size2 = b2.getSize();
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((long[])b2.getStore(), size2), size2);
        }

        @Specialization(guards={"isNull", "isOtherObject"})
        public RubyArray addNullObject(RubyArray a, RubyArray b2) {
            int size2 = b2.getSize();
            return new RubyArray(this.getContext().getCoreLibrary().getArrayClass(), Arrays.copyOf((Object[])b2.getStore(), size2), size2);
        }
    }
}

