/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.core;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.internal.DSLMetadata;
import com.oracle.truffle.api.dsl.internal.DSLNode;
import com.oracle.truffle.api.dsl.internal.DSLShare;
import com.oracle.truffle.api.dsl.internal.NodeFactoryBase;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.nodes.NodeInfo;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.core.ArrayDropTailNode;
import org.jruby.truffle.nodes.core.ArrayGuards;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;

@GeneratedBy(value=ArrayDropTailNode.class)
public final class ArrayDropTailNodeFactory
extends NodeFactoryBase<ArrayDropTailNode> {
    private static ArrayDropTailNodeFactory instance;

    private ArrayDropTailNodeFactory() {
        super(ArrayDropTailNode.class, new Class[]{RubyNode.class}, (Class[][])new Class[][]{{RubyContext.class, SourceSection.class, Integer.TYPE, RubyNode.class}});
    }

    public ArrayDropTailNode createNode(Object ... arguments) {
        if (arguments.length == 4 && (arguments[0] == null || arguments[0] instanceof RubyContext) && (arguments[1] == null || arguments[1] instanceof SourceSection) && arguments[2] instanceof Integer && (arguments[3] == null || arguments[3] instanceof RubyNode)) {
            return ArrayDropTailNodeFactory.create((RubyContext)((Object)arguments[0]), (SourceSection)arguments[1], (Integer)arguments[2], (RubyNode)((Object)arguments[3]));
        }
        throw new IllegalArgumentException("Invalid create signature.");
    }

    public static ArrayDropTailNode create(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
        return ArrayDropTailUninitializedNode.create0(context, sourceSection, index2, array);
    }

    public static NodeFactory<ArrayDropTailNode> getInstance() {
        if (instance == null) {
            instance = new ArrayDropTailNodeFactory();
        }
        return instance;
    }

    @GeneratedBy(value=ArrayDropTailNode.class)
    @NodeInfo(cost=NodeCost.POLYMORPHIC)
    private static final class ArrayDropTailPolymorphicNode
    extends ArrayDropTailBaseNode {
        @CompilerDirectives.CompilationFinal
        private Class<?> arrayPolymorphicType;

        ArrayDropTailPolymorphicNode(ArrayDropTailBaseNode copy) {
            super(copy);
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            Object arrayValue = this.array.execute(frameValue);
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        @Override
        public void updateTypes0(Class<?>[] types) {
            this.arrayPolymorphicType = types[0];
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            return this.next0.executeChained0(frameValue, arrayValue);
        }
    }

    @GeneratedBy(value=ArrayDropTailNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayDropTailRubyArray4Node
    extends ArrayDropTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDropTailRubyArray4Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayDropTailRubyArray4Node(ArrayDropTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isObject(arrayValue)) {
                return super.getHeadObject(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isObject] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isObject(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getHeadObject(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayDropTailNode create0(ArrayDropTailNode current2) {
            return new ArrayDropTailRubyArray4Node((ArrayDropTailBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayDropTailNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayDropTailRubyArray3Node
    extends ArrayDropTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDropTailRubyArray3Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayDropTailRubyArray3Node(ArrayDropTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isFloat(arrayValue)) {
                return super.getHeadFloat(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isFloat] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isFloat(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getHeadFloat(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayDropTailNode create0(ArrayDropTailNode current2) {
            return new ArrayDropTailRubyArray3Node((ArrayDropTailBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayDropTailNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayDropTailRubyArray2Node
    extends ArrayDropTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDropTailRubyArray2Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayDropTailRubyArray2Node(ArrayDropTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isLongFixnum(arrayValue)) {
                return super.geHeadLongFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isLongFixnum] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isLongFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.geHeadLongFixnum(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayDropTailNode create0(ArrayDropTailNode current2) {
            return new ArrayDropTailRubyArray2Node((ArrayDropTailBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayDropTailNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayDropTailRubyArray1Node
    extends ArrayDropTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDropTailRubyArray1Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayDropTailRubyArray1Node(ArrayDropTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isIntegerFixnum(arrayValue)) {
                return super.getHeadIntegerFixnum(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isIntegerFixnum] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isIntegerFixnum(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getHeadIntegerFixnum(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayDropTailNode create0(ArrayDropTailNode current2) {
            return new ArrayDropTailRubyArray1Node((ArrayDropTailBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayDropTailNode.class)
    @NodeInfo(cost=NodeCost.MONOMORPHIC)
    private static final class ArrayDropTailRubyArray0Node
    extends ArrayDropTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDropTailRubyArray0Node.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{RubyArray.class}, 0, 0);

        ArrayDropTailRubyArray0Node(ArrayDropTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            RubyArray arrayValue;
            try {
                arrayValue = this.array.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return this.rewrite0(frameValue, ex.getResult(), "Expected arrayValue instanceof RubyArray");
            }
            if (ArrayGuards.isNull(arrayValue)) {
                return super.getHeadNull(arrayValue);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return this.rewrite0(frameValue, arrayValue, "One of guards [isNull] failed");
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            RubyArray arrayValueCast;
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue) && ArrayGuards.isNull(arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue))) {
                return super.getHeadNull(arrayValueCast);
            }
            return this.next0.executeChained0(frameValue, arrayValue);
        }

        static ArrayDropTailNode create0(ArrayDropTailNode current2) {
            return new ArrayDropTailRubyArray0Node((ArrayDropTailBaseNode)current2);
        }
    }

    @GeneratedBy(value=ArrayDropTailNode.class)
    @NodeInfo(cost=NodeCost.UNINITIALIZED)
    private static final class ArrayDropTailUninitializedNode
    extends ArrayDropTailBaseNode {
        private static final DSLMetadata METADATA = new DSLMetadata(ArrayDropTailUninitializedNode.class, DSLMetadata.EMPTY_CLASS_ARRAY, DSLMetadata.EMPTY_CLASS_ARRAY, new Class[]{Object.class}, 0, 0);
        @CompilerDirectives.CompilationFinal
        private boolean containsFallback;

        ArrayDropTailUninitializedNode(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
            super(context, sourceSection, index2, array);
        }

        ArrayDropTailUninitializedNode(ArrayDropTailBaseNode copy) {
            super(copy);
        }

        @Override
        public DSLMetadata getMetadata0() {
            return METADATA;
        }

        public NodeCost getCost() {
            if (this.containsFallback) {
                return NodeCost.MONOMORPHIC;
            }
            return super.getCost();
        }

        @Override
        public Object execute(VirtualFrame frameValue) {
            RubyArray value2;
            try {
                value2 = this.executeArray(frameValue);
            }
            catch (UnexpectedResultException ex) {
                return ex.getResult();
            }
            return value2;
        }

        @Override
        public RubyArray executeArray(VirtualFrame frameValue) throws UnexpectedResultException {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            Object arrayValue = this.array.execute(frameValue);
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        @Override
        protected RubyArray executeChained0(VirtualFrame frameValue, Object arrayValue) {
            if (!this.containsFallback) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
            }
            return this.executeUninitialized0(frameValue, arrayValue);
        }

        protected RubyArray executeUninitialized0(VirtualFrame frameValue, Object arrayValue) {
            ArrayDropTailBaseNode newNode = this.specialize0(arrayValue);
            if (newNode == null) {
                if (CompilerDirectives.inInterpreter()) {
                    this.containsFallback = true;
                }
                CompilerDirectives.transferToInterpreter();
                ArrayDropTailBaseNode rootNode = (ArrayDropTailBaseNode)DSLShare.findRoot((Node)this);
                throw new UnsupportedSpecializationException((Node)rootNode, new Node[]{rootNode.array}, new Object[]{arrayValue});
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return ((ArrayDropTailBaseNode)DSLShare.rewriteUninitialized((Node)this, (Node)newNode)).executeChained0(frameValue, arrayValue);
        }

        static ArrayDropTailNode create0(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
            return new ArrayDropTailUninitializedNode(context, sourceSection, index2, array);
        }
    }

    @GeneratedBy(value=ArrayDropTailNode.class)
    private static abstract class ArrayDropTailBaseNode
    extends ArrayDropTailNode
    implements DSLNode {
        @Node.Child
        protected RubyNode array;
        @Node.Child
        protected ArrayDropTailBaseNode next0;

        ArrayDropTailBaseNode(RubyContext context, SourceSection sourceSection, int index2, RubyNode array) {
            super(context, sourceSection, index2);
            this.array = array;
        }

        ArrayDropTailBaseNode(ArrayDropTailBaseNode copy) {
            super(copy);
        }

        protected abstract RubyArray executeChained0(VirtualFrame var1, Object var2);

        protected final RubyArray rewrite0(VirtualFrame frameValue, Object arrayValue, String reason2) {
            String message2;
            ArrayDropTailBaseNode returnNode;
            CompilerAsserts.neverPartOfCompilation();
            ArrayDropTailBaseNode newNode = this.specialize0(arrayValue);
            if (newNode == null) {
                newNode = new ArrayDropTailUninitializedNode(this);
                ((ArrayDropTailUninitializedNode)newNode).containsFallback = true;
            }
            if ((returnNode = (ArrayDropTailBaseNode)DSLShare.rewrite((Node)this, (Node)newNode, (String)(message2 = ArrayDropTailBaseNode.createInfo0(reason2, arrayValue)))) == null) {
                returnNode = (ArrayDropTailBaseNode)DSLShare.rewriteToPolymorphic((Node)this, (DSLNode)new ArrayDropTailUninitializedNode(this), (Node)new ArrayDropTailPolymorphicNode(this), (DSLNode)((ArrayDropTailBaseNode)this.copy()), (DSLNode)newNode, (String)message2);
            }
            return returnNode.executeChained0(frameValue, arrayValue);
        }

        @CompilerDirectives.TruffleBoundary
        protected final ArrayDropTailBaseNode specialize0(Object arrayValue) {
            if (RubyTypesGen.RUBYTYPES.isRubyArray(arrayValue)) {
                RubyArray arrayValueCast = RubyTypesGen.RUBYTYPES.asRubyArray(arrayValue);
                if (ArrayGuards.isNull(arrayValueCast)) {
                    return (ArrayDropTailBaseNode)ArrayDropTailRubyArray0Node.create0(this);
                }
                if (ArrayGuards.isIntegerFixnum(arrayValueCast)) {
                    return (ArrayDropTailBaseNode)ArrayDropTailRubyArray1Node.create0(this);
                }
                if (ArrayGuards.isLongFixnum(arrayValueCast)) {
                    return (ArrayDropTailBaseNode)ArrayDropTailRubyArray2Node.create0(this);
                }
                if (ArrayGuards.isFloat(arrayValueCast)) {
                    return (ArrayDropTailBaseNode)ArrayDropTailRubyArray3Node.create0(this);
                }
                if (ArrayGuards.isObject(arrayValueCast)) {
                    return (ArrayDropTailBaseNode)ArrayDropTailRubyArray4Node.create0(this);
                }
            }
            return null;
        }

        public final void adoptChildren0(Node other, Node newNext) {
            this.array = other == null ? null : ((ArrayDropTailBaseNode)other).array;
            this.next0 = newNext == null ? null : (ArrayDropTailBaseNode)newNext;
        }

        public DSLMetadata getMetadata0() {
            return DSLMetadata.NONE;
        }

        public void updateTypes0(Class<?>[] types) {
        }

        public final Node getNext0() {
            return this.next0;
        }

        protected static String createInfo0(String message2, Object arrayValue) {
            if (TruffleOptions.DetailedRewriteReasons) {
                StringBuilder builder = new StringBuilder(message2);
                builder.append(" (");
                builder.append("arrayValue").append(" = ").append(arrayValue);
                if (arrayValue != null) {
                    builder.append(" (").append(arrayValue.getClass().getSimpleName()).append(")");
                }
                builder.append(")");
                return builder.toString();
            }
            return message2;
        }
    }
}

