/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.control;

import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.control.RescueNode;
import org.jruby.truffle.runtime.ModuleOperations;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyException;

public class RescueSplatNode
extends RescueNode {
    @Node.Child
    RubyNode handlingClassesArray;

    public RescueSplatNode(RubyContext context, SourceSection sourceSection, RubyNode handlingClassesArray, RubyNode body) {
        super(context, sourceSection, body);
        this.handlingClassesArray = handlingClassesArray;
    }

    @Override
    @ExplodeLoop
    public boolean canHandle(VirtualFrame frame, RubyException exception2) {
        RescueSplatNode.notDesignedForCompilation();
        RubyArray handlingClasses = (RubyArray)this.handlingClassesArray.execute(frame);
        RubyClass exceptionRubyClass = exception2.getLogicalClass();
        for (Object handlingClass : handlingClasses.slowToArray()) {
            if (!ModuleOperations.assignableTo(exceptionRubyClass, (RubyClass)handlingClass)) continue;
            return true;
        }
        return false;
    }
}

