/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes.cast;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.NodeChild;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.nodes.cast.BooleanCastNode;
import org.jruby.truffle.nodes.cast.BooleanCastNodeFactory;
import org.jruby.truffle.nodes.core.ArrayDupNode;
import org.jruby.truffle.nodes.core.ArrayDupNodeFactory;
import org.jruby.truffle.nodes.dispatch.CallDispatchHeadNode;
import org.jruby.truffle.nodes.dispatch.DispatchHeadNodeFactory;
import org.jruby.truffle.nodes.dispatch.DispatchNode;
import org.jruby.truffle.nodes.dispatch.MissingBehavior;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.control.RaiseException;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyNilClass;

@NodeChild(value="child")
public abstract class SplatCastNode
extends RubyNode {
    private final NilBehavior nilBehavior;
    private final boolean useToAry;
    @Node.Child
    private ArrayDupNode dup;
    @Node.Child
    private CallDispatchHeadNode respondToToA;
    @Node.Child
    private BooleanCastNode respondToCast;
    @Node.Child
    private CallDispatchHeadNode toA;

    public SplatCastNode(RubyContext context, SourceSection sourceSection, NilBehavior nilBehavior, boolean useToAry) {
        super(context, sourceSection);
        this.nilBehavior = nilBehavior;
        this.dup = ArrayDupNodeFactory.create(context, sourceSection, null);
        this.respondToToA = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.RETURN_MISSING);
        this.respondToCast = BooleanCastNodeFactory.create(context, sourceSection, null);
        this.toA = DispatchHeadNodeFactory.createMethodCall(context, true, MissingBehavior.RETURN_MISSING);
        this.useToAry = useToAry;
    }

    public SplatCastNode(SplatCastNode prev) {
        super(prev);
        this.dup = prev.dup;
        this.nilBehavior = prev.nilBehavior;
        this.respondToToA = prev.respondToToA;
        this.respondToCast = prev.respondToCast;
        this.toA = prev.toA;
        this.useToAry = prev.useToAry;
    }

    protected abstract RubyNode getChild();

    @Specialization
    public RubyArray splat(RubyNilClass nil) {
        switch (this.nilBehavior) {
            case EMPTY_ARRAY: {
                return new RubyArray(this.getContext().getCoreLibrary().getArrayClass());
            }
            case ARRAY_WITH_NIL: {
                return RubyArray.fromObject(this.getContext().getCoreLibrary().getArrayClass(), this.getContext().getCoreLibrary().getNilObject());
            }
        }
        CompilerAsserts.neverPartOfCompilation();
        throw new UnsupportedOperationException();
    }

    @Specialization
    public RubyArray splat(VirtualFrame frame, RubyArray array) {
        return this.dup.executeDup(frame, array);
    }

    @Specialization(guards={"!isRubyNilClass", "!isRubyArray"})
    public RubyArray splat(VirtualFrame frame, Object object) {
        SplatCastNode.notDesignedForCompilation();
        String method = this.useToAry ? "to_ary" : "to_a";
        Object respondToResult = this.respondToToA.call(frame, object, "respond_to?", null, this.getContext().makeString(method), true);
        if (respondToResult != DispatchNode.MISSING && this.respondToCast.executeBoolean(frame, respondToResult)) {
            Object array = this.toA.call(frame, object, method, null, new Object[0]);
            if (array instanceof RubyArray) {
                return (RubyArray)array;
            }
            if (array instanceof RubyNilClass || array == DispatchNode.MISSING) {
                return RubyArray.fromObject(this.getContext().getCoreLibrary().getArrayClass(), object);
            }
            throw new RaiseException(this.getContext().getCoreLibrary().typeErrorCantConvertTo(this.getContext().getCoreLibrary().getLogicalClass(object).getName(), "Array", method, this.getContext().getCoreLibrary().getLogicalClass(array).getName(), this));
        }
        return RubyArray.fromObject(this.getContext().getCoreLibrary().getArrayClass(), object);
    }

    public static enum NilBehavior {
        EMPTY_ARRAY,
        ARRAY_WITH_NIL,
        NIL;

    }
}

