/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.ExecutionContext;
import com.oracle.truffle.api.frame.FrameDescriptor;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.SourceSection;
import org.jruby.truffle.nodes.RubyNode;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.methods.SharedMethodInfo;

public class RubyRootNode
extends RootNode {
    private final RubyContext context;
    private final SharedMethodInfo sharedMethodInfo;
    @Node.Child
    private RubyNode body;
    private final RubyNode uninitializedBody;

    public RubyRootNode(RubyContext context, SourceSection sourceSection, FrameDescriptor frameDescriptor, SharedMethodInfo sharedMethodInfo, RubyNode body) {
        super(sourceSection, frameDescriptor);
        assert (body != null);
        this.context = context;
        this.body = body;
        this.sharedMethodInfo = sharedMethodInfo;
        this.uninitializedBody = (RubyNode)NodeUtil.cloneNode((Node)body);
    }

    public RubyRootNode cloneRubyRootNode() {
        return new RubyRootNode(this.context, this.getSourceSection(), this.getFrameDescriptor(), this.sharedMethodInfo, (RubyNode)NodeUtil.cloneNode((Node)this.uninitializedBody));
    }

    public boolean isCloningAllowed() {
        return true;
    }

    public Object execute(VirtualFrame frame) {
        this.context.getSafepointManager().poll();
        return this.body.execute(frame);
    }

    public String toString() {
        return this.sharedMethodInfo.toString();
    }

    public SharedMethodInfo getSharedMethodInfo() {
        return this.sharedMethodInfo;
    }

    public RubyNode getBody() {
        return this.body;
    }

    public ExecutionContext getExecutionContext() {
        return this.context;
    }
}

