/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.truffle.nodes;

import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.instrument.Probe;
import com.oracle.truffle.api.instrument.ProbeNode;
import com.oracle.truffle.api.instrument.TruffleEventReceiver;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.source.SourceSection;
import java.math.BigInteger;
import org.jruby.truffle.nodes.RubyTypes;
import org.jruby.truffle.nodes.RubyTypesGen;
import org.jruby.truffle.nodes.dispatch.DispatchAction;
import org.jruby.truffle.nodes.instrument.RubyWrapperNode;
import org.jruby.truffle.runtime.LexicalScope;
import org.jruby.truffle.runtime.RubyContext;
import org.jruby.truffle.runtime.UndefinedPlaceholder;
import org.jruby.truffle.runtime.core.RubyArray;
import org.jruby.truffle.runtime.core.RubyBasicObject;
import org.jruby.truffle.runtime.core.RubyBignum;
import org.jruby.truffle.runtime.core.RubyBinding;
import org.jruby.truffle.runtime.core.RubyClass;
import org.jruby.truffle.runtime.core.RubyEncoding;
import org.jruby.truffle.runtime.core.RubyEncodingConverter;
import org.jruby.truffle.runtime.core.RubyException;
import org.jruby.truffle.runtime.core.RubyFiber;
import org.jruby.truffle.runtime.core.RubyFile;
import org.jruby.truffle.runtime.core.RubyHash;
import org.jruby.truffle.runtime.core.RubyMatchData;
import org.jruby.truffle.runtime.core.RubyMethod;
import org.jruby.truffle.runtime.core.RubyModule;
import org.jruby.truffle.runtime.core.RubyNilClass;
import org.jruby.truffle.runtime.core.RubyProc;
import org.jruby.truffle.runtime.core.RubyRange;
import org.jruby.truffle.runtime.core.RubyRegexp;
import org.jruby.truffle.runtime.core.RubyString;
import org.jruby.truffle.runtime.core.RubySymbol;
import org.jruby.truffle.runtime.core.RubyThread;
import org.jruby.truffle.runtime.core.RubyTime;
import org.jruby.truffle.runtime.core.RubyUnboundMethod;

@TypeSystemReference(value=RubyTypes.class)
public abstract class RubyNode
extends Node
implements ProbeNode.Instrumentable {
    private final RubyContext context;

    public RubyNode(RubyContext context, SourceSection sourceSection) {
        super(sourceSection);
        assert (context != null);
        this.context = context;
    }

    public RubyNode(RubyNode prev) {
        this(prev.context, prev.getSourceSection());
    }

    public abstract Object execute(VirtualFrame var1);

    public Object isDefined(VirtualFrame frame) {
        return this.getContext().makeString("expression");
    }

    public String executeString(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectString(this.execute(frame));
    }

    public RubyArray executeArray(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyArray(this.execute(frame));
    }

    public RubyBignum executeBignum(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyBignum(this.execute(frame));
    }

    public boolean executeBoolean(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectBoolean(this.execute(frame));
    }

    public int executeIntegerFixnum(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectInteger(this.execute(frame));
    }

    public long executeLongFixnum(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectLong(this.execute(frame));
    }

    public RubyRange.IntegerFixnumRange executeIntegerFixnumRange(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectIntegerFixnumRange(this.execute(frame));
    }

    public RubyRange.LongFixnumRange executeLongFixnumRange(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectLongFixnumRange(this.execute(frame));
    }

    public double executeFloat(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectDouble(this.execute(frame));
    }

    public Object[] executeObjectArray(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectObjectArray(this.execute(frame));
    }

    public RubyRange.ObjectRange executeObjectRange(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectObjectRange(this.execute(frame));
    }

    public RubyBasicObject executeRubyBasicObject(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyBasicObject(this.execute(frame));
    }

    public RubyBinding executeRubyBinding(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyBinding(this.execute(frame));
    }

    public RubyClass executeRubyClass(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyClass(this.execute(frame));
    }

    public RubyException executeRubyException(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyException(this.execute(frame));
    }

    public RubyFiber executeRubyFiber(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyFiber(this.execute(frame));
    }

    public RubyFile executeRubyFile(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyFile(this.execute(frame));
    }

    public RubyHash executeRubyHash(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyHash(this.execute(frame));
    }

    public RubyMatchData executeRubyMatchData(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyMatchData(this.execute(frame));
    }

    public RubyModule executeRubyModule(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyModule(this.execute(frame));
    }

    public RubyNilClass executeRubyNilClass(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyNilClass(this.execute(frame));
    }

    public RubyProc executeRubyProc(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyProc(this.execute(frame));
    }

    public RubyRange executeRubyRange(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyRange(this.execute(frame));
    }

    public RubyRegexp executeRubyRegexp(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyRegexp(this.execute(frame));
    }

    public RubySymbol executeRubySymbol(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubySymbol(this.execute(frame));
    }

    public RubyThread executeRubyThread(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyThread(this.execute(frame));
    }

    public RubyTime executeRubyTime(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyTime(this.execute(frame));
    }

    public RubyString executeRubyString(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyString(this.execute(frame));
    }

    public RubyEncoding executeRubyEncoding(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyEncoding(this.execute(frame));
    }

    public UndefinedPlaceholder executeUndefinedPlaceholder(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectUndefinedPlaceholder(this.execute(frame));
    }

    public RubyEncodingConverter executeRubyEncodingConverter(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyEncodingConverter(this.execute(frame));
    }

    public RubyMethod executeRubyMethod(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyMethod(this.execute(frame));
    }

    public RubyUnboundMethod executeRubyUnboundMethod(VirtualFrame frame) throws UnexpectedResultException {
        return RubyTypesGen.RUBYTYPES.expectRubyUnboundMethod(this.execute(frame));
    }

    public void executeVoid(VirtualFrame frame) {
        this.execute(frame);
    }

    public RubyNode getNonProxyNode() {
        return this;
    }

    public RubyContext getContext() {
        return this.context;
    }

    public static void notDesignedForCompilation() {
        CompilerAsserts.neverPartOfCompilation();
    }

    public boolean isTrue(boolean value2) {
        return value2;
    }

    public RubyBignum bignum(int value2) {
        return this.bignum((long)value2);
    }

    public RubyBignum bignum(long value2) {
        return this.bignum(BigInteger.valueOf(value2));
    }

    public RubyBignum bignum(BigInteger value2) {
        return new RubyBignum(this.getContext().getCoreLibrary().getBignumClass(), value2);
    }

    public RubyNode getNonWrapperNode() {
        return this;
    }

    public Probe probe() {
        Node parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Cannot call probe() on a node without a parent.");
        }
        if (parent instanceof RubyWrapperNode) {
            return ((RubyWrapperNode)parent).getProbe();
        }
        RubyWrapperNode wrapper = new RubyWrapperNode(this);
        Probe probe = ProbeNode.insertProbe((ProbeNode.WrapperNode)wrapper);
        this.replace(wrapper);
        return probe;
    }

    public void probeLite(TruffleEventReceiver eventReceiver) {
        Node parent = this.getParent();
        if (parent == null) {
            throw new IllegalStateException("Cannot call probeLite() on a node without a parent");
        }
        if (parent instanceof RubyWrapperNode) {
            throw new IllegalStateException("Cannot call probeLite() on a node that already has a wrapper.");
        }
        RubyWrapperNode wrapper = new RubyWrapperNode(this);
        ProbeNode.insertProbeLite((ProbeNode.WrapperNode)wrapper, (TruffleEventReceiver)eventReceiver);
        this.replace(wrapper);
    }

    public boolean isRational(RubyBasicObject o) {
        return o.getLogicalClass() == this.getContext().getCoreLibrary().getRationalClass();
    }

    public boolean isDispatchAction(Object value2) {
        return value2 instanceof DispatchAction;
    }

    public boolean isLexicalScope(Object value2) {
        return value2 instanceof LexicalScope;
    }

    public boolean isUndefinedPlaceholder(Object value2) {
        return value2 instanceof UndefinedPlaceholder;
    }

    public boolean isBoolean(Object value2) {
        return value2 instanceof Boolean;
    }

    public boolean isInteger(Object value2) {
        return value2 instanceof Integer;
    }

    public boolean isLong(Object value2) {
        return value2 instanceof Long;
    }

    public boolean isDouble(Object value2) {
        return value2 instanceof Double;
    }

    public boolean isString(Object value2) {
        return value2 instanceof String;
    }

    public boolean isRubyBignum(Object value2) {
        return value2 instanceof RubyBignum;
    }

    public boolean isIntegerFixnumRange(Object value2) {
        return value2 instanceof RubyRange.IntegerFixnumRange;
    }

    public boolean isLongFixnumRange(Object value2) {
        return value2 instanceof RubyRange.LongFixnumRange;
    }

    public boolean isObjectRange(Object value2) {
        return value2 instanceof RubyRange.ObjectRange;
    }

    public boolean isRubyArray(Object value2) {
        return value2 instanceof RubyArray;
    }

    public boolean isRubyBinding(Object value2) {
        return value2 instanceof RubyBinding;
    }

    public boolean isRubyClass(Object value2) {
        return value2 instanceof RubyClass;
    }

    public boolean isRubyException(Object value2) {
        return value2 instanceof RubyException;
    }

    public boolean isRubyFiber(Object value2) {
        return value2 instanceof RubyFiber;
    }

    public boolean isRubyFile(Object value2) {
        return value2 instanceof RubyFile;
    }

    public boolean isRubyHash(Object value2) {
        return value2 instanceof RubyHash;
    }

    public boolean isRubyMatchData(Object value2) {
        return value2 instanceof RubyMatchData;
    }

    public boolean isRubyModule(Object value2) {
        return value2 instanceof RubyModule;
    }

    public boolean isRubyNilClass(Object value2) {
        return value2 instanceof RubyNilClass;
    }

    public boolean isRubyProc(Object value2) {
        return value2 instanceof RubyProc;
    }

    public boolean isRubyRange(Object value2) {
        return value2 instanceof RubyRange;
    }

    public boolean isRubyRegexp(Object value2) {
        return value2 instanceof RubyRegexp;
    }

    public boolean isRubyString(Object value2) {
        return value2 instanceof RubyString;
    }

    public boolean isRubyEncoding(Object value2) {
        return value2 instanceof RubyEncoding;
    }

    public boolean isRubySymbol(Object value2) {
        return value2 instanceof RubySymbol;
    }

    public boolean isRubyThread(Object value2) {
        return value2 instanceof RubyThread;
    }

    public boolean isRubyTime(Object value2) {
        return value2 instanceof RubyTime;
    }

    public boolean isRubyEncodingConverter(Object value2) {
        return value2 instanceof RubyEncodingConverter;
    }

    public boolean isRubyBasicObject(Object value2) {
        return value2 instanceof RubyBasicObject;
    }

    public boolean isThreadLocal(Object value2) {
        return value2 instanceof ThreadLocal;
    }

    public boolean isObjectArray(Object value2) {
        return value2 instanceof Object[];
    }

    public boolean isRubyNilObject(Object value2) {
        return value2 == this.getContext().getCoreLibrary().getNilObject();
    }
}

