/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import org.jruby.Ruby;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.Node;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.runtime.Arity;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.TypeConverter;

public class Signature {
    public static final Signature NO_ARGUMENTS = new Signature(0, 0, 0, Rest.NONE, false);
    public static final Signature ONE_ARGUMENT = new Signature(1, 0, 0, Rest.NONE, false);
    public static final Signature TWO_ARGUMENTS = new Signature(2, 0, 0, Rest.NONE, false);
    public static final Signature THREE_ARGUMENTS = new Signature(3, 0, 0, Rest.NONE, false);
    public static final Signature OPTIONAL = new Signature(0, 0, 0, Rest.NORM, false);
    public static final Signature ONE_REQUIRED = new Signature(1, 0, 0, Rest.NORM, false);
    public static final Signature TWO_REQUIRED = new Signature(2, 0, 0, Rest.NORM, false);
    public static final Signature THREE_REQUIRED = new Signature(3, 0, 0, Rest.NORM, false);
    private final int pre;
    private final int opt;
    private final Rest rest;
    private final int post;
    private final boolean kwargs;
    private final Arity arity;

    public Signature(int pre, int opt, int post, Rest rest2, boolean kwargs) {
        this.pre = pre;
        this.opt = opt;
        this.post = post;
        this.rest = rest2;
        this.kwargs = kwargs;
        this.arity = rest2 != Rest.NONE || opt != 0 ? Arity.createArity(-(pre + post + 1)) : Arity.fixed(pre + post);
    }

    public int pre() {
        return this.pre;
    }

    public int opt() {
        return this.opt;
    }

    public Rest rest() {
        return this.rest;
    }

    public int post() {
        return this.post;
    }

    public boolean kwargs() {
        return this.kwargs;
    }

    public int required() {
        return this.pre + this.post;
    }

    public Arity arity() {
        return this.arity;
    }

    public static Signature from(int pre, int opt, int post, Rest rest2, boolean kwargs) {
        if (opt == 0 && post == 0 && !kwargs) {
            switch (pre) {
                case 0: {
                    switch (rest2) {
                        case NONE: {
                            return NO_ARGUMENTS;
                        }
                        case NORM: {
                            return OPTIONAL;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (rest2) {
                        case NONE: {
                            return ONE_ARGUMENT;
                        }
                        case NORM: {
                            return ONE_REQUIRED;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (rest2) {
                        case NONE: {
                            return TWO_ARGUMENTS;
                        }
                        case NORM: {
                            return TWO_REQUIRED;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (rest2) {
                        case NONE: {
                            return THREE_ARGUMENTS;
                        }
                        case NORM: {
                            return THREE_REQUIRED;
                        }
                    }
                }
            }
        }
        return new Signature(pre, opt, post, rest2, kwargs);
    }

    public static Signature from(IterNode iter) {
        if (iter instanceof ForNode) {
            return Signature.from((ForNode)iter);
        }
        if (iter instanceof PreExeNode) {
            return Signature.from((PreExeNode)iter);
        }
        if (iter instanceof PostExeNode) {
            return Signature.from((PostExeNode)iter);
        }
        Node var = iter.getVarNode();
        ArgsNode args2 = (ArgsNode)var;
        Rest rest2 = Rest.NONE;
        if (args2.getRestArg() >= 0) {
            ArgumentNode restArg = args2.getRestArgNode();
            rest2 = Signature.restFromArg(restArg);
        }
        return Signature.from(args2.getPreCount(), args2.getOptionalArgsCount(), args2.getPostCount(), rest2, args2.hasKwargs());
    }

    private static Rest restFromArg(Node restArg) {
        UnnamedRestArgNode anonRest;
        Rest rest2 = restArg instanceof UnnamedRestArgNode ? ((anonRest = (UnnamedRestArgNode)restArg).isStar() ? Rest.STAR : Rest.ANON) : (restArg instanceof StarNode ? Rest.STAR : Rest.NORM);
        return rest2;
    }

    public static Signature from(ForNode iter) {
        Node var = iter.getVarNode();
        if (var instanceof MultipleAsgn19Node) {
            MultipleAsgn19Node masgn = (MultipleAsgn19Node)var;
            Rest rest2 = Rest.NONE;
            if (masgn.getRest() != null) {
                Node restArg = masgn.getRest();
                rest2 = Signature.restFromArg(restArg);
            }
            return Signature.from(masgn.getPreCount(), 0, masgn.getPostCount(), rest2, false);
        }
        return ONE_ARGUMENT;
    }

    public static Signature from(PreExeNode iter) {
        return NO_ARGUMENTS;
    }

    public static Signature from(PostExeNode iter) {
        return NO_ARGUMENTS;
    }

    public long encode() {
        return (long)this.pre << 48 | (long)this.opt << 32 | (long)this.post << 16 | (long)(this.rest.ordinal() << 8) | (long)(this.kwargs ? 1 : 0);
    }

    public static Signature decode(long l) {
        return Signature.from((int)(l >> 48) & 0xFFFF, (int)(l >> 32) & 0xFFFF, (int)(l >> 16) & 0xFFFF, Rest.values()[(int)(l >> 8 & 0xFFL)], (l & 0xFFL) == 1L);
    }

    public String toString() {
        return "signature(pre=" + this.pre + ",opt=" + this.opt + ",post=" + this.post + ",rest=" + (Object)((Object)this.rest) + ",kwargs=" + this.kwargs + ")";
    }

    public void checkArity(Ruby runtime, IRubyObject[] args2) {
        if (args2.length < this.required()) {
            throw runtime.newArgumentError("wrong number of arguments (" + args2.length + " for " + this.required() + ")");
        }
        if ((this.rest == Rest.NONE || this.rest == Rest.ANON) && args2.length > this.required() + this.opt()) {
            if (this.kwargs && !TypeConverter.checkHashType(runtime, args2[args2.length - 1]).isNil()) {
                if (args2.length - 1 > this.required() + this.opt()) {
                    throw runtime.newArgumentError("wrong number of arguments (" + args2.length + " for " + (this.required() + this.opt) + ")");
                }
            } else {
                throw runtime.newArgumentError("wrong number of arguments (" + args2.length + " for " + (this.required() + this.opt) + ")");
            }
        }
    }

    public static enum Rest {
        NONE,
        NORM,
        ANON,
        STAR;

    }
}

