/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.representations;

import java.util.BitSet;
import java.util.Iterator;
import org.jruby.ir.instructions.BranchInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;

public class CFGLinearizer {
    public static BasicBlock[] linearize(CFG cfg) {
        BasicBlock[] list2 = new BasicBlock[cfg.size()];
        BitSet processed = new BitSet(cfg.size());
        int listSize = CFGLinearizer.linearizeInner(cfg, list2, 0, processed, cfg.getEntryBB());
        CFGLinearizer.verifyAllBasicBlocksProcessed(cfg, processed);
        CFGLinearizer.fixupList(cfg, list2, listSize);
        return list2;
    }

    private static int linearizeInner(CFG cfg, BasicBlock[] list2, int listSize, BitSet processed, BasicBlock current2) {
        if (processed.get(current2.getID())) {
            return listSize;
        }
        BasicBlock source2 = cfg.getIncomingSourceOfType(current2, (Object)CFG.EdgeType.FALL_THROUGH);
        if (source2 != null && !processed.get(source2.getID())) {
            return listSize;
        }
        list2[listSize] = current2;
        ++listSize;
        processed.set(current2.getID());
        BasicBlock fallThrough = cfg.getOutgoingDestinationOfType(current2, (Object)CFG.EdgeType.FALL_THROUGH);
        if (fallThrough != null) {
            listSize = CFGLinearizer.linearizeInner(cfg, list2, listSize, processed, fallThrough);
        }
        for (BasicBlock destination : cfg.getOutgoingDestinationsOfType(current2, (Object)CFG.EdgeType.REGULAR)) {
            listSize = CFGLinearizer.linearizeInner(cfg, list2, listSize, processed, destination);
        }
        for (BasicBlock destination : cfg.getOutgoingDestinationsOfType(current2, (Object)CFG.EdgeType.EXCEPTION)) {
            listSize = CFGLinearizer.linearizeInner(cfg, list2, listSize, processed, destination);
        }
        for (BasicBlock destination : cfg.getOutgoingDestinationsOfType(current2, (Object)CFG.EdgeType.EXIT)) {
            listSize = CFGLinearizer.linearizeInner(cfg, list2, listSize, processed, destination);
        }
        return listSize;
    }

    private static void fixupList(CFG cfg, BasicBlock[] list2, int listSize) {
        for (int i2 = 0; i2 < listSize - 1; ++i2) {
            BasicBlock current2 = list2[i2];
            if (current2.isExitBB()) {
                current2.addInstr(new ReturnInstr(cfg.getScope().getManager().getNil()));
                continue;
            }
            Instr lastInstr = current2.getLastInstr();
            if (lastInstr instanceof JumpInstr) {
                CFGLinearizer.tryAndRemoveUnneededJump(list2[i2 + 1], cfg, lastInstr, current2);
                continue;
            }
            CFGLinearizer.addJumpIfNextNotDestination(cfg, list2[i2 + 1], lastInstr, current2);
        }
        BasicBlock current3 = list2[listSize - 1];
        if (!current3.isExitBB()) {
            Instr lastInstr = current3.getLastInstr();
            assert (!(lastInstr instanceof BranchInstr));
            if (lastInstr == null || !lastInstr.getOperation().transfersControl()) {
                Iterator<BasicBlock> iter = cfg.getOutgoingDestinationsNotOfType(current3, (Object)CFG.EdgeType.EXCEPTION).iterator();
                BasicBlock target = iter.next();
                assert (target != null && !iter.hasNext());
                current3.addInstr(new JumpInstr(target.getLabel()));
            }
        }
    }

    private static void tryAndRemoveUnneededJump(BasicBlock next2, CFG cfg, Instr lastInstr, BasicBlock current2) {
        if (next2 == cfg.getBBForLabel(((JumpInstr)lastInstr).getJumpTarget())) {
            current2.removeInstr(lastInstr);
        }
    }

    private static void addJumpIfNextNotDestination(CFG cfg, BasicBlock next2, Instr lastInstr, BasicBlock current2) {
        BasicBlock target;
        Iterator<BasicBlock> outs = cfg.getOutgoingDestinations(current2).iterator();
        BasicBlock basicBlock = target = outs.hasNext() ? outs.next() : null;
        if (!(target == null || outs.hasNext() || target == next2 || lastInstr != null && lastInstr.getOperation().transfersControl())) {
            current2.addInstr(new JumpInstr(target.getLabel()));
        }
    }

    private static void verifyAllBasicBlocksProcessed(CFG cfg, BitSet processed) throws RuntimeException {
        for (BasicBlock b2 : cfg.getBasicBlocks()) {
            if (processed.get(b2.getID())) continue;
            throw new RuntimeException("Bad CFG linearization: BB " + b2.getID() + " has been missed!");
        }
    }
}

