/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.operands;

import java.util.List;
import java.util.Map;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.OperandType;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.RegexpOptions;

public class Regexp
extends Operand {
    public final RegexpOptions options;
    private final Operand regexp;
    private RubyRegexp rubyRegexp;

    public Regexp(Operand regexp2, RegexpOptions options2) {
        super(OperandType.REGEXP);
        this.regexp = regexp2;
        this.options = options2;
    }

    public Operand getRegexp() {
        return this.regexp;
    }

    public String toString() {
        return "RE:|" + this.regexp + "|" + this.options;
    }

    @Override
    public boolean hasKnownValue() {
        return this.regexp.hasKnownValue();
    }

    @Override
    public Operand getSimplifiedOperand(Map<Operand, Operand> valueMap, boolean force) {
        Operand newRegexp = this.regexp.getSimplifiedOperand(valueMap, force);
        return newRegexp == this.regexp ? this : new Regexp(newRegexp, this.options);
    }

    @Override
    public void addUsedVariables(List<Variable> l) {
        this.regexp.addUsedVariables(l);
    }

    @Override
    public Operand cloneForInlining(CloneInfo ii) {
        return this.hasKnownValue() ? this : new Regexp(this.regexp.cloneForInlining(ii), this.options);
    }

    @Override
    public Object retrieve(ThreadContext context, IRubyObject self2, StaticScope currScope, DynamicScope currDynScope, Object[] temp) {
        if (!this.regexp.hasKnownValue() && !this.options.isOnce() || this.rubyRegexp == null || context.runtime.getKCode() != this.rubyRegexp.getKCode()) {
            RubyString pattern = (RubyString)this.regexp.retrieve(context, self2, currScope, currDynScope, temp);
            RubyRegexp re = RubyRegexp.newRegexp(context.runtime, pattern.getByteList(), this.options);
            re.setLiteral();
            this.rubyRegexp = re;
        }
        return this.rubyRegexp;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.Regexp(this);
    }
}

