/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class StoreLocalVarInstr
extends Instr
implements FixedArityInstr {
    private final IRScope scope;

    public StoreLocalVarInstr(Operand value2, IRScope scope, LocalVariable lvar) {
        super(Operation.BINDING_STORE, new Operand[]{value2, lvar});
        this.scope = scope;
    }

    public Operand getValue() {
        return this.operands[0];
    }

    public LocalVariable getLocalVar() {
        return (LocalVariable)this.operands[1];
    }

    public IRScope getScope() {
        return this.scope;
    }

    @Override
    public String toString() {
        return "store_lvar(" + this.getValue() + ", " + this.scope.getName() + ", " + this.getLocalVar() + ")";
    }

    public void decrementLVarScopeDepth() {
        this.operands[1] = this.getLocalVar().cloneForDepth(this.getLocalVar().getScopeDepth() - 1);
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.operands[0] = this.getValue().getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new StoreLocalVarInstr(this.getValue().cloneForInlining(ii), this.scope, (LocalVariable)this.getLocalVar().cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        Object varValue = this.getValue().retrieve(context, self2, currScope, currDynScope, temp);
        currDynScope.setValue((IRubyObject)varValue, this.getLocalVar().getLocation(), this.getLocalVar().getScopeDepth());
        return null;
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.StoreLocalVarInstr(this);
    }
}

