/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;

public class ReturnInstr
extends ReturnBase
implements FixedArityInstr {
    public ReturnInstr(Operand returnValue) {
        super(Operation.RETURN, returnValue);
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new ReturnInstr(this.getReturnValue().cloneForInlining(info));
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.isClosure()) {
            return new CopyInstr(ii.getYieldResult(), this.getReturnValue().cloneForInlining(ii));
        }
        Variable v = ii.getCallResultVariable();
        return v == null ? null : new CopyInstr(v, this.getReturnValue().cloneForInlining(ii));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReturnInstr(this);
    }
}

