/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.ir.transformations.inlining.InlineCloneInfo;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.runtime.builtin.IRubyObject;

public class ReceivePostReqdArgInstr
extends ReceiveArgBase
implements FixedArityInstr {
    public final int preReqdArgsCount;
    public final int postReqdArgsCount;

    public ReceivePostReqdArgInstr(Variable result2, int argIndex, int preReqdArgsCount, int postReqdArgsCount) {
        super(Operation.RECV_POST_REQD_ARG, result2, argIndex);
        this.preReqdArgsCount = preReqdArgsCount;
        this.postReqdArgsCount = postReqdArgsCount;
    }

    @Override
    public String toString() {
        return (this.isDead() ? "[DEAD]" : "") + this.getResult() + " = " + (Object)((Object)this.getOperation()) + "(" + this.argIndex + ", " + this.preReqdArgsCount + ", " + this.postReqdArgsCount + ")";
    }

    @Override
    public Instr clone(CloneInfo info) {
        if (info instanceof SimpleCloneInfo) {
            return new ReceivePostReqdArgInstr(info.getRenamedVariable(this.result), this.argIndex, this.preReqdArgsCount, this.postReqdArgsCount);
        }
        InlineCloneInfo ii = (InlineCloneInfo)info;
        if (ii.canMapArgsStatically()) {
            int n = ii.getArgsCount();
            int remaining = n - this.preReqdArgsCount;
            Operand argVal = remaining <= this.argIndex ? ii.getHostScope().getManager().getNil() : (remaining > this.postReqdArgsCount ? ii.getArg(n - this.postReqdArgsCount + this.argIndex) : ii.getArg(this.preReqdArgsCount + this.argIndex));
            return new CopyInstr(ii.getRenamedVariable(this.result), argVal);
        }
        return new ReqdArgMultipleAsgnInstr(ii.getRenamedVariable(this.result), ii.getArgs(), this.preReqdArgsCount, this.postReqdArgsCount, this.argIndex);
    }

    public IRubyObject receivePostReqdArg(IRubyObject[] args2, boolean acceptsKeywordArgument) {
        return IRRuntimeHelpers.receivePostReqdArg(args2, this.preReqdArgsCount, this.postReqdArgsCount, this.argIndex, acceptsKeywordArgument);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ReceivePostReqdArgInstr(this);
    }
}

