/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.InterpretedIRMethod;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.FixedArityInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultBaseInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.CloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class ProcessModuleBodyInstr
extends ResultBaseInstr
implements FixedArityInstr {
    public ProcessModuleBodyInstr(Variable result2, Operand moduleBody, Operand block) {
        super(Operation.PROCESS_MODULE_BODY, result2, new Operand[]{moduleBody, block});
        assert (result2 != null) : "ProcessModuleBodyInstr result is null";
    }

    public Operand getModuleBody() {
        return this.operands[0];
    }

    public Operand getBlock() {
        return this.operands[1];
    }

    @Override
    public Instr clone(CloneInfo ii) {
        return new ProcessModuleBodyInstr(ii.getRenamedVariable(this.result), this.getModuleBody().cloneForInlining(ii), this.getBlock().cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, StaticScope currScope, DynamicScope currDynScope, IRubyObject self2, Object[] temp) {
        InterpretedIRMethod bodyMethod = (InterpretedIRMethod)this.getModuleBody().retrieve(context, self2, currScope, currDynScope, temp);
        Block b2 = (Block)this.getBlock().retrieve(context, self2, currScope, currDynScope, temp);
        RubyModule implClass = bodyMethod.getImplementationClass();
        return bodyMethod.call(context, (IRubyObject)implClass, implClass, null, new IRubyObject[0], b2);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.ProcessModuleBodyInstr(this);
    }
}

