/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.EvalType;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AssignableNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockArgNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ComplexNode;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EncodingNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.KeywordArgNode;
import org.jruby.ast.KeywordRestArgNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2CaptureNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgn19Node;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OptArgNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RationalNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.ast.types.INameNode;
import org.jruby.compiler.NotCompilableException;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.ir.IRBindingEvalScript;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRFlags;
import org.jruby.ir.IRFor;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.ArgScopeDepthInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BacktickInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.BuildCompoundArrayInstr;
import org.jruby.ir.instructions.BuildCompoundStringInstr;
import org.jruby.ir.instructions.BuildDynRegExpInstr;
import org.jruby.ir.instructions.BuildLambdaInstr;
import org.jruby.ir.instructions.BuildRangeInstr;
import org.jruby.ir.instructions.BuildSplatInstr;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.ConstMissingInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetEncodingInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.LoadFrameClosureInstr;
import org.jruby.ir.instructions.LoadImplicitClosureInstr;
import org.jruby.ir.instructions.Match2Instr;
import org.jruby.ir.instructions.Match3Instr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.RaiseRequiredKeywordArgumentError;
import org.jruby.ir.instructions.ReceiveJRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveKeywordArgInstr;
import org.jruby.ir.instructions.ReceiveKeywordRestArgInstr;
import org.jruby.ir.instructions.ReceiveOptArgInstr;
import org.jruby.ir.instructions.ReceivePostReqdArgInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.ReceiveRubyExceptionInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReifyClosureInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SetCapturedVarInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.TraceInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.listeners.IRScopeListener;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.AsString;
import org.jruby.ir.operands.Backref;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.Complex;
import org.jruby.ir.operands.ConstantStringLiteral;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DepthCloneable;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.FrozenString;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.ImmutableLiteral;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.NullBlock;
import org.jruby.ir.operands.ObjectClass;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Rational;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.TemporaryLocalVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.transformations.inlining.SimpleCloneInfo;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.CallType;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.RubyEvent;
import org.jruby.runtime.Signature;
import org.jruby.util.ByteList;
import org.jruby.util.KeyValuePair;

public class IRBuilder {
    static final Operand[] NO_ARGS = new Operand[0];
    static final UnexecutableNil U_NIL = UnexecutableNil.U_NIL;
    private Stack<RescueBlockInfo> activeRescueBlockStack = new Stack();
    private Stack<EnsureBlockInfo> activeEnsureBlockStack = new Stack();
    private Stack<EnsureBlockInfo> ensureBodyBuildStack = new Stack();
    private Stack<Label> activeRescuers = new Stack();
    private Stack<IRLoop> loopStack = new Stack();
    private int _lastProcessedLineNum = -1;
    protected IRManager manager;

    public static IRBuilder createIRBuilder(Ruby runtime, IRManager manager) {
        return new IRBuilder(manager);
    }

    public static Node buildAST(boolean isCommandLineScript, String arg2) {
        Ruby ruby2 = Ruby.getGlobalRuntime();
        if (isCommandLineScript) {
            return ruby2.parse(ByteList.create((CharSequence)arg2), "-e", null, 0, false);
        }
        FileInputStream fis = null;
        try {
            File file2 = new File(arg2);
            fis = new FileInputStream(file2);
            long size2 = file2.length();
            byte[] bytes2 = new byte[(int)size2];
            fis.read(bytes2);
            System.out.println("-- processing " + arg2 + " --");
            Node node = ruby2.parse(new ByteList(bytes2), arg2, null, 0, false);
            return node;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ignored) {}
        }
    }

    public IRLoop getCurrentLoop() {
        return this.loopStack.isEmpty() ? null : this.loopStack.peek();
    }

    public IRBuilder(IRManager manager) {
        this.manager = manager;
        this.activeRescuers.push(Label.UNRESCUED_REGION_LABEL);
    }

    public void addInstr(IRScope s2, Instr i2) {
        if (this.ensureBodyBuildStack.empty()) {
            s2.addInstr(i2);
        } else {
            this.ensureBodyBuildStack.peek().addInstr(i2);
        }
    }

    public void addInstrAtBeginning(IRScope s2, Instr i2) {
        if (this.ensureBodyBuildStack.empty()) {
            s2.addInstrAtBeginning(i2);
        } else {
            this.ensureBodyBuildStack.peek().addInstrAtBeginning(i2);
        }
    }

    private void emitEnsureBlocks(IRScope s2, IRLoop loop2) {
        int n = this.activeEnsureBlockStack.size();
        EnsureBlockInfo[] ebArray = this.activeEnsureBlockStack.toArray(new EnsureBlockInfo[n]);
        for (int i2 = n - 1; i2 >= 0; --i2) {
            EnsureBlockInfo ebi = ebArray[i2];
            if (loop2 != null && ebi.innermostLoop != loop2) break;
            if (ebi.savedGlobalException != null) {
                this.addInstr(s2, new PutGlobalVarInstr("$!", ebi.savedGlobalException));
            }
            ebi.cloneIntoHostScope(this, s2);
        }
    }

    private Operand buildOperand(Node node, IRScope s2) throws NotCompilableException {
        switch (node.getNodeType()) {
            case ALIASNODE: {
                return this.buildAlias((AliasNode)node, s2);
            }
            case ANDNODE: {
                return this.buildAnd((AndNode)node, s2);
            }
            case ARGSCATNODE: {
                return this.buildArgsCat((ArgsCatNode)node, s2);
            }
            case ARGSPUSHNODE: {
                return this.buildArgsPush((ArgsPushNode)node, s2);
            }
            case ARRAYNODE: {
                return this.buildArray(node, s2);
            }
            case ATTRASSIGNNODE: {
                return this.buildAttrAssign((AttrAssignNode)node, s2);
            }
            case BACKREFNODE: {
                return this.buildBackref((BackRefNode)node, s2);
            }
            case BEGINNODE: {
                return this.buildBegin((BeginNode)node, s2);
            }
            case BIGNUMNODE: {
                return this.buildBignum((BignumNode)node);
            }
            case BLOCKNODE: {
                return this.buildBlock((BlockNode)node, s2);
            }
            case BREAKNODE: {
                return this.buildBreak((BreakNode)node, s2);
            }
            case CALLNODE: {
                return this.buildCall((CallNode)node, s2);
            }
            case CASENODE: {
                return this.buildCase((CaseNode)node, s2);
            }
            case CLASSNODE: {
                return this.buildClass((ClassNode)node, s2);
            }
            case CLASSVARNODE: {
                return this.buildClassVar((ClassVarNode)node, s2);
            }
            case CLASSVARASGNNODE: {
                return this.buildClassVarAsgn((ClassVarAsgnNode)node, s2);
            }
            case CLASSVARDECLNODE: {
                return this.buildClassVarDecl((ClassVarDeclNode)node, s2);
            }
            case COLON2NODE: {
                return this.buildColon2((Colon2Node)node, s2);
            }
            case COLON3NODE: {
                return this.buildColon3((Colon3Node)node, s2);
            }
            case COMPLEXNODE: {
                return this.buildComplex((ComplexNode)node, s2);
            }
            case CONSTDECLNODE: {
                return this.buildConstDecl((ConstDeclNode)node, s2);
            }
            case CONSTNODE: {
                return this.searchConst(s2, ((ConstNode)node).getName());
            }
            case DASGNNODE: {
                return this.buildDAsgn((DAsgnNode)node, s2);
            }
            case DEFINEDNODE: {
                return this.buildGetDefinition(((DefinedNode)node).getExpressionNode(), s2);
            }
            case DEFNNODE: {
                return this.buildDefn((MethodDefNode)node, s2);
            }
            case DEFSNODE: {
                return this.buildDefs((DefsNode)node, s2);
            }
            case DOTNODE: {
                return this.buildDot((DotNode)node, s2);
            }
            case DREGEXPNODE: {
                return this.buildDRegexp((DRegexpNode)node, s2);
            }
            case DSTRNODE: {
                return this.buildDStr((DStrNode)node, s2);
            }
            case DSYMBOLNODE: {
                return this.buildDSymbol((DSymbolNode)node, s2);
            }
            case DVARNODE: {
                return this.buildDVar((DVarNode)node, s2);
            }
            case DXSTRNODE: {
                return this.buildDXStr((DXStrNode)node, s2);
            }
            case ENCODINGNODE: {
                return this.buildEncoding((EncodingNode)node, s2);
            }
            case ENSURENODE: {
                return this.buildEnsureNode((EnsureNode)node, s2);
            }
            case EVSTRNODE: {
                return this.buildEvStr((EvStrNode)node, s2);
            }
            case FALSENODE: {
                return this.buildFalse();
            }
            case FCALLNODE: {
                return this.buildFCall((FCallNode)node, s2);
            }
            case FIXNUMNODE: {
                return this.buildFixnum((FixnumNode)node);
            }
            case FLIPNODE: {
                return this.buildFlip((FlipNode)node, s2);
            }
            case FLOATNODE: {
                return this.buildFloat((FloatNode)node);
            }
            case FORNODE: {
                return this.buildFor((ForNode)node, s2);
            }
            case GLOBALASGNNODE: {
                return this.buildGlobalAsgn((GlobalAsgnNode)node, s2);
            }
            case GLOBALVARNODE: {
                return this.buildGlobalVar((GlobalVarNode)node, s2);
            }
            case HASHNODE: {
                return this.buildHash((HashNode)node, s2);
            }
            case IFNODE: {
                return this.buildIf((IfNode)node, s2);
            }
            case INSTASGNNODE: {
                return this.buildInstAsgn((InstAsgnNode)node, s2);
            }
            case INSTVARNODE: {
                return this.buildInstVar((InstVarNode)node, s2);
            }
            case ITERNODE: {
                return this.buildIter((IterNode)node, s2);
            }
            case LAMBDANODE: {
                return this.buildLambda((LambdaNode)node, s2);
            }
            case LITERALNODE: {
                return this.buildLiteral((LiteralNode)node, s2);
            }
            case LOCALASGNNODE: {
                return this.buildLocalAsgn((LocalAsgnNode)node, s2);
            }
            case LOCALVARNODE: {
                return this.buildLocalVar((LocalVarNode)node, s2);
            }
            case MATCH2NODE: {
                return this.buildMatch2((Match2Node)node, s2);
            }
            case MATCH3NODE: {
                return this.buildMatch3((Match3Node)node, s2);
            }
            case MATCHNODE: {
                return this.buildMatch((MatchNode)node, s2);
            }
            case MODULENODE: {
                return this.buildModule((ModuleNode)node, s2);
            }
            case MULTIPLEASGNNODE: {
                return this.buildMultipleAsgn((MultipleAsgnNode)node, s2);
            }
            case MULTIPLEASGN19NODE: {
                return this.buildMultipleAsgn19((MultipleAsgn19Node)node, s2);
            }
            case NEWLINENODE: {
                return this.buildNewline((NewlineNode)node, s2);
            }
            case NEXTNODE: {
                return this.buildNext((NextNode)node, s2);
            }
            case NTHREFNODE: {
                return this.buildNthRef((NthRefNode)node, s2);
            }
            case NILNODE: {
                return this.buildNil();
            }
            case OPASGNANDNODE: {
                return this.buildOpAsgnAnd((OpAsgnAndNode)node, s2);
            }
            case OPASGNNODE: {
                return this.buildOpAsgn((OpAsgnNode)node, s2);
            }
            case OPASGNORNODE: {
                return this.buildOpAsgnOr((OpAsgnOrNode)node, s2);
            }
            case OPELEMENTASGNNODE: {
                return this.buildOpElementAsgn((OpElementAsgnNode)node, s2);
            }
            case ORNODE: {
                return this.buildOr((OrNode)node, s2);
            }
            case PREEXENODE: {
                return this.buildPreExe((PreExeNode)node, s2);
            }
            case POSTEXENODE: {
                return this.buildPostExe((PostExeNode)node, s2);
            }
            case RATIONALNODE: {
                return this.buildRational((RationalNode)node);
            }
            case REDONODE: {
                return this.buildRedo(s2);
            }
            case REGEXPNODE: {
                return this.buildRegexp((RegexpNode)node, s2);
            }
            case RESCUEBODYNODE: {
                throw new NotCompilableException("rescue body is handled by rescue compilation at: " + node.getPosition());
            }
            case RESCUENODE: {
                return this.buildRescue((RescueNode)node, s2);
            }
            case RETRYNODE: {
                return this.buildRetry(s2);
            }
            case RETURNNODE: {
                return this.buildReturn((ReturnNode)node, s2);
            }
            case ROOTNODE: {
                throw new NotCompilableException("Use buildRoot(); Root node at: " + node.getPosition());
            }
            case SCLASSNODE: {
                return this.buildSClass((SClassNode)node, s2);
            }
            case SELFNODE: {
                return this.buildSelf(s2);
            }
            case SPLATNODE: {
                return this.buildSplat((SplatNode)node, s2);
            }
            case STRNODE: {
                return this.buildStr((StrNode)node, s2);
            }
            case SUPERNODE: {
                return this.buildSuper((SuperNode)node, s2);
            }
            case SVALUENODE: {
                return this.buildSValue((SValueNode)node, s2);
            }
            case SYMBOLNODE: {
                return this.buildSymbol((SymbolNode)node);
            }
            case TRUENODE: {
                return this.buildTrue();
            }
            case UNDEFNODE: {
                return this.buildUndef(node, s2);
            }
            case UNTILNODE: {
                return this.buildUntil((UntilNode)node, s2);
            }
            case VALIASNODE: {
                return this.buildVAlias((VAliasNode)node, s2);
            }
            case VCALLNODE: {
                return this.buildVCall((VCallNode)node, s2);
            }
            case WHILENODE: {
                return this.buildWhile((WhileNode)node, s2);
            }
            case WHENNODE: {
                assert (false) : "When nodes are handled by case node compilation.";
                return null;
            }
            case XSTRNODE: {
                return this.buildXStr((XStrNode)node, s2);
            }
            case YIELDNODE: {
                return this.buildYield((YieldNode)node, s2);
            }
            case ZARRAYNODE: {
                return this.buildZArray(s2);
            }
            case ZSUPERNODE: {
                return this.buildZSuper((ZSuperNode)node, s2);
            }
        }
        throw new NotCompilableException("Unknown node encountered in builder: " + node.getClass());
    }

    private boolean hasListener() {
        return this.manager.getIRScopeListener() != null;
    }

    public static IRBuilder newIRBuilder(IRManager manager) {
        return new IRBuilder(manager);
    }

    public Node skipOverNewlines(IRScope s2, Node n) {
        int currLineNum;
        if (n.getNodeType() == NodeType.NEWLINENODE && (currLineNum = n.getPosition().getLine()) != this._lastProcessedLineNum) {
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                this.addInstr(s2, new TraceInstr(RubyEvent.LINE, this.methodNameFor(s2), s2.getFileName(), currLineNum));
            }
            this.addInstr(s2, new LineNumberInstr(currLineNum));
            this._lastProcessedLineNum = currLineNum;
        }
        while (n.getNodeType() == NodeType.NEWLINENODE) {
            n = ((NewlineNode)n).getNextNode();
        }
        return n;
    }

    public Operand build(Node node, IRScope s2) {
        if (node == null) {
            return null;
        }
        if (s2 == null) {
            System.out.println("Got a null scope!");
            throw new NotCompilableException("Unknown node encountered in builder: " + node);
        }
        if (this.hasListener()) {
            IRScopeListener listener = this.manager.getIRScopeListener();
            listener.startBuildOperand(node, s2);
        }
        Operand operand = this.buildOperand(node, s2);
        if (this.hasListener()) {
            IRScopeListener listener = this.manager.getIRScopeListener();
            listener.endBuildOperand(node, s2, operand);
        }
        return operand;
    }

    public Operand buildLambda(LambdaNode node, IRScope s2) {
        Nil closureRetVal;
        IRClosure closure = new IRClosure(this.manager, s2, node.getPosition().getLine(), node.getScope(), Signature.from(node), node.getArgumentType());
        IRBuilder closureBuilder = IRBuilder.newIRBuilder(this.manager);
        closureBuilder.prepareImplicitState(closure);
        closureBuilder.addInstr(closure, new CopyInstr(closure.getCurrentScopeVariable(), CurrentScope.CURRENT_SCOPE[0]));
        closureBuilder.addInstr(closure, new CopyInstr(closure.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        closureBuilder.receiveBlockArgs(node, closure);
        Operand operand = closureRetVal = node.getBody() == null ? this.manager.getNil() : closureBuilder.build(node.getBody(), closure);
        if (closureRetVal != U_NIL) {
            closureBuilder.addInstr(closure, new ReturnInstr(closureRetVal));
        }
        closureBuilder.handleBreakAndReturnsInLambdas(closure);
        TemporaryLocalVariable lambda2 = s2.createTemporaryVariable();
        WrappedIRClosure lambdaBody = new WrappedIRClosure(closure.getSelf(), closure);
        this.addInstr(s2, new BuildLambdaInstr(lambda2, lambdaBody, node.getPosition()));
        return lambda2;
    }

    public Operand buildEncoding(EncodingNode node, IRScope s2) {
        TemporaryLocalVariable ret = s2.createTemporaryVariable();
        this.addInstr(s2, new GetEncodingInstr(ret, node.getEncoding()));
        return ret;
    }

    public Operand buildMultipleAsgn19(MultipleAsgn19Node multipleAsgnNode, IRScope s2) {
        Operand values2 = this.build(multipleAsgnNode.getValueNode(), s2);
        Variable ret = this.getValueInTemporaryVariable(s2, values2);
        TemporaryLocalVariable tmp = s2.createTemporaryVariable();
        this.addInstr(s2, new ToAryInstr(tmp, ret));
        this.buildMultipleAsgn19Assignment(multipleAsgnNode, s2, null, tmp);
        return ret;
    }

    protected Variable copyAndReturnValue(IRScope s2, Operand val) {
        return this.addResultInstr(s2, new CopyInstr(s2.createTemporaryVariable(), val));
    }

    protected Variable getValueInTemporaryVariable(IRScope s2, Operand val) {
        if (val != null && val instanceof TemporaryVariable) {
            return (Variable)val;
        }
        return this.copyAndReturnValue(s2, val);
    }

    protected Operand buildAttrAssignCallArgs(List<Operand> argsList, Node args2, IRScope s2) {
        switch (args2.getNodeType()) {
            case ARRAYNODE: {
                Operand last2 = this.manager.getNil();
                for (Node n : args2.childNodes()) {
                    last2 = this.build(n, s2);
                    argsList.add(last2);
                }
                return last2;
            }
            case ARGSPUSHNODE: {
                ArgsPushNode argsPushNode = (ArgsPushNode)args2;
                Operand lhs = this.build(argsPushNode.getFirstNode(), s2);
                Operand rhs = this.build(argsPushNode.getSecondNode(), s2);
                TemporaryLocalVariable res = s2.createTemporaryVariable();
                this.addInstr(s2, new BuildCompoundArrayInstr(res, lhs, rhs, true));
                argsList.add(new Splat(res));
                return rhs;
            }
            case SPLATNODE: {
                Splat rhs = new Splat(this.buildSplat((SplatNode)args2, s2));
                argsList.add(rhs);
                return rhs;
            }
        }
        throw new NotCompilableException("Invalid node for attrassign call args: " + args2.getClass().getSimpleName() + ":" + args2.getPosition());
    }

    protected Operand[] buildCallArgs(Node args2, IRScope s2) {
        switch (args2.getNodeType()) {
            case ARGSCATNODE: 
            case ARGSPUSHNODE: {
                return new Operand[]{new Splat(this.build(args2, s2))};
            }
            case ARRAYNODE: {
                List<Node> children = args2.childNodes();
                int numberOfArgs = children.size();
                Operand[] builtArgs = new Operand[numberOfArgs];
                for (int i2 = 0; i2 < numberOfArgs; ++i2) {
                    builtArgs[i2] = this.build(children.get(i2), s2);
                }
                return builtArgs;
            }
            case SPLATNODE: {
                return new Operand[]{new Splat(this.buildSplat((SplatNode)args2, s2))};
            }
        }
        throw new NotCompilableException("Invalid node for call args: " + args2.getClass().getSimpleName() + ":" + args2.getPosition());
    }

    public Operand[] setupCallArgs(Node args2, IRScope s2) {
        return args2 == null ? Operand.EMPTY_ARRAY : this.buildCallArgs(args2, s2);
    }

    public static Operand[] addArg(Operand[] args2, Operand extraArg) {
        Operand[] newArgs = new Operand[args2.length + 1];
        System.arraycopy(args2, 0, newArgs, 0, args2.length);
        newArgs[args2.length] = extraArg;
        return newArgs;
    }

    public void buildVersionSpecificAssignment(Node node, IRScope s2, Variable v) {
        switch (node.getNodeType()) {
            case MULTIPLEASGN19NODE: {
                TemporaryLocalVariable tmp = s2.createTemporaryVariable();
                this.addInstr(s2, new ToAryInstr(tmp, v));
                this.buildMultipleAsgn19Assignment((MultipleAsgn19Node)node, s2, null, tmp);
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    public void buildAssignment(Node node, IRScope s2, Variable rhsVal) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                this.buildAttrAssignAssignment(node, s2, rhsVal);
                break;
            }
            case CLASSVARASGNNODE: {
                this.addInstr(s2, new PutClassVariableInstr(this.classVarDefinitionContainer(s2), ((ClassVarAsgnNode)node).getName(), rhsVal));
                break;
            }
            case CLASSVARDECLNODE: {
                this.addInstr(s2, new PutClassVariableInstr(this.classVarDeclarationContainer(s2), ((ClassVarDeclNode)node).getName(), rhsVal));
                break;
            }
            case CONSTDECLNODE: {
                this.buildConstDeclAssignment((ConstDeclNode)node, s2, rhsVal);
                break;
            }
            case DASGNNODE: {
                DAsgnNode variable = (DAsgnNode)node;
                int depth = variable.getDepth();
                this.addInstr(s2, new CopyInstr(s2.getLocalVariable(variable.getName(), depth), rhsVal));
                break;
            }
            case GLOBALASGNNODE: {
                this.addInstr(s2, new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), rhsVal));
                break;
            }
            case INSTASGNNODE: {
                this.addInstr(s2, new PutFieldInstr(s2.getSelf(), ((InstAsgnNode)node).getName(), rhsVal));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                int depth = localVariable.getDepth();
                this.addInstr(s2, new CopyInstr(s2.getLocalVariable(localVariable.getName(), depth), rhsVal));
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                this.buildVersionSpecificAssignment(node, s2, rhsVal);
            }
        }
    }

    protected LocalVariable getBlockArgVariable(IRScope s2, String name2, int depth) {
        if (!(s2 instanceof IRFor)) {
            throw new NotCompilableException("Cannot ask for block-arg variable in 1.9 mode");
        }
        return s2.getLocalVariable(name2, depth);
    }

    protected void receiveBlockArg(IRScope s2, Variable v, Operand argsArray, int argIndex, boolean isSplat) {
        if (argsArray != null) {
            if (isSplat) {
                this.addInstr(s2, new RestArgMultipleAsgnInstr(v, argsArray, argIndex));
            } else {
                this.addInstr(s2, new ReqdArgMultipleAsgnInstr(v, argsArray, argIndex));
            }
        } else {
            this.addInstr(s2, isSplat ? new ReceiveRestArgInstr(v, argIndex, argIndex) : new ReceivePreReqdArgInstr(v, argIndex));
        }
    }

    public void buildVersionSpecificBlockArgsAssignment(Node node, IRScope s2) {
        if (!(s2 instanceof IRFor)) {
            throw new NotCompilableException("Should not have come here for block args assignment in 1.9 mode: " + node);
        }
        switch (node.getNodeType()) {
            case MULTIPLEASGN19NODE: {
                ListNode sourceArray = ((MultipleAsgn19Node)node).getPre();
                int i2 = 0;
                for (Node an : sourceArray.childNodes()) {
                    this.buildBlockArgsAssignment(an, s2, null, i2, false);
                    ++i2;
                }
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    public void buildBlockArgsAssignment(Node node, IRScope s2, Operand argsArray, int argIndex, boolean isSplat) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                TemporaryLocalVariable v = s2.createTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isSplat);
                this.buildAttrAssignAssignment(node, s2, v);
                break;
            }
            case DASGNNODE: {
                DAsgnNode dynamicAsgn = (DAsgnNode)node;
                LocalVariable v = this.getBlockArgVariable(s2, dynamicAsgn.getName(), dynamicAsgn.getDepth());
                this.receiveBlockArg(s2, v, argsArray, argIndex, isSplat);
                break;
            }
            case CLASSVARASGNNODE: {
                TemporaryLocalVariable v = s2.createTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isSplat);
                this.addInstr(s2, new PutClassVariableInstr(this.classVarDefinitionContainer(s2), ((ClassVarAsgnNode)node).getName(), v));
                break;
            }
            case CLASSVARDECLNODE: {
                TemporaryLocalVariable v = s2.createTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isSplat);
                this.addInstr(s2, new PutClassVariableInstr(this.classVarDeclarationContainer(s2), ((ClassVarDeclNode)node).getName(), v));
                break;
            }
            case CONSTDECLNODE: {
                TemporaryLocalVariable v = s2.createTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isSplat);
                this.buildConstDeclAssignment((ConstDeclNode)node, s2, v);
                break;
            }
            case GLOBALASGNNODE: {
                TemporaryLocalVariable v = s2.createTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isSplat);
                this.addInstr(s2, new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), v));
                break;
            }
            case INSTASGNNODE: {
                TemporaryLocalVariable v = s2.createTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isSplat);
                this.addInstr(s2, new PutFieldInstr(s2.getSelf(), ((InstAsgnNode)node).getName(), v));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                int depth = localVariable.getDepth();
                LocalVariable v = this.getBlockArgVariable(s2, localVariable.getName(), depth);
                this.receiveBlockArg(s2, v, argsArray, argIndex, isSplat);
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                this.buildVersionSpecificBlockArgsAssignment(node, s2);
            }
        }
    }

    public Operand buildAlias(AliasNode alias2, IRScope s2) {
        Operand newName = this.build(alias2.getNewName(), s2);
        Operand oldName = this.build(alias2.getOldName(), s2);
        this.addInstr(s2, new AliasInstr(newName, oldName));
        return this.manager.getNil();
    }

    public Operand buildAnd(AndNode andNode, IRScope s2) {
        if (andNode.getFirstNode().getNodeType().alwaysTrue()) {
            this.build(andNode.getFirstNode(), s2);
            return this.build(andNode.getSecondNode(), s2);
        }
        if (andNode.getFirstNode().getNodeType().alwaysFalse()) {
            return this.build(andNode.getFirstNode(), s2);
        }
        Label l = s2.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode(), s2);
        Variable ret = this.getValueInTemporaryVariable(s2, v1);
        this.addInstr(s2, BEQInstr.create(v1, this.manager.getFalse(), l));
        Operand v2 = this.build(andNode.getSecondNode(), s2);
        this.addInstr(s2, new CopyInstr(ret, v2));
        this.addInstr(s2, new LabelInstr(l));
        return ret;
    }

    public Operand buildArray(Node node, IRScope s2) {
        ArrayList<Operand> elts = new ArrayList<Operand>();
        for (Node e : node.childNodes()) {
            elts.add(this.build(e, s2));
        }
        return this.copyAndReturnValue(s2, new Array(elts));
    }

    public Operand buildArgsCat(ArgsCatNode argsCatNode, IRScope s2) {
        Operand v1 = this.build(argsCatNode.getFirstNode(), s2);
        Operand v2 = this.build(argsCatNode.getSecondNode(), s2);
        TemporaryLocalVariable res = s2.createTemporaryVariable();
        this.addInstr(s2, new BuildCompoundArrayInstr(res, v1, v2, false));
        return res;
    }

    public Operand buildArgsPush(ArgsPushNode node, IRScope s2) {
        Operand lhs = this.build(node.getFirstNode(), s2);
        Operand rhs = this.build(node.getSecondNode(), s2);
        return this.addResultInstr(s2, new BuildCompoundArrayInstr(s2.createTemporaryVariable(), lhs, rhs, true));
    }

    private Operand buildAttrAssign(AttrAssignNode attrAssignNode, IRScope s2) {
        Operand obj = this.build(attrAssignNode.getReceiverNode(), s2);
        ArrayList<Operand> args2 = new ArrayList<Operand>();
        Node argsNode = attrAssignNode.getArgsNode();
        Nil lastArg = argsNode == null ? this.manager.getNil() : this.buildAttrAssignCallArgs(args2, argsNode, s2);
        this.addInstr(s2, AttrAssignInstr.create(obj, attrAssignNode.getName(), args2.toArray(new Operand[args2.size()])));
        return lastArg;
    }

    public Operand buildAttrAssignAssignment(Node node, IRScope s2, Operand value2) {
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        Operand obj = this.build(attrAssignNode.getReceiverNode(), s2);
        Operand[] args2 = this.setupCallArgs(attrAssignNode.getArgsNode(), s2);
        args2 = IRBuilder.addArg(args2, value2);
        this.addInstr(s2, AttrAssignInstr.create(obj, attrAssignNode.getName(), args2));
        return value2;
    }

    public Operand buildBackref(BackRefNode node, IRScope s2) {
        return this.copyAndReturnValue(s2, new Backref(node.getType()));
    }

    public Operand buildBegin(BeginNode beginNode, IRScope s2) {
        return this.build(beginNode.getBodyNode(), s2);
    }

    public Operand buildBignum(BignumNode node) {
        return new Bignum(node.getValue());
    }

    public Operand buildBlock(BlockNode node, IRScope s2) {
        Operand retVal = null;
        for (Node child : node.childNodes()) {
            retVal = this.build(child, s2);
        }
        return retVal;
    }

    public Operand buildBreak(BreakNode breakNode, IRScope s2) {
        IRLoop currLoop = this.getCurrentLoop();
        Operand rv = this.build(breakNode.getValueNode(), s2);
        if (!this.activeEnsureBlockStack.empty()) {
            this.emitEnsureBlocks(s2, currLoop);
        } else if (!this.activeRescueBlockStack.empty()) {
            this.activeRescueBlockStack.peek().restoreException(this, s2, currLoop);
        }
        if (currLoop != null) {
            this.addInstr(s2, new CopyInstr(currLoop.loopResult, rv));
            this.addInstr(s2, new JumpInstr(currLoop.loopEndLabel));
        } else if (s2 instanceof IRClosure) {
            IRScope returnScope = s2.getLexicalParent();
            if (s2 instanceof IREvalScript || returnScope == null) {
                this.addInstr(s2, new ThrowExceptionInstr(IRException.BREAK_LocalJumpError));
            } else {
                this.addInstr(s2, new BreakInstr(rv, returnScope.getName()));
            }
        } else {
            this.addInstr(s2, new ThrowExceptionInstr(IRException.BREAK_LocalJumpError));
        }
        return U_NIL;
    }

    private void handleNonlocalReturnInMethod(IRScope s2) {
        Label rBeginLabel = s2.getNewLabel();
        Label rEndLabel = s2.getNewLabel();
        Label gebLabel = s2.getNewLabel();
        this.addInstrAtBeginning(s2, new ExceptionRegionStartMarkerInstr(gebLabel));
        this.addInstrAtBeginning(s2, new LabelInstr(rBeginLabel));
        this.addInstr(s2, new ExceptionRegionEndMarkerInstr());
        this.addInstr(s2, new LabelInstr(gebLabel));
        TemporaryLocalVariable exc = s2.createTemporaryVariable();
        this.addInstr(s2, new ReceiveJRubyExceptionInstr(exc));
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(s2, new TraceInstr(RubyEvent.RETURN, s2.getName(), s2.getFileName(), -1));
        }
        TemporaryLocalVariable ret = s2.createTemporaryVariable();
        this.addInstr(s2, new RuntimeHelperCall(ret, RuntimeHelperCall.Methods.HANDLE_NONLOCAL_RETURN, new Operand[]{exc}));
        this.addInstr(s2, new ReturnInstr(ret));
        this.addInstr(s2, new LabelInstr(rEndLabel));
    }

    private Operand receiveBreakException(IRScope s2, Operand block, CodeBlock codeBlock) {
        if (block == null || !(block instanceof WrappedIRClosure) || !((WrappedIRClosure)block).getClosure().flags.contains((Object)IRFlags.HAS_BREAK_INSTRS)) {
            return codeBlock.run();
        }
        Label rBeginLabel = s2.getNewLabel();
        Label rEndLabel = s2.getNewLabel();
        Label rescueLabel = s2.getNewLabel();
        this.addInstr(s2, new LabelInstr(rBeginLabel));
        this.addInstr(s2, new ExceptionRegionStartMarkerInstr(rescueLabel));
        Variable callResult = (Variable)codeBlock.run();
        this.addInstr(s2, new JumpInstr(rEndLabel));
        this.addInstr(s2, new ExceptionRegionEndMarkerInstr());
        this.addInstr(s2, new LabelInstr(rescueLabel));
        TemporaryLocalVariable exc = s2.createTemporaryVariable();
        this.addInstr(s2, new ReceiveJRubyExceptionInstr(exc));
        this.addInstr(s2, new RuntimeHelperCall(callResult, RuntimeHelperCall.Methods.HANDLE_PROPAGATE_BREAK, new Operand[]{exc}));
        this.addInstr(s2, new LabelInstr(rEndLabel));
        return callResult;
    }

    private void receiveBreakException(final IRScope s2, Operand block, final CallInstr callInstr) {
        this.receiveBreakException(s2, block, new CodeBlock(){

            @Override
            public Operand run() {
                IRBuilder.this.addInstr(s2, callInstr);
                return callInstr.getResult();
            }
        });
    }

    public Operand buildCall(CallNode callNode, IRScope s2) {
        Node callArgsNode = callNode.getArgsNode();
        Node receiverNode = callNode.getReceiverNode();
        if (receiverNode instanceof StrNode && callNode.getName().equals("freeze")) {
            return new FrozenString(((StrNode)receiverNode).getValue());
        }
        Operand receiver2 = this.build(receiverNode, s2);
        Operand[] args2 = this.setupCallArgs(callArgsNode, s2);
        Operand block = this.setupCallClosure(callNode.getIterNode(), s2);
        TemporaryLocalVariable callResult = s2.createTemporaryVariable();
        CallInstr callInstr = CallInstr.create(callResult, callNode.getName(), receiver2, args2, block);
        if (callNode.getName().equals("new") && receiverNode instanceof ConstNode && ((ConstNode)receiverNode).getName().equals("Proc")) {
            callInstr.setProcNew(true);
        }
        this.receiveBreakException(s2, block, callInstr);
        return callResult;
    }

    public Operand buildCase(CaseNode caseNode, IRScope s2) {
        Operand value2 = this.build(caseNode.getCaseNode(), s2);
        if (value2 == null) {
            value2 = UndefinedValue.UNDEFINED;
        }
        Label endLabel = s2.getNewLabel();
        boolean hasElse = caseNode.getElseNode() != null;
        Label elseLabel = s2.getNewLabel();
        TemporaryLocalVariable result2 = s2.createTemporaryVariable();
        ArrayList<Label> labels = new ArrayList<Label>();
        HashMap<Label, Node> bodies = new HashMap<Label, Node>();
        for (Node aCase : caseNode.getCases().childNodes()) {
            Operand v2;
            Operand v1;
            WhenNode whenNode = (WhenNode)aCase;
            Label bodyLabel = s2.getNewLabel();
            TemporaryLocalVariable eqqResult = s2.createTemporaryVariable();
            labels.add(bodyLabel);
            if (whenNode.getExpressionNodes() instanceof ListNode && !(whenNode.getExpressionNodes() instanceof DNode)) {
                if (value2 == UndefinedValue.UNDEFINED) {
                    v1 = this.build(whenNode.getExpressionNodes(), s2);
                    v2 = this.manager.getTrue();
                } else {
                    v1 = value2;
                    v2 = this.build(whenNode.getExpressionNodes(), s2);
                }
            } else {
                this.addInstr(s2, new EQQInstr(eqqResult, this.build(whenNode.getExpressionNodes(), s2), value2));
                v1 = eqqResult;
                v2 = this.manager.getTrue();
            }
            this.addInstr(s2, BEQInstr.create(v1, v2, bodyLabel));
            bodies.put(bodyLabel, whenNode.getBodyNode());
        }
        this.addInstr(s2, new JumpInstr(elseLabel));
        if (hasElse) {
            labels.add(elseLabel);
            bodies.put(elseLabel, caseNode.getElseNode());
        }
        for (Label whenLabel : labels) {
            this.addInstr(s2, new LabelInstr(whenLabel));
            Operand bodyValue = this.build((Node)bodies.get(whenLabel), s2);
            if (bodyValue == null) continue;
            this.addInstr(s2, new CopyInstr(result2, bodyValue));
            this.addInstr(s2, new JumpInstr(endLabel));
        }
        if (!hasElse) {
            this.addInstr(s2, new LabelInstr(elseLabel));
            this.addInstr(s2, new CopyInstr(result2, this.manager.getNil()));
            this.addInstr(s2, new JumpInstr(endLabel));
        }
        this.addInstr(s2, new LabelInstr(endLabel));
        return result2;
    }

    public Operand buildClass(ClassNode classNode, IRScope s2) {
        Node superNode = classNode.getSuperNode();
        Colon3Node cpath = classNode.getCPath();
        Operand superClass = superNode == null ? null : this.build(superNode, s2);
        String className = cpath.getName();
        Operand container = this.getContainerFromCPath(cpath, s2);
        IRClassBody body = new IRClassBody(this.manager, s2, className, classNode.getPosition().getLine(), classNode.getScope());
        Variable classVar = this.addResultInstr(s2, new DefineClassInstr(s2.createTemporaryVariable(), body, container, superClass));
        return this.buildModuleOrClassBody(s2, classVar, body, classNode.getBodyNode(), classNode.getPosition().getLine(), NullBlock.INSTANCE);
    }

    public Operand buildSClass(SClassNode sclassNode, IRScope s2) {
        Operand receiver2 = this.build(sclassNode.getReceiverNode(), s2);
        IRMetaClassBody body = new IRMetaClassBody(this.manager, s2, this.manager.getMetaClassName(), sclassNode.getPosition().getLine(), sclassNode.getScope());
        Variable sClassVar = this.addResultInstr(s2, new DefineMetaClassInstr(s2.createTemporaryVariable(), receiver2, body));
        return this.buildModuleOrClassBody(s2, sClassVar, body, sclassNode.getBodyNode(), sclassNode.getPosition().getLine(), s2.getYieldClosureVariable());
    }

    public Operand buildClassVar(ClassVarNode node, IRScope s2) {
        TemporaryLocalVariable ret = s2.createTemporaryVariable();
        this.addInstr(s2, new GetClassVariableInstr(ret, this.classVarDefinitionContainer(s2), node.getName()));
        return ret;
    }

    private Variable addResultInstr(IRScope s2, ResultInstr instr) {
        this.addInstr(s2, (Instr)((Object)instr));
        return instr.getResult();
    }

    public Operand buildClassVarAsgn(ClassVarAsgnNode classVarAsgnNode, IRScope s2) {
        Operand val = this.build(classVarAsgnNode.getValueNode(), s2);
        this.addInstr(s2, new PutClassVariableInstr(this.classVarDefinitionContainer(s2), classVarAsgnNode.getName(), val));
        return val;
    }

    public Operand buildClassVarDecl(ClassVarDeclNode classVarDeclNode, IRScope s2) {
        Operand val = this.build(classVarDeclNode.getValueNode(), s2);
        this.addInstr(s2, new PutClassVariableInstr(this.classVarDeclarationContainer(s2), classVarDeclNode.getName(), val));
        return val;
    }

    public Operand classVarDeclarationContainer(IRScope s2) {
        return this.classVarContainer(s2, true);
    }

    public Operand classVarDefinitionContainer(IRScope s2) {
        return this.classVarContainer(s2, false);
    }

    public Operand classVarContainer(IRScope s2, boolean declContext) {
        int n = 0;
        IRScope cvarScope = s2;
        while (cvarScope != null && !(cvarScope instanceof IREvalScript) && !cvarScope.isNonSingletonClassBody()) {
            cvarScope = cvarScope.getLexicalParent();
            ++n;
        }
        if (cvarScope != null && cvarScope.isNonSingletonClassBody()) {
            return ScopeModule.ModuleFor(n);
        }
        return this.addResultInstr(s2, new GetClassVarContainerModuleInstr(s2.createTemporaryVariable(), (Operand)s2.getCurrentScopeVariable(), declContext ? null : s2.getSelf()));
    }

    public Operand buildConstDecl(ConstDeclNode node, IRScope s2) {
        return this.buildConstDeclAssignment(node, s2, this.build(node.getValueNode(), s2));
    }

    private Operand findContainerModule(IRScope s2) {
        int nearestModuleBodyDepth = s2.getNearestModuleReferencingScopeDepth();
        return nearestModuleBodyDepth == -1 ? s2.getCurrentModuleVariable() : ScopeModule.ModuleFor(nearestModuleBodyDepth);
    }

    private Operand startingSearchScope(IRScope s2) {
        int nearestModuleBodyDepth = s2.getNearestModuleReferencingScopeDepth();
        return nearestModuleBodyDepth == -1 ? s2.getCurrentScopeVariable() : CurrentScope.ScopeFor(nearestModuleBodyDepth);
    }

    public Operand buildConstDeclAssignment(ConstDeclNode constDeclNode, IRScope s2, Operand val) {
        Node constNode = constDeclNode.getConstNode();
        if (constNode == null) {
            this.addInstr(s2, new PutConstInstr(this.findContainerModule(s2), constDeclNode.getName(), val));
        } else if (constNode.getNodeType() == NodeType.COLON2NODE) {
            Operand module = this.build(((Colon2Node)constNode).getLeftNode(), s2);
            this.addInstr(s2, new PutConstInstr(module, constDeclNode.getName(), val));
        } else {
            this.addInstr(s2, new PutConstInstr(new ObjectClass(), constDeclNode.getName(), val));
        }
        return val;
    }

    private void genInheritanceSearchInstrs(IRScope s2, Operand startingModule, Variable constVal, Label foundLabel, boolean noPrivateConstants, String name2) {
        this.addInstr(s2, new InheritanceSearchConstInstr(constVal, startingModule, name2, noPrivateConstants));
        this.addInstr(s2, BNEInstr.create(constVal, UndefinedValue.UNDEFINED, foundLabel));
        this.addInstr(s2, new ConstMissingInstr(constVal, startingModule, name2));
        this.addInstr(s2, new LabelInstr(foundLabel));
    }

    private Operand searchConstInInheritanceHierarchy(IRScope s2, Operand startingModule, String name2) {
        TemporaryLocalVariable constVal = s2.createTemporaryVariable();
        this.genInheritanceSearchInstrs(s2, startingModule, constVal, s2.getNewLabel(), true, name2);
        return constVal;
    }

    private Operand searchConst(IRScope s2, String name2) {
        boolean noPrivateConstants = false;
        TemporaryLocalVariable v = s2.createTemporaryVariable();
        this.addInstr(s2, new SearchConstInstr(v, name2, this.startingSearchScope(s2), false));
        return v;
    }

    public Operand buildColon2(Colon2Node iVisited, IRScope s2) {
        Node leftNode = iVisited.getLeftNode();
        String name2 = iVisited.getName();
        if (leftNode == null) {
            return this.searchConst(s2, name2);
        }
        Operand module = this.build(leftNode, s2);
        return this.searchConstInInheritanceHierarchy(s2, module, name2);
    }

    public Operand buildColon3(Colon3Node node, IRScope s2) {
        return this.searchConstInInheritanceHierarchy(s2, new ObjectClass(), node.getName());
    }

    public Operand buildComplex(ComplexNode node, IRScope s2) {
        return new Complex((ImmutableLiteral)this.build(node.getNumber(), s2));
    }

    private Operand protectCodeWithRescue(IRScope s2, CodeBlock protectedCode, CodeBlock rescueBlock) {
        TemporaryLocalVariable rv = s2.createTemporaryVariable();
        Label rBeginLabel = s2.getNewLabel();
        Label rEndLabel = s2.getNewLabel();
        Label rescueLabel = s2.getNewLabel();
        this.addInstr(s2, new LabelInstr(rBeginLabel));
        this.addInstr(s2, new ExceptionRegionStartMarkerInstr(rescueLabel));
        Operand v1 = protectedCode.run();
        this.addInstr(s2, new CopyInstr(rv, v1));
        this.addInstr(s2, new JumpInstr(rEndLabel));
        this.addInstr(s2, new ExceptionRegionEndMarkerInstr());
        Label caughtLabel = s2.getNewLabel();
        TemporaryLocalVariable exc = s2.createTemporaryVariable();
        TemporaryLocalVariable excType = s2.createTemporaryVariable();
        this.addInstr(s2, new LabelInstr(rescueLabel));
        this.addInstr(s2, new ReceiveRubyExceptionInstr(exc));
        this.addInstr(s2, new InheritanceSearchConstInstr(excType, new ObjectClass(), "Exception", false));
        this.outputExceptionCheck(s2, excType, exc, caughtLabel);
        this.addInstr(s2, new ThrowExceptionInstr(exc));
        this.addInstr(s2, new LabelInstr(caughtLabel));
        Operand v2 = rescueBlock.run();
        if (v2 != null) {
            this.addInstr(s2, new CopyInstr(rv, this.manager.getNil()));
        }
        this.addInstr(s2, new LabelInstr(rEndLabel));
        return rv;
    }

    public Operand buildGetDefinition(Node node, final IRScope scope) {
        node = this.skipOverNewlines(scope, node);
        switch (node.getNodeType()) {
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case INSTASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case MULTIPLEASGN19NODE: 
            case OPASGNANDNODE: 
            case OPASGNNODE: 
            case OPASGNORNODE: 
            case OPELEMENTASGNNODE: {
                return new ConstantStringLiteral("assignment");
            }
            case ANDNODE: 
            case ORNODE: {
                return new ConstantStringLiteral("expression");
            }
            case FALSENODE: {
                return new ConstantStringLiteral("false");
            }
            case DVARNODE: 
            case LOCALVARNODE: {
                return new ConstantStringLiteral("local-variable");
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                return new ConstantStringLiteral("method");
            }
            case NILNODE: {
                return new ConstantStringLiteral("nil");
            }
            case SELFNODE: {
                return new ConstantStringLiteral("self");
            }
            case TRUENODE: {
                return new ConstantStringLiteral("true");
            }
            case DREGEXPNODE: 
            case DSTRNODE: {
                final Node dNode = node;
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run() {
                        IRBuilder.this.build(dNode, scope);
                        return new ConstantStringLiteral("expression");
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run() {
                        return IRBuilder.this.manager.getNil();
                    }
                };
                Operand v = this.protectCodeWithRescue(scope, protectedCode, rescueBlock);
                Label doneLabel = scope.getNewLabel();
                Variable tmpVar = this.getValueInTemporaryVariable(scope, v);
                this.addInstr(scope, BNEInstr.create(tmpVar, this.manager.getNil(), doneLabel));
                this.addInstr(scope, new CopyInstr(tmpVar, new ConstantStringLiteral("expression")));
                this.addInstr(scope, new LabelInstr(doneLabel));
                return tmpVar;
            }
            case ARRAYNODE: {
                ArrayNode array = (ArrayNode)node;
                Label undefLabel = scope.getNewLabel();
                Label doneLabel = scope.getNewLabel();
                TemporaryLocalVariable tmpVar = scope.createTemporaryVariable();
                for (Node elt : array.childNodes()) {
                    Operand result2 = this.buildGetDefinition(elt, scope);
                    this.addInstr(scope, BEQInstr.create(result2, this.manager.getNil(), undefLabel));
                }
                this.addInstr(scope, new CopyInstr(tmpVar, new ConstantStringLiteral("expression")));
                this.addInstr(scope, new JumpInstr(doneLabel));
                this.addInstr(scope, new LabelInstr(undefLabel));
                this.addInstr(scope, new CopyInstr(tmpVar, this.manager.getNil()));
                this.addInstr(scope, new LabelInstr(doneLabel));
                return tmpVar;
            }
            case BACKREFNODE: {
                return this.addResultInstr(scope, new RuntimeHelperCall(scope.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_BACKREF, Operand.EMPTY_ARRAY));
            }
            case GLOBALVARNODE: {
                return this.addResultInstr(scope, new RuntimeHelperCall(scope.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_GLOBAL, new Operand[]{new StringLiteral(((GlobalVarNode)node).getName())}));
            }
            case NTHREFNODE: {
                return this.addResultInstr(scope, new RuntimeHelperCall(scope.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_NTH_REF, new Operand[]{new Fixnum(((NthRefNode)node).getMatchNumber())}));
            }
            case INSTVARNODE: {
                return this.addResultInstr(scope, new RuntimeHelperCall(scope.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_INSTANCE_VAR, new Operand[]{scope.getSelf(), new StringLiteral(((InstVarNode)node).getName())}));
            }
            case CLASSVARNODE: {
                return this.addResultInstr(scope, new RuntimeHelperCall(scope.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_CLASS_VAR, new Operand[]{this.classVarDefinitionContainer(scope), new StringLiteral(((ClassVarNode)node).getName())}));
            }
            case SUPERNODE: {
                Label undefLabel = scope.getNewLabel();
                Variable tmpVar = this.addResultInstr(scope, new RuntimeHelperCall(scope.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{scope.getSelf()}));
                this.addInstr(scope, BEQInstr.create(tmpVar, this.manager.getNil(), undefLabel));
                Operand superDefnVal = this.buildGetArgumentDefinition(((SuperNode)node).getArgsNode(), scope, "super");
                return this.buildDefnCheckIfThenPaths(scope, undefLabel, superDefnVal);
            }
            case VCALLNODE: {
                return this.addResultInstr(scope, new RuntimeHelperCall(scope.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{scope.getSelf(), new StringLiteral(((VCallNode)node).getName()), this.manager.getFalse()}));
            }
            case YIELDNODE: {
                return this.buildDefinitionCheck(scope, new BlockGivenInstr(scope.createTemporaryVariable(), scope.getYieldClosureVariable()), "yield");
            }
            case ZSUPERNODE: {
                return this.addResultInstr(scope, new RuntimeHelperCall(scope.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_SUPER, new Operand[]{scope.getSelf()}));
            }
            case CONSTNODE: {
                Label defLabel = scope.getNewLabel();
                Label doneLabel = scope.getNewLabel();
                TemporaryLocalVariable tmpVar = scope.createTemporaryVariable();
                String constName = ((ConstNode)node).getName();
                this.addInstr(scope, new LexicalSearchConstInstr(tmpVar, this.startingSearchScope(scope), constName));
                this.addInstr(scope, BNEInstr.create(tmpVar, UndefinedValue.UNDEFINED, defLabel));
                this.addInstr(scope, new InheritanceSearchConstInstr(tmpVar, this.findContainerModule(scope), constName, false));
                this.addInstr(scope, BNEInstr.create(tmpVar, UndefinedValue.UNDEFINED, defLabel));
                this.addInstr(scope, new CopyInstr(tmpVar, this.manager.getNil()));
                this.addInstr(scope, new JumpInstr(doneLabel));
                this.addInstr(scope, new LabelInstr(defLabel));
                this.addInstr(scope, new CopyInstr(tmpVar, new ConstantStringLiteral("constant")));
                this.addInstr(scope, new LabelInstr(doneLabel));
                return tmpVar;
            }
            case COLON2NODE: 
            case COLON3NODE: {
                final Colon3Node colon = (Colon3Node)node;
                final String name2 = colon.getName();
                final TemporaryLocalVariable errInfo = scope.createTemporaryVariable();
                this.addInstr(scope, new GetErrorInfoInstr(errInfo));
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run() {
                        ObjectClass v = colon instanceof Colon2Node ? IRBuilder.this.build(((Colon2Node)colon).getLeftNode(), scope) : new ObjectClass();
                        TemporaryLocalVariable tmpVar = scope.createTemporaryVariable();
                        IRBuilder.this.addInstr(scope, new RuntimeHelperCall(tmpVar, RuntimeHelperCall.Methods.IS_DEFINED_CONSTANT_OR_METHOD, new Operand[]{v, new ConstantStringLiteral(name2)}));
                        return tmpVar;
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run() {
                        IRBuilder.this.addInstr(scope, new RestoreErrorInfoInstr(errInfo));
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(scope, protectedCode, rescueBlock);
            }
            case FCALLNODE: {
                Label undefLabel = scope.getNewLabel();
                Variable tmpVar = this.addResultInstr(scope, new RuntimeHelperCall(scope.createTemporaryVariable(), RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{scope.getSelf(), new StringLiteral(((FCallNode)node).getName()), this.manager.getFalse()}));
                this.addInstr(scope, BEQInstr.create(tmpVar, this.manager.getNil(), undefLabel));
                Operand argsCheckDefn = this.buildGetArgumentDefinition(((FCallNode)node).getArgsNode(), scope, "method");
                return this.buildDefnCheckIfThenPaths(scope, undefLabel, argsCheckDefn);
            }
            case CALLNODE: {
                final Label undefLabel = scope.getNewLabel();
                final CallNode callNode = (CallNode)node;
                Operand receiverDefn = this.buildGetDefinition(callNode.getReceiverNode(), scope);
                this.addInstr(scope, BEQInstr.create(receiverDefn, this.manager.getNil(), undefLabel));
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run() {
                        TemporaryLocalVariable tmpVar = scope.createTemporaryVariable();
                        IRBuilder.this.addInstr(scope, new RuntimeHelperCall(tmpVar, RuntimeHelperCall.Methods.IS_DEFINED_CALL, new Operand[]{IRBuilder.this.build(callNode.getReceiverNode(), scope), new StringLiteral(callNode.getName())}));
                        return IRBuilder.this.buildDefnCheckIfThenPaths(scope, undefLabel, tmpVar);
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run() {
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(scope, protectedCode, rescueBlock);
            }
            case ATTRASSIGNNODE: {
                final Label undefLabel = scope.getNewLabel();
                final AttrAssignNode attrAssign = (AttrAssignNode)node;
                Operand receiverDefn = this.buildGetDefinition(attrAssign.getReceiverNode(), scope);
                this.addInstr(scope, BEQInstr.create(receiverDefn, this.manager.getNil(), undefLabel));
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run() {
                        TemporaryLocalVariable tmpVar = scope.createTemporaryVariable();
                        Operand receiver2 = IRBuilder.this.build(attrAssign.getReceiverNode(), scope);
                        IRBuilder.this.addInstr(scope, new RuntimeHelperCall(tmpVar, RuntimeHelperCall.Methods.IS_DEFINED_METHOD, new Operand[]{receiver2, new StringLiteral(attrAssign.getName()), IRBuilder.this.manager.getTrue()}));
                        IRBuilder.this.addInstr(scope, BEQInstr.create(tmpVar, IRBuilder.this.manager.getNil(), undefLabel));
                        Operand argsCheckDefn = IRBuilder.this.buildGetArgumentDefinition(attrAssign.getArgsNode(), scope, "assignment");
                        return IRBuilder.this.buildDefnCheckIfThenPaths(scope, undefLabel, argsCheckDefn);
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run() {
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(scope, protectedCode, rescueBlock);
            }
        }
        return new ConstantStringLiteral("expression");
    }

    protected Variable buildDefnCheckIfThenPaths(IRScope s2, Label undefLabel, Operand defVal) {
        Label defLabel = s2.getNewLabel();
        Variable tmpVar = this.getValueInTemporaryVariable(s2, defVal);
        this.addInstr(s2, new JumpInstr(defLabel));
        this.addInstr(s2, new LabelInstr(undefLabel));
        this.addInstr(s2, new CopyInstr(tmpVar, this.manager.getNil()));
        this.addInstr(s2, new LabelInstr(defLabel));
        return tmpVar;
    }

    protected Variable buildDefinitionCheck(IRScope s2, ResultInstr definedInstr, String definedReturnValue) {
        Label undefLabel = s2.getNewLabel();
        this.addInstr(s2, (Instr)((Object)definedInstr));
        this.addInstr(s2, BEQInstr.create(definedInstr.getResult(), this.manager.getFalse(), undefLabel));
        return this.buildDefnCheckIfThenPaths(s2, undefLabel, new ConstantStringLiteral(definedReturnValue));
    }

    public Operand buildGetArgumentDefinition(Node node, IRScope s2, String type2) {
        if (node == null) {
            return new StringLiteral(type2);
        }
        Operand rv = new ConstantStringLiteral(type2);
        boolean failPathReqd = false;
        Label failLabel = s2.getNewLabel();
        if (node instanceof ArrayNode) {
            for (int i2 = 0; i2 < ((ArrayNode)node).size(); ++i2) {
                Node iterNode = ((ArrayNode)node).get(i2);
                Operand def = this.buildGetDefinition(iterNode, s2);
                if (def == this.manager.getNil()) {
                    rv = this.manager.getNil();
                    break;
                }
                if (def.hasKnownValue()) continue;
                failPathReqd = true;
                this.addInstr(s2, BEQInstr.create(def, this.manager.getNil(), failLabel));
            }
        } else {
            Operand def = this.buildGetDefinition(node, s2);
            if (def == this.manager.getNil()) {
                rv = this.manager.getNil();
            } else if (!def.hasKnownValue()) {
                failPathReqd = true;
                this.addInstr(s2, BEQInstr.create(def, this.manager.getNil(), failLabel));
            }
        }
        return failPathReqd ? this.buildDefnCheckIfThenPaths(s2, failLabel, rv) : rv;
    }

    public Operand buildDAsgn(DAsgnNode dasgnNode, IRScope s2) {
        int depth = dasgnNode.getDepth();
        LocalVariable arg2 = s2.getLocalVariable(dasgnNode.getName(), depth);
        Operand value2 = this.build(dasgnNode.getValueNode(), s2);
        this.addInstr(s2, new CopyInstr(arg2, value2));
        return value2;
    }

    protected IRMethod defineMethodInner(MethodDefNode defNode, IRMethod method, IRScope parent) {
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(method, new TraceInstr(RubyEvent.CALL, method.getName(), method.getFileName(), method.getLineNumber()));
        }
        this.prepareImplicitState(method);
        int nearestScopeDepth = parent.getNearestModuleReferencingScopeDepth();
        this.addInstr(method, new CopyInstr(method.getCurrentScopeVariable(), CurrentScope.ScopeFor(nearestScopeDepth == -1 ? 1 : nearestScopeDepth)));
        this.addInstr(method, new CopyInstr(method.getCurrentModuleVariable(), ScopeModule.ModuleFor(nearestScopeDepth == -1 ? 1 : nearestScopeDepth)));
        this.receiveMethodArgs(defNode.getArgsNode(), method);
        this.addInstr(method, new ThreadPollInstr());
        Operand rv = IRBuilder.newIRBuilder(this.manager).build(defNode.getBodyNode(), method);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            this.addInstr(method, new TraceInstr(RubyEvent.RETURN, method.getName(), method.getFileName(), -1));
        }
        if (rv != null) {
            this.addInstr(method, new ReturnInstr(rv));
        }
        if (method.canReceiveNonlocalReturns()) {
            this.handleNonlocalReturnInMethod(method);
        }
        return method;
    }

    private IRMethod defineNewMethod(MethodDefNode defNode, IRScope parent, boolean isInstanceMethod) {
        return new IRMethod(this.manager, parent, defNode, defNode.getName(), isInstanceMethod, defNode.getPosition().getLine(), defNode.getScope());
    }

    public Operand buildDefn(MethodDefNode node, IRScope s2) {
        IRMethod method = this.defineNewMethod(node, s2, true);
        this.addInstr(s2, new DefineInstanceMethodInstr(method));
        return new Symbol(method.getName(), (Encoding)ASCIIEncoding.INSTANCE);
    }

    public Operand buildDefs(DefsNode node, IRScope s2) {
        Operand container = this.build(node.getReceiverNode(), s2);
        IRMethod method = this.defineNewMethod(node, s2, false);
        this.addInstr(s2, new DefineClassMethodInstr(container, method));
        return new Symbol(method.getName(), (Encoding)ASCIIEncoding.INSTANCE);
    }

    protected LocalVariable getArgVariable(IRScope s2, String name2, int depth) {
        return s2 instanceof IRFor ? s2.getLocalVariable(name2, depth) : s2.getNewLocalVariable(name2, 0);
    }

    private void addArgReceiveInstr(IRScope s2, Variable v, int argIndex, boolean post, int numPreReqd, int numPostRead) {
        if (post) {
            this.addInstr(s2, new ReceivePostReqdArgInstr(v, argIndex, numPreReqd, numPostRead));
        } else {
            this.addInstr(s2, new ReceivePreReqdArgInstr(v, argIndex));
        }
    }

    public void receiveRequiredArg(Node node, IRScope s2, int argIndex, boolean post, int numPreReqd, int numPostRead) {
        switch (node.getNodeType()) {
            case ARGUMENTNODE: {
                ArgumentNode a = (ArgumentNode)node;
                String argName = a.getName();
                if (s2 instanceof IRMethod) {
                    ((IRMethod)s2).addArgDesc(IRMethodArgs.ArgType.req, argName);
                }
                if (argName.equals("_$0")) break;
                this.addArgReceiveInstr(s2, s2.getNewLocalVariable(argName, 0), argIndex, post, numPreReqd, numPostRead);
                break;
            }
            case MULTIPLEASGN19NODE: {
                MultipleAsgn19Node childNode = (MultipleAsgn19Node)node;
                TemporaryLocalVariable v = s2.createTemporaryVariable();
                this.addArgReceiveInstr(s2, v, argIndex, post, numPreReqd, numPostRead);
                if (s2 instanceof IRMethod) {
                    ((IRMethod)s2).addArgDesc(IRMethodArgs.ArgType.req, "");
                }
                TemporaryLocalVariable tmp = s2.createTemporaryVariable();
                this.addInstr(s2, new ToAryInstr(tmp, v));
                this.buildMultipleAsgn19Assignment(childNode, s2, tmp, null);
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    protected void receiveNonBlockArgs(ArgsNode argsNode, IRScope s2) {
        int numPreReqd = argsNode.getPreCount();
        int numPostReqd = argsNode.getPostCount();
        int required = argsNode.getRequiredArgsCount();
        int opt = argsNode.getOptionalArgsCount();
        int rest2 = argsNode.getRestArg();
        s2.getStaticScope().setArities(required, opt, rest2);
        KeywordRestArgNode keyRest = argsNode.getKeyRest();
        if (s2 instanceof IRMethod) {
            this.addInstr(s2, new CheckArityInstr(required, opt, rest2, argsNode.hasKwargs(), keyRest == null ? -1 : keyRest.getIndex()));
        } else if (s2 instanceof IRClosure && argsNode.hasKwargs()) {
            this.addInstr(s2, new CheckArityInstr(required, opt, rest2, argsNode.hasKwargs(), keyRest == null ? -1 : keyRest.getIndex()));
        }
        int argIndex = 0;
        ListNode preArgs = argsNode.getPre();
        int i2 = 0;
        while (i2 < numPreReqd) {
            this.receiveRequiredArg(preArgs.get(i2), s2, argIndex, false, -1, -1);
            ++i2;
            ++argIndex;
        }
        opt = opt > 0 ? opt : 0;
        int n = rest2 = rest2 > -1 ? 1 : 0;
        if (opt > 0) {
            ListNode optArgs = argsNode.getOptArgs();
            int j = 0;
            while (j < opt) {
                Label l = s2.getNewLabel();
                OptArgNode n2 = (OptArgNode)optArgs.get(j);
                String argName = n2.getName();
                LocalVariable av = s2.getNewLocalVariable(argName, 0);
                if (s2 instanceof IRMethod) {
                    ((IRMethod)s2).addArgDesc(IRMethodArgs.ArgType.opt, argName);
                }
                this.addInstr(s2, new ReceiveOptArgInstr(av, required, numPreReqd, j));
                this.addInstr(s2, BNEInstr.create(av, UndefinedValue.UNDEFINED, l));
                this.build(n2.getValue(), s2);
                this.addInstr(s2, new LabelInstr(l));
                ++j;
                ++argIndex;
            }
        }
        if (rest2 > 0) {
            String argName = argsNode.getRestArgNode().getName();
            if (s2 instanceof IRMethod) {
                ((IRMethod)s2).addArgDesc(IRMethodArgs.ArgType.rest, argName == null ? "" : argName);
            }
            argName = argName == null || argName.equals("") ? "*" : argName;
            this.addInstr(s2, new ReceiveRestArgInstr(s2.getNewLocalVariable(argName, 0), required + opt, argIndex));
        }
        ListNode postArgs = argsNode.getPost();
        for (int i3 = 0; i3 < numPostReqd; ++i3) {
            this.receiveRequiredArg(postArgs.get(i3), s2, i3, true, numPreReqd, numPostReqd);
        }
    }

    protected void receiveBlockArg(ArgsNode argsNode, IRScope s2) {
        BlockArgNode blockArg = argsNode.getBlock();
        if (blockArg != null) {
            String blockArgName = blockArg.getName();
            LocalVariable blockVar = s2.getLocalVariable(blockArgName, 0);
            if (s2 instanceof IRMethod) {
                ((IRMethod)s2).addArgDesc(IRMethodArgs.ArgType.block, blockArgName);
            }
            TemporaryLocalVariable tmp = s2.createTemporaryVariable();
            this.addInstr(s2, new LoadImplicitClosureInstr(tmp));
            this.addInstr(s2, new ReifyClosureInstr(blockVar, tmp));
        }
    }

    private void prepareImplicitState(IRScope s2) {
        this.addInstr(s2, new ReceiveSelfInstr(s2.getSelf()));
        if (s2 instanceof IRMethod || s2 instanceof IRMetaClassBody) {
            this.addInstr(s2, new LoadImplicitClosureInstr(s2.getYieldClosureVariable()));
        } else {
            this.addInstr(s2, new LoadFrameClosureInstr(s2.getYieldClosureVariable()));
        }
    }

    public void receiveArgs(ArgsNode argsNode, IRScope s2) {
        KeywordRestArgNode keyRest;
        this.receiveNonBlockArgs(argsNode, s2);
        ListNode keywords = argsNode.getKeywords();
        int required = argsNode.getRequiredArgsCount();
        if (keywords != null) {
            for (Node knode : keywords.childNodes()) {
                KeywordArgNode kwarg = (KeywordArgNode)knode;
                AssignableNode kasgn = kwarg.getAssignable();
                String argName = ((INameNode)((Object)kasgn)).getName();
                LocalVariable av = s2.getNewLocalVariable(argName, 0);
                Label l = s2.getNewLabel();
                if (s2 instanceof IRMethod) {
                    ((IRMethod)s2).addArgDesc(IRMethodArgs.ArgType.key, argName);
                }
                this.addInstr(s2, new ReceiveKeywordArgInstr(av, argName, required));
                this.addInstr(s2, BNEInstr.create(av, UndefinedValue.UNDEFINED, l));
                if (kasgn.getValueNode().getNodeType() != NodeType.REQUIRED_KEYWORD_ARGUMENT_VALUE) {
                    this.build(kasgn, s2);
                } else {
                    this.addInstr(s2, new RaiseRequiredKeywordArgumentError(argName));
                }
                this.addInstr(s2, new LabelInstr(l));
            }
        }
        if ((keyRest = argsNode.getKeyRest()) != null) {
            String argName = keyRest.getName();
            LocalVariable av = s2.getNewLocalVariable(argName, 0);
            if (s2 instanceof IRMethod) {
                ((IRMethod)s2).addArgDesc(IRMethodArgs.ArgType.keyrest, argName);
            }
            this.addInstr(s2, new ReceiveKeywordRestArgInstr(av, required));
        }
        this.receiveBlockArg(argsNode, s2);
    }

    public void buildArgsMasgn(Node node, IRScope s2, Operand argsArray, boolean isMasgnRoot, int preArgsCount, int postArgsCount, int index2, boolean isSplat) {
        switch (node.getNodeType()) {
            case DASGNNODE: {
                DAsgnNode dynamicAsgn = (DAsgnNode)node;
                LocalVariable v = this.getArgVariable(s2, dynamicAsgn.getName(), dynamicAsgn.getDepth());
                if (isSplat) {
                    this.addInstr(s2, new RestArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    break;
                }
                this.addInstr(s2, new ReqdArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                LocalVariable v = this.getArgVariable(s2, localVariable.getName(), localVariable.getDepth());
                if (isSplat) {
                    this.addInstr(s2, new RestArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    break;
                }
                this.addInstr(s2, new ReqdArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                break;
            }
            case MULTIPLEASGN19NODE: {
                MultipleAsgn19Node childNode = (MultipleAsgn19Node)node;
                if (!isMasgnRoot) {
                    TemporaryLocalVariable v = s2.createTemporaryVariable();
                    if (isSplat) {
                        this.addInstr(s2, new RestArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    } else {
                        this.addInstr(s2, new ReqdArgMultipleAsgnInstr(v, argsArray, preArgsCount, postArgsCount, index2));
                    }
                    TemporaryLocalVariable tmp = s2.createTemporaryVariable();
                    this.addInstr(s2, new ToAryInstr(tmp, v));
                    argsArray = tmp;
                }
                this.buildMultipleAsgn19Assignment(childNode, s2, argsArray, null);
                break;
            }
            default: {
                throw new NotCompilableException("Shouldn't get here: " + node);
            }
        }
    }

    public void buildMultipleAsgn19Assignment(MultipleAsgn19Node multipleAsgnNode, IRScope s2, Operand argsArray, Operand values2) {
        ListNode masgnPost;
        TemporaryLocalVariable rhsVal;
        ListNode masgnPre = multipleAsgnNode.getPre();
        int i2 = 0;
        if (masgnPre != null) {
            for (Node an : masgnPre.childNodes()) {
                if (values2 == null) {
                    this.buildArgsMasgn(an, s2, argsArray, false, -1, -1, i2, false);
                } else {
                    rhsVal = s2.createTemporaryVariable();
                    this.addInstr(s2, new ReqdArgMultipleAsgnInstr(rhsVal, values2, i2));
                    this.buildAssignment(an, s2, rhsVal);
                }
                ++i2;
            }
        }
        Node restNode = multipleAsgnNode.getRest();
        int postArgsCount = multipleAsgnNode.getPostCount();
        if (restNode != null && !(restNode instanceof StarNode)) {
            if (values2 == null) {
                this.buildArgsMasgn(restNode, s2, argsArray, false, i2, postArgsCount, 0, true);
            } else {
                rhsVal = s2.createTemporaryVariable();
                this.addInstr(s2, new RestArgMultipleAsgnInstr(rhsVal, values2, i2, postArgsCount, 0));
                this.buildAssignment(restNode, s2, rhsVal);
            }
        }
        if ((masgnPost = multipleAsgnNode.getPost()) != null) {
            int j = 0;
            for (Node an : masgnPost.childNodes()) {
                if (values2 == null) {
                    this.buildArgsMasgn(an, s2, argsArray, false, i2, postArgsCount, j, false);
                } else {
                    TemporaryLocalVariable rhsVal2 = s2.createTemporaryVariable();
                    this.addInstr(s2, new ReqdArgMultipleAsgnInstr(rhsVal2, values2, i2, postArgsCount, j));
                    this.buildAssignment(an, s2, rhsVal2);
                }
                ++j;
            }
        }
    }

    private void handleBreakAndReturnsInLambdas(IRClosure s2) {
        Label rEndLabel = s2.getNewLabel();
        Label rescueLabel = Label.getGlobalEnsureBlockLabel();
        this.addInstrAtBeginning(s2, new ExceptionRegionStartMarkerInstr(rescueLabel));
        this.addInstr(s2, new ExceptionRegionEndMarkerInstr());
        this.addInstr(s2, new LabelInstr(rescueLabel));
        TemporaryLocalVariable exc = s2.createTemporaryVariable();
        this.addInstr(s2, new ReceiveJRubyExceptionInstr(exc));
        TemporaryLocalVariable ret = s2.createTemporaryVariable();
        this.addInstr(s2, new RuntimeHelperCall(ret, RuntimeHelperCall.Methods.HANDLE_BREAK_AND_RETURNS_IN_LAMBDA, new Operand[]{exc}));
        this.addInstr(s2, new ReturnInstr(ret));
        this.addInstr(s2, new LabelInstr(rEndLabel));
    }

    public void receiveMethodArgs(ArgsNode argsNode, IRMethod s2) {
        this.receiveArgs(argsNode, s2);
    }

    public void receiveBlockArgs(IterNode node, IRScope s2) {
        Node args2 = node.getVarNode();
        if (args2 instanceof ArgsNode) {
            ((IRClosure)s2).setParameterList(Helpers.encodeParameterList((ArgsNode)args2).split(";"));
            this.receiveArgs((ArgsNode)args2, s2);
        } else {
            this.buildBlockArgsAssignment(args2, s2, null, 0, false);
        }
    }

    public Operand buildDot(DotNode dotNode, IRScope s2) {
        TemporaryLocalVariable res = s2.createTemporaryVariable();
        this.addInstr(s2, new BuildRangeInstr(res, this.build(dotNode.getBeginNode(), s2), this.build(dotNode.getEndNode(), s2), dotNode.isExclusive()));
        return res;
    }

    private Operand dynamicPiece(Node pieceNode, IRScope s2) {
        Operand piece = this.build(pieceNode, s2);
        return piece == null ? this.manager.getNil() : piece;
    }

    public Operand buildDRegexp(DRegexpNode node, IRScope s2) {
        List<Node> nodePieces = node.childNodes();
        Operand[] pieces = new Operand[nodePieces.size()];
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            pieces[i2] = this.dynamicPiece(nodePieces.get(i2), s2);
        }
        TemporaryLocalVariable res = s2.createTemporaryVariable();
        this.addInstr(s2, new BuildDynRegExpInstr(res, pieces, node.getOptions()));
        return res;
    }

    public Operand buildDStr(DStrNode node, IRScope s2) {
        List<Node> nodePieces = node.childNodes();
        Operand[] pieces = new Operand[nodePieces.size()];
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            pieces[i2] = this.dynamicPiece(nodePieces.get(i2), s2);
        }
        TemporaryLocalVariable res = s2.createTemporaryVariable();
        this.addInstr(s2, new BuildCompoundStringInstr(res, pieces, node.getEncoding()));
        return this.copyAndReturnValue(s2, res);
    }

    public Operand buildDSymbol(DSymbolNode node, IRScope s2) {
        List<Node> nodePieces = node.childNodes();
        Operand[] pieces = new Operand[nodePieces.size()];
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            pieces[i2] = this.dynamicPiece(nodePieces.get(i2), s2);
        }
        TemporaryLocalVariable res = s2.createTemporaryVariable();
        this.addInstr(s2, new BuildCompoundStringInstr(res, pieces, node.getEncoding()));
        return this.copyAndReturnValue(s2, new DynamicSymbol(res));
    }

    public Operand buildDVar(DVarNode node, IRScope s2) {
        return s2.getLocalVariable(node.getName(), node.getDepth());
    }

    public Operand buildDXStr(DXStrNode dstrNode, IRScope s2) {
        List<Node> nodePieces = dstrNode.childNodes();
        Operand[] pieces = new Operand[nodePieces.size()];
        for (int i2 = 0; i2 < pieces.length; ++i2) {
            pieces[i2] = this.dynamicPiece(nodePieces.get(i2), s2);
        }
        return this.addResultInstr(s2, new BacktickInstr(s2.createTemporaryVariable(), pieces));
    }

    public Operand buildEnsureNode(EnsureNode ensureNode, IRScope s2) {
        Node bodyNode = ensureNode.getBodyNode();
        EnsureBlockInfo ebi = new EnsureBlockInfo(s2, bodyNode instanceof RescueNode ? (RescueNode)bodyNode : null, this.getCurrentLoop(), this.activeRescuers.peek());
        this.ensureBodyBuildStack.push(ebi);
        Nil ensureRetVal = ensureNode.getEnsureNode() == null ? this.manager.getNil() : this.build(ensureNode.getEnsureNode(), s2);
        this.ensureBodyBuildStack.pop();
        this.activeEnsureBlockStack.push(ebi);
        this.addInstr(s2, new LabelInstr(ebi.regionStart));
        this.addInstr(s2, new ExceptionRegionStartMarkerInstr(ebi.dummyRescueBlockLabel));
        this.activeRescuers.push(ebi.dummyRescueBlockLabel);
        Operand rv = bodyNode instanceof RescueNode ? this.buildRescueInternal((RescueNode)bodyNode, s2, ebi) : this.build(bodyNode, s2);
        this.addInstr(s2, new ExceptionRegionEndMarkerInstr());
        this.activeRescuers.pop();
        if (rv != U_NIL && !(bodyNode instanceof RescueNode)) {
            ebi.cloneIntoHostScope(this, s2);
            this.addInstr(s2, new JumpInstr(ebi.end));
        }
        this.activeEnsureBlockStack.pop();
        TemporaryLocalVariable exc = s2.createTemporaryVariable();
        this.addInstr(s2, new LabelInstr(ebi.dummyRescueBlockLabel));
        this.addInstr(s2, new ReceiveJRubyExceptionInstr(exc));
        ebi.emitBody(this, s2);
        if (ensureRetVal == U_NIL) {
            rv = U_NIL;
        }
        this.addInstr(s2, new ThrowExceptionInstr(exc));
        this.addInstr(s2, new LabelInstr(ebi.end));
        return rv;
    }

    public Operand buildEvStr(EvStrNode node, IRScope s2) {
        return new AsString(this.build(node.getBody(), s2));
    }

    public Operand buildFalse() {
        return this.manager.getFalse();
    }

    public Operand buildFCall(FCallNode fcallNode, IRScope s2) {
        Node callArgsNode = fcallNode.getArgsNode();
        Operand[] args2 = this.setupCallArgs(callArgsNode, s2);
        Operand block = this.setupCallClosure(fcallNode.getIterNode(), s2);
        TemporaryLocalVariable callResult = s2.createTemporaryVariable();
        CallInstr callInstr = CallInstr.create(CallType.FUNCTIONAL, callResult, fcallNode.getName(), s2.getSelf(), args2, block);
        this.receiveBreakException(s2, block, callInstr);
        return callResult;
    }

    private Operand setupCallClosure(Node node, IRScope s2) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case ITERNODE: {
                return this.build(node, s2);
            }
            case BLOCKPASSNODE: {
                return this.build(((BlockPassNode)node).getBodyNode(), s2);
            }
        }
        throw new NotCompilableException("ERROR: Encountered a method with a non-block, non-blockpass iter node at: " + node);
    }

    public Operand buildFixnum(FixnumNode node) {
        return new Fixnum(node.getValue());
    }

    public Operand buildFlip(FlipNode flipNode, IRScope s2) {
        Fixnum s1 = new Fixnum(1L);
        Fixnum s22 = new Fixnum(2L);
        IRScope nearestNonClosure = s2.getNearestFlipVariableScope();
        LocalVariable flipState = nearestNonClosure.getNewFlipStateVariable();
        nearestNonClosure.initFlipStateVariable(flipState, s1);
        if (s2 instanceof IRClosure) {
            int n = 0;
            IRScope x = s2;
            while (!x.isFlipScope()) {
                ++n;
                x = x.getLexicalParent();
            }
            if (n > 0) {
                flipState = flipState.cloneForDepth(n);
            }
        }
        TemporaryLocalVariable returnVal = s2.createTemporaryVariable();
        Label s2Label = s2.getNewLabel();
        Label doneLabel = s2.getNewLabel();
        this.addInstr(s2, new CopyInstr(returnVal, this.manager.getFalse()));
        this.addInstr(s2, BNEInstr.create(flipState, s1, s2Label));
        Operand s1Val = this.build(flipNode.getBeginNode(), s2);
        this.addInstr(s2, BNEInstr.create(s1Val, this.manager.getTrue(), s2Label));
        this.addInstr(s2, new CopyInstr(returnVal, this.manager.getTrue()));
        this.addInstr(s2, new CopyInstr(flipState, s22));
        this.addInstr(s2, new LabelInstr(s2Label));
        if (flipNode.isExclusive()) {
            this.addInstr(s2, BEQInstr.create(returnVal, this.manager.getTrue(), doneLabel));
        }
        this.addInstr(s2, BNEInstr.create(flipState, s22, doneLabel));
        Operand s2Val = this.build(flipNode.getEndNode(), s2);
        this.addInstr(s2, new CopyInstr(returnVal, this.manager.getTrue()));
        this.addInstr(s2, BNEInstr.create(s2Val, this.manager.getTrue(), doneLabel));
        this.addInstr(s2, new CopyInstr(flipState, s1));
        this.addInstr(s2, new LabelInstr(doneLabel));
        return returnVal;
    }

    public Operand buildFloat(FloatNode node) {
        return new Float(node.getValue());
    }

    public Operand buildFor(ForNode forNode, IRScope s2) {
        TemporaryLocalVariable result2 = s2.createTemporaryVariable();
        Operand receiver2 = this.build(forNode.getIterNode(), s2);
        Operand forBlock = this.buildForIter(forNode, s2);
        CallInstr callInstr = new CallInstr(CallType.NORMAL, result2, "each", receiver2, NO_ARGS, forBlock);
        this.receiveBreakException(s2, forBlock, callInstr);
        return result2;
    }

    public Operand buildForIter(ForNode forNode, IRScope s2) {
        Nil closureRetVal;
        IRFor closure = new IRFor(this.manager, s2, forNode.getPosition().getLine(), forNode.getScope(), Signature.from(forNode), forNode.getArgumentType());
        IRBuilder forBuilder = IRBuilder.newIRBuilder(this.manager);
        forBuilder.prepareImplicitState(closure);
        Node varNode = forNode.getVarNode();
        if (varNode != null && varNode.getNodeType() != null) {
            forBuilder.receiveBlockArgs(forNode, closure);
        }
        forBuilder.addInstr(closure, new CopyInstr(closure.getCurrentScopeVariable(), CurrentScope.CURRENT_SCOPE[0]));
        forBuilder.addInstr(closure, new CopyInstr(closure.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        forBuilder.addInstr(closure, new ThreadPollInstr());
        forBuilder.addInstr(closure, new LabelInstr(closure.startLabel));
        Operand operand = closureRetVal = forNode.getBodyNode() == null ? this.manager.getNil() : forBuilder.build(forNode.getBodyNode(), closure);
        if (closureRetVal != U_NIL) {
            forBuilder.addInstr(closure, new ReturnInstr(closureRetVal));
        }
        return new WrappedIRClosure(s2.getSelf(), closure);
    }

    public Operand buildGlobalAsgn(GlobalAsgnNode globalAsgnNode, IRScope s2) {
        Operand value2 = this.build(globalAsgnNode.getValueNode(), s2);
        this.addInstr(s2, new PutGlobalVarInstr(globalAsgnNode.getName(), value2));
        return value2;
    }

    public Operand buildGlobalVar(GlobalVarNode node, IRScope s2) {
        return this.addResultInstr(s2, new GetGlobalVariableInstr((Variable)s2.createTemporaryVariable(), node.getName()));
    }

    public Operand buildHash(HashNode hashNode, IRScope s2) {
        ArrayList<KeyValuePair<Operand, Operand>> args2 = new ArrayList<KeyValuePair<Operand, Operand>>();
        Operand splatKeywordArgument = null;
        for (KeyValuePair<Node, Node> pair : hashNode.getPairs()) {
            Node key2 = pair.getKey();
            if (key2 == null) {
                splatKeywordArgument = this.build(pair.getValue(), s2);
                break;
            }
            Operand keyOperand = this.build(key2, s2);
            args2.add(new KeyValuePair<Operand, Operand>(keyOperand, this.build(pair.getValue(), s2)));
        }
        if (splatKeywordArgument != null) {
            TemporaryLocalVariable tmp = s2.createTemporaryVariable();
            s2.addInstr(new RuntimeHelperCall(tmp, RuntimeHelperCall.Methods.MERGE_KWARGS, new Operand[]{splatKeywordArgument, new Hash(args2)}));
            return tmp;
        }
        return this.copyAndReturnValue(s2, new Hash(args2));
    }

    public Operand buildIf(IfNode ifNode, IRScope s2) {
        Variable result2;
        Node actualCondition = this.skipOverNewlines(s2, ifNode.getCondition());
        Label falseLabel = s2.getNewLabel();
        Label doneLabel = s2.getNewLabel();
        this.addInstr(s2, BEQInstr.create(this.build(actualCondition, s2), this.manager.getFalse(), falseLabel));
        boolean thenNull = false;
        boolean elseNull = false;
        boolean thenUnil = false;
        boolean elseUnil = false;
        if (ifNode.getThenBody() != null) {
            Operand thenResult = this.build(ifNode.getThenBody(), s2);
            if (thenResult != U_NIL) {
                result2 = this.getValueInTemporaryVariable(s2, thenResult);
                this.addInstr(s2, new JumpInstr(doneLabel));
            } else {
                result2 = s2.createTemporaryVariable();
                thenUnil = true;
            }
        } else {
            thenNull = true;
            result2 = this.addResultInstr(s2, new CopyInstr(s2.createTemporaryVariable(), this.manager.getNil()));
            this.addInstr(s2, new JumpInstr(doneLabel));
        }
        this.addInstr(s2, new LabelInstr(falseLabel));
        if (ifNode.getElseBody() != null) {
            Operand elseResult = this.build(ifNode.getElseBody(), s2);
            if (elseResult != U_NIL) {
                this.addInstr(s2, new CopyInstr(result2, elseResult));
            } else {
                elseUnil = true;
            }
        } else {
            elseNull = true;
            this.addInstr(s2, new CopyInstr(result2, this.manager.getNil()));
        }
        if (thenNull && elseNull) {
            this.addInstr(s2, new LabelInstr(doneLabel));
            return this.manager.getNil();
        }
        if (thenUnil && elseUnil) {
            return U_NIL;
        }
        this.addInstr(s2, new LabelInstr(doneLabel));
        return result2;
    }

    public Operand buildInstAsgn(InstAsgnNode instAsgnNode, IRScope s2) {
        Operand val = this.build(instAsgnNode.getValueNode(), s2);
        this.addInstr(s2, new PutFieldInstr(s2.getSelf(), instAsgnNode.getName(), val));
        return val;
    }

    public Operand buildInstVar(InstVarNode node, IRScope s2) {
        return this.addResultInstr(s2, new GetFieldInstr(s2.createTemporaryVariable(), (Operand)s2.getSelf(), node.getName()));
    }

    public Operand buildIter(IterNode iterNode, IRScope s2) {
        Nil closureRetVal;
        IRClosure closure = new IRClosure(this.manager, s2, iterNode.getPosition().getLine(), iterNode.getScope(), Signature.from(iterNode), iterNode.getArgumentType());
        IRBuilder closureBuilder = IRBuilder.newIRBuilder(this.manager);
        closureBuilder.prepareImplicitState(closure);
        if (iterNode.getVarNode().getNodeType() != null) {
            closureBuilder.receiveBlockArgs(iterNode, closure);
        }
        closureBuilder.addInstr(closure, new CopyInstr(closure.getCurrentScopeVariable(), CurrentScope.CURRENT_SCOPE[0]));
        closureBuilder.addInstr(closure, new CopyInstr(closure.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        closureBuilder.addInstr(closure, new ThreadPollInstr());
        closureBuilder.addInstr(closure, new LabelInstr(closure.startLabel));
        Operand operand = closureRetVal = iterNode.getBodyNode() == null ? this.manager.getNil() : closureBuilder.build(iterNode.getBodyNode(), closure);
        if (closureRetVal != U_NIL) {
            closureBuilder.addInstr(closure, new ReturnInstr(closureRetVal));
        }
        closureBuilder.handleBreakAndReturnsInLambdas(closure);
        return new WrappedIRClosure(s2.getSelf(), closure);
    }

    public Operand buildLiteral(LiteralNode literalNode, IRScope s2) {
        return this.copyAndReturnValue(s2, new StringLiteral(literalNode.getName()));
    }

    public Operand buildLocalAsgn(LocalAsgnNode localAsgnNode, IRScope s2) {
        LocalVariable var = s2.getLocalVariable(localAsgnNode.getName(), localAsgnNode.getDepth());
        Operand value2 = this.build(localAsgnNode.getValueNode(), s2);
        this.addInstr(s2, new CopyInstr(var, value2));
        return value2;
    }

    public Operand buildLocalVar(LocalVarNode node, IRScope s2) {
        return s2.getLocalVariable(node.getName(), node.getDepth());
    }

    public Operand buildMatch(MatchNode matchNode, IRScope s2) {
        Operand regexp2 = this.build(matchNode.getRegexpNode(), s2);
        return this.addResultInstr(s2, new MatchInstr(s2.createTemporaryVariable(), regexp2));
    }

    public Operand buildMatch2(Match2Node matchNode, IRScope s2) {
        Operand receiver2 = this.build(matchNode.getReceiverNode(), s2);
        Operand value2 = this.build(matchNode.getValueNode(), s2);
        TemporaryLocalVariable result2 = s2.createTemporaryVariable();
        this.addInstr(s2, new Match2Instr(result2, receiver2, value2));
        if (matchNode instanceof Match2CaptureNode) {
            Match2CaptureNode m2c = (Match2CaptureNode)matchNode;
            for (int slot : m2c.getScopeOffsets()) {
                int depth = slot >> 16;
                int offset2 = slot & 0xFFFF;
                String var = this.getVarNameFromScopeTree(s2, depth, offset2);
                this.addInstr(s2, new SetCapturedVarInstr(s2.getLocalVariable(var, depth), (Operand)result2, var));
            }
        }
        return result2;
    }

    private String getVarNameFromScopeTree(IRScope scope, int depth, int offset2) {
        if (depth == 0) {
            return scope.getStaticScope().getVariables()[offset2];
        }
        return this.getVarNameFromScopeTree(scope.getLexicalParent(), depth - 1, offset2);
    }

    public Operand buildMatch3(Match3Node matchNode, IRScope s2) {
        Operand receiver2 = this.build(matchNode.getReceiverNode(), s2);
        Operand value2 = this.build(matchNode.getValueNode(), s2);
        return this.addResultInstr(s2, new Match3Instr(s2.createTemporaryVariable(), receiver2, value2));
    }

    private Operand getContainerFromCPath(Colon3Node cpath, IRScope s2) {
        Node leftNode;
        Operand container = cpath instanceof Colon2Node ? ((leftNode = ((Colon2Node)cpath).getLeftNode()) != null ? this.build(leftNode, s2) : this.findContainerModule(s2)) : new ObjectClass();
        return container;
    }

    public Operand buildModule(ModuleNode moduleNode, IRScope s2) {
        Colon3Node cpath = moduleNode.getCPath();
        String moduleName = cpath.getName();
        Operand container = this.getContainerFromCPath(cpath, s2);
        IRModuleBody body = new IRModuleBody(this.manager, s2, moduleName, moduleNode.getPosition().getLine(), moduleNode.getScope());
        Variable moduleVar = this.addResultInstr(s2, new DefineModuleInstr(s2.createTemporaryVariable(), body, container));
        return this.buildModuleOrClassBody(s2, moduleVar, body, moduleNode.getBodyNode(), moduleNode.getPosition().getLine(), NullBlock.INSTANCE);
    }

    public Operand buildMultipleAsgn(MultipleAsgnNode multipleAsgnNode, IRScope s2) {
        Operand values2 = this.build(multipleAsgnNode.getValueNode(), s2);
        Variable ret = this.getValueInTemporaryVariable(s2, values2);
        this.buildMultipleAsgnAssignment(multipleAsgnNode, s2, null, ret);
        return ret;
    }

    public void buildMultipleAsgnAssignment(MultipleAsgnNode multipleAsgnNode, IRScope s2, Operand argsArray, Operand values2) {
        Node argsNode;
        ListNode sourceArray = multipleAsgnNode.getHeadNode();
        int i2 = 0;
        if (sourceArray != null) {
            for (Node an : sourceArray.childNodes()) {
                if (values2 == null) {
                    this.buildBlockArgsAssignment(an, s2, argsArray, i2, false);
                } else {
                    Variable rhsVal = this.addResultInstr(s2, new ReqdArgMultipleAsgnInstr(s2.createTemporaryVariable(), values2, i2));
                    this.buildAssignment(an, s2, rhsVal);
                }
                ++i2;
            }
        }
        if ((argsNode = multipleAsgnNode.getArgsNode()) == null) {
            if (sourceArray == null) {
                throw new NotCompilableException("Something's wrong, multiple assignment with no head or args at: " + multipleAsgnNode.getPosition());
            }
        } else if (!(argsNode instanceof StarNode)) {
            if (values2 != null) {
                this.buildAssignment(argsNode, s2, this.addResultInstr(s2, new RestArgMultipleAsgnInstr(s2.createTemporaryVariable(), values2, i2)));
            } else {
                this.buildBlockArgsAssignment(argsNode, s2, argsArray, i2, true);
            }
        }
    }

    public Operand buildNewline(NewlineNode node, IRScope s2) {
        return this.build(this.skipOverNewlines(s2, node), s2);
    }

    public Operand buildNext(NextNode nextNode, IRScope s2) {
        Nil rv;
        IRLoop currLoop = this.getCurrentLoop();
        Operand operand = rv = nextNode.getValueNode() == null ? this.manager.getNil() : this.build(nextNode.getValueNode(), s2);
        if (!this.activeEnsureBlockStack.empty()) {
            this.emitEnsureBlocks(s2, currLoop);
        } else if (!this.activeRescueBlockStack.empty()) {
            this.activeRescueBlockStack.peek().restoreException(this, s2, currLoop);
        }
        if (currLoop != null) {
            this.addInstr(s2, new JumpInstr(currLoop.iterEndLabel));
        } else {
            this.addInstr(s2, new ThreadPollInstr(true));
            if (s2 instanceof IRClosure) {
                this.addInstr(s2, new ReturnInstr(rv));
            } else {
                this.addInstr(s2, new ThrowExceptionInstr(IRException.NEXT_LocalJumpError));
            }
        }
        return U_NIL;
    }

    public Operand buildNthRef(NthRefNode nthRefNode, IRScope s2) {
        return this.copyAndReturnValue(s2, new NthRef(nthRefNode.getMatchNumber()));
    }

    public Operand buildNil() {
        return this.manager.getNil();
    }

    public Operand buildOpAsgn(OpAsgnNode opAsgnNode, IRScope s2) {
        TemporaryLocalVariable readerValue = s2.createTemporaryVariable();
        TemporaryLocalVariable writerValue = s2.createTemporaryVariable();
        Operand v1 = this.build(opAsgnNode.getReceiverNode(), s2);
        this.addInstr(s2, CallInstr.create(readerValue, opAsgnNode.getVariableName(), v1, NO_ARGS, null));
        String opName = opAsgnNode.getOperatorName();
        if (opName.equals("||") || opName.equals("&&")) {
            Label l = s2.getNewLabel();
            this.addInstr(s2, BEQInstr.create(readerValue, opName.equals("||") ? this.manager.getTrue() : this.manager.getFalse(), l));
            Operand v2 = this.build(opAsgnNode.getValueNode(), s2);
            this.addInstr(s2, CallInstr.create(writerValue, opAsgnNode.getVariableNameAsgn(), v1, new Operand[]{v2}, null));
            this.addInstr(s2, new CopyInstr(readerValue, v2));
            this.addInstr(s2, new LabelInstr(l));
            return readerValue;
        }
        Operand v2 = this.build(opAsgnNode.getValueNode(), s2);
        TemporaryLocalVariable setValue2 = s2.createTemporaryVariable();
        this.addInstr(s2, CallInstr.create(setValue2, opAsgnNode.getOperatorName(), readerValue, new Operand[]{v2}, null));
        this.addInstr(s2, CallInstr.create(writerValue, opAsgnNode.getVariableNameAsgn(), v1, new Operand[]{setValue2}, null));
        return setValue2;
    }

    public Operand buildOpAsgnAnd(OpAsgnAndNode andNode, IRScope s2) {
        Label l = s2.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode(), s2);
        Variable result2 = this.getValueInTemporaryVariable(s2, v1);
        this.addInstr(s2, BEQInstr.create(v1, this.manager.getFalse(), l));
        Operand v2 = this.build(andNode.getSecondNode(), s2);
        this.addInstr(s2, new CopyInstr(result2, v2));
        this.addInstr(s2, new LabelInstr(l));
        return result2;
    }

    public Operand buildOpAsgnOr(OpAsgnOrNode orNode, IRScope s2) {
        Operand v1;
        Label l1 = s2.getNewLabel();
        Label l2 = null;
        TemporaryLocalVariable flag = s2.createTemporaryVariable();
        boolean needsDefnCheck = orNode.getFirstNode().needsDefinitionCheck();
        if (needsDefnCheck) {
            l2 = s2.getNewLabel();
            v1 = this.buildGetDefinition(orNode.getFirstNode(), s2);
            this.addInstr(s2, new CopyInstr(flag, v1));
            this.addInstr(s2, BEQInstr.create(flag, this.manager.getNil(), l2));
        }
        v1 = this.build(orNode.getFirstNode(), s2);
        this.addInstr(s2, new CopyInstr(flag, v1));
        Variable result2 = this.getValueInTemporaryVariable(s2, v1);
        if (needsDefnCheck) {
            this.addInstr(s2, new LabelInstr(l2));
        }
        this.addInstr(s2, BEQInstr.create(flag, this.manager.getTrue(), l1));
        Operand v2 = this.build(orNode.getSecondNode(), s2);
        this.addInstr(s2, new CopyInstr(result2, v2));
        this.addInstr(s2, new LabelInstr(l1));
        return result2;
    }

    public Operand buildOpElementAsgn(OpElementAsgnNode node, IRScope s2) {
        if (node.isOr()) {
            return this.buildOpElementAsgnWithOr(node, s2);
        }
        if (node.isAnd()) {
            return this.buildOpElementAsgnWithAnd(node, s2);
        }
        return this.buildOpElementAsgnWithMethod(node, s2);
    }

    public Operand buildOpElementAsgnWithOr(OpElementAsgnNode opElementAsgnNode, IRScope s2) {
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s2);
        Label l = s2.getNewLabel();
        TemporaryLocalVariable elt = s2.createTemporaryVariable();
        Operand[] argList = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s2);
        this.addInstr(s2, CallInstr.create(elt, "[]", array, argList, null));
        this.addInstr(s2, BEQInstr.create(elt, this.manager.getTrue(), l));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s2);
        argList = IRBuilder.addArg(argList, value2);
        this.addInstr(s2, CallInstr.create(elt, "[]=", array, argList, null));
        this.addInstr(s2, new CopyInstr(elt, value2));
        this.addInstr(s2, new LabelInstr(l));
        return elt;
    }

    public Operand buildOpElementAsgnWithAnd(OpElementAsgnNode opElementAsgnNode, IRScope s2) {
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s2);
        Label l = s2.getNewLabel();
        TemporaryLocalVariable elt = s2.createTemporaryVariable();
        Operand[] argList = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s2);
        this.addInstr(s2, CallInstr.create(elt, "[]", array, argList, null));
        this.addInstr(s2, BEQInstr.create(elt, this.manager.getFalse(), l));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s2);
        argList = IRBuilder.addArg(argList, value2);
        this.addInstr(s2, CallInstr.create(elt, "[]=", array, argList, null));
        this.addInstr(s2, new CopyInstr(elt, value2));
        this.addInstr(s2, new LabelInstr(l));
        return elt;
    }

    public Operand buildOpElementAsgnWithMethod(OpElementAsgnNode opElementAsgnNode, IRScope s2) {
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s2);
        Operand[] argList = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s2);
        TemporaryLocalVariable elt = s2.createTemporaryVariable();
        this.addInstr(s2, CallInstr.create(elt, "[]", array, argList, null));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s2);
        String operation = opElementAsgnNode.getOperatorName();
        this.addInstr(s2, CallInstr.create(elt, operation, elt, new Operand[]{value2}, null));
        TemporaryLocalVariable tmp = s2.createTemporaryVariable();
        argList = IRBuilder.addArg(argList, elt);
        this.addInstr(s2, CallInstr.create(tmp, "[]=", array, argList, null));
        return elt;
    }

    public Operand buildOr(OrNode orNode, IRScope s2) {
        if (orNode.getFirstNode().getNodeType().alwaysTrue()) {
            return this.build(orNode.getFirstNode(), s2);
        }
        if (orNode.getFirstNode().getNodeType().alwaysFalse()) {
            this.build(orNode.getFirstNode(), s2);
            return this.build(orNode.getSecondNode(), s2);
        }
        Label l = s2.getNewLabel();
        Operand v1 = this.build(orNode.getFirstNode(), s2);
        Variable ret = this.getValueInTemporaryVariable(s2, v1);
        this.addInstr(s2, BEQInstr.create(v1, this.manager.getTrue(), l));
        Operand v2 = this.build(orNode.getSecondNode(), s2);
        this.addInstr(s2, new CopyInstr(ret, v2));
        this.addInstr(s2, new LabelInstr(l));
        return ret;
    }

    public Operand buildPostExe(PostExeNode postExeNode, IRScope s2) {
        IRScope topLevel = s2.getTopLevelScope();
        IRScope nearestLVarScope = s2.getNearestTopLocalVariableScope();
        IRClosure endClosure = new IRClosure(this.manager, s2, postExeNode.getPosition().getLine(), nearestLVarScope.getStaticScope(), Signature.from(postExeNode), postExeNode.getArgumentType(), "_END_", true);
        IRBuilder closureBuilder = IRBuilder.newIRBuilder(this.manager);
        closureBuilder.addInstr(endClosure, new CopyInstr(endClosure.getCurrentScopeVariable(), CurrentScope.CURRENT_SCOPE[0]));
        closureBuilder.addInstr(endClosure, new CopyInstr(endClosure.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        closureBuilder.build(postExeNode.getBodyNode(), endClosure);
        closureBuilder.addInstr(endClosure, new ReturnInstr(new Nil()));
        this.addInstr(s2, new RecordEndBlockInstr(topLevel, new WrappedIRClosure(s2.getSelf(), endClosure)));
        return this.manager.getNil();
    }

    public Operand buildPreExe(PreExeNode preExeNode, IRScope s2) {
        IRFor beginClosure = new IRFor(this.manager, s2, preExeNode.getPosition().getLine(), s2.getTopLevelScope().getStaticScope(), Signature.from(preExeNode), preExeNode.getArgumentType(), "_BEGIN_");
        IRBuilder closureBuilder = IRBuilder.newIRBuilder(this.manager);
        closureBuilder.addInstr(beginClosure, new CopyInstr(beginClosure.getCurrentScopeVariable(), CurrentScope.CURRENT_SCOPE[0]));
        closureBuilder.addInstr(beginClosure, new CopyInstr(beginClosure.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        closureBuilder.build(preExeNode.getBodyNode(), beginClosure);
        closureBuilder.addInstr(beginClosure, new ReturnInstr(new Nil()));
        s2.getTopLevelScope().recordBeginBlock(beginClosure);
        return this.manager.getNil();
    }

    public Operand buildRational(RationalNode rationalNode) {
        return new Rational(rationalNode.getNumerator(), rationalNode.getDenominator());
    }

    public Operand buildRedo(IRScope s2) {
        IRLoop currLoop = this.getCurrentLoop();
        if (currLoop != null) {
            this.addInstr(s2, new JumpInstr(currLoop.iterStartLabel));
        } else if (s2 instanceof IRClosure) {
            this.addInstr(s2, new ThreadPollInstr(true));
            this.addInstr(s2, new JumpInstr(((IRClosure)s2).startLabel));
        } else {
            this.addInstr(s2, new ThrowExceptionInstr(IRException.REDO_LocalJumpError));
        }
        return this.manager.getNil();
    }

    public Operand buildRegexp(RegexpNode reNode, IRScope s2) {
        return this.copyAndReturnValue(s2, new Regexp(new StringLiteral(reNode.getValue()), reNode.getOptions()));
    }

    public Operand buildRescue(RescueNode node, IRScope s2) {
        return this.buildRescueInternal(node, s2, null);
    }

    private Operand buildRescueInternal(RescueNode rescueNode, IRScope s2, EnsureBlockInfo ensure) {
        Label elseLabel;
        Label rBeginLabel = ensure == null ? s2.getNewLabel() : ensure.regionStart;
        Label rEndLabel = ensure == null ? s2.getNewLabel() : ensure.end;
        Label rescueLabel = s2.getNewLabel();
        TemporaryLocalVariable savedGlobalException = s2.createTemporaryVariable();
        this.addInstr(s2, new GetGlobalVariableInstr((Variable)savedGlobalException, "$!"));
        if (ensure != null) {
            ensure.savedGlobalException = savedGlobalException;
        }
        this.addInstr(s2, new LabelInstr(rBeginLabel));
        this.addInstr(s2, new ExceptionRegionStartMarkerInstr(rescueLabel));
        this.activeRescuers.push(rescueLabel);
        Operand tmp = this.manager.getNil();
        TemporaryLocalVariable rv = s2.createTemporaryVariable();
        if (rescueNode.getBodyNode() != null) {
            tmp = this.build(rescueNode.getBodyNode(), s2);
        }
        RescueBlockInfo rbi = new RescueBlockInfo(rescueNode, rBeginLabel, savedGlobalException, this.getCurrentLoop());
        this.activeRescueBlockStack.push(rbi);
        this.addInstr(s2, new ExceptionRegionEndMarkerInstr());
        this.activeRescuers.pop();
        Label label2 = elseLabel = rescueNode.getElseNode() == null ? null : s2.getNewLabel();
        if (elseLabel != null) {
            this.addInstr(s2, new LabelInstr(elseLabel));
            tmp = this.build(rescueNode.getElseNode(), s2);
        }
        if (tmp != U_NIL) {
            this.addInstr(s2, new CopyInstr(rv, tmp));
            if (ensure != null) {
                ensure.cloneIntoHostScope(this, s2);
            }
            this.addInstr(s2, new JumpInstr(rEndLabel));
        }
        this.addInstr(s2, new LabelInstr(rescueLabel));
        Variable exc = this.addResultInstr(s2, new ReceiveRubyExceptionInstr(s2.createTemporaryVariable()));
        this.buildRescueBodyInternal(s2, rescueNode.getRescueNode(), rv, exc, rEndLabel);
        if (ensure == null) {
            this.addInstr(s2, new LabelInstr(rEndLabel));
        }
        this.activeRescueBlockStack.pop();
        return rv;
    }

    private void outputExceptionCheck(IRScope s2, Operand excType, Operand excObj, Label caughtLabel) {
        Variable eqqResult = this.addResultInstr(s2, new RescueEQQInstr(s2.createTemporaryVariable(), excType, excObj));
        this.addInstr(s2, BEQInstr.create(eqqResult, this.manager.getTrue(), caughtLabel));
    }

    private void buildRescueBodyInternal(IRScope s2, RescueBodyNode rescueBodyNode, Variable rv, Variable exc, Label endLabel) {
        Node exceptionList = rescueBodyNode.getExceptionNodes();
        Label uncaughtLabel = s2.getNewLabel();
        Label caughtLabel = s2.getNewLabel();
        if (exceptionList != null) {
            if (exceptionList instanceof ListNode) {
                ArrayList<Operand> excTypes = new ArrayList<Operand>();
                for (Node excType : exceptionList.childNodes()) {
                    excTypes.add(this.build(excType, s2));
                }
                this.outputExceptionCheck(s2, new Array(excTypes), exc, caughtLabel);
            } else if (exceptionList instanceof SplatNode) {
                this.outputExceptionCheck(s2, this.build(((SplatNode)exceptionList).getValue(), s2), exc, caughtLabel);
            } else {
                this.outputExceptionCheck(s2, this.build(exceptionList, s2), exc, caughtLabel);
            }
        } else {
            Variable v = this.addResultInstr(s2, new InheritanceSearchConstInstr(s2.createTemporaryVariable(), new ObjectClass(), "StandardError", false));
            this.outputExceptionCheck(s2, v, exc, caughtLabel);
        }
        this.addInstr(s2, new LabelInstr(uncaughtLabel));
        if (rescueBodyNode.getOptRescueNode() != null) {
            this.buildRescueBodyInternal(s2, rescueBodyNode.getOptRescueNode(), rv, exc, endLabel);
        } else {
            this.addInstr(s2, new ThrowExceptionInstr(exc));
        }
        this.addInstr(s2, new LabelInstr(caughtLabel));
        Node realBody = this.skipOverNewlines(s2, rescueBodyNode.getBodyNode());
        Operand x = this.build(realBody, s2);
        if (x != U_NIL) {
            RescueBlockInfo rbi = this.activeRescueBlockStack.peek();
            this.addInstr(s2, new PutGlobalVarInstr("$!", rbi.savedExceptionVariable));
            this.addInstr(s2, new CopyInstr(rv, x));
            if (!this.activeEnsureBlockStack.empty() && rbi.rescueNode == this.activeEnsureBlockStack.peek().matchingRescueNode) {
                this.activeEnsureBlockStack.peek().cloneIntoHostScope(this, s2);
            }
            this.addInstr(s2, new JumpInstr(endLabel));
        }
    }

    public Operand buildRetry(IRScope s2) {
        if (this.activeRescueBlockStack.empty()) {
            this.addInstr(s2, new ThrowExceptionInstr(IRException.RETRY_LocalJumpError));
        } else {
            this.addInstr(s2, new ThreadPollInstr(true));
            RescueBlockInfo rbi = this.activeRescueBlockStack.peek();
            this.addInstr(s2, new PutGlobalVarInstr("$!", rbi.savedExceptionVariable));
            this.addInstr(s2, new JumpInstr(rbi.entryLabel));
            s2.setHasLoopsFlag();
        }
        return this.manager.getNil();
    }

    private Operand processEnsureRescueBlocks(IRScope s2, Operand retVal) {
        if (!this.activeEnsureBlockStack.empty()) {
            retVal = this.addResultInstr(s2, new CopyInstr(s2.createTemporaryVariable(), retVal));
            this.emitEnsureBlocks(s2, null);
        } else if (!this.activeRescueBlockStack.empty()) {
            RescueBlockInfo rbi = this.activeRescueBlockStack.peek();
            this.addInstr(s2, new PutGlobalVarInstr("$!", rbi.savedExceptionVariable));
        }
        return retVal;
    }

    public Operand buildReturn(ReturnNode returnNode, IRScope s2) {
        Operand retVal;
        Operand operand = retVal = returnNode.getValueNode() == null ? this.manager.getNil() : this.build(returnNode.getValueNode(), s2);
        if (s2 instanceof IRClosure) {
            IRMethod m = s2.getNearestMethod();
            this.addInstr(s2, new RuntimeHelperCall(null, RuntimeHelperCall.Methods.CHECK_FOR_LJE, new Operand[]{m == null ? this.manager.getTrue() : this.manager.getFalse()}));
            retVal = this.processEnsureRescueBlocks(s2, retVal);
            this.addInstr(s2, new NonlocalReturnInstr(retVal, m == null ? "--none--" : m.getName()));
        } else if (s2.isModuleBody()) {
            IRMethod sm = s2.getNearestMethod();
            if (sm == null) {
                this.addInstr(s2, new ThrowExceptionInstr(IRException.RETURN_LocalJumpError));
            }
            retVal = this.processEnsureRescueBlocks(s2, retVal);
            if (sm != null) {
                this.addInstr(s2, new NonlocalReturnInstr(retVal, sm.getName()));
            }
        } else {
            retVal = this.processEnsureRescueBlocks(s2, retVal);
            this.addInstr(s2, new ReturnInstr(retVal));
        }
        return U_NIL;
    }

    public IREvalScript buildEvalRoot(StaticScope staticScope, IRScope containingScope, String file2, int lineNumber, RootNode rootNode, EvalType evalType) {
        IREvalScript script = evalType == EvalType.BINDING_EVAL ? new IRBindingEvalScript(this.manager, containingScope, file2, lineNumber, staticScope, evalType) : new IREvalScript(this.manager, containingScope, file2, lineNumber, staticScope, evalType);
        staticScope.setIRScope(script);
        this.addInstr(script, new LineNumberInstr(lineNumber));
        this.prepareImplicitState(script);
        this.addInstr(script, new CopyInstr(script.getCurrentScopeVariable(), CurrentScope.CURRENT_SCOPE[0]));
        this.addInstr(script, new CopyInstr(script.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        Nil rval = rootNode.getBodyNode() == null ? this.manager.getNil() : this.build(rootNode.getBodyNode(), script);
        this.addInstr(script, new ReturnInstr(rval));
        return script;
    }

    public IRScriptBody buildRoot(RootNode rootNode) {
        String file2 = rootNode.getPosition().getFile();
        StaticScope staticScope = rootNode.getStaticScope();
        IRScriptBody script = new IRScriptBody(this.manager, file2, staticScope);
        this.prepareImplicitState(script);
        this.addInstr(script, new CopyInstr(script.getCurrentScopeVariable(), CurrentScope.CURRENT_SCOPE[0]));
        this.addInstr(script, new CopyInstr(script.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        this.addInstr(script, new ReturnInstr(this.build(rootNode.getBodyNode(), script)));
        return script;
    }

    public Operand buildSelf(IRScope s2) {
        return s2.getSelf();
    }

    public Operand buildSplat(SplatNode splatNode, IRScope s2) {
        TemporaryLocalVariable res = s2.createTemporaryVariable();
        this.addInstr(s2, new BuildSplatInstr(res, this.build(splatNode.getValue(), s2)));
        return res;
    }

    public Operand buildStr(StrNode strNode, IRScope s2) {
        return this.copyAndReturnValue(s2, new StringLiteral(strNode.getValue(), strNode.getCodeRange()));
    }

    private Operand buildSuperInstr(IRScope s2, Operand block, Operand[] args2) {
        CallInstr superInstr;
        TemporaryLocalVariable ret = s2.createTemporaryVariable();
        if (s2 instanceof IRMethod && s2.getLexicalParent() instanceof IRClassBody) {
            IRMethod m = (IRMethod)s2;
            superInstr = m.isInstanceMethod ? new InstanceSuperInstr(ret, s2.getCurrentModuleVariable(), s2.getName(), args2, block) : new ClassSuperInstr(ret, s2.getCurrentModuleVariable(), s2.getName(), args2, block);
        } else {
            superInstr = new UnresolvedSuperInstr(ret, s2.getSelf(), args2, block);
        }
        this.receiveBreakException(s2, block, superInstr);
        return ret;
    }

    public Operand buildSuper(SuperNode superNode, IRScope s2) {
        if (s2.isModuleBody()) {
            return this.buildSuperInScriptBody(s2);
        }
        Operand[] args2 = this.setupCallArgs(superNode.getArgsNode(), s2);
        Operand block = this.setupCallClosure(superNode.getIterNode(), s2);
        if (block == null) {
            block = s2.getYieldClosureVariable();
        }
        return this.buildSuperInstr(s2, block, args2);
    }

    private Operand buildSuperInScriptBody(IRScope s2) {
        return this.addResultInstr(s2, new UnresolvedSuperInstr(s2.createTemporaryVariable(), s2.getSelf(), NO_ARGS, null));
    }

    public Operand buildSValue(SValueNode node, IRScope s2) {
        return this.copyAndReturnValue(s2, new SValue(this.build(node.getValue(), s2)));
    }

    public Operand buildSymbol(SymbolNode node) {
        return new Symbol(node.getName(), node.getEncoding());
    }

    public Operand buildTrue() {
        return this.manager.getTrue();
    }

    public Operand buildUndef(Node node, IRScope s2) {
        Operand methName = this.build(((UndefNode)node).getName(), s2);
        return this.addResultInstr(s2, new UndefMethodInstr(s2.createTemporaryVariable(), methName));
    }

    private Operand buildConditionalLoop(IRScope s2, Node conditionNode, Node bodyNode, boolean isWhile, boolean isLoopHeadCondition) {
        Operand cv;
        if (isLoopHeadCondition && (isWhile && conditionNode.getNodeType().alwaysFalse() || !isWhile && conditionNode.getNodeType().alwaysTrue())) {
            this.build(conditionNode, s2);
            return this.manager.getNil();
        }
        IRLoop loop2 = new IRLoop(s2, this.getCurrentLoop());
        Variable loopResult = loop2.loopResult;
        Label setupResultLabel = s2.getNewLabel();
        this.loopStack.push(loop2);
        this.addInstr(s2, new LabelInstr(loop2.loopStartLabel));
        if (isLoopHeadCondition) {
            cv = this.build(conditionNode, s2);
            this.addInstr(s2, BEQInstr.create(cv, isWhile ? this.manager.getFalse() : this.manager.getTrue(), setupResultLabel));
        }
        this.addInstr(s2, new LabelInstr(loop2.iterStartLabel));
        this.addInstr(s2, new ThreadPollInstr(true));
        if (bodyNode != null) {
            this.build(bodyNode, s2);
        }
        this.addInstr(s2, new LabelInstr(loop2.iterEndLabel));
        if (isLoopHeadCondition) {
            this.addInstr(s2, new JumpInstr(loop2.loopStartLabel));
        } else {
            cv = this.build(conditionNode, s2);
            this.addInstr(s2, BEQInstr.create(cv, isWhile ? this.manager.getTrue() : this.manager.getFalse(), loop2.iterStartLabel));
        }
        this.addInstr(s2, new LabelInstr(setupResultLabel));
        this.addInstr(s2, new CopyInstr(loopResult, this.manager.getNil()));
        this.addInstr(s2, new LabelInstr(loop2.loopEndLabel));
        this.loopStack.pop();
        return loopResult;
    }

    public Operand buildUntil(UntilNode untilNode, IRScope s2) {
        return this.buildConditionalLoop(s2, untilNode.getConditionNode(), untilNode.getBodyNode(), false, untilNode.evaluateAtStart());
    }

    public Operand buildVAlias(VAliasNode valiasNode, IRScope s2) {
        this.addInstr(s2, new GVarAliasInstr(new StringLiteral(valiasNode.getNewName()), new StringLiteral(valiasNode.getOldName())));
        return this.manager.getNil();
    }

    public Operand buildVCall(VCallNode node, IRScope s2) {
        return this.addResultInstr(s2, CallInstr.create(CallType.VARIABLE, s2.createTemporaryVariable(), node.getName(), s2.getSelf(), NO_ARGS, null));
    }

    public Operand buildWhile(WhileNode whileNode, IRScope s2) {
        return this.buildConditionalLoop(s2, whileNode.getConditionNode(), whileNode.getBodyNode(), true, whileNode.evaluateAtStart());
    }

    public Operand buildXStr(XStrNode node, IRScope s2) {
        return this.addResultInstr(s2, new BacktickInstr(s2.createTemporaryVariable(), new Operand[]{new StringLiteral(node.getValue())}));
    }

    public Operand buildYield(YieldNode node, IRScope s2) {
        boolean unwrap = true;
        Node argNode = node.getArgsNode();
        if (argNode != null && argNode instanceof ArrayNode && ((ArrayNode)argNode).size() == 1) {
            argNode = ((ArrayNode)argNode).getLast();
            unwrap = false;
        }
        TemporaryLocalVariable ret = s2.createTemporaryVariable();
        this.addInstr(s2, new YieldInstr(ret, s2.getYieldClosureVariable(), this.build(argNode, s2), unwrap));
        return ret;
    }

    public Operand buildZArray(IRScope s2) {
        return this.copyAndReturnValue(s2, new Array());
    }

    private Operand buildZSuperIfNest(final IRScope s2, final Operand block) {
        CodeBlock zsuperBuilder = new CodeBlock(){

            @Override
            public Operand run() {
                Operand[] args2;
                TemporaryLocalVariable scopeDepth = s2.createTemporaryVariable();
                IRBuilder.this.addInstr(s2, new ArgScopeDepthInstr(scopeDepth));
                Label allDoneLabel = s2.getNewLabel();
                IRScope superScope = s2;
                int depthFromSuper = 0;
                Label next2 = null;
                TemporaryLocalVariable zsuperResult = s2.createTemporaryVariable();
                while (superScope instanceof IRClosure) {
                    if (next2 != null) {
                        IRBuilder.this.addInstr(s2, new LabelInstr(next2));
                    }
                    next2 = s2.getNewLabel();
                    IRBuilder.this.addInstr(s2, BNEInstr.create(new Fixnum(depthFromSuper), scopeDepth, next2));
                    args2 = IRBuilder.this.adjustVariableDepth(((IRClosure)superScope).getBlockArgs(), depthFromSuper);
                    IRBuilder.this.addInstr(s2, new ZSuperInstr(zsuperResult, s2.getSelf(), args2, block));
                    IRBuilder.this.addInstr(s2, new JumpInstr(allDoneLabel));
                    superScope = superScope.getLexicalParent();
                    ++depthFromSuper;
                }
                IRBuilder.this.addInstr(s2, new LabelInstr(next2));
                if (superScope instanceof IRMethod) {
                    args2 = IRBuilder.this.adjustVariableDepth(((IRMethod)superScope).getCallArgs(), depthFromSuper);
                    IRBuilder.this.addInstr(s2, new ZSuperInstr(zsuperResult, s2.getSelf(), args2, block));
                }
                IRBuilder.this.addInstr(s2, new LabelInstr(allDoneLabel));
                return zsuperResult;
            }
        };
        return this.receiveBreakException(s2, block, zsuperBuilder);
    }

    public Operand buildZSuper(ZSuperNode zsuperNode, IRScope s2) {
        if (s2.isModuleBody()) {
            return this.buildSuperInScriptBody(s2);
        }
        Operand block = this.setupCallClosure(zsuperNode.getIterNode(), s2);
        if (block == null) {
            block = s2.getYieldClosureVariable();
        }
        if (s2 instanceof IRMethod) {
            return this.buildSuperInstr(s2, block, ((IRMethod)s2).getCallArgs());
        }
        return this.buildZSuperIfNest(s2, block);
    }

    private Operand[] adjustVariableDepth(Operand[] args2, int depthFromSuper) {
        Operand[] newArgs = new Operand[args2.length];
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newArgs[i2] = args2[i2] instanceof Hash ? ((Hash)args2[i2]).cloneForLVarDepth(depthFromSuper) : ((DepthCloneable)((Object)args2[i2])).cloneForDepth(depthFromSuper);
        }
        return newArgs;
    }

    private Operand buildModuleOrClassBody(IRScope parent, Variable moduleVar, IRModuleBody body, Node bodyNode, int linenumber, Operand block) {
        Variable processBodyResult = this.addResultInstr(parent, new ProcessModuleBodyInstr(parent.createTemporaryVariable(), (Operand)moduleVar, block));
        IRBuilder bodyBuilder = IRBuilder.newIRBuilder(this.manager);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            bodyBuilder.addInstr(body, new TraceInstr(RubyEvent.CLASS, null, body.getFileName(), linenumber));
        }
        bodyBuilder.prepareImplicitState(body);
        bodyBuilder.addInstr(body, new CopyInstr(body.getCurrentScopeVariable(), CurrentScope.CURRENT_SCOPE[0]));
        bodyBuilder.addInstr(body, new CopyInstr(body.getCurrentModuleVariable(), ScopeModule.SCOPE_MODULE[0]));
        Operand bodyReturnValue = bodyBuilder.build(bodyNode, body);
        if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
            bodyBuilder.addInstr(body, new TraceInstr(RubyEvent.END, null, body.getFileName(), -1));
        }
        bodyBuilder.addInstr(body, new ReturnInstr(bodyReturnValue));
        return processBodyResult;
    }

    private String methodNameFor(IRScope s2) {
        IRMethod method = s2.getNearestMethod();
        return method == null ? null : method.getName();
    }

    static interface CodeBlock {
        public Operand run();
    }

    private static class EnsureBlockInfo {
        Label regionStart;
        Label start;
        Label end;
        Label dummyRescueBlockLabel;
        Variable savedGlobalException;
        Label bodyRescuer;
        IRLoop innermostLoop;
        RescueNode matchingRescueNode;
        List<Instr> instrs;

        public EnsureBlockInfo(IRScope s2, RescueNode n, IRLoop l, Label bodyRescuer) {
            this.regionStart = s2.getNewLabel();
            this.start = s2.getNewLabel();
            this.end = s2.getNewLabel();
            this.dummyRescueBlockLabel = s2.getNewLabel();
            this.instrs = new ArrayList<Instr>();
            this.savedGlobalException = null;
            this.innermostLoop = l;
            this.matchingRescueNode = n;
            this.bodyRescuer = bodyRescuer;
        }

        public void addInstr(Instr i2) {
            this.instrs.add(i2);
        }

        public void addInstrAtBeginning(Instr i2) {
            this.instrs.add(0, i2);
        }

        public void emitBody(IRBuilder b2, IRScope s2) {
            b2.addInstr(s2, new LabelInstr(this.start));
            for (Instr i2 : this.instrs) {
                b2.addInstr(s2, i2);
            }
        }

        public void cloneIntoHostScope(IRBuilder b2, IRScope s2) {
            SimpleCloneInfo ii = new SimpleCloneInfo(s2, true);
            ii.renameLabel(this.start);
            for (Instr i2 : this.instrs) {
                if (!(i2 instanceof LabelInstr)) continue;
                ii.renameLabel(((LabelInstr)i2).getLabel());
            }
            b2.addInstr(s2, new LabelInstr(ii.getRenamedLabel(this.start)));
            b2.addInstr(s2, new ExceptionRegionStartMarkerInstr(this.bodyRescuer));
            for (Instr i2 : this.instrs) {
                CallBase call2;
                Operand block;
                Instr clonedInstr = i2.clone(ii);
                if (clonedInstr instanceof CallBase && (block = (call2 = (CallBase)clonedInstr).getClosureArg(null)) instanceof WrappedIRClosure) {
                    s2.addClosure(((WrappedIRClosure)block).getClosure());
                }
                b2.addInstr(s2, clonedInstr);
            }
            b2.addInstr(s2, new ExceptionRegionEndMarkerInstr());
        }
    }

    private static class RescueBlockInfo {
        RescueNode rescueNode;
        Label entryLabel;
        Variable savedExceptionVariable;
        IRLoop innermostLoop;

        public RescueBlockInfo(RescueNode n, Label l, Variable v, IRLoop loop2) {
            this.rescueNode = n;
            this.entryLabel = l;
            this.savedExceptionVariable = v;
            this.innermostLoop = loop2;
        }

        public void restoreException(IRBuilder b2, IRScope s2, IRLoop currLoop) {
            if (currLoop == this.innermostLoop) {
                b2.addInstr(s2, new PutGlobalVarInstr("$!", this.savedExceptionVariable));
            }
        }
    }

    private static class IRLoop {
        public final IRScope container;
        public final IRLoop parentLoop;
        public final Label loopStartLabel;
        public final Label loopEndLabel;
        public final Label iterStartLabel;
        public final Label iterEndLabel;
        public final Variable loopResult;

        public IRLoop(IRScope s2, IRLoop outerLoop) {
            this.container = s2;
            this.parentLoop = outerLoop;
            this.loopStartLabel = s2.getNewLabel("_LOOP_BEGIN");
            this.loopEndLabel = s2.getNewLabel("_LOOP_END");
            this.iterStartLabel = s2.getNewLabel("_ITER_BEGIN");
            this.iterEndLabel = s2.getNewLabel("_ITER_END");
            this.loopResult = s2.createTemporaryVariable();
            s2.setHasLoopsFlag();
        }
    }
}

