/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import com.headius.invokebinder.Signature;
import com.headius.invokebinder.SmartBinder;
import com.headius.invokebinder.SmartHandle;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.List;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.anno.JavaMethodDescriptor;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.HandleMethod;
import org.jruby.internal.runtime.methods.InvocationMethodFactory;
import org.jruby.internal.runtime.methods.MethodNodes;
import org.jruby.lexer.yacc.ISourcePosition;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.InvocationLinker;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InvokeDynamicMethodFactory
extends InvocationMethodFactory {
    private static final Logger LOG = LoggerFactory.getLogger("InvokeDynamicMethodFactory");
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();
    public static final Signature VARIABLE_ARITY_SIGNATURE = Signature.returning(IRubyObject.class).appendArg("context", ThreadContext.class).appendArg("self", IRubyObject.class).appendArg("args", IRubyObject[].class).appendArg("block", Block.class);
    public static final Signature ARITY_CHECK_FOLD = Signature.returning(Void.TYPE).appendArg("context", ThreadContext.class).appendArg("args", IRubyObject[].class);
    public static final Signature ARITY_CHECK_SIGNATURE = Signature.returning(Integer.TYPE).appendArg("context", ThreadContext.class).appendArg("args", IRubyObject[].class).appendArg("min", Integer.TYPE).appendArg("max", Integer.TYPE);
    public static final Signature[] SPECIFIC_ARITY_SIGNATURES;
    private static final SmartBinder[] SPREAD_BINDERS;
    private static final SmartHandle HANDLE_GETTER;

    public InvokeDynamicMethodFactory(ClassLoader classLoader) {
        super(classLoader);
    }

    @Override
    public DynamicMethod getCompiledMethodLazily(RubyModule implementationClass, String rubyName, String javaName, Arity arity2, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig, ISourcePosition position, String parameterDesc, MethodNodes methodNodes) {
        return this.getCompiledMethod(implementationClass, rubyName, javaName, arity2, visibility, scope, scriptObject, callConfig, position, parameterDesc, methodNodes);
    }

    @Override
    public DynamicMethod getCompiledMethod(RubyModule implementationClass, String rubyName, String javaName, Arity arity2, Visibility visibility, StaticScope scope, Object scriptObject, CallConfiguration callConfig, ISourcePosition position, String parameterDesc, MethodNodes methodNodes) {
        Class<?> scriptClass = scriptObject.getClass();
        try {
            SmartHandle variableCall;
            SmartHandle directCall;
            MethodHandle[] targets = new MethodHandle[5];
            int specificArity = -1;
            if (scope.getRestArg() >= 0 || scope.getOptionalArgs() > 0 || scope.getRequiredArgs() > 3) {
                directCall = SmartBinder.from((Signature)VARIABLE_ARITY_SIGNATURE.prependArg("script", scriptClass)).invokeStaticQuiet(LOOKUP, scriptClass, javaName).bindTo(scriptObject);
            } else {
                specificArity = scope.getRequiredArgs();
                directCall = SmartBinder.from((Signature)SPECIFIC_ARITY_SIGNATURES[specificArity].prependArg("script", scriptClass)).invokeStaticQuiet(LOOKUP, scriptClass, javaName).bindTo(scriptObject);
            }
            if (!callConfig.isNoop()) {
                directCall = SmartHandle.from((Signature)directCall.signature(), (MethodHandle)InvocationLinker.wrapWithFraming(directCall.signature(), callConfig, implementationClass, rubyName, directCall.handle(), scope));
            }
            if (specificArity >= 0) {
                SmartHandle arityCheck = SmartBinder.from((Signature)ARITY_CHECK_FOLD).append(new String[]{"min", "max"}, new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{specificArity, specificArity}).cast(ARITY_CHECK_SIGNATURE).invokeStaticQuiet(LOOKUP, Arity.class, "checkArgumentCount");
                variableCall = SmartBinder.from((Signature)VARIABLE_ARITY_SIGNATURE).foldVoid(arityCheck).permute(new String[]{"script", "context", "self", "block", "args"}).spread("arg", specificArity).permute(new String[]{"script", "context", "self", "arg*", "block"}).invoke(directCall);
            } else {
                variableCall = directCall;
            }
            if (RubyInstanceConfig.FULL_TRACE_ENABLED) {
                // empty if block
            }
            if (specificArity >= 0) {
                targets[specificArity] = directCall.handle();
                targets[4] = variableCall.handle();
            } else {
                targets[4] = directCall.handle();
            }
            return new HandleMethod(implementationClass, visibility, callConfig, targets, parameterDesc);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] getCompiledMethodOffline(String rubyName, String javaName, String className, String invokerPath, Arity arity2, StaticScope scope, CallConfiguration callConfig, String filename2, int line, MethodNodes methodNodes) {
        throw new RuntimeException("no offline support for invokedynamic handles");
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, List<JavaMethodDescriptor> descs) {
        JavaMethodDescriptor desc1 = descs.get(0);
        if (desc1.anno.frame()) {
            return super.getAnnotatedMethod(implementationClass, descs);
        }
        if (!Modifier.isPublic(desc1.getDeclaringClass().getModifiers())) {
            LOG.warn("warning: binding non-public class {}; reflected handles won't work", desc1.declaringClassName);
        }
        InvocationMethodFactory.DescriptorInfo info = new InvocationMethodFactory.DescriptorInfo(descs);
        MethodHandle[] targets = this.buildAnnotatedMethodHandles(implementationClass.getRuntime(), descs, implementationClass);
        return new HandleMethod(implementationClass, desc1.anno.visibility(), CallConfiguration.getCallConfig(info.isFrame(), info.isScope()), targets, null);
    }

    private MethodHandle[] buildAnnotatedMethodHandles(Ruby runtime, List<JavaMethodDescriptor> descs, RubyModule implementationClass) {
        MethodHandle[] targets = new MethodHandle[5];
        for (JavaMethodDescriptor desc : descs) {
            int specificArity = -1;
            if (desc.optional == 0 && !desc.rest) {
                if (desc.required == 0) {
                    specificArity = desc.actualRequired <= 3 ? desc.actualRequired : -1;
                } else if (desc.required >= 0 && desc.required <= 3) {
                    specificArity = desc.required;
                }
            }
            String javaMethodName = desc.name;
            String rubyName = desc.anno.name() != null && desc.anno.name().length > 0 ? desc.anno.name()[0] : javaMethodName;
            Signature baseSignature = specificArity >= 0 ? SPECIFIC_ARITY_SIGNATURES[specificArity] : VARIABLE_ARITY_SIGNATURE;
            SmartBinder targetBinder = SmartBinder.from((Signature)baseSignature);
            MethodHandle returnFilter = null;
            boolean castReturn = false;
            if (desc.returnClass != IRubyObject.class) {
                if (desc.returnClass == Void.TYPE) {
                    returnFilter = MethodHandles.constant(IRubyObject.class, runtime.getNil());
                } else {
                    castReturn = true;
                }
            }
            if (desc.isStatic) {
                if (desc.hasContext) {
                    if (!desc.hasBlock) {
                        targetBinder = targetBinder.exclude(new String[]{"block"});
                    }
                } else {
                    targetBinder = desc.hasBlock ? targetBinder.exclude(new String[]{"context"}) : targetBinder.exclude(new String[]{"context", "block"});
                }
                if (returnFilter != null) {
                    targetBinder = targetBinder.filterReturn(returnFilter);
                } else if (castReturn) {
                    targetBinder = targetBinder.castReturn(desc.returnClass);
                }
            } else {
                targetBinder = desc.hasContext ? (desc.hasBlock ? targetBinder.permute(new String[]{"self", "context", "arg*", "block"}) : targetBinder.permute(new String[]{"self", "context", "arg*"})) : (desc.hasBlock ? targetBinder.permute(new String[]{"self", "arg*", "block"}) : targetBinder.permute(new String[]{"self", "arg*"}));
                if (returnFilter != null) {
                    targetBinder = targetBinder.filterReturn(returnFilter);
                } else if (castReturn) {
                    targetBinder = targetBinder.castReturn(desc.returnClass);
                }
                targetBinder = targetBinder.castArg("self", desc.getDeclaringClass());
            }
            SmartHandle target = desc.isStatic ? targetBinder.invokeStaticQuiet(LOOKUP, desc.getDeclaringClass(), javaMethodName) : targetBinder.invokeVirtualQuiet(LOOKUP, javaMethodName);
            CallConfiguration callConfig = CallConfiguration.getCallConfigByAnno(desc.anno);
            if (!callConfig.isNoop()) {
                target = SmartHandle.from((Signature)target.signature(), (MethodHandle)InvocationLinker.wrapWithFraming(baseSignature, callConfig, implementationClass, rubyName, target.handle(), null));
            }
            if (specificArity >= 0) {
                targets[specificArity] = target.handle();
                continue;
            }
            targets[4] = target.handle();
        }
        if (targets[4] == null) {
            Signature VARIABLE_ARITY_SIGNATURE = Signature.returning(IRubyObject.class).appendArg("context", ThreadContext.class).appendArg("self", IRubyObject.class).appendArg("args", IRubyObject[].class).appendArg("block", Block.class);
            MethodHandle[] varargsTargets = new MethodHandle[4];
            for (int i2 = 0; i2 < 4; ++i2) {
                if (targets[i2] == null) continue;
                varargsTargets[i2] = i2 == 0 ? MethodHandles.dropArguments(targets[i2], 2, new Class[]{IRubyObject[].class}) : SmartBinder.from((Signature)VARIABLE_ARITY_SIGNATURE).permute(new String[]{"context", "self", "block", "args"}).spread("arg", i2).permute(new String[]{"context", "self", "arg*", "block"}).invoke(targets[i2]).handle();
            }
            SmartHandle HANDLE_GETTER = SmartBinder.from((Signature)Signature.returning(MethodHandle.class).appendArg("targets", MethodHandle[].class).appendArg("arity", Integer.TYPE)).arrayGet();
            SmartHandle handleLookup = SmartBinder.from((Signature)Signature.returning(MethodHandle.class).appendArg("args", IRubyObject[].class)).filterReturn(HANDLE_GETTER.bindTo((Object)varargsTargets)).cast(Integer.TYPE, new Class[]{Object.class}).invokeStaticQuiet(LOOKUP, Array.class, "getLength");
            SmartHandle variableCall = SmartBinder.from((Signature)VARIABLE_ARITY_SIGNATURE).fold("handle", handleLookup).invoker();
            targets[4] = variableCall.handle();
        }
        return targets;
    }

    @Override
    public DynamicMethod getAnnotatedMethod(RubyModule implementationClass, JavaMethodDescriptor desc) {
        return this.getAnnotatedMethod(implementationClass, Arrays.asList(desc));
    }

    static {
        Signature[] specifics = new Signature[4];
        Signature specific = Signature.returning(IRubyObject.class).appendArg("context", ThreadContext.class).appendArg("self", IRubyObject.class);
        specifics[0] = specific.appendArg("block", Block.class);
        for (int i2 = 0; i2 < 3; ++i2) {
            specific = specific.appendArg("arg" + i2, IRubyObject.class);
            specifics[i2 + 1] = specific.appendArg("block", Block.class);
        }
        SPECIFIC_ARITY_SIGNATURES = specifics;
        SPREAD_BINDERS = new SmartBinder[4];
        for (int i3 = 0; i3 < 4; ++i3) {
            InvokeDynamicMethodFactory.SPREAD_BINDERS[i3] = SmartBinder.from((Signature)VARIABLE_ARITY_SIGNATURE).permute(new String[]{"context", "self", "block", "args"}).spread("arg", i3).permute(new String[]{"context", "self", "arg*", "block"});
        }
        HANDLE_GETTER = SmartBinder.from((Signature)Signature.returning(MethodHandle.class).appendArg("targets", MethodHandle[].class).appendArg("arity", Integer.TYPE)).arrayGet();
    }
}

