/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.internal.runtime.methods;

import java.util.ArrayList;
import java.util.List;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubyModule;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.CompiledIRMethod;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.Interpreter;
import org.jruby.ir.interpreter.InterpreterContext;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.PositionAware;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InterpretedIRMethod
extends DynamicMethod
implements IRMethodArgs,
PositionAware {
    private static final Logger LOG = LoggerFactory.getLogger("InterpretedIRMethod");
    private Arity arity;
    private boolean displayedCFG = false;
    protected final IRScope method;
    private boolean isSynthetic;
    protected DynamicMethodBox box = new DynamicMethodBox();

    public InterpretedIRMethod(IRScope method, Visibility visibility, RubyModule implementationClass) {
        super(implementationClass, visibility, CallConfiguration.FrameNoneScopeNone, method.getName());
        this.method = method;
        this.method.getStaticScope().determineModule();
        this.arity = this.calculateArity();
        if (!(method instanceof IRMethod) || !implementationClass.getRuntime().getInstanceConfig().getCompileMode().shouldJIT()) {
            this.box.callCount = -1;
        }
        this.isSynthetic = method instanceof IRModuleBody;
    }

    public boolean isSynthetic() {
        return this.isSynthetic;
    }

    public IRScope getIRMethod() {
        return this.method;
    }

    public DynamicMethod getActualMethod() {
        return this.box.actualMethod;
    }

    public void setCallCount(int callCount) {
        this.box.callCount = callCount;
    }

    public StaticScope getStaticScope() {
        return this.method.getStaticScope();
    }

    @Override
    public List<String[]> getParameterList() {
        this.method.prepareForInterpretation();
        return this.method instanceof IRMethod ? ((IRMethod)this.method).getArgDesc() : new ArrayList();
    }

    private Arity calculateArity() {
        StaticScope s2 = this.method.getStaticScope();
        if (s2.getOptionalArgs() > 0 || s2.getRestArg() >= 0) {
            return Arity.required(s2.getRequiredArgs());
        }
        return Arity.createArity(s2.getRequiredArgs());
    }

    @Override
    public Arity getArity() {
        return this.arity;
    }

    public InterpreterContext ensureInstrsReady() {
        InterpreterContext ic = this.method.getInterpreterContext();
        return ic == null ? this.method.prepareForInterpretation() : ic;
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((jittedMethod = box.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, args2, block);
        }
        return Interpreter.INTERPRET_METHOD(context, this, self2, name2, args2, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((jittedMethod = box.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, block);
        }
        return Interpreter.INTERPRET_METHOD(context, this, self2, name2, IRubyObject.NULL_ARRAY, block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((jittedMethod = box.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, arg0, block);
        }
        return Interpreter.INTERPRET_METHOD(context, this, self2, name2, Helpers.arrayOf(arg0), block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((jittedMethod = box.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, arg0, arg1, block);
        }
        return Interpreter.INTERPRET_METHOD(context, this, self2, name2, Helpers.arrayOf(arg0, arg1), block);
    }

    @Override
    public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        DynamicMethod jittedMethod;
        if (IRRuntimeHelpers.isDebug()) {
            this.doDebug();
        }
        DynamicMethodBox box = this.box;
        if (box.callCount >= 0) {
            this.tryJit(context, box);
        }
        if ((jittedMethod = box.actualMethod) != null) {
            return jittedMethod.call(context, self2, clazz, name2, arg0, arg1, arg2, block);
        }
        return Interpreter.INTERPRET_METHOD(context, this, self2, name2, Helpers.arrayOf(arg0, arg1, arg2), block);
    }

    protected void doDebug() {
        this.ensureInstrsReady();
        LOG.info("Executing '" + this.method.getName() + "'", new Object[0]);
        if (!this.displayedCFG) {
            CFG cfg = this.method.getCFG();
            LOG.info("Graph:\n" + cfg.toStringGraph(), new Object[0]);
            LOG.info("CFG:\n" + cfg.toStringInstrs(), new Object[0]);
            this.displayedCFG = true;
        }
    }

    public DynamicMethod getMethodForCaching() {
        DynamicMethod method = this.box.actualMethod;
        if (method instanceof CompiledIRMethod) {
            return method;
        }
        return this;
    }

    public void switchToJitted(CompiledIRMethod newMethod) {
        this.box.actualMethod = newMethod;
        this.box.actualMethod.serialNumber = this.serialNumber;
        this.box.callCount = -1;
        this.getImplementationClass().invalidateCacheDescendants();
    }

    protected void tryJit(ThreadContext context, DynamicMethodBox box) {
        MetaClass metaClass;
        RubyClass realClass;
        Ruby runtime = context.runtime;
        if (runtime.isBooting()) {
            return;
        }
        String className = this.implementationClass.isSingleton() ? ((realClass = (metaClass = (MetaClass)this.implementationClass).getRealClass()) == context.runtime.getClassClass() ? ((RubyClass)metaClass.getAttached()).getName() : realClass.getName()) : this.implementationClass.getName();
        if (box.callCount++ >= (Integer)Options.JIT_THRESHOLD.load()) {
            context.runtime.getJITCompiler().jitThresholdReached(this, context.runtime.getInstanceConfig(), context, className, this.name);
        }
    }

    public void setActualMethod(CompiledIRMethod method) {
        this.box.actualMethod = method;
    }

    protected void dupBox(InterpretedIRMethod orig) {
        this.box = orig.box;
    }

    @Override
    public DynamicMethod dup() {
        InterpretedIRMethod x = new InterpretedIRMethod(this.method, this.visibility, this.implementationClass);
        x.box = this.box;
        return x;
    }

    @Override
    public String getFile() {
        return this.method.getFileName();
    }

    @Override
    public int getLine() {
        return this.method.getLineNumber();
    }

    protected static class DynamicMethodBox {
        public DynamicMethod actualMethod;
        public int callCount = 0;

        protected DynamicMethodBox() {
        }
    }
}

