/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class WhileNode
extends Node {
    private final Node conditionNode;
    private final Node bodyNode;
    private final boolean evaluateAtStart;
    public boolean containsNonlocalFlow = false;

    public WhileNode(ISourcePosition position, Node conditionNode, Node bodyNode) {
        this(position, conditionNode, bodyNode, true);
    }

    public WhileNode(ISourcePosition position, Node conditionNode, Node bodyNode, boolean evalAtStart) {
        super(position);
        assert (conditionNode != null) : "conditionNode is not null";
        assert (bodyNode != null) : "bodyNode is not null";
        this.conditionNode = conditionNode;
        this.bodyNode = bodyNode;
        this.evaluateAtStart = evalAtStart;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.WHILENODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitWhileNode(this);
    }

    public Node getBodyNode() {
        return this.bodyNode;
    }

    public Node getConditionNode() {
        return this.conditionNode;
    }

    public boolean evaluateAtStart() {
        return this.evaluateAtStart;
    }

    @Override
    public List<Node> childNodes() {
        return Node.createList(this.conditionNode, this.bodyNode);
    }
}

