/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ast;

import java.util.List;
import org.jruby.ast.BlockAcceptingNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.visitor.NodeVisitor;
import org.jruby.lexer.yacc.ISourcePosition;

public class SuperNode
extends Node
implements BlockAcceptingNode {
    private final Node argsNode;
    private Node iterNode;

    public SuperNode(ISourcePosition position, Node argsNode) {
        this(position, argsNode, null);
    }

    public SuperNode(ISourcePosition position, Node argsNode, Node iterNode) {
        super(position);
        this.argsNode = argsNode;
        this.iterNode = iterNode;
    }

    @Override
    public NodeType getNodeType() {
        return NodeType.SUPERNODE;
    }

    @Override
    public <T> T accept(NodeVisitor<T> iVisitor) {
        return iVisitor.visitSuperNode(this);
    }

    public Node getArgsNode() {
        return this.argsNode;
    }

    @Override
    public List<Node> childNodes() {
        return this.iterNode != null ? SuperNode.createList(this.argsNode, this.iterNode) : SuperNode.createList(this.argsNode);
    }

    @Override
    public Node getIterNode() {
        return this.iterNode;
    }

    @Override
    public Node setIterNode(Node iterNode) {
        this.iterNode = iterNode;
        return this;
    }
}

