/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyEncoding;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyModule;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.LambdaNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.ast.executable.Script;
import org.jruby.ast.util.SexpMaker;
import org.jruby.compiler.ASTCompiler;
import org.jruby.compiler.ASTCompiler19;
import org.jruby.compiler.ASTInspector;
import org.jruby.compiler.BodyCompiler;
import org.jruby.compiler.CompilerCallback;
import org.jruby.compiler.JITCompilerMBean;
import org.jruby.compiler.NotCompilableException;
import org.jruby.compiler.impl.ChildScopedBodyCompiler;
import org.jruby.compiler.impl.ChildScopedBodyCompiler19;
import org.jruby.compiler.impl.SkinnyMethodAdapter;
import org.jruby.compiler.impl.StandardASMCompiler;
import org.jruby.internal.runtime.methods.CallConfiguration;
import org.jruby.internal.runtime.methods.DefaultMethod;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CompiledBlock;
import org.jruby.runtime.CompiledBlock19;
import org.jruby.runtime.CompiledBlockCallback;
import org.jruby.runtime.CompiledBlockCallback19;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.threading.DaemonThreadFactory;
import org.jruby.util.ClassCache;
import org.jruby.util.JRubyClassLoader;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.util.TraceClassVisitor;

public class JITCompiler
implements JITCompilerMBean {
    private static final Logger LOG = LoggerFactory.getLogger("JITCompiler");
    public static final boolean USE_CACHE = true;
    public static final String RUBY_JIT_PREFIX = "rubyjit";
    public static final String CLASS_METHOD_DELIMITER = "$$";
    private final JITCounts counts = new JITCounts();
    private final ExecutorService executor = new ThreadPoolExecutor(2, 2, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new DaemonThreadFactory("JRubyJIT", 1));
    private final Ruby runtime;
    private final RubyInstanceConfig config;

    public JITCompiler(Ruby runtime) {
        this.runtime = runtime;
        this.config = runtime.getInstanceConfig();
        runtime.getBeanManager().register(this);
    }

    @Override
    public long getSuccessCount() {
        return this.counts.successCount.get();
    }

    @Override
    public long getCompileCount() {
        return this.counts.compiledCount.get();
    }

    @Override
    public long getFailCount() {
        return this.counts.failCount.get();
    }

    @Override
    public long getCompileTime() {
        return this.counts.compileTime.get() / 1000L;
    }

    @Override
    public long getAbandonCount() {
        return this.counts.abandonCount.get();
    }

    @Override
    public long getCodeSize() {
        return this.counts.codeSize.get();
    }

    @Override
    public long getAverageCodeSize() {
        return this.counts.averageCodeSize.get();
    }

    @Override
    public long getAverageCompileTime() {
        return this.counts.averageCompileTime.get() / 1000L;
    }

    @Override
    public long getLargestCodeSize() {
        return this.counts.largestCodeSize.get();
    }

    public void tryJIT(DefaultMethod method2, ThreadContext context, String className, String methodName) {
        if (!this.config.getCompileMode().shouldJIT()) {
            return;
        }
        if (method2.incrementCallCount() < this.config.getJitThreshold()) {
            return;
        }
        this.jitThresholdReached(method2, this.config, context, className, methodName);
    }

    public void tearDown() {
        if (this.executor != null) {
            try {
                this.executor.shutdown();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    private void jitThresholdReached(DefaultMethod method2, RubyInstanceConfig config, ThreadContext context, String className, String methodName) {
        method2.setCallCount(-1);
        Ruby runtime = context.runtime;
        JITTask jitTask = new JITTask(className, method2, methodName);
        if (config.getJitBackground() && config.getJitThreshold() > 0 && this.executor != null) {
            try {
                this.executor.submit(jitTask);
            }
            catch (RejectedExecutionException ree) {
                jitTask.run();
            }
        } else {
            jitTask.run();
        }
    }

    public static String getHashForString(String str) {
        return JITCompiler.getHashForBytes(RubyEncoding.encodeUTF8(str));
    }

    public static String getHashForBytes(byte[] bytes2) {
        try {
            MessageDigest sha1 = MessageDigest.getInstance("SHA1");
            sha1.update(bytes2);
            byte[] digest2 = sha1.digest();
            StringBuilder builder = new StringBuilder();
            for (int i2 = 0; i2 < digest2.length; ++i2) {
                builder.append(Integer.toString((digest2[i2] & 0xFF) + 256, 16).substring(1));
            }
            return builder.toString().toUpperCase(Locale.ENGLISH);
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new RuntimeException(nsae);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveToCodeCache(Ruby ruby2, byte[] bytecode, String packageName, File cachedClassFile) {
        String codeCache = RubyInstanceConfig.JIT_CODE_CACHE;
        File codeCacheDir = new File(codeCache);
        if (!codeCacheDir.exists()) {
            ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " does not exist");
        } else if (!codeCacheDir.isDirectory()) {
            ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " is not a directory");
        } else if (!codeCacheDir.canWrite()) {
            ruby2.getWarnings().warn("jruby.jit.codeCache directory " + codeCacheDir + " is not writable");
        } else {
            boolean createdDirs;
            if (!new File(codeCache, packageName).isDirectory() && !(createdDirs = new File(codeCache, packageName).mkdirs())) {
                ruby2.getWarnings().warn("could not create JIT cache dir: " + new File(codeCache, packageName));
            }
            FileOutputStream fos = null;
            try {
                if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                    LOG.info("writing jitted code to to " + cachedClassFile, new Object[0]);
                }
                fos = new FileOutputStream(cachedClassFile);
                fos.write(bytecode);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public Block newCompiledClosure(ThreadContext context, IterNode iterNode, IRubyObject self2) {
        Binding binding2 = context.currentBinding(self2);
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(iterNode);
        boolean hasMultipleArgsHead = false;
        if (iterNode.getVarNode() instanceof MultipleAsgnNode) {
            hasMultipleArgsHead = ((MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() != null;
        }
        CompiledBlock body = new CompiledBlock(Arity.procArityOf(iterNode.getVarNode()), iterNode.getScope(), this.compileBlock(context, new StandardASMCompiler("blahfooblah" + System.currentTimeMillis(), "blahfooblah"), iterNode), hasMultipleArgsHead, BlockBody.asArgumentType(argsNodeId));
        return new Block(body, binding2);
    }

    public BlockBody newCompiledBlockBody(ThreadContext context, IterNode iterNode, Arity arity2, int argumentType) {
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(iterNode);
        boolean hasMultipleArgsHead = false;
        if (iterNode.getVarNode() instanceof MultipleAsgnNode) {
            hasMultipleArgsHead = ((MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() != null;
        }
        return new CompiledBlock(Arity.procArityOf(iterNode.getVarNode()), iterNode.getScope(), this.compileBlock(context, new StandardASMCompiler("blahfooblah" + System.currentTimeMillis(), "blahfooblah"), iterNode), hasMultipleArgsHead, BlockBody.asArgumentType(argsNodeId));
    }

    public BlockBody newCompiledBlockBody19(ThreadContext context, IterNode iterNode) {
        ArgsNode argsNode = (ArgsNode)iterNode.getVarNode();
        boolean hasMultipleArgsHead = false;
        if (iterNode.getVarNode() instanceof MultipleAsgnNode) {
            hasMultipleArgsHead = ((MultipleAsgnNode)iterNode.getVarNode()).getHeadNode() != null;
        }
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(iterNode);
        return new CompiledBlock19(((ArgsNode)iterNode.getVarNode()).getArity(), iterNode.getScope(), this.compileBlock19(context, new StandardASMCompiler("blahfooblah" + System.currentTimeMillis(), "blahfooblah"), iterNode), hasMultipleArgsHead, BlockBody.asArgumentType(argsNodeId), Helpers.encodeParameterList(argsNode).split(";"));
    }

    public CompiledBlockCallback compileBlock(ThreadContext context, StandardASMCompiler asmCompiler, final IterNode iterNode) {
        final ASTCompiler astCompiler = new ASTCompiler();
        StaticScope scope = iterNode.getScope();
        asmCompiler.startScript(scope);
        CompilerCallback closureBody = new CompilerCallback(){

            @Override
            public void call(BodyCompiler context) {
                if (iterNode.getBodyNode() != null) {
                    astCompiler.compile(iterNode.getBodyNode(), context, true);
                } else {
                    context.loadNil();
                }
            }
        };
        CompilerCallback closureArgs = new CompilerCallback(){

            @Override
            public void call(BodyCompiler context) {
                if (iterNode.getVarNode() != null) {
                    astCompiler.compileAssignment(iterNode.getVarNode(), context);
                } else {
                    context.consumeCurrentValue();
                }
                if (iterNode.getBlockVarNode() != null) {
                    astCompiler.compileAssignment(iterNode.getBlockVarNode(), context);
                } else {
                    context.consumeCurrentValue();
                }
            }
        };
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(iterNode.getBodyNode());
        inspector.inspect(iterNode.getVarNode());
        int scopeIndex = asmCompiler.getCacheCompiler().reserveStaticScope();
        ChildScopedBodyCompiler closureCompiler = new ChildScopedBodyCompiler(asmCompiler, "__file__", asmCompiler.getClassname(), inspector, scope, scopeIndex);
        closureCompiler.beginMethod(closureArgs, scope);
        closureBody.call(closureCompiler);
        closureCompiler.endBody();
        SkinnyMethodAdapter method2 = new SkinnyMethodAdapter(asmCompiler.getClassVisitor(), 1, "__file__", StandardASMCompiler.getMethodSignature(4), null, null);
        method2.start();
        method2.aload(2);
        method2.areturn();
        method2.end();
        method2 = new SkinnyMethodAdapter(asmCompiler.getClassVisitor(), 1, "__file__", StandardASMCompiler.getMethodSignature(1), null, null);
        method2.start();
        method2.aload(0);
        method2.aload(1);
        method2.aload(2);
        method2.aload(3);
        method2.aload(4);
        method2.invokestatic(asmCompiler.getClassname(), "__file__", StandardASMCompiler.getStaticMethodSignature(asmCompiler.getClassname(), 1));
        method2.areturn();
        method2.end();
        asmCompiler.endScript(false, false);
        byte[] bytes2 = asmCompiler.getClassByteArray();
        Class<?> blockClass = new JRubyClassLoader(context.runtime.getJRubyClassLoader()).defineClass(asmCompiler.getClassname(), bytes2);
        try {
            final AbstractScript script = (AbstractScript)blockClass.newInstance();
            script.setRootScope(scope);
            return new CompiledBlockCallback(){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, IRubyObject args2, Block block) {
                    return script.__file__(context, self2, args2, block);
                }

                @Override
                public String getFile() {
                    return "blah";
                }

                @Override
                public int getLine() {
                    return -1;
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CompiledBlockCallback19 compileBlock19(ThreadContext context, StandardASMCompiler asmCompiler, final IterNode iterNode) {
        final ASTCompiler19 astCompiler = new ASTCompiler19();
        StaticScope scope = iterNode.getScope();
        asmCompiler.startScript(scope);
        final ArgsNode argsNode = (ArgsNode)iterNode.getVarNode();
        CompilerCallback closureBody = new CompilerCallback(){

            @Override
            public void call(BodyCompiler context) {
                if (iterNode.getBodyNode() != null) {
                    astCompiler.compile(iterNode.getBodyNode(), context, true);
                } else {
                    context.loadNil();
                }
            }
        };
        CompilerCallback closureArgs = new CompilerCallback(){

            @Override
            public void call(BodyCompiler context) {
                context.consumeCurrentValue();
                context.consumeCurrentValue();
                if (iterNode.getVarNode() != null) {
                    if (iterNode instanceof LambdaNode) {
                        int required = argsNode.getRequiredArgsCount();
                        int opt = argsNode.getOptionalArgsCount();
                        int rest2 = argsNode.getRestArg();
                        context.getVariableCompiler().checkMethodArity(required, opt, rest2);
                        astCompiler.compileMethodArgs(argsNode, context, true);
                    } else {
                        astCompiler.compileMethodArgs(argsNode, context, true);
                    }
                }
            }
        };
        ASTInspector inspector = new ASTInspector();
        inspector.inspect(iterNode.getBodyNode());
        inspector.inspect(iterNode.getVarNode());
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(iterNode);
        int scopeIndex = asmCompiler.getCacheCompiler().reserveStaticScope();
        ChildScopedBodyCompiler19 closureCompiler = new ChildScopedBodyCompiler19(asmCompiler, "__file__", asmCompiler.getClassname(), inspector, scope, scopeIndex);
        closureCompiler.beginMethod(argsNodeId == null ? null : closureArgs, scope);
        closureBody.call(closureCompiler);
        closureCompiler.endBody();
        SkinnyMethodAdapter method2 = new SkinnyMethodAdapter(asmCompiler.getClassVisitor(), 1, "__file__", StandardASMCompiler.getMethodSignature(4), null, null);
        method2.start();
        method2.aload(0);
        method2.aload(1);
        method2.aload(2);
        method2.aload(3);
        method2.aload(4);
        method2.invokestatic(asmCompiler.getClassname(), "__file__", StandardASMCompiler.getStaticMethodSignature(asmCompiler.getClassname(), 4));
        method2.areturn();
        method2.end();
        asmCompiler.endScript(false, false);
        byte[] bytes2 = asmCompiler.getClassByteArray();
        Class<?> blockClass = new JRubyClassLoader(context.runtime.getJRubyClassLoader()).defineClass(asmCompiler.getClassname(), bytes2);
        try {
            final AbstractScript script = (AbstractScript)blockClass.newInstance();
            script.setRootScope(scope);
            return new CompiledBlockCallback19(){

                @Override
                public IRubyObject call(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
                    return script.__file__(context, self2, args2, block);
                }

                @Override
                public String getFile() {
                    return iterNode.getPosition().getFile();
                }

                @Override
                public int getLine() {
                    return iterNode.getPosition().getLine();
                }
            };
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static void log(DefaultMethod method2, String name2, String message2, String ... reason2) {
        String className = method2.getImplementationClass().getBaseName();
        if (className == null) {
            className = "<anon class>";
        }
        StringBuilder builder = new StringBuilder(message2 + ":" + className + "." + name2 + " at " + method2.getPosition());
        if (reason2.length > 0) {
            builder.append(" because of: \"");
            for (int i2 = 0; i2 < reason2.length; ++i2) {
                builder.append(reason2[i2]);
            }
            builder.append('\"');
        }
        LOG.info(builder.toString(), new Object[0]);
    }

    private static String calculateFilename(ArgsNode argsNode, Node bodyNode) {
        if (bodyNode != null) {
            return bodyNode.getPosition().getFile();
        }
        if (argsNode != null) {
            return argsNode.getPosition().getFile();
        }
        return "__eval__";
    }

    public static class JITClassGenerator
    implements ClassCache.ClassGenerator {
        private final StandardASMCompiler asmCompiler;
        private final StaticScope staticScope;
        private final Node bodyNode;
        private final ArgsNode argsNode;
        private final Ruby ruby;
        private final String packageName;
        private final String className;
        private final String filename;
        private final String methodName;
        private final JITCounts counts;
        private final String digestString;
        private CallConfiguration jitCallConfig;
        private byte[] bytecode;
        private String name;

        public JITClassGenerator(String className, String methodName, String key2, Ruby ruby2, DefaultMethod method2, JITCounts counts) {
            this.packageName = JITCompiler.RUBY_JIT_PREFIX;
            this.digestString = RubyInstanceConfig.JAVA_VERSION == 51 || Options.COMPILE_INVOKEDYNAMIC.load() == true ? JITCompiler.getHashForString(key2) + Math.abs(ruby2.hashCode()) : JITCompiler.getHashForString(key2);
            this.className = this.packageName + "/" + className.replace('.', '/') + JITCompiler.CLASS_METHOD_DELIMITER + JavaNameMangler.mangleMethodName(methodName) + "_" + this.digestString;
            this.name = this.className.replaceAll("/", ".");
            this.bodyNode = method2.getBodyNode();
            this.argsNode = method2.getArgsNode();
            this.methodName = methodName;
            this.filename = JITCompiler.calculateFilename(this.argsNode, this.bodyNode);
            this.staticScope = method2.getStaticScope();
            this.asmCompiler = new StandardASMCompiler(this.className, this.filename);
            this.ruby = ruby2;
            this.counts = counts;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void compile() {
            BodyCompiler methodCompiler;
            if (this.bytecode != null) {
                return;
            }
            String codeCache = RubyInstanceConfig.JIT_CODE_CACHE;
            File cachedClassFile = new File(codeCache + "/" + this.className + ".class");
            if (codeCache != null && cachedClassFile.exists()) {
                FileInputStream fis = null;
                try {
                    if (RubyInstanceConfig.JIT_LOADING_DEBUG) {
                        LOG.info("loading cached code from: " + cachedClassFile, new Object[0]);
                    }
                    fis = new FileInputStream(cachedClassFile);
                    this.bytecode = new byte[(int)fis.getChannel().size()];
                    fis.read(this.bytecode);
                    this.name = new ClassReader(this.bytecode).getClassName();
                    return;
                }
                catch (Exception e) {
                }
                finally {
                    try {
                        fis.close();
                    }
                    catch (Exception e) {}
                }
            }
            long start2 = System.nanoTime();
            this.asmCompiler.startScript(this.staticScope);
            final ASTCompiler compiler = this.ruby.getInstanceConfig().newCompiler();
            CompilerCallback args2 = new CompilerCallback(){

                @Override
                public void call(BodyCompiler context) {
                    compiler.compileArgs(JITClassGenerator.this.argsNode, context, true);
                }
            };
            ASTInspector inspector = new ASTInspector();
            if (this.ruby.getInstanceConfig().isJitDumping()) {
                inspector = new ASTInspector(this.className, true);
            }
            inspector.inspect(this.argsNode);
            inspector.inspect(this.bodyNode);
            if (this.bodyNode != null) {
                methodCompiler = this.asmCompiler.startFileMethod(args2, this.staticScope, inspector);
                compiler.compileBody(this.bodyNode, methodCompiler, true);
            } else if (this.argsNode != null && (this.argsNode.getRequiredArgsCount() > 0 || this.argsNode.getOptionalArgsCount() > 0)) {
                methodCompiler = this.asmCompiler.startFileMethod(args2, this.staticScope, inspector);
                methodCompiler.loadNil();
            } else {
                methodCompiler = this.asmCompiler.startFileMethod(null, this.staticScope, inspector);
                methodCompiler.loadNil();
                this.jitCallConfig = CallConfiguration.FrameNoneScopeNone;
            }
            methodCompiler.endBody();
            this.asmCompiler.endScript(false, false);
            if (this.jitCallConfig == null) {
                this.jitCallConfig = inspector.getCallConfig();
            }
            this.bytecode = this.asmCompiler.getClassByteArray();
            if (this.ruby.getInstanceConfig().isJitDumping()) {
                TraceClassVisitor tcv = new TraceClassVisitor(new PrintWriter(System.out));
                new ClassReader(this.bytecode).accept((ClassVisitor)tcv, 0);
            }
            if (this.bytecode.length > this.ruby.getInstanceConfig().getJitMaxSize()) {
                this.bytecode = null;
                throw new NotCompilableException("JITed method size exceeds configured max of " + this.ruby.getInstanceConfig().getJitMaxSize());
            }
            if (codeCache != null) {
                JITCompiler.saveToCodeCache(this.ruby, this.bytecode, this.packageName, cachedClassFile);
            }
            this.counts.compiledCount.incrementAndGet();
            this.counts.compileTime.addAndGet(System.nanoTime() - start2);
            this.counts.codeSize.addAndGet(this.bytecode.length);
            this.counts.averageCompileTime.set(this.counts.compileTime.get() / this.counts.compiledCount.get());
            this.counts.averageCodeSize.set(this.counts.codeSize.get() / this.counts.compiledCount.get());
            JITCounts jITCounts = this.counts;
            synchronized (jITCounts) {
                if (this.counts.largestCodeSize.get() < (long)this.bytecode.length) {
                    this.counts.largestCodeSize.set(this.bytecode.length);
                }
            }
        }

        @Override
        public void generate() {
            this.compile();
        }

        @Override
        public byte[] bytecode() {
            return this.bytecode;
        }

        @Override
        public String name() {
            return this.name;
        }

        public CallConfiguration callConfig() {
            this.compile();
            return this.jitCallConfig;
        }

        public String toString() {
            return this.methodName + "() at " + this.bodyNode.getPosition().getFile() + ":" + this.bodyNode.getPosition().getLine();
        }
    }

    private class JITTask
    implements Runnable {
        private final String className;
        private final DefaultMethod method;
        private final String methodName;

        public JITTask(String className, DefaultMethod method2, String methodName) {
            this.className = className;
            this.method = method2;
            this.methodName = methodName;
        }

        @Override
        public void run() {
            try {
                int methodCount;
                ClassCache classCache = JITCompiler.this.config.getClassCache();
                if (classCache.isFull()) {
                    JITCompiler.this.counts.abandonCount.incrementAndGet();
                    return;
                }
                if (JITCompiler.this.config.getExcludedMethods().size() > 0) {
                    IRubyObject possibleRealClass;
                    String excludeModuleName = this.className;
                    if (this.method.getImplementationClass().isSingleton() && (possibleRealClass = ((MetaClass)this.method.getImplementationClass()).getAttached()) instanceof RubyModule) {
                        excludeModuleName = "Meta:" + ((RubyModule)possibleRealClass).getName();
                    }
                    if (JITCompiler.this.config.getExcludedMethods().contains(excludeModuleName) || JITCompiler.this.config.getExcludedMethods().contains(excludeModuleName + "#" + this.methodName) || JITCompiler.this.config.getExcludedMethods().contains(this.methodName)) {
                        this.method.setCallCount(-1);
                        JITCompiler.log(this.method, this.methodName, "skipping method: " + excludeModuleName + "#" + this.methodName, new String[0]);
                        return;
                    }
                }
                String key2 = SexpMaker.create(this.methodName, this.method.getArgsNode(), this.method.getBodyNode());
                JITClassGenerator generator = new JITClassGenerator(this.className, this.methodName, key2, JITCompiler.this.runtime, this.method, JITCompiler.this.counts);
                Class sourceClass = JITCompiler.this.config.getClassCache().cacheClassByKey(generator.digestString, generator);
                if (sourceClass == null) {
                    JITCompiler.this.counts.failCount.incrementAndGet();
                    return;
                }
                JITCompiler.this.counts.successCount.incrementAndGet();
                Script jitCompiledScript = (Script)sourceClass.newInstance();
                jitCompiledScript.setRootScope(this.method.getStaticScope());
                Set<Script> jittedMethods = JITCompiler.this.runtime.getJittedMethods();
                jittedMethods.add(jitCompiledScript);
                if (JITCompiler.this.config.getJitLogEvery() > 0 && (methodCount = jittedMethods.size()) % JITCompiler.this.config.getJitLogEvery() == 0) {
                    JITCompiler.log(this.method, this.methodName, "live compiled methods: " + methodCount, new String[0]);
                }
                if (JITCompiler.this.config.isJitLogging()) {
                    JITCompiler.log(this.method, this.className + "." + this.methodName, "done jitting", new String[0]);
                }
                this.method.switchToJitted(jitCompiledScript, generator.callConfig());
                return;
            }
            catch (Throwable t) {
                if (JITCompiler.this.runtime.getDebug().isTrue()) {
                    t.printStackTrace();
                }
                if (JITCompiler.this.config.isJitLoggingVerbose()) {
                    JITCompiler.log(this.method, this.className + "." + this.methodName, "could not compile", t.getMessage());
                }
                JITCompiler.this.counts.failCount.incrementAndGet();
                return;
            }
        }
    }

    public static class JITCounts {
        private final AtomicLong compiledCount = new AtomicLong(0L);
        private final AtomicLong successCount = new AtomicLong(0L);
        private final AtomicLong failCount = new AtomicLong(0L);
        private final AtomicLong abandonCount = new AtomicLong(0L);
        private final AtomicLong compileTime = new AtomicLong(0L);
        private final AtomicLong averageCompileTime = new AtomicLong(0L);
        private final AtomicLong codeSize = new AtomicLong(0L);
        private final AtomicLong averageCodeSize = new AtomicLong(0L);
        private final AtomicLong largestCodeSize = new AtomicLong(0L);
    }
}

