/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.IOException;
import java.util.zip.ZipEntry;
import org.jruby.RubyFile;
import org.jruby.util.FileResource;

public class JarFileResource
extends ZipEntry
implements FileResource {
    public static JarFileResource load(String path2) {
        String sanitized = path2.startsWith("file:") ? path2.substring(5) : path2;
        int bang = sanitized.indexOf(33);
        if (bang == -1) {
            throw new IllegalArgumentException("Expecting a jar containing path, but got: " + sanitized);
        }
        String jar = sanitized.substring(0, bang);
        String after = sanitized.substring(bang + 2);
        try {
            return new JarFileResource(RubyFile.getDirOrFileEntry(jar, after));
        }
        catch (IOException ioError) {
            return null;
        }
    }

    private JarFileResource(ZipEntry entry) {
        super(entry);
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean isFile() {
        return !this.isDirectory();
    }

    @Override
    public long length() {
        return this.getSize();
    }

    @Override
    public long lastModified() {
        return this.getTime();
    }
}

