/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.passes;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jruby.ir.IRScope;
import org.jruby.ir.passes.CompilerPassListener;

public abstract class CompilerPass {
    public static List<Class<? extends CompilerPass>> NO_DEPENDENCIES = new ArrayList<Class<? extends CompilerPass>>();
    private List<CompilerPassListener> listeners = new ArrayList<CompilerPassListener>();

    public abstract String getLabel();

    public abstract Object execute(IRScope var1, Object ... var2);

    public abstract void invalidate(IRScope var1);

    public List<Class<? extends CompilerPass>> getDependencies() {
        return NO_DEPENDENCIES;
    }

    public Object previouslyRun(IRScope scope) {
        return null;
    }

    protected Object run(IRScope scope, boolean childScope) {
        List<Class<? extends CompilerPass>> dependencies = this.getDependencies();
        Object[] data2 = new Object[dependencies.size()];
        for (int i2 = 0; i2 < data2.length; ++i2) {
            data2[i2] = this.makeSureDependencyHasRunOnce(dependencies.get(i2), scope, childScope);
        }
        for (CompilerPassListener listener : scope.getManager().getListeners()) {
            listener.startExecute(this, scope, childScope);
        }
        Object passData = this.execute(scope, data2);
        for (CompilerPassListener listener : scope.getManager().getListeners()) {
            listener.endExecute(this, scope, passData, childScope);
        }
        return passData;
    }

    public Object run(IRScope scope) {
        return this.run(scope, false);
    }

    private Object makeSureDependencyHasRunOnce(Class<? extends CompilerPass> passClass, IRScope scope, boolean childScope) {
        CompilerPass pass2 = CompilerPass.createPassInstance(passClass);
        Object data2 = pass2.previouslyRun(scope);
        if (data2 == null) {
            data2 = pass2.run(scope, childScope);
        } else {
            for (CompilerPassListener listener : scope.getManager().getListeners()) {
                listener.alreadyExecuted(pass2, scope, data2, childScope);
            }
        }
        return data2;
    }

    public static CompilerPass createPassInstance(Class<? extends CompilerPass> passClass) {
        try {
            return passClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(CompilerPass.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CompilerPass.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(CompilerPass.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(CompilerPass.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(CompilerPass.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(CompilerPass.class.getName()).log(Level.SEVERE, null, ex);
        }
        return null;
    }

    public static CompilerPass createPassInstance(String passClassName) {
        try {
            String clazzName = "org.jruby.ir.passes." + passClassName;
            Class<?> clazz = Class.forName(clazzName);
            return CompilerPass.createPassInstance(clazz);
        }
        catch (ClassNotFoundException ex) {
            System.out.println("No such pass: " + ex);
            System.exit(-1);
            return null;
        }
    }

    public static List<CompilerPass> getPassesFromString(String passList, String defaultPassList) {
        if (passList == null) {
            passList = defaultPassList;
        }
        ArrayList<CompilerPass> passes = new ArrayList<CompilerPass>();
        for (String passClassName : passList.split(",")) {
            passes.add(CompilerPass.createPassInstance(passClassName));
        }
        return passes;
    }
}

