/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.invokedynamic;

import com.headius.invokebinder.Binder;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.MutableCallSite;
import java.lang.invoke.SwitchPoint;
import java.math.BigInteger;
import org.jcodings.Encoding;
import org.jcodings.EncodingDB;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInstanceConfig;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyModule;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.executable.AbstractScript;
import org.jruby.exceptions.JumpException;
import org.jruby.internal.runtime.GlobalVariable;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.org.objectweb.asm.Handle;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.MethodIndex;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.GlobalSite;
import org.jruby.runtime.invokedynamic.InvocationLinker;
import org.jruby.runtime.invokedynamic.MathLinker;
import org.jruby.runtime.invokedynamic.RubyConstantCallSite;
import org.jruby.runtime.invokedynamic.VariableSite;
import org.jruby.runtime.opto.Invalidator;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.JavaNameMangler;
import org.jruby.util.RegexpOptions;
import org.jruby.util.cli.Options;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class InvokeDynamicSupport {
    private static final Logger LOG = LoggerFactory.getLogger("InvokeDynamicSupport");
    public static final String BOOTSTRAP_BARE_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class);
    public static final String BOOTSTRAP_INT_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Integer.TYPE);
    public static final String BOOTSTRAP_STRING_STRING_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class);
    public static final String BOOTSTRAP_STRING_STRING_INT_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, String.class, Integer.TYPE);
    public static final String BOOTSTRAP_STRING_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class);
    public static final String BOOTSTRAP_STRING_CALLTYPE_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, CallType.class);
    public static final String BOOTSTRAP_LONG_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE);
    public static final String BOOTSTRAP_DOUBLE_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Double.TYPE);
    public static final String BOOTSTRAP_LONG_STRING_INT_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Long.TYPE, String.class, Integer.TYPE);
    public static final String BOOTSTRAP_DOUBLE_STRING_INT_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, Double.TYPE, String.class, Integer.TYPE);
    public static final String BOOTSTRAP_STRING_INT_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Integer.TYPE);
    public static final String BOOTSTRAP_STRING_LONG_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Long.TYPE);
    public static final String BOOTSTRAP_STRING_DOUBLE_SIG = CodegenUtils.sig(java.lang.invoke.CallSite.class, MethodHandles.Lookup.class, String.class, MethodType.class, String.class, Double.TYPE);

    public static Handle getBootstrapHandle(String name2, Class type2, String sig) {
        return new Handle(6, CodegenUtils.p(type2), name2, sig);
    }

    public static Handle getBootstrapHandle(String name2, String sig) {
        return InvokeDynamicSupport.getBootstrapHandle(name2, InvokeDynamicSupport.class, sig);
    }

    public static Handle getInvocationHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("invocationBootstrap", InvocationLinker.class, BOOTSTRAP_STRING_INT_SIG);
    }

    public static Handle getConstantHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getConstantBootstrap", BOOTSTRAP_INT_SIG);
    }

    public static Handle getConstantBooleanHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getConstantBooleanBootstrap", BOOTSTRAP_INT_SIG);
    }

    public static Handle getByteListHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getByteListBootstrap", BOOTSTRAP_STRING_STRING_SIG);
    }

    public static Handle getRegexpHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getRegexpBootstrap", BOOTSTRAP_STRING_STRING_INT_SIG);
    }

    public static Handle getSymbolHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getSymbolBootstrap", BOOTSTRAP_STRING_SIG);
    }

    public static Handle getFixnumHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getFixnumBootstrap", BOOTSTRAP_LONG_SIG);
    }

    public static Handle getFloatHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getFloatBootstrap", BOOTSTRAP_DOUBLE_SIG);
    }

    public static Handle getStaticScopeHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getStaticScopeBootstrap", BOOTSTRAP_STRING_INT_SIG);
    }

    public static Handle getLoadStaticScopeHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getLoadStaticScopeBootstrap", BOOTSTRAP_INT_SIG);
    }

    public static Handle getCallSiteHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getCallSiteBootstrap", BOOTSTRAP_STRING_INT_SIG);
    }

    public static Handle getStringHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getStringBootstrap", BOOTSTRAP_STRING_STRING_INT_SIG);
    }

    public static Handle getBigIntegerHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getBigIntegerBootstrap", BOOTSTRAP_STRING_SIG);
    }

    public static Handle getEncodingHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getEncodingBootstrap", BOOTSTRAP_STRING_SIG);
    }

    public static Handle getBlockBodyHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("getBlockBodyBootstrap", BOOTSTRAP_STRING_SIG);
    }

    public static Handle getBlockBody19Handle() {
        return InvokeDynamicSupport.getBootstrapHandle("getBlockBody19Bootstrap", BOOTSTRAP_STRING_SIG);
    }

    public static Handle getFixnumOperatorHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("fixnumOperatorBootstrap", MathLinker.class, BOOTSTRAP_LONG_STRING_INT_SIG);
    }

    public static Handle getFixnumBooleanHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("fixnumBooleanBootstrap", MathLinker.class, BOOTSTRAP_LONG_STRING_INT_SIG);
    }

    public static Handle getFloatOperatorHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("floatOperatorBootstrap", MathLinker.class, BOOTSTRAP_DOUBLE_STRING_INT_SIG);
    }

    public static Handle getVariableHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("variableBootstrap", BOOTSTRAP_STRING_INT_SIG);
    }

    public static Handle getContextFieldHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("contextFieldBootstrap", BOOTSTRAP_BARE_SIG);
    }

    public static Handle getGlobalHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("globalBootstrap", BOOTSTRAP_STRING_INT_SIG);
    }

    public static Handle getGlobalBooleanHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("globalBooleanBootstrap", BOOTSTRAP_STRING_INT_SIG);
    }

    public static Handle checkpointHandle() {
        return InvokeDynamicSupport.getBootstrapHandle("checkpointBootstrap", BOOTSTRAP_BARE_SIG);
    }

    public static java.lang.invoke.CallSite contextFieldBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2) throws NoSuchMethodException, IllegalAccessException {
        MutableCallSite site = new MutableCallSite(type2);
        if (name2.equals("nil")) {
            site.setTarget(Binder.from(type2).insert(0, site).invokeStatic(lookup, InvokeDynamicSupport.class, "loadNil"));
        } else if (name2.equals("runtime")) {
            site.setTarget(Binder.from(type2).insert(0, site).invokeStatic(lookup, InvokeDynamicSupport.class, "loadRuntime"));
        }
        return site;
    }

    public static IRubyObject loadNil(MutableCallSite site, ThreadContext context) throws Throwable {
        site.setTarget(Binder.from(IRubyObject.class, ThreadContext.class, new Class[0]).drop(0).constant(context.nil));
        return context.nil;
    }

    public static Ruby loadRuntime(MutableCallSite site, ThreadContext context) throws Throwable {
        site.setTarget(Binder.from(Ruby.class, ThreadContext.class, new Class[0]).drop(0).constant(context.runtime));
        return context.runtime;
    }

    public static java.lang.invoke.CallSite getConstantBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, int scopeIndex) throws NoSuchMethodException, IllegalAccessException {
        RubyConstantCallSite site = new RubyConstantCallSite(type2, name2);
        MethodType fallbackType = MethodType.methodType(IRubyObject.class, RubyConstantCallSite.class, AbstractScript.class, ThreadContext.class, Integer.TYPE);
        MethodHandle myFallback = MethodHandles.insertArguments(lookup.findStatic(InvokeDynamicSupport.class, "constantFallback", fallbackType), 0, site);
        myFallback = MethodHandles.insertArguments(myFallback, 2, scopeIndex);
        site.setTarget(myFallback);
        return site;
    }

    public static java.lang.invoke.CallSite getConstantBooleanBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, int scopeIndex) throws NoSuchMethodException, IllegalAccessException {
        RubyConstantCallSite site = new RubyConstantCallSite(type2, name2);
        MethodType fallbackType = MethodType.methodType(Boolean.TYPE, RubyConstantCallSite.class, AbstractScript.class, ThreadContext.class, Integer.TYPE);
        MethodHandle myFallback = MethodHandles.insertArguments(lookup.findStatic(InvokeDynamicSupport.class, "constantBooleanFallback", fallbackType), 0, site);
        myFallback = MethodHandles.insertArguments(myFallback, 2, scopeIndex);
        site.setTarget(myFallback);
        return site;
    }

    public static java.lang.invoke.CallSite getByteListBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String asString, String encodingName) {
        byte[] bytes2 = RuntimeHelpers.stringToRawBytes(asString);
        Encoding encoding2 = ((EncodingDB.Entry)EncodingDB.getEncodings().get(encodingName.getBytes())).getEncoding();
        ByteList byteList = new ByteList(bytes2, encoding2);
        return new ConstantCallSite(MethodHandles.constant(ByteList.class, byteList));
    }

    public static java.lang.invoke.CallSite getRegexpBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String asString, String encodingName, int options2) {
        byte[] bytes2 = RuntimeHelpers.stringToRawBytes(asString);
        Encoding encoding2 = ((EncodingDB.Entry)EncodingDB.getEncodings().get(encodingName.getBytes())).getEncoding();
        ByteList byteList = new ByteList(bytes2, encoding2);
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle init = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "initRegexp", MethodType.methodType(RubyRegexp.class, MutableCallSite.class, ThreadContext.class, ByteList.class, Integer.TYPE));
        init = MethodHandles.insertArguments(init, 2, byteList, options2);
        init = MethodHandles.insertArguments(init, 0, site);
        site.setTarget(init);
        return site;
    }

    public static java.lang.invoke.CallSite getSymbolBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String symbol) {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle init = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "initSymbol", MethodType.methodType(RubySymbol.class, MutableCallSite.class, ThreadContext.class, String.class));
        init = MethodHandles.insertArguments(init, 2, symbol);
        init = MethodHandles.insertArguments(init, 0, site);
        site.setTarget(init);
        return site;
    }

    public static java.lang.invoke.CallSite getFixnumBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, long value2) {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle init = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "initFixnum", MethodType.methodType(RubyFixnum.class, MutableCallSite.class, ThreadContext.class, Long.TYPE));
        init = MethodHandles.insertArguments(init, 2, value2);
        init = MethodHandles.insertArguments(init, 0, site);
        site.setTarget(init);
        return site;
    }

    public static java.lang.invoke.CallSite getFloatBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, double value2) {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle init = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "initFloat", MethodType.methodType(RubyFloat.class, MutableCallSite.class, ThreadContext.class, Double.TYPE));
        init = MethodHandles.insertArguments(init, 2, value2);
        init = MethodHandles.insertArguments(init, 0, site);
        site.setTarget(init);
        return site;
    }

    public static java.lang.invoke.CallSite getStaticScopeBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String scopeString, int index2) {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle init = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "initStaticScope", MethodType.methodType(StaticScope.class, MutableCallSite.class, AbstractScript.class, ThreadContext.class, StaticScope.class, String.class, Integer.TYPE));
        init = MethodHandles.insertArguments(init, 4, scopeString, index2);
        init = MethodHandles.insertArguments(init, 0, site);
        site.setTarget(init);
        return site;
    }

    public static java.lang.invoke.CallSite getLoadStaticScopeBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, int index2) {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle init = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "loadStaticScope", MethodType.methodType(StaticScope.class, MutableCallSite.class, AbstractScript.class, Integer.TYPE));
        init = MethodHandles.insertArguments(init, 2, index2);
        init = MethodHandles.insertArguments(init, 0, site);
        site.setTarget(init);
        return site;
    }

    public static java.lang.invoke.CallSite getCallSiteBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String callName, int callTypeChar) {
        CallSite callSite = null;
        switch (callTypeChar) {
            case 78: {
                callSite = MethodIndex.getCallSite(callName);
                break;
            }
            case 70: {
                callSite = MethodIndex.getFunctionalCallSite(callName);
                break;
            }
            case 86: {
                callSite = MethodIndex.getVariableCallSite(callName);
                break;
            }
            case 83: {
                callSite = MethodIndex.getSuperCallSite();
            }
        }
        return new ConstantCallSite(MethodHandles.constant(CallSite.class, callSite));
    }

    public static java.lang.invoke.CallSite getStringBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String asString, String encodingName, int codeRange) {
        byte[] bytes2 = RuntimeHelpers.stringToRawBytes(asString);
        Encoding encoding2 = ((EncodingDB.Entry)EncodingDB.getEncodings().get(encodingName.getBytes())).getEncoding();
        ByteList byteList = new ByteList(bytes2, encoding2);
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle init = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "newString", MethodType.methodType(RubyString.class, ThreadContext.class, ByteList.class, Integer.TYPE));
        init = MethodHandles.insertArguments(init, 1, byteList, codeRange);
        site.setTarget(init);
        return site;
    }

    public static java.lang.invoke.CallSite getBigIntegerBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String asString) {
        BigInteger byteList = new BigInteger(asString, 16);
        return new ConstantCallSite(MethodHandles.constant(BigInteger.class, byteList));
    }

    public static java.lang.invoke.CallSite getEncodingBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String encodingName) {
        Encoding encoding2 = ((EncodingDB.Entry)EncodingDB.getEncodings().get(encodingName.getBytes())).getEncoding();
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle init = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "initEncoding", MethodType.methodType(RubyEncoding.class, MutableCallSite.class, ThreadContext.class, Encoding.class));
        init = MethodHandles.insertArguments(init, 2, encoding2);
        init = MethodHandles.insertArguments(init, 0, site);
        site.setTarget(init);
        return site;
    }

    public static java.lang.invoke.CallSite getBlockBodyBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String descriptor) {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle init = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "initBlockBody", MethodType.methodType(BlockBody.class, MutableCallSite.class, Object.class, ThreadContext.class, StaticScope.class, String.class));
        init = MethodHandles.insertArguments(init, 4, descriptor);
        init = MethodHandles.insertArguments(init, 0, site);
        site.setTarget(init);
        return site;
    }

    public static java.lang.invoke.CallSite getBlockBody19Bootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String descriptor) {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle init = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "initBlockBody19", MethodType.methodType(BlockBody.class, MutableCallSite.class, Object.class, ThreadContext.class, StaticScope.class, String.class));
        init = MethodHandles.insertArguments(init, 4, descriptor);
        init = MethodHandles.insertArguments(init, 0, site);
        site.setTarget(init);
        return site;
    }

    public static java.lang.invoke.CallSite variableBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String file2, int line) throws Throwable {
        MethodHandle handle;
        String[] names2 = name2.split(":");
        String operation = names2[0];
        String varName = names2[1];
        VariableSite site = new VariableSite(type2, varName, file2, line);
        if (operation.equals("get")) {
            handle = lookup.findStatic(InvokeDynamicSupport.class, "getVariableFallback", MethodType.methodType(IRubyObject.class, VariableSite.class, IRubyObject.class));
        } else if (operation.equals("set")) {
            handle = lookup.findStatic(InvokeDynamicSupport.class, "setVariableFallback", MethodType.methodType(IRubyObject.class, VariableSite.class, IRubyObject.class, IRubyObject.class));
        } else {
            throw new RuntimeException("invalid variable access type");
        }
        handle = handle.bindTo(site);
        site.setTarget(handle);
        return site;
    }

    public static IRubyObject getVariableFallback(VariableSite site, IRubyObject self) throws Throwable {
        RubyClass realClass = self.getMetaClass().getRealClass();
        RubyClass.VariableAccessor accessor = realClass.getVariableAccessorForRead(site.name);
        MethodHandle nullToNil = InvokeDynamicSupport.findStatic(RuntimeHelpers.class, "nullToNil", MethodType.methodType(IRubyObject.class, IRubyObject.class, IRubyObject.class));
        nullToNil = MethodHandles.insertArguments(nullToNil, 1, self.getRuntime().getNil());
        nullToNil = MethodHandles.explicitCastArguments(nullToNil, MethodType.methodType(IRubyObject.class, Object.class));
        MethodHandle getValue2 = InvokeDynamicSupport.findVirtual(IRubyObject.class, "getVariable", MethodType.methodType(Object.class, Integer.TYPE));
        getValue2 = MethodHandles.insertArguments(getValue2, 1, accessor.getIndex());
        getValue2 = MethodHandles.filterReturnValue(getValue2, nullToNil);
        MethodHandle fallback = null;
        if (site.chainCount() > RubyInstanceConfig.MAX_POLY_COUNT) {
            if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                LOG.info(site.name + "\tqet on type " + self.getMetaClass().id + " failed (polymorphic)" + InvokeDynamicSupport.extractSourceInfo(site), new Object[0]);
            }
            fallback = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "getVariableFail", MethodType.methodType(IRubyObject.class, VariableSite.class, IRubyObject.class));
            fallback = fallback.bindTo(site);
            site.setTarget(fallback);
            return (IRubyObject)fallback.invokeWithArguments(self);
        }
        if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
            LOG.info(site.name + "\tget on type " + self.getMetaClass().id + " added to PIC" + InvokeDynamicSupport.extractSourceInfo(site), new Object[0]);
        }
        fallback = site.getTarget();
        site.incrementChainCount();
        MethodHandle test2 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "testRealClass", MethodType.methodType(Boolean.TYPE, Integer.TYPE, IRubyObject.class));
        test2 = MethodHandles.insertArguments(test2, 0, accessor.getClassId());
        getValue2 = MethodHandles.guardWithTest(test2, getValue2, fallback);
        if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
            LOG.info(site.name + "\tget on class " + self.getMetaClass().id + " bound directly" + InvokeDynamicSupport.extractSourceInfo(site), new Object[0]);
        }
        site.setTarget(getValue2);
        return (IRubyObject)getValue2.invokeWithArguments(self);
    }

    public static IRubyObject getVariableFail(VariableSite site, IRubyObject self) throws Throwable {
        return site.getVariable(self);
    }

    public static IRubyObject setVariableFallback(VariableSite site, IRubyObject self, IRubyObject value2) throws Throwable {
        RubyClass realClass = self.getMetaClass().getRealClass();
        RubyClass.VariableAccessor accessor = realClass.getVariableAccessorForWrite(site.name);
        MethodHandle returnValue = MethodHandles.identity(IRubyObject.class);
        returnValue = MethodHandles.dropArguments(returnValue, 0, new Class[]{IRubyObject.class});
        MethodHandle setValue2 = InvokeDynamicSupport.findVirtual(IRubyObject.class, "setVariable", MethodType.methodType(Void.TYPE, Integer.TYPE, Object.class));
        setValue2 = MethodHandles.explicitCastArguments(setValue2, MethodType.methodType(Void.TYPE, IRubyObject.class, Integer.TYPE, IRubyObject.class));
        setValue2 = MethodHandles.insertArguments(setValue2, 1, accessor.getIndex());
        setValue2 = MethodHandles.foldArguments(returnValue, setValue2);
        MethodHandle fallback = null;
        if (site.chainCount() > RubyInstanceConfig.MAX_POLY_COUNT) {
            if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
                LOG.info(site.name + "\tset on type " + self.getMetaClass().id + " failed (polymorphic)" + InvokeDynamicSupport.extractSourceInfo(site), new Object[0]);
            }
            fallback = InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "setVariableFail", MethodType.methodType(IRubyObject.class, VariableSite.class, IRubyObject.class, IRubyObject.class));
            fallback = fallback.bindTo(site);
            site.setTarget(fallback);
            return (IRubyObject)fallback.invokeWithArguments(self, value2);
        }
        if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
            LOG.info(site.name + "\tset on type " + self.getMetaClass().id + " added to PIC" + InvokeDynamicSupport.extractSourceInfo(site), new Object[0]);
        }
        fallback = site.getTarget();
        site.incrementChainCount();
        MethodHandle test2 = InvokeDynamicSupport.findStatic(InvocationLinker.class, "testRealClass", MethodType.methodType(Boolean.TYPE, Integer.TYPE, IRubyObject.class));
        test2 = MethodHandles.insertArguments(test2, 0, accessor.getClassId());
        test2 = MethodHandles.dropArguments(test2, 1, new Class[]{IRubyObject.class});
        setValue2 = MethodHandles.guardWithTest(test2, setValue2, fallback);
        if (RubyInstanceConfig.LOG_INDY_BINDINGS) {
            LOG.info(site.name + "\tset on class " + self.getMetaClass().id + " bound directly" + InvokeDynamicSupport.extractSourceInfo(site), new Object[0]);
        }
        site.setTarget(setValue2);
        return (IRubyObject)setValue2.invokeWithArguments(self, value2);
    }

    public static IRubyObject setVariableFail(VariableSite site, IRubyObject self, IRubyObject value2) throws Throwable {
        return site.setVariable(self, value2);
    }

    public static java.lang.invoke.CallSite globalBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String file2, int line) throws Throwable {
        String[] names2 = name2.split(":");
        String operation = names2[0];
        String varName = JavaNameMangler.demangleMethodName(names2[1]);
        GlobalSite site = new GlobalSite(type2, varName, file2, line);
        if (!operation.equals("get")) {
            throw new RuntimeException("invalid variable access type");
        }
        MethodHandle handle = lookup.findStatic(InvokeDynamicSupport.class, "getGlobalFallback", MethodType.methodType(IRubyObject.class, GlobalSite.class, ThreadContext.class));
        handle = handle.bindTo(site);
        site.setTarget(handle);
        return site;
    }

    public static java.lang.invoke.CallSite globalBooleanBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2, String file2, int line) throws Throwable {
        String[] names2 = name2.split(":");
        String operation = names2[0];
        String varName = JavaNameMangler.demangleMethodName(names2[1]);
        GlobalSite site = new GlobalSite(type2, varName, file2, line);
        if (!operation.equals("getBoolean")) {
            throw new RuntimeException("invalid variable access type");
        }
        MethodHandle handle = lookup.findStatic(InvokeDynamicSupport.class, "getGlobalBooleanFallback", MethodType.methodType(Boolean.TYPE, GlobalSite.class, ThreadContext.class));
        handle = handle.bindTo(site);
        site.setTarget(handle);
        return site;
    }

    public static IRubyObject getGlobalFallback(GlobalSite site, ThreadContext context) throws Throwable {
        Ruby runtime = context.runtime;
        GlobalVariable variable = runtime.getGlobalVariables().getVariable(site.name);
        if (site.failures() > Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load() || variable.getScope() != GlobalVariable.Scope.GLOBAL) {
            if (Options.INVOKEDYNAMIC_LOG_GLOBALS.load().booleanValue()) {
                LOG.info("global " + site.name + " (" + site.file() + ":" + site.line() + ") rebound > " + Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load() + " times, reverting to simple lookup", new Object[0]);
            }
            MethodHandle uncached = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "getGlobalUncached", MethodType.methodType(IRubyObject.class, GlobalVariable.class));
            uncached = uncached.bindTo(variable);
            uncached = MethodHandles.dropArguments(uncached, 0, new Class[]{ThreadContext.class});
            site.setTarget(uncached);
            return (IRubyObject)uncached.invokeWithArguments(context);
        }
        Invalidator invalidator = variable.getInvalidator();
        IRubyObject value2 = variable.getAccessor().getValue();
        MethodHandle target = MethodHandles.constant(IRubyObject.class, value2);
        target = MethodHandles.dropArguments(target, 0, new Class[]{ThreadContext.class});
        MethodHandle fallback = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "getGlobalFallback", MethodType.methodType(IRubyObject.class, GlobalSite.class, ThreadContext.class));
        fallback = fallback.bindTo(site);
        target = ((SwitchPoint)invalidator.getData()).guardWithTest(target, fallback);
        site.setTarget(target);
        if (Options.INVOKEDYNAMIC_LOG_GLOBALS.load().booleanValue()) {
            LOG.info("global " + site.name + " (" + site.file() + ":" + site.line() + ") cached", new Object[0]);
        }
        return value2;
    }

    public static IRubyObject getGlobalUncached(GlobalVariable variable) throws Throwable {
        return variable.getAccessor().getValue();
    }

    public static boolean getGlobalBooleanFallback(GlobalSite site, ThreadContext context) throws Throwable {
        Ruby runtime = context.runtime;
        GlobalVariable variable = runtime.getGlobalVariables().getVariable(site.name);
        if (site.failures() > Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load() || variable.getScope() != GlobalVariable.Scope.GLOBAL) {
            if (Options.INVOKEDYNAMIC_LOG_GLOBALS.load().booleanValue()) {
                LOG.info("global " + site.name + " (" + site.file() + ":" + site.line() + ") rebound > " + Options.INVOKEDYNAMIC_GLOBAL_MAXFAIL.load() + " times, reverting to simple lookup", new Object[0]);
            }
            MethodHandle uncached = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "getGlobalBooleanUncached", MethodType.methodType(Boolean.TYPE, GlobalVariable.class));
            uncached = uncached.bindTo(variable);
            uncached = MethodHandles.dropArguments(uncached, 0, new Class[]{ThreadContext.class});
            site.setTarget(uncached);
            return (Boolean)uncached.invokeWithArguments(context);
        }
        Invalidator invalidator = variable.getInvalidator();
        boolean value2 = variable.getAccessor().getValue().isTrue();
        MethodHandle target = MethodHandles.constant(Boolean.TYPE, value2);
        target = MethodHandles.dropArguments(target, 0, new Class[]{ThreadContext.class});
        MethodHandle fallback = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "getGlobalBooleanFallback", MethodType.methodType(Boolean.TYPE, GlobalSite.class, ThreadContext.class));
        fallback = fallback.bindTo(site);
        target = ((SwitchPoint)invalidator.getData()).guardWithTest(target, fallback);
        site.setTarget(target);
        if (Options.INVOKEDYNAMIC_LOG_GLOBALS.load().booleanValue()) {
            LOG.info("global " + site.name + " (" + site.file() + ":" + site.line() + ") cached as boolean", new Object[0]);
        }
        return value2;
    }

    public static boolean getGlobalBooleanUncached(GlobalVariable variable) throws Throwable {
        return variable.getAccessor().getValue().isTrue();
    }

    public static java.lang.invoke.CallSite checkpointBootstrap(MethodHandles.Lookup lookup, String name2, MethodType type2) throws Throwable {
        MutableCallSite site = new MutableCallSite(type2);
        MethodHandle handle = lookup.findStatic(InvokeDynamicSupport.class, "checkpointFallback", MethodType.methodType(Void.TYPE, MutableCallSite.class, ThreadContext.class));
        handle = handle.bindTo(site);
        site.setTarget(handle);
        return site;
    }

    public static void checkpointFallback(MutableCallSite site, ThreadContext context) throws Throwable {
        Ruby runtime = context.runtime;
        Invalidator invalidator = runtime.getCheckpointInvalidator();
        MethodHandle target = Binder.from(Void.TYPE, ThreadContext.class, new Class[0]).nop();
        MethodHandle fallback = MethodHandles.lookup().findStatic(InvokeDynamicSupport.class, "checkpointFallback", MethodType.methodType(Void.TYPE, MutableCallSite.class, ThreadContext.class));
        fallback = fallback.bindTo(site);
        target = ((SwitchPoint)invalidator.getData()).guardWithTest(target, fallback);
        site.setTarget(target);
    }

    public static IRubyObject constantFallback(RubyConstantCallSite site, AbstractScript script, ThreadContext context, int scopeIndex) {
        SwitchPoint switchPoint = (SwitchPoint)context.runtime.getConstantInvalidator().getData();
        StaticScope scope = script.getScope(scopeIndex);
        IRubyObject value2 = scope.getConstant(site.name());
        if (value2 != null) {
            if (RubyInstanceConfig.LOG_INDY_CONSTANTS) {
                LOG.info("constant " + site.name() + " bound directly", new Object[0]);
            }
            MethodHandle valueHandle = MethodHandles.constant(IRubyObject.class, value2);
            valueHandle = MethodHandles.dropArguments(valueHandle, 0, new Class[]{AbstractScript.class, ThreadContext.class});
            MethodHandle fallback = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "constantFallback", MethodType.methodType(IRubyObject.class, RubyConstantCallSite.class, AbstractScript.class, ThreadContext.class, Integer.TYPE)), 0, site);
            fallback = MethodHandles.insertArguments(fallback, 2, scopeIndex);
            MethodHandle gwt = switchPoint.guardWithTest(valueHandle, fallback);
            site.setTarget(gwt);
        } else {
            value2 = scope.getModule().callMethod(context, "const_missing", (IRubyObject)context.runtime.newSymbol(site.name()));
        }
        return value2;
    }

    public static boolean constantBooleanFallback(RubyConstantCallSite site, AbstractScript script, ThreadContext context, int scopeIndex) {
        SwitchPoint switchPoint = (SwitchPoint)context.runtime.getConstantInvalidator().getData();
        StaticScope scope = script.getScope(scopeIndex);
        IRubyObject value2 = scope.getConstant(site.name());
        if (value2 != null) {
            if (RubyInstanceConfig.LOG_INDY_CONSTANTS) {
                LOG.info("constant " + site.name() + " bound directly", new Object[0]);
            }
            MethodHandle valueHandle = MethodHandles.constant(Boolean.TYPE, value2.isTrue());
            valueHandle = MethodHandles.dropArguments(valueHandle, 0, new Class[]{AbstractScript.class, ThreadContext.class});
            MethodHandle fallback = MethodHandles.insertArguments(InvokeDynamicSupport.findStatic(InvokeDynamicSupport.class, "constantBooleanFallback", MethodType.methodType(Boolean.TYPE, RubyConstantCallSite.class, AbstractScript.class, ThreadContext.class, Integer.TYPE)), 0, site);
            fallback = MethodHandles.insertArguments(fallback, 2, scopeIndex);
            MethodHandle gwt = switchPoint.guardWithTest(valueHandle, fallback);
            site.setTarget(gwt);
        } else {
            value2 = scope.getModule().callMethod(context, "const_missing", (IRubyObject)context.runtime.newSymbol(site.name()));
        }
        boolean booleanValue = value2.isTrue();
        return booleanValue;
    }

    public static RubyRegexp initRegexp(MutableCallSite site, ThreadContext context, ByteList pattern, int options2) {
        RubyRegexp regexp2 = RubyRegexp.newRegexp(context.runtime, pattern, RegexpOptions.fromEmbeddedOptions(options2));
        regexp2.setLiteral();
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(RubyRegexp.class, regexp2), 0, new Class[]{ThreadContext.class}));
        return regexp2;
    }

    public static RubySymbol initSymbol(MutableCallSite site, ThreadContext context, String symbol) {
        RubySymbol rubySymbol = context.runtime.newSymbol(symbol);
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(RubySymbol.class, rubySymbol), 0, new Class[]{ThreadContext.class}));
        return rubySymbol;
    }

    public static RubyFixnum initFixnum(MutableCallSite site, ThreadContext context, long value2) {
        RubyFixnum rubyFixnum = context.runtime.newFixnum(value2);
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(RubyFixnum.class, rubyFixnum), 0, new Class[]{ThreadContext.class}));
        return rubyFixnum;
    }

    public static RubyFloat initFloat(MutableCallSite site, ThreadContext context, double value2) {
        RubyFloat rubyFloat = context.runtime.newFloat(value2);
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(RubyFloat.class, rubyFloat), 0, new Class[]{ThreadContext.class}));
        return rubyFloat;
    }

    public static StaticScope initStaticScope(MutableCallSite site, AbstractScript script, ThreadContext context, StaticScope parent, String staticScope, int index2) {
        StaticScope scope = script.getScope(context, parent, staticScope, index2);
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(StaticScope.class, scope), 0, AbstractScript.class, ThreadContext.class, StaticScope.class));
        return scope;
    }

    public static StaticScope loadStaticScope(MutableCallSite site, AbstractScript script, int index2) {
        StaticScope scope = script.getScope(index2);
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(StaticScope.class, scope), 0, new Class[]{AbstractScript.class}));
        return scope;
    }

    public static RubyString newString(ThreadContext context, ByteList contents, int codeRange) {
        return RubyString.newStringShared(context.runtime, contents, codeRange);
    }

    public static RubyEncoding initEncoding(MutableCallSite site, ThreadContext context, Encoding encoding2) {
        RubyEncoding rubyEncoding = context.runtime.getEncodingService().getEncoding(encoding2);
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(RubyEncoding.class, rubyEncoding), 0, new Class[]{ThreadContext.class}));
        return rubyEncoding;
    }

    public static BlockBody initBlockBody(MutableCallSite site, Object scriptObject, ThreadContext context, StaticScope scope, String descriptor) {
        BlockBody body = RuntimeHelpers.createCompiledBlockBody(context, scriptObject, scope, descriptor);
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(BlockBody.class, body), 0, Object.class, ThreadContext.class, StaticScope.class));
        return body;
    }

    public static BlockBody initBlockBody19(MutableCallSite site, Object scriptObject, ThreadContext context, StaticScope scope, String descriptor) {
        BlockBody body = RuntimeHelpers.createCompiledBlockBody19(context, scriptObject, scope, descriptor);
        site.setTarget(MethodHandles.dropArguments(MethodHandles.constant(BlockBody.class, body), 0, Object.class, ThreadContext.class, StaticScope.class));
        return body;
    }

    public static boolean methodMissing(CacheEntry entry, CallType callType, String name2, IRubyObject caller2) {
        DynamicMethod method2 = entry.method;
        return method2.isUndefined() || callType == CallType.NORMAL && !name2.equals("method_missing") && !method2.isCallableFrom(caller2, callType);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, args2, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, block);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg2, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject[] args2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, args2, block);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, block);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, (RubyModule)self.getMetaClass(), name2, arg0, arg1, block);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, self.getMetaClass(), name2, arg0, arg1, arg2, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(CacheEntry entry, CallType callType, ThreadContext context, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return RuntimeHelpers.selectMethodMissing(context, self, entry.method.getVisibility(), name2, callType).call(context, self, self.getMetaClass(), name2, arg0, arg1, arg2, block);
    }

    public static RubyClass pollAndGetClass(ThreadContext context, IRubyObject self) {
        context.callThreadPoll();
        RubyClass selfType = ((RubyBasicObject)self).getMetaClass();
        return selfType;
    }

    public static IRubyObject handleBreakJump(JumpException.BreakJump bj, ThreadContext context) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    public static IRubyObject handleBreakJump(JumpException.BreakJump bj, CacheEntry entry, ThreadContext context, IRubyObject caller2, IRubyObject self, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    public static IRubyObject handleBreakJump(ThreadContext context, JumpException.BreakJump bj) throws JumpException.BreakJump {
        if (context.getFrameJumpTarget() == bj.getTarget()) {
            return (IRubyObject)bj.getValue();
        }
        throw bj;
    }

    public static IRubyObject retryJumpError(ThreadContext context) {
        throw context.runtime.newLocalJumpError(RubyLocalJumpError.Reason.RETRY, context.runtime.getNil(), "retry outside of rescue not supported");
    }

    public static MethodHandle findStatic(Class target, String name2, MethodType type2) {
        try {
            return MethodHandles.lookup().findStatic(target, name2, type2);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
        catch (IllegalAccessException nae) {
            throw new RuntimeException(nae);
        }
    }

    public static MethodHandle findVirtual(Class target, String name2, MethodType type2) {
        try {
            return MethodHandles.lookup().findVirtual(target, name2, type2);
        }
        catch (NoSuchMethodException nsme) {
            throw new RuntimeException(nsme);
        }
        catch (IllegalAccessException nae) {
            throw new RuntimeException(nae);
        }
    }

    private static String extractSourceInfo(VariableSite site) {
        return " (" + site.file() + ":" + site.line() + ")";
    }
}

