/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.atomic.AtomicInteger;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyComparable;
import org.jruby.RubyEnumerator;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyMethod;
import org.jruby.anno.JRubyModule;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.BlockCallback;
import org.jruby.runtime.CallBlock;
import org.jruby.runtime.CallBlock19;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaInternalBlockBody;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.builtin.InternalVariables;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.TypeConverter;

@JRubyModule(name={"Enumerable"})
public class RubyEnumerable {
    public static RubyModule createEnumerableModule(Ruby runtime) {
        RubyModule enumModule = runtime.defineModule("Enumerable");
        runtime.setEnumerable(enumModule);
        enumModule.defineAnnotatedMethods(RubyEnumerable.class);
        return enumModule;
    }

    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", CallBlock.newCallClosure(self2, runtime.getEnumerable(), Arity.OPTIONAL, callback, context));
    }

    public static IRubyObject callEach19(Ruby runtime, ThreadContext context, IRubyObject self2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", CallBlock19.newCallClosure(self2, runtime.getEnumerable(), Arity.OPTIONAL, callback, context));
    }

    @Deprecated
    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject[] args2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(self2, runtime.getEnumerable(), Arity.OPTIONAL, callback, context));
    }

    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self2, Arity arity2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", CallBlock.newCallClosure(self2, runtime.getEnumerable(), arity2, callback, context));
    }

    public static IRubyObject callEach19(Ruby runtime, ThreadContext context, IRubyObject self2, Arity arity2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", CallBlock19.newCallClosure(self2, runtime.getEnumerable(), arity2, callback, context));
    }

    public static IRubyObject each(ThreadContext context, IRubyObject self2, BlockBody body) {
        Block block = new Block(body, context.currentBinding(self2, Visibility.PUBLIC));
        return Helpers.invoke(context, self2, "each", block);
    }

    @Deprecated
    public static IRubyObject callEach(Ruby runtime, ThreadContext context, IRubyObject self2, IRubyObject[] args2, Arity arity2, BlockCallback callback) {
        return Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(self2, runtime.getEnumerable(), arity2, callback, context));
    }

    private static void checkContext(ThreadContext firstContext, ThreadContext secondContext, String name2) {
        if (firstContext != secondContext) {
            throw secondContext.runtime.newThreadError("Enumerable#" + name2 + " cannot be parallelized");
        }
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject count18(ThreadContext context, IRubyObject self2, Block block) {
        if (!block.isGiven() && self2.respondsTo("size")) {
            return self2.callMethod(context, "size");
        }
        return RubyEnumerable.countCommon(context, self2, block, Arity.OPTIONAL);
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject count(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.countCommon(context, self2, block, block.arity());
    }

    private static IRubyObject countCommon(ThreadContext context, IRubyObject self2, final Block block, Arity callbackArity) {
        Ruby runtime = context.runtime;
        final int[] result2 = new int[]{0};
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject packedArgs = RubyEnumerable.packEnumValues(ctx.runtime, largs);
                    if (block.yield(ctx, packedArgs).isTrue()) {
                        result2[0] = result2[0] + 1;
                    }
                    return ctx.nil;
                }
            });
        } else {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, "Enumerable#count", Arity.NO_ARGUMENTS){

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject unusedValue) {
                    result2[0] = result2[0] + 1;
                    return context.nil;
                }
            });
        }
        return RubyFixnum.newFixnum(runtime, result2[0]);
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject count18(ThreadContext context, IRubyObject self2, IRubyObject methodArg, Block block) {
        return RubyEnumerable.count(context, self2, methodArg, block);
    }

    @JRubyMethod(name={"count"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject count(ThreadContext context, IRubyObject self2, final IRubyObject methodArg, Block block) {
        final Ruby runtime = context.runtime;
        final int[] result2 = new int[]{0};
        if (block.isGiven()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, "Enumerable#count", Arity.ONE_REQUIRED){

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject blockArg) {
                if (blockArg.equals(methodArg)) {
                    result2[0] = result2[0] + 1;
                }
                return runtime.getNil();
            }
        });
        return RubyFixnum.newFixnum(runtime, result2[0]);
    }

    @JRubyMethod
    public static IRubyObject cycle(ThreadContext context, IRubyObject self2, Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self2, "cycle");
        }
        return RubyEnumerable.cycleCommon(context, self2, -1L, block);
    }

    @JRubyMethod
    public static IRubyObject cycle(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        if (arg2.isNil()) {
            return RubyEnumerable.cycle(context, self2, block);
        }
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self2, "cycle", arg2);
        }
        long times2 = RubyNumeric.num2long(arg2);
        if (times2 <= 0L) {
            return context.nil;
        }
        return RubyEnumerable.cycleCommon(context, self2, times2, block);
    }

    private static IRubyObject cycleCommon(ThreadContext context, IRubyObject self2, long nv, final Block block) {
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, Arity.OPTIONAL){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                RubyArray rubyArray = result2;
                synchronized (rubyArray) {
                    result2.append(arg2);
                }
                block.yield(context, arg2);
                return context.nil;
            }
        });
        int length2 = result2.size();
        if (length2 == 0) {
            return context.nil;
        }
        while (nv < 0L || 0L < --nv) {
            for (int i2 = 0; i2 < length2; ++i2) {
                block.yield(context, result2.eltInternal(i2));
            }
        }
        return context.nil;
    }

    @JRubyMethod(name={"take"})
    public static IRubyObject take(ThreadContext context, IRubyObject self2, IRubyObject n, Block block) {
        Ruby runtime = context.runtime;
        final long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime.newArgumentError("attempt to take negative size");
        }
        if (len == 0L) {
            return runtime.newEmptyArray();
        }
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, Arity.ONE_REQUIRED){
                long i;
                {
                    super(runtime, arity2);
                    this.i = len;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(arg2);
                        if (--this.i == 0L) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                    }
                    return context.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"take_while"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject take_while18(ThreadContext context, IRubyObject self2, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self2, "take_while");
        }
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, Arity.OPTIONAL){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    if (!block.yield(context, arg2).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(arg2);
                    }
                    return context.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"take_while"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject take_while19(ThreadContext context, IRubyObject self2, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self2, "take_while");
        }
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject val;
                    IRubyObject larg;
                    boolean ary = false;
                    switch (largs.length) {
                        case 0: {
                            larg = ctx.nil;
                            break;
                        }
                        case 1: {
                            larg = largs[0];
                            break;
                        }
                        default: {
                            larg = RubyArray.newArrayNoCopy(ctx.runtime, largs);
                            ary = true;
                        }
                    }
                    IRubyObject iRubyObject = val = ary ? block.yieldArray(ctx, larg, null, null) : block.yield(ctx, larg);
                    if (!val.isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"drop"})
    public static IRubyObject drop(ThreadContext context, IRubyObject self2, IRubyObject n, Block block) {
        Ruby runtime = context.runtime;
        final long len = RubyNumeric.num2long(n);
        if (len < 0L) {
            throw runtime.newArgumentError("attempt to drop negative size");
        }
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, Arity.ONE_ARGUMENT){
                long i;
                {
                    super(runtime, arity2);
                    this.i = len;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        if (this.i == 0L) {
                            result2.append(arg2);
                        } else {
                            --this.i;
                        }
                    }
                    return context.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod
    public static IRubyObject drop_while(ThreadContext context, IRubyObject self2, final Block block) {
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(context.runtime, self2, "drop_while");
        }
        final Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, "Enumerable#drop_while", Arity.OPTIONAL){
                boolean memo;
                {
                    super(runtime2, originalContext, methodName, arity2);
                    this.memo = false;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    if (!this.memo && !block.yield(context, arg2).isTrue()) {
                        this.memo = true;
                    }
                    if (this.memo) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(arg2);
                        }
                    }
                    return runtime.getNil();
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first(ThreadContext context, IRubyObject self2) {
        final IRubyObject[] holder = new IRubyObject[]{context.nil};
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(context.runtime, context, null, Arity.ONE_REQUIRED){

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    holder[0] = arg2;
                    throw JumpException.SPECIAL_JUMP;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return holder[0];
    }

    @JRubyMethod(name={"first"})
    public static IRubyObject first(ThreadContext context, IRubyObject self2, final IRubyObject num) {
        int firstCount = RubyNumeric.fix2int(num);
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        if (firstCount < 0) {
            throw runtime.newArgumentError("negative index");
        }
        if (firstCount == 0) {
            return result2;
        }
        try {
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, null, Arity.ONE_REQUIRED){
                private int iter;
                {
                    super(runtime, originalContext, methodName, arity2);
                    this.iter = RubyNumeric.fix2int(num);
                }

                @Override
                public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                    result2.append(arg2);
                    if (this.iter-- == 1) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return context.nil;
                }
            });
        }
        catch (JumpException.SpecialJump specialJump) {
            // empty catch block
        }
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject to_a(ThreadContext context, IRubyObject self2) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, (BlockCallback)new AppendBlockCallback(result2));
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, rest=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject to_a(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(self2, runtime.getEnumerable(), Arity.OPTIONAL, new AppendBlockCallback(result2), context));
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_a19(ThreadContext context, IRubyObject self2) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, (BlockCallback)new AppendBlockCallback(result2));
        result2.infectBy(self2);
        return result2;
    }

    @JRubyMethod(name={"to_a", "entries"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject to_a19(ThreadContext context, IRubyObject self2, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        Helpers.invoke(context, self2, "each", args2, CallBlock.newCallClosure(self2, runtime.getEnumerable(), Arity.OPTIONAL, new AppendBlockCallback(result2), context));
        result2.infectBy(self2);
        return result2;
    }

    @JRubyMethod
    public static IRubyObject sort(ThreadContext context, IRubyObject self2, Block block) {
        Ruby runtime = context.runtime;
        RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, (BlockCallback)new AppendBlockCallback(result2));
        result2.sort_bang(context, block);
        return result2;
    }

    public static IRubyObject sort_byCommon(final ThreadContext context, IRubyObject self2, final Block block) {
        IRubyObject[][] valuesAndCriteria;
        Ruby runtime = context.runtime;
        if (self2 instanceof RubyArray) {
            RubyArray selfArray = (RubyArray)self2;
            final IRubyObject[][] valuesAndCriteriaArray = new IRubyObject[selfArray.size()][2];
            RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, Arity.OPTIONAL){
                AtomicInteger i;
                {
                    super(runtime, arity2);
                    this.i = new AtomicInteger(0);
                }

                @Override
                public IRubyObject yield(ThreadContext ctx, IRubyObject arg2) {
                    IRubyObject[] myVandC = valuesAndCriteriaArray[this.i.getAndIncrement()];
                    myVandC[0] = arg2;
                    myVandC[1] = block.yield(ctx, arg2);
                    return ctx.nil;
                }
            });
            valuesAndCriteria = valuesAndCriteriaArray;
        } else {
            final ArrayList valuesAndCriteriaList = new ArrayList();
            RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject[] myVandC = new IRubyObject[]{larg, block.yield(ctx, larg)};
                    valuesAndCriteriaList.add(myVandC);
                    return ctx.nil;
                }
            });
            valuesAndCriteria = (IRubyObject[][])valuesAndCriteriaList.toArray((T[])new IRubyObject[valuesAndCriteriaList.size()][]);
        }
        Arrays.sort(valuesAndCriteria, new Comparator<IRubyObject[]>(){

            @Override
            public int compare(IRubyObject[] o1, IRubyObject[] o2) {
                return RubyComparable.cmpint(context, Helpers.invokedynamic(context, o1[1], MethodNames.OP_CMP, o2[1]), o1[1], o2[1]);
            }
        });
        IRubyObject[] dstArray = new IRubyObject[valuesAndCriteria.length];
        for (int i2 = 0; i2 < dstArray.length; ++i2) {
            dstArray[i2] = valuesAndCriteria[i2][0];
        }
        return runtime.newArrayNoCopy(dstArray);
    }

    @JRubyMethod
    public static IRubyObject sort_by(ThreadContext context, IRubyObject self2, Block block) {
        return block.isGiven() ? RubyEnumerable.sort_byCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "sort_by");
    }

    @JRubyMethod
    public static IRubyObject grep(ThreadContext context, IRubyObject self2, final IRubyObject pattern, final Block block) {
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (pattern.callMethod(ctx, "===", larg).isTrue()) {
                        IRubyObject value2 = block.yield(ctx, larg);
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(value2);
                        }
                    }
                    return ctx.nil;
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (pattern.callMethod(ctx, "===", larg).isTrue()) {
                        RubyArray rubyArray = result2;
                        synchronized (rubyArray) {
                            result2.append(larg);
                        }
                    }
                    return ctx.nil;
                }
            });
        }
        return result2;
    }

    public static IRubyObject detectCommon(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.detectCommon(context, self2, null, block);
    }

    public static IRubyObject detectCommon(final ThreadContext context, IRubyObject self2, IRubyObject ifnone, final Block block) {
        Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null};
        try {
            RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    RubyEnumerable.checkContext(context, ctx, "detect/find");
                    if (block.yield(ctx, larg).isTrue()) {
                        result2[0] = larg;
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return result2[0];
        }
        return ifnone != null ? ifnone.callMethod(context, "call") : runtime.getNil();
    }

    @JRubyMethod
    public static IRubyObject detect(ThreadContext context, IRubyObject self2, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, null, block);
        }
        return block.isGiven() ? RubyEnumerable.detectCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "detect");
    }

    @JRubyMethod
    public static IRubyObject detect(ThreadContext context, IRubyObject self2, IRubyObject ifnone, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, ifnone, block);
        }
        return block.isGiven() ? RubyEnumerable.detectCommon(context, self2, ifnone, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "detect", ifnone);
    }

    @JRubyMethod
    public static IRubyObject find(ThreadContext context, IRubyObject self2, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, null, block);
        }
        return blockGiven ? RubyEnumerable.detectCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "find");
    }

    @JRubyMethod
    public static IRubyObject find(ThreadContext context, IRubyObject self2, IRubyObject ifnone, Block block) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find(context, ifnone, block);
        }
        return blockGiven ? RubyEnumerable.detectCommon(context, self2, ifnone, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "find", ifnone);
    }

    @JRubyMethod(name={"find_index"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject find_index(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.find_index(context, self2, block, Arity.OPTIONAL);
    }

    @JRubyMethod(name={"find_index"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject find_index19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.find_index(context, self2, block, block.arity());
    }

    public static IRubyObject find_index(ThreadContext context, IRubyObject self2, Block block, Arity callbackArity) {
        boolean blockGiven = block.isGiven();
        if (self2 instanceof RubyArray && blockGiven) {
            return ((RubyArray)self2).find_index(context, block);
        }
        return blockGiven ? RubyEnumerable.find_indexCommon(context, self2, block, callbackArity) : RubyEnumerator.enumeratorize(context.runtime, self2, "find_index");
    }

    @JRubyMethod(name={"find_index"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject find_index19(ThreadContext context, IRubyObject self2, IRubyObject cond, Block block) {
        return RubyEnumerable.find_index(context, self2, cond, block);
    }

    @JRubyMethod(name={"find_index"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject find_index(ThreadContext context, IRubyObject self2, IRubyObject cond, Block block) {
        Ruby runtime = context.runtime;
        if (block.isGiven()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        if (self2 instanceof RubyArray) {
            return ((RubyArray)self2).find_index(context, cond);
        }
        return RubyEnumerable.find_indexCommon(context, self2, cond);
    }

    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self2, final Block block, Arity callbackArity) {
        Ruby runtime = context.runtime;
        final long[] result2 = new long[]{0L};
        try {
            RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (block.yield(ctx, larg).isTrue()) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2[0] = result2[0] + 1L;
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime, result2[0]);
        }
        return context.nil;
    }

    public static IRubyObject find_indexCommon(ThreadContext context, IRubyObject self2, final IRubyObject cond) {
        Ruby runtime = context.runtime;
        final long[] result2 = new long[]{0L};
        try {
            RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_ARGUMENT, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    if (RubyObject.equalInternal(ctx, larg, cond)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    result2[0] = result2[0] + 1L;
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return RubyFixnum.newFixnum(runtime, result2[0]);
        }
        return context.nil;
    }

    public static IRubyObject selectCommon(ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                if (block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                }
                return ctx.nil;
            }
        });
        return result2;
    }

    @JRubyMethod
    public static IRubyObject select(ThreadContext context, IRubyObject self2, Block block) {
        return block.isGiven() ? RubyEnumerable.selectCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "select");
    }

    @JRubyMethod
    public static IRubyObject find_all(ThreadContext context, IRubyObject self2, Block block) {
        return block.isGiven() ? RubyEnumerable.selectCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "find_all");
    }

    public static IRubyObject rejectCommon(ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                if (!block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(larg);
                    }
                }
                return ctx.nil;
            }
        });
        return result2;
    }

    @JRubyMethod
    public static IRubyObject reject(ThreadContext context, IRubyObject self2, Block block) {
        return block.isGiven() ? RubyEnumerable.rejectCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "reject");
    }

    @JRubyMethod(name={"collect", "map"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject collect(ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        final RubyArray result2 = runtime.newArray();
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject value2 = block.yield(ctx, larg);
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(value2);
                    }
                    return ctx.nil;
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_ARGUMENT, (BlockCallback)new AppendBlockCallback(result2));
        }
        return result2;
    }

    @JRubyMethod(name={"collect"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject collect19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.collectCommon19(context, self2, block, "collect");
    }

    @JRubyMethod(name={"map"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject map19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.collectCommon19(context, self2, block, "map");
    }

    private static IRubyObject collectCommon19(ThreadContext context, IRubyObject self2, final Block block, String methodName) {
        Ruby runtime = context.runtime;
        if (block.isGiven()) {
            final RubyArray result2 = runtime.newArray();
            RubyEnumerable.callEach19(runtime, context, self2, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg;
                    boolean ary = false;
                    switch (largs.length) {
                        case 0: {
                            larg = ctx.nil;
                            break;
                        }
                        case 1: {
                            larg = largs[0];
                            break;
                        }
                        default: {
                            larg = RubyArray.newArrayNoCopy(ctx.runtime, largs);
                            ary = true;
                        }
                    }
                    IRubyObject val = ary ? block.yieldArray(ctx, larg, null, null) : block.yield(ctx, larg);
                    RubyArray rubyArray = result2;
                    synchronized (rubyArray) {
                        result2.append(val);
                    }
                    return ctx.nil;
                }
            });
            return result2;
        }
        return RubyEnumerator.enumeratorize(runtime, self2, methodName);
    }

    public static IRubyObject collectCommon(ThreadContext context, Ruby runtime, IRubyObject self2, RubyArray result2, Block block, BlockCallback blockCallback) {
        RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_ARGUMENT, blockCallback);
        return result2;
    }

    @JRubyMethod(name={"flat_map"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject flat_map19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.flatMapCommon19(context, self2, block, "flat_map");
    }

    @JRubyMethod(name={"collect_concat"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject collect_concat19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.flatMapCommon19(context, self2, block, "collect_concat");
    }

    private static IRubyObject flatMapCommon19(ThreadContext context, IRubyObject self2, final Block block, String methodName) {
        Ruby runtime = context.runtime;
        if (block.isGiven()) {
            final RubyArray ary = runtime.newArray();
            RubyEnumerable.callEach(runtime, context, self2, block.arity(), new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject i2 = block.yield(ctx, larg);
                    IRubyObject tmp = i2.checkArrayType();
                    RubyArray rubyArray = ary;
                    synchronized (rubyArray) {
                        if (tmp.isNil()) {
                            ary.append(i2);
                        } else {
                            ary.concat(tmp);
                        }
                    }
                    return ctx.nil;
                }
            });
            return ary;
        }
        return RubyEnumerator.enumeratorize(runtime, self2, methodName);
    }

    public static IRubyObject injectCommon(final ThreadContext context, IRubyObject self2, IRubyObject init, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{init};
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyEnumerable.checkContext(context, ctx, "inject");
                result2[0] = result2[0] == null ? larg : block.yieldArray(ctx, runtime.newArray(result2[0], larg), null, null);
                return ctx.nil;
            }
        });
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.injectCommon(context, self2, null, block);
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.injectCommon(context, self2, arg2, block) : RubyEnumerable.inject(context, self2, null, arg2, block);
    }

    @JRubyMethod(name={"inject", "reduce"})
    public static IRubyObject inject(ThreadContext context, IRubyObject self2, IRubyObject init, IRubyObject method2, Block block) {
        Ruby runtime = context.runtime;
        if (block.isGiven()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.BLOCK_UNUSED, "given block not used");
        }
        final String methodId = method2.asJavaString();
        final IRubyObject[] result2 = new IRubyObject[]{init};
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                result2[0] = result2[0] == null ? larg : result2[0].callMethod(ctx, methodId, larg);
                return ctx.nil;
            }
        });
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    public static IRubyObject partitionCommon(ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        final RubyArray arr_true = runtime.newArray();
        final RubyArray arr_false = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                if (block.yield(ctx, larg).isTrue()) {
                    RubyArray rubyArray = arr_true;
                    synchronized (rubyArray) {
                        arr_true.append(larg);
                    }
                }
                RubyArray rubyArray = arr_false;
                synchronized (rubyArray) {
                    arr_false.append(larg);
                }
                return ctx.nil;
            }
        });
        return runtime.newArray((IRubyObject)arr_true, (IRubyObject)arr_false);
    }

    @JRubyMethod(name={"partition"})
    public static IRubyObject partition(ThreadContext context, IRubyObject self2, Block block) {
        return block.isGiven() ? RubyEnumerable.partitionCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "partition");
    }

    private static IRubyObject packEnumValues(Ruby runtime, IRubyObject[] args2) {
        if (args2.length < 2) {
            return args2.length == 0 ? runtime.getNil() : args2[0];
        }
        return runtime.newArrayNoCopy(args2);
    }

    static IRubyObject packEnumValues(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            case 0: {
                return context.nil;
            }
            case 1: {
                return args2[0];
            }
        }
        return RubyArray.newArrayNoCopy(context.runtime, args2);
    }

    public static IRubyObject each_with_indexCommon(ThreadContext context, IRubyObject self2, Block block) {
        RubyEnumerable.callEach(context.runtime, context, self2, Arity.OPTIONAL, (BlockCallback)new EachWithIndex(block));
        return self2;
    }

    public static IRubyObject each_with_indexCommon19(ThreadContext context, IRubyObject self2, Block block, IRubyObject[] args2) {
        RubyEnumerable.callEach(context.runtime, context, self2, args2, Arity.OPTIONAL, new EachWithIndex(block));
        return self2;
    }

    public static IRubyObject each_with_objectCommon19(ThreadContext context, IRubyObject self2, final Block block, final IRubyObject arg2) {
        final Ruby runtime = context.runtime;
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return block.call(ctx, new IRubyObject[]{runtime.newArray(RubyEnumerable.packEnumValues(ctx, largs), arg2)});
            }
        });
        return arg2;
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_8)
    public static IRubyObject each_with_index(ThreadContext context, IRubyObject self2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "each_with_index");
    }

    @JRubyMethod(name={"each_with_index"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_with_index19(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon19(context, self2, block, args2) : RubyEnumerator.enumeratorize(context.runtime, self2, "each_with_index", args2);
    }

    @JRubyMethod
    public static IRubyObject enum_with_index(ThreadContext context, IRubyObject self2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_indexCommon(context, self2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "enum_with_index");
    }

    @JRubyMethod(required=1, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_with_object(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon19(context, self2, block, arg2) : RubyEnumerator.enumeratorize(context.runtime, self2, "each_with_object", arg2);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject with_object(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_with_objectCommon19(context, self2, block, arg2) : RubyEnumerator.enumeratorize(context.runtime, self2, "with_object", arg2);
    }

    @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject each_entry(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_entryCommon(context, self2, args2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "each_entry", args2);
    }

    public static IRubyObject each_entryCommon(ThreadContext context, IRubyObject self2, IRubyObject[] args2, final Block block) {
        RubyEnumerable.callEach(context.runtime, context, self2, args2, Arity.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                return block.yieldSpecific(ctx, RubyEnumerable.packEnumValues(ctx, largs));
            }
        });
        return self2;
    }

    public static IRubyObject each_slice(ThreadContext context, IRubyObject self2, IRubyObject arg2, final Block block) {
        final int size2 = RubyNumeric.num2int(arg2);
        final Ruby runtime = context.runtime;
        if (size2 <= 0) {
            throw runtime.newArgumentError("invalid slice size");
        }
        final RubyArray[] result2 = new RubyArray[]{runtime.newArray(size2)};
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                result2[0].append(RubyEnumerable.packEnumValues(ctx, largs));
                if (result2[0].size() == size2) {
                    block.yield(ctx, result2[0]);
                    result2[0] = runtime.newArray(size2);
                }
                return ctx.nil;
            }
        });
        if (result2[0].size() > 0) {
            block.yield(context, result2[0]);
        }
        return context.nil;
    }

    @JRubyMethod(name={"each_slice"})
    public static IRubyObject each_slice19(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_slice(context, self2, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "each_slice", arg2);
    }

    @JRubyMethod(name={"enum_slice"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject enum_slice(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_slice(context, self2, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "enum_slice", arg2);
    }

    public static IRubyObject each_cons(ThreadContext context, IRubyObject self2, IRubyObject arg2, final Block block) {
        final int size2 = (int)RubyNumeric.num2long(arg2);
        Ruby runtime = context.runtime;
        if (size2 <= 0) {
            throw runtime.newArgumentError("invalid size");
        }
        final RubyArray result2 = runtime.newArray(size2);
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                if (result2.size() == size2) {
                    result2.shift(ctx);
                }
                result2.append(RubyEnumerable.packEnumValues(ctx, largs));
                if (result2.size() == size2) {
                    block.yield(ctx, result2.aryDup());
                }
                return ctx.nil;
            }
        });
        return context.nil;
    }

    @JRubyMethod(name={"each_cons"})
    public static IRubyObject each_cons19(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_cons(context, self2, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "each_cons", arg2);
    }

    @JRubyMethod(name={"enum_cons"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject enum_cons(ThreadContext context, IRubyObject self2, IRubyObject arg2, Block block) {
        return block.isGiven() ? RubyEnumerable.each_cons(context, self2, arg2, block) : RubyEnumerator.enumeratorize(context.runtime, self2, "enum_cons", arg2);
    }

    @JRubyMethod
    public static IRubyObject reverse_each(ThreadContext context, IRubyObject self2, Block block) {
        return block.isGiven() ? RubyEnumerable.reverse_eachInternal(context, self2, RubyEnumerable.to_a(context, self2), block) : RubyEnumerator.enumeratorize(context.runtime, self2, "reverse_each");
    }

    @JRubyMethod(rest=true)
    public static IRubyObject reverse_each(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return block.isGiven() ? RubyEnumerable.reverse_eachInternal(context, self2, RubyEnumerable.to_a(context, self2, args2), block) : RubyEnumerator.enumeratorize(context.runtime, self2, "reverse_each", args2);
    }

    private static IRubyObject reverse_eachInternal(ThreadContext context, IRubyObject self2, IRubyObject obj, Block block) {
        ((RubyArray)obj).reverse_each(context, block);
        return self2;
    }

    @JRubyMethod(name={"include?", "member?"}, required=1)
    public static IRubyObject include_p(final ThreadContext context, IRubyObject self2, final IRubyObject arg2) {
        Ruby runtime = context.runtime;
        try {
            RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    RubyEnumerable.checkContext(context, ctx, "include?/member?");
                    if (RubyObject.equalInternal(ctx, larg, arg2)) {
                        throw JumpException.SPECIAL_JUMP;
                    }
                    return ctx.nil;
                }
            });
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod
    public static IRubyObject max(final ThreadContext context, IRubyObject self2, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null};
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, block.arity(), new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    RubyEnumerable.checkContext(context, ctx, "max{}");
                    if (result2[0] == null || RubyComparable.cmpint(ctx, block.yieldArray(ctx, runtime.newArray(larg, result2[0]), null, null), larg, result2[0]) > 0) {
                        result2[0] = larg;
                    }
                    return ctx.nil;
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject[] iRubyObjectArray = result2;
                    synchronized (result2) {
                        if (result2[0] == null || RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, larg, MethodNames.OP_CMP, result2[0]), larg, result2[0]) > 0) {
                            result2[0] = larg;
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return ctx.nil;
                    }
                }
            });
        }
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    @JRubyMethod
    public static IRubyObject max_by(final ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, self2, "max_by");
        }
        final IRubyObject[] result2 = new IRubyObject[]{runtime.getNil()};
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){
            IRubyObject memo = null;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyEnumerable.checkContext(context, ctx, "max_by");
                IRubyObject v = block.yield(ctx, larg);
                if (this.memo == null || RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.memo), v, this.memo) > 0) {
                    this.memo = v;
                    result2[0] = larg;
                }
                return ctx.nil;
            }
        });
        return result2[0];
    }

    @JRubyMethod
    public static IRubyObject min(final ThreadContext context, IRubyObject self2, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null};
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, block.arity(), new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    RubyEnumerable.checkContext(context, ctx, "min{}");
                    if (result2[0] == null || RubyComparable.cmpint(ctx, block.yield(ctx, runtime.newArray(larg, result2[0])), larg, result2[0]) < 0) {
                        result2[0] = larg;
                    }
                    return ctx.nil;
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject[] iRubyObjectArray = result2;
                    synchronized (result2) {
                        if (result2[0] == null || RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, larg, MethodNames.OP_CMP, result2[0]), larg, result2[0]) < 0) {
                            result2[0] = larg;
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return ctx.nil;
                    }
                }
            });
        }
        return result2[0] == null ? runtime.getNil() : result2[0];
    }

    @JRubyMethod
    public static IRubyObject min_by(final ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, self2, "min_by");
        }
        final IRubyObject[] result2 = new IRubyObject[]{context.nil};
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){
            IRubyObject memo = null;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyEnumerable.checkContext(context, ctx, "min_by");
                IRubyObject v = block.yield(ctx, larg);
                if (this.memo == null || RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.memo), v, this.memo) < 0) {
                    this.memo = v;
                    result2[0] = larg;
                }
                return ctx.nil;
            }
        });
        return result2[0];
    }

    @JRubyMethod
    public static IRubyObject minmax(final ThreadContext context, IRubyObject self2, final Block block) {
        final Ruby runtime = context.runtime;
        final IRubyObject[] result2 = new IRubyObject[]{null, null};
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, block.arity(), new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    RubyEnumerable.checkContext(context, ctx, "minmax");
                    IRubyObject arg2 = RubyEnumerable.packEnumValues(ctx, largs);
                    if (result2[0] == null) {
                        result2[0] = result2[1] = arg2;
                    } else {
                        if (RubyComparable.cmpint(ctx, block.yield(ctx, runtime.newArray(arg2, result2[0])), arg2, result2[0]) < 0) {
                            result2[0] = arg2;
                        }
                        if (RubyComparable.cmpint(ctx, block.yield(ctx, runtime.newArray(arg2, result2[1])), arg2, result2[1]) > 0) {
                            result2[1] = arg2;
                        }
                    }
                    return ctx.nil;
                }
            });
        } else {
            RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_REQUIRED, new BlockCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject arg2 = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject[] iRubyObjectArray = result2;
                    synchronized (result2) {
                        if (result2[0] == null) {
                            result2[0] = result2[1] = arg2;
                        } else {
                            if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, arg2, MethodNames.OP_CMP, result2[0]), arg2, result2[0]) < 0) {
                                result2[0] = arg2;
                            }
                            if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, arg2, MethodNames.OP_CMP, result2[1]), arg2, result2[1]) > 0) {
                                result2[1] = arg2;
                            }
                        }
                        // ** MonitorExit[var5_5] (shouldn't be in output)
                        return ctx.nil;
                    }
                }
            });
        }
        if (result2[0] == null) {
            result2[0] = result2[1] = runtime.getNil();
        }
        return runtime.newArrayNoCopy(result2);
    }

    @JRubyMethod
    public static IRubyObject minmax_by(final ThreadContext context, IRubyObject self2, final Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, self2, "minmax_by");
        }
        final IRubyObject[] result2 = new IRubyObject[]{runtime.getNil(), runtime.getNil()};
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){
            IRubyObject minMemo = null;
            IRubyObject maxMemo = null;

            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                RubyEnumerable.checkContext(context, ctx, "minmax_by");
                IRubyObject arg2 = RubyEnumerable.packEnumValues(ctx, largs);
                IRubyObject v = block.yield(ctx, arg2);
                if (this.minMemo == null) {
                    this.minMemo = this.maxMemo = v;
                    result2[0] = result2[1] = arg2;
                } else {
                    if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.minMemo), v, this.minMemo) < 0) {
                        this.minMemo = v;
                        result2[0] = arg2;
                    }
                    if (RubyComparable.cmpint(ctx, Helpers.invokedynamic(ctx, v, MethodNames.OP_CMP, this.maxMemo), v, this.maxMemo) > 0) {
                        this.maxMemo = v;
                        result2[1] = arg2;
                    }
                }
                return ctx.nil;
            }
        });
        return runtime.newArrayNoCopy(result2);
    }

    @JRubyMethod(name={"none?"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject none_p(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.none_p(context, self2, block, Arity.OPTIONAL);
    }

    @JRubyMethod(name={"none?"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject none_p19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.none_p(context, self2, block, block.arity());
    }

    public static IRubyObject none_p(final ThreadContext context, IRubyObject self2, final Block block, Arity callbackArity) {
        Ruby runtime = context.runtime;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "none?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ctx.nil;
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "none?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ctx.nil;
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @JRubyMethod(name={"one?"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject one_p(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.one_p(context, self2, block, Arity.OPTIONAL);
    }

    @JRubyMethod(name={"one?"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject one_p19(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.one_p(context, self2, block, block.arity());
    }

    public static IRubyObject one_p(final ThreadContext context, IRubyObject self2, final Block block, Arity callbackArity) {
        Ruby runtime = context.runtime;
        final boolean[] result2 = new boolean[]{false};
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "one?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (block.yield(ctx, larg).isTrue()) {
                            if (result2[0]) {
                                throw JumpException.SPECIAL_JUMP;
                            }
                            result2[0] = true;
                        }
                        return ctx.nil;
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "one?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (larg.isTrue()) {
                            if (result2[0]) {
                                throw JumpException.SPECIAL_JUMP;
                            }
                            result2[0] = true;
                        }
                        return ctx.nil;
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return result2[0] ? runtime.getTrue() : runtime.getFalse();
    }

    @JRubyMethod(name={"all?"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject all_p(ThreadContext context, IRubyObject self2, Block block) {
        if (self2 instanceof RubyArray) {
            return ((RubyArray)self2).all_p(context, block);
        }
        return RubyEnumerable.all_pCommon(context, self2, block, Arity.OPTIONAL);
    }

    @JRubyMethod(name={"all?"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject all_p19(ThreadContext context, IRubyObject self2, Block block) {
        if (self2 instanceof RubyArray) {
            return ((RubyArray)self2).all_p(context, block);
        }
        return RubyEnumerable.all_pCommon(context, self2, block, block.arity());
    }

    public static IRubyObject all_pCommon(final ThreadContext context, IRubyObject self2, final Block block, Arity callbackArity) {
        Ruby runtime = context.runtime;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "all?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (!block.yield(ctx, larg).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ctx.nil;
                    }
                });
            } else {
                RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_REQUIRED, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        RubyEnumerable.checkContext(context, ctx, "all?");
                        IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                        if (!larg.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return ctx.nil;
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getFalse();
        }
        return runtime.getTrue();
    }

    @JRubyMethod(name={"any?"}, compat=CompatVersion.RUBY1_8)
    public static IRubyObject any_p18(ThreadContext context, IRubyObject self2, Block block) {
        if (self2 instanceof RubyArray) {
            return ((RubyArray)self2).any_p(context, block);
        }
        return RubyEnumerable.any_pCommon(context, self2, block, Arity.OPTIONAL);
    }

    @JRubyMethod(name={"any?"}, compat=CompatVersion.RUBY1_9)
    public static IRubyObject any_p(ThreadContext context, IRubyObject self2, Block block) {
        if (self2 instanceof RubyArray) {
            return ((RubyArray)self2).any_p(context, block);
        }
        return RubyEnumerable.any_pCommon(context, self2, block, block.arity());
    }

    public static IRubyObject any_pCommon(ThreadContext context, IRubyObject self2, final Block block, Arity callbackArity) {
        final Ruby runtime = context.runtime;
        try {
            if (block.isGiven()) {
                RubyEnumerable.callEach(runtime, context, self2, callbackArity, new BlockCallback(){

                    @Override
                    public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                        IRubyObject packedArgs = RubyEnumerable.packEnumValues(ctx, largs);
                        if (block.yield(ctx, packedArgs).isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            } else {
                RubyEnumerable.each(context, self2, new JavaInternalBlockBody(runtime, context, "Enumerable#any?", Arity.ONE_REQUIRED){

                    @Override
                    public IRubyObject yield(ThreadContext context, IRubyObject arg2) {
                        if (arg2.isTrue()) {
                            throw JumpException.SPECIAL_JUMP;
                        }
                        return runtime.getNil();
                    }
                });
            }
        }
        catch (JumpException.SpecialJump sj) {
            return runtime.getTrue();
        }
        return runtime.getFalse();
    }

    @JRubyMethod(rest=true, compat=CompatVersion.RUBY1_8)
    public static IRubyObject zip(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zipCommon(context, self2, args2, block);
    }

    @JRubyMethod(name={"zip"}, rest=true, compat=CompatVersion.RUBY1_9)
    public static IRubyObject zip19(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return RubyEnumerable.zipCommon19(context, self2, args2, block);
    }

    public static IRubyObject[] zipCommonConvert(Ruby runtime, IRubyObject[] args2) {
        return RubyEnumerable.zipCommonConvert(runtime, args2, "to_a");
    }

    public static IRubyObject[] zipCommonConvert(Ruby runtime, IRubyObject[] args2, String method2) {
        RubyClass array = runtime.getArray();
        ThreadContext context = runtime.getCurrentContext();
        if (runtime.is1_9()) {
            for (int i2 = 0; i2 < args2.length; ++i2) {
                IRubyObject result2 = TypeConverter.convertToTypeWithCheck19(args2[i2], array, method2);
                if (result2.isNil()) {
                    result2 = RubyEnumerable.takeItems(context, args2[i2]);
                }
                args2[i2] = result2;
            }
        } else {
            for (int i3 = 0; i3 < args2.length; ++i3) {
                args2[i3] = TypeConverter.convertToType(args2[i3], array, method2);
            }
        }
        return args2;
    }

    public static IRubyObject zipCommon(ThreadContext context, IRubyObject self2, IRubyObject[] aArgs, Block block) {
        Ruby runtime = context.runtime;
        IRubyObject[] args2 = RubyEnumerable.zipCommonConvert(runtime, aArgs);
        return RubyEnumerable.zipCommonAry(context, self2, args2, block);
    }

    public static IRubyObject zipCommon19(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        Ruby runtime = context.runtime;
        int aLen = args2.length + 1;
        RubyClass array = runtime.getArray();
        IRubyObject[] newArgs = new IRubyObject[args2.length];
        boolean hasUncoercible = false;
        for (int i2 = 0; i2 < args2.length; ++i2) {
            newArgs[i2] = TypeConverter.convertToType(args2[i2], array, "to_ary", false);
            if (!newArgs[i2].isNil()) continue;
            hasUncoercible = true;
        }
        if (hasUncoercible) {
            RubySymbol each2 = runtime.newSymbol("each");
            for (int i3 = 0; i3 < args2.length; ++i3) {
                newArgs[i3] = args2[i3].callMethod(context, "to_enum", each2);
            }
        }
        if (hasUncoercible) {
            return RubyEnumerable.zipCommonEnum(context, self2, newArgs, block);
        }
        return RubyEnumerable.zipCommonAry(context, self2, newArgs, block);
    }

    public static IRubyObject zipCommonAry(ThreadContext context, IRubyObject self2, final IRubyObject[] args2, final Block block) {
        final Ruby runtime = context.runtime;
        final int len = args2.length + 1;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, block.arity(), new BlockCallback(){
                AtomicInteger ix = new AtomicInteger(0);

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    RubyArray array = runtime.newArray(len);
                    int myIx = this.ix.getAndIncrement();
                    array.append(larg);
                    int j = args2.length;
                    for (int i2 = 0; i2 < j; ++i2) {
                        array.append(((RubyArray)args2[i2]).entry(myIx));
                    }
                    block.yield(ctx, array);
                    return runtime.getNil();
                }
            });
            return runtime.getNil();
        }
        final RubyArray zip2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_REQUIRED, new BlockCallback(){
            AtomicInteger ix = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyArray array = runtime.newArray(len);
                array.append(larg);
                int myIx = this.ix.getAndIncrement();
                int j = args2.length;
                for (int i2 = 0; i2 < j; ++i2) {
                    array.append(((RubyArray)args2[i2]).entry(myIx));
                }
                RubyArray rubyArray = zip2;
                synchronized (rubyArray) {
                    zip2.append(array);
                }
                return runtime.getNil();
            }
        });
        return zip2;
    }

    public static IRubyObject zipCommonEnum(ThreadContext context, IRubyObject self2, final IRubyObject[] args2, final Block block) {
        final Ruby runtime = context.runtime;
        final int len = args2.length + 1;
        if (block.isGiven()) {
            RubyEnumerable.callEach(runtime, context, self2, block.arity(), new BlockCallback(){
                AtomicInteger ix = new AtomicInteger(0);

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    RubyArray array = runtime.newArray(len);
                    int myIx = this.ix.getAndIncrement();
                    array.append(larg);
                    int j = args2.length;
                    for (int i2 = 0; i2 < j; ++i2) {
                        array.append(RubyEnumerable.zipEnumNext(ctx, args2[i2]));
                    }
                    block.yield(ctx, array);
                    return runtime.getNil();
                }
            });
            return runtime.getNil();
        }
        final RubyArray zip2 = runtime.newArray();
        RubyEnumerable.callEach(runtime, context, self2, Arity.ONE_REQUIRED, new BlockCallback(){
            AtomicInteger ix = new AtomicInteger(0);

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                RubyArray array = runtime.newArray(len);
                array.append(larg);
                int myIx = this.ix.getAndIncrement();
                int j = args2.length;
                for (int i2 = 0; i2 < j; ++i2) {
                    array.append(RubyEnumerable.zipEnumNext(ctx, args2[i2]));
                }
                RubyArray rubyArray = zip2;
                synchronized (rubyArray) {
                    zip2.append(array);
                }
                return runtime.getNil();
            }
        });
        return zip2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IRubyObject takeItems(ThreadContext context, IRubyObject enumerable) {
        RubyArray array;
        RubyArray rubyArray = array = context.runtime.newArray();
        synchronized (rubyArray) {
            RubyEnumerable.callEach(context.runtime, context, enumerable, Arity.ONE_ARGUMENT, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    array.append(larg);
                    return larg;
                }
            });
        }
        return array;
    }

    public static IRubyObject zipEnumNext(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg2.isNil()) {
            return context.nil;
        }
        try {
            return arg2.callMethod(context, "next");
        }
        catch (RaiseException re) {
            if (re.getException().getMetaClass() == runtime.getStopIteration()) {
                return context.nil;
            }
            throw re;
        }
    }

    @JRubyMethod
    public static IRubyObject group_by(ThreadContext context, IRubyObject self2, final Block block) {
        final Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            return RubyEnumerator.enumeratorize(runtime, self2, "group_by");
        }
        final RubyHash result2 = new RubyHash(runtime);
        RubyEnumerable.callEach(runtime, context, self2, Arity.OPTIONAL, new BlockCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                IRubyObject key2 = block.yield(ctx, larg);
                RubyHash rubyHash = result2;
                synchronized (rubyHash) {
                    RubyArray curr = (RubyArray)result2.fastARef(key2);
                    if (curr == null) {
                        curr = runtime.newArray();
                        result2.fastASet(key2, curr);
                    }
                    curr.append(larg);
                }
                return runtime.getNil();
            }
        });
        return result2;
    }

    @Deprecated
    public static IRubyObject chunk(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        switch (Arity.checkArgumentCount(context.runtime, args2, 0, 1)) {
            case 0: {
                return RubyEnumerable.chunk(context, self2, block);
            }
            case 1: {
                return RubyEnumerable.chunk(context, self2, args2[0], block);
            }
        }
        throw context.runtime.newArgumentError(args2.length, 0);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject chunk(ThreadContext context, IRubyObject self2, Block block) {
        return RubyEnumerable.chunk(context, self2, context.nil, block);
    }

    @JRubyMethod(compat=CompatVersion.RUBY1_9)
    public static IRubyObject chunk(ThreadContext context, IRubyObject self2, IRubyObject initialState, Block block) {
        if (!block.isGiven()) {
            throw context.runtime.newArgumentError("no block given");
        }
        IRubyObject enumerator = context.runtime.getEnumerator().allocate();
        enumerator.getInternalVariables().setInternalVariable("chunk_enumerable", self2);
        enumerator.getInternalVariables().setInternalVariable("chunk_categorize", RubyProc.newProc(context.runtime, block, block.type));
        enumerator.getInternalVariables().setInternalVariable("chunk_initial_state", initialState);
        Helpers.invoke(context, enumerator, "initialize", CallBlock.newCallClosure(self2, context.runtime.getEnumerable(), Arity.ONE_ARGUMENT, new ChunkedBlockCallback(context.runtime, enumerator), context));
        return enumerator;
    }

    public static final class AppendBlockCallback
    implements BlockCallback {
        private final RubyArray result;

        public AppendBlockCallback(Ruby runtime, RubyArray result2) {
            this.result = result2;
        }

        AppendBlockCallback(RubyArray result2) {
            this.result = result2;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] largs, Block blk) {
            this.result.append(RubyEnumerable.packEnumValues(context, largs));
            return context.nil;
        }
    }

    public static final class ChunkedBlockCallback
    implements BlockCallback {
        private final Ruby runtime;
        private final IRubyObject enumerator;

        public ChunkedBlockCallback(Ruby runtime, IRubyObject enumerator) {
            this.runtime = runtime;
            this.enumerator = enumerator;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] args2, Block block) {
            InternalVariables variables = this.enumerator.getInternalVariables();
            IRubyObject enumerable = (IRubyObject)variables.getInternalVariable("chunk_enumerable");
            final RubyProc categorize = (RubyProc)variables.getInternalVariable("chunk_categorize");
            IRubyObject state2 = (IRubyObject)variables.getInternalVariable("chunk_initial_state");
            final IRubyObject yielder = RubyEnumerable.packEnumValues(context, args2);
            final ChunkArg arg2 = new ChunkArg(context, state2.isNil() ? null : state2.dup());
            final RubySymbol alone = this.runtime.newSymbol("_alone");
            final RubySymbol separator = this.runtime.newSymbol("_separator");
            RubyEnumerable.callEach(this.runtime, context, enumerable, Arity.OPTIONAL, new BlockCallback(){

                @Override
                public IRubyObject call(ThreadContext ctx, IRubyObject[] largs, Block blk) {
                    IRubyObject larg = RubyEnumerable.packEnumValues(ctx, largs);
                    IRubyObject v = arg2.state == null ? (categorize.getBlock().arity().getValue() == 1 ? categorize.callMethod(ctx, "call", larg) : categorize.callMethod(ctx, "call", largs)) : categorize.callMethod(ctx, "call", new IRubyObject[]{larg, arg2.state});
                    if (v == alone) {
                        if (!arg2.prev_value.isNil()) {
                            yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = arg2.prev_elts = ctx.nil;
                        }
                        yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(v, (IRubyObject)ChunkedBlockCallback.this.runtime.newArray(larg)));
                    } else if (v.isNil() || v == separator) {
                        if (!arg2.prev_value.isNil()) {
                            yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = arg2.prev_elts = ctx.nil;
                        }
                    } else {
                        if (v instanceof RubySymbol && v.toString().charAt(0) == '_') {
                            throw ChunkedBlockCallback.this.runtime.newRuntimeError("symbol begins with an underscore is reserved");
                        }
                        if (arg2.prev_value.isNil()) {
                            arg2.prev_value = v;
                            arg2.prev_elts = ChunkedBlockCallback.this.runtime.newArray(larg);
                        } else if (arg2.prev_value.equals(v)) {
                            ((RubyArray)arg2.prev_elts).append(larg);
                        } else {
                            yielder.callMethod(ctx, "<<", ChunkedBlockCallback.this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
                            arg2.prev_value = v;
                            arg2.prev_elts = ChunkedBlockCallback.this.runtime.newArray(larg);
                        }
                    }
                    return ctx.nil;
                }
            });
            if (!arg2.prev_elts.isNil()) {
                yielder.callMethod(context, "<<", this.runtime.newArray(arg2.prev_value, arg2.prev_elts));
            }
            return context.nil;
        }
    }

    private static class ChunkArg {
        final IRubyObject state;
        IRubyObject prev_value;
        IRubyObject prev_elts;

        private ChunkArg(ThreadContext context, IRubyObject state2) {
            this.state = state2;
            this.prev_elts = this.prev_value = context.nil;
        }
    }

    static final class EachWithIndex
    implements BlockCallback {
        private int index;
        private final Block block;

        EachWithIndex(Block block, int index2) {
            this.block = block;
            this.index = index2;
        }

        EachWithIndex(Block block) {
            this.block = block;
            this.index = 0;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject[] iargs, Block block) {
            return this.block.call(context, RubyEnumerable.packEnumValues(context, iargs), context.runtime.newFixnum(this.index++));
        }
    }
}

