/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SelectableChannel;
import java.nio.channels.Selector;
import org.jruby.Finalizable;
import org.jruby.Ruby;
import org.jruby.platform.Platform;
import org.jruby.util.ByteList;
import org.jruby.util.JRubyFile;
import org.jruby.util.ResourceException;
import org.jruby.util.io.BadDescriptorException;
import org.jruby.util.io.CRLFStreamWrapper;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.DirectoryAsFileException;
import org.jruby.util.io.FileExistsException;
import org.jruby.util.io.InvalidValueException;
import org.jruby.util.io.ModeFlags;
import org.jruby.util.io.NonblockWritingStream;
import org.jruby.util.io.NullChannel;
import org.jruby.util.io.PipeException;
import org.jruby.util.io.SelectorFactory;
import org.jruby.util.io.Stream;
import org.jruby.util.log.Logger;
import org.jruby.util.log.LoggerFactory;

public class ChannelStream
implements Stream,
Finalizable,
NonblockWritingStream {
    private static final Logger LOG = LoggerFactory.getLogger("ChannelStream");
    private static final boolean DEBUG = false;
    public static final int BUFSIZE = 4096;
    private static final int BULK_READ_SIZE = 16384;
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);
    private static EOFException eofException = new EOFException();
    private volatile Ruby runtime;
    protected ModeFlags modes;
    protected boolean sync = false;
    protected volatile ByteBuffer buffer;
    protected boolean reading;
    private ChannelDescriptor descriptor;
    private boolean blocking = true;
    private ByteList ungotChars = new ByteList();
    private volatile boolean closedExplicitly = false;
    private volatile boolean eof = false;
    private volatile boolean autoclose = true;

    private ChannelStream(Ruby runtime, ChannelDescriptor descriptor, boolean autoclose2) {
        this.runtime = runtime;
        this.descriptor = descriptor;
        this.modes = descriptor.getOriginalModes();
        this.buffer = ByteBuffer.allocate(4096);
        this.buffer.flip();
        this.reading = true;
        this.autoclose = autoclose2;
        runtime.addInternalFinalizer(this);
    }

    private ChannelStream(Ruby runtime, ChannelDescriptor descriptor, ModeFlags modes, boolean autoclose2) {
        this(runtime, descriptor, autoclose2);
        this.modes = modes;
    }

    public Ruby getRuntime() {
        return this.runtime;
    }

    public void checkReadable() throws IOException {
        if (!this.modes.isReadable()) {
            throw new IOException("not opened for reading");
        }
    }

    public void checkWritable() throws IOException {
        if (!this.modes.isWritable()) {
            throw new IOException("not opened for writing");
        }
    }

    public void checkPermissionsSubsetOf(ModeFlags subsetModes) {
        subsetModes.isSubsetOf(this.modes);
    }

    @Override
    public ModeFlags getModes() {
        return this.modes;
    }

    @Override
    public void setModes(ModeFlags modes) {
        this.modes = modes;
    }

    @Override
    public boolean isSync() {
        return this.sync;
    }

    @Override
    public void setSync(boolean sync2) {
        this.sync = sync2;
    }

    @Override
    public void setBinmode() {
    }

    @Override
    public boolean isBinmode() {
        return false;
    }

    @Override
    public boolean isAutoclose() {
        return this.autoclose;
    }

    @Override
    public void setAutoclose(boolean autoclose2) {
        this.autoclose = autoclose2;
    }

    @Override
    public void waitUntilReady() throws IOException, InterruptedException {
        while (this.ready() == 0) {
            Thread.sleep(10L);
        }
    }

    @Override
    public final boolean readDataBuffered() {
        return this.hasBufferedInputBytes();
    }

    private boolean hasUngotChars() {
        return this.ungotChars.length() > 0;
    }

    @Override
    public final boolean writeDataBuffered() {
        return !this.reading && this.buffer.position() > 0;
    }

    private final int refillBuffer() throws IOException {
        this.buffer.clear();
        int n = ((ReadableByteChannel)this.descriptor.getChannel()).read(this.buffer);
        this.buffer.flip();
        return n;
    }

    @Override
    public synchronized ByteList fgets(ByteList separatorString) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        if (separatorString == null) {
            return this.readall();
        }
        ByteList separator = separatorString == PARAGRAPH_DELIMETER ? PARAGRAPH_SEPARATOR : separatorString;
        this.descriptor.checkOpen();
        if (this.feof()) {
            return null;
        }
        int c = this.read();
        if (c == -1) {
            return null;
        }
        this.buffer.position(this.buffer.position() - 1);
        ByteList buf = new ByteList(40);
        byte first2 = separator.getUnsafeBytes()[separator.getBegin()];
        block0: while (true) {
            block11: {
                byte[] bytes2 = this.buffer.array();
                int offset2 = this.buffer.position();
                int max2 = this.buffer.limit();
                for (int i2 = offset2; i2 < max2; ++i2) {
                    c = bytes2[i2];
                    if (c != first2) continue;
                    buf.append(bytes2, offset2, i2 - offset2);
                    if (i2 >= max2) {
                        this.buffer.clear();
                    } else {
                        this.buffer.position(i2 + 1);
                    }
                    break block11;
                }
                buf.append(bytes2, offset2, this.buffer.remaining());
                int read2 = this.refillBuffer();
                if (read2 != -1) continue;
                break;
            }
            for (int i3 = 0; i3 < separator.getRealSize() && c != -1; ++i3) {
                if (c != separator.getUnsafeBytes()[separator.getBegin() + i3]) {
                    buf.append(c);
                    continue block0;
                }
                buf.append(c);
                if (i3 >= separator.getRealSize() - 1) continue;
                c = this.read();
            }
            break;
        }
        if (separatorString == PARAGRAPH_DELIMETER) {
            while (c == separator.getUnsafeBytes()[separator.getBegin()]) {
                c = this.read();
            }
            this.ungetc(c);
        }
        return buf;
    }

    @Override
    public synchronized int getline(ByteList dst, byte terminator) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        this.descriptor.checkOpen();
        int totalRead = 0;
        boolean found = false;
        if (this.hasUngotChars()) {
            for (int i2 = 0; i2 < this.ungotChars.length(); ++i2) {
                byte ungotc = (byte)this.ungotChars.get(i2);
                dst.append(ungotc);
                found = ungotc == terminator;
                ++totalRead;
            }
            this.clearUngotChars();
        }
        while (!found) {
            int n;
            byte[] bytes2 = this.buffer.array();
            int begin2 = this.buffer.arrayOffset() + this.buffer.position();
            int end2 = begin2 + this.buffer.remaining();
            int len = 0;
            for (int i3 = begin2; i3 < end2 && !found; ++i3) {
                found = bytes2[i3] == terminator;
                ++len;
            }
            if (len > 0) {
                dst.append(this.buffer, len);
                totalRead += len;
            }
            if (found || (n = this.refillBuffer()) > 0) continue;
            if (n >= 0 || totalRead >= 1) break;
            return -1;
        }
        return totalRead;
    }

    @Override
    public synchronized int getline(ByteList dst, byte terminator, long limit2) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        this.descriptor.checkOpen();
        int totalRead = 0;
        boolean found = false;
        if (this.hasUngotChars()) {
            for (int i2 = 0; i2 < this.ungotChars.length(); ++i2) {
                byte ungotc = (byte)this.ungotChars.get(i2);
                dst.append(ungotc);
                found = ungotc == terminator;
                --limit2;
                ++totalRead;
            }
            this.clearUngotChars();
        }
        while (!found) {
            int n;
            byte[] bytes2 = this.buffer.array();
            int begin2 = this.buffer.arrayOffset() + this.buffer.position();
            int end2 = begin2 + this.buffer.remaining();
            int len = 0;
            for (int i3 = begin2; i3 < end2 && limit2-- > 0L && !found; ++i3) {
                found = bytes2[i3] == terminator;
                ++len;
            }
            if (limit2 < 1L) {
                found = true;
            }
            if (len > 0) {
                dst.append(this.buffer, len);
                totalRead += len;
            }
            if (found || (n = this.refillBuffer()) > 0) continue;
            if (n >= 0 || totalRead >= 1) break;
            return -1;
        }
        return totalRead;
    }

    private void clearUngotChars() {
        if (this.ungotChars.length() > 0) {
            this.ungotChars.delete(0, this.ungotChars.length());
        }
    }

    @Override
    @Deprecated
    public synchronized ByteList readall() throws IOException, BadDescriptorException {
        long fileSize;
        long l = fileSize = this.descriptor.isSeekable() && this.descriptor.getChannel() instanceof FileChannel ? ((FileChannel)this.descriptor.getChannel()).size() : 0L;
        if (fileSize > 0L) {
            this.ensureRead();
            FileChannel channel = (FileChannel)this.descriptor.getChannel();
            long left2 = fileSize - channel.position() + (long)this.bufferedInputBytesRemaining();
            if (left2 <= 0L) {
                this.eof = true;
                return null;
            }
            if (left2 > Integer.MAX_VALUE) {
                if (this.getRuntime() != null) {
                    throw this.getRuntime().newIOError("File too large");
                }
                throw new IOException("File too large");
            }
            ByteList result2 = new ByteList((int)left2);
            ByteBuffer buf = ByteBuffer.wrap(result2.getUnsafeBytes(), result2.begin(), (int)left2);
            this.copyBufferedBytes(buf);
            while (buf.hasRemaining()) {
                int n;
                int MAX_READ_CHUNK = 0x100000;
                ByteBuffer tmp = buf.duplicate();
                if (tmp.remaining() > 0x100000) {
                    tmp.limit(tmp.position() + 0x100000);
                }
                if ((n = channel.read(tmp)) <= 0) break;
                buf.position(tmp.position());
            }
            this.eof = true;
            result2.length(buf.position());
            return result2;
        }
        if (this.descriptor.isNull()) {
            return new ByteList(0);
        }
        this.checkReadable();
        ByteList byteList = new ByteList();
        ByteList read2 = this.fread(4096);
        if (read2 == null) {
            this.eof = true;
            return byteList;
        }
        while (read2 != null) {
            byteList.append(read2);
            read2 = this.fread(4096);
        }
        return byteList;
    }

    private final int copyBufferedBytes(ByteBuffer dst) {
        int bytesToCopy = dst.remaining();
        if (this.hasUngotChars() && dst.hasRemaining()) {
            for (int i2 = 0; i2 < this.ungotChars.length(); ++i2) {
                byte ungotc = (byte)this.ungotChars.get(i2);
                dst.put(ungotc);
            }
            this.clearUngotChars();
        }
        if (this.buffer.hasRemaining() && dst.hasRemaining()) {
            if (dst.remaining() >= this.buffer.remaining()) {
                dst.put(this.buffer);
            } else {
                ByteBuffer tmp = this.buffer.duplicate();
                tmp.limit(tmp.position() + dst.remaining());
                dst.put(tmp);
                this.buffer.position(tmp.position());
            }
        }
        return bytesToCopy - dst.remaining();
    }

    private final int copyBufferedBytes(byte[] dst, int off, int len) {
        int bytesCopied = 0;
        if (this.hasUngotChars() && len > 0) {
            for (int i2 = 0; i2 < this.ungotChars.length(); ++i2) {
                byte ungotc = (byte)this.ungotChars.get(i2);
                dst[off++] = ungotc;
                ++bytesCopied;
            }
            this.clearUngotChars();
        }
        int n = Math.min(len - bytesCopied, this.buffer.remaining());
        this.buffer.get(dst, off, n);
        return bytesCopied += n;
    }

    private final int copyBufferedBytes(ByteList dst, int len) {
        int bytesCopied = 0;
        dst.ensure(Math.min(len, this.bufferedInputBytesRemaining()));
        if (this.hasUngotChars() && this.hasUngotChars()) {
            for (int i2 = 0; i2 < this.ungotChars.length(); ++i2) {
                byte ungotc = (byte)this.ungotChars.get(i2);
                ++bytesCopied;
                dst.append(ungotc);
            }
            this.clearUngotChars();
        }
        if (bytesCopied < len && this.buffer.hasRemaining()) {
            int n = Math.min(this.buffer.remaining(), len - bytesCopied);
            dst.append(this.buffer, n);
            bytesCopied += n;
        }
        return bytesCopied;
    }

    private final int bufferedInputBytesRemaining() {
        return this.reading ? this.buffer.remaining() + this.ungotChars.length() : 0;
    }

    private final boolean hasBufferedInputBytes() {
        return this.reading && (this.buffer.hasRemaining() || this.hasUngotChars());
    }

    private final int bufferedOutputSpaceRemaining() {
        return !this.reading ? this.buffer.remaining() : 0;
    }

    private final boolean hasBufferedOutputSpace() {
        return !this.reading && this.buffer.hasRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void fclose() throws IOException, BadDescriptorException {
        try {
            ChannelStream channelStream = this;
            synchronized (channelStream) {
                this.closedExplicitly = true;
                this.close();
            }
        }
        finally {
            Ruby localRuntime = this.getRuntime();
            if (localRuntime != null) {
                localRuntime.removeInternalFinalizer(this);
            }
            this.runtime = null;
        }
    }

    private void close() throws IOException, BadDescriptorException {
        this.finish(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish(boolean close2) throws BadDescriptorException, IOException {
        try {
            this.flushWrite();
        }
        finally {
            this.buffer = EMPTY_BUFFER;
            this.runtime = null;
            this.descriptor.finish(close2);
        }
    }

    @Override
    public synchronized int fflush() throws IOException, BadDescriptorException {
        this.checkWritable();
        try {
            this.flushWrite();
        }
        catch (EOFException eofe) {
            return -1;
        }
        return 0;
    }

    private void flushWrite() throws IOException, BadDescriptorException {
        if (this.reading || !this.modes.isWritable() || this.buffer.position() == 0) {
            return;
        }
        int len = this.buffer.position();
        this.buffer.flip();
        int n = this.descriptor.write(this.buffer);
        if (n != len) {
            // empty if block
        }
        this.buffer.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushWrite(boolean block) throws IOException, BadDescriptorException {
        if (this.reading || !this.modes.isWritable() || this.buffer.position() == 0) {
            return false;
        }
        int len = this.buffer.position();
        int nWritten = 0;
        this.buffer.flip();
        if (this.descriptor.getChannel() instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)this.descriptor.getChannel();
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                boolean oldBlocking = selectableChannel.isBlocking();
                try {
                    if (oldBlocking != block) {
                        selectableChannel.configureBlocking(block);
                    }
                    nWritten = this.descriptor.write(this.buffer);
                }
                finally {
                    if (oldBlocking != block) {
                        selectableChannel.configureBlocking(oldBlocking);
                    }
                }
            }
        }
        nWritten = this.descriptor.write(this.buffer);
        if (nWritten != len) {
            this.buffer.compact();
            return false;
        }
        this.buffer.clear();
        return true;
    }

    @Override
    public InputStream newInputStream() {
        InputStream in = this.descriptor.getBaseInputStream();
        return in == null ? new InputStreamAdapter(this) : in;
    }

    @Override
    public OutputStream newOutputStream() {
        return new OutputStreamAdapter(this);
    }

    @Override
    public void clearerr() {
        this.eof = false;
    }

    @Override
    public boolean feof() throws IOException, BadDescriptorException {
        this.checkReadable();
        return this.eof;
    }

    @Override
    public synchronized long fgetpos() throws IOException, PipeException, InvalidValueException, BadDescriptorException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            long pos2 = fileChannel.position();
            if (this.reading) {
                return pos2 - (long)((pos2 -= (long)this.buffer.remaining()) > 0L && this.hasUngotChars() ? this.ungotChars.length() : 0);
            }
            return pos2 + (long)this.buffer.position();
        }
        if (this.descriptor.isNull()) {
            return 0L;
        }
        throw new PipeException();
    }

    @Override
    public synchronized void lseek(long offset2, int type2) throws IOException, InvalidValueException, PipeException, BadDescriptorException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            this.clearUngotChars();
            int adj = 0;
            if (this.reading) {
                adj = this.buffer.remaining();
                this.buffer.clear();
                this.buffer.flip();
            } else {
                this.flushWrite();
            }
            try {
                switch (type2) {
                    case 0: {
                        fileChannel.position(offset2);
                        break;
                    }
                    case 1: {
                        fileChannel.position(fileChannel.position() - (long)adj + offset2);
                        break;
                    }
                    case 2: {
                        fileChannel.position(fileChannel.size() + offset2);
                    }
                }
            }
            catch (IllegalArgumentException e) {
                throw new InvalidValueException();
            }
            catch (IOException ioe) {
                throw ioe;
            }
        } else if (this.descriptor.getChannel() instanceof SelectableChannel) {
            throw new PipeException();
        }
    }

    @Override
    public synchronized void sync() throws IOException, BadDescriptorException {
        this.flushWrite();
    }

    private void ensureRead() throws IOException, BadDescriptorException {
        if (this.reading) {
            return;
        }
        this.flushWrite();
        this.buffer.clear();
        this.buffer.flip();
        this.reading = true;
    }

    private void ensureReadNonBuffered() throws IOException, BadDescriptorException {
        if (this.reading) {
            if (this.buffer.hasRemaining()) {
                Ruby localRuntime = this.getRuntime();
                if (localRuntime != null) {
                    throw localRuntime.newIOError("sysread for buffered IO");
                }
                throw new IOException("sysread for buffered IO");
            }
        } else {
            this.flushWrite();
            this.buffer.clear();
            this.buffer.flip();
            this.reading = true;
        }
    }

    private void resetForWrite() throws IOException {
        if (this.descriptor.isSeekable()) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            if (this.buffer.hasRemaining()) {
                fileChannel.position(fileChannel.position() - (long)this.buffer.remaining());
            }
        }
        this.buffer.clear();
        this.reading = false;
    }

    private void ensureWrite() throws IOException {
        if (!this.reading) {
            return;
        }
        this.resetForWrite();
    }

    @Override
    public synchronized ByteList read(int number) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureReadNonBuffered();
        ByteList byteList = new ByteList(number);
        int bytesRead = this.descriptor.read(number, byteList);
        if (bytesRead == -1) {
            this.eof = true;
        }
        return byteList;
    }

    private ByteList bufferedRead(int number) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        int resultSize = 0;
        int BULK_THRESHOLD = 131072;
        if (number >= 131072 && this.descriptor.isSeekable() && this.descriptor.getChannel() instanceof FileChannel) {
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            resultSize = (int)Math.min(fileChannel.size() - fileChannel.position() + (long)this.bufferedInputBytesRemaining(), (long)number);
        } else {
            resultSize = Math.min(this.bufferedInputBytesRemaining(), number);
        }
        ByteList result2 = new ByteList(resultSize);
        this.bufferedRead(result2, number);
        return result2;
    }

    private int bufferedRead(ByteList dst, int number) throws IOException, BadDescriptorException {
        int bytesRead = 0;
        bytesRead += this.copyBufferedBytes(dst, number);
        boolean done = false;
        while (number - bytesRead >= 4096) {
            int bytesToRead = Math.min(16384, number - bytesRead);
            int n = this.descriptor.read(bytesToRead, dst);
            if (n == -1) {
                this.eof = true;
                done = true;
                break;
            }
            if (n == 0) {
                done = true;
                break;
            }
            bytesRead += n;
        }
        while (!done && bytesRead < number) {
            int read2 = this.refillBuffer();
            if (read2 == -1) {
                this.eof = true;
                break;
            }
            if (read2 == 0) break;
            int len = Math.min(this.buffer.remaining(), number - bytesRead);
            dst.append(this.buffer, len);
            bytesRead += len;
        }
        if (bytesRead == 0 && number != 0 && this.eof) {
            throw this.newEOFException();
        }
        return bytesRead;
    }

    private EOFException newEOFException() {
        if (eofException != null) {
            return eofException;
        }
        return new EOFException();
    }

    private int bufferedRead(ByteBuffer dst, boolean partial) throws IOException, BadDescriptorException {
        this.checkReadable();
        this.ensureRead();
        boolean done = false;
        int bytesRead = 0;
        bytesRead += this.copyBufferedBytes(dst);
        while (!(bytesRead >= 1 && partial || dst.remaining() < 4096 && !dst.isDirect())) {
            int n;
            int bytesToRead;
            ByteBuffer tmpDst = dst;
            if (!dst.isDirect() && (bytesToRead = Math.min(16384, dst.remaining())) < dst.remaining()) {
                tmpDst = dst.duplicate();
                tmpDst.limit(tmpDst.position() + bytesToRead);
            }
            if ((n = this.descriptor.read(tmpDst)) == -1) {
                this.eof = true;
                done = true;
                break;
            }
            if (n == 0) {
                done = true;
                break;
            }
            bytesRead += n;
        }
        while (!(done || !dst.hasRemaining() || bytesRead >= 1 && partial)) {
            int read2 = this.refillBuffer();
            if (read2 == -1) {
                this.eof = true;
                done = true;
                break;
            }
            if (read2 == 0) {
                done = true;
                break;
            }
            bytesRead += this.copyBufferedBytes(dst);
        }
        if (this.eof && bytesRead == 0 && dst.remaining() != 0) {
            throw this.newEOFException();
        }
        return bytesRead;
    }

    private int bufferedRead() throws IOException, BadDescriptorException {
        this.ensureRead();
        if (!this.buffer.hasRemaining()) {
            int len = this.refillBuffer();
            if (len == -1) {
                this.eof = true;
                return -1;
            }
            if (len == 0) {
                return -1;
            }
        }
        return this.buffer.get() & 0xFF;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int bufferedWrite(ByteList buf) throws IOException, BadDescriptorException {
        this.checkWritable();
        this.ensureWrite();
        if (buf == null || buf.length() == 0) {
            return 0;
        }
        if (buf.length() > this.buffer.capacity()) {
            this.flushWrite();
            int n = this.descriptor.write(ByteBuffer.wrap(buf.getUnsafeBytes(), buf.begin(), buf.length()));
            if (n == buf.length()) {
                // empty if block
            }
        } else {
            if (buf.length() > this.buffer.remaining()) {
                this.flushWrite();
            }
            this.buffer.put(buf.getUnsafeBytes(), buf.begin(), buf.length());
        }
        if (this.isSync()) {
            this.flushWrite();
        }
        return buf.getRealSize();
    }

    private int bufferedWrite(ByteBuffer buf) throws IOException, BadDescriptorException {
        this.checkWritable();
        this.ensureWrite();
        if (buf == null || !buf.hasRemaining()) {
            return 0;
        }
        int nbytes = buf.remaining();
        if (nbytes >= this.buffer.capacity()) {
            this.flushWrite();
            this.descriptor.write(buf);
        } else {
            if (nbytes > this.buffer.remaining()) {
                this.flushWrite();
            }
            this.buffer.put(buf);
        }
        if (this.isSync()) {
            this.flushWrite();
        }
        return nbytes - buf.remaining();
    }

    private int bufferedWrite(int c) throws IOException, BadDescriptorException {
        this.checkWritable();
        this.ensureWrite();
        if (!this.buffer.hasRemaining()) {
            this.flushWrite();
        }
        this.buffer.put((byte)c);
        if (this.isSync()) {
            this.flushWrite();
        }
        return 1;
    }

    @Override
    public synchronized void ftruncate(long newLength) throws IOException, BadDescriptorException, InvalidValueException {
        Channel ch = this.descriptor.getChannel();
        if (!(ch instanceof FileChannel)) {
            throw new InvalidValueException();
        }
        this.invalidateBuffer();
        FileChannel fileChannel = (FileChannel)ch;
        long position = fileChannel.position();
        if (newLength > fileChannel.size()) {
            int difference = (int)(newLength - fileChannel.size());
            fileChannel.position(fileChannel.size());
            fileChannel.write(ByteBuffer.allocate(difference));
        } else {
            fileChannel.truncate(newLength);
        }
        fileChannel.position(position);
    }

    private void invalidateBuffer() throws IOException, BadDescriptorException {
        if (!this.reading) {
            this.flushWrite();
        }
        int posOverrun = this.buffer.remaining();
        this.buffer.clear();
        if (this.reading) {
            this.buffer.flip();
            FileChannel fileChannel = (FileChannel)this.descriptor.getChannel();
            if (posOverrun != 0) {
                fileChannel.position(fileChannel.position() - (long)posOverrun);
            }
        }
    }

    @Override
    public void finalize() throws Throwable {
        super.finalize();
        if (this.closedExplicitly) {
            return;
        }
        if (this.descriptor != null && this.descriptor.isOpen()) {
            this.finish(this.autoclose);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int ready() throws IOException {
        if (this.descriptor.getChannel() instanceof SelectableChannel) {
            int ready_stat = 0;
            Selector sel = SelectorFactory.openWithRetryFrom(null, ((SelectableChannel)this.descriptor.getChannel()).provider());
            SelectableChannel selchan = (SelectableChannel)this.descriptor.getChannel();
            Object object = selchan.blockingLock();
            synchronized (object) {
                boolean is_block = selchan.isBlocking();
                try {
                    selchan.configureBlocking(false);
                    selchan.register(sel, 1);
                    ready_stat = sel.selectNow();
                    sel.close();
                }
                catch (Throwable ex) {
                }
                finally {
                    if (sel != null) {
                        try {
                            sel.close();
                        }
                        catch (Exception e) {}
                    }
                    selchan.configureBlocking(is_block);
                }
            }
            return ready_stat;
        }
        return this.newInputStream().available();
    }

    @Override
    public synchronized void fputc(int c) throws IOException, BadDescriptorException {
        this.bufferedWrite(c);
    }

    @Override
    public int ungetc(int c) {
        if (c == -1) {
            return -1;
        }
        this.eof = false;
        this.ungotChars.prepend((byte)c);
        return c;
    }

    @Override
    public synchronized int fgetc() throws IOException, BadDescriptorException {
        if (this.eof) {
            return -1;
        }
        this.checkReadable();
        int c = this.read();
        if (c == -1) {
            this.eof = true;
            return c;
        }
        return c & 0xFF;
    }

    @Override
    public synchronized int fwrite(ByteList string2) throws IOException, BadDescriptorException {
        return this.bufferedWrite(string2);
    }

    public synchronized int write(ByteBuffer buf) throws IOException, BadDescriptorException {
        return this.bufferedWrite(buf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized int writenonblock(ByteList buf) throws IOException, BadDescriptorException {
        this.checkWritable();
        this.ensureWrite();
        if (buf == null || buf.length() == 0) {
            return 0;
        }
        if (this.buffer.position() != 0 && !this.flushWrite(false)) {
            return 0;
        }
        if (this.descriptor.getChannel() instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)this.descriptor.getChannel();
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                int n;
                block11: {
                    boolean oldBlocking = selectableChannel.isBlocking();
                    try {
                        if (oldBlocking) {
                            selectableChannel.configureBlocking(false);
                        }
                        n = this.descriptor.write(ByteBuffer.wrap(buf.getUnsafeBytes(), buf.begin(), buf.length()));
                        if (!oldBlocking) break block11;
                    }
                    catch (Throwable throwable) {
                        if (oldBlocking) {
                            selectableChannel.configureBlocking(oldBlocking);
                        }
                        throw throwable;
                    }
                    selectableChannel.configureBlocking(oldBlocking);
                }
                return n;
            }
        }
        return this.descriptor.write(ByteBuffer.wrap(buf.getUnsafeBytes(), buf.begin(), buf.length()));
    }

    @Override
    public synchronized ByteList fread(int number) throws IOException, BadDescriptorException {
        try {
            if (number == 0) {
                if (this.eof) {
                    return null;
                }
                return new ByteList(0);
            }
            return this.bufferedRead(number);
        }
        catch (EOFException e) {
            this.eof = true;
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized ByteList readnonblock(int number) throws IOException, BadDescriptorException, EOFException {
        assert (number >= 0);
        if (number == 0) {
            return null;
        }
        if (this.descriptor.getChannel() instanceof SelectableChannel) {
            SelectableChannel selectableChannel = (SelectableChannel)this.descriptor.getChannel();
            Object object = selectableChannel.blockingLock();
            synchronized (object) {
                ByteList byteList;
                boolean oldBlocking = selectableChannel.isBlocking();
                try {
                    selectableChannel.configureBlocking(false);
                    byteList = this.readpartial(number);
                }
                catch (Throwable throwable) {
                    selectableChannel.configureBlocking(oldBlocking);
                    throw throwable;
                }
                selectableChannel.configureBlocking(oldBlocking);
                return byteList;
            }
        }
        if (this.descriptor.getChannel() instanceof FileChannel) {
            return this.fread(number);
        }
        return null;
    }

    public synchronized ByteList readpartial(int number) throws IOException, BadDescriptorException, EOFException {
        assert (number >= 0);
        if (number == 0) {
            return null;
        }
        if (this.descriptor.getChannel() instanceof FileChannel) {
            return this.fread(number);
        }
        if (this.hasBufferedInputBytes()) {
            return this.bufferedRead(Math.min(this.bufferedInputBytesRemaining(), number));
        }
        return this.read(number);
    }

    public synchronized int read(ByteBuffer dst) throws IOException, BadDescriptorException, EOFException {
        return this.read(dst, !(this.descriptor.getChannel() instanceof FileChannel));
    }

    public synchronized int read(ByteBuffer dst, boolean partial) throws IOException, BadDescriptorException, EOFException {
        assert (dst.hasRemaining());
        return this.bufferedRead(dst, partial);
    }

    public synchronized int read() throws IOException, BadDescriptorException {
        try {
            this.descriptor.checkOpen();
            if (this.hasUngotChars()) {
                int c = this.ungotChars.get(0);
                this.ungotChars.delete(0, 1);
                return c;
            }
            return this.bufferedRead();
        }
        catch (EOFException e) {
            this.eof = true;
            return -1;
        }
    }

    @Override
    public ChannelDescriptor getDescriptor() {
        return this.descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setBlocking(boolean block) throws IOException {
        if (!(this.descriptor.getChannel() instanceof SelectableChannel)) {
            return;
        }
        Object object = ((SelectableChannel)this.descriptor.getChannel()).blockingLock();
        synchronized (object) {
            this.blocking = block;
            try {
                ((SelectableChannel)this.descriptor.getChannel()).configureBlocking(block);
            }
            catch (IllegalBlockingModeException illegalBlockingModeException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean isBlocking() {
        return this.blocking;
    }

    @Override
    public synchronized void freopen(Ruby runtime, String path2, ModeFlags modes) throws DirectoryAsFileException, IOException, InvalidValueException, PipeException, BadDescriptorException {
        this.flushWrite();
        this.buffer.clear();
        if (this.reading) {
            this.buffer.flip();
        }
        this.modes = modes;
        if (this.descriptor.isOpen()) {
            this.descriptor.close();
        }
        if (path2.equals("/dev/null") || path2.equalsIgnoreCase("nul:") || path2.equalsIgnoreCase("nul")) {
            this.descriptor = this.descriptor.reopen(new NullChannel(), modes);
        } else {
            String cwd = runtime.getCurrentDirectory();
            JRubyFile theFile = JRubyFile.create(cwd, path2);
            if (theFile.isDirectory() && modes.isWritable()) {
                throw runtime.newErrnoEISDirError(path2);
            }
            if (modes.isCreate()) {
                if (theFile.exists() && modes.isExclusive()) {
                    throw runtime.newErrnoEEXISTError("File exists - " + path2);
                }
                theFile.createNewFile();
            } else if (!theFile.exists()) {
                throw runtime.newErrnoENOENTError("file not found - " + path2);
            }
            RandomAccessFile file2 = new RandomAccessFile((File)((Object)theFile), modes.toJavaModeString());
            if (modes.isTruncate()) {
                file2.setLength(0L);
            }
            this.descriptor = this.descriptor.reopen(file2, modes);
            try {
                if (modes.isAppendable()) {
                    this.lseek(0L, 2);
                }
            }
            catch (PipeException pe) {
                // empty catch block
            }
        }
    }

    public static Stream open(Ruby runtime, ChannelDescriptor descriptor) {
        return ChannelStream.maybeWrapWithLineEndingWrapper(new ChannelStream(runtime, descriptor, true), descriptor.getOriginalModes());
    }

    public static Stream fdopen(Ruby runtime, ChannelDescriptor descriptor, ModeFlags modes) throws InvalidValueException {
        descriptor.checkNewModes(modes);
        return ChannelStream.maybeWrapWithLineEndingWrapper(new ChannelStream(runtime, descriptor, modes, true), modes);
    }

    public static Stream open(Ruby runtime, ChannelDescriptor descriptor, boolean autoclose2) {
        return ChannelStream.maybeWrapWithLineEndingWrapper(new ChannelStream(runtime, descriptor, autoclose2), descriptor.getOriginalModes());
    }

    public static Stream fdopen(Ruby runtime, ChannelDescriptor descriptor, ModeFlags modes, boolean autoclose2) throws InvalidValueException {
        descriptor.checkNewModes(modes);
        return ChannelStream.maybeWrapWithLineEndingWrapper(new ChannelStream(runtime, descriptor, modes, autoclose2), modes);
    }

    private static Stream maybeWrapWithLineEndingWrapper(Stream stream, ModeFlags modes) {
        if (modes.isText() || Platform.IS_WINDOWS && stream.getDescriptor().getChannel() instanceof FileChannel && !modes.isBinary()) {
            return new CRLFStreamWrapper(stream);
        }
        return stream;
    }

    public static Stream fopen(Ruby runtime, String path2, ModeFlags modes) throws FileNotFoundException, DirectoryAsFileException, FileExistsException, IOException, InvalidValueException, PipeException, BadDescriptorException {
        try {
            ChannelDescriptor descriptor = ChannelDescriptor.open(runtime.getCurrentDirectory(), path2, modes, runtime.getClassLoader());
            Stream stream = ChannelStream.fdopen(runtime, descriptor, modes);
            return stream;
        }
        catch (ResourceException resourceException) {
            throw resourceException.newRaiseException(runtime);
        }
    }

    @Override
    public Channel getChannel() {
        return this.getDescriptor().getChannel();
    }

    private static final class OutputStreamAdapter
    extends OutputStream {
        private final ChannelStream stream;

        public OutputStreamAdapter(ChannelStream stream) {
            this.stream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(int i2) throws IOException {
            ChannelStream channelStream = this.stream;
            synchronized (channelStream) {
                if (!this.stream.isSync() && this.stream.hasBufferedOutputSpace()) {
                    this.stream.buffer.put((byte)i2);
                    return;
                }
            }
            byte[] b2 = new byte[]{(byte)i2};
            this.write(b2, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] bytes2, int off, int len) throws IOException {
            if (bytes2 == null) {
                throw new NullPointerException("null source buffer");
            }
            if ((len | off | off + len | bytes2.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            try {
                ChannelStream channelStream = this.stream;
                synchronized (channelStream) {
                    if (!this.stream.isSync() && this.stream.bufferedOutputSpaceRemaining() >= len) {
                        this.stream.buffer.put(bytes2, off, len);
                    } else {
                        if (this.stream.getDescriptor().getChannel() instanceof SelectableChannel) {
                            SelectableChannel ch = (SelectableChannel)this.stream.getDescriptor().getChannel();
                            Object object = ch.blockingLock();
                            synchronized (object) {
                                boolean oldBlocking = ch.isBlocking();
                                try {
                                    if (!oldBlocking) {
                                        ch.configureBlocking(true);
                                    }
                                    this.stream.bufferedWrite(ByteBuffer.wrap(bytes2, off, len));
                                }
                                finally {
                                    if (!oldBlocking) {
                                        ch.configureBlocking(oldBlocking);
                                    }
                                }
                            }
                        }
                        this.stream.bufferedWrite(ByteBuffer.wrap(bytes2, off, len));
                    }
                }
            }
            catch (BadDescriptorException ex) {
                throw new IOException(ex.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                ChannelStream channelStream = this.stream;
                synchronized (channelStream) {
                    this.stream.fclose();
                }
            }
            catch (BadDescriptorException ex) {
                throw new IOException(ex.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            try {
                ChannelStream channelStream = this.stream;
                synchronized (channelStream) {
                    this.stream.flushWrite(true);
                }
            }
            catch (BadDescriptorException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }

    private static final class InputStreamAdapter
    extends InputStream {
        private final ChannelStream stream;

        public InputStreamAdapter(ChannelStream stream) {
            this.stream = stream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int read() throws IOException {
            ChannelStream channelStream = this.stream;
            synchronized (channelStream) {
                if (this.stream.hasBufferedInputBytes()) {
                    try {
                        return this.stream.read();
                    }
                    catch (BadDescriptorException ex) {
                        throw new IOException(ex.getMessage());
                    }
                }
            }
            byte[] b2 = new byte[1];
            return this.read(b2, 0, 1) == 1 ? b2[0] & 0xFF : -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public int read(byte[] bytes2, int off, int len) throws IOException {
            if (bytes2 == null) {
                throw new NullPointerException("null destination buffer");
            }
            if ((len | off | off + len | bytes2.length - (off + len)) < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (len == 0) {
                return 0;
            }
            try {
                ChannelStream channelStream = this.stream;
                synchronized (channelStream) {
                    int available = this.stream.bufferedInputBytesRemaining();
                    if (available >= len) {
                        return this.stream.copyBufferedBytes(bytes2, off, len);
                    }
                    if (!(this.stream.getDescriptor().getChannel() instanceof SelectableChannel)) {
                        return this.stream.bufferedRead(ByteBuffer.wrap(bytes2, off, len), true);
                    }
                    SelectableChannel ch = (SelectableChannel)this.stream.getDescriptor().getChannel();
                    Object object = ch.blockingLock();
                    synchronized (object) {
                        boolean oldBlocking = ch.isBlocking();
                        if (!oldBlocking) {
                            ch.configureBlocking(true);
                        }
                        int n = this.stream.bufferedRead(ByteBuffer.wrap(bytes2, off, len), true);
                        return n;
                        finally {
                            if (!oldBlocking) {
                                ch.configureBlocking(oldBlocking);
                            }
                        }
                    }
                }
            }
            catch (BadDescriptorException ex) {
                throw new IOException(ex.getMessage());
            }
            catch (EOFException ex) {
                return -1;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            ChannelStream channelStream = this.stream;
            synchronized (channelStream) {
                return !this.stream.eof ? this.stream.bufferedInputBytesRemaining() : 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                ChannelStream channelStream = this.stream;
                synchronized (channelStream) {
                    this.stream.fclose();
                }
            }
            catch (BadDescriptorException ex) {
                throw new IOException(ex.getMessage());
            }
        }
    }
}

