/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.FileDescriptor;
import jnr.posix.FileStat;
import jnr.posix.util.Platform;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.StringSupport;

@JRubyClass(name={"File::Stat"}, include={"Comparable"})
public class RubyFileStat
extends RubyObject {
    private static final long serialVersionUID = 1L;
    private static final int S_IRUGO = 292;
    private static final int S_IWUGO = 146;
    private static final int S_IXUGO = 73;
    private FileResource file;
    private FileStat stat;
    private static ObjectAllocator ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyFileStat(runtime, klass);
        }
    };

    private void checkInitialized() {
        if (this.stat == null) {
            throw this.getRuntime().newTypeError("uninitialized File::Stat");
        }
    }

    public static RubyClass createFileStatClass(Ruby runtime) {
        RubyClass fileStatClass = runtime.getFile().defineClassUnder("Stat", runtime.getObject(), ALLOCATOR);
        runtime.setFileStat(fileStatClass);
        fileStatClass.includeModule(runtime.getModule("Comparable"));
        fileStatClass.defineAnnotatedMethods(RubyFileStat.class);
        return fileStatClass;
    }

    protected RubyFileStat(Ruby runtime, RubyClass clazz) {
        super(runtime, clazz);
    }

    public static RubyFileStat newFileStat(Ruby runtime, String filename2, boolean lstat2) {
        RubyFileStat stat2 = new RubyFileStat(runtime, runtime.getFileStat());
        stat2.setup(filename2, lstat2);
        return stat2;
    }

    public static RubyFileStat newFileStat(Ruby runtime, FileDescriptor descriptor) {
        RubyFileStat stat2 = new RubyFileStat(runtime, runtime.getFileStat());
        stat2.setup(descriptor);
        return stat2;
    }

    private void setup(FileDescriptor descriptor) {
        this.stat = this.getRuntime().getPosix().fstat(descriptor);
    }

    private void setup(String filename2, boolean lstat2) {
        Ruby runtime = this.getRuntime();
        if (Platform.IS_WINDOWS && filename2.length() == 2 && filename2.charAt(1) == ':' && Character.isLetter(filename2.charAt(0))) {
            filename2 = filename2 + '/';
        }
        this.file = JRubyFile.createResource(runtime.getPosix(), runtime.getCurrentDirectory(), filename2);
        FileStat fileStat = this.stat = lstat2 ? this.file.lstat() : this.file.stat();
        if (this.stat == null) {
            throw runtime.newErrnoFromInt(this.file.errno(), filename2);
        }
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_8)
    public IRubyObject initialize(IRubyObject fname, Block unusedBlock) {
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        RubyString path2 = StringSupport.checkEmbeddedNulls(runtime, RubyFile.get_path(context, fname));
        this.setup(fname.convertToString().toString(), false);
        return this;
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE, compat=CompatVersion.RUBY1_9)
    public IRubyObject initialize19(IRubyObject fname, Block unusedBlock) {
        return this.initialize(RubyFile.get_path(this.getRuntime().getCurrentContext(), fname), unusedBlock);
    }

    @JRubyMethod(name={"atime"})
    public IRubyObject atime() {
        this.checkInitialized();
        return this.getRuntime().newTime(this.stat.atime() * 1000L);
    }

    @JRubyMethod(name={"blksize"})
    public RubyFixnum blksize() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.blockSize());
    }

    @JRubyMethod(name={"blockdev?"})
    public IRubyObject blockdev_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isBlockDev());
    }

    @JRubyMethod(name={"blocks"})
    public IRubyObject blocks() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.blocks());
    }

    @JRubyMethod(name={"chardev?"})
    public IRubyObject chardev_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isCharDev());
    }

    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject cmp(IRubyObject other) {
        long time2;
        this.checkInitialized();
        if (!(other instanceof RubyFileStat)) {
            return this.getRuntime().getNil();
        }
        long time1 = this.stat.mtime();
        if (time1 == (time2 = ((RubyFileStat)other).stat.mtime())) {
            return this.getRuntime().newFixnum(0);
        }
        if (time1 < time2) {
            return this.getRuntime().newFixnum(-1);
        }
        return this.getRuntime().newFixnum(1);
    }

    @JRubyMethod(name={"ctime"})
    public IRubyObject ctime() {
        this.checkInitialized();
        return this.getRuntime().newTime(this.stat.ctime() * 1000L);
    }

    @JRubyMethod(name={"dev"})
    public IRubyObject dev() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.dev());
    }

    @JRubyMethod(name={"dev_major"})
    public IRubyObject devMajor() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.major(this.stat.dev()));
    }

    @JRubyMethod(name={"dev_minor"})
    public IRubyObject devMinor() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.minor(this.stat.dev()));
    }

    @JRubyMethod(name={"directory?"})
    public RubyBoolean directory_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isDirectory());
    }

    @JRubyMethod(name={"executable?"})
    public IRubyObject executable_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isExecutable());
    }

    @JRubyMethod(name={"executable_real?"})
    public IRubyObject executableReal_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isExecutableReal());
    }

    @JRubyMethod(name={"file?"})
    public RubyBoolean file_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isFile());
    }

    @JRubyMethod(name={"ftype"})
    public RubyString ftype() {
        this.checkInitialized();
        return this.getRuntime().newString(this.stat.ftype());
    }

    @JRubyMethod(name={"gid"})
    public IRubyObject gid() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.gid());
    }

    @JRubyMethod(name={"grpowned?"})
    public IRubyObject group_owned_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isGroupOwned());
    }

    @Override
    @JRubyMethod(name={"initialize_copy"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(IRubyObject original) {
        if (!(original instanceof RubyFileStat)) {
            throw this.getRuntime().newTypeError("wrong argument class");
        }
        RubyFileStat originalFileStat = (RubyFileStat)original;
        this.file = originalFileStat.file;
        this.stat = originalFileStat.stat;
        return this;
    }

    @JRubyMethod(name={"ino"})
    public IRubyObject ino() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.ino());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect() {
        StringBuilder buf = new StringBuilder("#<");
        buf.append(this.getMetaClass().getRealClass().getName());
        if (this.stat == null) {
            buf.append(": uninitialized");
        } else {
            buf.append(' ');
            try {
                buf.append("dev=0x").append(Long.toHexString(this.stat.dev()));
            }
            catch (Exception exception2) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("ino=").append(this.stat.ino());
            }
            catch (Exception exception3) {
            }
            finally {
                buf.append(", ");
            }
            buf.append("mode=0").append(Integer.toOctalString(this.stat.mode())).append(", ");
            try {
                buf.append("nlink=").append(this.stat.nlink());
            }
            catch (Exception exception4) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("uid=").append(this.stat.uid());
            }
            catch (Exception exception5) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("gid=").append(this.stat.gid());
            }
            catch (Exception exception6) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("rdev=0x").append(Long.toHexString(this.stat.rdev()));
            }
            catch (Exception exception7) {
            }
            finally {
                buf.append(", ");
            }
            buf.append("size=").append(this.sizeInternal()).append(", ");
            try {
                buf.append("blksize=").append(this.stat.blockSize());
            }
            catch (Exception exception8) {
            }
            finally {
                buf.append(", ");
            }
            try {
                buf.append("blocks=").append(this.stat.blocks());
            }
            catch (Exception exception9) {
            }
            finally {
                buf.append(", ");
            }
            buf.append("atime=").append(this.atime()).append(", ");
            buf.append("mtime=").append(this.mtime()).append(", ");
            buf.append("ctime=").append(this.ctime());
        }
        buf.append('>');
        return this.getRuntime().newString(buf.toString());
    }

    @JRubyMethod(name={"uid"})
    public IRubyObject uid() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.uid());
    }

    @JRubyMethod(name={"mode"})
    public IRubyObject mode() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.mode());
    }

    @JRubyMethod(name={"mtime"})
    public IRubyObject mtime() {
        this.checkInitialized();
        return this.getRuntime().newTime(this.stat.mtime() * 1000L);
    }

    public IRubyObject mtimeEquals(IRubyObject other) {
        return this.getRuntime().newBoolean(this.stat.mtime() == RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat.mtime());
    }

    public IRubyObject mtimeGreaterThan(IRubyObject other) {
        return this.getRuntime().newBoolean(this.stat.mtime() > RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat.mtime());
    }

    public IRubyObject mtimeLessThan(IRubyObject other) {
        return this.getRuntime().newBoolean(this.stat.mtime() < RubyFileStat.newFileStat((Ruby)this.getRuntime(), (String)other.convertToString().toString(), (boolean)false).stat.mtime());
    }

    @JRubyMethod(name={"nlink"})
    public IRubyObject nlink() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.nlink());
    }

    @JRubyMethod(name={"owned?"})
    public IRubyObject owned_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isOwned());
    }

    @JRubyMethod(name={"pipe?"})
    public IRubyObject pipe_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isNamedPipe());
    }

    @JRubyMethod(name={"rdev"})
    public IRubyObject rdev() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.rdev());
    }

    @JRubyMethod(name={"rdev_major"})
    public IRubyObject rdevMajor() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.major(this.stat.rdev()));
    }

    @JRubyMethod(name={"rdev_minor"})
    public IRubyObject rdevMinor() {
        this.checkInitialized();
        return this.getRuntime().newFixnum(this.stat.minor(this.stat.rdev()));
    }

    @JRubyMethod(name={"readable?"})
    public IRubyObject readable_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isReadable());
    }

    @JRubyMethod(name={"readable_real?"})
    public IRubyObject readableReal_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isReadableReal());
    }

    @JRubyMethod(name={"setgid?"})
    public IRubyObject setgid_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isSetgid());
    }

    @JRubyMethod(name={"setuid?"})
    public IRubyObject setuid_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isSetuid());
    }

    private long sizeInternal() {
        this.checkInitialized();
        if (Platform.IS_WINDOWS && this.file != null) {
            try {
                return this.file.length();
            }
            catch (SecurityException ex) {
                return 0L;
            }
        }
        return this.stat.st_size();
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size() {
        return this.getRuntime().newFixnum(this.sizeInternal());
    }

    @JRubyMethod(name={"size?"})
    public IRubyObject size_p() {
        long size2 = this.sizeInternal();
        if (size2 == 0L) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(size2);
    }

    @JRubyMethod(name={"socket?"})
    public IRubyObject socket_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isSocket());
    }

    @JRubyMethod(name={"sticky?"})
    public IRubyObject sticky_p() {
        this.checkInitialized();
        Ruby runtime = this.getRuntime();
        if (runtime.getPosix().isNative()) {
            return runtime.newBoolean(this.stat.isSticky());
        }
        return runtime.getNil();
    }

    @JRubyMethod(name={"symlink?"})
    public IRubyObject symlink_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isSymlink());
    }

    @JRubyMethod(name={"writable?"})
    public IRubyObject writable_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isWritable());
    }

    @JRubyMethod(name={"writable_real?"})
    public IRubyObject writableReal_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isWritableReal());
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        this.checkInitialized();
        return this.getRuntime().newBoolean(this.stat.isEmpty());
    }

    @JRubyMethod(name={"world_readable?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject worldReadable(ThreadContext context) {
        return this.getWorldMode(context, 4);
    }

    @JRubyMethod(name={"world_writable?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject worldWritable(ThreadContext context) {
        return this.getWorldMode(context, 2);
    }

    private IRubyObject getWorldMode(ThreadContext context, int mode2) {
        this.checkInitialized();
        if ((this.stat.mode() & mode2) == mode2) {
            return RubyNumeric.int2fix(context.runtime, this.stat.mode() & 0x1FF);
        }
        return context.runtime.getNil();
    }
}

