/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import org.jruby.ir.IRMethod;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReturnBase;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.transformations.inlining.InlinerInfo;

public class NonlocalReturnInstr
extends ReturnBase {
    public final IRMethod methodToReturnFrom;

    public NonlocalReturnInstr(Operand returnValue, IRMethod methodToReturnFrom) {
        super(Operation.NONLOCAL_RETURN, returnValue);
        this.methodToReturnFrom = methodToReturnFrom;
    }

    public NonlocalReturnInstr(Operand returnValue) {
        this(returnValue, null);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getOperation()) + "(" + this.returnValue + ", <" + (this.methodToReturnFrom == null ? "-NULL-" : this.methodToReturnFrom.getName()) + ">)";
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new NonlocalReturnInstr(this.returnValue.cloneForInlining(ii), this.methodToReturnFrom);
    }

    @Override
    public Instr cloneForInlinedScope(InlinerInfo ii) {
        if (ii.getInlineHostScope() == this.methodToReturnFrom) {
            return new NonlocalReturnInstr(this.returnValue.cloneForInlining(ii));
        }
        return this.cloneForInlining(ii);
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.NonlocalReturnInstr(this);
    }
}

