/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.fiber;

import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.RubyThread;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.JumpException;
import org.jruby.exceptions.RaiseException;
import org.jruby.ext.thread.SizedQueue;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.ExecutionContext;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class ThreadFiber
extends RubyObject
implements ExecutionContext {
    volatile FiberData data;
    volatile RubyThread thread;

    public ThreadFiber(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
    }

    public static void initRootFiber(ThreadContext context) {
        Ruby runtime = context.runtime;
        ThreadFiber rootFiber = new ThreadFiber(runtime, runtime.getClass("Fiber"));
        assert (runtime.getClass("SizedQueue") != null) : "SizedQueue has not been loaded";
        rootFiber.data = new FiberData(new SizedQueue(runtime, runtime.getClass("SizedQueue")), null, rootFiber);
        rootFiber.thread = context.getThread();
        context.setRootFiber(rootFiber);
    }

    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, Block block) {
        Ruby runtime = context.runtime;
        if (!block.isGiven()) {
            throw runtime.newArgumentError("tried to create Proc object without block");
        }
        this.data = new FiberData(new SizedQueue(runtime, runtime.getClass("SizedQueue")), context.getFiberCurrentThread(), this);
        FiberData currentFiberData = context.getFiber().data;
        this.thread = ThreadFiber.createThread(runtime, this.data, currentFiberData.queue, block);
        return context.nil;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject resume(ThreadContext context, IRubyObject[] values2) {
        IRubyObject val;
        Ruby runtime = context.runtime;
        if (this.data.prev != null || this.data.transferred) {
            throw runtime.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (this.data == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return runtime.newArrayNoCopyLight(values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = values2[0];
                break;
            }
            default: {
                val = runtime.newArrayNoCopyLight(values2);
            }
        }
        if (this.data.parent != context.getFiberCurrentThread()) {
            throw runtime.newFiberError("fiber called across threads");
        }
        this.data.prev = context.getFiber();
        try {
            IRubyObject iRubyObject = ThreadFiber.exchangeWithFiber(context, currentFiberData, this.data, val);
            return iRubyObject;
        }
        finally {
            this.data.prev = null;
        }
    }

    private static IRubyObject exchangeWithFiber(ThreadContext context, FiberData currentFiberData, FiberData targetFiberData, IRubyObject val) {
        targetFiberData.queue.push(context, val);
        while (true) {
            try {
                IRubyObject result2 = currentFiberData.queue.pop(context);
                if (result2 == NEVER) {
                    result2 = context.nil;
                }
                return result2;
            }
            catch (RaiseException re) {
                if (context.runtime.getLocalJumpError().isInstance(re.getException())) {
                    throw re;
                }
                if (currentFiberData.queue.isShutdown()) {
                    throw re;
                }
                if (targetFiberData.queue.isShutdown()) {
                    throw re;
                }
                ((ThreadFiber)targetFiberData.fiber.get()).thread.raise(re.getException());
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(rest=true)
    public IRubyObject __transfer__(ThreadContext context, IRubyObject[] values2) {
        IRubyObject val;
        Ruby runtime = context.runtime;
        if (this.data.prev != null) {
            throw runtime.newFiberError("double resume");
        }
        if (!this.alive()) {
            throw runtime.newFiberError("dead fiber called");
        }
        FiberData currentFiberData = context.getFiber().data;
        if (this.data == currentFiberData) {
            switch (values2.length) {
                case 0: {
                    return context.nil;
                }
                case 1: {
                    return values2[0];
                }
            }
            return runtime.newArrayNoCopyLight(values2);
        }
        switch (values2.length) {
            case 0: {
                val = NEVER;
                break;
            }
            case 1: {
                val = values2[0];
                break;
            }
            default: {
                val = runtime.newArrayNoCopyLight(values2);
            }
        }
        if (this.data.parent != context.getFiberCurrentThread()) {
            throw runtime.newFiberError("fiber called across threads");
        }
        if (currentFiberData.prev != null) {
            this.data.prev = currentFiberData.prev;
            currentFiberData.prev = null;
            currentFiberData.transferred = true;
        } else {
            this.data.prev = context.getFiber();
        }
        try {
            IRubyObject iRubyObject = ThreadFiber.exchangeWithFiber(context, currentFiberData, this.data, val);
            return iRubyObject;
        }
        finally {
            this.data.prev = null;
            currentFiberData.transferred = false;
        }
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2) {
        return ThreadFiber.yield(context, recv2, context.nil);
    }

    @JRubyMethod(meta=true)
    public static IRubyObject yield(ThreadContext context, IRubyObject recv2, IRubyObject value2) {
        Ruby runtime = context.runtime;
        FiberData currentFiberData = context.getFiber().data;
        if (currentFiberData.parent == null) {
            throw runtime.newFiberError("can't yield from root fiber");
        }
        if (currentFiberData.prev == null) {
            throw runtime.newFiberError("BUG: yield occured with null previous fiber. Report this at http://bugs.jruby.org");
        }
        if (currentFiberData.queue.isShutdown()) {
            throw runtime.newFiberError("dead fiber yielded");
        }
        FiberData prevFiberData = currentFiberData.prev.data;
        return ThreadFiber.exchangeWithFiber(context, currentFiberData, prevFiberData, value2);
    }

    @JRubyMethod
    public IRubyObject __alive__(ThreadContext context) {
        return context.runtime.newBoolean(this.thread != null && this.thread.isAlive());
    }

    @JRubyMethod(meta=true)
    public static IRubyObject __current__(ThreadContext context, IRubyObject recv2) {
        return context.getFiber();
    }

    @Override
    public Map<Object, IRubyObject> getContextVariables() {
        return this.thread.getContextVariables();
    }

    boolean alive() {
        return this.thread != null && this.thread.isAlive() && !this.data.queue.isShutdown();
    }

    static RubyThread createThread(final Ruby runtime, final FiberData data2, SizedQueue queue, final Block block) {
        final AtomicReference fiberThread = new AtomicReference();
        runtime.getFiberExecutor().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block9: {
                    ThreadContext context = runtime.getCurrentContext();
                    context.setFiber((ThreadFiber)data2.fiber.get());
                    context.setRootThread(data2.parent);
                    fiberThread.set(context.getThread());
                    try {
                        IRubyObject init = data2.queue.pop(context);
                        try {
                            IRubyObject result2 = init == RubyBasicObject.NEVER ? block.yieldSpecific(context) : block.yieldArray(context, init, null, null);
                            data2.prev.data.queue.push(context, result2);
                        }
                        finally {
                            data2.queue.shutdown();
                            runtime.getThreadService().disposeCurrentThread();
                        }
                    }
                    catch (JumpException.FlowControlException fce) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(fce.buildException(runtime).getException());
                        }
                    }
                    catch (RaiseException re) {
                        if (data2.prev != null) {
                            data2.prev.thread.raise(re.getException());
                        }
                    }
                    catch (Throwable t) {
                        if (data2.prev == null) break block9;
                        data2.prev.thread.raise(JavaUtil.convertJavaToUsableRubyObject(runtime, t));
                    }
                }
            }
        });
        while (fiberThread.get() == null) {
            Thread.yield();
        }
        return (RubyThread)fiberThread.get();
    }

    protected void finalize() throws Throwable {
        try {
            RubyThread thread2;
            FiberData data2 = this.data;
            if (data2 != null) {
                if (data2.parent == null) {
                    return;
                }
                data2.queue.shutdown();
            }
            if ((thread2 = this.thread) != null) {
                thread2.dieFromFinalizer();
                thread2.interrupt();
                data2 = null;
                Object var2_2 = null;
            }
        }
        finally {
            super.finalize();
        }
    }

    public FiberData getData() {
        return this.data;
    }

    public RubyThread getThread() {
        return this.thread;
    }

    public static class FiberData {
        final SizedQueue queue;
        volatile ThreadFiber prev;
        final RubyThread parent;
        final WeakReference<ThreadFiber> fiber;
        volatile boolean transferred;

        FiberData(SizedQueue queue, RubyThread parent, ThreadFiber fiber2) {
            this.queue = queue;
            this.parent = parent;
            this.fiber = new WeakReference<ThreadFiber>(fiber2);
        }

        public ThreadFiber getPrev() {
            return this.prev;
        }
    }
}

