/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport.proxy;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyNil;
import org.jruby.RubyObject;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.exceptions.RaiseException;
import org.jruby.javasupport.JavaCallable;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaObject;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.javasupport.proxy.JavaProxyConstructor;
import org.jruby.javasupport.proxy.JavaProxyInvocationHandler;
import org.jruby.javasupport.proxy.JavaProxyMethod;
import org.jruby.javasupport.proxy.JavaProxyReflectionObject;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.JRubyClassLoader;

public class JavaProxyClass
extends JavaProxyReflectionObject {
    static ThreadLocal<Ruby> runtimeTLS = new ThreadLocal();
    private final Class proxyClass;
    private final ArrayList<JavaProxyMethod> methods = new ArrayList();
    private final HashMap<String, ArrayList<JavaProxyMethod>> methodMap = new HashMap();
    private transient JavaProxyConstructor[] constructors;
    private static final HashSet<String> EXCLUDE_MODULES = new HashSet();
    private static final HashSet<String> EXCLUDE_METHODS;

    JavaProxyClass(Class<?> proxyClass) {
        super(JavaProxyClass.getThreadLocalRuntime(), JavaProxyClass.getThreadLocalRuntime().getModule("Java").getClass("JavaProxyClass"));
        this.proxyClass = proxyClass;
    }

    @Override
    public boolean equals(Object other) {
        return other instanceof JavaProxyClass && this.proxyClass == ((JavaProxyClass)other).proxyClass;
    }

    @Override
    public int hashCode() {
        return this.proxyClass.hashCode();
    }

    public Object getValue() {
        return this;
    }

    private static Ruby getThreadLocalRuntime() {
        return runtimeTLS.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JavaProxyClass getProxyClass(Ruby runtime, Class superClass, Class[] interfaces2, Set<String> names2) throws InvocationTargetException {
        Ruby save = runtimeTLS.get();
        runtimeTLS.set(runtime);
        try {
            JRubyClassLoader loader = runtime.getJRubyClassLoader();
            JavaProxyClass javaProxyClass = runtime.getJavaProxyClassFactory().newProxyClass(runtime, loader, null, superClass, interfaces2, names2);
            return javaProxyClass;
        }
        finally {
            runtimeTLS.set(save);
        }
    }

    public static JavaProxyClass getProxyClass(Ruby runtime, Class superClass, Class[] interfaces2) throws InvocationTargetException {
        return JavaProxyClass.getProxyClass(runtime, superClass, interfaces2, null);
    }

    public static Object newProxyInstance(Ruby runtime, Class superClass, Class[] interfaces2, Class[] constructorParameters, Object[] constructorArgs, JavaProxyInvocationHandler handler) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException, SecurityException, NoSuchMethodException {
        JavaProxyClass proxyClass = JavaProxyClass.getProxyClass(runtime, superClass, interfaces2);
        JavaProxyConstructor constructor2 = proxyClass.getConstructor(constructorParameters == null ? JavaClass.EMPTY_CLASS_ARRAY : constructorParameters);
        return constructor2.newInstance(constructorArgs, handler);
    }

    public Class getSuperclass() {
        return this.proxyClass.getSuperclass();
    }

    public Class[] getInterfaces() {
        Class<?>[] ifaces = this.proxyClass.getInterfaces();
        Class[] result2 = new Class[ifaces.length - 1];
        int j = 0;
        for (int i2 = 0; i2 < ifaces.length; ++i2) {
            if (ifaces[i2] == InternalJavaProxy.class) continue;
            result2[j++] = ifaces[i2];
        }
        return result2;
    }

    public JavaProxyConstructor[] getConstructors() {
        JavaProxyConstructor[] constructors2 = this.constructors;
        if (constructors2 != null) {
            return constructors2;
        }
        Ruby runtime = this.getRuntime();
        Constructor<?>[] ctors = this.proxyClass.getConstructors();
        constructors2 = new JavaProxyConstructor[ctors.length];
        for (int i2 = 0; i2 < ctors.length; ++i2) {
            constructors2[i2] = new JavaProxyConstructor(runtime, this, ctors[i2]);
        }
        this.constructors = constructors2;
        return constructors2;
    }

    public JavaProxyConstructor getConstructor(Class[] args2) throws SecurityException, NoSuchMethodException {
        Class[] realArgs = new Class[args2.length + 1];
        System.arraycopy(args2, 0, realArgs, 0, args2.length);
        realArgs[args2.length] = JavaProxyInvocationHandler.class;
        Constructor constructor2 = this.proxyClass.getConstructor(realArgs);
        return new JavaProxyConstructor(this.getRuntime(), this, constructor2);
    }

    public JavaProxyMethod[] getMethods() {
        return this.methods.toArray(new JavaProxyMethod[this.methods.size()]);
    }

    public JavaProxyMethod getMethod(String name2, Class[] parameterTypes) {
        List methods2 = this.methodMap.get(name2);
        if (methods2 != null && methods2.size() > 0) {
            int i2 = methods2.size();
            while (--i2 >= 0) {
                ProxyMethodImpl impl2 = (ProxyMethodImpl)methods2.get(i2);
                if (!impl2.matches(name2, parameterTypes)) continue;
                return impl2;
            }
        }
        return null;
    }

    final Class getProxyClass() {
        return this.proxyClass;
    }

    @Override
    public Class getJavaClass() {
        return this.proxyClass;
    }

    JavaProxyMethod initMethod(String name2, String desc, boolean hasSuper) {
        Class proxy2 = this.proxyClass;
        try {
            Class[] paramTypes = JavaProxyClass.parse(proxy2.getClassLoader(), desc);
            Method method2 = proxy2.getDeclaredMethod(name2, paramTypes);
            Method superMethod = null;
            if (hasSuper) {
                superMethod = proxy2.getDeclaredMethod("__super$" + name2, paramTypes);
            }
            ProxyMethodImpl proxyMethod = new ProxyMethodImpl(this.getRuntime(), this, method2, superMethod);
            this.methods.add(proxyMethod);
            ArrayList<JavaProxyMethod> methodsWithName = this.methodMap.get(name2);
            if (methodsWithName == null) {
                methodsWithName = new ArrayList(2);
                this.methodMap.put(name2, methodsWithName);
            }
            methodsWithName.add(proxyMethod);
            return proxyMethod;
        }
        catch (ClassNotFoundException e) {
            throw new InternalError(e.getMessage());
        }
        catch (SecurityException e) {
            throw new InternalError(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new InternalError(e.getMessage());
        }
    }

    private static Class[] parse(final ClassLoader loader, String desc) throws ClassNotFoundException {
        ArrayList<Class<Byte>> types = new ArrayList<Class<Byte>>();
        int idx = 1;
        while (desc.charAt(idx) != ')') {
            Class type2;
            int arr = 0;
            while (desc.charAt(idx) == '[') {
                ++idx;
                ++arr;
            }
            switch (desc.charAt(idx)) {
                case 'L': {
                    int semi = desc.indexOf(59, idx);
                    final String name2 = desc.substring(idx + 1, semi);
                    idx = semi;
                    try {
                        type2 = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                            @Override
                            public Class run() throws ClassNotFoundException {
                                return Class.forName(name2.replace('/', '.'), false, loader);
                            }
                        });
                        break;
                    }
                    catch (PrivilegedActionException e) {
                        throw (ClassNotFoundException)e.getException();
                    }
                }
                case 'B': {
                    type2 = Byte.TYPE;
                    break;
                }
                case 'C': {
                    type2 = Character.TYPE;
                    break;
                }
                case 'Z': {
                    type2 = Boolean.TYPE;
                    break;
                }
                case 'S': {
                    type2 = Short.TYPE;
                    break;
                }
                case 'I': {
                    type2 = Integer.TYPE;
                    break;
                }
                case 'J': {
                    type2 = Long.TYPE;
                    break;
                }
                case 'F': {
                    type2 = Float.TYPE;
                    break;
                }
                case 'D': {
                    type2 = Double.TYPE;
                    break;
                }
                default: {
                    throw new InternalError("cannot parse " + desc + "[" + idx + "]");
                }
            }
            ++idx;
            if (arr != 0) {
                type2 = Array.newInstance(type2, new int[arr]).getClass();
            }
            types.add(type2);
        }
        return types.toArray(new Class[types.size()]);
    }

    @Deprecated
    public static void createJavaProxyModule(Ruby runtime) {
        JavaProxyClass.createJavaProxyClasses(runtime, runtime.getJavaSupport().getJavaModule());
    }

    public static void createJavaProxyClasses(Ruby runtime, RubyModule Java2) {
        JavaProxyClass.createJavaProxyClassClass(runtime, Java2);
        ProxyMethodImpl.createJavaProxyMethodClass(runtime, Java2);
        JavaProxyConstructor.createJavaProxyConstructorClass(runtime, Java2);
    }

    public static RubyClass createJavaProxyClassClass(Ruby runtime, RubyModule Java2) {
        RubyClass JavaProxyClass2 = Java2.defineClassUnder("JavaProxyClass", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        JavaProxyReflectionObject.registerRubyMethods(runtime, JavaProxyClass2);
        JavaProxyClass2.defineAnnotatedMethods(JavaProxyClass.class);
        return JavaProxyClass2;
    }

    @JRubyMethod(meta=true)
    public static RubyObject get(IRubyObject self2, IRubyObject obj) {
        Ruby runtime = self2.getRuntime();
        if (!(obj instanceof JavaClass)) {
            throw runtime.newTypeError(obj, runtime.getJavaSupport().getJavaClassClass());
        }
        JavaClass type2 = (JavaClass)obj;
        try {
            return JavaProxyClass.getProxyClass(runtime, type2.javaClass(), JavaClass.EMPTY_CLASS_ARRAY);
        }
        catch (Error e) {
            RaiseException ex = runtime.newArgumentError("unable to create proxy class for " + type2.getValue());
            ex.initCause(e);
            throw ex;
        }
        catch (InvocationTargetException e) {
            RaiseException ex = runtime.newArgumentError("unable to create proxy class for " + type2.getValue());
            ex.initCause(e);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @JRubyMethod(meta=true)
    public static RubyObject get_with_class(IRubyObject recv, IRubyObject obj) {
        runtime = recv.getRuntime();
        if (!(obj instanceof RubyClass)) {
            throw runtime.newTypeError(obj, runtime.getClassClass());
        }
        clazz = (RubyClass)obj;
        javaClass = null;
        names = new HashSet<String>();
        interfaceList = new ArrayList<Class>();
        ancestors = clazz.getAncestorList();
        skipRemainingClasses = false;
        var9_9 = ancestors.iterator();
        block7: while (true) {
            block29: {
                block30: {
                    block27: {
                        block28: {
                            if (!var9_9.hasNext()) break block27;
                            ancestorObject = var9_9.next();
                            ancestor = (RubyModule)ancestorObject;
                            if (!(ancestor instanceof RubyClass)) break block28;
                            if (skipRemainingClasses) continue;
                            if (!ancestor.getInstanceVariables().hasInstanceVariable("@java_proxy_class")) {
                                skipRemainingClasses = true;
                                continue;
                            }
                            var = ancestor.getInstanceVariables().getInstanceVariable("@java_class");
                            if (var == null) {
                                throw runtime.newTypeError("no java_class defined for proxy (or ancestor): " + ancestor);
                            }
                            if (!(var instanceof JavaClass)) {
                                throw runtime.newTypeError("invalid java_class defined for proxy (or ancestor): " + ancestor + ": " + var);
                            }
                            if (javaClass == null) {
                                javaClass = (JavaClass)var;
                            } else if (javaClass != var) {
                                throw runtime.newTypeError("java_class defined for " + clazz + " (" + javaClass + ") does not match java_class for ancestor " + ancestor + " (" + var + ")");
                            }
                            var = ancestor.getInstanceVariables().getInstanceVariable("@java_interfaces");
                            if (var == null || var instanceof RubyNil) break block29;
                            if (!(var instanceof RubyArray)) {
                                throw runtime.newTypeError("invalid java_interfaces defined for proxy (or ancestor): " + ancestor + ": " + var);
                            }
                            ifcArray = (RubyArray)var;
                            i = size = ifcArray.size();
                            break block30;
                        }
                        if (JavaProxyClass.EXCLUDE_MODULES.contains(ancestor.getName())) continue;
                        var13_17 = methods = ancestor.getMethods();
                        // MONITORENTER : methods
                        for (String methodName : methods.keySet()) {
                            if (JavaProxyClass.EXCLUDE_METHODS.contains(methodName)) continue;
                            names.add(methodName);
                        }
                        // MONITOREXIT : var13_17
                        continue;
                    }
                    if (javaClass == null) {
                        throw runtime.newArgumentError("unable to create proxy class: no java_class defined for " + clazz);
                    }
                    interfaceCount = interfaceList.size();
                    interfaces = new Class[interfaceCount];
                    i = interfaceCount;
                    while (--i >= 0) {
                        interfaces[i] = (Class)interfaceList.get(i);
                    }
                    try {
                        return JavaProxyClass.getProxyClass(runtime, javaClass.javaClass(), interfaces, names);
                    }
                    catch (Error e) {
                        ex = runtime.newArgumentError("unable to create proxy class for " + javaClass.getValue() + " : " + e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                    catch (InvocationTargetException e) {
                        ex = runtime.newArgumentError("unable to create proxy class for " + javaClass.getValue() + " : " + e.getMessage());
                        ex.initCause(e);
                        throw ex;
                    }
                }
                while (--i >= 0) {
                    ifc = ifcArray.eltInternal(i);
                    if (!(ifc instanceof JavaClass)) {
                        throw runtime.newTypeError("invalid java interface defined for proxy (or ancestor): " + ancestor + ": " + ifc);
                    }
                    interfaceClass = ((JavaClass)ifc).javaClass();
                    if (!interfaceClass.isInterface()) {
                        throw runtime.newTypeError("invalid java interface defined for proxy (or ancestor): " + ancestor + ": " + ifc + " (not an interface)");
                    }
                    if (interfaceList.contains(interfaceClass)) continue;
                    interfaceList.add(interfaceClass);
                }
            }
            if ((var = ancestor.getInstanceVariables().getInstanceVariable("@__java_ovrd_methods")) == null) {
                i = methods = ancestor.getMethods();
                // MONITORENTER : methods
                methodNames = RubyArray.newArrayLight(runtime, methods.size());
                for (String methodName : methods.keySet()) {
                    if (JavaProxyClass.EXCLUDE_METHODS.contains(methodName)) continue;
                    names.add(methodName);
                    methodNames.append(runtime.newString(methodName));
                }
                // MONITOREXIT : i
                ancestor.setInstanceVariable("@__java_ovrd_methods", methodNames);
                continue;
            }
            if (!(var instanceof RubyArray)) {
                throw runtime.newTypeError("invalid @__java_ovrd_methods defined for proxy: " + ancestor + ": " + var);
            }
            methodNames = (RubyArray)var;
            i = size = methodNames.size();
            while (true) {
                if (--i >= 0) ** break;
                continue block7;
                methodName = methodNames.eltInternal(i);
                if (!(methodName instanceof RubyString)) {
                    throw runtime.newTypeError("invalid method name defined for proxy (or ancestor): " + ancestor + ": " + methodName);
                }
                names.add(methodName.asJavaString());
            }
            break;
        }
    }

    @JRubyMethod
    public RubyObject superclass() {
        return JavaClass.get(this.getRuntime(), this.getSuperclass());
    }

    @JRubyMethod
    public RubyArray methods() {
        return this.toRubyArray(this.getMethods());
    }

    @JRubyMethod
    public RubyArray interfaces() {
        return this.toRubyArray(this.getInterfaces());
    }

    @JRubyMethod
    public final RubyArray constructors() {
        return this.toRubyArray(this.getConstructors());
    }

    public final String nameOnInspection() {
        return "[Proxy:" + this.getSuperclass().getName() + "]";
    }

    static {
        EXCLUDE_MODULES.add("Kernel");
        EXCLUDE_MODULES.add("Java");
        EXCLUDE_MODULES.add("JavaProxyMethods");
        EXCLUDE_MODULES.add("Enumerable");
        EXCLUDE_METHODS = new HashSet();
        EXCLUDE_METHODS.add("class");
        EXCLUDE_METHODS.add("finalize");
        EXCLUDE_METHODS.add("initialize");
        EXCLUDE_METHODS.add("java_class");
        EXCLUDE_METHODS.add("java_object");
        EXCLUDE_METHODS.add("__jcreate!");
        EXCLUDE_METHODS.add("__jsend!");
    }

    @JRubyClass(name={"Java::JavaProxyMethod"})
    public static class ProxyMethodImpl
    extends JavaProxyReflectionObject
    implements JavaProxyMethod {
        private final Method method;
        private final Method superMethod;
        private final Class[] parameterTypes;
        private final JavaProxyClass proxyClass;
        private Object state;

        public static RubyClass createJavaProxyMethodClass(Ruby runtime, RubyModule Java2) {
            RubyClass JavaProxyMethod2 = Java2.defineClassUnder("JavaProxyMethod", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
            JavaProxyReflectionObject.registerRubyMethods(runtime, JavaProxyMethod2);
            JavaProxyMethod2.defineAnnotatedMethods(ProxyMethodImpl.class);
            return JavaProxyMethod2;
        }

        public ProxyMethodImpl(Ruby runtime, JavaProxyClass clazz, Method method2, Method superMethod) {
            super(runtime, ProxyMethodImpl.getJavaProxyMethod(runtime));
            this.method = method2;
            this.parameterTypes = method2.getParameterTypes();
            this.superMethod = superMethod;
            this.proxyClass = clazz;
        }

        private static RubyClass getJavaProxyMethod(Ruby runtime) {
            return runtime.getJavaSupport().getJavaModule().getClass("JavaProxyMethod");
        }

        @Override
        public boolean equals(Object other) {
            if (!(other instanceof ProxyMethodImpl)) {
                return false;
            }
            ProxyMethodImpl that = (ProxyMethodImpl)other;
            return this.method == that.method || this.method.equals(that.method);
        }

        @Override
        public int hashCode() {
            return this.method.hashCode();
        }

        public Method getMethod() {
            return this.method;
        }

        @Override
        public Method getSuperMethod() {
            return this.superMethod;
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public String getName() {
            return this.method.getName();
        }

        @Override
        public final Class<?>[] getExceptionTypes() {
            return this.method.getExceptionTypes();
        }

        @Override
        public final Class<?>[] getParameterTypes() {
            return this.parameterTypes;
        }

        @Override
        public final boolean isVarArgs() {
            return this.method.isVarArgs();
        }

        @Override
        public boolean hasSuperImplementation() {
            return this.superMethod != null;
        }

        @Override
        public Object invoke(Object proxy2, Object[] args2) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
            if (!this.hasSuperImplementation()) {
                throw new NoSuchMethodException();
            }
            return this.superMethod.invoke(proxy2, args2);
        }

        @Override
        public Object getState() {
            return this.state;
        }

        @Override
        public void setState(Object state2) {
            this.state = state2;
        }

        @Override
        public String toString() {
            return this.method.toString();
        }

        @Override
        public Object defaultResult() {
            Class<?> returnType = this.method.getReturnType();
            if (returnType == Void.TYPE) {
                return null;
            }
            if (returnType == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (returnType == Byte.TYPE) {
                return (byte)0;
            }
            if (returnType == Short.TYPE) {
                return (short)0;
            }
            if (returnType == Integer.TYPE) {
                return 0;
            }
            if (returnType == Long.TYPE) {
                return 0L;
            }
            if (returnType == Float.TYPE) {
                return new Float(0.0f);
            }
            if (returnType == Double.TYPE) {
                return new Double(0.0);
            }
            return null;
        }

        public final boolean matches(String name2, Class<?>[] parameterTypes) {
            return this.method.getName().equals(name2) && Arrays.equals(this.parameterTypes, parameterTypes);
        }

        @Override
        public final Class<?> getReturnType() {
            return this.method.getReturnType();
        }

        public RubyObject name() {
            return this.getRuntime().newString(this.getName());
        }

        @Override
        @JRubyMethod(name={"declaring_class"})
        public final JavaProxyClass getDeclaringClass() {
            return this.proxyClass;
        }

        @JRubyMethod
        public RubyArray argument_types() {
            return this.toRubyArray(this.getParameterTypes());
        }

        @JRubyMethod(name={"super?"})
        public IRubyObject super_p() {
            return this.hasSuperImplementation() ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
        }

        @JRubyMethod
        public RubyFixnum arity() {
            return this.getRuntime().newFixnum(this.getArity());
        }

        @Deprecated
        protected String nameOnInspection() {
            return this.getDeclaringClass().nameOnInspection() + "/" + this.getName();
        }

        @Override
        @JRubyMethod
        public RubyString inspect() {
            StringBuilder str = new StringBuilder();
            str.append("#<");
            str.append(this.getDeclaringClass().nameOnInspection()).append('/').append(this.getName());
            JavaCallable.inspectParameterTypes(str, this);
            str.append(">");
            return this.getRuntime().newString(str.toString());
        }

        @JRubyMethod(name={"invoke"}, rest=true)
        public IRubyObject do_invoke(IRubyObject[] args2) {
            Ruby runtime = this.getRuntime();
            if (args2.length != 1 + this.getArity()) {
                throw runtime.newArgumentError(args2.length, 1 + this.getArity());
            }
            IRubyObject invokee = args2[0];
            if (!(invokee instanceof JavaObject)) {
                throw runtime.newTypeError("invokee not a java object");
            }
            Object receiver_value = ((JavaObject)invokee).getValue();
            Object[] arguments = new Object[args2.length - 1];
            Class<?>[] parameterTypes = this.getParameterTypes();
            for (int i2 = 0; i2 < arguments.length; ++i2) {
                arguments[i2] = args2[i2 + 1].toJava(parameterTypes[i2]);
            }
            try {
                Object javaResult = this.superMethod.invoke(receiver_value, arguments);
                return JavaUtil.convertJavaToRuby(runtime, javaResult, this.getReturnType());
            }
            catch (IllegalArgumentException ex) {
                throw runtime.newTypeError("expected " + this.argument_types().inspect());
            }
            catch (IllegalAccessException ex) {
                throw runtime.newTypeError("illegal access on '" + this.superMethod.getName() + "': " + ex.getMessage());
            }
            catch (InvocationTargetException ex) {
                if (runtime.getDebug().isTrue()) {
                    ex.getTargetException().printStackTrace();
                }
                runtime.getJavaSupport().handleNativeException(ex.getTargetException(), this.superMethod);
                return runtime.getNil();
            }
        }

        @Override
        public final int getArity() {
            return this.getParameterTypes().length;
        }
    }
}

