/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.transformations.inlining;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jruby.RubyModule;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IRScope;
import org.jruby.ir.Tuple;
import org.jruby.ir.instructions.CallBase;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.ModuleVersionGuardInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.representations.ExceptionRegion;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.ir.util.Edge;

public class CFGInliner {
    private CFG cfg;

    public CFGInliner(CFG build) {
        this.cfg = build;
    }

    private CFG cloneSelf(InlinerInfo ii) {
        CFG selfClone = new CFG(this.cfg.getScope());
        BasicBlock entry = this.cfg.getEntryBB();
        BasicBlock exit2 = this.cfg.getExitBB();
        for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
            if (b2 == entry || b2 == exit2) continue;
            selfClone.addBasicBlock(b2.cloneForInlinedMethod(ii));
        }
        for (BasicBlock b2 : this.cfg.getBasicBlocks()) {
            if (b2 == entry || b2 == exit2) continue;
            BasicBlock rb = ii.getRenamedBB(b2);
            for (Edge<BasicBlock> e : this.cfg.getOutgoingEdges(b2)) {
                BasicBlock destination = e.getDestination().getData();
                if (destination == exit2) continue;
                selfClone.addEdge(rb, ii.getRenamedBB(destination), e.getType());
            }
        }
        return selfClone;
    }

    public void inlineMethod(IRScope scope, RubyModule implClass, int classToken, BasicBlock callBB, CallBase call2) {
        BasicBlock callBBensurer;
        IRScope hostScope = this.cfg.getScope();
        if (hostScope.getNearestMethod() == scope) {
            return;
        }
        InlinerInfo ii = new InlinerInfo(call2, this.cfg);
        Label splitBBLabel = hostScope.getNewLabel();
        CFG methodCFG = scope.getCFG();
        BasicBlock mEntry = methodCFG.getEntryBB();
        BasicBlock mExit = methodCFG.getExitBB();
        ArrayList<BasicBlock> methodBBs = new ArrayList<BasicBlock>();
        for (BasicBlock basicBlock : methodCFG.getBasicBlocks()) {
            methodBBs.add(basicBlock);
        }
        if (hostScope.getNearestMethod() == scope) {
            Iterator<Object> selfClone = this.cloneSelf(ii);
            for (BasicBlock b3 : ((CFG)((Object)selfClone)).getBasicBlocks()) {
                this.cfg.addBasicBlock(b3);
                for (Edge<BasicBlock> e : ((CFG)((Object)selfClone)).getOutgoingEdges(b3)) {
                    this.cfg.addEdge(b3, e.getDestination().getData(), e.getType());
                }
            }
        } else {
            for (BasicBlock basicBlock : methodCFG.getBasicBlocks()) {
                if (basicBlock == mEntry || basicBlock == mExit) continue;
                this.cfg.addBasicBlock(basicBlock.cloneForInlinedMethod(ii));
            }
            for (BasicBlock basicBlock : methodCFG.getBasicBlocks()) {
                if (basicBlock == mEntry || basicBlock == mExit) continue;
                BasicBlock rx = ii.getRenamedBB(basicBlock);
                for (Edge<BasicBlock> e : methodCFG.getOutgoingEdges(basicBlock)) {
                    BasicBlock b4 = e.getDestination().getData();
                    if (b4 == mExit) continue;
                    this.cfg.addEdge(rx, ii.getRenamedBB(b4), e.getType());
                }
            }
        }
        if (callBB == null) {
            block6: for (BasicBlock basicBlock : this.cfg.getBasicBlocks()) {
                for (Instr i2 : basicBlock.getInstrs()) {
                    if (i2 != call2) continue;
                    callBB = basicBlock;
                    continue block6;
                }
            }
        }
        if (callBB == null) {
            System.out.println("----------------------------------");
            System.out.println("Did not find BB with call: " + call2);
            System.out.println("Host cfg   :" + this.cfg.toStringGraph());
            System.out.println("Host instrs:" + this.cfg.toStringInstrs());
            System.out.println("----------------------------------");
            return;
        }
        BasicBlock splitBB = callBB.splitAtInstruction(call2, splitBBLabel, false);
        this.cfg.addBasicBlock(splitBB);
        for (Edge edge : this.cfg.getOutgoingEdges(callBB)) {
            this.cfg.addEdge(splitBB, (BasicBlock)edge.getDestination().getData(), edge.getType());
        }
        this.cfg.removeAllOutgoingEdgesForBB(callBB);
        assert (methodCFG.outDegree(mEntry) == 2) : "Entry BB of inlinee method does not have outdegree 2: " + methodCFG.toStringGraph();
        for (Edge edge : methodCFG.getOutgoingEdges(mEntry)) {
            BasicBlock destination = (BasicBlock)edge.getDestination().getData();
            if (destination == mExit) continue;
            BasicBlock dstBB = ii.getRenamedBB(destination);
            if (!ii.canMapArgsStatically()) {
                dstBB.addInstr(new ToAryInstr((Variable)ii.getArgs(), new Array(call2.getCallArgs()), this.cfg.getScope().getManager().getTrue()));
            }
            this.cfg.addEdge(callBB, dstBB, (Object)CFG.EdgeType.FALL_THROUGH);
        }
        for (Edge edge : methodCFG.getIncomingEdges(mExit)) {
            BasicBlock source2 = (BasicBlock)edge.getSource().getData();
            if (source2 == mEntry) continue;
            BasicBlock clonedSource = ii.getRenamedBB(source2);
            if (edge.getType() == CFG.EdgeType.EXCEPTION) {
                BasicBlock rescuerOfSplitBB = this.cfg.getRescuerBBFor(splitBB);
                if (rescuerOfSplitBB != null) {
                    this.cfg.addEdge(clonedSource, rescuerOfSplitBB, (Object)CFG.EdgeType.EXCEPTION);
                    continue;
                }
                this.cfg.addEdge(clonedSource, this.cfg.getExitBB(), (Object)CFG.EdgeType.EXIT);
                continue;
            }
            this.cfg.addEdge(clonedSource, splitBB, edge.getType());
        }
        List<ExceptionRegion> exceptionRegions = this.cfg.getOutermostExceptionRegions();
        for (ExceptionRegion r : methodCFG.getOutermostExceptionRegions()) {
            exceptionRegions.add(r.cloneForInlining(ii));
        }
        BasicBlock basicBlock = this.cfg.getRescuerBBFor(callBB);
        if (basicBlock != null) {
            this.cfg.setRescuerBB(splitBB, basicBlock);
        }
        if ((callBBensurer = this.cfg.getEnsurerBBFor(callBB)) != null) {
            this.cfg.setEnsurerBB(splitBB, callBBensurer);
        }
        for (BasicBlock x : methodBBs) {
            if (x == mEntry || x == mExit) continue;
            BasicBlock xRenamed = ii.getRenamedBB(x);
            BasicBlock xProtector = methodCFG.getRescuerBBFor(x);
            if (xProtector != null) {
                this.cfg.setRescuerBB(xRenamed, ii.getRenamedBB(xProtector));
            } else if (basicBlock != null) {
                this.cfg.setRescuerBB(xRenamed, basicBlock);
            }
            BasicBlock xEnsurer = methodCFG.getEnsurerBBFor(x);
            if (xEnsurer != null) {
                this.cfg.setEnsurerBB(xRenamed, ii.getRenamedBB(xEnsurer));
                continue;
            }
            if (callBBensurer == null) continue;
            this.cfg.setEnsurerBB(xRenamed, callBBensurer);
        }
        Label failurePathLabel = hostScope.getNewLabel();
        callBB.addInstr(new ModuleVersionGuardInstr(implClass, classToken, call2.getReceiver(), failurePathLabel));
        BasicBlock failurePathBB = new BasicBlock(this.cfg, failurePathLabel);
        this.cfg.addBasicBlock(failurePathBB);
        failurePathBB.addInstr(call2);
        failurePathBB.addInstr(new JumpInstr(splitBBLabel));
        call2.blockInlining();
        this.cfg.addEdge(callBB, failurePathBB, (Object)CFG.EdgeType.REGULAR);
        this.cfg.addEdge(failurePathBB, splitBB, (Object)CFG.EdgeType.REGULAR);
        Operand closureArg = call2.getClosureArg(null);
        List yieldSites = ii.getYieldSites();
        if (closureArg != null && !yieldSites.isEmpty()) {
            if (yieldSites.size() > 1) {
                throw new RuntimeException("Encountered " + yieldSites.size() + " yield sites.  Convert the yield to a call by converting the closure into a dummy method (have to convert all frame vars to call arguments, or at least convert the frame into a call arg");
            }
            if (!(closureArg instanceof WrappedIRClosure)) {
                throw new RuntimeException("Encountered a dynamic closure arg.  Cannot inline it here!  Convert the yield to a call by converting the closure into a dummy method (have to convert all frame vars to call arguments, or at least convert the frame into a call arg");
            }
            Tuple t = (Tuple)yieldSites.get(0);
            this.inlineClosureAtYieldSite(ii, ((WrappedIRClosure)closureArg).getClosure(), (BasicBlock)t.a, (YieldInstr)t.b);
        }
        this.cfg.collapseStraightLineBBs();
    }

    private void inlineClosureAtYieldSite(InlinerInfo ii, IRClosure cl, BasicBlock yieldBB, YieldInstr yield2) {
        BasicBlock yieldBBensurer;
        BasicBlock splitBB = yieldBB.splitAtInstruction(yield2, this.cfg.getScope().getNewLabel(), false);
        this.cfg.addBasicBlock(splitBB);
        for (Edge<BasicBlock> e : this.cfg.getOutgoingEdges(yieldBB)) {
            this.cfg.addEdge(splitBB, e.getDestination().getData(), e.getType());
        }
        this.cfg.removeAllOutgoingEdgesForBB(yieldBB);
        ii = ii.cloneForInliningClosure();
        ii.setupYieldArgsAndYieldResult(yield2, yieldBB, cl.getBlockBody().arity());
        CFG closureCFG = cl.getCFG();
        BasicBlock cEntry = closureCFG.getEntryBB();
        BasicBlock cExit = closureCFG.getExitBB();
        for (BasicBlock basicBlock : closureCFG.getBasicBlocks()) {
            if (basicBlock == cEntry || basicBlock == cExit) continue;
            this.cfg.addBasicBlock(basicBlock.cloneForInlinedClosure(ii));
        }
        for (BasicBlock basicBlock : closureCFG.getBasicBlocks()) {
            if (basicBlock == cEntry || basicBlock == cExit) continue;
            BasicBlock bClone = ii.getRenamedBB(basicBlock);
            for (Edge<BasicBlock> e : closureCFG.getOutgoingEdges(basicBlock)) {
                BasicBlock edst = e.getDestination().getData();
                if (edst == cExit) continue;
                this.cfg.addEdge(bClone, ii.getRenamedBB(edst), e.getType());
            }
        }
        for (Edge edge : closureCFG.getOutgoingEdges(cEntry)) {
            BasicBlock destination = (BasicBlock)edge.getDestination().getData();
            if (destination == cExit) continue;
            this.cfg.addEdge(yieldBB, ii.getRenamedBB(destination), (Object)CFG.EdgeType.FALL_THROUGH);
        }
        for (Edge edge : closureCFG.getIncomingEdges(cExit)) {
            BasicBlock source2 = (BasicBlock)edge.getSource().getData();
            if (source2 == cEntry) continue;
            BasicBlock clonedSource = ii.getRenamedBB(source2);
            if (edge.getType() == CFG.EdgeType.EXCEPTION) {
                BasicBlock rescuerOfSplitBB = this.cfg.getRescuerBBFor(splitBB);
                if (rescuerOfSplitBB != null) {
                    this.cfg.addEdge(clonedSource, rescuerOfSplitBB, (Object)CFG.EdgeType.EXCEPTION);
                    continue;
                }
                this.cfg.addEdge(clonedSource, this.cfg.getExitBB(), (Object)CFG.EdgeType.EXIT);
                continue;
            }
            this.cfg.addEdge(clonedSource, splitBB, edge.getType());
        }
        List<ExceptionRegion> exceptionRegions = this.cfg.getOutermostExceptionRegions();
        for (ExceptionRegion r : closureCFG.getOutermostExceptionRegions()) {
            exceptionRegions.add(r.cloneForInlining(ii));
        }
        BasicBlock basicBlock = this.cfg.getRescuerBBFor(yieldBB);
        if (basicBlock != null) {
            this.cfg.setRescuerBB(splitBB, basicBlock);
        }
        if ((yieldBBensurer = this.cfg.getEnsurerBBFor(yieldBB)) != null) {
            this.cfg.setEnsurerBB(splitBB, yieldBBensurer);
        }
        for (BasicBlock cb : closureCFG.getBasicBlocks()) {
            if (cb == cEntry || cb == cExit) continue;
            BasicBlock cbProtector = ii.getRenamedBB(closureCFG.getRescuerBBFor(cb));
            if (cbProtector != null) {
                this.cfg.setRescuerBB(cb, cbProtector);
            } else if (basicBlock != null) {
                this.cfg.setRescuerBB(cb, basicBlock);
            }
            BasicBlock cbEnsurer = ii.getRenamedBB(closureCFG.getEnsurerBBFor(cb));
            if (cbEnsurer != null) {
                this.cfg.setEnsurerBB(cb, cbEnsurer);
                continue;
            }
            if (yieldBBensurer == null) continue;
            this.cfg.setEnsurerBB(cb, yieldBBensurer);
        }
    }
}

