/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir.instructions;

import java.util.Map;
import org.jruby.ir.IRVisitor;
import org.jruby.ir.Operation;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.javasupport.util.RuntimeHelpers;
import org.jruby.runtime.Block;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public class UndefMethodInstr
extends Instr
implements ResultInstr {
    private Variable result;
    private Operand methodName;

    public UndefMethodInstr(Variable result2, Operand methodName) {
        super(Operation.UNDEF_METHOD);
        this.result = result2;
        this.methodName = methodName;
    }

    @Override
    public Operand[] getOperands() {
        return new Operand[]{this.methodName};
    }

    @Override
    public String toString() {
        return super.toString() + "(" + this.methodName + ")";
    }

    @Override
    public void simplifyOperands(Map<Operand, Operand> valueMap, boolean force) {
        this.methodName = this.methodName.getSimplifiedOperand(valueMap, force);
    }

    @Override
    public Variable getResult() {
        return this.result;
    }

    @Override
    public void updateResult(Variable v) {
        this.result = v;
    }

    @Override
    public Instr cloneForInlining(InlinerInfo ii) {
        return new UndefMethodInstr((Variable)this.result.cloneForInlining(ii), this.methodName.cloneForInlining(ii));
    }

    @Override
    public Object interpret(ThreadContext context, DynamicScope currDynScope, IRubyObject self, Object[] temp, Block block) {
        return RuntimeHelpers.undefMethod(context, this.methodName.retrieve(context, self, currDynScope, temp));
    }

    @Override
    public void visit(IRVisitor visitor) {
        visitor.UndefMethodInstr(this);
    }
}

