/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.jruby.Ruby;
import org.jruby.RubyInstanceConfig;
import org.jruby.ast.AliasNode;
import org.jruby.ast.AndNode;
import org.jruby.ast.ArgsCatNode;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgsPushNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.ArrayNode;
import org.jruby.ast.AttrAssignNode;
import org.jruby.ast.BackRefNode;
import org.jruby.ast.BeginNode;
import org.jruby.ast.BignumNode;
import org.jruby.ast.BlockNode;
import org.jruby.ast.BlockPassNode;
import org.jruby.ast.BreakNode;
import org.jruby.ast.CallNode;
import org.jruby.ast.CaseNode;
import org.jruby.ast.ClassNode;
import org.jruby.ast.ClassVarAsgnNode;
import org.jruby.ast.ClassVarDeclNode;
import org.jruby.ast.ClassVarNode;
import org.jruby.ast.Colon2ConstNode;
import org.jruby.ast.Colon2MethodNode;
import org.jruby.ast.Colon2Node;
import org.jruby.ast.Colon3Node;
import org.jruby.ast.ConstDeclNode;
import org.jruby.ast.ConstNode;
import org.jruby.ast.DAsgnNode;
import org.jruby.ast.DRegexpNode;
import org.jruby.ast.DStrNode;
import org.jruby.ast.DSymbolNode;
import org.jruby.ast.DVarNode;
import org.jruby.ast.DXStrNode;
import org.jruby.ast.DefinedNode;
import org.jruby.ast.DefsNode;
import org.jruby.ast.DotNode;
import org.jruby.ast.EnsureNode;
import org.jruby.ast.EvStrNode;
import org.jruby.ast.FCallNode;
import org.jruby.ast.FixnumNode;
import org.jruby.ast.FlipNode;
import org.jruby.ast.FloatNode;
import org.jruby.ast.ForNode;
import org.jruby.ast.GlobalAsgnNode;
import org.jruby.ast.GlobalVarNode;
import org.jruby.ast.HashNode;
import org.jruby.ast.IfNode;
import org.jruby.ast.InstAsgnNode;
import org.jruby.ast.InstVarNode;
import org.jruby.ast.IterNode;
import org.jruby.ast.ListNode;
import org.jruby.ast.LiteralNode;
import org.jruby.ast.LocalAsgnNode;
import org.jruby.ast.LocalVarNode;
import org.jruby.ast.Match2Node;
import org.jruby.ast.Match3Node;
import org.jruby.ast.MatchNode;
import org.jruby.ast.MethodDefNode;
import org.jruby.ast.ModuleNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.NewlineNode;
import org.jruby.ast.NextNode;
import org.jruby.ast.Node;
import org.jruby.ast.NodeType;
import org.jruby.ast.NotNode;
import org.jruby.ast.NthRefNode;
import org.jruby.ast.OpAsgnAndNode;
import org.jruby.ast.OpAsgnNode;
import org.jruby.ast.OpAsgnOrNode;
import org.jruby.ast.OpElementAsgnNode;
import org.jruby.ast.OrNode;
import org.jruby.ast.PostExeNode;
import org.jruby.ast.PreExeNode;
import org.jruby.ast.RegexpNode;
import org.jruby.ast.RescueBodyNode;
import org.jruby.ast.RescueNode;
import org.jruby.ast.ReturnNode;
import org.jruby.ast.RootNode;
import org.jruby.ast.SClassNode;
import org.jruby.ast.SValueNode;
import org.jruby.ast.SelfNode;
import org.jruby.ast.SplatNode;
import org.jruby.ast.StarNode;
import org.jruby.ast.StrNode;
import org.jruby.ast.SuperNode;
import org.jruby.ast.SymbolNode;
import org.jruby.ast.ToAryNode;
import org.jruby.ast.UndefNode;
import org.jruby.ast.UntilNode;
import org.jruby.ast.VAliasNode;
import org.jruby.ast.VCallNode;
import org.jruby.ast.WhenNode;
import org.jruby.ast.WhileNode;
import org.jruby.ast.XStrNode;
import org.jruby.ast.YieldNode;
import org.jruby.ast.ZSuperNode;
import org.jruby.compiler.NotCompilableException;
import org.jruby.ir.IRBuilder19;
import org.jruby.ir.IRClassBody;
import org.jruby.ir.IRClosure;
import org.jruby.ir.IREvalScript;
import org.jruby.ir.IRLoop;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMetaClassBody;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRModuleBody;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScriptBody;
import org.jruby.ir.instructions.AliasInstr;
import org.jruby.ir.instructions.AttrAssignInstr;
import org.jruby.ir.instructions.BEQInstr;
import org.jruby.ir.instructions.BNEInstr;
import org.jruby.ir.instructions.BlockGivenInstr;
import org.jruby.ir.instructions.BreakInstr;
import org.jruby.ir.instructions.CallInstr;
import org.jruby.ir.instructions.CheckArityInstr;
import org.jruby.ir.instructions.ClassSuperInstr;
import org.jruby.ir.instructions.ConstMissingInstr;
import org.jruby.ir.instructions.CopyInstr;
import org.jruby.ir.instructions.DefineClassInstr;
import org.jruby.ir.instructions.DefineClassMethodInstr;
import org.jruby.ir.instructions.DefineInstanceMethodInstr;
import org.jruby.ir.instructions.DefineMetaClassInstr;
import org.jruby.ir.instructions.DefineModuleInstr;
import org.jruby.ir.instructions.EQQInstr;
import org.jruby.ir.instructions.EnsureRubyArrayInstr;
import org.jruby.ir.instructions.ExceptionRegionEndMarkerInstr;
import org.jruby.ir.instructions.ExceptionRegionStartMarkerInstr;
import org.jruby.ir.instructions.GVarAliasInstr;
import org.jruby.ir.instructions.GetClassVarContainerModuleInstr;
import org.jruby.ir.instructions.GetClassVariableInstr;
import org.jruby.ir.instructions.GetFieldInstr;
import org.jruby.ir.instructions.GetGlobalVariableInstr;
import org.jruby.ir.instructions.InheritanceSearchConstInstr;
import org.jruby.ir.instructions.InstanceSuperInstr;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.JumpIndirectInstr;
import org.jruby.ir.instructions.JumpInstr;
import org.jruby.ir.instructions.LabelInstr;
import org.jruby.ir.instructions.LexicalSearchConstInstr;
import org.jruby.ir.instructions.LineNumberInstr;
import org.jruby.ir.instructions.Match2Instr;
import org.jruby.ir.instructions.Match3Instr;
import org.jruby.ir.instructions.MatchInstr;
import org.jruby.ir.instructions.NonlocalReturnInstr;
import org.jruby.ir.instructions.NotInstr;
import org.jruby.ir.instructions.ProcessModuleBodyInstr;
import org.jruby.ir.instructions.PutClassVariableInstr;
import org.jruby.ir.instructions.PutConstInstr;
import org.jruby.ir.instructions.PutFieldInstr;
import org.jruby.ir.instructions.PutGlobalVarInstr;
import org.jruby.ir.instructions.ReceiveClosureInstr;
import org.jruby.ir.instructions.ReceiveExceptionInstr;
import org.jruby.ir.instructions.ReceivePreReqdArgInstr;
import org.jruby.ir.instructions.ReceiveSelfInstr;
import org.jruby.ir.instructions.RecordEndBlockInstr;
import org.jruby.ir.instructions.ReqdArgMultipleAsgnInstr;
import org.jruby.ir.instructions.RescueEQQInstr;
import org.jruby.ir.instructions.RestArgMultipleAsgnInstr;
import org.jruby.ir.instructions.ResultInstr;
import org.jruby.ir.instructions.ReturnInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.instructions.SearchConstInstr;
import org.jruby.ir.instructions.SetReturnAddressInstr;
import org.jruby.ir.instructions.ThreadPollInstr;
import org.jruby.ir.instructions.ThrowExceptionInstr;
import org.jruby.ir.instructions.ToAryInstr;
import org.jruby.ir.instructions.UndefMethodInstr;
import org.jruby.ir.instructions.UnresolvedSuperInstr;
import org.jruby.ir.instructions.YieldInstr;
import org.jruby.ir.instructions.ZSuperInstr;
import org.jruby.ir.instructions.defined.BackrefIsMatchDataInstr;
import org.jruby.ir.instructions.defined.ClassVarIsDefinedInstr;
import org.jruby.ir.instructions.defined.GetDefinedConstantOrMethodInstr;
import org.jruby.ir.instructions.defined.GetErrorInfoInstr;
import org.jruby.ir.instructions.defined.GlobalIsDefinedInstr;
import org.jruby.ir.instructions.defined.HasInstanceVarInstr;
import org.jruby.ir.instructions.defined.IsMethodBoundInstr;
import org.jruby.ir.instructions.defined.MethodDefinedInstr;
import org.jruby.ir.instructions.defined.MethodIsPublicInstr;
import org.jruby.ir.instructions.defined.RestoreErrorInfoInstr;
import org.jruby.ir.instructions.defined.SuperMethodBoundInstr;
import org.jruby.ir.instructions.ruby18.ReceiveOptArgInstr18;
import org.jruby.ir.instructions.ruby18.ReceiveRestArgInstr18;
import org.jruby.ir.operands.Array;
import org.jruby.ir.operands.AsString;
import org.jruby.ir.operands.Backref;
import org.jruby.ir.operands.BacktickString;
import org.jruby.ir.operands.Bignum;
import org.jruby.ir.operands.CompoundArray;
import org.jruby.ir.operands.CompoundString;
import org.jruby.ir.operands.CurrentScope;
import org.jruby.ir.operands.DynamicSymbol;
import org.jruby.ir.operands.Fixnum;
import org.jruby.ir.operands.Float;
import org.jruby.ir.operands.Hash;
import org.jruby.ir.operands.IRException;
import org.jruby.ir.operands.KeyValuePair;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.MethAddr;
import org.jruby.ir.operands.Nil;
import org.jruby.ir.operands.NthRef;
import org.jruby.ir.operands.ObjectClass;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Range;
import org.jruby.ir.operands.Regexp;
import org.jruby.ir.operands.SValue;
import org.jruby.ir.operands.ScopeModule;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.StringLiteral;
import org.jruby.ir.operands.Symbol;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.operands.UnexecutableNil;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.operands.WrappedIRClosure;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.CallType;
import org.jruby.util.ByteList;

public class IRBuilder {
    protected static final Operand[] NO_ARGS = new Operand[0];
    protected static final UnexecutableNil U_NIL = UnexecutableNil.U_NIL;
    private static String rubyVersion = "1.8";
    private Stack<EnsureBlockInfo> _ensureBlockStack = new Stack();
    private Stack<RescueBlockInfo> _rescueBlockStack = new Stack();
    private int _lastProcessedLineNum = -1;
    private Stack<IRLoop> loopStack = new Stack();
    protected IRManager manager;

    public static void setRubyVersion(String rubyVersion) {
        IRBuilder.rubyVersion = rubyVersion;
    }

    public boolean is1_9() {
        return false;
    }

    public IRLoop getCurrentLoop() {
        return this.loopStack.isEmpty() ? null : this.loopStack.peek();
    }

    public IRBuilder(IRManager manager) {
        this.manager = manager;
    }

    public static Node buildAST(boolean isCommandLineScript, String arg2) {
        Ruby ruby2 = Ruby.getGlobalRuntime();
        ruby2.getInstanceConfig().setCompileMode(RubyInstanceConfig.CompileMode.OFFIR);
        if (isCommandLineScript) {
            return ruby2.parse(ByteList.create((CharSequence)arg2), "-e", null, 0, false);
        }
        FileInputStream fis = null;
        try {
            File file2 = new File(arg2);
            fis = new FileInputStream(file2);
            long size2 = file2.length();
            byte[] bytes2 = new byte[(int)size2];
            fis.read(bytes2);
            System.out.println("-- processing " + arg2 + " --");
            Node node = ruby2.parse(new ByteList(bytes2), arg2, null, 0, false);
            return node;
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception e) {}
        }
    }

    public static IRBuilder createIRBuilder(IRManager manager, boolean is19) {
        return is19 ? new IRBuilder19(manager) : new IRBuilder(manager);
    }

    public Node skipOverNewlines(IRScope s2, Node n) {
        int currLineNum;
        if (n.getNodeType() == NodeType.NEWLINENODE && (currLineNum = n.getPosition().getStartLine()) != this._lastProcessedLineNum) {
            s2.addInstr(new LineNumberInstr(s2, currLineNum));
            this._lastProcessedLineNum = currLineNum;
        }
        while (n.getNodeType() == NodeType.NEWLINENODE) {
            n = ((NewlineNode)n).getNextNode();
        }
        return n;
    }

    public Operand build(Node node, IRScope s2) {
        if (node == null) {
            return null;
        }
        if (s2 == null) {
            System.out.println("Got a null scope!");
            throw new NotCompilableException("Unknown node encountered in builder: " + node);
        }
        switch (node.getNodeType()) {
            case ALIASNODE: {
                return this.buildAlias((AliasNode)node, s2);
            }
            case ANDNODE: {
                return this.buildAnd((AndNode)node, s2);
            }
            case ARGSCATNODE: {
                return this.buildArgsCat((ArgsCatNode)node, s2);
            }
            case ARGSPUSHNODE: {
                return this.buildArgsPush((ArgsPushNode)node, s2);
            }
            case ARRAYNODE: {
                return this.buildArray(node, s2);
            }
            case ATTRASSIGNNODE: {
                return this.buildAttrAssign((AttrAssignNode)node, s2);
            }
            case BACKREFNODE: {
                return this.buildBackref((BackRefNode)node, s2);
            }
            case BEGINNODE: {
                return this.buildBegin((BeginNode)node, s2);
            }
            case BIGNUMNODE: {
                return this.buildBignum((BignumNode)node, s2);
            }
            case BLOCKNODE: {
                return this.buildBlock((BlockNode)node, s2);
            }
            case BREAKNODE: {
                return this.buildBreak((BreakNode)node, s2);
            }
            case CALLNODE: {
                return this.buildCall((CallNode)node, s2);
            }
            case CASENODE: {
                return this.buildCase((CaseNode)node, s2);
            }
            case CLASSNODE: {
                return this.buildClass((ClassNode)node, s2);
            }
            case CLASSVARNODE: {
                return this.buildClassVar((ClassVarNode)node, s2);
            }
            case CLASSVARASGNNODE: {
                return this.buildClassVarAsgn((ClassVarAsgnNode)node, s2);
            }
            case CLASSVARDECLNODE: {
                return this.buildClassVarDecl((ClassVarDeclNode)node, s2);
            }
            case COLON2NODE: {
                return this.buildColon2((Colon2Node)node, s2);
            }
            case COLON3NODE: {
                return this.buildColon3((Colon3Node)node, s2);
            }
            case CONSTDECLNODE: {
                return this.buildConstDecl((ConstDeclNode)node, s2);
            }
            case CONSTNODE: {
                return this.searchConst(s2, s2, ((ConstNode)node).getName());
            }
            case DASGNNODE: {
                return this.buildDAsgn((DAsgnNode)node, s2);
            }
            case DEFINEDNODE: {
                return this.buildGetDefinitionBase(((DefinedNode)node).getExpressionNode(), s2);
            }
            case DEFNNODE: {
                return this.buildDefn((MethodDefNode)node, s2);
            }
            case DEFSNODE: {
                return this.buildDefs((DefsNode)node, s2);
            }
            case DOTNODE: {
                return this.buildDot((DotNode)node, s2);
            }
            case DREGEXPNODE: {
                return this.buildDRegexp((DRegexpNode)node, s2);
            }
            case DSTRNODE: {
                return this.buildDStr((DStrNode)node, s2);
            }
            case DSYMBOLNODE: {
                return this.buildDSymbol((DSymbolNode)node, s2);
            }
            case DVARNODE: {
                return this.buildDVar((DVarNode)node, s2);
            }
            case DXSTRNODE: {
                return this.buildDXStr((DXStrNode)node, s2);
            }
            case ENSURENODE: {
                return this.buildEnsureNode((EnsureNode)node, s2);
            }
            case EVSTRNODE: {
                return this.buildEvStr((EvStrNode)node, s2);
            }
            case FALSENODE: {
                return this.buildFalse(node, s2);
            }
            case FCALLNODE: {
                return this.buildFCall((FCallNode)node, s2);
            }
            case FIXNUMNODE: {
                return this.buildFixnum((FixnumNode)node, s2);
            }
            case FLIPNODE: {
                return this.buildFlip((FlipNode)node, s2);
            }
            case FLOATNODE: {
                return this.buildFloat((FloatNode)node, s2);
            }
            case FORNODE: {
                return this.buildFor((ForNode)node, s2);
            }
            case GLOBALASGNNODE: {
                return this.buildGlobalAsgn((GlobalAsgnNode)node, s2);
            }
            case GLOBALVARNODE: {
                return this.buildGlobalVar((GlobalVarNode)node, s2);
            }
            case HASHNODE: {
                return this.buildHash((HashNode)node, s2);
            }
            case IFNODE: {
                return this.buildIf((IfNode)node, s2);
            }
            case INSTASGNNODE: {
                return this.buildInstAsgn((InstAsgnNode)node, s2);
            }
            case INSTVARNODE: {
                return this.buildInstVar((InstVarNode)node, s2);
            }
            case ITERNODE: {
                return this.buildIter((IterNode)node, s2);
            }
            case LITERALNODE: {
                return this.buildLiteral((LiteralNode)node, s2);
            }
            case LOCALASGNNODE: {
                return this.buildLocalAsgn((LocalAsgnNode)node, s2);
            }
            case LOCALVARNODE: {
                return this.buildLocalVar((LocalVarNode)node, s2);
            }
            case MATCH2NODE: {
                return this.buildMatch2((Match2Node)node, s2);
            }
            case MATCH3NODE: {
                return this.buildMatch3((Match3Node)node, s2);
            }
            case MATCHNODE: {
                return this.buildMatch((MatchNode)node, s2);
            }
            case MODULENODE: {
                return this.buildModule((ModuleNode)node, s2);
            }
            case MULTIPLEASGNNODE: {
                return this.buildMultipleAsgn((MultipleAsgnNode)node, s2);
            }
            case NEWLINENODE: {
                return this.buildNewline((NewlineNode)node, s2);
            }
            case NEXTNODE: {
                return this.buildNext((NextNode)node, s2);
            }
            case NTHREFNODE: {
                return this.buildNthRef((NthRefNode)node, s2);
            }
            case NILNODE: {
                return this.buildNil(node, s2);
            }
            case NOTNODE: {
                return this.buildNot((NotNode)node, s2);
            }
            case OPASGNANDNODE: {
                return this.buildOpAsgnAnd((OpAsgnAndNode)node, s2);
            }
            case OPASGNNODE: {
                return this.buildOpAsgn((OpAsgnNode)node, s2);
            }
            case OPASGNORNODE: {
                return this.buildOpAsgnOr((OpAsgnOrNode)node, s2);
            }
            case OPELEMENTASGNNODE: {
                return this.buildOpElementAsgn((OpElementAsgnNode)node, s2);
            }
            case ORNODE: {
                return this.buildOr((OrNode)node, s2);
            }
            case PREEXENODE: {
                return this.buildPreExe((PreExeNode)node, s2);
            }
            case POSTEXENODE: {
                return this.buildPostExe((PostExeNode)node, s2);
            }
            case REDONODE: {
                return this.buildRedo(node, s2);
            }
            case REGEXPNODE: {
                return this.buildRegexp((RegexpNode)node, s2);
            }
            case RESCUEBODYNODE: {
                throw new NotCompilableException("rescue body is handled by rescue compilation at: " + node.getPosition());
            }
            case RESCUENODE: {
                return this.buildRescue((RescueNode)node, s2);
            }
            case RETRYNODE: {
                return this.buildRetry(node, s2);
            }
            case RETURNNODE: {
                return this.buildReturn((ReturnNode)node, s2);
            }
            case ROOTNODE: {
                throw new NotCompilableException("Use buildRoot(); Root node at: " + node.getPosition());
            }
            case SCLASSNODE: {
                return this.buildSClass((SClassNode)node, s2);
            }
            case SELFNODE: {
                return this.buildSelf((SelfNode)node, s2);
            }
            case SPLATNODE: {
                return this.buildSplat((SplatNode)node, s2);
            }
            case STRNODE: {
                return this.buildStr((StrNode)node, s2);
            }
            case SUPERNODE: {
                return this.buildSuper((SuperNode)node, s2);
            }
            case SVALUENODE: {
                return this.buildSValue((SValueNode)node, s2);
            }
            case SYMBOLNODE: {
                return this.buildSymbol((SymbolNode)node, s2);
            }
            case TOARYNODE: {
                return this.buildToAry((ToAryNode)node, s2);
            }
            case TRUENODE: {
                return this.buildTrue(node, s2);
            }
            case UNDEFNODE: {
                return this.buildUndef(node, s2);
            }
            case UNTILNODE: {
                return this.buildUntil((UntilNode)node, s2);
            }
            case VALIASNODE: {
                return this.buildVAlias(node, s2);
            }
            case VCALLNODE: {
                return this.buildVCall((VCallNode)node, s2);
            }
            case WHILENODE: {
                return this.buildWhile((WhileNode)node, s2);
            }
            case WHENNODE: {
                assert (false) : "When nodes are handled by case node compilation.";
                return null;
            }
            case XSTRNODE: {
                return this.buildXStr((XStrNode)node, s2);
            }
            case YIELDNODE: {
                return this.buildYield((YieldNode)node, s2);
            }
            case ZARRAYNODE: {
                return this.buildZArray(node, s2);
            }
            case ZSUPERNODE: {
                return this.buildZSuper((ZSuperNode)node, s2);
            }
        }
        return this.buildVersionSpecificNodes(node, s2);
    }

    protected Operand buildVersionSpecificNodes(Node node, IRScope s2) {
        throw new NotCompilableException("Unknown node encountered in builder: " + node.getClass());
    }

    protected Variable getSelf(IRScope s2) {
        return s2.getSelf();
    }

    protected Variable copyAndReturnValue(IRScope s2, Operand val) {
        TemporaryVariable v = s2.getNewTemporaryVariable();
        s2.addInstr(new CopyInstr(v, val));
        return v;
    }

    protected Variable getValueInTemporaryVariable(IRScope s2, Operand val) {
        if (val != null && val instanceof TemporaryVariable) {
            return (Variable)val;
        }
        return this.copyAndReturnValue(s2, val);
    }

    protected Operand buildCallArgs(List<Operand> argsList, Node args2, IRScope s2) {
        args2 = this.skipOverNewlines(s2, args2);
        switch (args2.getNodeType()) {
            case ARGSCATNODE: {
                CompoundArray a = (CompoundArray)this.build(args2, s2);
                argsList.add(new Splat(a));
                return a.getAppendedArg();
            }
            case ARGSPUSHNODE: {
                ArgsPushNode ap = (ArgsPushNode)args2;
                Operand v1 = this.build(ap.getFirstNode(), s2);
                Operand v2 = this.build(ap.getSecondNode(), s2);
                argsList.add(new Splat(new CompoundArray(v1, v2, true)));
                return v2;
            }
            case ARRAYNODE: {
                ArrayNode arrayNode = (ArrayNode)args2;
                if (arrayNode.isLightweight()) {
                    List<Node> children = arrayNode.childNodes();
                    if (children.size() == 1) {
                        Node child = this.skipOverNewlines(s2, children.get(0));
                        if (child instanceof SplatNode) {
                            SplatNode splat = (SplatNode)child;
                            Variable splatArray = this.getValueInTemporaryVariable(s2, this.build(splat.getValue(), s2));
                            argsList.add(new CompoundArray(new Array(), splatArray));
                            return new Splat(splatArray);
                        }
                        Operand childOperand = this.build(child, s2);
                        argsList.add(childOperand);
                        return childOperand;
                    }
                    for (Node n : children) {
                        argsList.add(this.build(n, s2));
                    }
                    break;
                }
                argsList.add(this.build(arrayNode, s2));
                break;
            }
            default: {
                argsList.add(this.build(args2, s2));
            }
        }
        return argsList.isEmpty() ? this.manager.getNil() : argsList.get(argsList.size() - 1);
    }

    public List<Operand> setupCallArgs(Node args2, IRScope s2) {
        ArrayList<Operand> argsList = new ArrayList<Operand>();
        if (args2 != null) {
            this.buildCallArgs(argsList, args2, s2);
        }
        return argsList;
    }

    public void buildVersionSpecificAssignment(Node node, IRScope s2, Variable v) {
        switch (node.getNodeType()) {
            case MULTIPLEASGNNODE: {
                Variable valuesArg;
                MultipleAsgnNode childNode = (MultipleAsgnNode)node;
                if (childNode.getHeadNode() != null && childNode.getHeadNode().childNodes().size() > 0) {
                    TemporaryVariable result2 = s2.getNewTemporaryVariable();
                    s2.addInstr(new ToAryInstr(result2, v, this.manager.getTrue()));
                    valuesArg = result2;
                } else {
                    s2.addInstr(new EnsureRubyArrayInstr(v, v));
                    valuesArg = v;
                }
                this.buildMultipleAsgnAssignment(childNode, s2, null, valuesArg);
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    public void buildAssignment(Node node, IRScope s2, Variable rhsVal) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                this.buildAttrAssignAssignment(node, s2, rhsVal);
                break;
            }
            case CLASSVARASGNNODE: {
                s2.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(s2), ((ClassVarAsgnNode)node).getName(), rhsVal));
                break;
            }
            case CLASSVARDECLNODE: {
                s2.addInstr(new PutClassVariableInstr(this.classVarDeclarationContainer(s2), ((ClassVarDeclNode)node).getName(), rhsVal));
                break;
            }
            case CONSTDECLNODE: {
                this.buildConstDeclAssignment((ConstDeclNode)node, s2, rhsVal);
                break;
            }
            case DASGNNODE: {
                DAsgnNode variable = (DAsgnNode)node;
                int depth = variable.getDepth();
                s2.addInstr(new CopyInstr(s2.getLocalVariable(variable.getName(), depth), rhsVal));
                break;
            }
            case GLOBALASGNNODE: {
                s2.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), rhsVal));
                break;
            }
            case INSTASGNNODE: {
                s2.addInstr(new PutFieldInstr(this.getSelf(s2), ((InstAsgnNode)node).getName(), rhsVal));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                int depth = localVariable.getDepth();
                s2.addInstr(new CopyInstr(s2.getLocalVariable(localVariable.getName(), depth), rhsVal));
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                this.buildVersionSpecificAssignment(node, s2, rhsVal);
            }
        }
    }

    protected LocalVariable getBlockArgVariable(IRScope cl, String name2, int depth) {
        return cl.getLocalVariable(name2, depth);
    }

    protected void receiveBlockArg(IRScope s2, Variable v, Operand argsArray, int argIndex, boolean isClosureArg, boolean isSplat) {
        if (argsArray != null) {
            if (isSplat) {
                s2.addInstr(new RestArgMultipleAsgnInstr(v, argsArray, argIndex));
            } else {
                s2.addInstr(new ReqdArgMultipleAsgnInstr(v, argsArray, argIndex));
            }
        } else {
            s2.addInstr(isClosureArg ? new ReceiveClosureInstr(v) : (isSplat ? new ReceiveRestArgInstr18(v, argIndex) : new ReceivePreReqdArgInstr(v, argIndex)));
        }
    }

    public void buildVersionSpecificBlockArgsAssignment(Node node, IRScope s2, Operand argsArray, int argIndex, boolean isMasgnRoot, boolean isClosureArg, boolean isSplat) {
        switch (node.getNodeType()) {
            case MULTIPLEASGNNODE: {
                Object oldArgs = null;
                MultipleAsgnNode childNode = (MultipleAsgnNode)node;
                if (!isMasgnRoot) {
                    boolean runToAry;
                    LocalVariable v = s2.getLocalVariable("%_masgn_arg_" + argIndex, 0);
                    this.receiveBlockArg(s2, v, argsArray, argIndex, isClosureArg, isSplat);
                    boolean bl = runToAry = childNode.getHeadNode() != null && childNode.getHeadNode().childNodes().size() > 0;
                    if (runToAry) {
                        s2.addInstr(new ToAryInstr(v, v, this.manager.getFalse()));
                    } else {
                        s2.addInstr(new EnsureRubyArrayInstr(v, v));
                    }
                    argsArray = v;
                }
                this.buildMultipleAsgnAssignment(childNode, s2, argsArray, null);
                break;
            }
            default: {
                throw new NotCompilableException("Can't build assignment node: " + node);
            }
        }
    }

    public void buildBlockArgsAssignment(Node node, IRScope s2, Operand argsArray, int argIndex, boolean isMasgnRoot, boolean isClosureArg, boolean isSplat) {
        switch (node.getNodeType()) {
            case ATTRASSIGNNODE: {
                TemporaryVariable v = s2.getNewTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isClosureArg, isSplat);
                this.buildAttrAssignAssignment(node, s2, v);
                break;
            }
            case DASGNNODE: {
                DAsgnNode dynamicAsgn = (DAsgnNode)node;
                LocalVariable v = this.getBlockArgVariable((IRClosure)s2, dynamicAsgn.getName(), dynamicAsgn.getDepth());
                this.receiveBlockArg(s2, v, argsArray, argIndex, isClosureArg, isSplat);
                break;
            }
            case CLASSVARASGNNODE: {
                TemporaryVariable v = s2.getNewTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isClosureArg, isSplat);
                s2.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(s2), ((ClassVarAsgnNode)node).getName(), v));
                break;
            }
            case CLASSVARDECLNODE: {
                TemporaryVariable v = s2.getNewTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isClosureArg, isSplat);
                s2.addInstr(new PutClassVariableInstr(this.classVarDeclarationContainer(s2), ((ClassVarDeclNode)node).getName(), v));
                break;
            }
            case CONSTDECLNODE: {
                TemporaryVariable v = s2.getNewTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isClosureArg, isSplat);
                this.buildConstDeclAssignment((ConstDeclNode)node, s2, v);
                break;
            }
            case GLOBALASGNNODE: {
                TemporaryVariable v = s2.getNewTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isClosureArg, isSplat);
                s2.addInstr(new PutGlobalVarInstr(((GlobalAsgnNode)node).getName(), v));
                break;
            }
            case INSTASGNNODE: {
                TemporaryVariable v = s2.getNewTemporaryVariable();
                this.receiveBlockArg(s2, v, argsArray, argIndex, isClosureArg, isSplat);
                s2.addInstr(new PutFieldInstr(this.getSelf(s2), ((InstAsgnNode)node).getName(), v));
                break;
            }
            case LOCALASGNNODE: {
                LocalAsgnNode localVariable = (LocalAsgnNode)node;
                int depth = localVariable.getDepth();
                LocalVariable v = this.getBlockArgVariable((IRClosure)s2, localVariable.getName(), depth);
                this.receiveBlockArg(s2, v, argsArray, argIndex, isClosureArg, isSplat);
                break;
            }
            case ZEROARGNODE: {
                throw new NotCompilableException("Shouldn't get here; zeroarg does not do assignment: " + node);
            }
            default: {
                this.buildVersionSpecificBlockArgsAssignment(node, s2, argsArray, argIndex, isMasgnRoot, isClosureArg, isSplat);
            }
        }
    }

    public Operand buildAlias(AliasNode alias2, IRScope s2) {
        Operand newName = this.build(alias2.getNewName(), s2);
        Operand oldName = this.build(alias2.getOldName(), s2);
        s2.addInstr(new AliasInstr(this.getSelf(s2), newName, oldName));
        return this.manager.getNil();
    }

    public Operand buildAnd(AndNode andNode, IRScope s2) {
        if (andNode.getFirstNode().getNodeType().alwaysTrue()) {
            this.build(andNode.getFirstNode(), s2);
            return this.build(andNode.getSecondNode(), s2);
        }
        if (andNode.getFirstNode().getNodeType().alwaysFalse()) {
            return this.build(andNode.getFirstNode(), s2);
        }
        Label l = s2.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode(), s2);
        Variable ret = this.getValueInTemporaryVariable(s2, v1);
        s2.addInstr(BEQInstr.create(v1, this.manager.getFalse(), l));
        Operand v2 = this.build(andNode.getSecondNode(), s2);
        s2.addInstr(new CopyInstr(ret, v2));
        s2.addInstr(new LabelInstr(l));
        return ret;
    }

    public Operand buildArray(Node node, IRScope s2) {
        ArrayList<Operand> elts = new ArrayList<Operand>();
        for (Node e : node.childNodes()) {
            elts.add(this.build(e, s2));
        }
        return this.copyAndReturnValue(s2, new Array(elts));
    }

    public Operand buildArgsCat(ArgsCatNode argsCatNode, IRScope s2) {
        Operand v1 = this.build(argsCatNode.getFirstNode(), s2);
        Operand v2 = this.build(argsCatNode.getSecondNode(), s2);
        return new CompoundArray(v1, v2);
    }

    public Operand buildArgsPush(ArgsPushNode node, IRScope s2) {
        throw new NotCompilableException("ArgsPush should never be encountered bare in 1.8" + node);
    }

    private Operand buildAttrAssign(AttrAssignNode attrAssignNode, IRScope s2) {
        Operand obj = this.build(attrAssignNode.getReceiverNode(), s2);
        ArrayList<Operand> args2 = new ArrayList<Operand>();
        Node argsNode = attrAssignNode.getArgsNode();
        Nil lastArg = argsNode == null ? this.manager.getNil() : this.buildCallArgs(args2, argsNode, s2);
        s2.addInstr(new AttrAssignInstr(obj, new MethAddr(attrAssignNode.getName()), args2.toArray(new Operand[args2.size()])));
        return lastArg;
    }

    public Operand buildAttrAssignAssignment(Node node, IRScope s2, Operand value2) {
        AttrAssignNode attrAssignNode = (AttrAssignNode)node;
        Operand obj = this.build(attrAssignNode.getReceiverNode(), s2);
        List<Operand> args2 = this.setupCallArgs(attrAssignNode.getArgsNode(), s2);
        args2.add(value2);
        s2.addInstr(new AttrAssignInstr(obj, new MethAddr(attrAssignNode.getName()), args2.toArray(new Operand[args2.size()])));
        return value2;
    }

    public Operand buildBackref(BackRefNode node, IRScope s2) {
        return this.copyAndReturnValue(s2, new Backref(node.getType()));
    }

    public Operand buildBegin(BeginNode beginNode, IRScope s2) {
        return this.build(beginNode.getBodyNode(), s2);
    }

    public Operand buildBignum(BignumNode node, IRScope s2) {
        return new Bignum(node.getValue());
    }

    public Operand buildBlock(BlockNode node, IRScope s2) {
        Operand retVal = null;
        for (Node child : node.childNodes()) {
            retVal = this.build(child, s2);
        }
        return retVal;
    }

    public Operand buildBreak(BreakNode breakNode, IRScope s2) {
        IRLoop currLoop = this.getCurrentLoop();
        Operand rv = this.build(breakNode.getValueNode(), s2);
        if (!this._ensureBlockStack.empty()) {
            EnsureBlockInfo.emitJumpChain(s2, this._ensureBlockStack, currLoop);
        } else if (!this._rescueBlockStack.empty()) {
            this._rescueBlockStack.peek().restoreException(s2, currLoop);
        }
        if (currLoop != null) {
            s2.addInstr(new CopyInstr(currLoop.loopResult, rv));
            s2.addInstr(new JumpInstr(currLoop.loopEndLabel));
        } else if (s2 instanceof IRClosure) {
            IRScope returnScope = s2.getLexicalParent();
            if (this.is1_9()) {
                if (s2 instanceof IREvalScript) {
                    s2.addInstr(new ThrowExceptionInstr(IRException.BREAK_LocalJumpError));
                } else {
                    s2.addInstr(new BreakInstr(rv, returnScope));
                }
            } else {
                if (s2 instanceof IREvalScript) {
                    returnScope = returnScope.getLexicalParent();
                }
                s2.addInstr(new BreakInstr(rv, returnScope));
            }
        } else {
            s2.addInstr(new ThrowExceptionInstr(IRException.BREAK_LocalJumpError));
        }
        return UnexecutableNil.U_NIL;
    }

    private void handleNonlocalReturnInMethod(IRScope s2) {
        Label rBeginLabel = s2.getNewLabel();
        Label rEndLabel = s2.getNewLabel();
        Label gebLabel = s2.getNewLabel();
        s2.addInstrAtBeginning(new ExceptionRegionStartMarkerInstr(rBeginLabel, rEndLabel, gebLabel, gebLabel));
        s2.addInstr(new ExceptionRegionEndMarkerInstr());
        s2.addInstr(new LabelInstr(gebLabel));
        TemporaryVariable exc = s2.getNewTemporaryVariable();
        s2.addInstr(new ReceiveExceptionInstr(exc, false));
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new RuntimeHelperCall(ret, "handleNonlocalReturn", new Operand[]{exc}));
        s2.addInstr(new ReturnInstr(ret));
        s2.addInstr(new LabelInstr(rEndLabel));
    }

    private void receiveBreakException(IRScope s2, Operand block, CallInstr callInstr) {
        if (block != null && block instanceof WrappedIRClosure) {
            IRClosure closure = ((WrappedIRClosure)block).getClosure();
            if (!closure.hasBreakInstrs) {
                s2.addInstr(callInstr);
                return;
            }
        } else {
            s2.addInstr(callInstr);
            return;
        }
        Label rBeginLabel = s2.getNewLabel();
        Label rEndLabel = s2.getNewLabel();
        Label rescueLabel = s2.getNewLabel();
        s2.addInstr(new ExceptionRegionStartMarkerInstr(rBeginLabel, rEndLabel, null, rescueLabel));
        s2.addInstr(callInstr);
        s2.addInstr(new JumpInstr(rEndLabel));
        s2.addInstr(new ExceptionRegionEndMarkerInstr());
        s2.addInstr(new LabelInstr(rescueLabel));
        TemporaryVariable exc = s2.getNewTemporaryVariable();
        s2.addInstr(new ReceiveExceptionInstr(exc));
        s2.addInstr(new RuntimeHelperCall(callInstr.getResult(), "handlePropagatedBreak", new Operand[]{exc}));
        s2.addInstr(new LabelInstr(rEndLabel));
    }

    public Operand buildCall(CallNode callNode, IRScope s2) {
        Node callArgsNode = callNode.getArgsNode();
        Node receiverNode = callNode.getReceiverNode();
        Operand receiver2 = this.build(receiverNode, s2);
        List<Operand> args2 = this.setupCallArgs(callArgsNode, s2);
        Operand block = this.setupCallClosure(callNode.getIterNode(), s2);
        TemporaryVariable callResult = s2.getNewTemporaryVariable();
        CallInstr callInstr = CallInstr.create(callResult, new MethAddr(callNode.getName()), receiver2, args2.toArray(new Operand[args2.size()]), block);
        this.receiveBreakException(s2, block, callInstr);
        return callResult;
    }

    public Operand buildCase(CaseNode caseNode, IRScope s2) {
        Operand value2 = this.build(caseNode.getCaseNode(), s2);
        if (value2 == null) {
            value2 = UndefinedValue.UNDEFINED;
        }
        Label endLabel = s2.getNewLabel();
        boolean hasElse = caseNode.getElseNode() != null;
        Label elseLabel = s2.getNewLabel();
        TemporaryVariable result2 = s2.getNewTemporaryVariable();
        ArrayList<Label> labels = new ArrayList<Label>();
        HashMap<Label, Node> bodies = new HashMap<Label, Node>();
        for (Node aCase : caseNode.getCases().childNodes()) {
            Operand v2;
            Operand v1;
            WhenNode whenNode = (WhenNode)aCase;
            Label bodyLabel = s2.getNewLabel();
            TemporaryVariable eqqResult = s2.getNewTemporaryVariable();
            labels.add(bodyLabel);
            if (whenNode.getExpressionNodes() instanceof ListNode) {
                if (value2 == UndefinedValue.UNDEFINED) {
                    v1 = this.build(whenNode.getExpressionNodes(), s2);
                    v2 = this.manager.getTrue();
                } else {
                    v1 = value2;
                    v2 = this.build(whenNode.getExpressionNodes(), s2);
                }
            } else {
                s2.addInstr(new EQQInstr(eqqResult, this.build(whenNode.getExpressionNodes(), s2), value2));
                v1 = eqqResult;
                v2 = this.manager.getTrue();
            }
            s2.addInstr(BEQInstr.create(v1, v2, bodyLabel));
            bodies.put(bodyLabel, whenNode.getBodyNode());
        }
        s2.addInstr(new JumpInstr(elseLabel));
        if (hasElse) {
            labels.add(elseLabel);
            bodies.put(elseLabel, caseNode.getElseNode());
        }
        for (Label whenLabel : labels) {
            s2.addInstr(new LabelInstr(whenLabel));
            Operand bodyValue = this.build((Node)bodies.get(whenLabel), s2);
            if (bodyValue == null) continue;
            Label tgt = endLabel;
            s2.addInstr(new CopyInstr(result2, bodyValue));
            s2.addInstr(new JumpInstr(tgt));
        }
        if (!hasElse) {
            s2.addInstr(new LabelInstr(elseLabel));
            s2.addInstr(new CopyInstr(result2, this.manager.getNil()));
            s2.addInstr(new JumpInstr(endLabel));
        }
        s2.addInstr(new LabelInstr(endLabel));
        return result2;
    }

    public Operand buildClass(ClassNode classNode, IRScope s2) {
        Node superNode = classNode.getSuperNode();
        Colon3Node cpath = classNode.getCPath();
        Operand superClass = superNode == null ? null : this.build(superNode, s2);
        String className = cpath.getName();
        Operand container = this.getContainerFromCPath(cpath, s2);
        IRClassBody c = new IRClassBody(this.manager, s2, className, classNode.getPosition().getLine(), classNode.getScope());
        TemporaryVariable classBody = s2.getNewTemporaryVariable();
        s2.addInstr(new DefineClassInstr(classBody, c, container, superClass));
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new ProcessModuleBodyInstr(ret, classBody));
        c.addInstr(new ReceiveSelfInstr(c.getSelf()));
        c.addInstr(new CopyInstr(c.getCurrentScopeVariable(), new CurrentScope(c)));
        c.addInstr(new CopyInstr(c.getCurrentModuleVariable(), new ScopeModule(c)));
        Operand rv = IRBuilder.createIRBuilder(this.manager, this.is1_9()).build(classNode.getBodyNode(), c);
        if (rv != null) {
            c.addInstr(new ReturnInstr(rv));
        }
        return ret;
    }

    public Operand buildSClass(SClassNode sclassNode, IRScope s2) {
        Operand receiver2 = this.build(sclassNode.getReceiverNode(), s2);
        IRMetaClassBody mc = new IRMetaClassBody(this.manager, s2, this.manager.getMetaClassName(), sclassNode.getPosition().getLine(), sclassNode.getScope());
        TemporaryVariable classBody = s2.getNewTemporaryVariable();
        s2.addInstr(new DefineMetaClassInstr(classBody, receiver2, mc));
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new ProcessModuleBodyInstr(ret, classBody));
        mc.addInstr(new ReceiveSelfInstr(mc.getSelf()));
        mc.addInstr(new ReceiveClosureInstr(((IRModuleBody)mc).getImplicitBlockArg()));
        mc.addInstr(new CopyInstr(mc.getCurrentScopeVariable(), new CurrentScope(mc)));
        mc.addInstr(new CopyInstr(mc.getCurrentModuleVariable(), new ScopeModule(mc)));
        Operand rv = IRBuilder.createIRBuilder(this.manager, this.is1_9()).build(sclassNode.getBodyNode(), mc);
        if (rv != null) {
            mc.addInstr(new ReturnInstr(rv));
        }
        return ret;
    }

    public Operand buildClassVar(ClassVarNode node, IRScope s2) {
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new GetClassVariableInstr(ret, this.classVarDefinitionContainer(s2), node.getName()));
        return ret;
    }

    public Operand buildClassVarAsgn(ClassVarAsgnNode classVarAsgnNode, IRScope s2) {
        Operand val = this.build(classVarAsgnNode.getValueNode(), s2);
        s2.addInstr(new PutClassVariableInstr(this.classVarDefinitionContainer(s2), classVarAsgnNode.getName(), val));
        return val;
    }

    public Operand buildClassVarDecl(ClassVarDeclNode classVarDeclNode, IRScope s2) {
        Operand val = this.build(classVarDeclNode.getValueNode(), s2);
        s2.addInstr(new PutClassVariableInstr(this.classVarDeclarationContainer(s2), classVarDeclNode.getName(), val));
        return val;
    }

    public Operand classVarDeclarationContainer(IRScope s2) {
        return this.classVarContainer(s2, true);
    }

    public Operand classVarDefinitionContainer(IRScope s2) {
        return this.classVarContainer(s2, false);
    }

    public Operand classVarContainer(IRScope s2, boolean declContext) {
        IRScope cvarScope;
        for (cvarScope = s2; cvarScope != null && !(cvarScope instanceof IREvalScript) && !cvarScope.isNonSingletonClassBody(); cvarScope = cvarScope.getLexicalParent()) {
        }
        if (cvarScope != null && cvarScope.isNonSingletonClassBody()) {
            return new ScopeModule(cvarScope);
        }
        TemporaryVariable tmp = s2.getNewTemporaryVariable();
        s2.addInstr(new GetClassVarContainerModuleInstr(tmp, s2.getCurrentScopeVariable(), declContext ? null : this.getSelf(s2)));
        return tmp;
    }

    public Operand buildConstDecl(ConstDeclNode node, IRScope s2) {
        Operand val = this.build(node.getValueNode(), s2);
        return this.buildConstDeclAssignment(node, s2, val);
    }

    private Operand findContainerModule(IRScope s2) {
        IRScope nearestModuleBody = s2.getNearestModuleReferencingScope();
        return nearestModuleBody == null ? s2.getCurrentModuleVariable() : new ScopeModule(nearestModuleBody);
    }

    private Operand startingSearchScope(IRScope s2) {
        IRScope nearestModuleBody = s2.getNearestModuleReferencingScope();
        return nearestModuleBody == null ? s2.getCurrentScopeVariable() : new CurrentScope(nearestModuleBody);
    }

    public Operand buildConstDeclAssignment(ConstDeclNode constDeclNode, IRScope s2, Operand val) {
        Node constNode = constDeclNode.getConstNode();
        if (constNode == null) {
            s2.addInstr(new PutConstInstr(this.findContainerModule(s2), constDeclNode.getName(), val));
        } else if (constNode.getNodeType() == NodeType.COLON2NODE) {
            Operand module = this.build(((Colon2Node)constNode).getLeftNode(), s2);
            s2.addInstr(new PutConstInstr(module, constDeclNode.getName(), val));
        } else {
            ScopeModule object = new ScopeModule(this.manager.getObject());
            s2.addInstr(new PutConstInstr(object, constDeclNode.getName(), val));
        }
        return val;
    }

    private void genInheritanceSearchInstrs(IRScope s2, Operand startingModule, Variable constVal, Label foundLabel, boolean noPrivateConstants, String name2) {
        s2.addInstr(new InheritanceSearchConstInstr(constVal, startingModule, name2, noPrivateConstants));
        s2.addInstr(BNEInstr.create(constVal, UndefinedValue.UNDEFINED, foundLabel));
        s2.addInstr(new ConstMissingInstr(constVal, startingModule, name2));
        s2.addInstr(new LabelInstr(foundLabel));
    }

    private Operand searchConstInInheritanceHierarchy(IRScope s2, Operand startingModule, String name2) {
        TemporaryVariable constVal = s2.getNewTemporaryVariable();
        this.genInheritanceSearchInstrs(s2, startingModule, constVal, s2.getNewLabel(), true, name2);
        return constVal;
    }

    private Operand searchConst(IRScope s2, IRScope startingScope, String name2) {
        boolean noPrivateConstants = s2 != startingScope;
        TemporaryVariable v = s2.getNewTemporaryVariable();
        s2.addInstr(new SearchConstInstr(v, name2, this.startingSearchScope(startingScope), noPrivateConstants));
        return v;
    }

    public Operand buildColon2(Colon2Node iVisited, IRScope s2) {
        Node leftNode = iVisited.getLeftNode();
        String name2 = iVisited.getName();
        if (leftNode == null) {
            return this.searchConst(s2, s2, name2);
        }
        if (iVisited instanceof Colon2ConstNode) {
            Operand module = this.build(leftNode, s2);
            return this.searchConstInInheritanceHierarchy(s2, module, name2);
        }
        if (iVisited instanceof Colon2MethodNode) {
            Colon2MethodNode c2mNode = (Colon2MethodNode)iVisited;
            List<Operand> args2 = this.setupCallArgs(null, s2);
            TemporaryVariable callResult = s2.getNewTemporaryVariable();
            CallInstr callInstr = CallInstr.create(callResult, new MethAddr(c2mNode.getName()), null, args2.toArray(new Operand[args2.size()]), null);
            s2.addInstr(callInstr);
            return callResult;
        }
        throw new NotCompilableException("Not compilable: " + iVisited);
    }

    public Operand buildColon3(Colon3Node node, IRScope s2) {
        return this.searchConstInInheritanceHierarchy(s2, new ObjectClass(), node.getName());
    }

    private Operand protectCodeWithRescue(IRScope m, CodeBlock protectedCode, Object[] protectedCodeArgs, CodeBlock rescueBlock, Object[] rescueBlockArgs) {
        TemporaryVariable rv = m.getNewTemporaryVariable();
        Label rBeginLabel = m.getNewLabel();
        Label rEndLabel = m.getNewLabel();
        Label rescueLabel = m.getNewLabel();
        m.addInstr(new LabelInstr(rBeginLabel));
        m.addInstr(new ExceptionRegionStartMarkerInstr(rBeginLabel, rEndLabel, null, rescueLabel));
        Operand v1 = protectedCode.run(protectedCodeArgs);
        m.addInstr(new CopyInstr(rv, v1));
        m.addInstr(new JumpInstr(rEndLabel));
        m.addInstr(new ExceptionRegionEndMarkerInstr());
        Label caughtLabel = m.getNewLabel();
        TemporaryVariable exc = m.getNewTemporaryVariable();
        TemporaryVariable excType = m.getNewTemporaryVariable();
        m.addInstr(new LabelInstr(rescueLabel));
        m.addInstr(new ReceiveExceptionInstr(exc));
        m.addInstr(new InheritanceSearchConstInstr(excType, new ObjectClass(), "Exception", false));
        this.outputExceptionCheck(m, excType, exc, caughtLabel);
        m.addInstr(new ThrowExceptionInstr(exc));
        m.addInstr(new LabelInstr(caughtLabel));
        Operand v2 = rescueBlock.run(rescueBlockArgs);
        if (v2 != null) {
            m.addInstr(new CopyInstr(rv, this.manager.getNil()));
        }
        m.addInstr(new LabelInstr(rEndLabel));
        return rv;
    }

    protected Operand buildGenericGetDefinitionIR(Node node, IRScope s2) {
        return this.buildGetDefinition(node, s2);
    }

    protected Operand buildVersionSpecificGetDefinitionIR(Node node, IRScope s2) {
        switch (node.getNodeType()) {
            case BACKREFNODE: 
            case DVARNODE: {
                return this.buildGetDefinition(node, s2);
            }
        }
        return this.buildGenericGetDefinitionIR(node, s2);
    }

    public Operand buildGetDefinitionBase(Node node, IRScope s2) {
        node = this.skipOverNewlines(s2, node);
        switch (node.getNodeType()) {
            case CLASSVARNODE: 
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case CONSTNODE: 
            case DASGNNODE: 
            case FALSENODE: 
            case FCALLNODE: 
            case GLOBALASGNNODE: 
            case GLOBALVARNODE: 
            case INSTVARNODE: 
            case LOCALASGNNODE: 
            case LOCALVARNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: 
            case SELFNODE: 
            case TRUENODE: 
            case VCALLNODE: 
            case YIELDNODE: {
                return this.buildGetDefinition(node, s2);
            }
        }
        return this.buildVersionSpecificGetDefinitionIR(node, s2);
    }

    protected Variable buildDefnCheckIfThenPaths(IRScope s2, Label undefLabel, Operand defVal) {
        Label defLabel = s2.getNewLabel();
        Variable tmpVar = this.getValueInTemporaryVariable(s2, defVal);
        s2.addInstr(new JumpInstr(defLabel));
        s2.addInstr(new LabelInstr(undefLabel));
        s2.addInstr(new CopyInstr(tmpVar, this.manager.getNil()));
        s2.addInstr(new LabelInstr(defLabel));
        return tmpVar;
    }

    protected Variable buildDefinitionCheck(IRScope s2, ResultInstr definedInstr, String definedReturnValue) {
        Label undefLabel = s2.getNewLabel();
        s2.addInstr((Instr)((Object)definedInstr));
        s2.addInstr(BEQInstr.create(definedInstr.getResult(), this.manager.getFalse(), undefLabel));
        return this.buildDefnCheckIfThenPaths(s2, undefLabel, new StringLiteral(definedReturnValue));
    }

    public Operand buildGetArgumentDefinition(Node node, IRScope s2, String type2) {
        if (node == null) {
            return new StringLiteral(type2);
        }
        Operand rv = new StringLiteral(type2);
        boolean failPathReqd = false;
        Label failLabel = s2.getNewLabel();
        if (node instanceof ArrayNode) {
            for (int i2 = 0; i2 < ((ArrayNode)node).size(); ++i2) {
                Node iterNode = ((ArrayNode)node).get(i2);
                Operand def = this.buildGetDefinition(iterNode, s2);
                if (def == this.manager.getNil()) {
                    rv = this.manager.getNil();
                    break;
                }
                if (def.hasKnownValue()) continue;
                failPathReqd = true;
                s2.addInstr(BEQInstr.create(def, this.manager.getNil(), failLabel));
            }
        } else {
            Operand def = this.buildGetDefinition(node, s2);
            if (def == this.manager.getNil()) {
                rv = this.manager.getNil();
            } else if (!def.hasKnownValue()) {
                failPathReqd = true;
                s2.addInstr(BEQInstr.create(def, this.manager.getNil(), failLabel));
            }
        }
        return failPathReqd ? this.buildDefnCheckIfThenPaths(s2, failLabel, rv) : rv;
    }

    public Operand buildGetDefinition(Node defnNode, IRScope s2) {
        final Node node = this.skipOverNewlines(s2, defnNode);
        switch (node.getNodeType()) {
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case GLOBALASGNNODE: 
            case INSTASGNNODE: 
            case LOCALASGNNODE: 
            case MULTIPLEASGNNODE: 
            case OPASGNANDNODE: 
            case OPASGNNODE: 
            case OPASGNORNODE: 
            case OPELEMENTASGNNODE: {
                return new StringLiteral("assignment");
            }
            case DVARNODE: {
                return new StringLiteral("local-variable(in-block)");
            }
            case FALSENODE: {
                return new StringLiteral("false");
            }
            case TRUENODE: {
                return new StringLiteral("true");
            }
            case LOCALVARNODE: {
                return new StringLiteral("local-variable");
            }
            case MATCH2NODE: 
            case MATCH3NODE: {
                return new StringLiteral("method");
            }
            case NILNODE: {
                return new StringLiteral("nil");
            }
            case SELFNODE: {
                return new StringLiteral("self");
            }
            case CONSTNODE: {
                Label defLabel = s2.getNewLabel();
                Label doneLabel = s2.getNewLabel();
                TemporaryVariable tmpVar = s2.getNewTemporaryVariable();
                String constName = ((ConstNode)node).getName();
                s2.addInstr(new LexicalSearchConstInstr(tmpVar, this.startingSearchScope(s2), constName));
                s2.addInstr(BNEInstr.create(tmpVar, UndefinedValue.UNDEFINED, defLabel));
                s2.addInstr(new InheritanceSearchConstInstr(tmpVar, this.findContainerModule(s2), constName, false));
                s2.addInstr(BNEInstr.create(tmpVar, UndefinedValue.UNDEFINED, defLabel));
                s2.addInstr(new CopyInstr(tmpVar, this.manager.getNil()));
                s2.addInstr(new JumpInstr(doneLabel));
                s2.addInstr(new LabelInstr(defLabel));
                s2.addInstr(new CopyInstr(tmpVar, new StringLiteral("constant")));
                s2.addInstr(new LabelInstr(doneLabel));
                return tmpVar;
            }
            case GLOBALVARNODE: {
                return this.buildDefinitionCheck(s2, new GlobalIsDefinedInstr(s2.getNewTemporaryVariable(), new StringLiteral(((GlobalVarNode)node).getName())), "global-variable");
            }
            case INSTVARNODE: {
                return this.buildDefinitionCheck(s2, new HasInstanceVarInstr(s2.getNewTemporaryVariable(), (Operand)this.getSelf(s2), new StringLiteral(((InstVarNode)node).getName())), "instance-variable");
            }
            case YIELDNODE: {
                return this.buildDefinitionCheck(s2, new BlockGivenInstr(s2.getNewTemporaryVariable()), "yield");
            }
            case BACKREFNODE: {
                return this.buildDefinitionCheck(s2, new BackrefIsMatchDataInstr(s2.getNewTemporaryVariable()), "$" + ((BackRefNode)node).getType());
            }
            case NTHREFNODE: {
                int n = ((NthRefNode)node).getMatchNumber();
                Label undefLabel = s2.getNewLabel();
                TemporaryVariable tmpVar = s2.getNewTemporaryVariable();
                s2.addInstr(new BackrefIsMatchDataInstr(tmpVar));
                s2.addInstr(BEQInstr.create(tmpVar, this.manager.getFalse(), undefLabel));
                s2.addInstr(CallInstr.create(tmpVar, new MethAddr("nil?"), new NthRef(n), NO_ARGS, null));
                s2.addInstr(BEQInstr.create(tmpVar, this.manager.getTrue(), undefLabel));
                return this.buildDefnCheckIfThenPaths(s2, undefLabel, new StringLiteral("$" + n));
            }
            case COLON2NODE: 
            case COLON3NODE: {
                Colon3Node iVisited = (Colon3Node)node;
                String name2 = iVisited.getName();
                TemporaryVariable errInfo = s2.getNewTemporaryVariable();
                s2.addInstr(new GetErrorInfoInstr(errInfo));
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run(Object[] args2) {
                        IRScope s2 = (IRScope)args2[0];
                        Node n = (Node)args2[1];
                        String name2 = (String)args2[2];
                        ObjectClass v = n instanceof Colon2Node ? IRBuilder.this.build(((Colon2Node)n).getLeftNode(), s2) : new ObjectClass();
                        TemporaryVariable tmpVar = s2.getNewTemporaryVariable();
                        s2.addInstr(new GetDefinedConstantOrMethodInstr(tmpVar, v, new StringLiteral(name2)));
                        return tmpVar;
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run(Object[] args2) {
                        IRScope m = (IRScope)args2[0];
                        m.addInstr(new RestoreErrorInfoInstr((Operand)args2[1]));
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(s2, protectedCode, new Object[]{s2, iVisited, name2}, rescueBlock, new Object[]{s2, errInfo});
            }
            case FCALLNODE: {
                Label undefLabel = s2.getNewLabel();
                TemporaryVariable tmpVar = s2.getNewTemporaryVariable();
                StringLiteral mName = new StringLiteral(((FCallNode)node).getName());
                s2.addInstr(new IsMethodBoundInstr(tmpVar, (Operand)this.getSelf(s2), mName));
                s2.addInstr(BEQInstr.create(tmpVar, this.manager.getFalse(), undefLabel));
                Operand argsCheckDefn = this.buildGetArgumentDefinition(((FCallNode)node).getArgsNode(), s2, "method");
                return this.buildDefnCheckIfThenPaths(s2, undefLabel, argsCheckDefn);
            }
            case VCALLNODE: {
                return this.buildDefinitionCheck(s2, new IsMethodBoundInstr(s2.getNewTemporaryVariable(), (Operand)this.getSelf(s2), new StringLiteral(((VCallNode)node).getName())), "method");
            }
            case CALLNODE: {
                Label undefLabel = s2.getNewLabel();
                CallNode iVisited = (CallNode)node;
                Operand receiverDefn = this.buildGetDefinition(iVisited.getReceiverNode(), s2);
                s2.addInstr(BEQInstr.create(receiverDefn, this.manager.getNil(), undefLabel));
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run(Object[] args2) {
                        IRScope s2 = (IRScope)args2[0];
                        CallNode iVisited = (CallNode)args2[1];
                        String methodName = iVisited.getName();
                        TemporaryVariable tmpVar = s2.getNewTemporaryVariable();
                        Operand receiver2 = IRBuilder.this.build(iVisited.getReceiverNode(), s2);
                        s2.addInstr(new MethodDefinedInstr(tmpVar, receiver2, new StringLiteral(methodName)));
                        return IRBuilder.this.buildDefnCheckIfThenPaths(s2, (Label)args2[2], tmpVar);
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run(Object[] args2) {
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(s2, protectedCode, new Object[]{s2, iVisited, undefLabel}, rescueBlock, null);
            }
            case CLASSVARNODE: {
                ClassVarNode iVisited = (ClassVarNode)node;
                Operand cm = this.classVarDefinitionContainer(s2);
                return this.buildDefinitionCheck(s2, new ClassVarIsDefinedInstr(s2.getNewTemporaryVariable(), cm, new StringLiteral(iVisited.getName())), "class variable");
            }
            case ATTRASSIGNNODE: {
                Label undefLabel = s2.getNewLabel();
                AttrAssignNode iVisited = (AttrAssignNode)node;
                Operand receiverDefn = this.buildGetDefinition(iVisited.getReceiverNode(), s2);
                s2.addInstr(BEQInstr.create(receiverDefn, this.manager.getNil(), undefLabel));
                CodeBlock protectedCode = new CodeBlock(){

                    @Override
                    public Operand run(Object[] args2) {
                        IRScope s2 = (IRScope)args2[0];
                        AttrAssignNode iVisited = (AttrAssignNode)args2[1];
                        Label undefLabel = (Label)args2[2];
                        StringLiteral attrMethodName = new StringLiteral(iVisited.getName());
                        TemporaryVariable tmpVar = s2.getNewTemporaryVariable();
                        Operand receiver2 = IRBuilder.this.build(iVisited.getReceiverNode(), s2);
                        s2.addInstr(new MethodIsPublicInstr(tmpVar, receiver2, attrMethodName));
                        s2.addInstr(BEQInstr.create(tmpVar, IRBuilder.this.manager.getFalse(), undefLabel));
                        s2.addInstr(new IsMethodBoundInstr(tmpVar, (Operand)IRBuilder.this.getSelf(s2), attrMethodName));
                        s2.addInstr(BEQInstr.create(tmpVar, IRBuilder.this.manager.getFalse(), undefLabel));
                        Operand argsCheckDefn = IRBuilder.this.buildGetArgumentDefinition(((AttrAssignNode)node).getArgsNode(), s2, "assignment");
                        return IRBuilder.this.buildDefnCheckIfThenPaths(s2, undefLabel, argsCheckDefn);
                    }
                };
                CodeBlock rescueBlock = new CodeBlock(){

                    @Override
                    public Operand run(Object[] args2) {
                        return IRBuilder.this.manager.getNil();
                    }
                };
                return this.protectCodeWithRescue(s2, protectedCode, new Object[]{s2, iVisited, undefLabel}, rescueBlock, null);
            }
            case ZSUPERNODE: {
                return this.buildDefinitionCheck(s2, new SuperMethodBoundInstr(s2.getNewTemporaryVariable(), this.getSelf(s2)), "super");
            }
            case SUPERNODE: {
                Label undefLabel = s2.getNewLabel();
                TemporaryVariable tmpVar = s2.getNewTemporaryVariable();
                s2.addInstr(new SuperMethodBoundInstr(tmpVar, this.getSelf(s2)));
                s2.addInstr(BEQInstr.create(tmpVar, this.manager.getFalse(), undefLabel));
                Operand superDefnVal = this.buildGetArgumentDefinition(((SuperNode)node).getArgsNode(), s2, "super");
                return this.buildDefnCheckIfThenPaths(s2, undefLabel, superDefnVal);
            }
        }
        CodeBlock protectedCode = new CodeBlock(){

            @Override
            public Operand run(Object[] args2) {
                IRBuilder.this.build((Node)args2[0], (IRScope)args2[1]);
                return new StringLiteral("expression");
            }
        };
        CodeBlock rescueBlock = new CodeBlock(){

            @Override
            public Operand run(Object[] args2) {
                return IRBuilder.this.manager.getNil();
            }
        };
        return this.protectCodeWithRescue(s2, protectedCode, new Object[]{node, s2}, rescueBlock, null);
    }

    public Operand buildDAsgn(DAsgnNode dasgnNode, IRScope s2) {
        int depth = dasgnNode.getDepth();
        LocalVariable arg2 = s2.getLocalVariable(dasgnNode.getName(), depth);
        Operand value2 = this.build(dasgnNode.getValueNode(), s2);
        s2.addInstr(new CopyInstr(arg2, value2));
        return value2;
    }

    private IRMethod defineNewMethod(MethodDefNode defNode, IRScope s2, boolean isInstanceMethod) {
        IRMethod method2 = new IRMethod(this.manager, s2, defNode.getName(), isInstanceMethod, defNode.getPosition().getLine(), defNode.getScope());
        method2.addInstr(new ReceiveSelfInstr(this.getSelf(s2)));
        IRScope nearestScope = s2.getNearestModuleReferencingScope();
        method2.addInstr(new CopyInstr(method2.getCurrentScopeVariable(), new CurrentScope(nearestScope == null ? s2 : nearestScope)));
        method2.addInstr(new CopyInstr(method2.getCurrentModuleVariable(), new ScopeModule(nearestScope == null ? s2 : nearestScope)));
        this.receiveMethodArgs(defNode.getArgsNode(), method2);
        method2.addInstr(new ThreadPollInstr());
        Node bodyNode = defNode.getBodyNode();
        if (bodyNode != null) {
            Operand rv = IRBuilder.createIRBuilder(this.manager, this.is1_9()).build(bodyNode, method2);
            if (rv != null) {
                method2.addInstr(new ReturnInstr(rv));
            }
        } else {
            method2.addInstr(new ReturnInstr(this.manager.getNil()));
        }
        if (method2.canReceiveNonlocalReturns()) {
            this.handleNonlocalReturnInMethod(method2);
        }
        return method2;
    }

    public Operand buildDefn(MethodDefNode node, IRScope s2) {
        IRMethod method2 = this.defineNewMethod(node, s2, true);
        s2.addInstr(new DefineInstanceMethodInstr(new StringLiteral("--unused--"), method2));
        return this.manager.getNil();
    }

    public Operand buildDefs(DefsNode node, IRScope s2) {
        Operand container = this.build(node.getReceiverNode(), s2);
        IRMethod method2 = this.defineNewMethod(node, s2, false);
        s2.addInstr(new DefineClassMethodInstr(container, method2));
        return this.manager.getNil();
    }

    protected int receiveOptArgs(ArgsNode argsNode, IRScope s2, int opt, int argIndex) {
        ListNode optArgs = argsNode.getOptArgs();
        int j = 0;
        while (j < opt) {
            Label l = s2.getNewLabel();
            LocalAsgnNode n = (LocalAsgnNode)optArgs.get(j);
            String argName = n.getName();
            LocalVariable av = s2.getLocalVariable(argName, 0);
            if (s2 instanceof IRMethod) {
                ((IRMethod)s2).addArgDesc("opt", argName);
            }
            s2.addInstr(new ReceiveOptArgInstr18(av, argIndex));
            s2.addInstr(BNEInstr.create(av, UndefinedValue.UNDEFINED, l));
            this.build(n, s2);
            s2.addInstr(new LabelInstr(l));
            ++j;
            ++argIndex;
        }
        return argIndex;
    }

    public void receiveMethodArgs(ArgsNode argsNode, IRScope s2) {
        int required = argsNode.getRequiredArgsCount();
        int opt = argsNode.getOptionalArgsCount();
        int rest2 = argsNode.getRestArg();
        s2.getStaticScope().setArities(required, opt, rest2);
        s2.addInstr(new CheckArityInstr(required, opt, rest2));
        int argIndex = 0;
        ListNode preArgs = argsNode.getPre();
        int i2 = 0;
        while (i2 < required) {
            ArgumentNode a = (ArgumentNode)preArgs.get(i2);
            String argName = a.getName();
            s2.addInstr(new ReceivePreReqdArgInstr(s2.getLocalVariable(argName, 0), argIndex));
            if (s2 instanceof IRMethod) {
                ((IRMethod)s2).addArgDesc("req", argName);
            }
            ++i2;
            ++argIndex;
        }
        if (opt > 0) {
            argIndex = this.receiveOptArgs(argsNode, s2, opt, argIndex);
        }
        if (rest2 > -1) {
            String argName = argsNode.getRestArgNode().getName();
            if (s2 instanceof IRMethod) {
                ((IRMethod)s2).addArgDesc("rest", argName);
            }
            argName = argName.equals("") ? "%_arg_array" : argName;
            s2.addInstr(new ReceiveRestArgInstr18(s2.getLocalVariable(argName, 0), argIndex));
        }
        this.receiveMethodClosureArg(argsNode, s2);
    }

    private void receiveMethodClosureArg(ArgsNode argsNode, IRScope s2) {
        LocalVariable blockVar = null;
        if (argsNode.getBlock() != null) {
            String blockArgName = argsNode.getBlock().getName();
            blockVar = s2.getLocalVariable(blockArgName, 0);
            if (s2 instanceof IRMethod) {
                ((IRMethod)s2).addArgDesc("block", blockArgName);
            }
            s2.addInstr(new ReceiveClosureInstr(blockVar));
        }
        LocalVariable implicitBlockArg = s2.getImplicitBlockArg();
        if (blockVar == null) {
            s2.addInstr(new ReceiveClosureInstr(implicitBlockArg));
        } else {
            s2.addInstr(new CopyInstr(implicitBlockArg, blockVar));
        }
    }

    public void receiveBlockArgs(IterNode node, IRScope s2) {
        this.buildBlockArgsAssignment(node.getVarNode(), s2, null, 0, true, false, false);
    }

    public void receiveBlockClosureArg(Node node, IRScope s2) {
        if (node != null) {
            this.buildBlockArgsAssignment(node, s2, null, 0, true, true, false);
        }
    }

    public String buildType(Node typeNode) {
        switch (typeNode.getNodeType()) {
            case CONSTNODE: {
                return ((ConstNode)typeNode).getName();
            }
            case SYMBOLNODE: {
                return ((SymbolNode)typeNode).getName();
            }
        }
        return "unknown_type";
    }

    public Operand buildDot(DotNode dotNode, IRScope s2) {
        return this.copyAndReturnValue(s2, new Range(this.build(dotNode.getBeginNode(), s2), this.build(dotNode.getEndNode(), s2), dotNode.isExclusive()));
    }

    private Operand dynamicPiece(Node pieceNode, IRScope s2) {
        Operand piece = this.build(pieceNode, s2);
        return piece == null ? this.manager.getNil() : piece;
    }

    public Operand buildDRegexp(DRegexpNode dregexpNode, IRScope s2) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node n : dregexpNode.childNodes()) {
            strPieces.add(this.dynamicPiece(n, s2));
        }
        return this.copyAndReturnValue(s2, new Regexp(new CompoundString(strPieces), dregexpNode.getOptions()));
    }

    public Operand buildDStr(DStrNode dstrNode, IRScope s2) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node n : dstrNode.childNodes()) {
            strPieces.add(this.dynamicPiece(n, s2));
        }
        return this.copyAndReturnValue(s2, new CompoundString(strPieces, dstrNode.getEncoding()));
    }

    public Operand buildDSymbol(DSymbolNode node, IRScope s2) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node n : node.childNodes()) {
            strPieces.add(this.dynamicPiece(n, s2));
        }
        return this.copyAndReturnValue(s2, new DynamicSymbol(new CompoundString(strPieces, node.getEncoding())));
    }

    public Operand buildDVar(DVarNode node, IRScope s2) {
        return s2.getLocalVariable(node.getName(), node.getDepth());
    }

    public Operand buildDXStr(DXStrNode dstrNode, IRScope s2) {
        ArrayList<Operand> strPieces = new ArrayList<Operand>();
        for (Node nextNode : dstrNode.childNodes()) {
            strPieces.add(this.dynamicPiece(nextNode, s2));
        }
        return this.copyAndReturnValue(s2, new BacktickString(strPieces));
    }

    public Operand buildEnsureNode(EnsureNode ensureNode, IRScope s2) {
        Nil ensureRetVal;
        Operand rv;
        Node bodyNode = ensureNode.getBodyNode();
        EnsureBlockInfo ebi = new EnsureBlockInfo(s2, bodyNode instanceof RescueNode ? (RescueNode)bodyNode : null, this.getCurrentLoop());
        this._ensureBlockStack.push(ebi);
        Label rBeginLabel = ebi.regionStart;
        Label rEndLabel = ebi.end;
        s2.addInstr(new LabelInstr(rBeginLabel));
        s2.addInstr(new ExceptionRegionStartMarkerInstr(rBeginLabel, rEndLabel, ebi.dummyRescueBlockLabel, ebi.dummyRescueBlockLabel));
        if (bodyNode instanceof RescueNode) {
            rv = this.buildRescueInternal((RescueNode)bodyNode, s2, ebi);
        } else {
            rv = this.build(bodyNode, s2);
            if (rv != U_NIL) {
                s2.addInstr(new SetReturnAddressInstr(ebi.returnAddr, rEndLabel));
            }
        }
        s2.addInstr(new ExceptionRegionEndMarkerInstr());
        this._ensureBlockStack.pop();
        s2.addInstr(new JumpInstr(ebi.start));
        Label rethrowExcLabel = s2.getNewLabel();
        TemporaryVariable exc = s2.getNewTemporaryVariable();
        s2.addInstr(new LabelInstr(ebi.dummyRescueBlockLabel));
        s2.addInstr(new ReceiveExceptionInstr(exc, false));
        s2.addInstr(new SetReturnAddressInstr(ebi.returnAddr, rethrowExcLabel));
        s2.addInstr(new LabelInstr(ebi.start));
        Operand operand = ensureRetVal = ensureNode.getEnsureNode() == null ? this.manager.getNil() : this.build(ensureNode.getEnsureNode(), s2);
        if (ensureRetVal == U_NIL) {
            rv = U_NIL;
        }
        s2.addInstr(new JumpIndirectInstr(ebi.returnAddr));
        s2.addInstr(new LabelInstr(rethrowExcLabel));
        s2.addInstr(new ThrowExceptionInstr(exc));
        s2.addInstr(new LabelInstr(rEndLabel));
        return rv;
    }

    public Operand buildEvStr(EvStrNode node, IRScope s2) {
        return new AsString(this.build(node.getBody(), s2));
    }

    public Operand buildFalse(Node node, IRScope s2) {
        return this.manager.getFalse();
    }

    public Operand buildFCall(FCallNode fcallNode, IRScope s2) {
        Node callArgsNode = fcallNode.getArgsNode();
        List<Operand> args2 = this.setupCallArgs(callArgsNode, s2);
        Operand block = this.setupCallClosure(fcallNode.getIterNode(), s2);
        TemporaryVariable callResult = s2.getNewTemporaryVariable();
        CallInstr callInstr = CallInstr.create(CallType.FUNCTIONAL, callResult, new MethAddr(fcallNode.getName()), this.getSelf(s2), args2.toArray(new Operand[args2.size()]), block);
        this.receiveBreakException(s2, block, callInstr);
        return callResult;
    }

    private Operand setupCallClosure(Node node, IRScope s2) {
        if (node == null) {
            return null;
        }
        switch (node.getNodeType()) {
            case ITERNODE: {
                return this.build((IterNode)node, s2);
            }
            case BLOCKPASSNODE: {
                return this.build(((BlockPassNode)node).getBodyNode(), s2);
            }
        }
        throw new NotCompilableException("ERROR: Encountered a method with a non-block, non-blockpass iter node at: " + node);
    }

    public Operand buildFixnum(FixnumNode node, IRScope s2) {
        return new Fixnum(node.getValue());
    }

    public Operand buildFlip(FlipNode flipNode, IRScope s2) {
        Fixnum s1 = new Fixnum(1L);
        Fixnum s22 = new Fixnum(2L);
        IRScope nearestNonClosure = s2.getNearestFlipVariableScope();
        LocalVariable flipState = nearestNonClosure.getNewFlipStateVariable();
        nearestNonClosure.initFlipStateVariable(flipState, s1);
        if (s2 instanceof IRClosure) {
            int n = 0;
            IRScope x = s2;
            while (!x.isFlipScope()) {
                if (!x.isForLoopBody()) {
                    ++n;
                }
                x = x.getLexicalParent();
            }
            if (n > 0) {
                flipState = flipState.cloneForDepth(n);
            }
        }
        TemporaryVariable returnVal = s2.getNewTemporaryVariable();
        Label s2Label = s2.getNewLabel();
        Label doneLabel = s2.getNewLabel();
        s2.addInstr(new CopyInstr(returnVal, this.manager.getFalse()));
        s2.addInstr(BNEInstr.create(flipState, s1, s2Label));
        Operand s1Val = this.build(flipNode.getBeginNode(), s2);
        s2.addInstr(BNEInstr.create(s1Val, this.manager.getTrue(), s2Label));
        s2.addInstr(new CopyInstr(returnVal, this.manager.getTrue()));
        s2.addInstr(new CopyInstr(flipState, s22));
        s2.addInstr(new LabelInstr(s2Label));
        if (flipNode.isExclusive()) {
            s2.addInstr(BEQInstr.create(returnVal, this.manager.getTrue(), doneLabel));
        }
        s2.addInstr(BNEInstr.create(flipState, s22, doneLabel));
        Operand s2Val = this.build(flipNode.getEndNode(), s2);
        s2.addInstr(new CopyInstr(returnVal, this.manager.getTrue()));
        s2.addInstr(BNEInstr.create(s2Val, this.manager.getTrue(), doneLabel));
        s2.addInstr(new CopyInstr(flipState, s1));
        s2.addInstr(new LabelInstr(doneLabel));
        return returnVal;
    }

    public Operand buildFloat(FloatNode node, IRScope s2) {
        return new Float(node.getValue());
    }

    public Operand buildFor(ForNode forNode, IRScope s2) {
        TemporaryVariable result2 = s2.getNewTemporaryVariable();
        Operand receiver2 = this.build(forNode.getIterNode(), s2);
        Operand forBlock = this.buildForIter(forNode, s2);
        CallInstr callInstr = new CallInstr(CallType.NORMAL, result2, new MethAddr("each"), receiver2, NO_ARGS, forBlock);
        this.receiveBreakException(s2, forBlock, callInstr);
        return result2;
    }

    public Operand buildForIter(ForNode forNode, IRScope s2) {
        Nil closureRetVal;
        IRClosure closure = new IRClosure(this.manager, s2, true, forNode.getPosition().getStartLine(), forNode.getScope(), Arity.procArityOf(forNode.getVarNode()), forNode.getArgumentType(), this.is1_9());
        s2.addClosure(closure);
        IRBuilder forBuilder = IRBuilder.createIRBuilder(this.manager, this.is1_9());
        closure.addInstr(new ReceiveSelfInstr(this.getSelf(closure)));
        Node varNode = forNode.getVarNode();
        if (varNode != null && varNode.getNodeType() != null) {
            forBuilder.receiveBlockArgs(forNode, closure);
        }
        closure.addInstr(new CopyInstr(closure.getCurrentScopeVariable(), new CurrentScope(closure)));
        closure.addInstr(new CopyInstr(closure.getCurrentModuleVariable(), new ScopeModule(closure)));
        closure.addInstr(new ThreadPollInstr());
        closure.addInstr(new LabelInstr(closure.startLabel));
        Operand operand = closureRetVal = forNode.getBodyNode() == null ? this.manager.getNil() : forBuilder.build(forNode.getBodyNode(), closure);
        if (closureRetVal != U_NIL) {
            closure.addInstr(new ReturnInstr(closureRetVal));
        }
        return new WrappedIRClosure(closure);
    }

    public Operand buildGlobalAsgn(GlobalAsgnNode globalAsgnNode, IRScope s2) {
        Operand value2 = this.build(globalAsgnNode.getValueNode(), s2);
        s2.addInstr(new PutGlobalVarInstr(globalAsgnNode.getName(), value2));
        return value2;
    }

    public Operand buildGlobalVar(GlobalVarNode node, IRScope s2) {
        TemporaryVariable rv = s2.getNewTemporaryVariable();
        s2.addInstr(new GetGlobalVariableInstr(rv, node.getName()));
        return rv;
    }

    public Operand buildHash(HashNode hashNode, IRScope s2) {
        if (hashNode.getListNode() == null || hashNode.getListNode().size() == 0) {
            return this.copyAndReturnValue(s2, new Hash(new ArrayList<KeyValuePair>()));
        }
        boolean i2 = false;
        Operand key2 = null;
        Object value2 = null;
        ArrayList<KeyValuePair> args2 = new ArrayList<KeyValuePair>();
        for (Node nextNode : hashNode.getListNode().childNodes()) {
            Operand v = this.build(nextNode, s2);
            if (key2 == null) {
                key2 = v;
                continue;
            }
            args2.add(new KeyValuePair(key2, v));
            key2 = null;
        }
        return this.copyAndReturnValue(s2, new Hash(args2));
    }

    public Operand buildIf(IfNode ifNode, IRScope s2) {
        Variable result2;
        Node actualCondition = this.skipOverNewlines(s2, ifNode.getCondition());
        Label falseLabel = s2.getNewLabel();
        Label doneLabel = s2.getNewLabel();
        s2.addInstr(BEQInstr.create(this.build(actualCondition, s2), this.manager.getFalse(), falseLabel));
        boolean thenNull = false;
        boolean elseNull = false;
        boolean thenUnil = false;
        boolean elseUnil = false;
        if (ifNode.getThenBody() != null) {
            Operand thenResult = this.build(ifNode.getThenBody(), s2);
            if (thenResult != U_NIL) {
                Label tgt = doneLabel;
                result2 = this.getValueInTemporaryVariable(s2, thenResult);
                s2.addInstr(new JumpInstr(tgt));
            } else {
                result2 = s2.getNewTemporaryVariable();
                thenUnil = true;
            }
        } else {
            thenNull = true;
            result2 = s2.getNewTemporaryVariable();
            s2.addInstr(new CopyInstr(result2, this.manager.getNil()));
            s2.addInstr(new JumpInstr(doneLabel));
        }
        s2.addInstr(new LabelInstr(falseLabel));
        if (ifNode.getElseBody() != null) {
            Operand elseResult = this.build(ifNode.getElseBody(), s2);
            if (elseResult != U_NIL) {
                s2.addInstr(new CopyInstr(result2, elseResult));
            } else {
                elseUnil = true;
            }
        } else {
            elseNull = true;
            s2.addInstr(new CopyInstr(result2, this.manager.getNil()));
        }
        if (thenNull && elseNull) {
            s2.addInstr(new LabelInstr(doneLabel));
            return this.manager.getNil();
        }
        if (thenUnil && elseUnil) {
            return U_NIL;
        }
        s2.addInstr(new LabelInstr(doneLabel));
        return result2;
    }

    public Operand buildInstAsgn(InstAsgnNode instAsgnNode, IRScope s2) {
        Operand val = this.build(instAsgnNode.getValueNode(), s2);
        s2.addInstr(new PutFieldInstr(this.getSelf(s2), instAsgnNode.getName(), val));
        return val;
    }

    public Operand buildInstVar(InstVarNode node, IRScope s2) {
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new GetFieldInstr(ret, this.getSelf(s2), node.getName()));
        return ret;
    }

    public Operand buildIter(IterNode iterNode, IRScope s2) {
        Nil closureRetVal;
        IRClosure closure = new IRClosure(this.manager, s2, false, iterNode.getPosition().getStartLine(), iterNode.getScope(), Arity.procArityOf(iterNode.getVarNode()), iterNode.getArgumentType(), this.is1_9());
        s2.addClosure(closure);
        IRBuilder closureBuilder = IRBuilder.createIRBuilder(this.manager, this.is1_9());
        closure.addInstr(new ReceiveSelfInstr(this.getSelf(closure)));
        NodeType argsNodeId = BlockBody.getArgumentTypeWackyHack(iterNode);
        if (iterNode.getVarNode() != null && argsNodeId != null) {
            closureBuilder.receiveBlockArgs(iterNode, closure);
        }
        closureBuilder.receiveBlockClosureArg(iterNode.getBlockVarNode(), closure);
        closure.addInstr(new CopyInstr(closure.getCurrentScopeVariable(), new CurrentScope(closure)));
        closure.addInstr(new CopyInstr(closure.getCurrentModuleVariable(), new ScopeModule(closure)));
        closure.addInstr(new ThreadPollInstr());
        closure.addInstr(new LabelInstr(closure.startLabel));
        Operand operand = closureRetVal = iterNode.getBodyNode() == null ? this.manager.getNil() : closureBuilder.build(iterNode.getBodyNode(), closure);
        if (closureRetVal != U_NIL) {
            closure.addInstr(new ReturnInstr(closureRetVal));
        }
        return new WrappedIRClosure(closure);
    }

    public Operand buildLiteral(LiteralNode literalNode, IRScope s2) {
        return this.copyAndReturnValue(s2, new StringLiteral(literalNode.getName()));
    }

    public Operand buildLocalAsgn(LocalAsgnNode localAsgnNode, IRScope s2) {
        LocalVariable var = s2.getLocalVariable(localAsgnNode.getName(), localAsgnNode.getDepth());
        Operand value2 = this.build(localAsgnNode.getValueNode(), s2);
        s2.addInstr(new CopyInstr(var, value2));
        return value2;
    }

    public Operand buildLocalVar(LocalVarNode node, IRScope s2) {
        return s2.getLocalVariable(node.getName(), node.getDepth());
    }

    public Operand buildMatch(MatchNode matchNode, IRScope s2) {
        Operand regexp2 = this.build(matchNode.getRegexpNode(), s2);
        TemporaryVariable result2 = s2.getNewTemporaryVariable();
        s2.addInstr(new MatchInstr(result2, regexp2));
        return result2;
    }

    public Operand buildMatch2(Match2Node matchNode, IRScope s2) {
        Operand receiver2 = this.build(matchNode.getReceiverNode(), s2);
        Operand value2 = this.build(matchNode.getValueNode(), s2);
        TemporaryVariable result2 = s2.getNewTemporaryVariable();
        s2.addInstr(new Match2Instr(result2, receiver2, value2));
        return result2;
    }

    public Operand buildMatch3(Match3Node matchNode, IRScope s2) {
        Operand receiver2 = this.build(matchNode.getReceiverNode(), s2);
        Operand value2 = this.build(matchNode.getValueNode(), s2);
        TemporaryVariable result2 = s2.getNewTemporaryVariable();
        s2.addInstr(new Match3Instr(result2, receiver2, value2));
        return result2;
    }

    private Operand getContainerFromCPath(Colon3Node cpath, IRScope s2) {
        Node leftNode;
        Operand container = cpath instanceof Colon2Node ? ((leftNode = ((Colon2Node)cpath).getLeftNode()) != null ? this.build(leftNode, s2) : this.findContainerModule(s2)) : new ScopeModule(this.manager.getObject());
        return container;
    }

    public Operand buildModule(ModuleNode moduleNode, IRScope s2) {
        Colon3Node cpath = moduleNode.getCPath();
        String moduleName = cpath.getName();
        Operand container = this.getContainerFromCPath(cpath, s2);
        IRModuleBody m = new IRModuleBody(this.manager, s2, moduleName, moduleNode.getPosition().getLine(), moduleNode.getScope());
        TemporaryVariable moduleBody = s2.getNewTemporaryVariable();
        s2.addInstr(new DefineModuleInstr(moduleBody, m, container));
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new ProcessModuleBodyInstr(ret, moduleBody));
        m.addInstr(new ReceiveSelfInstr(m.getSelf()));
        m.addInstr(new CopyInstr(m.getCurrentScopeVariable(), new CurrentScope(m)));
        m.addInstr(new CopyInstr(m.getCurrentModuleVariable(), new ScopeModule(m)));
        Operand rv = IRBuilder.createIRBuilder(this.manager, this.is1_9()).build(moduleNode.getBodyNode(), m);
        if (rv != null) {
            m.addInstr(new ReturnInstr(rv));
        }
        return ret;
    }

    public Operand buildMultipleAsgn(MultipleAsgnNode multipleAsgnNode, IRScope s2) {
        Operand values2 = this.build(multipleAsgnNode.getValueNode(), s2);
        Variable ret = this.getValueInTemporaryVariable(s2, values2);
        this.buildMultipleAsgnAssignment(multipleAsgnNode, s2, null, ret);
        return ret;
    }

    public void buildMultipleAsgnAssignment(MultipleAsgnNode multipleAsgnNode, IRScope s2, Operand argsArray, Operand values2) {
        Node argsNode;
        ListNode sourceArray = multipleAsgnNode.getHeadNode();
        int i2 = 0;
        if (sourceArray != null) {
            for (Node an : sourceArray.childNodes()) {
                if (values2 == null) {
                    this.buildBlockArgsAssignment(an, s2, argsArray, i2, false, false, false);
                } else {
                    TemporaryVariable rhsVal = s2.getNewTemporaryVariable();
                    s2.addInstr(new ReqdArgMultipleAsgnInstr(rhsVal, values2, i2));
                    this.buildAssignment(an, s2, rhsVal);
                }
                ++i2;
            }
        }
        if ((argsNode = multipleAsgnNode.getArgsNode()) == null) {
            if (sourceArray == null) {
                throw new NotCompilableException("Something's wrong, multiple assignment with no head or args at: " + multipleAsgnNode.getPosition());
            }
        } else if (!(argsNode instanceof StarNode)) {
            if (values2 != null) {
                TemporaryVariable rhsVal = s2.getNewTemporaryVariable();
                s2.addInstr(new RestArgMultipleAsgnInstr(rhsVal, values2, i2));
                this.buildAssignment(argsNode, s2, rhsVal);
            } else {
                this.buildBlockArgsAssignment(argsNode, s2, argsArray, i2, false, false, true);
            }
        }
    }

    public Operand buildNewline(NewlineNode node, IRScope s2) {
        return this.build(this.skipOverNewlines(s2, node), s2);
    }

    public Operand buildNext(NextNode nextNode, IRScope s2) {
        Nil rv;
        IRLoop currLoop = this.getCurrentLoop();
        Operand operand = rv = nextNode.getValueNode() == null ? this.manager.getNil() : this.build(nextNode.getValueNode(), s2);
        if (!this._ensureBlockStack.empty()) {
            EnsureBlockInfo.emitJumpChain(s2, this._ensureBlockStack, currLoop);
        } else if (!this._rescueBlockStack.empty()) {
            this._rescueBlockStack.peek().restoreException(s2, currLoop);
        }
        if (currLoop != null) {
            s2.addInstr(new JumpInstr(currLoop.iterEndLabel));
        } else {
            s2.addInstr(new ThreadPollInstr(true));
            if (s2 instanceof IRClosure) {
                s2.addInstr(new ReturnInstr(rv));
            } else {
                s2.addInstr(new ThrowExceptionInstr(IRException.NEXT_LocalJumpError));
            }
        }
        return UnexecutableNil.U_NIL;
    }

    public Operand buildNthRef(NthRefNode nthRefNode, IRScope s2) {
        return this.copyAndReturnValue(s2, new NthRef(nthRefNode.getMatchNumber()));
    }

    public Operand buildNil(Node node, IRScope s2) {
        return this.manager.getNil();
    }

    public Operand buildNot(NotNode node, IRScope s2) {
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new NotInstr(ret, this.build(node.getConditionNode(), s2)));
        return ret;
    }

    public Operand buildOpAsgn(OpAsgnNode opAsgnNode, IRScope s2) {
        TemporaryVariable readerValue = s2.getNewTemporaryVariable();
        TemporaryVariable writerValue = s2.getNewTemporaryVariable();
        Operand v1 = this.build(opAsgnNode.getReceiverNode(), s2);
        s2.addInstr(CallInstr.create(readerValue, new MethAddr(opAsgnNode.getVariableName()), v1, NO_ARGS, null));
        String opName = opAsgnNode.getOperatorName();
        if (opName.equals("||") || opName.equals("&&")) {
            Label l = s2.getNewLabel();
            s2.addInstr(BEQInstr.create(readerValue, opName.equals("||") ? this.manager.getTrue() : this.manager.getFalse(), l));
            Operand v2 = this.build(opAsgnNode.getValueNode(), s2);
            s2.addInstr(CallInstr.create(writerValue, new MethAddr(opAsgnNode.getVariableNameAsgn()), v1, new Operand[]{v2}, null));
            s2.addInstr(new CopyInstr(readerValue, v2));
            s2.addInstr(new LabelInstr(l));
            return readerValue;
        }
        Operand v2 = this.build(opAsgnNode.getValueNode(), s2);
        TemporaryVariable setValue2 = s2.getNewTemporaryVariable();
        s2.addInstr(CallInstr.create(setValue2, new MethAddr(opAsgnNode.getOperatorName()), readerValue, new Operand[]{v2}, null));
        s2.addInstr(CallInstr.create(writerValue, new MethAddr(opAsgnNode.getVariableNameAsgn()), v1, new Operand[]{setValue2}, null));
        return setValue2;
    }

    public Operand buildOpAsgnAnd(OpAsgnAndNode andNode, IRScope s2) {
        Label l = s2.getNewLabel();
        Operand v1 = this.build(andNode.getFirstNode(), s2);
        Variable result2 = this.getValueInTemporaryVariable(s2, v1);
        s2.addInstr(BEQInstr.create(v1, this.manager.getFalse(), l));
        Operand v2 = this.build(andNode.getSecondNode(), s2);
        s2.addInstr(new CopyInstr(result2, v2));
        s2.addInstr(new LabelInstr(l));
        return result2;
    }

    public Operand buildOpAsgnOr(OpAsgnOrNode orNode, IRScope s2) {
        Operand v1;
        Label l1 = s2.getNewLabel();
        Label l2 = null;
        TemporaryVariable flag = s2.getNewTemporaryVariable();
        boolean needsDefnCheck = this.needsDefinitionCheck(orNode.getFirstNode());
        if (needsDefnCheck) {
            l2 = s2.getNewLabel();
            v1 = this.buildGetDefinitionBase(orNode.getFirstNode(), s2);
            s2.addInstr(new CopyInstr(flag, v1));
            s2.addInstr(BEQInstr.create(flag, this.manager.getNil(), l2));
        }
        v1 = this.build(orNode.getFirstNode(), s2);
        s2.addInstr(new CopyInstr(flag, v1));
        Variable result2 = this.getValueInTemporaryVariable(s2, v1);
        if (needsDefnCheck) {
            s2.addInstr(new LabelInstr(l2));
        }
        s2.addInstr(BEQInstr.create(flag, this.manager.getTrue(), l1));
        Operand v2 = this.build(orNode.getSecondNode(), s2);
        s2.addInstr(new CopyInstr(result2, v2));
        s2.addInstr(new LabelInstr(l1));
        return result2;
    }

    private boolean needsDefinitionCheck(Node node) {
        switch (node.getNodeType()) {
            case CLASSVARASGNNODE: 
            case CLASSVARDECLNODE: 
            case CONSTDECLNODE: 
            case DASGNNODE: 
            case DVARNODE: 
            case FALSENODE: 
            case GLOBALASGNNODE: 
            case LOCALASGNNODE: 
            case LOCALVARNODE: 
            case MATCH2NODE: 
            case MATCH3NODE: 
            case MULTIPLEASGNNODE: 
            case NILNODE: 
            case OPASGNNODE: 
            case OPELEMENTASGNNODE: 
            case SELFNODE: 
            case TRUENODE: {
                return false;
            }
        }
        return true;
    }

    public Operand buildOpElementAsgn(OpElementAsgnNode node, IRScope s2) {
        if (node.isOr()) {
            return this.buildOpElementAsgnWithOr(node, s2);
        }
        if (node.isAnd()) {
            return this.buildOpElementAsgnWithAnd(node, s2);
        }
        return this.buildOpElementAsgnWithMethod(node, s2);
    }

    public Operand buildOpElementAsgnWithOr(OpElementAsgnNode opElementAsgnNode, IRScope s2) {
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s2);
        Label l = s2.getNewLabel();
        TemporaryVariable elt = s2.getNewTemporaryVariable();
        List<Operand> argList = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s2);
        s2.addInstr(CallInstr.create(elt, new MethAddr("[]"), array, argList.toArray(new Operand[argList.size()]), null));
        s2.addInstr(BEQInstr.create(elt, this.manager.getTrue(), l));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s2);
        argList.add(value2);
        s2.addInstr(CallInstr.create(elt, new MethAddr("[]="), array, argList.toArray(new Operand[argList.size()]), null));
        s2.addInstr(new CopyInstr(elt, value2));
        s2.addInstr(new LabelInstr(l));
        return elt;
    }

    public Operand buildOpElementAsgnWithAnd(OpElementAsgnNode opElementAsgnNode, IRScope s2) {
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s2);
        Label l = s2.getNewLabel();
        TemporaryVariable elt = s2.getNewTemporaryVariable();
        List<Operand> argList = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s2);
        s2.addInstr(CallInstr.create(elt, new MethAddr("[]"), array, argList.toArray(new Operand[argList.size()]), null));
        s2.addInstr(BEQInstr.create(elt, this.manager.getFalse(), l));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s2);
        argList.add(value2);
        s2.addInstr(CallInstr.create(elt, new MethAddr("[]="), array, argList.toArray(new Operand[argList.size()]), null));
        s2.addInstr(new CopyInstr(elt, value2));
        s2.addInstr(new LabelInstr(l));
        return elt;
    }

    public Operand buildOpElementAsgnWithMethod(OpElementAsgnNode opElementAsgnNode, IRScope s2) {
        Operand array = this.build(opElementAsgnNode.getReceiverNode(), s2);
        List<Operand> argList = this.setupCallArgs(opElementAsgnNode.getArgsNode(), s2);
        TemporaryVariable elt = s2.getNewTemporaryVariable();
        s2.addInstr(CallInstr.create(elt, new MethAddr("[]"), array, argList.toArray(new Operand[argList.size()]), null));
        Operand value2 = this.build(opElementAsgnNode.getValueNode(), s2);
        String operation = opElementAsgnNode.getOperatorName();
        s2.addInstr(CallInstr.create(elt, new MethAddr(operation), elt, new Operand[]{value2}, null));
        TemporaryVariable tmp = s2.getNewTemporaryVariable();
        argList.add(elt);
        s2.addInstr(CallInstr.create(tmp, new MethAddr("[]="), array, argList.toArray(new Operand[argList.size()]), null));
        return elt;
    }

    public Operand buildOr(OrNode orNode, IRScope s2) {
        if (orNode.getFirstNode().getNodeType().alwaysTrue()) {
            return this.build(orNode.getFirstNode(), s2);
        }
        if (orNode.getFirstNode().getNodeType().alwaysFalse()) {
            this.build(orNode.getFirstNode(), s2);
            return this.build(orNode.getSecondNode(), s2);
        }
        Label l = s2.getNewLabel();
        Operand v1 = this.build(orNode.getFirstNode(), s2);
        Variable ret = this.getValueInTemporaryVariable(s2, v1);
        s2.addInstr(BEQInstr.create(v1, this.manager.getTrue(), l));
        Operand v2 = this.build(orNode.getSecondNode(), s2);
        s2.addInstr(new CopyInstr(ret, v2));
        s2.addInstr(new LabelInstr(l));
        return ret;
    }

    public Operand buildPostExe(PostExeNode postExeNode, IRScope s2) {
        IRClosure endClosure = new IRClosure(this.manager, s2, false, postExeNode.getPosition().getStartLine(), postExeNode.getScope(), Arity.procArityOf(postExeNode.getVarNode()), postExeNode.getArgumentType(), this.is1_9());
        endClosure.addInstr(new CopyInstr(endClosure.getCurrentScopeVariable(), new CurrentScope(endClosure)));
        endClosure.addInstr(new CopyInstr(endClosure.getCurrentModuleVariable(), new ScopeModule(endClosure)));
        this.build(postExeNode.getBodyNode(), endClosure);
        s2.addInstr(new RecordEndBlockInstr(s2, endClosure));
        return this.manager.getNil();
    }

    public Operand buildPreExe(PreExeNode preExeNode, IRScope s2) {
        IRClosure beginClosure = new IRClosure(this.manager, s2, false, preExeNode.getPosition().getStartLine(), preExeNode.getScope(), Arity.procArityOf(preExeNode.getVarNode()), preExeNode.getArgumentType(), this.is1_9());
        beginClosure.addInstr(new CopyInstr(beginClosure.getCurrentScopeVariable(), new CurrentScope(beginClosure)));
        beginClosure.addInstr(new CopyInstr(beginClosure.getCurrentModuleVariable(), new ScopeModule(beginClosure)));
        this.build(preExeNode.getBodyNode(), beginClosure);
        s2.getTopLevelScope().recordBeginBlock(beginClosure);
        return this.manager.getNil();
    }

    public Operand buildRedo(Node node, IRScope s2) {
        IRLoop currLoop = this.getCurrentLoop();
        if (currLoop != null) {
            s2.addInstr(new JumpInstr(currLoop.iterStartLabel));
        } else if (s2 instanceof IRClosure) {
            s2.addInstr(new ThreadPollInstr(true));
            s2.addInstr(new JumpInstr(((IRClosure)s2).startLabel));
        } else {
            s2.addInstr(new ThrowExceptionInstr(IRException.REDO_LocalJumpError));
        }
        return this.manager.getNil();
    }

    public Operand buildRegexp(RegexpNode reNode, IRScope s2) {
        return this.copyAndReturnValue(s2, new Regexp(new StringLiteral(reNode.getValue()), reNode.getOptions()));
    }

    public Operand buildRescue(RescueNode node, IRScope s2) {
        return this.buildRescueInternal(node, s2, null);
    }

    private Operand buildRescueInternal(RescueNode rescueNode, IRScope s2, EnsureBlockInfo ensure) {
        Label elseLabel;
        Label rBeginLabel = ensure == null ? s2.getNewLabel() : ensure.regionStart;
        Label rEndLabel = ensure == null ? s2.getNewLabel() : ensure.end;
        Label rescueLabel = s2.getNewLabel();
        if (ensure == null) {
            s2.addInstr(new LabelInstr(rBeginLabel));
        }
        s2.addInstr(new ExceptionRegionStartMarkerInstr(rBeginLabel, rEndLabel, ensure == null ? null : ensure.dummyRescueBlockLabel, rescueLabel));
        TemporaryVariable savedGlobalException = s2.getNewTemporaryVariable();
        s2.addInstr(new GetGlobalVariableInstr(savedGlobalException, "$!"));
        if (ensure != null) {
            ensure.savedGlobalException = savedGlobalException;
        }
        Operand tmp = this.manager.getNil();
        TemporaryVariable rv = s2.getNewTemporaryVariable();
        if (rescueNode.getBodyNode() != null) {
            tmp = this.build(rescueNode.getBodyNode(), s2);
        }
        this._rescueBlockStack.push(new RescueBlockInfo(rescueNode, rBeginLabel, savedGlobalException, this.getCurrentLoop()));
        ExceptionRegionEndMarkerInstr rbEndInstr = new ExceptionRegionEndMarkerInstr();
        s2.addInstr(rbEndInstr);
        Label label = elseLabel = rescueNode.getElseNode() == null ? null : s2.getNewLabel();
        if (elseLabel != null) {
            s2.addInstr(new LabelInstr(elseLabel));
            tmp = this.build(rescueNode.getElseNode(), s2);
        }
        if (tmp != U_NIL) {
            s2.addInstr(new CopyInstr(rv, tmp));
            if (ensure == null) {
                s2.addInstr(new JumpInstr(rEndLabel));
            } else {
                s2.addInstr(new SetReturnAddressInstr(ensure.returnAddr, rEndLabel));
                s2.addInstr(new JumpInstr(ensure.start));
            }
        }
        s2.addInstr(new LabelInstr(rescueLabel));
        this.buildRescueBodyInternal(s2, rescueNode.getRescueNode(), rv, rEndLabel);
        if (ensure == null) {
            s2.addInstr(new LabelInstr(rEndLabel));
        }
        this._rescueBlockStack.pop();
        return rv;
    }

    private void outputExceptionCheck(IRScope s2, Operand excType, Operand excObj, Label caughtLabel) {
        TemporaryVariable eqqResult = s2.getNewTemporaryVariable();
        s2.addInstr(new RescueEQQInstr(eqqResult, excType, excObj));
        s2.addInstr(BEQInstr.create(eqqResult, this.manager.getTrue(), caughtLabel));
    }

    private void buildRescueBodyInternal(IRScope s2, Node node, Variable rv, Label endLabel) {
        RescueBodyNode rescueBodyNode = (RescueBodyNode)node;
        Node exceptionList = rescueBodyNode.getExceptionNodes();
        TemporaryVariable exc = s2.getNewTemporaryVariable();
        s2.addInstr(new ReceiveExceptionInstr(exc));
        Label uncaughtLabel = s2.getNewLabel();
        Label caughtLabel = s2.getNewLabel();
        if (exceptionList != null) {
            if (exceptionList instanceof ListNode) {
                for (Node excType : ((ListNode)exceptionList).childNodes()) {
                    this.outputExceptionCheck(s2, this.build(excType, s2), exc, caughtLabel);
                }
            } else {
                this.outputExceptionCheck(s2, this.build(((SplatNode)exceptionList).getValue(), s2), exc, caughtLabel);
            }
        } else {
            TemporaryVariable v = s2.getNewTemporaryVariable();
            s2.addInstr(new InheritanceSearchConstInstr(v, s2.getCurrentModuleVariable(), "StandardError", false));
            this.outputExceptionCheck(s2, v, exc, caughtLabel);
        }
        s2.addInstr(new LabelInstr(uncaughtLabel));
        if (rescueBodyNode.getOptRescueNode() != null) {
            this.buildRescueBodyInternal(s2, rescueBodyNode.getOptRescueNode(), rv, endLabel);
        } else {
            s2.addInstr(new ThrowExceptionInstr(exc));
        }
        s2.addInstr(new LabelInstr(caughtLabel));
        Node realBody = this.skipOverNewlines(s2, rescueBodyNode.getBodyNode());
        Operand x = this.build(realBody, s2);
        if (x != U_NIL) {
            RescueBlockInfo rbi = this._rescueBlockStack.peek();
            s2.addInstr(new PutGlobalVarInstr("$!", rbi.savedExceptionVariable));
            s2.addInstr(new CopyInstr(rv, x));
            if (this._ensureBlockStack.empty()) {
                s2.addInstr(new JumpInstr(endLabel));
            } else {
                EnsureBlockInfo ebi = this._ensureBlockStack.peek();
                if (rbi.rescueNode == ebi.matchingRescueNode) {
                    s2.addInstr(new SetReturnAddressInstr(ebi.returnAddr, endLabel));
                    s2.addInstr(new JumpInstr(ebi.start));
                } else {
                    s2.addInstr(new JumpInstr(endLabel));
                }
            }
        }
    }

    public Operand buildRetry(Node node, IRScope s2) {
        if (this._rescueBlockStack.empty()) {
            s2.addInstr(new ThrowExceptionInstr(IRException.RETRY_LocalJumpError));
        } else {
            s2.addInstr(new ThreadPollInstr(true));
            RescueBlockInfo rbi = this._rescueBlockStack.peek();
            s2.addInstr(new PutGlobalVarInstr("$!", rbi.savedExceptionVariable));
            s2.addInstr(new JumpInstr(rbi.entryLabel));
            s2.setHasLoopsFlag(true);
        }
        return this.manager.getNil();
    }

    public Operand buildReturn(ReturnNode returnNode, IRScope s2) {
        Nil retVal;
        Operand operand = retVal = returnNode.getValueNode() == null ? this.manager.getNil() : this.build(returnNode.getValueNode(), s2);
        if (!this._ensureBlockStack.empty()) {
            EnsureBlockInfo.emitJumpChain(s2, this._ensureBlockStack, null);
        } else if (!this._rescueBlockStack.empty()) {
            s2.addInstr(new PutGlobalVarInstr("$!", this.manager.getNil()));
        }
        if (s2 instanceof IRClosure) {
            s2.addInstr(new NonlocalReturnInstr(retVal, s2.getNearestMethod()));
        } else if (s2.isModuleBody()) {
            IRMethod sm = s2.getNearestMethod();
            if (sm == null) {
                s2.addInstr(new ThrowExceptionInstr(IRException.RETURN_LocalJumpError));
            } else {
                s2.addInstr(new NonlocalReturnInstr(retVal, sm));
            }
        } else {
            s2.addInstr(new ReturnInstr(retVal));
        }
        return UnexecutableNil.U_NIL;
    }

    public IREvalScript buildEvalRoot(StaticScope staticScope, IRScope containingScope, String file2, int lineNumber, RootNode rootNode) {
        IREvalScript script = new IREvalScript(this.manager, containingScope, file2, lineNumber, staticScope);
        script.addInstr(new LineNumberInstr(script, lineNumber));
        script.addInstr(new CopyInstr(script.getCurrentScopeVariable(), new CurrentScope(script)));
        script.addInstr(new CopyInstr(script.getCurrentModuleVariable(), new ScopeModule(script)));
        Nil rval = rootNode.getBodyNode() == null ? this.manager.getNil() : this.build(rootNode.getBodyNode(), script);
        script.addInstr(new ReturnInstr(rval));
        return script;
    }

    public IRScope buildRoot(RootNode rootNode) {
        String file2 = rootNode.getPosition().getFile();
        StaticScope staticScope = rootNode.getStaticScope();
        IRScriptBody script = new IRScriptBody(this.manager, "__file__", file2, staticScope);
        script.addInstr(new ReceiveSelfInstr(script.getSelf()));
        script.addInstr(new CopyInstr(script.getCurrentScopeVariable(), new CurrentScope(script)));
        script.addInstr(new CopyInstr(script.getCurrentModuleVariable(), new ScopeModule(script)));
        script.addInstr(new ReturnInstr(this.build(rootNode.getBodyNode(), script)));
        return script;
    }

    public Operand buildSelf(Node node, IRScope s2) {
        return this.getSelf(s2);
    }

    public Operand buildSplat(SplatNode splatNode, IRScope s2) {
        return new Splat(this.build(splatNode.getValue(), s2));
    }

    public Operand buildStr(StrNode strNode, IRScope s2) {
        return this.copyAndReturnValue(s2, new StringLiteral(strNode.getValue()));
    }

    private Operand buildSuperInstr(IRScope s2, Operand block, Operand[] args2) {
        CallInstr superInstr;
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        if (s2 instanceof IRMethod && s2.getLexicalParent() instanceof IRClassBody) {
            IRMethod m = (IRMethod)s2;
            superInstr = m.isInstanceMethod ? new InstanceSuperInstr(ret, s2.getCurrentModuleVariable(), new MethAddr(s2.getName()), args2, block) : new ClassSuperInstr(ret, s2.getCurrentModuleVariable(), new MethAddr(s2.getName()), args2, block);
        } else {
            superInstr = new UnresolvedSuperInstr(ret, (Operand)this.getSelf(s2), args2, block);
        }
        this.receiveBreakException(s2, block, superInstr);
        return ret;
    }

    public Operand buildSuper(SuperNode superNode, IRScope s2) {
        if (s2.isModuleBody()) {
            return this.buildSuperInScriptBody(s2);
        }
        List<Operand> args2 = this.setupCallArgs(superNode.getArgsNode(), s2);
        Operand block = this.setupCallClosure(superNode.getIterNode(), s2);
        if (block == null) {
            block = s2.getImplicitBlockArg();
        }
        return this.buildSuperInstr(s2, block, args2.toArray(new Operand[args2.size()]));
    }

    private Operand buildSuperInScriptBody(IRScope s2) {
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new UnresolvedSuperInstr(ret, (Operand)this.getSelf(s2), NO_ARGS, null));
        return ret;
    }

    public Operand buildSValue(SValueNode node, IRScope s2) {
        return this.copyAndReturnValue(s2, new SValue(this.build(node.getValue(), s2)));
    }

    public Operand buildSymbol(SymbolNode node, IRScope s2) {
        return new Symbol(node.getName());
    }

    public Operand buildToAry(ToAryNode node, IRScope s2) {
        Operand array = this.build(node.getValue(), s2);
        TemporaryVariable result2 = s2.getNewTemporaryVariable();
        s2.addInstr(new ToAryInstr(result2, array, this.manager.getFalse()));
        return result2;
    }

    public Operand buildTrue(Node node, IRScope s2) {
        return this.manager.getTrue();
    }

    public Operand buildUndef(Node node, IRScope s2) {
        Operand methName = this.build(((UndefNode)node).getName(), s2);
        TemporaryVariable result2 = s2.getNewTemporaryVariable();
        s2.addInstr(new UndefMethodInstr(result2, methName));
        return result2;
    }

    private Operand buildConditionalLoop(IRScope s2, Node conditionNode, Node bodyNode, boolean isWhile, boolean isLoopHeadCondition) {
        Operand cv;
        if (isLoopHeadCondition && (isWhile && conditionNode.getNodeType().alwaysFalse() || !isWhile && conditionNode.getNodeType().alwaysTrue())) {
            this.build(conditionNode, s2);
            return this.manager.getNil();
        }
        IRLoop loop2 = new IRLoop(s2, this.getCurrentLoop());
        Variable loopResult = loop2.loopResult;
        Label setupResultLabel = s2.getNewLabel();
        this.loopStack.push(loop2);
        s2.addInstr(new LabelInstr(loop2.loopStartLabel));
        if (isLoopHeadCondition) {
            cv = this.build(conditionNode, s2);
            s2.addInstr(BEQInstr.create(cv, isWhile ? this.manager.getFalse() : this.manager.getTrue(), setupResultLabel));
        }
        s2.addInstr(new LabelInstr(loop2.iterStartLabel));
        s2.addInstr(new ThreadPollInstr(true));
        if (bodyNode != null) {
            this.build(bodyNode, s2);
        }
        s2.addInstr(new LabelInstr(loop2.iterEndLabel));
        if (isLoopHeadCondition) {
            s2.addInstr(new JumpInstr(loop2.loopStartLabel));
        } else {
            cv = this.build(conditionNode, s2);
            s2.addInstr(BEQInstr.create(cv, isWhile ? this.manager.getTrue() : this.manager.getFalse(), loop2.iterStartLabel));
        }
        s2.addInstr(new LabelInstr(setupResultLabel));
        s2.addInstr(new CopyInstr(loopResult, this.manager.getNil()));
        s2.addInstr(new LabelInstr(loop2.loopEndLabel));
        this.loopStack.pop();
        return loopResult;
    }

    public Operand buildUntil(UntilNode untilNode, IRScope s2) {
        return this.buildConditionalLoop(s2, untilNode.getConditionNode(), untilNode.getBodyNode(), false, untilNode.evaluateAtStart());
    }

    public Operand buildVAlias(Node node, IRScope s2) {
        VAliasNode valiasNode = (VAliasNode)node;
        s2.addInstr(new GVarAliasInstr(new StringLiteral(valiasNode.getNewName()), new StringLiteral(valiasNode.getOldName())));
        return this.manager.getNil();
    }

    public Operand buildVCall(VCallNode node, IRScope s2) {
        TemporaryVariable callResult = s2.getNewTemporaryVariable();
        CallInstr callInstr = CallInstr.create(CallType.VARIABLE, callResult, new MethAddr(node.getName()), this.getSelf(s2), NO_ARGS, null);
        s2.addInstr(callInstr);
        return callResult;
    }

    public Operand buildWhile(WhileNode whileNode, IRScope s2) {
        return this.buildConditionalLoop(s2, whileNode.getConditionNode(), whileNode.getBodyNode(), true, whileNode.evaluateAtStart());
    }

    public Operand buildXStr(XStrNode node, IRScope s2) {
        return this.copyAndReturnValue(s2, new BacktickString(new StringLiteral(node.getValue())));
    }

    public Operand buildYield(YieldNode node, IRScope s2) {
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        s2.addInstr(new YieldInstr(ret, s2.getImplicitBlockArg(), this.build(node.getArgsNode(), s2), node.getExpandArguments()));
        return ret;
    }

    public Operand buildZArray(Node node, IRScope s2) {
        return this.copyAndReturnValue(s2, new Array());
    }

    public Operand buildZSuper(ZSuperNode zsuperNode, IRScope s2) {
        if (s2.isModuleBody()) {
            return this.buildSuperInScriptBody(s2);
        }
        Operand block = this.setupCallClosure(zsuperNode.getIterNode(), s2);
        if (block == null) {
            block = s2.getImplicitBlockArg();
        }
        if (s2 instanceof IRMethod) {
            Operand[] args2 = ((IRMethod)s2).getCallArgs();
            return this.buildSuperInstr(s2, block, args2);
        }
        TemporaryVariable ret = s2.getNewTemporaryVariable();
        this.receiveBreakException(s2, block, new ZSuperInstr(ret, this.getSelf(s2), block));
        return ret;
    }

    static interface CodeBlock {
        public Operand run(Object[] var1);
    }

    private static class RescueBlockInfo {
        RescueNode rescueNode;
        Label entryLabel;
        Variable savedExceptionVariable;
        IRLoop innermostLoop;

        public RescueBlockInfo(RescueNode n, Label l, Variable v, IRLoop loop2) {
            this.rescueNode = n;
            this.entryLabel = l;
            this.savedExceptionVariable = v;
            this.innermostLoop = loop2;
        }

        public void restoreException(IRScope s2, IRLoop currLoop) {
            if (currLoop == this.innermostLoop) {
                s2.addInstr(new PutGlobalVarInstr("$!", this.savedExceptionVariable));
            }
        }
    }

    private static class EnsureBlockInfo {
        Label regionStart;
        Label start;
        Label end;
        Label dummyRescueBlockLabel;
        Variable returnAddr;
        Variable savedGlobalException;
        IRLoop innermostLoop;
        RescueNode matchingRescueNode;

        public EnsureBlockInfo(IRScope s2, RescueNode n, IRLoop l) {
            this.regionStart = s2.getNewLabel();
            this.start = s2.getNewLabel();
            this.end = s2.getNewLabel();
            this.returnAddr = s2.getNewTemporaryVariable();
            this.dummyRescueBlockLabel = s2.getNewLabel();
            this.savedGlobalException = null;
            this.innermostLoop = l;
            this.matchingRescueNode = n;
        }

        public static void emitJumpChain(IRScope s2, Stack<EnsureBlockInfo> ebStack, IRLoop loop2) {
            int n = ebStack.size();
            EnsureBlockInfo[] ebArray = ebStack.toArray(new EnsureBlockInfo[n]);
            for (int i2 = n - 1; i2 >= 0; --i2) {
                EnsureBlockInfo ebi = ebArray[i2];
                if (ebi.innermostLoop != loop2) break;
                Label retLabel = s2.getNewLabel();
                if (ebi.savedGlobalException != null) {
                    s2.addInstr(new PutGlobalVarInstr("$!", ebi.savedGlobalException));
                }
                s2.addInstr(new SetReturnAddressInstr(ebi.returnAddr, retLabel));
                s2.addInstr(new JumpInstr(ebi.start));
                s2.addInstr(new LabelInstr(retLabel));
            }
        }
    }
}

