/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.net.BindException;
import java.net.ConnectException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import jnr.constants.Constant;
import jnr.constants.platform.AddressFamily;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyIPSocket;
import org.jruby.ext.socket.SocketUtils;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ModeFlags;

public class RubyTCPSocket
extends RubyIPSocket {
    private static ObjectAllocator TCPSOCKET_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyTCPSocket(runtime, klass);
        }
    };

    static void createTCPSocket(Ruby runtime) {
        RubyClass rb_cTCPSocket = runtime.defineClass("TCPSocket", runtime.getClass("IPSocket"), TCPSOCKET_ALLOCATOR);
        rb_cTCPSocket.defineAnnotatedMethods(RubyTCPSocket.class);
        runtime.getObject().setConstant("TCPsocket", rb_cTCPSocket);
    }

    public RubyTCPSocket(Ruby runtime, RubyClass type2) {
        super(runtime, type2);
    }

    @JRubyMethod(required=2, optional=2, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        Ruby runtime = context.runtime;
        IRubyObject _host = args2[0];
        IRubyObject _port = args2[1];
        String remoteHost = _host.isNil() ? "localhost" : _host.convertToString().toString();
        int remotePort = SocketUtils.getPortFrom(context, _port);
        String localHost = args2.length >= 3 && !args2[2].isNil() ? args2[2].convertToString().toString() : null;
        int localPort = args2.length == 4 && !args2[3].isNil() ? SocketUtils.getPortFrom(context, args2[3]) : 0;
        boolean success2 = false;
        SocketChannel channel = null;
        try {
            channel = SocketChannel.open();
            Socket socket2 = channel.socket();
            if (localHost != null) {
                socket2.bind(new InetSocketAddress(InetAddress.getByName(localHost), localPort));
            }
            try {
                channel.configureBlocking(false);
                channel.connect(new InetSocketAddress(InetAddress.getByName(remoteHost), remotePort));
                context.getThread().select(channel, this, 8);
                channel.finishConnect();
                channel.configureBlocking(true);
                this.initSocket(runtime, new ChannelDescriptor((Channel)channel, RubyTCPSocket.newModeFlags(runtime, ModeFlags.RDWR)));
                success2 = true;
            }
            catch (NoRouteToHostException nrthe) {
                throw runtime.newErrnoEHOSTUNREACHError("SocketChannel.connect");
            }
            catch (ConnectException e) {
                throw runtime.newErrnoECONNREFUSEDError();
            }
            catch (UnknownHostException e) {
                throw SocketUtils.sockerr(runtime, "initialize: name or service not known");
            }
        }
        catch (ClosedChannelException cce) {
            throw runtime.newErrnoECONNREFUSEDError();
        }
        catch (BindException e) {
            throw runtime.newErrnoEADDRFromBindException(e);
        }
        catch (IOException e) {
            throw SocketUtils.sockerr(runtime, e.getLocalizedMessage());
        }
        catch (IllegalArgumentException iae) {
            throw SocketUtils.sockerr(runtime, iae.getMessage());
        }
        finally {
            if (!success2 && channel != null) {
                try {
                    channel.close();
                }
                catch (IOException ioe) {}
            }
        }
        return context.nil;
    }

    @JRubyMethod(meta=true)
    public static IRubyObject gethostbyname(ThreadContext context, IRubyObject recv2, IRubyObject hostname) {
        Ruby runtime = context.runtime;
        IRubyObject[] ret = new IRubyObject[4];
        String hostString = hostname.convertToString().toString();
        try {
            InetAddress addr2 = InetAddress.getByName(hostString);
            ret[0] = runtime.newString(RubyTCPSocket.do_not_reverse_lookup(context, recv2).isTrue() ? addr2.getHostAddress() : addr2.getCanonicalHostName());
            ret[1] = runtime.newArray();
            if (addr2 instanceof Inet4Address) {
                ret[2] = runtime.newFixnum((Constant)AddressFamily.AF_INET);
            } else if (addr2 instanceof Inet6Address) {
                ret[2] = runtime.newFixnum((Constant)AddressFamily.AF_INET6);
            }
            ret[3] = runtime.newString(addr2.getHostAddress());
            return runtime.newArrayNoCopy(ret);
        }
        catch (UnknownHostException e) {
            throw SocketUtils.sockerr(runtime, "gethostbyname: name or service not known");
        }
    }

    @Deprecated
    public static IRubyObject open(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return RubyTCPSocket.open(recv2.getRuntime().getCurrentContext(), recv2, args2, block);
    }

    @Deprecated
    public static IRubyObject gethostbyname(IRubyObject recv2, IRubyObject hostname) {
        return RubyTCPSocket.gethostbyname(recv2.getRuntime().getCurrentContext(), recv2, hostname);
    }
}

