/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.jcodings.Encoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.RubyObject;
import org.jruby.RubyProc;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Binding;
import org.jruby.runtime.Block;
import org.jruby.runtime.ContextAwareBlockBody;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.FunctionalCachingCallSite;
import org.jruby.runtime.encoding.MarshalEncoding;
import org.jruby.runtime.marshal.UnmarshalStream;
import org.jruby.util.ByteList;
import org.jruby.util.PerlHash;
import org.jruby.util.SipHashInline;
import org.jruby.util.StringSupport;

@JRubyClass(name={"Symbol"})
public class RubySymbol
extends RubyObject
implements MarshalEncoding {
    public static final long symbolHashSeedK0 = 5238926673095087190L;
    private final String symbol;
    private final int id;
    private final ByteList symbolBytes;
    private final int hashCode;

    private RubySymbol(Ruby runtime, String internedSymbol, ByteList symbolBytes) {
        super(runtime, runtime.getSymbol(), false);
        if (!runtime.is1_9()) {
            int length2 = symbolBytes.getBegin() + symbolBytes.getRealSize();
            for (int i2 = symbolBytes.getBegin(); i2 < length2; ++i2) {
                if (symbolBytes.getUnsafeBytes()[i2] != 0) continue;
                throw runtime.newSyntaxError("symbol cannot contain '\\0'");
            }
        }
        this.symbol = internedSymbol;
        this.symbolBytes = symbolBytes;
        this.id = runtime.allocSymbolId();
        long hash2 = runtime.isSiphashEnabled() ? SipHashInline.hash24(5238926673095087190L, 0L, symbolBytes.getUnsafeBytes(), symbolBytes.getBegin(), symbolBytes.getRealSize()) : PerlHash.hash(5238926673095087190L, symbolBytes.getUnsafeBytes(), symbolBytes.getBegin(), symbolBytes.getRealSize());
        this.hashCode = (int)hash2;
    }

    private RubySymbol(Ruby runtime, String internedSymbol) {
        this(runtime, internedSymbol, RubySymbol.symbolBytesFromString(runtime, internedSymbol));
    }

    public static RubyClass createSymbolClass(Ruby runtime) {
        RubyClass symbolClass = runtime.defineClass("Symbol", runtime.getObject(), ObjectAllocator.NOT_ALLOCATABLE_ALLOCATOR);
        runtime.setSymbol(symbolClass);
        RubyClass symbolMetaClass = symbolClass.getMetaClass();
        symbolClass.index = 8;
        symbolClass.setReifiedClass(RubySymbol.class);
        symbolClass.kindOf = new RubyModule.JavaClassKindOf(RubySymbol.class);
        symbolClass.defineAnnotatedMethods(RubySymbol.class);
        symbolMetaClass.undefineMethod("new");
        if (runtime.is1_9()) {
            symbolClass.includeModule(runtime.getComparable());
        }
        return symbolClass;
    }

    @Override
    public int getNativeTypeIndex() {
        return 8;
    }

    @Override
    public String asJavaString() {
        return this.symbol;
    }

    @Override
    public String toString() {
        return this.symbol;
    }

    final ByteList getBytes() {
        return this.symbolBytes;
    }

    public void associateEncoding(Encoding encoding2) {
        this.symbolBytes.setEncoding(encoding2);
    }

    @Override
    public final boolean eql(IRubyObject other) {
        return other == this;
    }

    @Override
    public boolean isImmediate() {
        return true;
    }

    @Override
    public RubyClass getSingletonClass() {
        throw this.getRuntime().newTypeError("can't define singleton");
    }

    public static RubySymbol getSymbolLong(Ruby runtime, long id2) {
        return runtime.getSymbolTable().lookup(id2);
    }

    public static RubySymbol newSymbol(Ruby runtime, IRubyObject name2) {
        if (!(name2 instanceof RubyString)) {
            return RubySymbol.newSymbol(runtime, name2.asJavaString());
        }
        return runtime.getSymbolTable().getSymbol(((RubyString)name2).getByteList());
    }

    public static RubySymbol newSymbol(Ruby runtime, String name2) {
        return runtime.getSymbolTable().getSymbol(name2);
    }

    @Deprecated
    public RubyFixnum to_i() {
        return this.to_i(this.getRuntime());
    }

    @JRubyMethod(name={"to_i"}, compat=CompatVersion.RUBY1_8)
    public RubyFixnum to_i(ThreadContext context) {
        return this.to_i(context.runtime);
    }

    private final RubyFixnum to_i(Ruby runtime) {
        return runtime.newFixnum(this.id);
    }

    @Deprecated
    public RubyFixnum to_int() {
        return this.to_int(this.getRuntime());
    }

    @JRubyMethod(name={"to_int"}, compat=CompatVersion.RUBY1_8)
    public RubyFixnum to_int(ThreadContext context) {
        return this.to_int(context.runtime);
    }

    private final RubyFixnum to_int(Ruby runtime) {
        if (runtime.isVerbose()) {
            runtime.getWarnings().warn(IRubyWarnings.ID.SYMBOL_AS_INTEGER, "treating Symbol as an integer");
        }
        return this.to_i(runtime);
    }

    @Override
    @Deprecated
    public IRubyObject inspect() {
        return this.inspect(this.getRuntime());
    }

    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject inspect(ThreadContext context) {
        return this.inspect(context.runtime);
    }

    private final IRubyObject inspect(Ruby runtime) {
        ByteList bytes2 = RubySymbol.isSymbolName(this.symbol) ? this.symbolBytes : ((RubyString)RubyString.newString(runtime, this.symbolBytes).dump()).getByteList();
        ByteList result2 = new ByteList(bytes2.getRealSize() + 1);
        result2.append((byte)58).append(bytes2);
        return RubyString.newString(runtime, result2);
    }

    @Deprecated
    public IRubyObject inspect19() {
        return this.inspect19(this.getRuntime());
    }

    @JRubyMethod(name={"inspect"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject inspect19(ThreadContext context) {
        return this.inspect19(context.runtime);
    }

    private final IRubyObject inspect19(Ruby runtime) {
        ByteList result2 = new ByteList(this.symbolBytes.getRealSize() + 1);
        result2.setEncoding(this.symbolBytes.getEncoding());
        result2.append((byte)58);
        result2.append(this.symbolBytes);
        RubyString str = RubyString.newString(runtime, result2);
        if (this.isPrintable() && RubySymbol.isSymbolName19(this.symbol)) {
            return str;
        }
        str = (RubyString)str.inspect19();
        ByteList bytes2 = str.getByteList();
        bytes2.set(0, 58);
        bytes2.set(1, 34);
        return str;
    }

    @Override
    public IRubyObject to_s() {
        return this.to_s(this.getRuntime());
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        return this.to_s(context.runtime);
    }

    private final IRubyObject to_s(Ruby runtime) {
        return RubyString.newStringShared(runtime, this.symbolBytes);
    }

    public IRubyObject id2name() {
        return this.to_s(this.getRuntime());
    }

    @JRubyMethod(name={"id2name"})
    public IRubyObject id2name(ThreadContext context) {
        return this.to_s(context);
    }

    @Override
    @JRubyMethod(name={"==="}, required=1)
    public IRubyObject op_eqq(ThreadContext context, IRubyObject other) {
        return super.op_equal(context, other);
    }

    @Override
    @Deprecated
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.hashCode());
    }

    @JRubyMethod(name={"hash"})
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCode());
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    public int getId() {
        return this.id;
    }

    @Override
    public boolean equals(Object other) {
        return other == this;
    }

    @JRubyMethod(name={"to_sym"})
    public IRubyObject to_sym() {
        return this;
    }

    @JRubyMethod(name={"intern"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_sym19() {
        return this;
    }

    @Override
    public IRubyObject taint(ThreadContext context) {
        return this;
    }

    private RubyString newShared(Ruby runtime) {
        return RubyString.newStringShared(runtime, this.symbolBytes);
    }

    private RubyString rubyStringFromString(Ruby runtime) {
        return RubyString.newString(runtime, this.symbol);
    }

    @JRubyMethod(name={"succ", "next"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject succ(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubySymbol.newSymbol(runtime, this.newShared(runtime).succ19(context).toString());
    }

    @Override
    @JRubyMethod(name={"<=>"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        return !(other instanceof RubySymbol) ? runtime.getNil() : this.newShared(runtime).op_cmp19(context, ((RubySymbol)other).newShared(runtime));
    }

    @JRubyMethod(name={"casecmp"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject casecmp(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        return !(other instanceof RubySymbol) ? runtime.getNil() : this.newShared(runtime).casecmp19(context, ((RubySymbol)other).newShared(runtime));
    }

    @Override
    @JRubyMethod(name={"=~", "match"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_match19(ThreadContext context, IRubyObject other) {
        return this.newShared(context.runtime).op_match19(context, other);
    }

    @JRubyMethod(name={"[]", "slice"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg2) {
        return this.newShared(context.runtime).op_aref19(context, arg2);
    }

    @JRubyMethod(name={"[]", "slice"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_aref(ThreadContext context, IRubyObject arg1, IRubyObject arg2) {
        return this.newShared(context.runtime).op_aref19(context, arg1, arg2);
    }

    @JRubyMethod(name={"length", "size"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject length() {
        return this.newShared(this.getRuntime()).length19();
    }

    @JRubyMethod(name={"empty?"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject empty_p(ThreadContext context) {
        return this.newShared(context.runtime).empty_p(context);
    }

    @JRubyMethod(name={"upcase"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject upcase(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubySymbol.newSymbol(runtime, this.rubyStringFromString(runtime).upcase19(context).toString());
    }

    @JRubyMethod(name={"downcase"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject downcase(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubySymbol.newSymbol(runtime, this.rubyStringFromString(runtime).downcase19(context).toString());
    }

    @JRubyMethod(name={"capitalize"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject capitalize(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubySymbol.newSymbol(runtime, this.rubyStringFromString(runtime).capitalize19(context).toString());
    }

    @JRubyMethod(name={"swapcase"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject swapcase(ThreadContext context) {
        Ruby runtime = context.runtime;
        return RubySymbol.newSymbol(runtime, this.rubyStringFromString(runtime).swapcase19(context).toString());
    }

    @JRubyMethod(name={"encoding"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject encoding(ThreadContext context) {
        return context.runtime.getEncodingService().getEncoding(this.symbolBytes.getEncoding());
    }

    @JRubyMethod
    public IRubyObject to_proc(ThreadContext context) {
        StaticScope scope = context.runtime.getStaticScopeFactory().getDummyScope();
        final FunctionalCachingCallSite site = new FunctionalCachingCallSite(this.symbol);
        ContextAwareBlockBody body = new ContextAwareBlockBody(scope, Arity.OPTIONAL, 3){

            private IRubyObject yieldInner(ThreadContext context, RubyArray array, Block block) {
                if (array.isEmpty()) {
                    throw context.runtime.newArgumentError("no receiver given");
                }
                IRubyObject self2 = array.shift(context);
                return site.call(context, self2, self2, array.toJavaArray(), block);
            }

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self2, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2, Block block) {
                RubyArray array = aValue && value2 instanceof RubyArray ? (RubyArray)value2 : ArgsUtil.convertToRubyArray(context.runtime, value2, false);
                return this.yieldInner(context, array, block);
            }

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2, Block block) {
                return this.yieldInner(context, ArgsUtil.convertToRubyArray(context.runtime, value2, false), block);
            }

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject value2, Binding binding2, Block.Type type2) {
                return this.yieldInner(context, ArgsUtil.convertToRubyArray(context.runtime, value2, false), Block.NULL_BLOCK);
            }

            @Override
            public IRubyObject yield(ThreadContext context, IRubyObject value2, IRubyObject self2, RubyModule klass, boolean aValue, Binding binding2, Block.Type type2) {
                RubyArray array = aValue && value2 instanceof RubyArray ? (RubyArray)value2 : ArgsUtil.convertToRubyArray(context.runtime, value2, false);
                return this.yieldInner(context, array, Block.NULL_BLOCK);
            }

            @Override
            public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, Binding binding2, Block.Type type2) {
                return site.call(context, arg0, arg0);
            }

            @Override
            public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, Binding binding2, Block.Type type2) {
                return site.call(context, arg0, arg0, arg1);
            }

            @Override
            public IRubyObject yieldSpecific(ThreadContext context, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Binding binding2, Block.Type type2) {
                return site.call(context, arg0, arg0, arg1, arg2);
            }

            @Override
            public String getFile() {
                return RubySymbol.this.symbol;
            }

            @Override
            public int getLine() {
                return -1;
            }
        };
        return RubyProc.newProc(context.runtime, new Block(body, context.currentBinding()), Block.Type.PROC);
    }

    private static boolean isIdentStart(char c) {
        return c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentChar(char c) {
        return c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c >= 'A' && c <= 'Z' || c == '_';
    }

    private static boolean isIdentifier(String s2) {
        if (s2 == null || s2.length() <= 0 || !RubySymbol.isIdentStart(s2.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < s2.length(); ++i2) {
            if (RubySymbol.isIdentChar(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static boolean isSpecialGlobalName(String s2) {
        if (s2 == null || s2.length() <= 0) {
            return false;
        }
        int length2 = s2.length();
        switch (s2.charAt(0)) {
            case '!': 
            case '\"': 
            case '$': 
            case '&': 
            case '\'': 
            case '*': 
            case '+': 
            case ',': 
            case '.': 
            case '/': 
            case '0': 
            case ':': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '?': 
            case '@': 
            case '\\': 
            case '`': 
            case '~': {
                return length2 == 1;
            }
            case '-': {
                return length2 == 1 || length2 == 2 && RubySymbol.isIdentChar(s2.charAt(1));
            }
        }
        for (int i2 = 0; i2 < length2; ++i2) {
            if (Character.isDigit(s2.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private boolean isPrintable() {
        int c;
        int p2;
        Ruby runtime = this.getRuntime();
        int end2 = p2 + this.symbolBytes.getRealSize();
        byte[] bytes2 = this.symbolBytes.getUnsafeBytes();
        Encoding enc = this.symbolBytes.getEncoding();
        for (p2 = this.symbolBytes.getBegin(); p2 < end2; p2 += StringSupport.codeLength(runtime, enc, c)) {
            c = StringSupport.codePoint(runtime, enc, bytes2, p2, end2);
            if (enc.isPrint(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isSymbolName19(String s2) {
        if (s2 == null || s2.length() < 1) {
            return false;
        }
        int length2 = s2.length();
        char c = s2.charAt(0);
        return RubySymbol.isSymbolNameCommon(s2, c, length2) || c == '!' && (length2 == 1 || length2 == 2 && (s2.charAt(1) == '~' || s2.charAt(1) == '=')) || RubySymbol.isSymbolLocal(s2, c, length2);
    }

    private static boolean isSymbolName(String s2) {
        if (s2 == null || s2.length() < 1) {
            return false;
        }
        int length2 = s2.length();
        char c = s2.charAt(0);
        return RubySymbol.isSymbolNameCommon(s2, c, length2) || RubySymbol.isSymbolLocal(s2, c, length2);
    }

    private static boolean isSymbolNameCommon(String s2, char c, int length2) {
        switch (c) {
            case '$': {
                if (length2 > 1 && RubySymbol.isSpecialGlobalName(s2.substring(1))) {
                    return true;
                }
                return RubySymbol.isIdentifier(s2.substring(1));
            }
            case '@': {
                int offset2 = 1;
                if (length2 >= 2 && s2.charAt(1) == '@') {
                    ++offset2;
                }
                return RubySymbol.isIdentifier(s2.substring(offset2));
            }
            case '<': {
                return length2 == 1 || length2 == 2 && (s2.equals("<<") || s2.equals("<=")) || length2 == 3 && s2.equals("<=>");
            }
            case '>': {
                return length2 == 1 || length2 == 2 && (s2.equals(">>") || s2.equals(">="));
            }
            case '=': {
                return length2 == 2 && (s2.equals("==") || s2.equals("=~")) || length2 == 3 && s2.equals("===");
            }
            case '*': {
                return length2 == 1 || length2 == 2 && s2.equals("**");
            }
            case '+': {
                return length2 == 1 || length2 == 2 && s2.equals("+@");
            }
            case '-': {
                return length2 == 1 || length2 == 2 && s2.equals("-@");
            }
            case '%': 
            case '&': 
            case '/': 
            case '^': 
            case '`': 
            case '|': 
            case '~': {
                return length2 == 1;
            }
            case '[': {
                return s2.equals("[]") || s2.equals("[]=");
            }
        }
        return false;
    }

    private static boolean isSymbolLocal(String s2, char c, int length2) {
        char d;
        int last2;
        if (!RubySymbol.isIdentStart(c)) {
            return false;
        }
        boolean localID = c >= 'a' && c <= 'z';
        for (last2 = 1; last2 < length2 && RubySymbol.isIdentChar(d = s2.charAt(last2)); ++last2) {
        }
        if (last2 == length2) {
            return true;
        }
        if (localID && last2 == length2 - 1) {
            d = s2.charAt(last2);
            return d == '!' || d == '?' || d == '=';
        }
        return false;
    }

    @JRubyMethod(name={"all_symbols"}, meta=true)
    public static IRubyObject all_symbols(ThreadContext context, IRubyObject recv2) {
        return context.runtime.getSymbolTable().all_symbols();
    }

    @Deprecated
    public static IRubyObject all_symbols(IRubyObject recv2) {
        return recv2.getRuntime().getSymbolTable().all_symbols();
    }

    public static RubySymbol unmarshalFrom(UnmarshalStream input) throws IOException {
        RubySymbol result2 = RubySymbol.newSymbol(input.getRuntime(), RubyString.byteListToString(input.unmarshalString()));
        input.registerLinkTarget(result2);
        return result2;
    }

    @Override
    public Object toJava(Class target) {
        if (target == String.class || target == CharSequence.class) {
            return this.symbol;
        }
        return super.toJava(target);
    }

    private static ByteList symbolBytesFromString(Ruby runtime, String internedSymbol) {
        if (runtime.is1_9()) {
            return new ByteList(ByteList.plain((CharSequence)internedSymbol), (Encoding)USASCIIEncoding.INSTANCE, false);
        }
        return ByteList.create((CharSequence)internedSymbol);
    }

    @Override
    public boolean shouldMarshalEncoding() {
        return this.getMarshalEncoding() != USASCIIEncoding.INSTANCE;
    }

    @Override
    public Encoding getMarshalEncoding() {
        return this.symbolBytes.getEncoding();
    }

    public static String objectToSymbolString(IRubyObject object) {
        if (object instanceof RubySymbol) {
            return ((RubySymbol)object).toString();
        }
        if (object instanceof RubyString) {
            return ((RubyString)object).getByteList().toString();
        }
        return object.convertToString().getByteList().toString();
    }

    public static final class SymbolTable {
        static final int DEFAULT_INITIAL_CAPACITY = 2048;
        static final int MAXIMUM_CAPACITY = 0x40000000;
        static final float DEFAULT_LOAD_FACTOR = 0.75f;
        private final ReentrantLock tableLock = new ReentrantLock();
        private volatile SymbolEntry[] symbolTable;
        private final ConcurrentHashMap<ByteList, RubySymbol> bytelistTable = new ConcurrentHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors());
        private int size;
        private int threshold;
        private final float loadFactor;
        private final Ruby runtime;

        public SymbolTable(Ruby runtime) {
            this.runtime = runtime;
            this.loadFactor = 0.75f;
            this.threshold = 1536;
            this.symbolTable = new SymbolEntry[2048];
        }

        public RubySymbol getSymbol(String name2) {
            int hash2 = name2.hashCode();
            SymbolEntry[] table = this.symbolTable;
            SymbolEntry e = SymbolTable.getEntryFromTable(table, hash2);
            while (e != null) {
                if (SymbolTable.isSymbolMatch(name2, hash2, e)) {
                    return e.symbol;
                }
                e = e.next;
            }
            return this.createSymbol(name2, RubySymbol.symbolBytesFromString(this.runtime, name2), hash2, table);
        }

        public RubySymbol getSymbol(ByteList bytes2) {
            RubySymbol symbol = this.bytelistTable.get(bytes2);
            if (symbol != null) {
                return symbol;
            }
            String name2 = bytes2.toString();
            int hash2 = name2.hashCode();
            SymbolEntry[] table = this.symbolTable;
            SymbolEntry e = SymbolTable.getEntryFromTable(table, hash2);
            while (e != null) {
                if (SymbolTable.isSymbolMatch(name2, hash2, e)) {
                    symbol = e.symbol;
                    break;
                }
                e = e.next;
            }
            if (symbol == null) {
                symbol = this.createSymbol(name2, bytes2, hash2, table);
            }
            this.bytelistTable.put(bytes2, symbol);
            return symbol;
        }

        public RubySymbol fastGetSymbol(String internedName) {
            SymbolEntry[] table = this.symbolTable;
            SymbolEntry e = SymbolTable.getEntryFromTable(this.symbolTable, internedName.hashCode());
            while (e != null) {
                if (SymbolTable.isSymbolMatch(internedName, e)) {
                    return e.symbol;
                }
                e = e.next;
            }
            return this.fastCreateSymbol(internedName, table);
        }

        private static SymbolEntry getEntryFromTable(SymbolEntry[] table, int hash2) {
            return table[hash2 & table.length - 1];
        }

        private static boolean isSymbolMatch(String name2, int hash2, SymbolEntry entry) {
            return hash2 == entry.hash && name2.equals(entry.name);
        }

        private static boolean isSymbolMatch(String internedName, SymbolEntry entry) {
            return internedName == entry.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RubySymbol createSymbol(String name2, ByteList value2, int hash2, SymbolEntry[] table) {
            ReentrantLock lock2 = this.tableLock;
            lock2.lock();
            try {
                int potentialNewSize = this.size + 1;
                table = potentialNewSize > this.threshold ? this.rehash() : this.symbolTable;
                int index2 = hash2 & table.length - 1;
                SymbolEntry e = table[index2];
                while (e != null) {
                    if (hash2 == e.hash && name2.equals(e.name)) {
                        RubySymbol rubySymbol = e.symbol;
                        return rubySymbol;
                    }
                    e = e.next;
                }
                String internedName = name2.intern();
                RubySymbol symbol = new RubySymbol(this.runtime, internedName, value2);
                table[index2] = new SymbolEntry(hash2, internedName, symbol, table[index2]);
                this.size = potentialNewSize;
                this.symbolTable = table;
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock2.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private RubySymbol fastCreateSymbol(String internedName, SymbolEntry[] table) {
            ReentrantLock lock2 = this.tableLock;
            lock2.lock();
            try {
                int potentialNewSize = this.size + 1;
                table = potentialNewSize > this.threshold ? this.rehash() : this.symbolTable;
                int hash2 = internedName.hashCode();
                int index2 = hash2 & table.length - 1;
                SymbolEntry e = table[index2];
                while (e != null) {
                    if (internedName == e.name) {
                        RubySymbol rubySymbol = e.symbol;
                        return rubySymbol;
                    }
                    e = e.next;
                }
                RubySymbol symbol = new RubySymbol(this.runtime, internedName);
                table[index2] = new SymbolEntry(hash2, internedName, symbol, table[index2]);
                this.size = potentialNewSize;
                this.symbolTable = table;
                RubySymbol rubySymbol = symbol;
                return rubySymbol;
            }
            finally {
                lock2.unlock();
            }
        }

        public RubySymbol lookup(String name2) {
            int hash2 = name2.hashCode();
            SymbolEntry[] table = this.symbolTable;
            SymbolEntry e = this.symbolTable[hash2 & table.length - 1];
            while (e != null) {
                if (hash2 == e.hash && name2.equals(e.name)) {
                    return e.symbol;
                }
                e = e.next;
            }
            return null;
        }

        public RubySymbol lookup(long id2) {
            SymbolEntry[] table = this.symbolTable;
            int i2 = table.length;
            while (--i2 >= 0) {
                SymbolEntry e = table[i2];
                while (e != null) {
                    if (id2 == (long)e.symbol.id) {
                        return e.symbol;
                    }
                    e = e.next;
                }
            }
            return null;
        }

        public RubyArray all_symbols() {
            SymbolEntry[] table = this.symbolTable;
            RubyArray array = this.runtime.newArray(this.size);
            int i2 = table.length;
            while (--i2 >= 0) {
                SymbolEntry e = table[i2];
                while (e != null) {
                    array.append(e.symbol);
                    e = e.next;
                }
            }
            return array;
        }

        @Deprecated
        public void store(RubySymbol symbol) {
            throw new UnsupportedOperationException();
        }

        private SymbolEntry[] rehash() {
            SymbolEntry[] oldTable = this.symbolTable;
            int oldCapacity = oldTable.length;
            if (oldCapacity >= 0x40000000) {
                return oldTable;
            }
            int newCapacity = oldCapacity << 1;
            SymbolEntry[] newTable = new SymbolEntry[newCapacity];
            this.threshold = (int)((float)newCapacity * this.loadFactor);
            int sizeMask = newCapacity - 1;
            int i2 = oldCapacity;
            while (--i2 >= 0) {
                int k;
                SymbolEntry e = oldTable[i2];
                if (e == null) continue;
                SymbolEntry next2 = e.next;
                int idx = e.hash & sizeMask;
                if (next2 == null) {
                    newTable[idx] = e;
                    continue;
                }
                SymbolEntry lastRun = e;
                int lastIdx = idx;
                SymbolEntry last2 = next2;
                while (last2 != null) {
                    k = last2.hash & sizeMask;
                    if (k != lastIdx) {
                        lastIdx = k;
                        lastRun = last2;
                    }
                    last2 = last2.next;
                }
                newTable[lastIdx] = lastRun;
                SymbolEntry p2 = e;
                while (p2 != lastRun) {
                    k = p2.hash & sizeMask;
                    SymbolEntry n = newTable[k];
                    newTable[k] = new SymbolEntry(p2.hash, p2.name, p2.symbol, n);
                    p2 = p2.next;
                }
            }
            this.symbolTable = newTable;
            return newTable;
        }

        static class SymbolEntry {
            final int hash;
            final String name;
            final RubySymbol symbol;
            final SymbolEntry next;

            SymbolEntry(int hash2, String name2, RubySymbol symbol, SymbolEntry next2) {
                this.hash = hash2;
                this.name = name2;
                this.symbol = symbol;
                this.next = next2;
            }
        }
    }
}

