/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ir;

import java.util.ArrayList;
import java.util.List;
import org.jruby.ir.IRManager;
import org.jruby.ir.IRMethod;
import org.jruby.ir.IRScope;
import org.jruby.ir.instructions.Instr;
import org.jruby.ir.instructions.ReceiveArgBase;
import org.jruby.ir.instructions.ReceiveExceptionInstr;
import org.jruby.ir.instructions.ReceiveRestArgInstr;
import org.jruby.ir.instructions.RuntimeHelperCall;
import org.jruby.ir.operands.ClosureLocalVariable;
import org.jruby.ir.operands.Label;
import org.jruby.ir.operands.LocalVariable;
import org.jruby.ir.operands.Operand;
import org.jruby.ir.operands.Splat;
import org.jruby.ir.operands.TemporaryClosureVariable;
import org.jruby.ir.operands.TemporaryVariable;
import org.jruby.ir.operands.Variable;
import org.jruby.ir.representations.BasicBlock;
import org.jruby.ir.representations.CFG;
import org.jruby.ir.transformations.inlining.InlinerInfo;
import org.jruby.parser.IRStaticScope;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.Arity;
import org.jruby.runtime.BlockBody;
import org.jruby.runtime.InterpretedIRBlockBody;
import org.jruby.runtime.InterpretedIRBlockBody19;

public class IRClosure
extends IRScope {
    public final Label startLabel;
    public final Label endLabel;
    public final int closureId;
    private int nestingDepth;
    private BlockBody body;
    private boolean isForLoopBody;
    private List<Operand> blockArgs;
    private String[] parameterList;
    public boolean addedGEBForUncaughtBreaks;

    private IRClosure(IRClosure c, IRScope lexicalParent) {
        super(c, lexicalParent);
        this.closureId = lexicalParent.getNextClosureId();
        this.setName("_CLOSURE_CLONE_" + this.closureId);
        this.startLabel = this.getNewLabel(this.getName() + "_START");
        this.endLabel = this.getNewLabel(this.getName() + "_END");
        this.body = c.body instanceof InterpretedIRBlockBody19 ? new InterpretedIRBlockBody19(this, c.body.arity(), c.body.getArgumentType()) : new InterpretedIRBlockBody(this, c.body.arity(), c.body.getArgumentType());
        this.addedGEBForUncaughtBreaks = false;
    }

    public IRClosure(IRManager manager, IRScope lexicalParent, boolean isForLoopBody, int lineNumber, StaticScope staticScope, Arity arity2, int argumentType, boolean is1_8) {
        this(manager, lexicalParent, lexicalParent.getFileName(), lineNumber, staticScope, isForLoopBody ? "_FOR_LOOP_" : "_CLOSURE_");
        this.isForLoopBody = isForLoopBody;
        this.blockArgs = new ArrayList<Operand>();
        if (this.getManager().isDryRun()) {
            this.body = null;
        } else {
            BlockBody blockBody = this.body = is1_8 ? new InterpretedIRBlockBody(this, arity2, argumentType) : new InterpretedIRBlockBody19(this, arity2, argumentType);
            if (staticScope != null && !isForLoopBody) {
                ((IRStaticScope)staticScope).setIRScope(this);
            }
        }
        int n = 0;
        IRScope s2 = this;
        while (s2 instanceof IRClosure) {
            if (!((IRScope)s2).isForLoopBody()) {
                ++n;
            }
            s2 = s2.getLexicalParent();
        }
        this.nestingDepth = n;
    }

    protected IRClosure(IRManager manager, IRScope lexicalParent, String fileName, int lineNumber, StaticScope staticScope, String prefix) {
        super(manager, lexicalParent, null, fileName, lineNumber, staticScope);
        this.isForLoopBody = false;
        this.startLabel = this.getNewLabel(prefix + "START");
        this.endLabel = this.getNewLabel(prefix + "END");
        this.closureId = lexicalParent.getNextClosureId();
        this.setName(prefix + this.closureId);
        this.body = null;
        this.parameterList = new String[0];
        int n = 0;
        IRScope s2 = this;
        while (s2 instanceof IRClosure) {
            if (!((IRScope)s2).isForLoopBody()) {
                ++n;
            }
            s2 = s2.getLexicalParent();
        }
        this.nestingDepth = n;
    }

    public void setParameterList(String[] parameterList) {
        this.parameterList = parameterList;
    }

    public String[] getParameterList() {
        return this.parameterList;
    }

    @Override
    public int getNextClosureId() {
        return this.getLexicalParent().getNextClosureId();
    }

    @Override
    public LocalVariable getNewFlipStateVariable() {
        throw new RuntimeException("Cannot get flip variables from closures.");
    }

    @Override
    public TemporaryVariable getNewTemporaryVariable() {
        ++this.temporaryVariableIndex;
        return new TemporaryClosureVariable(this.closureId, this.temporaryVariableIndex);
    }

    @Override
    public TemporaryVariable getNewTemporaryVariable(String name2) {
        ++this.temporaryVariableIndex;
        return new TemporaryClosureVariable(name2, this.temporaryVariableIndex);
    }

    @Override
    public Label getNewLabel() {
        return this.getNewLabel("CL" + this.closureId + "_LBL");
    }

    @Override
    public String getScopeName() {
        return "Closure";
    }

    @Override
    public boolean isForLoopBody() {
        return this.isForLoopBody;
    }

    @Override
    public boolean isTopLocalVariableScope() {
        return false;
    }

    @Override
    public boolean isFlipScope() {
        return false;
    }

    @Override
    public void addInstr(Instr i2) {
        if (i2 instanceof ReceiveRestArgInstr) {
            this.blockArgs.add(new Splat(((ReceiveRestArgInstr)i2).getResult()));
        } else if (i2 instanceof ReceiveArgBase) {
            this.blockArgs.add(((ReceiveArgBase)i2).getResult());
        }
        super.addInstr(i2);
    }

    public Operand[] getBlockArgs() {
        return this.blockArgs.toArray(new Operand[this.blockArgs.size()]);
    }

    public String toStringBody() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getName()).append(" = { \n");
        CFG c = this.getCFG();
        if (c != null) {
            buf.append("\nCFG:\n").append(c.toStringGraph()).append("\nInstructions:\n").append(c.toStringInstrs());
        } else {
            buf.append(this.toStringInstrs());
        }
        buf.append("\n}\n\n");
        return buf.toString();
    }

    public BlockBody getBlockBody() {
        return this.body;
    }

    @Override
    public LocalVariable findExistingLocalVariable(String name2, int scopeDepth) {
        LocalVariable lvar = this.localVars.getVariable(name2);
        if (lvar != null) {
            return lvar;
        }
        int newDepth = this.isForLoopBody ? scopeDepth : scopeDepth - 1;
        return newDepth >= 0 ? this.getLexicalParent().findExistingLocalVariable(name2, newDepth) : null;
    }

    @Override
    public LocalVariable getNewLocalVariable(String name2, int depth) {
        if (this.isForLoopBody) {
            return this.getLexicalParent().getNewLocalVariable(name2, depth);
        }
        if (depth == 0) {
            ClosureLocalVariable lvar = new ClosureLocalVariable(this, name2, 0, this.localVars.nextSlot);
            this.localVars.putVariable(name2, lvar);
            return lvar;
        }
        return this.getLexicalParent().getNewLocalVariable(name2, depth - 1);
    }

    @Override
    public LocalVariable getLocalVariable(String name2, int scopeDepth) {
        if (this.isForLoopBody) {
            return this.getLexicalParent().getLocalVariable(name2, scopeDepth);
        }
        LocalVariable lvar = this.findExistingLocalVariable(name2, scopeDepth);
        if (lvar == null) {
            lvar = this.getNewLocalVariable(name2, scopeDepth);
        }
        if (lvar.getScopeDepth() != scopeDepth) {
            lvar = lvar.cloneForDepth(scopeDepth);
        }
        return lvar;
    }

    public int getNestingDepth() {
        return this.nestingDepth;
    }

    @Override
    public LocalVariable getImplicitBlockArg() {
        LocalVariable blockVar = this.findExistingLocalVariable("%block", this.getNestingDepth());
        if (blockVar != null) {
            if (blockVar.getScopeDepth() != this.getNestingDepth()) {
                blockVar = blockVar.cloneForDepth(this.getNestingDepth());
            }
        } else {
            IRScope s2 = this;
            while (s2 instanceof IRClosure) {
                s2 = s2.getLexicalParent();
            }
            if (s2 instanceof IRMethod) {
                blockVar = s2.getNewLocalVariable("%block", 0);
                if (this.getNestingDepth() != 0) {
                    blockVar = blockVar.cloneForDepth(this.getNestingDepth());
                }
            } else {
                blockVar = this.getNewLocalVariable("%block", 0);
            }
        }
        return blockVar;
    }

    public IRClosure cloneForClonedInstr(InlinerInfo ii) {
        IRClosure clonedClosure = new IRClosure(this, ii.getNewLexicalParentForClosure());
        clonedClosure.isForLoopBody = this.isForLoopBody;
        clonedClosure.nestingDepth = this.nestingDepth;
        clonedClosure.parameterList = this.parameterList;
        ii = ii.cloneForCloningClosure(clonedClosure);
        clonedClosure.setCFG(this.getCFG().cloneForCloningClosure(clonedClosure, ii));
        return clonedClosure;
    }

    protected boolean addGEBForUncaughtBreaks() {
        if (this.addedGEBForUncaughtBreaks) {
            return false;
        }
        CFG cfg = this.cfg();
        BasicBlock geb = cfg.getGlobalEnsureBB();
        if (geb == null) {
            geb = new BasicBlock(cfg, new Label("_GLOBAL_ENSURE_BLOCK"));
            TemporaryVariable exc = this.getNewTemporaryVariable();
            geb.addInstr(new ReceiveExceptionInstr(exc, false));
            geb.addInstr(new RuntimeHelperCall(null, "catchUncaughtBreakInLambdas", new Operand[]{exc}));
            cfg.addGlobalEnsureBB(geb);
        } else {
            List<Instr> instrs = geb.getInstrs();
            Variable exc = ((ReceiveExceptionInstr)instrs.get(0)).getResult();
            instrs.set(instrs.size(), new RuntimeHelperCall(null, "catchUncaughtBreakInLambdas", new Operand[]{exc}));
        }
        this.addedGEBForUncaughtBreaks = true;
        return true;
    }
}

