/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.bigdecimal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jruby.CompatVersion;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyObject;
import org.jruby.RubyRational;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyConstant;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.Numeric;
import org.jruby.util.SafeDoubleParser;

@JRubyClass(name={"BigDecimal"}, parent="Numeric")
public class RubyBigDecimal
extends RubyNumeric {
    private static final ObjectAllocator BIGDECIMAL_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime, RubyClass klass) {
            return new RubyBigDecimal(runtime, klass);
        }
    };
    @JRubyConstant
    public static final int ROUND_DOWN = 1;
    @JRubyConstant
    public static final int ROUND_CEILING = 2;
    @JRubyConstant
    public static final int ROUND_UP = 0;
    @JRubyConstant
    public static final int ROUND_HALF_DOWN = 5;
    @JRubyConstant
    public static final int ROUND_HALF_EVEN = 6;
    @JRubyConstant
    public static final int ROUND_HALF_UP = 4;
    @JRubyConstant
    public static final int ROUND_FLOOR = 3;
    @JRubyConstant
    public static final int SIGN_POSITIVE_INFINITE = 3;
    @JRubyConstant
    public static final int EXCEPTION_OVERFLOW = 8;
    @JRubyConstant
    public static final int SIGN_POSITIVE_ZERO = 1;
    @JRubyConstant
    public static final int EXCEPTION_ALL = 255;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_FINITE = -2;
    @JRubyConstant
    public static final int EXCEPTION_UNDERFLOW = 4;
    @JRubyConstant
    public static final int SIGN_NaN = 0;
    @JRubyConstant
    public static final int BASE = 10000;
    @JRubyConstant
    public static final int ROUND_MODE = 256;
    @JRubyConstant
    public static final int SIGN_POSITIVE_FINITE = 2;
    @JRubyConstant
    public static final int EXCEPTION_INFINITY = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_INFINITE = -3;
    @JRubyConstant
    public static final int EXCEPTION_ZERODIVIDE = 1;
    @JRubyConstant
    public static final int SIGN_NEGATIVE_ZERO = -1;
    @JRubyConstant
    public static final int EXCEPTION_NaN = 2;
    private static final BigDecimal TWO = new BigDecimal(2);
    private static final double SQRT_10 = 3.1622776601683795;
    private final boolean isNaN;
    private final int infinitySign;
    private final int zeroSign;
    private BigDecimal value;
    private static final Pattern INFINITY_PATTERN = Pattern.compile("^([+-])?Infinity$");
    private static final Pattern NUMBER_PATTERN = Pattern.compile("^([+-]?\\d*\\.?\\d*([eE][+-]?)?\\d*).*");

    public static RubyClass createBigDecimal(Ruby runtime) {
        RubyClass bigDecimal = runtime.defineClass("BigDecimal", runtime.getNumeric(), BIGDECIMAL_ALLOCATOR);
        runtime.getKernel().defineAnnotatedMethods(BigDecimalKernelMethods.class);
        bigDecimal.setInternalModuleVariable("vpPrecLimit", RubyFixnum.zero(runtime));
        bigDecimal.setInternalModuleVariable("vpExceptionMode", RubyFixnum.zero(runtime));
        bigDecimal.setInternalModuleVariable("vpRoundingMode", runtime.newFixnum(4));
        bigDecimal.defineAnnotatedMethods(RubyBigDecimal.class);
        bigDecimal.defineAnnotatedConstants(RubyBigDecimal.class);
        if (runtime.is1_9()) {
            RubyModule bigMath = runtime.defineModule("BigMath");
            bigDecimal.defineConstant("NAN", RubyBigDecimal.newNaN(runtime));
            bigDecimal.defineConstant("INFINITY", RubyBigDecimal.newInfinity(runtime, 1));
        }
        return bigDecimal;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public RubyBigDecimal(Ruby runtime, RubyClass klass) {
        super(runtime, klass);
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value2) {
        super(runtime, runtime.getClass("BigDecimal"));
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
    }

    public RubyBigDecimal(Ruby runtime, RubyClass klass, BigDecimal value2) {
        super(runtime, klass);
        this.isNaN = false;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value2, int infinitySign) {
        super(runtime, runtime.getClass("BigDecimal"));
        this.isNaN = false;
        this.infinitySign = infinitySign;
        this.zeroSign = 0;
        this.value = value2;
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value2, int infinitySign, int zeroSign) {
        super(runtime, runtime.getClass("BigDecimal"));
        this.isNaN = false;
        this.infinitySign = infinitySign;
        this.zeroSign = zeroSign;
        this.value = value2;
    }

    public RubyBigDecimal(Ruby runtime, BigDecimal value2, boolean isNan) {
        super(runtime, runtime.getClass("BigDecimal"));
        this.isNaN = isNan;
        this.infinitySign = 0;
        this.zeroSign = 0;
        this.value = value2;
    }

    public RubyBigDecimal(Ruby runtime, RubyBigDecimal rbd) {
        this(runtime, runtime.getClass("BigDecimal"), rbd);
    }

    public RubyBigDecimal(Ruby runtime, RubyClass klass, RubyBigDecimal rbd) {
        super(runtime, klass);
        this.isNaN = rbd.isNaN;
        this.infinitySign = rbd.infinitySign;
        this.zeroSign = rbd.zeroSign;
        this.value = rbd.value;
    }

    public static RubyBigDecimal newBigDecimal(IRubyObject recv2, IRubyObject[] args2, Block unusedBlock) {
        return RubyBigDecimal.newInstance(recv2.getRuntime().getClass("BigDecimal"), args2);
    }

    @JRubyMethod(name={"ver"}, meta=true)
    public static IRubyObject ver(IRubyObject recv2) {
        return recv2.getRuntime().newString("1.0.1");
    }

    @JRubyMethod(name={"_dump"}, optional=1)
    public IRubyObject dump(IRubyObject[] args2, Block unusedBlock) {
        RubyString precision = RubyString.newUnicodeString(this.getRuntime(), "0:");
        return precision.append(this.asString());
    }

    @JRubyMethod(name={"_load"}, required=1, meta=true)
    public static RubyBigDecimal load(IRubyObject recv2, IRubyObject from, Block block) {
        RubyBigDecimal rubyBigDecimal = (RubyBigDecimal)((RubyClass)recv2).allocate();
        String precisionAndValue = from.convertToString().asJavaString();
        String value2 = precisionAndValue.substring(precisionAndValue.indexOf(":") + 1);
        rubyBigDecimal.value = new BigDecimal(value2);
        return rubyBigDecimal;
    }

    @JRubyMethod(name={"double_fig"}, meta=true)
    public static IRubyObject double_fig(IRubyObject recv2) {
        return recv2.getRuntime().newFixnum(20);
    }

    @JRubyMethod(name={"limit"}, optional=1, meta=true)
    public static IRubyObject limit(IRubyObject recv2, IRubyObject[] args2) {
        IRubyObject arg2;
        Ruby runtime = recv2.getRuntime();
        RubyModule c = (RubyModule)recv2;
        IRubyObject nCur = c.searchInternalModuleVariable("vpPrecLimit");
        if (args2.length > 0 && !(arg2 = args2[0]).isNil()) {
            if (!(arg2 instanceof RubyFixnum)) {
                throw runtime.newTypeError(arg2, runtime.getFixnum());
            }
            if (0L > ((RubyFixnum)arg2).getLongValue()) {
                throw runtime.newArgumentError("argument must be positive");
            }
            c.setInternalModuleVariable("vpPrecLimit", arg2);
        }
        return nCur;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"save_limit"}, meta=true)
    public static IRubyObject save_limit(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject ret;
        RubyModule c = (RubyModule)recv2;
        IRubyObject nCur = c.searchInternalModuleVariable("vpPrecLimit");
        try {
            ret = block.yieldSpecific(context);
        }
        finally {
            c.setInternalModuleVariable("vpPrecLimit", nCur);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"save_exception_mode"}, meta=true)
    public static IRubyObject save_exception_mode(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject ret;
        RubyModule c = (RubyModule)recv2;
        IRubyObject nCur = c.searchInternalModuleVariable("vpExceptionMode");
        try {
            ret = block.yieldSpecific(context);
        }
        finally {
            c.setInternalModuleVariable("vpExceptionMode", nCur);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JRubyMethod(name={"save_rounding_mode"}, meta=true)
    public static IRubyObject save_rounding_mode(ThreadContext context, IRubyObject recv2, Block block) {
        IRubyObject ret;
        RubyModule c = (RubyModule)recv2;
        IRubyObject nCur = c.searchInternalModuleVariable("vpRoundingMode");
        try {
            ret = block.yieldSpecific(context);
        }
        finally {
            c.setInternalModuleVariable("vpRoundingMode", nCur);
        }
        return ret;
    }

    @JRubyMethod(name={"mode"}, required=1, optional=1, meta=true)
    public static IRubyObject mode(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        long EXCEPTION_ALL;
        Ruby runtime = recv2.getRuntime();
        RubyClass clazz = runtime.getClass("BigDecimal");
        RubyModule c = (RubyModule)recv2;
        args2 = Arity.scanArgs(runtime, args2, 1, 1);
        IRubyObject mode2 = args2[0];
        IRubyObject value2 = args2[1];
        if (!(mode2 instanceof RubyFixnum)) {
            throw runtime.newTypeError("wrong argument type " + mode2.getMetaClass() + " (expected Fixnum)");
        }
        long longMode = ((RubyFixnum)mode2).getLongValue();
        if ((longMode & (EXCEPTION_ALL = ((RubyFixnum)clazz.getConstant("EXCEPTION_ALL")).getLongValue())) != 0L) {
            RubyFixnum EXCEPTION_OVERFLOW;
            RubyFixnum EXCEPTION_UNDERFLOW;
            RubyFixnum EXCEPTION_NaN;
            if (value2.isNil()) {
                return c.searchInternalModuleVariable("vpExceptionMode");
            }
            if (!value2.isNil() && !(value2 instanceof RubyBoolean)) {
                throw runtime.newArgumentError("second argument must be true or false");
            }
            RubyFixnum currentExceptionMode = (RubyFixnum)c.searchInternalModuleVariable("vpExceptionMode");
            RubyFixnum newExceptionMode = new RubyFixnum(runtime, currentExceptionMode.getLongValue());
            RubyFixnum EXCEPTION_INFINITY = (RubyFixnum)clazz.getConstant("EXCEPTION_INFINITY");
            if ((longMode & EXCEPTION_INFINITY.getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", EXCEPTION_INFINITY) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(runtime, EXCEPTION_INFINITY.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (EXCEPTION_NaN = (RubyFixnum)clazz.getConstant("EXCEPTION_NaN")).getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", EXCEPTION_NaN) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(runtime, EXCEPTION_NaN.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (EXCEPTION_UNDERFLOW = (RubyFixnum)clazz.getConstant("EXCEPTION_UNDERFLOW")).getLongValue()) != 0L) {
                RubyFixnum rubyFixnum = newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", EXCEPTION_UNDERFLOW) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(runtime, EXCEPTION_UNDERFLOW.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            if ((longMode & (EXCEPTION_OVERFLOW = (RubyFixnum)clazz.getConstant("EXCEPTION_OVERFLOW")).getLongValue()) != 0L) {
                newExceptionMode = value2.isTrue() ? (RubyFixnum)currentExceptionMode.callCoerced(context, "|", EXCEPTION_OVERFLOW) : (RubyFixnum)currentExceptionMode.callCoerced(context, "&", new RubyFixnum(runtime, EXCEPTION_OVERFLOW.getLongValue() ^ 0xFFFFFFFFFFFFFFFFL));
            }
            c.setInternalModuleVariable("vpExceptionMode", newExceptionMode);
            return newExceptionMode;
        }
        long ROUND_MODE = ((RubyFixnum)clazz.getConstant("ROUND_MODE")).getLongValue();
        if (longMode == ROUND_MODE) {
            if (value2.isNil()) {
                return c.searchInternalModuleVariable("vpRoundingMode");
            }
            RoundingMode javaRoundingMode = RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(runtime, value2);
            RubyFixnum roundingMode = runtime.newFixnum(javaRoundingMode.ordinal());
            c.setInternalModuleVariable("vpRoundingMode", roundingMode);
            return c.searchInternalModuleVariable("vpRoundingMode");
        }
        throw runtime.newTypeError("first argument for BigDecimal#mode invalid");
    }

    private static RoundingMode getRoundingMode(Ruby runtime) {
        RubyFixnum roundingMode = (RubyFixnum)runtime.getClass("BigDecimal").searchInternalModuleVariable("vpRoundingMode");
        return RoundingMode.valueOf((int)roundingMode.getLongValue());
    }

    private static boolean isNaNExceptionMode(Ruby runtime) {
        RubyFixnum currentExceptionMode = (RubyFixnum)runtime.getClass("BigDecimal").searchInternalModuleVariable("vpExceptionMode");
        RubyFixnum EXCEPTION_NaN = (RubyFixnum)runtime.getClass("BigDecimal").getConstant("EXCEPTION_NaN");
        return (currentExceptionMode.getLongValue() & EXCEPTION_NaN.getLongValue()) != 0L;
    }

    private static boolean isInfinityExceptionMode(Ruby runtime) {
        RubyFixnum currentExceptionMode = (RubyFixnum)runtime.getClass("BigDecimal").searchInternalModuleVariable("vpExceptionMode");
        RubyFixnum EXCEPTION_INFINITY = (RubyFixnum)runtime.getClass("BigDecimal").getConstant("EXCEPTION_INFINITY");
        return (currentExceptionMode.getLongValue() & EXCEPTION_INFINITY.getLongValue()) != 0L;
    }

    private static boolean isOverflowExceptionMode(Ruby runtime) {
        RubyFixnum currentExceptionMode = (RubyFixnum)runtime.getClass("BigDecimal").searchInternalModuleVariable("vpExceptionMode");
        RubyFixnum EXCEPTION_OVERFLOW = (RubyFixnum)runtime.getClass("BigDecimal").getConstant("EXCEPTION_OVERFLOW");
        return (currentExceptionMode.getLongValue() & EXCEPTION_OVERFLOW.getLongValue()) != 0L;
    }

    private static RubyBigDecimal cannotBeCoerced(ThreadContext context, IRubyObject v, boolean must) {
        if (must) {
            String err = v.isImmediate() ? RubyObject.inspect(context, v).toString() : v.getMetaClass().getBaseName();
            throw context.runtime.newTypeError(err + " can't be coerced into BigDecimal");
        }
        return null;
    }

    private static RubyBigDecimal unableToCoerceWithoutPrec(ThreadContext context, IRubyObject v, boolean must) {
        if (must) {
            throw context.runtime.newArgumentError(v.getMetaClass().getBaseName() + " can't be coerced into BigDecimal without a precision");
        }
        return null;
    }

    private static RubyBigDecimal getVpValue19(ThreadContext context, IRubyObject v, boolean must) {
        long precision = v instanceof RubyFloat ? 0L : (v instanceof RubyRational ? 0L : -1L);
        return RubyBigDecimal.getVpValueWithPrec19(context, v, precision, must);
    }

    private static IRubyObject getVpRubyObjectWithPrec19Inner(ThreadContext context, RubyRational r, long precision, boolean must) {
        long numerator2 = RubyNumeric.num2long(r.numerator(context));
        long denominator2 = RubyNumeric.num2long(r.denominator(context));
        return new RubyBigDecimal(context.runtime, BigDecimal.valueOf(numerator2).divide(BigDecimal.valueOf(denominator2), RubyBigDecimal.getRoundingMode(context.runtime)));
    }

    private static RubyBigDecimal getVpValueWithPrec19(ThreadContext context, IRubyObject value2, long precision, boolean must) {
        while (true) {
            if (value2 instanceof RubyFloat) {
                if (precision > Long.MAX_VALUE) {
                    RubyBigDecimal.cannotBeCoerced(context, value2, must);
                }
                RubyFloat f = (RubyFloat)value2;
                value2 = new RubyBigDecimal(context.runtime, BigDecimal.valueOf(f.getDoubleValue()));
                continue;
            }
            if (!(value2 instanceof RubyRational)) break;
            if (precision < 0L) {
                return RubyBigDecimal.unableToCoerceWithoutPrec(context, value2, must);
            }
            value2 = RubyBigDecimal.getVpRubyObjectWithPrec19Inner(context, (RubyRational)value2, precision, must);
        }
        if (value2 instanceof RubyBigDecimal) {
            return (RubyBigDecimal)value2;
        }
        if (value2 instanceof RubyFixnum || value2 instanceof RubyBignum) {
            String s2 = value2.toString();
            return RubyBigDecimal.newInstance(value2.getRuntime().getClass("BigDecimal"), new IRubyObject[]{value2.getRuntime().newString(s2)});
        }
        return RubyBigDecimal.cannotBeCoerced(context, value2, must);
    }

    private static RubyBigDecimal getVpValue(IRubyObject v, boolean must) {
        if (v instanceof RubyBigDecimal) {
            return (RubyBigDecimal)v;
        }
        if (v instanceof RubyFixnum || v instanceof RubyBignum) {
            String s2 = v.toString();
            return RubyBigDecimal.newInstance(v.getRuntime().getClass("BigDecimal"), new IRubyObject[]{v.getRuntime().newString(s2)});
        }
        return RubyBigDecimal.cannotBeCoerced(v.getRuntime().getCurrentContext(), v, must);
    }

    @JRubyMethod(name={"induced_from"}, required=1, meta=true)
    public static IRubyObject induced_from(IRubyObject recv2, IRubyObject arg2) {
        return RubyBigDecimal.getVpValue(arg2, true);
    }

    @JRubyMethod(name={"new"}, required=1, optional=1, meta=true)
    public static RubyBigDecimal newInstance(IRubyObject recv2, IRubyObject[] args2) {
        BigDecimal decimal;
        Ruby runtime = recv2.getRuntime();
        ThreadContext ctx = runtime.getCurrentContext();
        if (args2.length == 0) {
            decimal = new BigDecimal(0);
        } else {
            MathContext context = MathContext.UNLIMITED;
            if (args2.length == 2) {
                int digits = (int)args2[1].convertToInteger().getLongValue();
                if (digits < 0) {
                    throw runtime.newArgumentError("argument must be positive");
                }
                context = new MathContext(digits);
            }
            if (runtime.is1_9()) {
                if (args2[0] instanceof RubyBigDecimal) {
                    return new RubyBigDecimal(runtime, (RubyClass)recv2, (RubyBigDecimal)args2[0]);
                }
                if (args2[0] instanceof RubyFloat || args2[0] instanceof RubyRational) {
                    if (args2.length != 2) {
                        throw runtime.newArgumentError("can't omit precision for a rational");
                    }
                    if (args2[0] instanceof RubyFloat) {
                        if (context.getPrecision() > 16) {
                            throw runtime.newArgumentError("precision too large");
                        }
                        return new RubyBigDecimal(runtime, (RubyClass)recv2, new BigDecimal(((RubyFloat)args2[0]).getDoubleValue(), context));
                    }
                    RubyRational rat = (RubyRational)args2[0];
                    BigDecimal num = new BigDecimal(rat.numerator(ctx).convertToInteger().getLongValue());
                    BigDecimal den = new BigDecimal(rat.denominator(ctx).convertToInteger().getLongValue());
                    BigDecimal value2 = num.divide(den, context);
                    return new RubyBigDecimal(runtime, value2);
                }
                if (args2[0] instanceof RubyFixnum) {
                    return new RubyBigDecimal(runtime, (RubyClass)recv2, new BigDecimal(((RubyFixnum)args2[0]).getLongValue(), context));
                }
                if (args2[0] instanceof RubyBignum) {
                    return new RubyBigDecimal(runtime, (RubyClass)recv2, new BigDecimal(((RubyBignum)args2[0]).getBigIntegerValue(), context));
                }
            }
            String strValue = args2[0].convertToString().toString();
            if ("NaN".equals(strValue = strValue.trim())) {
                return RubyBigDecimal.newNaN(runtime);
            }
            Matcher m = INFINITY_PATTERN.matcher(strValue);
            if (m.matches()) {
                int sign2 = 1;
                String signGroup = m.group(1);
                if ("-".equals(signGroup)) {
                    sign2 = -1;
                }
                return RubyBigDecimal.newInfinity(runtime, sign2);
            }
            strValue = strValue.replaceFirst("[dD]", "E");
            strValue = strValue.replaceAll("_", "");
            strValue = NUMBER_PATTERN.matcher(strValue).replaceFirst("$1");
            try {
                decimal = new BigDecimal(strValue, context);
            }
            catch (NumberFormatException e) {
                if (RubyBigDecimal.isOverflowExceptionMode(runtime)) {
                    throw runtime.newFloatDomainError("exponent overflow");
                }
                decimal = new BigDecimal(0);
            }
            if (decimal.signum() == 0) {
                if (strValue.matches("^\\s*-.*")) {
                    return RubyBigDecimal.newZero(runtime, -1);
                }
                return RubyBigDecimal.newZero(runtime, 1);
            }
        }
        return new RubyBigDecimal(runtime, (RubyClass)recv2, decimal);
    }

    private static RubyBigDecimal newZero(Ruby runtime, int sign2) {
        int zeroSign = sign2 < 0 ? -1 : 1;
        RubyBigDecimal rbd = new RubyBigDecimal(runtime, BigDecimal.ZERO, 0, zeroSign);
        return rbd;
    }

    private static RubyBigDecimal newNaN(Ruby runtime) {
        if (RubyBigDecimal.isNaNExceptionMode(runtime)) {
            throw runtime.newFloatDomainError("Computation results to 'NaN'(Not a Number)");
        }
        RubyBigDecimal rbd = new RubyBigDecimal(runtime, BigDecimal.ZERO, true);
        return rbd;
    }

    private static RubyBigDecimal newInfinity(Ruby runtime, int sign2) {
        int infinitySign = sign2 < 0 ? -1 : 1;
        RubyBigDecimal rbd = new RubyBigDecimal(runtime, BigDecimal.ZERO, infinitySign);
        if (RubyBigDecimal.isInfinityExceptionMode(runtime)) {
            throw runtime.newFloatDomainError("Computation results to 'Infinity'");
        }
        return rbd;
    }

    private RubyBigDecimal setResult() {
        return this.setResult(0);
    }

    private RubyBigDecimal setResult(int scale) {
        int prec2 = RubyFixnum.fix2int(this.getRuntime().getClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
        int prec22 = Math.max(scale, prec2);
        if (prec22 > 0 && this.value.scale() > prec22 - this.getExponent()) {
            this.value = this.value.setScale(prec22 - this.getExponent(), 4);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"hash"})
    public RubyFixnum hash() {
        return this.getRuntime().newFixnum(this.value.stripTrailingZeros().hashCode());
    }

    @JRubyMethod(name={"%", "modulo"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_mod(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        RubyBigDecimal val = RubyBigDecimal.getVpValue(arg2, false);
        if (val == null) {
            return this.callCoerced(context, "%", arg2, true);
        }
        if (val.isInfinity() || val.isNaN() || val.isZero()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        BigDecimal modulo2 = this.value.remainder(val.value);
        if (modulo2.signum() * val.value.signum() < 0) {
            modulo2 = modulo2.add(val.value);
        }
        return new RubyBigDecimal(runtime, modulo2).setResult();
    }

    @JRubyMethod(name={"%", "modulo"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_mod19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, other, false);
        if (val == null) {
            return this.callCoerced(context, "%", other, true);
        }
        if (this.isNaN() || val.isNaN() || this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (val.isZero()) {
            throw context.runtime.newZeroDivisionError();
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (val.isInfinity()) {
            return this;
        }
        if (this.isZero()) {
            return RubyBigDecimal.newZero(runtime, this.value.signum());
        }
        BigDecimal modulo2 = this.value.remainder(val.value);
        if (modulo2.signum() * val.value.signum() < 0) {
            modulo2 = modulo2.add(val.value);
        }
        return new RubyBigDecimal(runtime, modulo2).setResult();
    }

    @Override
    @JRubyMethod(name={"remainder"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject remainder(ThreadContext context, IRubyObject arg2) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(arg2, false);
        return this.remainderInternal(context, val, arg2);
    }

    @JRubyMethod(name={"remainder"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject remainder19(ThreadContext context, IRubyObject arg2) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, arg2, false);
        return this.remainderInternal(context, val, arg2);
    }

    private IRubyObject remainderInternal(ThreadContext context, RubyBigDecimal val, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (this.isInfinity() || this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (val == null) {
            return this.callCoerced(context, "remainder", arg2, true);
        }
        if (val.isInfinity() || val.isNaN() || val.isZero()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        return new RubyBigDecimal(runtime, this.value.remainder(val.value)).setResult();
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_mul(ThreadContext context, IRubyObject arg2) {
        return this.mult2(context, arg2, this.getRuntime().getClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
    }

    @JRubyMethod(name={"*"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_mul19(ThreadContext context, IRubyObject arg2) {
        return this.mult219(context, arg2, this.getRuntime().getClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
    }

    @JRubyMethod(name={"mult"}, required=2, compat=CompatVersion.RUBY1_8)
    public IRubyObject mult2(ThreadContext context, IRubyObject b, IRubyObject n) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(b, false);
        return this.multInternal(context, val, b, n);
    }

    @JRubyMethod(name={"mult"}, required=2, compat=CompatVersion.RUBY1_9)
    public IRubyObject mult219(ThreadContext context, IRubyObject b, IRubyObject n) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, b, false);
        if (val == null) {
            return RubyBigDecimal.cannotBeCoerced(context, val, true);
        }
        return this.multInternal(context, val, b, n);
    }

    private IRubyObject multInternal(ThreadContext context, RubyBigDecimal val, IRubyObject b, IRubyObject n) {
        Ruby runtime = context.runtime;
        if (val == null) {
            return this.callCoerced(context, "*", b);
        }
        int digits = RubyNumeric.fix2int(n);
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isInfinity() && val.isZero() || this.isZero() && val.isInfinity()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isZero() || val.isZero()) {
            int sign1 = this.isZero() ? this.zeroSign : this.value.signum();
            int sign2 = val.isZero() ? val.zeroSign : val.value.signum();
            return RubyBigDecimal.newZero(runtime, sign1 * sign2);
        }
        if (this.isInfinity() || val.isInfinity()) {
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            int sign2 = val.isInfinity() ? val.infinitySign : val.value.signum();
            return RubyBigDecimal.newInfinity(runtime, sign1 * sign2);
        }
        BigDecimal res = this.value.multiply(val.value);
        if (res.precision() > digits) {
            res = res.round(new MathContext(digits, RoundingMode.HALF_UP));
        }
        return new RubyBigDecimal(runtime, res).setResult();
    }

    @JRubyMethod(name={"**", "power"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_pow(IRubyObject arg2) {
        if (!(arg2 instanceof RubyFixnum)) {
            throw this.getRuntime().newTypeError("wrong argument type " + arg2.getMetaClass() + " (expected Fixnum)");
        }
        if (this.isNaN() || this.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        int times2 = RubyNumeric.fix2int(arg2.convertToInteger());
        if (times2 < 0) {
            if (this.isZero()) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), this.value.signum());
            }
            int precision = (-times2 + 4) * (this.getAllDigits().length() + 4);
            return new RubyBigDecimal(this.getRuntime(), this.value.pow(times2, new MathContext(precision, RoundingMode.HALF_UP)));
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.pow(times2));
    }

    @JRubyMethod(name={"**", "power"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_pow19(IRubyObject exp2) {
        if (!(exp2 instanceof RubyFixnum)) {
            throw this.getRuntime().newTypeError("wrong argument type " + exp2.getMetaClass() + " (expected Fixnum)");
        }
        Ruby runtime = this.getRuntime();
        ThreadContext context = runtime.getCurrentContext();
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isInfinity()) {
            if (Numeric.f_negative_p(context, exp2)) {
                if (this.infinitySign < 0) {
                    if (Numeric.f_integer_p(context, exp2).isTrue()) {
                        if (this.is_even(exp2)) {
                            return RubyBigDecimal.newZero(runtime, 1);
                        }
                        return RubyBigDecimal.newZero(runtime, -1);
                    }
                    return RubyBigDecimal.newZero(runtime, -1);
                }
                return RubyBigDecimal.newZero(runtime, 0);
            }
            if (this.infinitySign < 0) {
                if (Numeric.f_integer_p(context, exp2).isTrue()) {
                    if (this.is_even(exp2)) {
                        return RubyBigDecimal.newInfinity(runtime, 1);
                    }
                    return RubyBigDecimal.newInfinity(runtime, -1);
                }
                throw runtime.newMathDomainError("a non-integral exponent for a negative base");
            }
            return RubyBigDecimal.newInfinity(runtime, 1);
        }
        int times2 = RubyNumeric.fix2int(exp2.convertToInteger());
        if (times2 < 0) {
            if (this.isZero()) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), this.value.signum());
            }
            int precision = (-times2 + 4) * (this.getAllDigits().length() + 4);
            return new RubyBigDecimal(this.getRuntime(), this.value.pow(times2, new MathContext(precision, RoundingMode.HALF_UP)));
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.pow(times2));
    }

    @JRubyMethod(name={"+"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_plus(ThreadContext context, IRubyObject b) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(b, false);
        return this.addInternal(context, val, b, this.getRuntime().getClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
    }

    @JRubyMethod(name={"+"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_plus19(ThreadContext context, IRubyObject b) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, b, false);
        return this.addInternal(context, val, b, this.getRuntime().getClass("BigDecimal").searchInternalModuleVariable("vpPrecLimit"));
    }

    @JRubyMethod(name={"add"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject add2(ThreadContext context, IRubyObject b, IRubyObject digits) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(b, false);
        return this.addInternal(context, val, b, digits);
    }

    @JRubyMethod(name={"add"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject add219(ThreadContext context, IRubyObject b, IRubyObject digits) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, b, false);
        return this.addInternal(context, val, b, digits);
    }

    private IRubyObject addInternal(ThreadContext context, RubyBigDecimal val, IRubyObject b, IRubyObject digits) {
        Ruby runtime = context.runtime;
        int prec2 = this.getPositiveInt(context, digits);
        if (val == null) {
            return this.callCoerced(context, "+", b, true);
        }
        RubyBigDecimal res = this.handleAddSpecialValues(val);
        if (res != null) {
            return res;
        }
        RoundingMode roundMode = RubyBigDecimal.getRoundingMode(runtime);
        return new RubyBigDecimal(runtime, this.value.add(val.value, new MathContext(prec2, roundMode)));
    }

    private int getPositiveInt(ThreadContext context, IRubyObject arg2) {
        Ruby runtime = context.runtime;
        if (arg2 instanceof RubyFixnum) {
            int value2 = RubyNumeric.fix2int(arg2);
            if (value2 < 0) {
                throw runtime.newArgumentError("argument must be positive");
            }
            return value2;
        }
        throw runtime.newTypeError(arg2, runtime.getFixnum());
    }

    private RubyBigDecimal handleAddSpecialValues(RubyBigDecimal val) {
        if (this.isNaN() || val.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        int sign2 = this.infinitySign * val.infinitySign;
        if (sign2 > 0) {
            return this.isInfinity() ? this : val;
        }
        if (sign2 < 0) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (sign2 == 0 && (sign2 = this.infinitySign + val.infinitySign) != 0) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), sign2);
        }
        return null;
    }

    @Override
    @JRubyMethod(name={"+@"})
    public IRubyObject op_uplus() {
        return this;
    }

    @JRubyMethod(name={"-"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_minus(ThreadContext context, IRubyObject b) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(b, false);
        return this.subInternal(context, val, b);
    }

    @JRubyMethod(name={"-"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_minus19(ThreadContext context, IRubyObject b) {
        return this.subInternal(context, RubyBigDecimal.getVpValue19(context, b, true), b);
    }

    @JRubyMethod(name={"sub"}, required=2, compat=CompatVersion.RUBY1_8)
    public IRubyObject sub2(ThreadContext context, IRubyObject b, IRubyObject n) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(b, false);
        return this.subInternal(context, val, b);
    }

    @JRubyMethod(name={"sub"}, required=2, compat=CompatVersion.RUBY1_9)
    public IRubyObject sub219(ThreadContext context, IRubyObject b, IRubyObject n) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, b, false);
        return this.subInternal(context, val, b);
    }

    private IRubyObject subInternal(ThreadContext context, RubyBigDecimal val, IRubyObject b) {
        if (val == null) {
            return this.callCoerced(context, "-", b);
        }
        RubyBigDecimal res = this.handleMinusSpecialValues(val);
        if (res != null) {
            return res;
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.subtract(val.value)).setResult();
    }

    private RubyBigDecimal handleMinusSpecialValues(RubyBigDecimal val) {
        if (this.isNaN() || val.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        int sign2 = this.infinitySign * val.infinitySign;
        if (sign2 > 0) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (sign2 < 0) {
            return this;
        }
        if (sign2 == 0) {
            if (this.isInfinity()) {
                return this;
            }
            if (val.isInfinity()) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), val.infinitySign * -1);
            }
            sign2 = this.infinitySign + val.infinitySign;
            if (sign2 != 0) {
                return RubyBigDecimal.newInfinity(this.getRuntime(), sign2);
            }
        }
        return null;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject op_uminus() {
        Ruby runtime = this.getRuntime();
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(runtime, -this.infinitySign);
        }
        if (this.isZero()) {
            return RubyBigDecimal.newZero(runtime, -this.zeroSign);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.negate());
    }

    @JRubyMethod(name={"/", "quo"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_quo(ThreadContext context, IRubyObject other) {
        return this.convertDivResult(context, other, this.op_div(context, other, this.getRuntime().newFixnum(200)));
    }

    @JRubyMethod(name={"/", "quo"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_quo19(ThreadContext context, IRubyObject other) {
        return this.op_quo19_20(context, other);
    }

    @JRubyMethod(name={"/", "quo"}, compat=CompatVersion.RUBY2_0)
    public IRubyObject op_quo20(ThreadContext context, IRubyObject other) {
        return this.op_quo19_20(context, other);
    }

    private IRubyObject op_quo19_20(ThreadContext context, IRubyObject other) {
        RubyBigDecimal preciseOther = RubyBigDecimal.getVpValue19(context, other, true);
        return this.op_div(context, preciseOther, this.getRuntime().newFixnum(200));
    }

    private IRubyObject convertDivResult(ThreadContext context, IRubyObject other, IRubyObject result2) {
        if (other instanceof RubyFloat && result2 instanceof RubyBigDecimal) {
            result2 = ((RubyBigDecimal)result2).convertToFloat();
        }
        return result2;
    }

    @JRubyMethod(name={"div"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(other, false);
        if (val == null) {
            return this.callCoerced(context, "div", other);
        }
        if (this.isNaN() || val.isZero() || val.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity() || val.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.divideToIntegralValue(val.value)).setResult();
    }

    @JRubyMethod(name={"div"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_div19(ThreadContext context, IRubyObject r) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, r, true);
        if (val == null) {
            return RubyBigDecimal.cannotBeCoerced(context, val, true);
        }
        if (this.isNaN() || val.isNaN()) {
            throw context.runtime.newFloatDomainError("Computation results to 'NaN'");
        }
        if (this.isInfinity() && val.isOne()) {
            throw context.runtime.newFloatDomainError("Computation results to 'Infinity'");
        }
        if (val.isInfinity()) {
            return RubyBigDecimal.newZero(this.getRuntime(), val.infinitySign);
        }
        if (this.isZero() || val.isZero()) {
            throw context.runtime.newZeroDivisionError();
        }
        return this.op_div(context, r);
    }

    @JRubyMethod(name={"div"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject op_div(ThreadContext context, IRubyObject other, IRubyObject digits) {
        int scale = RubyNumeric.fix2int(digits);
        RubyBigDecimal val = RubyBigDecimal.getVpValue(other, false);
        if (val == null) {
            return this.callCoerced(context, "/", other);
        }
        if (this.isNaN() || this.isZero() && val.isZero() || val.isNaN()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (val.isZero()) {
            int sign1 = this.isInfinity() ? this.infinitySign : this.value.signum();
            return RubyBigDecimal.newInfinity(this.getRuntime(), sign1 * val.zeroSign);
        }
        if (this.isInfinity() && !val.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign * val.value.signum());
        }
        if (!this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.newZero(this.getRuntime(), this.value.signum() * val.infinitySign);
        }
        if (this.isInfinity() && val.isInfinity()) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isZero()) {
            return RubyBigDecimal.newZero(this.getRuntime(), this.zeroSign * val.value.signum());
        }
        if (scale == 0) {
            return this.op_quo(context, other);
        }
        int prec2 = Math.max(200, scale);
        return new RubyBigDecimal(this.getRuntime(), this.value.divide(val.value, new MathContext(prec2, RoundingMode.HALF_UP))).setResult(scale);
    }

    @JRubyMethod(name={"div"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject op_div19(ThreadContext context, IRubyObject other, IRubyObject digits) {
        RubyBigDecimal val = RubyBigDecimal.getVpValue(other, false);
        if (val == null) {
            return RubyBigDecimal.cannotBeCoerced(context, val, true);
        }
        if (this.isNaN() || val.isNaN()) {
            throw context.runtime.newFloatDomainError("Computation results to 'NaN'");
        }
        return this.op_div(context, other, digits);
    }

    private IRubyObject cmp(ThreadContext context, IRubyObject r, char op) {
        int e = 0;
        RubyBigDecimal rb = RubyBigDecimal.getVpValue(r, false);
        if (rb == null) {
            IRubyObject ee = this.callCoerced(context, "<=>", r);
            if (ee.isNil()) {
                if (op == '*') {
                    return this.getRuntime().getNil();
                }
                if (op == '=' || this.isNaN()) {
                    return this.getRuntime().getFalse();
                }
                throw this.getRuntime().newArgumentError("nil could not be coerced into a BigDecmil");
            }
            e = RubyNumeric.fix2int(ee);
        } else {
            if (this.isNaN() | rb.isNaN()) {
                return op == '*' ? this.getRuntime().getNil() : this.getRuntime().getFalse();
            }
            e = this.infinitySign != 0 || rb.infinitySign != 0 ? this.infinitySign - rb.infinitySign : this.value.compareTo(rb.value);
        }
        switch (op) {
            case '*': {
                return this.getRuntime().newFixnum(e);
            }
            case '=': {
                return e == 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '!': {
                return e != 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'G': {
                return e >= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '>': {
                return e > 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case 'L': {
                return e <= 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
            case '<': {
                return e < 0 ? this.getRuntime().getTrue() : this.getRuntime().getFalse();
            }
        }
        return this.getRuntime().getNil();
    }

    @Override
    @JRubyMethod(name={"<=>"}, required=1)
    public IRubyObject op_cmp(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '*');
    }

    @Override
    @JRubyMethod(name={"eql?", "==", "==="}, required=1)
    public IRubyObject eql_p(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '=');
    }

    @JRubyMethod(name={"<"}, required=1)
    public IRubyObject op_lt(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '<');
    }

    @JRubyMethod(name={"<="}, required=1)
    public IRubyObject op_le(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, 'L');
    }

    @JRubyMethod(name={">"}, required=1)
    public IRubyObject op_gt(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, '>');
    }

    @JRubyMethod(name={">="}, required=1)
    public IRubyObject op_ge(ThreadContext context, IRubyObject arg2) {
        return this.cmp(context, arg2, 'G');
    }

    @JRubyMethod(name={"abs"})
    public IRubyObject abs() {
        Ruby runtime = this.getRuntime();
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(runtime);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(runtime, 1);
        }
        return new RubyBigDecimal(this.getRuntime(), this.value.abs()).setResult();
    }

    @JRubyMethod(name={"ceil"}, optional=1)
    public IRubyObject ceil(IRubyObject[] args2) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = 0;
        if (args2.length > 0) {
            n = RubyNumeric.fix2int(args2[0]);
        }
        if (this.value.scale() > n) {
            return new RubyBigDecimal(this.getRuntime(), this.value.setScale(n, RoundingMode.CEILING));
        }
        return this;
    }

    @JRubyMethod(name={"ceil"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject ceil19(IRubyObject[] args2) {
        this.checkFloatDomain();
        if (args2.length == 0) {
            BigInteger ceil2 = this.value.setScale(0, RoundingMode.CEILING).toBigInteger();
            if (ceil2.compareTo(BigInteger.valueOf(ceil2.intValue())) == 0) {
                return RubyInteger.int2fix(this.getRuntime(), ceil2.intValue());
            }
            return RubyBignum.newBignum(this.getRuntime(), ceil2);
        }
        return this.ceil(args2);
    }

    @Override
    @JRubyMethod(name={"coerce"}, required=1)
    public IRubyObject coerce(IRubyObject other) {
        RubyArray obj = other instanceof RubyFloat ? this.getRuntime().newArray(other, this.to_f()) : this.getRuntime().newArray((IRubyObject)RubyBigDecimal.getVpValue(other, true), (IRubyObject)this);
        return obj;
    }

    @Override
    public double getDoubleValue() {
        return SafeDoubleParser.doubleValue(this.value);
    }

    @Override
    public long getLongValue() {
        return this.value.longValue();
    }

    @Override
    public BigInteger getBigIntegerValue() {
        return this.value.toBigInteger();
    }

    public BigDecimal getBigDecimalValue() {
        return this.value;
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyInteger value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyFloat value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    public RubyNumeric multiplyWith(ThreadContext context, RubyBignum value2) {
        return (RubyNumeric)this.op_mul(context, value2);
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject divmod(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        if (this.isInfinity() || this.isNaN()) {
            return RubyArray.newArray(runtime, RubyBigDecimal.newNaN(runtime), RubyBigDecimal.newNaN(runtime));
        }
        RubyBigDecimal val = RubyBigDecimal.getVpValue(other, false);
        if (val == null) {
            return this.callCoerced(context, "divmod", other, true);
        }
        if (val.isInfinity() || val.isNaN() || val.isZero()) {
            return RubyArray.newArray(runtime, RubyBigDecimal.newNaN(runtime), RubyBigDecimal.newNaN(runtime));
        }
        BigDecimal[] divmod2 = this.value.divideAndRemainder(val.value);
        BigDecimal div2 = divmod2[0];
        BigDecimal mod = divmod2[1];
        if (mod.signum() * val.value.signum() < 0) {
            div2 = div2.subtract(BigDecimal.ONE);
            mod = mod.add(val.value);
        }
        return RubyArray.newArray(runtime, new RubyBigDecimal(runtime, div2), new RubyBigDecimal(runtime, mod));
    }

    @Override
    @JRubyMethod(name={"divmod"}, required=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject divmod19(ThreadContext context, IRubyObject other) {
        Ruby runtime = context.runtime;
        RubyBigDecimal val = RubyBigDecimal.getVpValue19(context, other, false);
        if (val == null) {
            return this.callCoerced(context, "divmod", other, true);
        }
        if (this.isNaN() || val.isNaN() || this.isInfinity() && val.isInfinity()) {
            return RubyArray.newArray(runtime, RubyBigDecimal.newNaN(runtime), RubyBigDecimal.newNaN(runtime));
        }
        if (val.isZero()) {
            throw context.runtime.newZeroDivisionError();
        }
        if (this.isInfinity()) {
            int sign2 = this.infinitySign == val.value.signum() ? 1 : -1;
            return RubyArray.newArray(runtime, RubyBigDecimal.newInfinity(runtime, sign2), RubyBigDecimal.newNaN(runtime));
        }
        if (val.isInfinity()) {
            return RubyArray.newArray(runtime, RubyBigDecimal.newZero(runtime, val.value.signum()), this);
        }
        if (this.isZero()) {
            return RubyArray.newArray(runtime, RubyBigDecimal.newZero(runtime, this.value.signum()), RubyBigDecimal.newZero(runtime, this.value.signum()));
        }
        BigDecimal[] divmod2 = this.value.divideAndRemainder(val.value);
        BigDecimal div2 = divmod2[0];
        BigDecimal mod = divmod2[1];
        if (mod.signum() * val.value.signum() < 0) {
            div2 = div2.subtract(BigDecimal.ONE);
            mod = mod.add(val.value);
        }
        return RubyArray.newArray(runtime, new RubyBigDecimal(runtime, div2), new RubyBigDecimal(runtime, mod));
    }

    @JRubyMethod(name={"exponent"})
    public IRubyObject exponent() {
        return this.getRuntime().newFixnum(this.getExponent());
    }

    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p() {
        if (this.isNaN()) {
            return this.getRuntime().getFalse();
        }
        return this.getRuntime().newBoolean(!this.isInfinity());
    }

    @JRubyMethod(name={"floor"}, optional=1)
    public IRubyObject floor(IRubyObject[] args2) {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = 0;
        if (args2.length > 0) {
            n = RubyNumeric.fix2int(args2[0]);
        }
        RubyBigDecimal floor2 = null;
        floor2 = this.value.scale() > n ? new RubyBigDecimal(this.getRuntime(), this.value.setScale(n, RoundingMode.FLOOR)) : this;
        if (this.getRuntime().is1_8()) {
            return floor2;
        }
        if (args2.length == 0) {
            return floor2.to_int19();
        }
        return floor2;
    }

    @JRubyMethod(name={"floor"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject floor19(IRubyObject[] args2) {
        if (this.isNaN || this.isInfinity()) {
            throw this.getRuntime().newFloatDomainError("Computation results to '" + this.to_s(args2).asJavaString() + "'");
        }
        return this.floor(args2);
    }

    @JRubyMethod(name={"frac"})
    public IRubyObject frac() {
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        if (this.value.scale() > 0 && this.value.precision() < this.value.scale()) {
            return new RubyBigDecimal(this.getRuntime(), this.value);
        }
        BigDecimal val = this.value.subtract(((RubyBigDecimal)this.fix()).value);
        return new RubyBigDecimal(this.getRuntime(), val);
    }

    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p() {
        if (this.infinitySign == 0) {
            return this.getRuntime().getNil();
        }
        return this.getRuntime().newFixnum(this.infinitySign);
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        StringBuilder val = new StringBuilder("#<BigDecimal:").append(Integer.toHexString(System.identityHashCode(this))).append(",");
        val.append("'").append(this.callMethod(context, "to_s")).append("'").append(",");
        val.append(this.getSignificantDigits().length()).append("(");
        int len = this.getAllDigits().length();
        int pow = len / 4;
        val.append((pow + 1) * 4).append(")").append(">");
        return this.getRuntime().newString(val.toString());
    }

    @JRubyMethod(name={"nan?"})
    public IRubyObject nan_p() {
        return this.getRuntime().newBoolean(this.isNaN);
    }

    @JRubyMethod(name={"nonzero?"})
    public IRubyObject nonzero_p() {
        return this.isZero() ? this.getRuntime().getNil() : this;
    }

    @JRubyMethod(name={"precs"})
    public IRubyObject precs() {
        Ruby runtime = this.getRuntime();
        IRubyObject[] array = new IRubyObject[2];
        array[0] = runtime.newFixnum(this.getSignificantDigits().length());
        int len = this.getAllDigits().length();
        int pow = len / 4;
        array[1] = runtime.newFixnum((pow + 1) * 4);
        return RubyArray.newArrayNoCopy(runtime, array);
    }

    @Deprecated
    public IRubyObject round(IRubyObject[] args2) {
        return this.round(this.getRuntime().getCurrentContext(), args2);
    }

    @JRubyMethod(name={"round"}, optional=2)
    public IRubyObject round(ThreadContext context, IRubyObject[] args2) {
        int scale;
        int n = scale = args2.length > 0 ? RubyBigDecimal.num2int(args2[0]) : 0;
        if (scale == 0 && (this.isNaN() || this.isInfinity())) {
            StringBuilder message2 = new StringBuilder("Computation results to ");
            message2.append("'").append(this.callMethod(context, "to_s")).append("'");
            if (this.isNaN()) {
                message2.append("(Not a Number)");
            }
            throw this.getRuntime().newFloatDomainError(message2.toString());
        }
        if (this.isNaN()) {
            return RubyBigDecimal.newNaN(context.runtime);
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(context.runtime, this.infinitySign);
        }
        RoundingMode mode2 = args2.length > 1 ? RubyBigDecimal.javaRoundingModeFromRubyRoundingMode(context.runtime, args2[1]) : RubyBigDecimal.getRoundingMode(context.runtime);
        RubyBigDecimal bigDecimal = null;
        if (scale < 0) {
            BigDecimal normalized = this.value.movePointRight(scale);
            BigDecimal rounded = normalized.setScale(0, mode2);
            bigDecimal = new RubyBigDecimal(this.getRuntime(), rounded.movePointLeft(scale));
        } else {
            bigDecimal = new RubyBigDecimal(this.getRuntime(), this.value.setScale(scale, mode2));
        }
        if (context.runtime.is1_8()) {
            return bigDecimal;
        }
        if (args2.length == 0) {
            return bigDecimal.to_int19();
        }
        return bigDecimal;
    }

    private static RoundingMode javaRoundingModeFromRubyRoundingMode(Ruby runtime, IRubyObject arg2) {
        if (arg2 instanceof RubySymbol) {
            RubySymbol roundingModeSymbol = (RubySymbol)arg2;
            String roundingModeString = roundingModeSymbol.asJavaString();
            if (roundingModeString.equals("up")) {
                return RoundingMode.UP;
            }
            if (roundingModeString.equals("down") || roundingModeString.equals("truncate")) {
                return RoundingMode.DOWN;
            }
            if (roundingModeString.equals("half_up") || roundingModeString.equals("default")) {
                return RoundingMode.HALF_UP;
            }
            if (roundingModeString.equals("half_down")) {
                return RoundingMode.HALF_DOWN;
            }
            if (roundingModeString.equals("half_even") || roundingModeString.equals("banker")) {
                return RoundingMode.HALF_EVEN;
            }
            if (roundingModeString.equals("ceiling") || roundingModeString.equals("ceil")) {
                return RoundingMode.CEILING;
            }
            if (roundingModeString.equals("floor")) {
                return RoundingMode.FLOOR;
            }
            throw runtime.newArgumentError("invalid rounding mode");
        }
        try {
            return RoundingMode.valueOf(RubyBigDecimal.num2int(arg2));
        }
        catch (IllegalArgumentException iae) {
            throw runtime.newArgumentError("invalid rounding mode");
        }
    }

    @JRubyMethod(name={"sign"})
    public IRubyObject sign() {
        if (this.isNaN()) {
            return this.getMetaClass().getConstant("SIGN_NaN");
        }
        if (this.isInfinity()) {
            if (this.infinitySign < 0) {
                return this.getMetaClass().getConstant("SIGN_NEGATIVE_INFINITE");
            }
            return this.getMetaClass().getConstant("SIGN_POSITIVE_INFINITE");
        }
        if (this.isZero()) {
            if (this.zeroSign < 0) {
                return this.getMetaClass().getConstant("SIGN_NEGATIVE_ZERO");
            }
            return this.getMetaClass().getConstant("SIGN_POSITIVE_ZERO");
        }
        if (this.value.signum() < 0) {
            return this.getMetaClass().getConstant("SIGN_NEGATIVE_FINITE");
        }
        return this.getMetaClass().getConstant("SIGN_POSITIVE_FINITE");
    }

    @JRubyMethod(name={"split"})
    public RubyArray split() {
        RubyFixnum exp2;
        RubyString digits;
        Ruby runtime = this.getRuntime();
        IRubyObject[] array = new IRubyObject[4];
        RubyFixnum sign2 = this.isNaN ? RubyFixnum.zero(runtime) : (this.isInfinity() ? runtime.newFixnum(this.infinitySign) : (this.isZero() ? runtime.newFixnum(this.zeroSign) : runtime.newFixnum(this.value.signum())));
        array[0] = sign2;
        if (this.isNaN()) {
            digits = runtime.newString("NaN");
            exp2 = RubyFixnum.zero(runtime);
        } else if (this.isInfinity()) {
            digits = runtime.newString("Infinity");
            exp2 = RubyFixnum.zero(runtime);
        } else if (this.isZero()) {
            digits = runtime.newString("0");
            exp2 = RubyFixnum.zero(runtime);
        } else {
            digits = runtime.newString(this.getSignificantDigits());
            exp2 = runtime.newFixnum(this.getExponent());
        }
        array[1] = digits;
        array[3] = exp2;
        array[2] = runtime.newFixnum(10);
        return RubyArray.newArrayNoCopy(runtime, array);
    }

    private String getSignificantDigits() {
        BigDecimal val = this.value.abs().stripTrailingZeros();
        return val.unscaledValue().toString();
    }

    private String getAllDigits() {
        BigDecimal val = this.value.abs();
        return val.unscaledValue().toString();
    }

    private int getExponent() {
        if (this.isZero() || this.isNaN() || this.isInfinity()) {
            return 0;
        }
        BigDecimal val = this.value.abs().stripTrailingZeros();
        return val.precision() - val.scale();
    }

    @JRubyMethod(name={"sqrt"}, required=1)
    public IRubyObject sqrt(IRubyObject arg2) {
        Ruby runtime = this.getRuntime();
        if (this.isNaN()) {
            throw runtime.newFloatDomainError("(VpSqrt) SQRT(NaN value)");
        }
        if (this.isInfinity() && this.infinitySign < 0 || this.value.signum() < 0) {
            throw runtime.newFloatDomainError("(VpSqrt) SQRT(negative value)");
        }
        if (this.isInfinity() && this.infinitySign > 0) {
            return RubyBigDecimal.newInfinity(runtime, 1);
        }
        int n = RubyNumeric.fix2int(arg2);
        if (n < 0) {
            throw runtime.newArgumentError("argument must be positive");
        }
        return new RubyBigDecimal(this.getRuntime(), RubyBigDecimal.bigSqrt(this.value, new MathContext(n += 4, RoundingMode.HALF_UP))).setResult();
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f() {
        if (this.isNaN()) {
            return RubyFloat.newFloat(this.getRuntime(), Double.NaN);
        }
        if (this.isInfinity()) {
            return RubyFloat.newFloat(this.getRuntime(), this.infinitySign < 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY);
        }
        if (this.isZero()) {
            return RubyFloat.newFloat(this.getRuntime(), this.zeroSign < 0 ? -0.0 : 0.0);
        }
        if (-this.value.scale() > 308) {
            switch (this.value.signum()) {
                case -1: {
                    return RubyFloat.newFloat(this.getRuntime(), Double.NEGATIVE_INFINITY);
                }
                case 0: {
                    return RubyFloat.newFloat(this.getRuntime(), 0.0);
                }
                case 1: {
                    return RubyFloat.newFloat(this.getRuntime(), Double.POSITIVE_INFINITY);
                }
            }
        }
        return RubyFloat.newFloat(this.getRuntime(), SafeDoubleParser.doubleValue(this.value));
    }

    @JRubyMethod(name={"to_i", "to_int"}, compat=CompatVersion.RUBY1_8)
    public IRubyObject to_int() {
        if (this.isNaN() || this.infinitySign != 0) {
            return this.getRuntime().getNil();
        }
        try {
            return RubyNumeric.int2fix(this.getRuntime(), this.value.longValueExact());
        }
        catch (ArithmeticException ae) {
            return RubyBignum.bignorm(this.getRuntime(), this.value.toBigInteger());
        }
    }

    @JRubyMethod(name={"to_i", "to_int"}, compat=CompatVersion.RUBY1_9)
    public IRubyObject to_int19() {
        this.checkFloatDomain();
        return this.to_int();
    }

    private String removeTrailingZeroes(String in) {
        while (in.length() > 0 && in.charAt(in.length() - 1) == '0') {
            in = in.substring(0, in.length() - 1);
        }
        return in;
    }

    public static boolean formatHasLeadingPlus(String format) {
        return format.startsWith("+");
    }

    public static boolean formatHasLeadingSpace(String format) {
        return format.startsWith(" ");
    }

    public static boolean formatHasFloatingPointNotation(String format) {
        return format.endsWith("F");
    }

    public static int formatFractionalDigitGroups(String format) {
        int groups2 = 0;
        Pattern p2 = Pattern.compile("(\\+| )?(\\d+)(E|F)?");
        Matcher m = p2.matcher(format);
        if (m.matches()) {
            groups2 = Integer.parseInt(m.group(2));
        }
        return groups2;
    }

    private boolean hasArg(IRubyObject[] args2) {
        return args2.length != 0 && !args2[0].isNil();
    }

    private String format(IRubyObject[] args2) {
        return args2[0].toString();
    }

    private String firstArgument(IRubyObject[] args2) {
        if (this.hasArg(args2)) {
            return this.format(args2);
        }
        return null;
    }

    private boolean posSpace(String arg2) {
        if (null != arg2) {
            return RubyBigDecimal.formatHasLeadingSpace(arg2);
        }
        return false;
    }

    private boolean posSign(String arg2) {
        if (null != arg2) {
            return RubyBigDecimal.formatHasLeadingPlus(arg2) || this.posSpace(arg2);
        }
        return false;
    }

    private boolean asEngineering(String arg2) {
        if (null != arg2) {
            return !RubyBigDecimal.formatHasFloatingPointNotation(arg2);
        }
        return true;
    }

    private int groups(String arg2) {
        if (null != arg2) {
            return RubyBigDecimal.formatFractionalDigitGroups(arg2);
        }
        return 0;
    }

    private boolean isZero() {
        return !this.isNaN() && !this.isInfinity() && this.value.signum() == 0;
    }

    private boolean isOne() {
        return this.value.abs().compareTo(BigDecimal.ONE) == 0;
    }

    private boolean isNaN() {
        return this.isNaN;
    }

    private boolean isInfinity() {
        return this.infinitySign != 0;
    }

    private String unscaledValue() {
        return this.value.abs().unscaledValue().toString();
    }

    private String sign(String arg2, int signum) {
        return signum == -1 ? "-" : (signum == 1 ? (this.posSign(arg2) ? (this.posSpace(arg2) ? " " : "+") : "") : "");
    }

    private IRubyObject engineeringValue(String arg2) {
        StringBuilder build = new StringBuilder().append(this.sign(arg2, this.value.signum())).append("0.");
        String s2 = this.removeTrailingZeroes(this.unscaledValue());
        if (this.groups(arg2) == 0) {
            build.append("".equals(s2) ? "0" : s2);
        } else {
            int length2 = s2.length();
            String sep = "";
            for (int index2 = 0; index2 < length2; index2 += this.groups(arg2)) {
                int next2 = index2 + this.groups(arg2);
                build.append(sep).append(s2.substring(index2, next2 > length2 ? length2 : next2));
                sep = " ";
            }
        }
        build.append("E").append(this.getExponent());
        return this.getRuntime().newString(build.toString());
    }

    private IRubyObject floatingPointValue(String arg2) {
        String[] values2 = this.value.abs().stripTrailingZeros().toPlainString().split("\\.");
        String whole = "0";
        if (values2.length > 0) {
            whole = values2[0];
        }
        String after = "0";
        if (values2.length > 1) {
            after = values2[1];
        }
        int signum = this.value.signum();
        StringBuilder build = new StringBuilder();
        build.append(signum == -1 ? "-" : (signum == 1 ? (this.posSign(arg2) ? (this.posSpace(arg2) ? " " : "+") : "") : ""));
        if (this.groups(arg2) == 0) {
            build.append(whole);
            if (null != after) {
                build.append(".").append(after);
            }
        } else {
            int next2;
            int index2;
            String sep = "";
            for (index2 = 0; index2 < whole.length(); index2 += this.groups(arg2)) {
                next2 = index2 + this.groups(arg2);
                if (next2 > whole.length()) {
                    next2 = whole.length();
                }
                build.append(sep).append(whole.substring(index2, next2));
                sep = " ";
            }
            if (null != after) {
                build.append(".");
                sep = "";
                for (index2 = 0; index2 < after.length(); index2 += this.groups(arg2)) {
                    next2 = index2 + this.groups(arg2);
                    if (next2 > after.length()) {
                        next2 = after.length();
                    }
                    build.append(sep).append(after.substring(index2, next2));
                    sep = " ";
                }
            }
        }
        return this.getRuntime().newString(build.toString());
    }

    @JRubyMethod(name={"to_s"}, optional=1)
    public IRubyObject to_s(IRubyObject[] args2) {
        String arg2 = this.firstArgument(args2);
        if (this.isNaN()) {
            return this.getRuntime().newString("NaN");
        }
        if (this.infinitySign != 0) {
            if (this.infinitySign == -1) {
                return this.getRuntime().newString("-Infinity");
            }
            return this.getRuntime().newString("Infinity");
        }
        if (this.isZero()) {
            String zero = "0.0";
            if (this.zeroSign < 0) {
                zero = "-" + zero;
            }
            return this.getRuntime().newString(zero);
        }
        if (this.asEngineering(arg2)) {
            return this.engineeringValue(arg2);
        }
        return this.floatingPointValue(arg2);
    }

    @JRubyMethod
    public IRubyObject fix() {
        IRubyObject[] ary = new IRubyObject[]{RubyFixnum.zero(this.getRuntime())};
        return this.truncate(ary);
    }

    @JRubyMethod(name={"truncate"}, optional=1, compat=CompatVersion.RUBY1_8)
    public IRubyObject truncate(IRubyObject[] args2) {
        if (args2.length == 0) {
            IRubyObject[] ary = new IRubyObject[]{RubyFixnum.zero(this.getRuntime())};
            return this.truncate(ary);
        }
        if (this.isNaN) {
            return RubyBigDecimal.newNaN(this.getRuntime());
        }
        if (this.isInfinity()) {
            return RubyBigDecimal.newInfinity(this.getRuntime(), this.infinitySign);
        }
        int n = RubyNumeric.fix2int(args2[0]);
        int precision = this.value.precision() - this.value.scale() + n;
        if (precision > 0) {
            return new RubyBigDecimal(this.getRuntime(), this.value.round(new MathContext(precision, RoundingMode.DOWN)));
        }
        return new RubyBigDecimal(this.getRuntime(), BigDecimal.ZERO);
    }

    @JRubyMethod(name={"truncate"}, optional=1, compat=CompatVersion.RUBY1_9)
    public IRubyObject truncate19(IRubyObject[] args2) {
        if (args2.length == 0) {
            return ((RubyBigDecimal)this.truncate(args2)).to_int19();
        }
        return this.truncate(args2);
    }

    @JRubyMethod(name={"zero?"})
    public IRubyObject zero_p() {
        return this.getRuntime().newBoolean(this.isZero());
    }

    public static BigDecimal bigSqrt(BigDecimal squarD, MathContext rootMC) {
        int biLen;
        int sign2 = squarD.signum();
        if (sign2 == -1) {
            throw new ArithmeticException("Square root of a negative number: " + squarD);
        }
        if (sign2 == 0) {
            return squarD.round(rootMC);
        }
        int prec2 = rootMC.getPrecision();
        if (prec2 == 0) {
            throw new IllegalArgumentException("Most roots won't have infinite precision = 0");
        }
        int BITS = 62;
        int nInit = 16;
        MathContext nMC = new MathContext(18, RoundingMode.HALF_DOWN);
        BigDecimal x = null;
        BigDecimal e = null;
        BigDecimal v = null;
        BigDecimal g = null;
        BigInteger bi = squarD.unscaledValue();
        int shift2 = Math.max(0, biLen - BITS + ((biLen = bi.bitLength()) % 2 == 0 ? 0 : 1));
        bi = bi.shiftRight(shift2);
        double root = Math.sqrt(SafeDoubleParser.doubleValue(bi));
        BigDecimal halfBack = new BigDecimal(BigInteger.ONE.shiftLeft(shift2 / 2));
        int scale = squarD.scale();
        if (scale % 2 == 1) {
            root *= 3.1622776601683795;
        }
        scale = (int)Math.ceil((double)scale / 2.0);
        x = new BigDecimal(root, nMC);
        x = x.multiply(halfBack, nMC);
        if (scale != 0) {
            x = x.movePointLeft(scale);
        }
        if (prec2 < nInit) {
            return x.round(rootMC);
        }
        v = BigDecimal.ONE.divide(TWO.multiply(x), nMC);
        ArrayList<Integer> nPrecs = new ArrayList<Integer>();
        assert (nInit > 3) : "Never ending loop!";
        int m = prec2 + 1;
        while (m > nInit) {
            nPrecs.add(m);
            m = m / 2 + (m > 100 ? 1 : 2);
        }
        for (int i2 = nPrecs.size() - 1; i2 > -1; --i2) {
            nMC = new MathContext((Integer)nPrecs.get(i2), i2 % 2 == 1 ? RoundingMode.HALF_UP : RoundingMode.HALF_DOWN);
            e = squarD.subtract(x.multiply(x, nMC), nMC);
            if (i2 == 0) {
                x = x.add(e.multiply(v, rootMC), rootMC);
                break;
            }
            x = x.add(e.multiply(v, nMC));
            g = BigDecimal.ONE.subtract(TWO.multiply(x).multiply(v, nMC));
            v = v.add(g.multiply(v, nMC));
        }
        return x;
    }

    private void checkFloatDomain() {
        if (this.isNaN) {
            throw this.getRuntime().newFloatDomainError("NaN");
        }
        if (this.infinitySign != 0) {
            if (this.infinitySign == -1) {
                throw this.getRuntime().newFloatDomainError("-Infinity");
            }
            throw this.getRuntime().newFloatDomainError("Infinity");
        }
    }

    private boolean is_even(IRubyObject x) {
        if (x instanceof RubyFixnum) {
            return RubyNumeric.fix2long((RubyFixnum)x) % 2L == 0L;
        }
        if (x instanceof RubyBignum) {
            return RubyBignum.big2long((RubyBignum)x) % 2L == 0L;
        }
        return false;
    }

    public static class BigDecimalKernelMethods {
        @JRubyMethod(name={"BigDecimal"}, rest=true, module=true, visibility=Visibility.PRIVATE)
        public static IRubyObject newBigDecimal(IRubyObject recv2, IRubyObject[] args2) {
            return RubyBigDecimal.newBigDecimal(recv2, args2, Block.NULL_BLOCK);
        }
    }
}

