/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channel;
import java.nio.channels.FileChannel;
import jnr.posix.FileStat;
import jnr.posix.POSIX;
import org.jruby.RubyFile;
import org.jruby.util.FileResource;
import org.jruby.util.JRubyFile;
import org.jruby.util.ResourceException;
import org.jruby.util.io.ChannelDescriptor;
import org.jruby.util.io.ModeFlags;

class RegularFileResource
implements FileResource {
    private final JRubyFile file;
    private final POSIX posix;

    RegularFileResource(POSIX posix, File file2) {
        this(posix, file2.getAbsolutePath());
    }

    protected RegularFileResource(POSIX posix, String filename2) {
        this.file = new JRubyFile(filename2);
        this.posix = posix;
    }

    @Override
    public String absolutePath() {
        return RubyFile.canonicalize(this.file.getAbsolutePath());
    }

    @Override
    public String canonicalPath() {
        try {
            return this.file.getCanonicalPath();
        }
        catch (IOException ioError) {
            return this.file.getAbsolutePath();
        }
    }

    @Override
    public long length() {
        return this.file.length();
    }

    @Override
    public long lastModified() {
        return this.file.lastModified();
    }

    @Override
    public boolean exists() {
        return this.file.exists() || this.isSymLink();
    }

    @Override
    public boolean isFile() {
        return this.file.isFile();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public boolean isSymLink() {
        FileStat stat2 = this.posix.allocateStat();
        return this.posix.lstat(this.file.getAbsolutePath(), stat2) < 0 ? false : stat2.isSymlink();
    }

    @Override
    public boolean canRead() {
        return this.file.canRead();
    }

    @Override
    public boolean canWrite() {
        return this.file.canWrite();
    }

    @Override
    public String[] list() {
        String[] fileList = this.file.list();
        if (fileList == null) {
            return null;
        }
        String[] list2 = new String[fileList.length + 2];
        list2[0] = ".";
        list2[1] = "..";
        System.arraycopy(fileList, 0, list2, 2, fileList.length);
        return list2;
    }

    @Override
    public FileStat stat() {
        return this.posix.stat(this.absolutePath());
    }

    @Override
    public FileStat lstat() {
        return this.posix.lstat(this.file.getAbsolutePath());
    }

    public String toString() {
        return this.file.toString();
    }

    @Override
    public JRubyFile hackyGetJRubyFile() {
        return this.file;
    }

    @Override
    public InputStream openInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream((File)((Object)this.file)), 32768);
        }
        catch (FileNotFoundException fnfe) {
            return null;
        }
    }

    @Override
    public ChannelDescriptor openDescriptor(ModeFlags flags, int perm) throws ResourceException {
        if (flags.isCreate()) {
            boolean fileCreated;
            try {
                fileCreated = this.file.createNewFile();
            }
            catch (IOException ioe) {
                File parent = this.file.getParentFile();
                if (parent != null && parent != this.file && !parent.exists()) {
                    throw new ResourceException.NotFound(this.absolutePath());
                }
                if (!this.file.canWrite()) {
                    throw new ResourceException.PermissionDenied(this.absolutePath());
                }
                throw new ResourceException.IOError(ioe);
            }
            if (!fileCreated && flags.isExclusive()) {
                throw new ResourceException.FileExists(this.absolutePath());
            }
            ChannelDescriptor descriptor = this.createDescriptor(flags);
            if (fileCreated && this.posix != null && perm > 0 && perm > 0) {
                this.posix.chmod(this.file.getPath(), perm);
            }
            return descriptor;
        }
        if (this.file.isDirectory() && flags.isWritable()) {
            throw new ResourceException.FileIsDirectory(this.absolutePath());
        }
        if (!this.file.exists()) {
            throw new ResourceException.NotFound(this.absolutePath());
        }
        return this.createDescriptor(flags);
    }

    private ChannelDescriptor createDescriptor(ModeFlags flags) throws ResourceException {
        boolean isInAppendMode;
        FileDescriptor fileDescriptor;
        FileChannel fileChannel;
        block8: {
            try {
                if (flags.isWritable() && !flags.isReadable()) {
                    FileOutputStream fos = new FileOutputStream((File)((Object)this.file), flags.isAppendable());
                    fileChannel = fos.getChannel();
                    fileDescriptor = fos.getFD();
                    isInAppendMode = true;
                } else {
                    RandomAccessFile raf = new RandomAccessFile((File)((Object)this.file), flags.toJavaModeString());
                    fileChannel = raf.getChannel();
                    fileDescriptor = raf.getFD();
                    isInAppendMode = false;
                }
            }
            catch (FileNotFoundException fnfe) {
                throw this.file.exists() ? new ResourceException.PermissionDenied(this.absolutePath()) : new ResourceException.NotFound(this.absolutePath());
            }
            catch (IOException ioe) {
                throw new ResourceException.IOError(ioe);
            }
            try {
                if (flags.isTruncate()) {
                    fileChannel.truncate(0L);
                }
            }
            catch (IOException ioe) {
                if (ioe.getMessage().equals("Illegal seek")) break block8;
                throw new ResourceException.IOError(ioe);
            }
        }
        return new ChannelDescriptor((Channel)fileChannel, flags, fileDescriptor, isInAppendMode);
    }
}

