/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyInteger;
import org.jruby.RubyString;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.ByteList;

public class ConvertBytes {
    private final Ruby runtime;
    private final ByteList _str;
    private int str;
    private int end;
    private byte[] data;
    private int base;
    private final boolean badcheck;
    private final boolean is19;
    private static final byte[] ZERO_BYTES;
    private static final byte[][] MIN_VALUE_BYTES;
    private static final byte[] LOWER_DIGITS;
    private static final byte[] UPPER_DIGITS;
    private static final byte[] conv_digit;
    private static final boolean[] digit;
    private static final boolean[] space;
    private static final boolean[] spaceOrUnderscore;

    public ConvertBytes(Ruby runtime, ByteList _str, int base, boolean badcheck) {
        this(runtime, _str, base, badcheck, false);
    }

    public ConvertBytes(Ruby runtime, ByteList _str, int base, boolean badcheck, boolean is19) {
        this.runtime = runtime;
        this._str = _str;
        this.str = _str.getBegin();
        this.data = _str.getUnsafeBytes();
        this.end = this.str + _str.getRealSize();
        this.badcheck = badcheck;
        this.base = base;
        this.is19 = is19;
    }

    public static final byte[] intToBinaryBytes(int i2) {
        return ConvertBytes.intToUnsignedByteList(i2, 1, LOWER_DIGITS).bytes();
    }

    public static final byte[] intToOctalBytes(int i2) {
        return ConvertBytes.intToUnsignedByteList(i2, 3, LOWER_DIGITS).bytes();
    }

    public static final byte[] intToHexBytes(int i2) {
        return ConvertBytes.intToUnsignedByteList(i2, 4, LOWER_DIGITS).bytes();
    }

    public static final byte[] intToHexBytes(int i2, boolean upper) {
        return ConvertBytes.intToUnsignedByteList(i2, 4, upper ? UPPER_DIGITS : LOWER_DIGITS).bytes();
    }

    public static final ByteList intToBinaryByteList(int i2) {
        return new ByteList(ConvertBytes.intToBinaryBytes(i2));
    }

    public static final ByteList intToOctalByteList(int i2) {
        return new ByteList(ConvertBytes.intToOctalBytes(i2));
    }

    public static final ByteList intToHexByteList(int i2) {
        return new ByteList(ConvertBytes.intToHexBytes(i2));
    }

    public static final ByteList intToHexByteList(int i2, boolean upper) {
        return new ByteList(ConvertBytes.intToHexBytes(i2, upper));
    }

    public static final byte[] intToByteArray(int i2, int radix, boolean upper) {
        return ConvertBytes.longToByteArray(i2, radix, upper);
    }

    public static final byte[] intToCharBytes(int i2) {
        return ConvertBytes.longToByteList(i2, 10, LOWER_DIGITS).bytes();
    }

    public static final byte[] longToBinaryBytes(long i2) {
        return ConvertBytes.longToUnsignedByteList(i2, 1, LOWER_DIGITS).bytes();
    }

    public static final byte[] longToOctalBytes(long i2) {
        return ConvertBytes.longToUnsignedByteList(i2, 3, LOWER_DIGITS).bytes();
    }

    public static final byte[] longToHexBytes(long i2) {
        return ConvertBytes.longToUnsignedByteList(i2, 4, LOWER_DIGITS).bytes();
    }

    public static final byte[] longToHexBytes(long i2, boolean upper) {
        return ConvertBytes.longToUnsignedByteList(i2, 4, upper ? UPPER_DIGITS : LOWER_DIGITS).bytes();
    }

    public static final ByteList longToBinaryByteList(long i2) {
        return ConvertBytes.longToByteList(i2, 2, LOWER_DIGITS);
    }

    public static final ByteList longToOctalByteList(long i2) {
        return ConvertBytes.longToByteList(i2, 8, LOWER_DIGITS);
    }

    public static final ByteList longToHexByteList(long i2) {
        return ConvertBytes.longToByteList(i2, 16, LOWER_DIGITS);
    }

    public static final ByteList longToHexByteList(long i2, boolean upper) {
        return ConvertBytes.longToByteList(i2, 16, upper ? UPPER_DIGITS : LOWER_DIGITS);
    }

    public static final byte[] longToByteArray(long i2, int radix, boolean upper) {
        return ConvertBytes.longToByteList(i2, radix, upper ? UPPER_DIGITS : LOWER_DIGITS).bytes();
    }

    public static final byte[] longToCharBytes(long i2) {
        return ConvertBytes.longToByteList(i2, 10, LOWER_DIGITS).bytes();
    }

    public static final ByteList longToByteList(long i2) {
        return ConvertBytes.longToByteList(i2, 10, LOWER_DIGITS);
    }

    public static final ByteList longToByteList(long i2, int radix) {
        return ConvertBytes.longToByteList(i2, radix, LOWER_DIGITS);
    }

    public static final ByteList longToByteList(long i2, int radix, byte[] digitmap) {
        if (i2 == 0L) {
            return new ByteList(ZERO_BYTES);
        }
        if (i2 == Long.MIN_VALUE) {
            return new ByteList(MIN_VALUE_BYTES[radix]);
        }
        boolean neg = false;
        if (i2 < 0L) {
            i2 = -i2;
            neg = true;
        }
        int len = 64;
        byte[] buf = new byte[len];
        int pos2 = len;
        do {
            buf[--pos2] = digitmap[(int)(i2 % (long)radix)];
        } while ((i2 /= (long)radix) > 0L);
        if (neg) {
            buf[--pos2] = 45;
        }
        return new ByteList(buf, pos2, len - pos2, false);
    }

    private static final ByteList intToUnsignedByteList(int i2, int shift2, byte[] digitmap) {
        byte[] buf = new byte[32];
        int charPos = 32;
        int radix = 1 << shift2;
        long mask = radix - 1;
        do {
            buf[--charPos] = digitmap[(int)((long)i2 & mask)];
        } while ((i2 >>>= shift2) != 0);
        return new ByteList(buf, charPos, 32 - charPos, false);
    }

    private static final ByteList longToUnsignedByteList(long i2, int shift2, byte[] digitmap) {
        byte[] buf = new byte[64];
        int charPos = 64;
        int radix = 1 << shift2;
        long mask = radix - 1;
        do {
            buf[--charPos] = digitmap[(int)(i2 & mask)];
        } while ((i2 >>>= shift2) != 0L);
        return new ByteList(buf, charPos, 64 - charPos, false);
    }

    public static final byte[] twosComplementToBinaryBytes(byte[] in) {
        return ConvertBytes.twosComplementToUnsignedBytes(in, 1, false);
    }

    public static final byte[] twosComplementToOctalBytes(byte[] in) {
        return ConvertBytes.twosComplementToUnsignedBytes(in, 3, false);
    }

    public static final byte[] twosComplementToHexBytes(byte[] in, boolean upper) {
        return ConvertBytes.twosComplementToUnsignedBytes(in, 4, upper);
    }

    public static final byte[] twosComplementToUnsignedBytes(byte[] in, int shift2, boolean upper) {
        if (shift2 < 1 || shift2 > 4) {
            throw new IllegalArgumentException("shift value must be 1-4");
        }
        int ilen = in.length;
        int olen = (ilen * 8 + shift2 - 1) / shift2;
        byte[] out = new byte[olen];
        int mask = (1 << shift2) - 1;
        byte[] digits = upper ? UPPER_DIGITS : LOWER_DIGITS;
        int bitbuf = 0;
        int bitcnt = 0;
        int i2 = ilen;
        int o = olen;
        while (--o >= 0) {
            if (bitcnt < shift2) {
                bitbuf |= (in[--i2] & 0xFF) << bitcnt;
                bitcnt += 8;
            }
            out[o] = digits[bitbuf & mask];
            bitbuf >>= shift2;
            bitcnt -= shift2;
        }
        return out;
    }

    public static RubyInteger byteListToInum(Ruby runtime, ByteList str, int base, boolean badcheck) {
        return new ConvertBytes(runtime, str, base, badcheck).byteListToInum();
    }

    public static RubyInteger byteListToInum19(Ruby runtime, ByteList str, int base, boolean badcheck) {
        return new ConvertBytes(runtime, str, base, badcheck, true).byteListToInum();
    }

    public static byte[] bytesToUUIDBytes(byte[] randBytes, boolean upper) {
        ByteBuffer bytes2 = ByteBuffer.wrap(randBytes);
        long N0 = (long)bytes2.getInt() & 0xFFFFFFFFL;
        int n1 = bytes2.getShort() & 0xFFFF;
        int n2 = bytes2.getShort() & 0xFFFF;
        n2 = n2 & 0xFFF | 0x4000;
        int n3 = bytes2.getShort() & 0xFFFF;
        n3 = n3 & 0x3FFF | 0x8000;
        int n4 = bytes2.getShort() & 0xFFFF;
        long N5 = (long)bytes2.getInt() & 0xFFFFFFFFL;
        byte[] convert2 = upper ? UPPER_DIGITS : LOWER_DIGITS;
        return new byte[]{convert2[(int)(N0 >> 28 & 0xFL)], convert2[(int)(N0 >> 24 & 0xFL)], convert2[(int)(N0 >> 20 & 0xFL)], convert2[(int)(N0 >> 16 & 0xFL)], convert2[(int)(N0 >> 12 & 0xFL)], convert2[(int)(N0 >> 8 & 0xFL)], convert2[(int)(N0 >> 4 & 0xFL)], convert2[(int)(N0 & 0xFL)], 45, convert2[n1 >> 12 & 0xF], convert2[n1 >> 8 & 0xF], convert2[n1 >> 4 & 0xF], convert2[n1 & 0xF], 45, convert2[n2 >> 12 & 0xF], convert2[n2 >> 8 & 0xF], convert2[n2 >> 4 & 0xF], convert2[n2 & 0xF], 45, convert2[n3 >> 12 & 0xF], convert2[n3 >> 8 & 0xF], convert2[n3 >> 4 & 0xF], convert2[n3 & 0xF], 45, convert2[n4 >> 12 & 0xF], convert2[n4 >> 8 & 0xF], convert2[n4 >> 4 & 0xF], convert2[n4 & 0xF], convert2[(int)(N5 >> 28 & 0xFL)], convert2[(int)(N5 >> 24 & 0xFL)], convert2[(int)(N5 >> 20 & 0xFL)], convert2[(int)(N5 >> 16 & 0xFL)], convert2[(int)(N5 >> 12 & 0xFL)], convert2[(int)(N5 >> 8 & 0xFL)], convert2[(int)(N5 >> 4 & 0xFL)], convert2[(int)(N5 & 0xFL)]};
    }

    private byte convertDigit(byte c) {
        if (c < 0) {
            return -1;
        }
        return conv_digit[c];
    }

    private boolean isSpace(int str) {
        byte c;
        if (str == this.end || (c = this.data[str]) < 0) {
            return false;
        }
        return space[c];
    }

    private boolean isDigit(byte[] buf, int str) {
        byte c;
        if (str == buf.length || (c = buf[str]) < 0) {
            return false;
        }
        return digit[c];
    }

    private boolean isSpaceOrUnderscore(int str) {
        byte c;
        if (str == this.end || (c = this.data[str]) < 0) {
            return false;
        }
        return spaceOrUnderscore[c];
    }

    private boolean getSign() {
        boolean sign2 = true;
        if (this.str < this.end) {
            if (this.data[this.str] == 43) {
                ++this.str;
            } else if (this.data[this.str] == 45) {
                ++this.str;
                sign2 = false;
            }
        }
        return sign2;
    }

    private void ignoreLeadingWhitespace() {
        if (this.badcheck || this.is19) {
            while (this.isSpace(this.str)) {
                ++this.str;
            }
        } else {
            while (this.isSpaceOrUnderscore(this.str)) {
                ++this.str;
            }
        }
    }

    private void figureOutBase() {
        if (this.base <= 0) {
            if (this.str < this.end && this.data[this.str] == 48) {
                if (this.str + 1 < this.end) {
                    switch (this.data[this.str + 1]) {
                        case 88: 
                        case 120: {
                            this.base = 16;
                            break;
                        }
                        case 66: 
                        case 98: {
                            this.base = 2;
                            break;
                        }
                        case 79: 
                        case 111: {
                            this.base = 8;
                            break;
                        }
                        case 68: 
                        case 100: {
                            this.base = 10;
                            break;
                        }
                        default: {
                            this.base = 8;
                            break;
                        }
                    }
                } else {
                    this.base = 8;
                }
            } else {
                this.base = this.base < -1 ? -this.base : 10;
            }
        }
    }

    private int calculateLength() {
        int len = 0;
        int second = this.str + 1 < this.end && this.data[this.str] == 48 ? this.data[this.str + 1] : 0;
        switch (this.base) {
            case 2: {
                len = 1;
                if (second != 98 && second != 66) break;
                this.str += 2;
                break;
            }
            case 3: {
                len = 2;
                break;
            }
            case 8: {
                if (second == 111 || second == 79) {
                    this.str += 2;
                }
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                len = 3;
                break;
            }
            case 10: {
                if (second == 100 || second == 68) {
                    this.str += 2;
                }
            }
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: {
                len = 4;
                break;
            }
            case 16: {
                len = 4;
                if (second != 120 && second != 88) break;
                this.str += 2;
                break;
            }
            default: {
                if (this.base < 2 || 36 < this.base) {
                    throw this.runtime.newArgumentError("illegal radix " + this.base);
                }
                len = this.base <= 32 ? 5 : 6;
            }
        }
        return len;
    }

    private void squeezeZeroes() {
        if (this.str < this.end && this.data[this.str] == 48) {
            byte c;
            ++this.str;
            int us = 0;
            while (this.str < this.end && ((c = this.data[this.str]) == 48 || c == 95)) {
                if (c == 95) {
                    if (++us >= 2) {
                        break;
                    }
                } else {
                    us += 0;
                }
                ++this.str;
            }
            if (this.str == this.end || this.isSpace(this.str)) {
                --this.str;
            }
        }
    }

    private long stringToLong(int nptr, int[] endptr, int base) {
        if (base < 0 || base == 1 || base > 36) {
            return 0L;
        }
        int save = nptr;
        int s2 = nptr;
        boolean overflow = false;
        while (this.isSpace(s2)) {
            ++s2;
        }
        if (s2 != this.end) {
            byte c;
            boolean negative = false;
            if (this.data[s2] == 45) {
                negative = true;
                ++s2;
            } else if (this.data[s2] == 43) {
                negative = false;
                ++s2;
            }
            save = s2;
            long i2 = 0L;
            long cutoff = Long.MAX_VALUE / (long)base;
            long cutlim = Long.MAX_VALUE % (long)base;
            while (s2 < this.end && (c = this.convertDigit(this.data[s2])) != -1 && c < base) {
                ++s2;
                if (i2 > cutoff || i2 == cutoff && (long)c > cutlim) {
                    overflow = true;
                    continue;
                }
                i2 *= (long)base;
                i2 += (long)c;
            }
            if (s2 != save) {
                if (endptr != null) {
                    endptr[0] = s2;
                }
                if (overflow) {
                    throw new ERange(negative ? ERange.Kind.Underflow : ERange.Kind.Overflow);
                }
                if (negative) {
                    return -i2;
                }
                return i2;
            }
        }
        if (endptr != null) {
            endptr[0] = save - nptr >= 2 && (this.data[save - 1] == 120 || this.data[save - 1] == 88) && this.data[save - 2] == 48 ? save - 1 : nptr;
        }
        return 0L;
    }

    public RubyInteger byteListToInum() {
        if (this._str == null) {
            if (this.badcheck) {
                this.invalidString("Integer");
            }
            return this.runtime.newFixnum(0);
        }
        this.ignoreLeadingWhitespace();
        boolean sign2 = this.getSign();
        if (this.str < this.end && (this.data[this.str] == 43 || this.data[this.str] == 45)) {
            if (this.badcheck) {
                this.invalidString("Integer");
            }
            return this.runtime.newFixnum(0);
        }
        this.figureOutBase();
        int len = this.calculateLength();
        this.squeezeZeroes();
        int c = 0;
        if (this.str < this.end) {
            c = this.data[this.str];
        }
        if ((c = this.convertDigit((byte)c)) < 0 || c >= this.base) {
            if (this.badcheck) {
                this.invalidString("Integer");
            }
            return this.runtime.newFixnum(0);
        }
        if ((len *= this.end - this.str) < 63) {
            int[] endPlace = new int[]{this.str};
            long val = this.stringToLong(this.str, endPlace, this.base);
            if (endPlace[0] < this.end && this.data[endPlace[0]] == 95) {
                return this.bigParse(len, sign2);
            }
            if (this.badcheck) {
                if (endPlace[0] == this.str) {
                    this.invalidString("Integer");
                }
                while (this.isSpace(endPlace[0])) {
                    endPlace[0] = endPlace[0] + 1;
                }
                if (endPlace[0] < this.end) {
                    this.invalidString("Integer");
                }
            }
            if (sign2) {
                return this.runtime.newFixnum(val);
            }
            return this.runtime.newFixnum(-val);
        }
        return this.bigParse(len, sign2);
    }

    private RubyInteger bigParse(int len, boolean sign2) {
        if (this.badcheck && this.str < this.end && this.data[this.str] == 95) {
            this.invalidString("Integer");
        }
        char[] result2 = new char[this.end - this.str];
        int resultIndex = 0;
        int nondigit = -1;
        while (this.str < this.end) {
            int c;
            int cx = c = this.data[this.str++];
            if (c == 95) {
                if (nondigit != -1) {
                    if (!this.badcheck) break;
                    this.invalidString("Integer");
                    break;
                }
                nondigit = c;
                continue;
            }
            byte by = this.convertDigit((byte)c);
            c = by;
            if (by < 0 || c >= this.base) break;
            nondigit = -1;
            result2[resultIndex++] = (char)cx;
        }
        int tmpStr = this.str;
        if (this.badcheck) {
            if (this._str.getBegin() + 1 < tmpStr && this.data[tmpStr - 1] == 95) {
                this.invalidString("Integer");
            }
            while (tmpStr < this.end && Character.isWhitespace(this.data[tmpStr])) {
                ++tmpStr;
            }
            if (tmpStr < this.end) {
                this.invalidString("Integer");
            }
        }
        BigInteger z = resultIndex == 0 ? BigInteger.ZERO : new BigInteger(new String(result2, 0, resultIndex), this.base);
        if (!sign2) {
            z = z.negate();
        }
        if (this.badcheck) {
            if (this._str.getBegin() + 1 < this.str && this.data[this.str - 1] == 95) {
                this.invalidString("Integer");
            }
            while (this.str < this.end && this.isSpace(this.str)) {
                ++this.str;
            }
            if (this.str < this.end) {
                this.invalidString("Integer");
            }
        }
        return RubyBignum.bignorm(this.runtime, z);
    }

    private void invalidString(String type2) {
        IRubyObject s2 = RubyString.newString(this.runtime, this._str).inspect();
        throw this.runtime.newArgumentError("invalid value for " + type2 + ": " + s2);
    }

    static {
        int c;
        ZERO_BYTES = new byte[]{48};
        MIN_VALUE_BYTES = new byte[37][];
        for (int i2 = 2; i2 <= 36; ++i2) {
            ConvertBytes.MIN_VALUE_BYTES[i2] = ByteList.plain((CharSequence)Long.toString(Long.MIN_VALUE, i2));
        }
        LOWER_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122};
        UPPER_DIGITS = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90};
        conv_digit = new byte[128];
        digit = new boolean[128];
        space = new boolean[128];
        spaceOrUnderscore = new boolean[128];
        Arrays.fill(conv_digit, (byte)-1);
        Arrays.fill(digit, false);
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            ConvertBytes.conv_digit[c] = (byte)(c - 48);
            ConvertBytes.digit[c] = true;
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            ConvertBytes.conv_digit[c] = (byte)(c - 97 + 10);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            ConvertBytes.conv_digit[c] = (byte)(c - 65 + 10);
        }
        Arrays.fill(space, false);
        ConvertBytes.space[9] = true;
        ConvertBytes.space[10] = true;
        ConvertBytes.space[11] = true;
        ConvertBytes.space[12] = true;
        ConvertBytes.space[13] = true;
        ConvertBytes.space[32] = true;
        Arrays.fill(spaceOrUnderscore, false);
        ConvertBytes.spaceOrUnderscore[9] = true;
        ConvertBytes.spaceOrUnderscore[10] = true;
        ConvertBytes.spaceOrUnderscore[11] = true;
        ConvertBytes.spaceOrUnderscore[12] = true;
        ConvertBytes.spaceOrUnderscore[13] = true;
        ConvertBytes.spaceOrUnderscore[32] = true;
        ConvertBytes.spaceOrUnderscore[95] = true;
    }

    public static class ERange
    extends RuntimeException {
        private Kind kind;

        public ERange() {
        }

        public ERange(Kind kind) {
            this.kind = kind;
        }

        public Kind getKind() {
            return this.kind;
        }

        public static enum Kind {
            Overflow,
            Underflow;

        }
    }
}

