/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.jruby.Ruby;
import org.jruby.RubyBignum;
import org.jruby.RubyHash;
import org.jruby.RubyInteger;
import org.jruby.RubyNumeric;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ext.ffi.Type;
import org.jruby.javasupport.JavaObject;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public final class Util {
    private static final BigInteger UINT64_BASE = BigInteger.valueOf(Long.MAX_VALUE).add(BigInteger.ONE);

    private Util() {
    }

    public static final byte int8Value(IRubyObject parameter) {
        return (byte)Util.longValue(parameter);
    }

    public static final short uint8Value(IRubyObject parameter) {
        return (short)Util.longValue(parameter);
    }

    public static final short int16Value(IRubyObject parameter) {
        return (short)Util.longValue(parameter);
    }

    public static final int uint16Value(IRubyObject parameter) {
        return (int)Util.longValue(parameter);
    }

    public static final int int32Value(IRubyObject parameter) {
        return (int)Util.longValue(parameter);
    }

    public static final long uint32Value(IRubyObject parameter) {
        return Util.longValue(parameter);
    }

    public static final long int64Value(IRubyObject parameter) {
        return Util.longValue(parameter);
    }

    public static final long uint64Value(IRubyObject parameter) {
        long value2 = parameter instanceof RubyBignum ? ((RubyBignum)parameter).getValue().longValue() : Util.longValue(parameter);
        return value2;
    }

    public static final float floatValue(IRubyObject parameter) {
        return (float)RubyNumeric.num2dbl(parameter);
    }

    public static final double doubleValue(IRubyObject parameter) {
        return RubyNumeric.num2dbl(parameter);
    }

    public static final long longValue(IRubyObject parameter) {
        return RubyNumeric.num2long(parameter);
    }

    public static int intValue(IRubyObject obj, RubyHash enums) {
        if (obj instanceof RubyInteger) {
            return (int)((RubyInteger)obj).getLongValue();
        }
        if (obj instanceof RubySymbol) {
            IRubyObject value2 = enums.fastARef(obj);
            if (value2.isNil()) {
                throw obj.getRuntime().newArgumentError("invalid enum value, " + obj.inspect());
            }
            return (int)Util.longValue(value2);
        }
        return (int)Util.longValue(obj);
    }

    public static final IRubyObject newSigned8(Ruby runtime, byte value2) {
        return runtime.newFixnum(value2);
    }

    public static final IRubyObject newUnsigned8(Ruby runtime, byte value2) {
        return runtime.newFixnum(value2 < 0 ? ((long)value2 & 0x7FL) + 128L : (long)value2);
    }

    public static final IRubyObject newSigned16(Ruby runtime, short value2) {
        return runtime.newFixnum(value2);
    }

    public static final IRubyObject newUnsigned16(Ruby runtime, short value2) {
        return runtime.newFixnum(value2 < 0 ? ((long)value2 & 0x7FFFL) + 32768L : (long)value2);
    }

    public static final IRubyObject newSigned32(Ruby runtime, int value2) {
        return runtime.newFixnum(value2);
    }

    public static final IRubyObject newUnsigned32(Ruby runtime, int value2) {
        return runtime.newFixnum(value2 < 0 ? ((long)value2 & Integer.MAX_VALUE) + 0x80000000L : (long)value2);
    }

    public static final IRubyObject newSigned64(Ruby runtime, long value2) {
        return runtime.newFixnum(value2);
    }

    public static final IRubyObject newUnsigned64(Ruby runtime, long value2) {
        return value2 < 0L ? RubyBignum.newBignum(runtime, BigInteger.valueOf(value2 & Long.MAX_VALUE).add(UINT64_BASE)) : runtime.newFixnum(value2);
    }

    @Deprecated
    public static final <T> T convertParameter(IRubyObject parameter, Class<T> paramClass) {
        return paramClass.cast(parameter instanceof JavaObject ? ((JavaObject)parameter).getValue() : parameter.toJava(paramClass));
    }

    public static final ByteBuffer slice(ByteBuffer buf, int offset2) {
        ByteBuffer tmp = buf.duplicate();
        tmp.position(offset2);
        return tmp.slice();
    }

    public static final void checkBounds(Ruby runtime, long size2, long off, long len) {
        if ((off | len | off + len | size2 - (off + len)) < 0L) {
            throw runtime.newIndexError("Memory access offset=" + off + " size=" + len + " is out of bounds");
        }
    }

    public static Type findType(ThreadContext context, IRubyObject name2) {
        return context.runtime.getFFI().getTypeResolver().findType(context.runtime, name2);
    }

    public static ByteOrder parseByteOrder(Ruby runtime, IRubyObject byte_order) {
        if (byte_order instanceof RubySymbol || byte_order instanceof RubyString) {
            String orderName = byte_order.asJavaString();
            if ("network".equals(orderName) || "big".equals(orderName)) {
                return ByteOrder.BIG_ENDIAN;
            }
            if ("little".equals(orderName)) {
                return ByteOrder.LITTLE_ENDIAN;
            }
            return ByteOrder.nativeOrder();
        }
        throw runtime.newTypeError(byte_order, runtime.getSymbol());
    }

    public static int roundUpToPowerOfTwo(int v) {
        if (v < 1) {
            return 1;
        }
        --v;
        v |= v >> 1;
        v |= v >> 2;
        v |= v >> 4;
        v |= v >> 8;
        v |= v >> 16;
        return v + 1;
    }
}

