/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util.io;

import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyHash;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.encoding.EncodingService;
import org.jruby.util.io.ModeFlags;

public class EncodingOption {
    private Encoding externalEncoding;
    private Encoding internalEncoding;
    private boolean bom;

    public EncodingOption(Encoding externalEncoding, Encoding internalEncoding, boolean bom) {
        this.externalEncoding = externalEncoding;
        this.internalEncoding = internalEncoding;
        this.bom = bom;
    }

    public Encoding getExternalEncoding() {
        return this.externalEncoding;
    }

    public Encoding getInternalEncoding() {
        return this.internalEncoding;
    }

    public boolean hasBom() {
        return this.bom;
    }

    public static EncodingOption getEncodingOptionFromObject(IRubyObject options2) {
        if (options2 == null || options2.isNil() || !(options2 instanceof RubyHash)) {
            return null;
        }
        RubyHash opts = (RubyHash)options2;
        Ruby runtime = options2.getRuntime();
        IRubyObject encOption = opts.fastARef(runtime.newSymbol("encoding"));
        IRubyObject extOption = opts.fastARef(runtime.newSymbol("external_encoding"));
        IRubyObject intOption = opts.fastARef(runtime.newSymbol("internal_encoding"));
        if (encOption != null && !encOption.isNil()) {
            if (extOption != null) {
                runtime.getWarnings().warn("Ignoring encoding parameter '" + encOption + "': external_encoding is used");
                encOption = runtime.getNil();
            } else if (intOption != null) {
                runtime.getWarnings().warn("Ignoring encoding parameter '" + encOption + "': internal_encoding is used");
                encOption = runtime.getNil();
            } else {
                IRubyObject tmp = encOption.checkStringType19();
                if (!tmp.isNil()) {
                    return EncodingOption.getEncodingOptionFromString(runtime, tmp.convertToString().toString());
                }
                return EncodingOption.createEncodingOption(runtime, runtime.getEncodingService().getEncodingFromObject(encOption), null, false);
            }
        }
        boolean set = false;
        Encoding extEncoding = null;
        Encoding intEncoding = null;
        if (extOption != null) {
            set = true;
            if (!extOption.isNil()) {
                extEncoding = runtime.getEncodingService().getEncodingFromObject(extOption);
            }
        }
        if (intOption != null) {
            set = true;
            if (!intOption.isNil() && !intOption.asString().toString().equals("-")) {
                intEncoding = runtime.getEncodingService().getEncodingFromObject(intOption);
            }
        }
        if (!set) {
            return null;
        }
        return EncodingOption.createEncodingOption(runtime, extEncoding, intEncoding, false);
    }

    private static EncodingOption createEncodingOption(Ruby runtime, Encoding extEncoding, Encoding intEncoding, boolean isBom) {
        boolean defaultExt = false;
        if (extEncoding == null) {
            extEncoding = runtime.getDefaultExternalEncoding();
            defaultExt = true;
        }
        if (intEncoding == null && extEncoding != ASCIIEncoding.INSTANCE) {
            intEncoding = runtime.getDefaultInternalEncoding();
        }
        if (intEncoding == null || intEncoding == extEncoding) {
            return new EncodingOption(extEncoding, (Encoding)(defaultExt && intEncoding != extEncoding ? null : extEncoding), isBom);
        }
        return new EncodingOption(extEncoding, intEncoding, isBom);
    }

    public static EncodingOption getEncodingOptionFromString(Ruby runtime, String option) {
        EncodingService service = runtime.getEncodingService();
        Encoding ascii8bit = service.getAscii8bitEncoding();
        Encoding extEncoding = null;
        Encoding intEncoding = null;
        boolean isBom = false;
        String[] encs = option.split(":", 2);
        if (encs[0].toLowerCase().startsWith("bom|utf-")) {
            isBom = true;
            encs[0] = encs[0].substring(4);
        }
        extEncoding = service.getEncodingFromString(encs[0]);
        if (encs.length > 1 && !encs[1].equals("-")) {
            intEncoding = service.getEncodingFromString(encs[1]);
        }
        if (extEncoding == null) {
            extEncoding = runtime.getDefaultExternalEncoding();
        }
        if (intEncoding == null && extEncoding != ASCIIEncoding.INSTANCE) {
            intEncoding = runtime.getDefaultInternalEncoding();
        }
        return new EncodingOption(extEncoding, intEncoding, isBom);
    }

    public static EncodingOption getEncodingNoOption(Ruby runtime, ModeFlags modeFlags) {
        if (modeFlags.isBinary()) {
            return new EncodingOption((Encoding)ASCIIEncoding.INSTANCE, null, false);
        }
        return new EncodingOption(null, null, false);
    }

    public String toString() {
        return "EncodingOption(int:" + this.internalEncoding + ", ext:" + this.externalEncoding + ", bom:" + this.bom + ")";
    }
}

