/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime.profile;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import org.jruby.runtime.profile.ProfilePrinter;

public class ProfileOutput {
    private final PrintStream stream;
    private boolean headerPrinted = false;

    public ProfileOutput(PrintStream out) {
        this.stream = out;
    }

    public ProfileOutput(File out) throws FileNotFoundException {
        this.stream = new PrintStream(new FileOutputStream(out));
    }

    public void printProfile(ProfilePrinter printer) {
        if (this.headerPrinted) {
            printer.printProfile(this.stream, false);
        } else {
            printer.printHeader(this.stream);
            printer.printProfile(this.stream, true);
            this.headerPrinted = true;
            this.footerAndCleanupOnShutdown(printer);
        }
    }

    private void footerAndCleanupOnShutdown(final ProfilePrinter printer) {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                printer.printFooter(ProfileOutput.this.stream);
                ProfileOutput.this.stream.close();
            }
        });
    }
}

