/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.operator.bc;

import java.io.IOException;
import java.io.OutputStream;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.crypto.Digest;
import org.jruby.org.bouncycastle.operator.DigestCalculator;
import org.jruby.org.bouncycastle.operator.DigestCalculatorProvider;
import org.jruby.org.bouncycastle.operator.OperatorCreationException;
import org.jruby.org.bouncycastle.operator.bc.BcUtil;

public class BcDigestCalculatorProvider
implements DigestCalculatorProvider {
    private DigestOutputStream stream;

    public DigestCalculator get(final AlgorithmIdentifier algorithmIdentifier) throws OperatorCreationException {
        Digest digest2 = BcUtil.createDigest(algorithmIdentifier);
        this.stream = new DigestOutputStream(digest2);
        return new DigestCalculator(){

            public AlgorithmIdentifier getAlgorithmIdentifier() {
                return algorithmIdentifier;
            }

            public OutputStream getOutputStream() {
                return BcDigestCalculatorProvider.this.stream;
            }

            public byte[] getDigest() {
                return BcDigestCalculatorProvider.this.stream.getDigest();
            }
        };
    }

    private class DigestOutputStream
    extends OutputStream {
        private Digest dig;

        DigestOutputStream(Digest digest2) {
            this.dig = digest2;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        public void write(byte[] byArray) throws IOException {
            this.dig.update(byArray, 0, byArray.length);
        }

        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }

        byte[] getDigest() {
            byte[] byArray = new byte[this.dig.getDigestSize()];
            this.dig.doFinal(byArray, 0);
            return byArray;
        }
    }
}

