/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.mail.smime.examples;

import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jruby.org.bouncycastle.cert.X509CertificateHolder;
import org.jruby.org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.jruby.org.bouncycastle.cms.SignerInformation;
import org.jruby.org.bouncycastle.cms.SignerInformationStore;
import org.jruby.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import org.jruby.org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jruby.org.bouncycastle.mail.smime.SMIMESignedParser;
import org.jruby.org.bouncycastle.mail.smime.util.SharedFileInputStream;
import org.jruby.org.bouncycastle.util.Store;

public class ReadLargeSignedMail {
    private static final String BC = BouncyCastleProvider.PROVIDER_NAME;

    private static void verify(SMIMESignedParser sMIMESignedParser) throws Exception {
        Store store = sMIMESignedParser.getCertificates();
        SignerInformationStore signerInformationStore = sMIMESignedParser.getSignerInfos();
        Collection collection = signerInformationStore.getSigners();
        for (SignerInformation signerInformation : collection) {
            Collection collection2 = store.getMatches(signerInformation.getSID());
            Iterator iterator = collection2.iterator();
            X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider(BC).getCertificate((X509CertificateHolder)iterator.next());
            if (signerInformation.verify(new JcaSimpleSignerInfoVerifierBuilder().setProvider(BC).build(x509Certificate))) {
                System.out.println("signature verified");
                continue;
            }
            System.out.println("signature failed!");
        }
    }

    public static void main(String[] stringArray) throws Exception {
        Properties properties = System.getProperties();
        Session session = Session.getDefaultInstance((Properties)properties, null);
        MimeMessage mimeMessage = new MimeMessage(session, (InputStream)new SharedFileInputStream("signed.message"));
        if (mimeMessage.isMimeType("multipart/signed")) {
            SMIMESignedParser sMIMESignedParser = new SMIMESignedParser((MimeMultipart)mimeMessage.getContent());
            System.out.println("Status:");
            ReadLargeSignedMail.verify(sMIMESignedParser);
        } else if (mimeMessage.isMimeType("application/pkcs7-mime")) {
            SMIMESignedParser sMIMESignedParser = new SMIMESignedParser((Part)mimeMessage);
            System.out.println("Status:");
            ReadLargeSignedMail.verify(sMIMESignedParser);
        } else {
            System.err.println("Not a signed message!");
        }
    }
}

