/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.mail.smime;

import java.io.IOException;
import java.io.OutputStream;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.CMSProcessable;
import org.jruby.org.bouncycastle.mail.smime.SMIMEUtil;
import org.jruby.org.bouncycastle.mail.smime.util.CRLFOutputStream;

public class CMSProcessableBodyPartOutbound
implements CMSProcessable {
    private BodyPart bodyPart;
    private String defaultContentTransferEncoding;

    public CMSProcessableBodyPartOutbound(BodyPart bodyPart) {
        this.bodyPart = bodyPart;
    }

    public CMSProcessableBodyPartOutbound(BodyPart bodyPart, String string2) {
        this.bodyPart = bodyPart;
        this.defaultContentTransferEncoding = string2;
    }

    public void write(OutputStream outputStream) throws IOException, CMSException {
        try {
            if (SMIMEUtil.isCanonicalisationRequired((MimeBodyPart)this.bodyPart, this.defaultContentTransferEncoding)) {
                outputStream = new CRLFOutputStream(outputStream);
            }
            this.bodyPart.writeTo(outputStream);
        }
        catch (MessagingException messagingException) {
            throw new CMSException("can't write BodyPart to stream.", (Exception)((Object)messagingException));
        }
    }

    public Object getContent() {
        return this.bodyPart;
    }
}

