/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.jce.provider.symmetric;

import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import javax.crypto.spec.IvParameterSpec;
import org.jruby.org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.jruby.org.bouncycastle.crypto.BufferedBlockCipher;
import org.jruby.org.bouncycastle.crypto.CipherKeyGenerator;
import org.jruby.org.bouncycastle.crypto.engines.AESFastEngine;
import org.jruby.org.bouncycastle.crypto.engines.AESWrapEngine;
import org.jruby.org.bouncycastle.crypto.engines.RFC3211WrapEngine;
import org.jruby.org.bouncycastle.crypto.macs.CMac;
import org.jruby.org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.jruby.org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.jruby.org.bouncycastle.crypto.modes.OFBBlockCipher;
import org.jruby.org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jruby.org.bouncycastle.jce.provider.JCEBlockCipher;
import org.jruby.org.bouncycastle.jce.provider.JCEKeyGenerator;
import org.jruby.org.bouncycastle.jce.provider.JCEMac;
import org.jruby.org.bouncycastle.jce.provider.JDKAlgorithmParameterGenerator;
import org.jruby.org.bouncycastle.jce.provider.JDKAlgorithmParameters;
import org.jruby.org.bouncycastle.jce.provider.WrapCipherSpi;

public final class AES {
    private AES() {
    }

    public static class AESCMAC
    extends JCEMac {
        public AESCMAC() {
            super(new CMac(new AESFastEngine()));
        }
    }

    public static class AlgParamGen
    extends JDKAlgorithmParameterGenerator {
        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            throw new InvalidAlgorithmParameterException("No supported AlgorithmParameterSpec for AES parameter generation.");
        }

        protected AlgorithmParameters engineGenerateParameters() {
            AlgorithmParameters algorithmParameters;
            byte[] byArray = new byte[16];
            if (this.random == null) {
                this.random = new SecureRandom();
            }
            this.random.nextBytes(byArray);
            try {
                algorithmParameters = AlgorithmParameters.getInstance("AES", BouncyCastleProvider.PROVIDER_NAME);
                algorithmParameters.init(new IvParameterSpec(byArray));
            }
            catch (Exception exception2) {
                throw new RuntimeException(exception2.getMessage());
            }
            return algorithmParameters;
        }
    }

    public static class AlgParams
    extends JDKAlgorithmParameters.IVAlgorithmParameters {
        protected String engineToString() {
            return "AES IV";
        }
    }

    public static class CBC
    extends JCEBlockCipher {
        public CBC() {
            super(new CBCBlockCipher(new AESFastEngine()), 128);
        }
    }

    public static class CFB
    extends JCEBlockCipher {
        public CFB() {
            super(new BufferedBlockCipher(new CFBBlockCipher(new AESFastEngine(), 128)), 128);
        }
    }

    public static class ECB
    extends JCEBlockCipher {
        public ECB() {
            super(new AESFastEngine());
        }
    }

    public static class KeyGen
    extends JCEKeyGenerator {
        public KeyGen() {
            this(192);
        }

        public KeyGen(int n) {
            super("AES", n, new CipherKeyGenerator());
        }
    }

    public static class KeyGen128
    extends KeyGen {
        public KeyGen128() {
            super(128);
        }
    }

    public static class KeyGen192
    extends KeyGen {
        public KeyGen192() {
            super(192);
        }
    }

    public static class KeyGen256
    extends KeyGen {
        public KeyGen256() {
            super(256);
        }
    }

    public static class Mappings
    extends HashMap {
        private static final String wrongAES128 = "2.16.840.1.101.3.4.2";
        private static final String wrongAES192 = "2.16.840.1.101.3.4.22";
        private static final String wrongAES256 = "2.16.840.1.101.3.4.42";

        public Mappings() {
            this.put("AlgorithmParameters.AES", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$AlgParams");
            this.put("Alg.Alias.AlgorithmParameters.2.16.840.1.101.3.4.2", "AES");
            this.put("Alg.Alias.AlgorithmParameters.2.16.840.1.101.3.4.22", "AES");
            this.put("Alg.Alias.AlgorithmParameters.2.16.840.1.101.3.4.42", "AES");
            this.put("Alg.Alias.AlgorithmParameters." + NISTObjectIdentifiers.id_aes128_CBC, "AES");
            this.put("Alg.Alias.AlgorithmParameters." + NISTObjectIdentifiers.id_aes192_CBC, "AES");
            this.put("Alg.Alias.AlgorithmParameters." + NISTObjectIdentifiers.id_aes256_CBC, "AES");
            this.put("AlgorithmParameterGenerator.AES", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$AlgParamGen");
            this.put("Alg.Alias.AlgorithmParameterGenerator.2.16.840.1.101.3.4.2", "AES");
            this.put("Alg.Alias.AlgorithmParameterGenerator.2.16.840.1.101.3.4.22", "AES");
            this.put("Alg.Alias.AlgorithmParameterGenerator.2.16.840.1.101.3.4.42", "AES");
            this.put("Alg.Alias.AlgorithmParameterGenerator." + NISTObjectIdentifiers.id_aes128_CBC, "AES");
            this.put("Alg.Alias.AlgorithmParameterGenerator." + NISTObjectIdentifiers.id_aes192_CBC, "AES");
            this.put("Alg.Alias.AlgorithmParameterGenerator." + NISTObjectIdentifiers.id_aes256_CBC, "AES");
            this.put("Cipher.AES", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$ECB");
            this.put("Alg.Alias.Cipher.2.16.840.1.101.3.4.2", "AES");
            this.put("Alg.Alias.Cipher.2.16.840.1.101.3.4.22", "AES");
            this.put("Alg.Alias.Cipher.2.16.840.1.101.3.4.42", "AES");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes128_ECB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$ECB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes192_ECB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$ECB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes256_ECB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$ECB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes128_CBC, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$CBC");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes192_CBC, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$CBC");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes256_CBC, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$CBC");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes128_OFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$OFB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes192_OFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$OFB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes256_OFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$OFB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes128_CFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$CFB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes192_CFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$CFB");
            this.put("Cipher." + NISTObjectIdentifiers.id_aes256_CFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$CFB");
            this.put("Cipher.AESWRAP", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$Wrap");
            this.put("Alg.Alias.Cipher." + NISTObjectIdentifiers.id_aes128_wrap, "AESWRAP");
            this.put("Alg.Alias.Cipher." + NISTObjectIdentifiers.id_aes192_wrap, "AESWRAP");
            this.put("Alg.Alias.Cipher." + NISTObjectIdentifiers.id_aes256_wrap, "AESWRAP");
            this.put("Cipher.AESRFC3211WRAP", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$RFC3211Wrap");
            this.put("KeyGenerator.AES", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen");
            this.put("KeyGenerator.2.16.840.1.101.3.4.2", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator.2.16.840.1.101.3.4.22", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator.2.16.840.1.101.3.4.42", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen256");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes128_ECB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes128_CBC, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes128_OFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes128_CFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes192_ECB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes192_CBC, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes192_OFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes192_CFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes256_ECB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen256");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes256_CBC, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen256");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes256_OFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen256");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes256_CFB, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen256");
            this.put("KeyGenerator.AESWRAP", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes128_wrap, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen128");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes192_wrap, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen192");
            this.put("KeyGenerator." + NISTObjectIdentifiers.id_aes256_wrap, "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$KeyGen256");
            this.put("Mac.AESCMAC", "org.jruby.org.bouncycastle.jce.provider.symmetric.AES$AESCMAC");
        }
    }

    public static class OFB
    extends JCEBlockCipher {
        public OFB() {
            super(new BufferedBlockCipher(new OFBBlockCipher(new AESFastEngine(), 128)), 128);
        }
    }

    public static class RFC3211Wrap
    extends WrapCipherSpi {
        public RFC3211Wrap() {
            super(new RFC3211WrapEngine(new AESFastEngine()), 16);
        }
    }

    public static class Wrap
    extends WrapCipherSpi {
        public Wrap() {
            super(new AESWrapEngine());
        }
    }
}

