/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.jce;

import java.io.IOException;
import java.security.cert.CRLException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import org.jruby.org.bouncycastle.asn1.ASN1Object;
import org.jruby.org.bouncycastle.asn1.x509.TBSCertList;
import org.jruby.org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.jruby.org.bouncycastle.jce.X509Principal;

public class PrincipalUtil {
    public static X509Principal getIssuerX509Principal(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Object.fromByteArray(x509Certificate.getTBSCertificate()));
            return new X509Principal(tBSCertificateStructure.getIssuer());
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public static X509Principal getSubjectX509Principal(X509Certificate x509Certificate) throws CertificateEncodingException {
        try {
            TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance(ASN1Object.fromByteArray(x509Certificate.getTBSCertificate()));
            return new X509Principal(tBSCertificateStructure.getSubject());
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    public static X509Principal getIssuerX509Principal(X509CRL x509CRL) throws CRLException {
        try {
            TBSCertList tBSCertList = TBSCertList.getInstance(ASN1Object.fromByteArray(x509CRL.getTBSCertList()));
            return new X509Principal(tBSCertList.getIssuer());
        }
        catch (IOException iOException) {
            throw new CRLException(iOException.toString());
        }
    }
}

