/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.bouncycastle.cms.jcajce;

import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.jruby.org.bouncycastle.asn1.ASN1OctetString;
import org.jruby.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.jruby.org.bouncycastle.cms.CMSException;
import org.jruby.org.bouncycastle.cms.PasswordRecipient;
import org.jruby.org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import org.jruby.org.bouncycastle.jcajce.DefaultJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.NamedJcaJceHelper;
import org.jruby.org.bouncycastle.jcajce.ProviderJcaJceHelper;

public abstract class JcePasswordRecipient
implements PasswordRecipient {
    private int schemeID = 1;
    protected EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceHelper());
    private char[] password;

    JcePasswordRecipient(char[] cArray) {
        this.password = cArray;
    }

    public JcePasswordRecipient setPasswordConversionScheme(int n) {
        this.schemeID = n;
        return this;
    }

    public JcePasswordRecipient setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcePasswordRecipient setProvider(String string2) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceHelper(string2));
        return this;
    }

    protected Key extractSecretKey(AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, byte[] byArray, byte[] byArray2) throws CMSException {
        Cipher cipher2 = this.helper.createRFC3211Wrapper(algorithmIdentifier.getAlgorithm());
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(ASN1OctetString.getInstance(algorithmIdentifier.getParameters()).getOctets());
            cipher2.init(4, (Key)new SecretKeySpec(byArray, cipher2.getAlgorithm()), ivParameterSpec);
            return cipher2.unwrap(byArray2, algorithmIdentifier2.getAlgorithm().getId(), 3);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new CMSException("cannot process content encryption key: " + generalSecurityException.getMessage(), generalSecurityException);
        }
    }

    public int getPasswordConversionScheme() {
        return this.schemeID;
    }

    public char[] getPassword() {
        return this.password;
    }
}

